/*
 * Decompiled with CFR 0.152.
 */
package eyespyfx;

import eyespyfx.LocalizationSupport;
import eyespyfx.PSFX;
import eyespyfx.WaitCanvas;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class HttpGetThread
extends Thread {
    private static final String SENDING = LocalizationSupport.getMessage("SENDING");
    private static final String READING = LocalizationSupport.getMessage("READING");
    private static final String NO_RESPONSE = "No Response";
    private PSFX parent;
    private WaitCanvas display;
    private HttpConnection hc;
    private InputStream in;
    private String url;
    private boolean started;
    private boolean cancelled;
    private boolean running;
    private int operation;
    private boolean show;
    private String response;

    public HttpGetThread(PSFX parent, WaitCanvas display) {
        this.parent = parent;
        this.display = display;
        this.started = true;
    }

    public void cancel() {
        this.cancelled = true;
        this.running = false;
        try {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
            if (this.hc != null) {
                this.hc.close();
                this.hc = null;
            }
        }
        catch (IOException ioe) {
            this.parent.addLogEntry("HttpGetThread Cancel error: " + ioe.getMessage());
        }
    }

    public synchronized void go() {
        this.running = true;
        this.cancelled = false;
        this.notify();
    }

    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readData() {
        if (this.url == null) {
            return null;
        }
        StringBuffer buffer = null;
        String data = null;
        int length = 0;
        int rc = 0;
        try {
            if (this.show) {
                this.display.setMessage(SENDING);
            }
            this.hc = (HttpConnection)Connector.open((String)this.url);
            if (this.hc == null) {
            }
            rc = this.hc.getResponseCode();
            if (rc == 200) {
                length = (int)this.hc.getLength();
                this.in = this.hc.openInputStream();
                if (this.show) {
                    this.display.setMessage(READING);
                }
                if (this.in != null) {
                    buffer = new StringBuffer();
                    if (length == -1) {
                        rc = 0;
                        while ((rc = this.in.read()) != -1) {
                            buffer.append((char)rc);
                        }
                    } else {
                        for (int i = 0; i < length; ++i) {
                            buffer.append((char)this.in.read());
                        }
                    }
                    data = buffer.toString();
                }
            } else {
                if (rc >= 300 && rc <= 307) {
                    this.url = this.hc.getHeaderField("Location");
                    data = "redirect";
                }
                data = null;
                return data;
            }
        }
        catch (IOException ex) {
            this.parent.addLogEntry("HttpGetThread readData error: " + ex.getMessage());
            data = null;
            return data;
        }
        catch (OutOfMemoryError oo) {
            this.parent.addLogEntry("HttpGetThread readData error: " + oo.toString());
            data = null;
            return data;
        }
        finally {
            try {
                if (this.in != null) {
                    this.in.close();
                    this.in = null;
                }
                if (this.hc != null) {
                    this.hc.close();
                    this.hc = null;
                }
            }
            catch (IOException ignored) {
                System.out.println(ignored.getMessage());
            }
            if (buffer == null) return data;
            return data;
        }
    }

    public synchronized void run() {
        while (this.started) {
            try {
                this.parent.addLogEntry("HttpGetThread Waiting...");
                this.running = false;
                this.cancelled = false;
                this.wait();
            }
            catch (InterruptedException ie) {
                this.parent.addLogEntry("HttpGetThread interrupted error: " + ie.getMessage());
            }
            if (!this.started) continue;
            this.response = this.readData();
            if (!this.cancelled) {
                if (this.response != null && this.response.equals("redirect")) {
                    this.response = this.readData();
                }
                this.parent.dataReceviedGet(this.response, this.operation);
                continue;
            }
            this.parent.dataReceviedGet(NO_RESPONSE, this.operation);
        }
    }

    public void setGetOperation(String url, int operation, boolean show) {
        this.url = url;
        this.operation = operation;
        this.show = show;
    }

    public synchronized void stop() {
        this.started = false;
        this.notify();
        if (this.running) {
            this.cancel();
        }
    }
}

