/*
 * Decompiled with CFR 0.152.
 */
package eyespyfx;

import eyespyfx.LocalizationSupport;
import eyespyfx.PSFX;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Cam
extends Canvas {
    private static final String ERROR = LocalizationSupport.getMessage("ERROR");
    private static final String LOADING = LocalizationSupport.getMessage("LOADING");
    private static final String CLOSING = LocalizationSupport.getMessage("CLOSING");
    private static final String SPLASH_PATH = "/splash_app.png";
    private static final String SEP = " | ";
    private PSFX parent;
    private String[] cam_names;
    private int back_colour;
    private int list_back_colour;
    private int list_border_colour;
    private int list_text_colour;
    private int list_text_high_colour;
    private int img_size;
    private int img_back;
    private boolean portrait;
    private boolean loading;
    private boolean closing;
    private Timer timer;
    private TimerTask task;
    private int anim_index;
    private Font f;
    private Font loading_font;
    private Image img;
    private Image splash;
    private int w;
    private int h;
    private int splash_w;
    private int splash_h;
    private int splash_x;
    private int splash_y;
    private int font_h;
    private int img_w;
    private int img_h;
    private int img_x;
    private int img_y;
    private int menu_w;
    private int menu_h;
    private int menu_x;
    private int menu_y1;
    private int menu_y2;
    private int menu_idx;
    private int menu_total;
    private int menu_selected_border_w;
    private int menu_selected_border_h;
    private int menu_selected_border_x;
    private int menu_selected_border_y;
    private int loading_w;
    private int loading_h;
    private int loading_x;
    private int loading_y;
    private int loading_x2;
    private int selected_w;
    private int selected_x;
    private String selected_name;
    private String menu;
    private int selected_idx;
    private int menu_sep_length;
    private StringBuffer buffer;
    private char[] loading_chars;
    private int loading_len;

    public Cam(PSFX parent, String[] cam_names, int back_colour, int fore_colour, int border_colour, int high_back_colour, int high_fore_colour, int img_size, int img_back) {
        this.parent = parent;
        this.cam_names = cam_names;
        this.back_colour = back_colour;
        this.list_back_colour = fore_colour;
        this.list_border_colour = border_colour;
        this.list_text_colour = high_back_colour;
        this.list_text_high_colour = high_fore_colour;
        this.img_size = img_size;
        this.img_back = img_back;
        this.selected_idx = -1;
        this.init();
        this.assignDimensions();
        this.loadSplash();
    }

    private void assignDimensions() {
        this.w = this.getWidth();
        this.h = this.getHeight();
        this.portrait = this.h >= this.w;
        this.parent.addLogEntry("Width: " + this.w);
        this.parent.addLogEntry("Height: " + this.h);
        this.parent.addLogEntry("Portrait: " + this.portrait);
        this.font_h = this.f.getHeight();
        this.menu_w = this.w;
        this.menu_h = this.font_h + 8;
        this.menu_x = this.w / 2;
        this.menu_y1 = this.h - this.menu_h;
        this.menu_y2 = this.h - (this.font_h + 4);
        if (this.cam_names != null) {
            this.menu_idx = this.cam_names.length / 2;
            this.menu_total = this.cam_names.length;
        }
        this.menu_sep_length = this.f.stringWidth(SEP);
        this.menu_selected_border_h = this.menu_h;
        this.menu_selected_border_y = this.menu_y1;
        this.splash_w = this.w;
        this.splash_h = this.h - this.menu_h;
        this.splash_x = this.w / 2;
        this.splash_y = this.splash_h / 2;
        this.loading_w = this.loading_font.stringWidth(LOADING) + 2;
        this.loading_h = this.loading_font.getHeight() + 2;
        this.loading_x = this.w / 2;
        this.loading_y = this.h - this.menu_h * 2 - this.loading_h / 2;
        this.loading_x2 = this.loading_x - this.loading_w / 2;
        this.assignImageDimensions();
    }

    public void assignImageDimensions() {
        this.img_w = 320;
        this.img_h = 240;
        this.img_x = this.w / 2;
        this.img_y = this.h / 2;
    }

    private String buildMenuString() {
        if (this.cam_names != null) {
            this.getStringBuffer();
            int len = 0;
            int i = 1;
            int idx = this.menu_idx;
            this.menu_x = this.w / 2;
            this.selected_w = this.f.stringWidth(this.cam_names[idx]);
            this.menu_x = this.selected_x = this.menu_x - this.selected_w / 2;
            this.menu_selected_border_w = this.selected_w + 2;
            this.menu_selected_border_x = this.selected_x - 2;
            this.buffer.append(this.cam_names[idx]);
            len += this.selected_w;
            if (idx != this.cam_names.length - 1) {
                this.buffer.append(SEP);
                len += this.menu_sep_length;
            }
            while (len < this.w) {
                if (idx - i >= 0) {
                    this.buffer.insert(0, SEP);
                    len += this.menu_sep_length;
                    this.menu_x -= this.menu_sep_length;
                    this.buffer.insert(0, this.cam_names[idx - i]);
                    len += this.f.stringWidth(this.cam_names[idx - i]);
                    this.menu_x -= this.f.stringWidth(this.cam_names[idx - i]);
                }
                if (idx + i < this.menu_total) {
                    this.buffer.append(this.cam_names[idx + i]);
                    len += this.f.stringWidth(this.cam_names[idx + 1]);
                    if (idx + i != this.cam_names.length - 1) {
                        this.buffer.append(SEP);
                        len += this.menu_sep_length;
                    }
                }
                ++i;
            }
            return this.buffer.toString();
        }
        return null;
    }

    public void clearImage() {
        this.img = null;
        this.repaint();
    }

    public int getImageHeight() {
        return this.img_h;
    }

    public int getImageWidth() {
        return this.img_w;
    }

    public int getMenuIndex() {
        return this.menu_idx;
    }

    private void getStringBuffer() {
        if (this.buffer == null) {
            this.buffer = new StringBuffer();
        } else {
            this.buffer.delete(0, this.buffer.capacity());
        }
    }

    private TimerTask getTask() {
        this.task = new TimerTask(){

            public void run() {
                Cam.this.timerStep();
            }
        };
        return this.task;
    }

    private void init() {
        this.f = Font.getFont((int)0, (int)1, (int)8);
        this.loading_font = Font.getFont((int)0, (int)1, (int)0);
        this.loading_chars = LOADING.toCharArray();
        this.loading_len = this.loading_chars.length;
    }

    protected void keyPressed(int keyCode) {
        System.out.println("Key code = " + keyCode);
        switch (this.getGameAction(keyCode)) {
            case 2: {
                --this.menu_idx;
                if (this.menu_idx < 0) {
                    this.menu_idx = 0;
                }
                this.repaint();
                break;
            }
            case 5: {
                ++this.menu_idx;
                if (this.menu_idx >= this.menu_total) {
                    this.menu_idx = this.menu_total - 1;
                }
                this.repaint();
                break;
            }
            case 8: {
                if (this.selected_idx == this.menu_idx) break;
                this.img = null;
                this.parent.addLogEntry("Loading camera: " + this.cam_names[this.menu_idx]);
                this.parent.changeCamera(this.menu_idx);
                this.repaint();
                break;
            }
            case 9: {
                if (this.selected_idx == this.menu_idx) break;
                this.img = null;
                this.parent.addLogEntry("Loading camera: " + this.cam_names[this.menu_idx]);
                this.parent.changeCamera(this.menu_idx);
                this.repaint();
                break;
            }
            case 10: {
                if (this.selected_idx == this.menu_idx) break;
                this.img = null;
                this.parent.addLogEntry("Loading camera: " + this.cam_names[this.menu_idx]);
                this.parent.changeCamera(this.menu_idx);
                this.repaint();
                break;
            }
            case 11: {
                if (this.selected_idx == this.menu_idx) break;
                this.img = null;
                this.parent.addLogEntry("Loading camera: " + this.cam_names[this.menu_idx]);
                this.parent.changeCamera(this.menu_idx);
                this.repaint();
                break;
            }
            case 12: {
                if (this.selected_idx == this.menu_idx) break;
                this.img = null;
                this.parent.addLogEntry("Loading camera: " + this.cam_names[this.menu_idx]);
                this.parent.changeCamera(this.menu_idx);
                this.repaint();
            }
        }
    }

    protected void keyReleased(int keyCode) {
    }

    protected void keyRepeated(int keyCode) {
        switch (this.getGameAction(keyCode)) {
            case 2: {
                --this.menu_idx;
                if (this.menu_idx < 0) {
                    this.menu_idx = 0;
                }
                this.repaint();
                break;
            }
            case 5: {
                ++this.menu_idx;
                if (this.menu_idx >= this.menu_total) {
                    this.menu_idx = this.menu_total - 1;
                }
                this.repaint();
            }
        }
    }

    private void loadSplash() {
        try {
            this.splash = Image.createImage((String)SPLASH_PATH);
            this.splash_w = this.splash.getWidth();
            this.splash_h = this.splash.getHeight();
        }
        catch (IOException ioe) {
            this.splash = null;
            this.parent.addLogEntry(ERROR + "IOException - " + ioe.getMessage());
        }
        catch (OutOfMemoryError oo) {
            this.splash = null;
            this.parent.addLogEntry(ERROR + "Out Of Memory - " + oo.toString());
        }
    }

    public void paint(Graphics g) {
        g.setColor(this.back_colour);
        g.fillRect(0, 0, this.w, this.h);
        this.paintImage(g);
        this.paintMenu(g);
    }

    private void paintClosing(Graphics g) {
        g.setColor(this.list_back_colour);
        g.fillRect(this.loading_x2, this.loading_y, this.loading_w, this.loading_h);
        g.setColor(this.list_border_colour);
        g.drawRect(this.loading_x2, this.loading_y, this.loading_w, this.loading_h);
        g.setColor(this.list_text_high_colour);
        g.drawString(CLOSING, this.loading_x, this.loading_y, 17);
    }

    private void paintImage(Graphics g) {
        try {
            if (this.img != null) {
                g.drawImage(this.img, this.img_x, this.img_y, 3);
            } else {
                if (this.splash != null) {
                    g.drawImage(this.splash, this.splash_x, this.splash_y, 3);
                }
                if (this.loading) {
                    this.paintLoading(g);
                }
            }
            if (this.closing) {
                this.paintClosing(g);
            }
        }
        catch (Throwable t) {
            this.parent.addLogEntry("Error painting image: " + t.getMessage());
            this.parent.addLogEntry(t.toString());
        }
    }

    private void paintLoading(Graphics g) {
        g.setColor(this.list_back_colour);
        g.fillRect(this.loading_x2, this.loading_y, this.loading_w, this.loading_h);
        g.setColor(this.list_border_colour);
        g.drawRect(this.loading_x2, this.loading_y, this.loading_w, this.loading_h);
        g.setColor(this.list_text_high_colour);
        g.drawChars(this.loading_chars, 0, this.anim_index, this.loading_x, this.loading_y, 17);
    }

    private void paintMenu(Graphics g) {
        this.paintMenuBar(g);
        g.setFont(this.f);
        g.setColor(this.list_text_colour);
        this.menu = this.buildMenuString();
        if (this.menu != null) {
            g.drawString(this.menu, this.menu_x, this.menu_y2, 20);
            this.paintMenuSelected(g);
        }
    }

    private void paintMenuBar(Graphics g) {
        g.setColor(this.list_back_colour);
        g.fillRect(0, this.menu_y1, this.menu_w, this.menu_h);
        g.setColor(this.list_border_colour);
        g.fillRect(0, this.h - 2, this.menu_w, 2);
    }

    private void paintMenuSelected(Graphics g) {
        g.setColor(this.list_border_colour);
        g.fillRect(this.menu_selected_border_x, this.menu_selected_border_y, this.menu_selected_border_w, this.menu_selected_border_h);
        g.setColor(this.list_text_high_colour);
        this.selected_name = this.cam_names[this.menu_idx];
        g.drawString(this.selected_name, this.selected_x, this.menu_y2, 20);
    }

    protected void pointerDragged(int x, int y) {
    }

    protected void pointerPressed(int x, int y) {
    }

    protected void pointerReleased(int x, int y) {
        this.parent.addLogEntry("screen pressed x = " + x + ", y = " + y);
        int x1 = this.menu_selected_border_x;
        int x2 = this.menu_selected_border_x + this.menu_selected_border_w;
        int y1 = this.menu_selected_border_y;
        int y2 = this.menu_selected_border_y + this.menu_selected_border_h;
        if (x >= x1 && x <= x2) {
            if (y >= y1 && y <= y2 && this.selected_idx != this.menu_idx) {
                this.img = null;
                this.parent.addLogEntry("Loading camera: " + this.cam_names[this.menu_idx]);
                this.parent.changeCamera(this.menu_idx);
                this.repaint();
            }
        } else if (x < x1) {
            if (y >= y1 && y <= y2) {
                --this.menu_idx;
                if (this.menu_idx < 0) {
                    this.menu_idx = 0;
                }
                this.repaint();
            }
        } else if (x > x2 && y >= y1 && y <= y2) {
            ++this.menu_idx;
            if (this.menu_idx >= this.menu_total) {
                this.menu_idx = this.menu_total - 1;
            }
            this.repaint();
        }
    }

    public void setClosing(boolean closing) {
        this.closing = closing;
        this.repaint();
    }

    public void setImageSize(int img_size) {
        this.img_size = img_size;
        this.assignImageDimensions();
        this.repaint();
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
        this.repaint();
        if (loading) {
            this.startAnimation();
        } else {
            this.stopAnimation();
        }
    }

    protected void sizeChanged(int arg0, int arg1) {
        super.sizeChanged(arg0, arg1);
        this.assignDimensions();
        this.assignImageDimensions();
    }

    public void startAnimation() {
        System.out.println("startAnimation called");
        this.anim_index = 0;
        this.timer = new Timer();
        this.timer.schedule(this.getTask(), 0L, 150L);
    }

    public void stopAnimation() {
        System.out.println("stopAnimation called");
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void timerStep() {
        ++this.anim_index;
        if (this.anim_index >= this.loading_len) {
            this.anim_index = 0;
        }
        this.repaint();
    }

    public void updateImage(Image img) {
        this.img = img;
        if (img != null) {
            if (this.loading) {
                this.setLoading(false);
            }
            if (this.img_h != img.getHeight()) {
                this.img_h = img.getHeight();
            }
            if (this.img_w != img.getWidth()) {
                this.img_w = img.getWidth();
            }
        }
        this.repaint();
    }
}

