/*
 * Decompiled with CFR 0.152.
 */
package eyespyfx;

import eyespyfx.PSFX;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class ImageThread
extends Thread {
    private PSFX parent;
    private String url;
    private HttpConnection hc;
    private DataInputStream in;
    private StringBuffer url_builder;
    private ByteArrayOutputStream out = null;
    private String query;
    private byte[] img_data;
    private boolean started;
    private boolean cancelled;
    private boolean running;
    private boolean redirect;
    private boolean is_image;
    private int error_count;

    public ImageThread(PSFX parent, String url) {
        this.parent = parent;
        this.url = url;
        this.started = true;
    }

    private String buildURL() {
        if (this.url_builder == null) {
            this.url_builder = new StringBuffer();
        } else {
            this.url_builder.delete(0, this.url_builder.capacity());
        }
        this.url_builder.append(this.url);
        this.url_builder.append('?');
        this.url_builder.append(this.query);
        return this.url_builder.toString();
    }

    public void cancel() {
        this.cancelled = true;
        this.running = false;
        try {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
            if (this.hc != null) {
                this.hc.close();
                this.hc = null;
            }
        }
        catch (IOException ioe) {
            this.parent.addLogEntry("ImageThread Cancel error: " + ioe.getMessage());
        }
    }

    private void changeImageURL() {
        int tomcat_present = this.url.indexOf(":8080");
        if (tomcat_present != -1) {
            this.url = "http://www.eyespyfx.mobi/j2me2/snapshot.php";
        }
    }

    public synchronized void go() {
        this.running = true;
        this.notify();
    }

    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] readImageData() {
        if (this.url == null || this.query == null) {
            ++this.error_count;
            return null;
        }
        byte[] buffer = null;
        int length = 0;
        int rc = 0;
        String type = null;
        try {
            this.hc = (HttpConnection)Connector.open((String)this.buildURL());
            if (this.hc == null) {
            }
            rc = this.hc.getResponseCode();
            if (rc == 200) {
                length = (int)this.hc.getLength();
                type = this.hc.getType();
                this.in = this.hc.openDataInputStream();
                rc = type.indexOf("image");
                if (rc != -1) {
                    this.is_image = true;
                }
                if (this.in != null) {
                    if (length != -1) {
                        buffer = new byte[length];
                        this.in.readFully(buffer, 0, buffer.length);
                    }
                    if (this.out == null) {
                        this.out = new ByteArrayOutputStream();
                    }
                    buffer = new byte[1024];
                    rc = 0;
                    while (true) {
                        if ((rc = this.in.read(buffer)) == -1) {
                            buffer = null;
                            buffer = this.out.toByteArray();
                        }
                        this.out.write(buffer, 0, rc);
                    }
                }
            } else {
                if (rc >= 300 && rc <= 307) {
                    this.url = this.hc.getHeaderField("Location");
                    this.redirect = true;
                    buffer = null;
                    ++this.error_count;
                }
                this.changeImageURL();
                this.redirect = true;
                buffer = null;
                ++this.error_count;
                return this.error_count;
            }
        }
        catch (IOException ex) {
            this.parent.addLogEntry("ImageDownloadThread readData error: " + ex.getMessage());
            buffer = null;
            ++this.error_count;
            return this.error_count;
        }
        catch (OutOfMemoryError oo) {
            this.parent.addLogEntry("ImageDownloadThread readData error: " + oo.toString());
            buffer = null;
            ++this.error_count;
            return this.error_count;
        }
        finally {
            try {
                if (this.out != null) {
                    this.out.reset();
                }
                if (this.in != null) {
                    this.in.close();
                    this.in = null;
                }
                if (this.hc == null) return buffer;
                this.hc.close();
                this.hc = null;
                return buffer;
            }
            catch (IOException ignored) {
                System.out.println(ignored.getMessage());
            }
            return buffer;
        }
    }

    public synchronized void run() {
        while (this.started) {
            try {
                this.parent.addLogEntry("ImageThread Waiting...");
                this.cancelled = false;
                this.running = false;
                this.error_count = 0;
                this.wait();
            }
            catch (InterruptedException ie) {
                this.parent.addLogEntry("ImageThread interrupted error: " + ie.getMessage());
            }
            if (!this.started) continue;
            while (this.running) {
                this.img_data = this.readImageData();
                if (!this.cancelled) {
                    if (this.redirect) {
                        this.img_data = this.readImageData();
                    }
                    if (this.img_data != null && this.is_image) {
                        this.parent.updateImageData(this.img_data);
                    }
                }
                this.img_data = null;
                if (this.error_count <= 5) continue;
                this.running = false;
                this.parent.addLogEntry("Too many errors: " + this.error_count);
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException ignore) {
                System.err.println(ignore.getMessage());
            }
            this.out = null;
        }
    }

    public void setImageURL(String url) {
        this.url = url;
    }

    public void setImageQueryString(String query) {
        this.query = query;
    }

    public synchronized void stop() {
        this.started = false;
        this.notify();
        if (this.running) {
            this.cancel();
        }
    }
}

