/*
 * Decompiled with CFR 0.152.
 */
package eyespyfx;

import eyespyfx.Cam;
import eyespyfx.HttpGetThread;
import eyespyfx.ImageThread;
import eyespyfx.LocalizationSupport;
import eyespyfx.Properties;
import eyespyfx.Splash;
import eyespyfx.Tools;
import eyespyfx.WaitCanvas;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Spacer;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;

public class PSFX
extends MIDlet
implements CommandListener {
    private static final String TITLE = Properties.getProperty("TITLE");
    private static final String ERROR = LocalizationSupport.getMessage("ERROR2");
    private static final String NO_RESPONSE = "No Response";
    private static final String HELP = LocalizationSupport.getMessage("HELP");
    private static final String ABOUT = LocalizationSupport.getMessage("ABOUT");
    private static final String EXIT = LocalizationSupport.getMessage("EXIT");
    private static final String BACK = LocalizationSupport.getMessage("BACK");
    private static final String SELECT = LocalizationSupport.getMessage("SELECT");
    private static final String CANCEL = LocalizationSupport.getMessage("CANCEL");
    private static final Command CMD_HELP = new Command(HELP, 1, 2);
    private static final Command CMD_ABOUT = new Command(ABOUT, 1, 3);
    private static final Command CMD_EXIT = new Command(EXIT, 2, 4);
    private static final Command CMD_BACK = new Command(BACK, 2, 2);
    private static final Command CMD_SELECT = new Command(SELECT, 1, 1);
    private static final Command CMD_CANCEL = new Command(CANCEL, 3, 1);
    private static final Command CMD_LOG = new Command("Log", 1, 5);
    private static final Command CMD_CLEAR = new Command("Clear", 1, 1);
    private static final String JAD1 = "MIDlet-Version";
    private static final String LOCALE = "microedition.locale";
    private static final String SEP = ",";
    private static final String SEP2 = "|";
    private static final String HELP_TEXT = LocalizationSupport.getMessage("HELP_TEXT");
    private static final String ABOUT_US = LocalizationSupport.getMessage("ABOUT_US");
    private static final String COPYRIGHT1 = LocalizationSupport.getMessage("COPYRIGHT1");
    private static final String COPYRIGHT2 = LocalizationSupport.getMessage("COPYRIGHT2");
    private static final String VERSION = LocalizationSupport.getMessage("VERSION");
    private static final String COLON = ": ";
    private Display disp;
    private StringBuffer log;
    private HttpGetThread get_thread;
    private int back_colour;
    private int fore_colour;
    private int border_colour;
    private int high_fore_colour;
    private int high_back_colour;
    private WaitCanvas wait_canvas;
    private String[] menu;
    private Displayable lastDisplay;
    private boolean started;
    private String locale;
    private Splash splash;
    private ImageThread img_thread;
    private Cam cam_canvas;
    private Image img;
    private int num_cams;
    private String[] cam_names;
    private String[] cam_urls;
    private Form frm_about;
    private String version;
    private Alert alert;
    private int idx_image;
    private Form frm_help;
    private Form frm_log;

    public void startApp() {
        if (this.disp == null) {
            this.disp = Display.getDisplay((MIDlet)this);
            this.back_colour = Integer.parseInt(Properties.getProperty("CANVAS_BACKGROUND"), 16);
            this.fore_colour = Integer.parseInt(Properties.getProperty("CANVAS_CAM_LIST"), 16);
            this.border_colour = Integer.parseInt(Properties.getProperty("CANVAS_CAM_LIST_HIGHLIGHT"), 16);
            this.high_fore_colour = Integer.parseInt(Properties.getProperty("CANVAS_CAM_LIST_TEXT_HIGH"), 16);
            this.high_back_colour = Integer.parseInt(Properties.getProperty("CANVAS_CAM_LIST_TEXT"), 16);
        }
        if (this.get_thread == null) {
            this.get_thread = new HttpGetThread(this, this.getWaitCanvas());
            this.get_thread.start();
        }
        if (this.img_thread == null) {
            this.img_thread = new ImageThread(this, Properties.getProperty("IMAGE_URL"));
            this.img_thread.start();
        }
        if (this.version == null) {
            this.version = this.getAppProperty(JAD1);
        }
        if (this.locale == null) {
            this.locale = System.getProperty(LOCALE);
        }
        this.idx_image = 0;
        if (!this.started) {
            this.started = true;
            this.disp.setCurrent((Displayable)this.getSplash());
        } else {
            this.disp.setCurrent((Displayable)this.getMain());
        }
    }

    public void pauseApp() {
        this.addLogEntry("Application paused.");
        this.stopGetThread(false);
        this.stopImageThread(false);
    }

    public void destroyApp(boolean unconditional) {
    }

    public void commandAction(Command c, Displayable d) {
        if (c == CMD_EXIT) {
            this.quit();
        } else if (c == CMD_CANCEL) {
            this.stopGetThread(false);
            if (this.lastDisplay != null) {
                this.disp.setCurrent(this.lastDisplay);
            } else {
                this.quit();
            }
        } else if (c == CMD_BACK) {
            this.disp.setCurrent((Displayable)this.getMain());
        } else if (c == CMD_HELP) {
            this.disp.setCurrent((Displayable)this.getHelp());
        } else if (c == CMD_ABOUT) {
            this.disp.setCurrent((Displayable)this.getAbout());
        } else if (c == CMD_LOG) {
            this.disp.setCurrent((Displayable)this.getLog());
        } else if (c == CMD_SELECT) {
            System.out.println("CMD Select is pressed");
            this.cam_canvas.clearImage();
            this.changeCamera(this.cam_canvas.getMenuIndex());
        } else if (c == CMD_CLEAR) {
            this.log.delete(0, this.log.capacity());
            this.disp.setCurrent((Displayable)this.getMain());
        } else {
            this.addLogEntry("Unrecognised command.");
        }
    }

    public void addLogEntry(String entry) {
        if (this.log == null) {
            this.log = new StringBuffer();
        }
        try {
            this.log.append(entry);
            this.log.append("\r\n");
        }
        catch (OutOfMemoryError oo) {
            System.err.println(oo.toString());
            this.log = null;
        }
        entry = null;
    }

    public void changeCamera(int idx) {
        if (this.img_thread != null) {
            this.stopImageThread(false);
            this.cam_canvas.setLoading(false);
            this.cam_canvas.assignImageDimensions();
            String[] keys = new String[]{"width", "height"};
            String[] vals = new String[]{Integer.toString(this.cam_canvas.getImageWidth()), Integer.toString(this.cam_canvas.getImageHeight())};
            String query = this.cam_urls[idx] + Tools.buildQueryPart(keys, vals);
            this.img_thread.setImageQueryString(query);
            this.cam_canvas.setLoading(true);
            this.img_thread.go();
        }
    }

    public void dataReceviedGet(String response, int operation) {
        if (response != null && !response.equals(NO_RESPONSE)) {
            String[] parsed_response = null;
            switch (operation) {
                case 1: {
                    parsed_response = Tools.split(response, SEP2, 1);
                    this.num_cams = Tools.parseIntString(parsed_response[1], 0);
                    System.out.println("Number of cams = " + this.num_cams);
                    if (this.num_cams > 0) {
                        this.cam_names = new String[this.num_cams];
                        this.cam_urls = new String[this.num_cams];
                        String[] temp = null;
                        int k = 0;
                        for (int i = 2; i < parsed_response.length - 1; ++i) {
                            temp = Tools.split(parsed_response[i], SEP, 1);
                            this.cam_names[k] = temp[0];
                            this.cam_urls[k] = temp[1];
                            ++k;
                        }
                        temp = null;
                        this.disp.setCurrent((Displayable)this.getMain());
                    } else {
                        this.showAlert(ERROR, "Error loading cams. Please try again.", AlertType.ERROR, 0, (Displayable)this.getMain(), false);
                    }
                    Object var3_3 = null;
                }
            }
        } else if (response != null && response.equals(NO_RESPONSE)) {
            this.disp.setCurrent((Displayable)this.getMain());
        } else {
            this.showAlert(ERROR, "Error loading cameras cannot connect to Internet. The software must now shut down please try again.", AlertType.ERROR, -2, null, true);
        }
    }

    public void executeGetRequest(String url, int operation, boolean show) {
        if (this.get_thread != null) {
            if (url != null) {
                this.get_thread.setGetOperation(url, operation, show);
            }
            this.get_thread.go();
            if (show) {
                this.disp.setCurrent((Displayable)this.getWaitCanvas());
            }
        }
    }

    public void exitSplash() {
        if (this.locale != null) {
            this.executeGetRequest(Properties.getProperty("LIST_URL") + "?locale=" + this.locale, 1, true);
        } else {
            this.executeGetRequest(Properties.getProperty("LIST_URL"), 1, true);
        }
    }

    private Form getAbout() {
        if (this.frm_about == null) {
            this.frm_about = new Form(TITLE);
            this.frm_about.addCommand(CMD_BACK);
            this.frm_about.setCommandListener((CommandListener)this);
            Spacer s = new Spacer(1, 5);
            s.setLayout(16897);
            Spacer s2 = new Spacer(1, 5);
            s2.setLayout(16897);
            StringItem about1 = new StringItem(TITLE + COLON, ABOUT_US);
            about1.setLayout(16897);
            StringItem about2 = new StringItem(COPYRIGHT1, COPYRIGHT2);
            about2.setLayout(16897);
            StringItem about3 = new StringItem(VERSION, this.version);
            about3.setLayout(16897);
            this.frm_about.append((Item)about1);
            this.frm_about.append((Item)s);
            this.frm_about.append((Item)about2);
            this.frm_about.append((Item)s2);
            this.frm_about.append((Item)about3);
        }
        return this.frm_about;
    }

    private Form getHelp() {
        if (this.frm_help == null) {
            this.frm_help = new Form(TITLE);
            this.frm_help.addCommand(CMD_BACK);
            this.frm_help.setCommandListener((CommandListener)this);
            this.frm_help.append(HELP_TEXT);
        }
        return this.frm_help;
    }

    private Form getLog() {
        if (this.frm_log == null) {
            this.frm_log = new Form(TITLE);
            this.frm_log.addCommand(CMD_CLEAR);
            this.frm_log.addCommand(CMD_BACK);
            this.frm_log.setCommandListener((CommandListener)this);
        } else {
            this.frm_log.deleteAll();
        }
        this.frm_log.append(this.log.toString());
        return this.frm_log;
    }

    private Canvas getMain() {
        if (this.cam_canvas == null) {
            this.cam_canvas = new Cam(this, this.cam_names, this.back_colour, this.fore_colour, this.border_colour, this.high_back_colour, this.high_fore_colour, this.idx_image, Tools.parseIntString(Properties.getProperty("SPLASH_BACK"), 16));
            this.cam_canvas.addCommand(CMD_HELP);
            this.cam_canvas.addCommand(CMD_ABOUT);
            this.cam_canvas.addCommand(CMD_EXIT);
            this.cam_canvas.setCommandListener(this);
        }
        return this.cam_canvas;
    }

    private Splash getSplash() {
        if (this.splash == null) {
            this.splash = new Splash(this, Tools.parseIntString(Properties.getProperty("SPLASH_BACK"), 16), Tools.parseIntString(Properties.getProperty("SPLASH_FORE"), 16));
        }
        return this.splash;
    }

    private WaitCanvas getWaitCanvas() {
        if (this.wait_canvas == null) {
            this.wait_canvas = new WaitCanvas(this.high_back_colour, this.back_colour);
            this.wait_canvas.addCommand(CMD_CANCEL);
            this.wait_canvas.setCommandListener(this);
        }
        return this.wait_canvas;
    }

    public void quit() {
        if (this.cam_canvas != null) {
            this.cam_canvas.setLoading(false);
            this.cam_canvas.setClosing(true);
        }
        this.stopGetThread(true);
        this.stopImageThread(true);
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void showAlert(String title, String msg, AlertType type, int timeout, Displayable d, boolean exit) {
        try {
            if (this.alert == null) {
                this.alert = new Alert(title, msg, null, type);
                this.alert.setTimeout(timeout);
            } else {
                this.alert.setTitle(title);
                this.alert.setString(msg);
                this.alert.setTimeout(timeout);
                this.alert.setType(type);
            }
            if (exit) {
                this.alert.setCommandListener((CommandListener)this);
                this.alert.addCommand(CMD_EXIT);
            }
            if (d != null) {
                this.disp.setCurrent(this.alert, d);
            } else {
                this.disp.setCurrent(this.alert, this.disp.getCurrent());
            }
        }
        catch (IllegalArgumentException ie) {
            System.out.println("IllegalArgumentException: " + ie.getMessage());
            this.quit();
        }
    }

    private void stopGetThread(boolean finish) {
        if (this.get_thread != null) {
            if (this.get_thread.isRunning()) {
                this.get_thread.cancel();
            }
            if (finish) {
                this.get_thread.stop();
                this.get_thread = null;
            }
        }
    }

    private void stopImageThread(boolean finish) {
        if (this.img_thread != null) {
            if (this.img_thread.isRunning()) {
                this.img_thread.cancel();
            }
            if (finish) {
                this.img_thread.stop();
                this.img_thread = null;
            }
        }
    }

    public void updateImageData(byte[] img_data) {
        if (img_data != null) {
            if (this.img != null) {
                this.img = null;
                System.gc();
            }
            try {
                this.img = Image.createImage((byte[])img_data, (int)0, (int)img_data.length);
            }
            catch (Throwable t) {
                this.addLogEntry("Error updating image: " + t.getMessage());
                this.img = null;
            }
            this.cam_canvas.updateImage(this.img);
        }
    }
}

