/*
 * Decompiled with CFR 0.152.
 */
package eyespyfx;

import java.util.Vector;
import javax.microedition.lcdui.Image;

public class Tools {
    public static final String buildQuery(String[] keys, String[] vals) {
        StringBuffer post = new StringBuffer();
        post.append('?');
        for (int i = 0; i < keys.length; ++i) {
            post.append(keys[i]);
            post.append('=');
            post.append(vals[i]);
            if (i == keys.length - 1) continue;
            post.append('&');
        }
        return post.toString();
    }

    public static final String buildQueryPart(String[] keys, String[] vals) {
        StringBuffer post = new StringBuffer();
        for (int i = 0; i < keys.length; ++i) {
            post.append('&');
            post.append(keys[i]);
            post.append('=');
            post.append(vals[i]);
        }
        return post.toString();
    }

    public static final boolean checkArray(String[] vals) {
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] != null && !vals[i].equals("")) continue;
            return false;
        }
        return true;
    }

    public static final Image getResizedByHeightImage(Image image, int src_w, int src_h, int h) {
        int width = h * (src_h / src_w);
        int height = h;
        return Tools.getThumbnail(image, src_w, src_h, width, height);
    }

    public static final Image getResizedByWidthImage(Image image, int src_w, int src_h, int w) {
        int width = w;
        int height = w * (src_h / src_w);
        return Tools.getThumbnail(image, src_w, src_h, width, height);
    }

    public static final Image getThumbnailWrapper(Image image, int sourceWidth, int sourceHeight, int expectedWidth, int expectedHeight, int padding) throws OutOfMemoryError {
        int thumbWidth = -1;
        int thumbHeight = -1;
        if (sourceWidth >= sourceHeight) {
            thumbWidth = expectedWidth - padding;
            thumbHeight = thumbWidth * sourceHeight / sourceWidth;
            if (thumbHeight > expectedHeight - padding) {
                thumbHeight = expectedHeight - padding;
                thumbWidth = thumbHeight * sourceWidth / sourceHeight;
            }
        } else {
            thumbHeight = expectedHeight - padding;
            thumbWidth = thumbHeight * sourceWidth / sourceHeight;
            if (thumbWidth > expectedWidth - padding) {
                thumbWidth = expectedWidth - padding;
                thumbHeight = thumbWidth * sourceHeight / sourceWidth;
            }
        }
        thumbHeight = sourceHeight < thumbHeight ? sourceHeight : thumbHeight;
        thumbWidth = sourceWidth < thumbWidth ? sourceWidth : thumbWidth;
        return Tools.getThumbnail(image, sourceWidth, sourceHeight, thumbWidth, thumbHeight);
    }

    private static final Image getThumbnail(Image image, int sourceWidth, int sourceHeight, int thumbWidth, int thumbHeight) throws OutOfMemoryError {
        if (image != null) {
            int tmp;
            int x;
            int z = 0;
            int ratio = sourceWidth / thumbWidth;
            int[] in = new int[sourceWidth];
            int[] out = new int[thumbWidth * thumbHeight];
            int[] cols = new int[thumbWidth];
            int pos = 0;
            for (x = 0; x < thumbWidth; ++x) {
                cols[x] = pos;
                tmp = (pos += ratio) + (thumbWidth - x) * ratio;
                if (tmp > sourceWidth) {
                    --pos;
                    continue;
                }
                if (tmp >= sourceWidth - ratio) continue;
                ++pos;
            }
            pos = 0;
            z = 0;
            for (int y = 0; y < thumbHeight; ++y) {
                image.getRGB(in, 0, sourceWidth, 0, pos, sourceWidth, 1);
                x = 0;
                while (x < thumbWidth) {
                    out[z] = in[cols[x]];
                    ++x;
                    ++z;
                }
                tmp = (pos += ratio) + (thumbHeight - y) * ratio;
                if (tmp > sourceHeight) {
                    --pos;
                    continue;
                }
                if (tmp >= sourceHeight - ratio) continue;
                ++pos;
            }
            return Image.createRGBImage((int[])out, (int)thumbWidth, (int)thumbHeight, (boolean)false);
        }
        return null;
    }

    public static final int parseIntString(String i, int radix) {
        int retval = -1;
        if (i != null) {
            try {
                retval = radix == 0 ? Integer.parseInt(i) : Integer.parseInt(i, radix);
            }
            catch (NumberFormatException ex) {
                System.out.println(ex.getMessage());
                retval = -1;
            }
        }
        return retval;
    }

    public static final int[] splitInts(String message, String deliminator, int dlen) {
        if (message == null || deliminator == null || dlen == 0) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        int index1 = 0;
        int index2 = 0;
        while (index1 <= message.length()) {
            index2 = message.indexOf(deliminator, index1);
            if (index2 < 0) {
                index2 = message.length();
            }
            String sub = message.substring(index1, index2);
            index1 = index2 + dlen;
            v.addElement(sub.trim());
        }
        v.trimToSize();
        int[] resp = new int[v.size()];
        for (int i = 0; i < resp.length; ++i) {
            resp[i] = Tools.parseIntString((String)v.elementAt(i), 0);
        }
        v = null;
        return resp;
    }

    public static String[] split(String message, String deliminator, int dlen) {
        if (message == null || deliminator == null || dlen == 0) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        int index1 = 0;
        int index2 = 0;
        while (index1 <= message.length()) {
            index2 = message.indexOf(deliminator, index1);
            if (index2 < 0) {
                index2 = message.length();
            }
            String sub = message.substring(index1, index2);
            index1 = index2 + dlen;
            v.addElement(sub.trim());
        }
        v.trimToSize();
        String[] resp = new String[v.size()];
        for (int i = 0; i < resp.length; ++i) {
            resp[i] = (String)v.elementAt(i);
        }
        v = null;
        return resp;
    }
}

