/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;

public class KitSound {
    public static final int SFX_MENU = 0;
    public static final int SFX_GOOD = 2;
    public static final int SFX_BAD = 3;
    public static final int SFX_BARS_SLICE = 4;
    public static final int SFX_WIN = 5;
    public static final int SFX_LOOSE = 6;
    public static Player[] sounds;
    public static int[] loadedSoundsId;
    public static int currentSound;
    public static boolean loopSound;
    public static int lastDeleted;
    public static long sleepTime;

    public KitSound() {
        sounds = new Player[4];
        loadedSoundsId = new int[4];
        for (int i = 0; i < loadedSoundsId.length; ++i) {
            KitSound.loadedSoundsId[i] = -1;
        }
        currentSound = -1;
        sleepTime = System.currentTimeMillis();
    }

    public int loadSound(int n) {
        int n2;
        int n3 = -1;
        for (n2 = 0; n2 < loadedSoundsId.length; ++n2) {
            if (loadedSoundsId[n2] != n) continue;
            return n2;
        }
        for (n2 = 0; n2 < loadedSoundsId.length && n3 == -1; ++n2) {
            if (loadedSoundsId[n2] != -1) continue;
            n3 = n2;
        }
        if (n3 == -1) {
            try {
                KitSound.a(lastDeleted);
                n3 = lastDeleted++;
                if (lastDeleted == 4) {
                    lastDeleted = 0;
                }
            }
            catch (Exception exception) {
                return -1;
            }
        }
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("/" + this.getSoundString(n));
            KitSound.sounds[n3] = Manager.createPlayer((InputStream)inputStream, (String)"audio/midi");
            KitSound.loadedSoundsId[n3] = n;
            return n3;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public void unloadSoundId(int n) {
        if (loadedSoundsId == null) {
            return;
        }
        for (int i = 0; i < loadedSoundsId.length; ++i) {
            if (loadedSoundsId[i] != n) continue;
            KitSound.a(i);
        }
    }

    private static void a(int n) {
        try {
            if (sounds[n] == null) {
                return;
            }
            if (sounds[n].getState() == 400) {
                sounds[n].stop();
            }
            sounds[n].close();
            KitSound.sounds[n] = null;
            KitSound.loadedSoundsId[n] = -1;
            return;
        }
        catch (MediaException mediaException) {
            MediaException mediaException2 = mediaException;
            mediaException.printStackTrace();
            return;
        }
    }

    public void unloadAll() {
        for (int i = 0; i < loadedSoundsId.length; ++i) {
            if (loadedSoundsId[i] == -1) continue;
            KitSound.a(i);
        }
        currentSound = -1;
        System.gc();
    }

    public void playSound(int n, boolean bl) {
        if (!MainManager.SoundOn) {
            return;
        }
        loopSound = bl;
        bl = false;
        int n2 = 0;
        for (int i = 0; i < loadedSoundsId.length && !bl; ++i) {
            if (loadedSoundsId[i] != n) continue;
            bl = true;
            n2 = i;
        }
        if (!bl) {
            n2 = this.loadSound(n);
        }
        currentSound = n2;
    }

    public void stopSounds() {
        for (int i = 0; i < sounds.length; ++i) {
            if (sounds[i] != null) {
                try {
                    if (sounds[i].getState() != 400) continue;
                    sounds[i].stop();
                    sounds[i].deallocate();
                    sounds[i].deallocate();
                }
                catch (MediaException mediaException) {
                    MediaException mediaException2 = mediaException;
                    mediaException.printStackTrace();
                }
                continue;
            }
            KitSound.loadedSoundsId[i] = -1;
        }
        currentSound = -1;
    }

    public void start() {
        if (System.currentTimeMillis() - sleepTime < 200L && currentSound == -1) {
            return;
        }
        sleepTime = System.currentTimeMillis();
        try {
            if (currentSound == -1) {
                for (int i = 0; i < sounds.length; ++i) {
                    if (sounds[i] == null || sounds[i].getState() != 300) continue;
                    sounds[i].deallocate();
                }
                return;
            }
            for (int i = 0; i < sounds.length; ++i) {
                if (sounds[i] == null) continue;
                try {
                    if (sounds[i].getState() != 400 || loopSound && (!loopSound || i == currentSound)) continue;
                    sounds[i].stop();
                    sounds[i].deallocate();
                    sounds[i].deallocate();
                    continue;
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    exception.printStackTrace();
                }
            }
            if (!loopSound || sounds[currentSound].getState() == 400) {
                if (!loopSound) {
                    if (sounds[currentSound].getState() == 400) {
                        sounds[currentSound].stop();
                        sounds[currentSound].deallocate();
                        sounds[currentSound].deallocate();
                    }
                    sounds[currentSound].start();
                    currentSound = -1;
                }
                return;
            }
            sounds[currentSound].start();
        }
        catch (MediaException mediaException) {
            Object object = mediaException;
            mediaException.printStackTrace();
        }
    }

    public String getSoundString(int n) {
        switch (n) {
            case 0: {
                return "sonid_menu.mid";
            }
            case 5: {
                return "Ganas.mid";
            }
            case 6: {
                return "pierdes.mid";
            }
            case 2: {
                return "acierto.mid";
            }
            case 3: {
                return "fracaso.mid";
            }
            case 4: {
                return "barras.mid";
            }
        }
        return null;
    }

    static {
        loopSound = false;
        lastDeleted = 0;
    }
}

