/*
 * Decompiled with CFR 0.152.
 */
package com.softgames.farmninja;

import com.kiwavi.mobileutils.MobileUtils;
import com.softgames.farmninja.BGSplashEffects;
import com.softgames.farmninja.FMNFruitImage;
import com.softgames.farmninja.FarmNinjaMidlet;
import com.softgames.farmninja.PointI;
import com.softgames.farmninja.RectI;
import com.softgames.farmninja.SPSplashEffects;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

class FMNPlayScreen
extends GameCanvas
implements Runnable,
PlayerListener {
    FarmNinjaMidlet app;
    Image img_background;
    Image img_lifewhole;
    Image img_lifeempty;
    Image[] img_lives = new Image[3];
    int width;
    int height;
    Font largeFont;
    Font mediumFont;
    Font smallFont;
    String txtScoreIndicator = "SCORE: ";
    String txtHighScore = "HighScore:";
    Image[] img_animfruit;
    Image imgshadow;
    Vector fruitList = new Vector();
    int[] fruit_nums = new int[]{1, 4, 7, 2, 5, 8, 3, 6, 9};
    Image[] img_bgsplash;
    Image[] img_dotssplash;
    Image collideImage;
    int porigx;
    int porigy;
    int SWORD_CUT = 0;
    int FRUIT_SMASH = 1;
    int POISON_SPILL = 2;
    int BUZZER_SOUND = 3;
    int drorigx;
    int drorigy;
    int drendx;
    int drendy;
    int cutdx;
    int cutdy;
    boolean cutting = false;
    boolean dragging = false;
    Vector bg_splashEffects = new Vector();
    Vector sp_splashEffects = new Vector();
    Player[] game_sounds = new Player[5];
    boolean touchscreen = false;
    RectI[] riFruits;
    PointI[] cutPoints;
    int drcutcount = 0;
    int drlinecount = 0;
    Vector vctCutFruits = new Vector();
    int numfruits = 1;
    int score = 0;
    int cutcount = 0;
    int combotimecount = 0;
    int combocount;
    int gamelives = 3;
    int PRAISE_POINTS = 1;
    int PRAISE_IN_A_ROW = 2;
    int PRAISE_NICE = 3;
    int PRAISE_WOW = 4;
    int PRAISE_SLICER = 5;
    int PRAISE_AWESOME = 6;
    int PRAISE_GOD = 7;
    int PRAISE_FN = 8;
    int praisecount = 0;
    int praisetimecount = 0;
    int praise_index = 0;
    int slowmocount = 0;
    int slowmotimecount = 0;
    String txtSlowMoText = "SLOW MOTION !";
    String txtComboPoints = "COMBO POINTS";
    String[] txt_gametexts = new String[]{"COMBO", "POINTS", "IN A ROW !!", "NICE !", "WOW !", "SLICER !", "AWESOME !", "GOD !", "FARM NINJA !"};
    int time_fruitinterval = 3000;
    int time_fruitintervalcum = 3200;
    int minveloc = 40;
    int maxveloc = 0;
    double anglemin = 67.0;
    double anglemax = 87.0;
    double fruit_fly_interval = 0.3;
    boolean endgame = false;
    boolean pausegame = false;
    boolean drawing = false;
    int endgameoption = 0;
    String txtPlayAgain = "PLAY AGAIN";
    String txtGotoMenu = "MAIN MENU";
    String txtGameOver = "GAME OVER";
    Random globalRandom;

    FMNPlayScreen(FarmNinjaMidlet app) {
        super(false);
        this.setFullScreenMode(true);
        this.app = app;
        this.largeFont = Font.getFont((int)64, (int)1, (int)16);
        this.mediumFont = Font.getFont((int)64, (int)1, (int)0);
        this.smallFont = Font.getFont((int)64, (int)1, (int)8);
        System.gc();
        try {
            String[] gameTexts = app.gameText.getGameText(app.getLanguage());
            this.txtScoreIndicator = gameTexts[9];
            this.txtHighScore = gameTexts[10];
            this.txtPlayAgain = gameTexts[13];
            this.txtGotoMenu = gameTexts[12];
            this.txtGameOver = gameTexts[11];
            this.txtSlowMoText = gameTexts[0];
            this.txtComboPoints = gameTexts[14];
            this.txt_gametexts[0] = gameTexts[14];
            this.txt_gametexts[1] = gameTexts[8];
            this.txt_gametexts[2] = gameTexts[7];
            this.txt_gametexts[3] = gameTexts[1];
            this.txt_gametexts[4] = gameTexts[2];
            this.txt_gametexts[5] = gameTexts[3];
            this.txt_gametexts[6] = gameTexts[4];
            this.txt_gametexts[7] = gameTexts[5];
            this.txt_gametexts[8] = gameTexts[6];
            this.img_animfruit = app.gameAssets.img_animfruit;
            this.img_background = app.imggeneralbg;
            this.img_lifewhole = app.gameAssets.imgLives[0];
            this.img_lifeempty = app.gameAssets.imgLives[1];
            this.img_lives[0] = this.img_lifewhole;
            this.img_lives[1] = this.img_lifewhole;
            this.img_lives[2] = this.img_lifewhole;
            this.img_bgsplash = app.gameAssets.img_bgsplash;
            this.img_dotssplash = app.gameAssets.img_dotssplash;
            this.imgshadow = app.gameAssets.img_shadow;
            if (app.soundon) {
                this.game_sounds = app.gameAssets.game_sounds;
            }
        }
        catch (Exception ex) {
            app.showMessage("Error at FMNPlayScreen.init() " + ex);
        }
        catch (OutOfMemoryError omex) {
            app.showMessage("Out of memory Error at FMNPlayScreen.init() " + omex);
        }
    }

    public void sizeChanged(int w, int h) {
        this.width = w;
        this.height = h;
        if (h > 800) {
            this.maxveloc = 101;
        }
        if (h <= 800) {
            this.maxveloc = 83;
        }
        if (h <= 640) {
            this.maxveloc = 74;
        }
        if (h <= 400) {
            this.maxveloc = 58;
        }
        if (h <= 320) {
            this.maxveloc = 50;
        }
        if (h <= 240) {
            this.maxveloc = 44;
        }
        this.img_background = MobileUtils.resizeImage(this.img_background, this.width, this.height);
    }

    public void keyPressed(int keyCode) {
        if (this.endgame) {
            if (keyCode == -6) {
                this.endgameoption = 0;
                this.doEndgameOption();
                return;
            }
            if (keyCode == -7) {
                this.endgameoption = 1;
                this.app.gotoMainMenu();
                return;
            }
            int gameaction = this.getGameAction(keyCode);
            if (gameaction == 2 && this.endgameoption == 1) {
                this.endgameoption = 0;
                this.repaint();
                return;
            }
            if (gameaction == 5 && this.endgameoption == 0) {
                this.endgameoption = 1;
                this.repaint();
                return;
            }
            if (gameaction == 8) {
                this.doEndgameOption();
                this.repaint();
                return;
            }
            this.repaint();
            return;
        }
        if (keyCode == 49) {
            this.keyCut(1, null);
            return;
        }
        if (keyCode == 50) {
            this.keyCut(2, null);
            return;
        }
        if (keyCode == 51) {
            this.keyCut(3, null);
            return;
        }
        if (keyCode == 52) {
            this.keyCut(4, null);
            return;
        }
        if (keyCode == 53) {
            this.keyCut(5, null);
            return;
        }
        if (keyCode == 54) {
            this.keyCut(6, null);
            return;
        }
        if (keyCode == 55) {
            this.keyCut(7, null);
            return;
        }
        if (keyCode == 56) {
            this.keyCut(8, null);
            return;
        }
        if (keyCode == 57) {
            this.keyCut(9, null);
            return;
        }
    }

    void getNumFruits() {
        if (this.score > 500) {
            this.numfruits = 6;
            return;
        }
        if (this.score > 200) {
            this.numfruits = 5;
            return;
        }
        if (this.score > 100) {
            this.numfruits = 4;
            return;
        }
        if (this.score > 20) {
            this.numfruits = 3;
            return;
        }
        if (this.score > 10) {
            this.numfruits = 2;
            return;
        }
    }

    void keyCut(int fruitnum, FMNFruitImage[] fruitimage) {
        if (fruitimage == null) {
            this.playSound(this.SWORD_CUT);
            this.cutting = true;
            Vector<FMNFruitImage> toCut = new Vector<FMNFruitImage>();
            int i = 0;
            while (i < this.fruitList.size()) {
                FMNFruitImage cfi = (FMNFruitImage)((Object)this.fruitList.elementAt(i));
                int cfirn = cfi.getRandNum();
                if (cfirn == fruitnum) {
                    toCut.addElement(cfi);
                }
                ++i;
            }
            FMNFruitImage[] allCut = new FMNFruitImage[toCut.size()];
            toCut.copyInto((Object[])allCut);
            this.keyCut(fruitnum, allCut);
            return;
        }
        try {
            int i = 0;
            while (i < fruitimage.length) {
                if (fruitimage[i] == null) break;
                if (fruitimage[i].isfull()) {
                    FMNFruitImage cfi = fruitimage[i];
                    FMNFruitImage[] splits = cfi.splitFruit();
                    if (splits != null) {
                        this.fruitList.addElement(splits[0]);
                        this.fruitList.addElement(splits[1]);
                        splits[0].doMove();
                        splits[1].doMove();
                        this.makeCut(cfi, splits[0], splits[1]);
                    }
                    BGSplashEffects splashere = new BGSplashEffects(this.img_bgsplash[cfi.imgnum], this.img_bgsplash[cfi.imgnum].getWidth(), this.img_bgsplash[cfi.imgnum].getHeight(), this.app, this.height, this.bg_splashEffects);
                    splashere.setPosition(fruitimage[i].getX(), fruitimage[i].getY());
                    this.bg_splashEffects.addElement(splashere);
                    SPSplashEffects splashdots = new SPSplashEffects(this.img_dotssplash[cfi.imgnum], this.img_dotssplash[cfi.imgnum].getWidth(), this.img_dotssplash[cfi.imgnum].getHeight(), this, this.sp_splashEffects);
                    this.sp_splashEffects.addElement(splashdots);
                    splashdots.setPosition(cfi.getX(), cfi.getY() - 10);
                    splashdots.setGravity(cfi.gravity);
                    this.fruitList.removeElement((Object)cfi);
                    this.playSound(this.FRUIT_SMASH);
                }
                ++i;
            }
            this.score();
            this.cutting = false;
            this.repaint();
        }
        catch (Exception ex) {
            System.out.println("Error at KEYCUT_DRAG.split() " + ex);
            this.cutting = false;
        }
    }

    void score() {
        if (this.endgame) {
            return;
        }
        this.score += this.cutcount;
        if (this.cutcount >= 2) {
            this.combotimecount = 50;
            this.score += this.cutcount;
            this.combocount = this.cutcount;
            this.slowmocount = this.slowmotimecount == 0 ? (this.slowmocount += this.cutcount) : 0;
            if (this.slowmocount >= 30) {
                this.slowmotimecount = 50;
            }
            this.cutcount = 0;
        }
    }

    void cutMushroom() {
        try {
            if (this.app.soundon) {
                this.endGame();
                this.game_sounds[this.POISON_SPILL].addPlayerListener((PlayerListener)this);
                this.playSound(this.POISON_SPILL);
            } else {
                this.endGame();
            }
        }
        catch (Exception ex) {
            System.out.println(this.game_sounds[this.POISON_SPILL] + "Error at FMNPlayScreen.cutMushroom()" + ex);
        }
    }

    void loseFruit(FMNFruitImage lostfruit) {
        this.praisecount = 0;
        this.combotimecount = 0;
        this.playSound(this.BUZZER_SOUND);
        this.reduceLives();
        this.fruitList.removeElement((Object)lostfruit);
    }

    void reduceLives() {
        --this.gamelives;
        if (this.gamelives <= 0) {
            this.endGame();
        }
    }

    boolean intersects(FMNFruitImage fruitimage, int x, int y) {
        if (!fruitimage.full) {
            return false;
        }
        int x1 = fruitimage.getX();
        int y1 = fruitimage.getY();
        int y2 = y1 + fruitimage.height;
        int x2 = x1 + fruitimage.width;
        return x >= x1 && x <= x2 && y >= y1 && y <= y2;
    }

    void makeCut(FMNFruitImage original, FMNFruitImage fritop, FMNFruitImage fribot) {
        fritop.drorigx = fritop.getX() + 5;
        fritop.drendx = fribot.getX() + fribot.getWidth() - 5;
        fritop.drendy = fritop.getY() + 5;
        fritop.drorigy = fribot.getY() + fribot.getHeight() - 5;
        fritop.cutdx = fritop.drendx - fritop.drorigx;
        fritop.cutdy = fritop.drendy - fritop.drorigy;
        if (!original.isMushroom()) {
            ++this.cutcount;
            ++this.praisecount;
            if (this.praisecount == 10) {
                this.score += 10;
                this.praisetimecount = 50;
                this.praise_index = this.PRAISE_NICE;
            }
            if (this.praisecount == 25) {
                this.score += 10;
                this.praisetimecount = 50;
                this.praise_index = this.PRAISE_WOW;
            }
            if (this.praisecount == 50) {
                this.score += 10;
                this.praisetimecount = 50;
                this.praise_index = this.PRAISE_SLICER;
            }
            if (this.praisecount == 100) {
                this.score += 10;
                this.praisetimecount = 50;
                this.praise_index = this.PRAISE_AWESOME;
            }
            if (this.praisecount == 200) {
                this.score += 10;
                this.praisetimecount = 50;
                this.praise_index = this.PRAISE_GOD;
            }
            if (this.praisecount == 500) {
                this.score += 10;
                this.praisetimecount = 50;
                this.praise_index = this.PRAISE_FN;
            }
        }
    }

    int getPraiseCount(int prindex) {
        int prct = 0;
        if (prindex == this.PRAISE_NICE) {
            prct = 10;
        }
        if (prindex == this.PRAISE_WOW) {
            prct = 25;
        }
        if (prindex == this.PRAISE_SLICER) {
            prct = 50;
        }
        if (prindex == this.PRAISE_AWESOME) {
            prct = 100;
        }
        if (prindex == this.PRAISE_GOD) {
            prct = 200;
        }
        if (prindex == this.PRAISE_FN) {
            prct = 500;
        }
        return prct;
    }

    public void pointerPressed(int x, int y) {
        if (!this.touchscreen) {
            this.touchscreen = true;
        }
        if (this.endgame) {
            try {
                if (y > this.height - (this.app.gameAssets.controlFont.getHeight() + 5) && x < this.width / 3) {
                    this.endgameoption = 0;
                    this.repaint();
                    Thread.sleep(300L);
                    this.doEndgameOption();
                    return;
                }
                if (y > this.height - (this.app.gameAssets.controlFont.getHeight() + 5) && x >= this.width * 2 / 3) {
                    this.endgameoption = 1;
                    this.repaint();
                    Thread.sleep(300L);
                    this.doEndgameOption();
                    return;
                }
            }
            catch (Exception ex) {
                System.out.println("Error at PointerPressed():endGame " + ex);
            }
            return;
        }
        this.drorigx = x;
        this.drorigy = y;
    }

    public void pointerReleased(int x, int y) {
        this.drorigx = 0;
        this.drendx = 0;
        this.drorigy = 0;
        this.drendy = 0;
        this.dragging = false;
        this.repaint();
        FMNFruitImage[] fruitImages = new FMNFruitImage[this.vctCutFruits.size()];
        this.vctCutFruits.copyInto((Object[])fruitImages);
        if (fruitImages.length >= 1) {
            this.keyCut(0, fruitImages);
        }
        this.drcutcount = 0;
        this.cutPoints = new PointI[1];
        PointI thisPoint = new PointI();
        thisPoint.xp = x;
        thisPoint.yp = y;
        this.cutPoints[0] = thisPoint;
        this.vctCutFruits = new Vector();
        this.cutting = false;
        this.repaint();
    }

    public void pointerDragged(int x, int y) {
        try {
            if (!this.dragging) {
                this.drendx = x;
                this.drendy = y;
                this.dragging = true;
                this.cutPoints = new PointI[1];
                PointI thisPoint = new PointI();
                thisPoint.xp = x;
                thisPoint.yp = y;
                this.cutPoints[0] = thisPoint;
                if (this.drcutcount == 0) {
                    this.drcutcount = 50;
                }
                this.repaint();
            } else {
                if (this.drcutcount < 50) {
                    this.drcutcount = 50;
                }
                int i = 0;
                while (i < this.fruitList.size()) {
                    FMNFruitImage cfi = (FMNFruitImage)((Object)this.fruitList.elementAt(i));
                    if (this.intersects(cfi, x, y) && !this.vctCutFruits.contains((Object)cfi)) {
                        this.vctCutFruits.addElement(cfi);
                    }
                    ++i;
                }
                PointI thisPoint = new PointI();
                thisPoint.xp = x;
                thisPoint.yp = y;
                if (this.cutPoints == null) {
                    this.cutPoints = new PointI[1];
                    this.cutPoints[0] = thisPoint;
                }
                PointI[] oldCutPoints = new PointI[this.cutPoints.length];
                int i2 = 0;
                while (i2 < oldCutPoints.length) {
                    oldCutPoints[i2] = this.cutPoints[i2];
                    ++i2;
                }
                this.cutPoints = new PointI[1 + this.cutPoints.length];
                i2 = 0;
                while (i2 < oldCutPoints.length) {
                    this.cutPoints[i2] = oldCutPoints[i2];
                    ++i2;
                }
                this.cutPoints[this.cutPoints.length - 1] = thisPoint;
            }
            this.repaint();
        }
        catch (Exception ex) {
            System.out.println("Error at FMNPlaySCreen.pointerDragged() " + ex + "  " + this.fruitList.size() + " CP " + this.cutPoints + " DRCC " + this.drcutcount);
        }
    }

    public void paint(Graphics g) {
        String allobjects = "";
        if (this.width == 0) {
            this.sizeChanged(this.getWidth(), this.getHeight());
            return;
        }
        this.drawing = true;
        try {
            if (this.endgame) {
                int endy = (this.height - this.largeFont.getHeight()) / 2;
                int endx = this.width / 2;
                g.drawImage(this.img_background, 0, 0, 20);
                g.setColor(0xFFFFFF);
                g.setFont(this.largeFont);
                g.drawString(this.txtGameOver, endx, endy, 17);
                g.setColor(0xFFFFFF);
                g.setFont(this.mediumFont);
                endx = (this.width - this.mediumFont.stringWidth(String.valueOf(this.txtScoreIndicator) + " " + this.score + " ")) / 2;
                g.drawString(String.valueOf(this.txtScoreIndicator) + " " + this.score + " ", endx, endy += 5 + this.largeFont.getHeight(), 20);
                g.setColor(0xFF8000);
                g.setFont(this.smallFont);
                endx = (this.width - this.smallFont.stringWidth(String.valueOf(this.txtHighScore) + "  " + this.app.highscore + " ")) / 2;
                g.drawString(String.valueOf(this.txtHighScore) + "  " + this.app.highscore + " ", endx, endy += 3 + this.mediumFont.getHeight(), 20);
                g.setColor(0);
                g.setFont(this.largeFont);
                g.drawString(String.valueOf(this.txtScoreIndicator) + " " + this.score, 3, 5, 20);
                g.setColor(0);
                g.setFont(this.mediumFont);
                g.drawString(String.valueOf(this.txtHighScore) + " " + this.app.highscore, 3, this.largeFont.getHeight() + 8, 20);
                g.setColor(0xFFFFFF);
                int origin = this.width - (this.img_lifewhole.getWidth() * this.img_lives.length + 5 * this.img_lives.length);
                int i = 0;
                while (i < this.img_lives.length) {
                    if (i < 3 - this.gamelives) {
                        g.drawImage(this.img_lifeempty, origin + i * this.img_lifeempty.getWidth() + i * 5, 5, 20);
                    } else {
                        g.drawImage(this.img_lives[i], origin + i * this.img_lifewhole.getWidth() + i * 5, 5, 20);
                    }
                    ++i;
                }
                g.setColor(0xFFFFFF);
                g.setFont(this.app.gameAssets.controlFont);
                if (this.endgameoption == 0) {
                    g.setColor(this.app.gameAssets.ctrl_hl_color);
                    g.drawString(this.txtPlayAgain, 5, this.height - 5, 36);
                    g.setColor(this.app.gameAssets.ctrl_normal_color);
                    g.drawString(this.txtGotoMenu, this.width - 5, this.height - 5, 40);
                }
                if (this.endgameoption == 1) {
                    g.setColor(this.app.gameAssets.ctrl_normal_color);
                    g.drawString(this.txtPlayAgain, 5, this.height - 5, 36);
                    g.setColor(this.app.gameAssets.ctrl_hl_color);
                    g.drawString(this.txtGotoMenu, this.width - 5, this.height - 5, 40);
                }
                return;
            }
            g.drawImage(this.img_background, 0, 0, 20);
            g.setColor(-1);
            g.setFont(this.app.gameAssets.controlFont);
            int i = 0;
            while (i < this.bg_splashEffects.size()) {
                BGSplashEffects splashere = (BGSplashEffects)((Object)this.bg_splashEffects.elementAt(i));
                splashere.ticktock();
                splashere.paint(g);
                ++i;
            }
            g.setColor(0xFFFFFF);
            try {
                i = 0;
                while (i < this.fruitList.size()) {
                    FMNFruitImage cfi = (FMNFruitImage)((Object)this.fruitList.elementAt(i));
                    g.setColor(0xFFFFFF);
                    g.drawImage(this.imgshadow, cfi.getX() + 2, cfi.getY() + 3, 20);
                    cfi.paint(g);
                    if (cfi.isfull()) {
                        g.drawString("" + cfi.getRandNum(), cfi.getOutX(), cfi.getOutY(), 40);
                    } else if (cfi.hasline && cfi.isupper) {
                        if (this.cutcount == 1) {
                            cfi.cutcount = 1;
                            this.cutcount = 0;
                        }
                        if (!this.touchscreen) {
                            int j;
                            if (Math.abs(cfi.cutdy) >= Math.abs(cfi.cutdx)) {
                                j = 0;
                                while (j < 5) {
                                    g.drawLine(cfi.drorigx + j, cfi.drorigy, cfi.drendx + j, cfi.drendy);
                                    ++j;
                                }
                            } else {
                                j = 0;
                                while (j < 5) {
                                    g.drawLine(cfi.drorigx, cfi.drorigy + j, cfi.drendx, cfi.drendy + j);
                                    ++j;
                                }
                            }
                        } else {
                            g.setColor(-1430192192);
                            if (cfi.cutPoints != null) {
                                int k = 0;
                                while (k < cfi.cutPoints.length) {
                                    if (k > 0) {
                                        int j = 0;
                                        while (j < 4) {
                                            g.drawLine(cfi.cutPoints[k - 1].xp + j, cfi.cutPoints[k - 1].yp + j, cfi.cutPoints[k].xp + j, cfi.cutPoints[k].yp + j);
                                            ++j;
                                        }
                                    }
                                    ++k;
                                }
                            }
                        }
                        g.setColor(0xFF8000);
                        if (cfi.cutcount == 1) {
                            int xpos = cfi.drorigx;
                            g.drawString("+1", xpos, cfi.drorigy, 20);
                        }
                    }
                    ++i;
                }
            }
            catch (Exception frex) {
                System.out.println("Error at drawFruits " + frex);
            }
            g.setColor(-1430192192);
            if (this.cutPoints != null) {
                i = 0;
                while (i < this.cutPoints.length) {
                    if (i > 0) {
                        int j = 0;
                        while (j < 4) {
                            g.drawLine(this.cutPoints[i - 1].xp + j, this.cutPoints[i - 1].yp + j, this.cutPoints[i].xp + j, this.cutPoints[i].yp + j);
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            allobjects = "SPL" + this.sp_splashEffects + " cut points " + this.cutPoints + " GA " + this.app.gameAssets;
            if (this.combotimecount < 1200 && this.combotimecount > 0) {
                g.setColor(this.app.gameAssets.prompt_color);
                g.setFont(this.app.gameAssets.controlFont);
                int xpos = (this.width - this.app.gameAssets.controlFont.stringWidth("+" + this.combocount + " " + this.txtComboPoints)) / 2;
                int nypos = (this.height - this.app.gameAssets.controlFont.getHeight()) / 2 - 15;
                g.drawString("+" + this.combocount + " " + this.txtComboPoints, xpos, nypos, 20);
            }
            if (this.praisetimecount < 1800 && this.praisetimecount > 0) {
                g.setColor(0x8000FF);
                g.setFont(this.largeFont);
                int imgwid = 0;
                int xpos = (this.width - (imgwid += this.largeFont.stringWidth(this.txt_gametexts[this.praise_index]))) / 2;
                int oypos = 15 + (this.height - this.largeFont.getHeight()) / 2;
                g.drawString(this.txt_gametexts[this.praise_index], xpos, oypos, 20);
                g.setColor(this.app.gameAssets.prompt_color);
                g.setFont(this.app.gameAssets.controlFont);
                int hypos = oypos + 5 + this.largeFont.getHeight();
                xpos = (this.width - this.app.gameAssets.controlFont.stringWidth(String.valueOf(this.praisecount) + " " + this.txt_gametexts[this.PRAISE_POINTS])) / 2;
                g.drawString(String.valueOf(this.getPraiseCount(this.praise_index)) + " " + this.txt_gametexts[this.PRAISE_POINTS], xpos, hypos, 20);
                xpos = (this.width - this.app.gameAssets.controlFont.stringWidth(this.txt_gametexts[this.PRAISE_IN_A_ROW])) / 2;
                hypos = hypos + 5 + this.app.gameAssets.controlFont.getHeight();
                g.drawString(this.txt_gametexts[this.PRAISE_IN_A_ROW], xpos, hypos, 20);
            }
            i = 0;
            while (i < this.sp_splashEffects.size()) {
                SPSplashEffects splashere = (SPSplashEffects)((Object)this.sp_splashEffects.elementAt(i));
                splashere.doMove();
                splashere.ticktock();
                splashere.paint(g);
                ++i;
            }
            g.setColor(0);
            g.setFont(this.largeFont);
            g.drawString(String.valueOf(this.txtScoreIndicator) + "  " + this.score, 3, 5, 20);
            g.setColor(0);
            g.setFont(this.mediumFont);
            g.drawString(String.valueOf(this.txtHighScore) + "  " + this.app.highscore, 3, this.largeFont.getHeight() + 8, 20);
            int origin = this.width - (this.img_lifewhole.getWidth() * this.img_lives.length + 5 * this.img_lives.length);
            int i2 = 0;
            while (i2 < this.img_lives.length) {
                if (i2 < 3 - this.gamelives) {
                    g.drawImage(this.img_lifeempty, origin + i2 * this.img_lifeempty.getWidth() + i2 * 5, 5, 20);
                } else {
                    g.drawImage(this.img_lives[i2], origin + i2 * this.img_lifewhole.getWidth() + i2 * 5, 5, 20);
                }
                ++i2;
            }
            if (this.slowmotimecount > 50 && this.slowmotimecount < 7000) {
                g.setColor(32960);
                g.setFont(this.largeFont);
                g.drawString(this.txtSlowMoText, this.width / 2, this.height - (this.largeFont.getHeight() + 5), 17);
            }
        }
        catch (Exception ex) {
            System.out.println("Error at FMNPlayScreen.paint()" + ex + "  FruitListSize " + this.fruitList.size() + " Cut Points " + this.cutPoints + "  SPL = " + this.sp_splashEffects);
        }
        this.drawing = false;
    }

    int[] rotateArray(int[] array) {
        int firstnum = array[0];
        int i = 1;
        while (i < array.length) {
            array[i - 1] = array[i];
            ++i;
        }
        array[array.length - 1] = firstnum;
        return array;
    }

    void makeFruit() {
        int chosen_fruit = -1;
        this.getNumFruits();
        int velocity = 0;
        if (this.fruitList.size() == 0) {
            this.fruit_nums = this.rotateArray(this.fruit_nums);
        }
        try {
            Vector<Integer> velocvec = new Vector<Integer>();
            Vector<Integer> posvec = new Vector<Integer>();
            Random frRandom = new Random();
            Random angRandom = new Random();
            this.globalRandom = new Random();
            int i = 0;
            while (i < this.numfruits) {
                chosen_fruit = Math.abs(frRandom.nextInt(this.img_animfruit.length));
                int framewidth = this.img_animfruit[chosen_fruit].getWidth() / 8;
                int frameheight = this.img_animfruit[chosen_fruit].getHeight() / 3;
                FMNFruitImage cfi = new FMNFruitImage(this.img_animfruit[chosen_fruit], framewidth, frameheight, this, true);
                cfi.imgnum = chosen_fruit;
                if (chosen_fruit == 3) {
                    cfi.setMushroom(true);
                } else {
                    cfi.setMushroom(false);
                }
                int leftofrange = -10;
                int posx = this.getRandomInt(new Integer(this.width + 20), posvec);
                posvec.addElement(new Integer(posx));
                velocity = this.getRandomInt(new Integer(Math.abs(this.maxveloc - this.minveloc)), velocvec);
                velocvec.addElement(new Integer(velocity));
                double angle = Math.toRadians(angRandom.nextDouble() * (this.anglemax - this.anglemin) + this.anglemin);
                cfi.setMotion(posx += leftofrange, this.height - 2, angle, velocity += this.minveloc);
                this.fruitList.addElement(cfi);
                ++i;
            }
        }
        catch (Exception ex) {
            System.out.println(" Error at FMNPlayScreen.makeFruit() " + ex);
        }
    }

    void removeIntFromVector(int intvalue, Vector vct) {
        int i = 0;
        while (i < vct.size()) {
            Integer inint = (Integer)vct.elementAt(i);
            if (inint == intvalue) {
                vct.removeElementAt(i);
            }
            ++i;
        }
    }

    int getRandomInt(Integer max, Vector exclude) {
        Integer myint = new Integer(0);
        try {
            myint = new Integer(this.globalRandom.nextInt(Math.abs(max)));
            int[] exclarray = new int[exclude.size()];
            int i = 0;
            while (i < exclarray.length) {
                Integer inint = (Integer)exclude.elementAt(i);
                exclarray[i] = inint;
                ++i;
            }
            i = 0;
            while (i < exclarray.length) {
                if (myint == exclarray[i]) {
                    i = 0;
                    myint = new Integer(this.globalRandom.nextInt(max));
                }
                ++i;
            }
        }
        catch (Exception ex) {
            System.out.println(" Error at getRandomInt() " + ex);
        }
        return myint;
    }

    public void run() {
        while (!this.endgame) {
            try {
                Thread.sleep(30L);
                if (this.drawing) continue;
                if (this.endgame) break;
                if (this.pausegame) continue;
                if (this.slowmotimecount >= 7000) {
                    this.slowmotimecount = 0;
                    this.slowmocount = 0;
                    this.fruit_fly_interval = 0.32;
                } else if (this.slowmotimecount > 0 && this.slowmotimecount < 7000) {
                    this.slowmotimecount += 30;
                    this.fruit_fly_interval = 0.16;
                }
                if (this.drcutcount >= 300) {
                    if (this.vctCutFruits != null && this.vctCutFruits.size() >= 1) {
                        FMNFruitImage[] fruitImages = new FMNFruitImage[this.vctCutFruits.size()];
                        this.vctCutFruits.copyInto((Object[])fruitImages);
                        if (fruitImages.length >= 1) {
                            this.keyCut(0, fruitImages);
                        }
                        this.vctCutFruits = new Vector();
                        this.cutPoints = null;
                        this.dragging = false;
                    }
                    this.cutPoints = null;
                    this.dragging = false;
                    this.drcutcount = 0;
                    this.cutting = false;
                } else if (this.drcutcount > 0 && this.drcutcount < 350) {
                    this.drcutcount += 50;
                }
                if (this.combotimecount > 1200) {
                    this.combotimecount = 0;
                    this.combocount = 0;
                } else if (this.combotimecount > 0 && this.combotimecount < 1200) {
                    this.combotimecount += 50;
                }
                if (this.praisetimecount > 1800) {
                    this.praisetimecount = 0;
                    this.score += 10;
                } else if (this.praisetimecount > 0 && this.praisetimecount < 1800) {
                    this.praisetimecount += 50;
                }
                int i = 0;
                while (i < this.fruitList.size()) {
                    FMNFruitImage cfi = (FMNFruitImage)((Object)this.fruitList.elementAt(i));
                    cfi.doMove();
                    ++i;
                }
                this.repaint();
                this.time_fruitintervalcum += 50;
                if (this.time_fruitintervalcum < this.time_fruitinterval) continue;
                this.makeFruit();
                this.time_fruitintervalcum = 0;
            }
            catch (Exception ex) {
                System.out.println("Error at PlayScreen.run() " + ex);
            }
        }
    }

    void endGame() {
        this.endgame = true;
        this.combotimecount = 0;
        this.praisecount = 0;
        this.app.highscore = Math.max(this.app.highscore, this.score);
        this.app.hdbrSettings.set("HIGH_SCORE", "" + this.app.highscore);
        this.app.hdbrSettings.persistData();
        this.fruitList = new Vector();
        this.repaint();
    }

    void doEndgameOption() {
        if (this.endgameoption == 1) {
            this.app.gotoMainMenu();
            return;
        }
        if (this.endgameoption == 0) {
            this.app.gotoPlayScreen();
            return;
        }
    }

    public void playerUpdate(Player ply, String eventType, Object eventData) {
        try {
            if (ply == this.game_sounds[this.POISON_SPILL] && (eventType == "endOfMedia" || eventType.equalsIgnoreCase("endOfMedia"))) {
                this.endGame();
                return;
            }
        }
        catch (Exception ex) {
            System.out.println("Error at FMNPlayScreen.playerUpdate() " + ex);
        }
    }

    void playSound(int soundindex) {
    }
}

