/*
 * Decompiled with CFR 0.152.
 */
package com.kiwavi.mobiledb;

import com.kiwavi.mobiledb.CHashtable;
import com.kiwavi.mobiledb.RMSMobileStore;
import com.kiwavi.mobiledb.RMSUsingApp;
import java.util.Enumeration;

public final class MobileHDBR
implements RMSMobileStore {
    RMSUsingApp app;
    private CHashtable chData = new CHashtable();
    String dbname;

    public MobileHDBR(RMSUsingApp app, String dbname) {
        this.app = app;
        this.dbname = dbname;
    }

    public void load() {
        this.app.loadRMSData(this.dbname, this);
    }

    public void persistData() {
        try {
            String appsData = this.chData.toString();
            this.app.persistRMSData(this.dbname, appsData);
            System.out.println(String.valueOf(this.dbname) + " Data saved is " + new String(appsData));
        }
        catch (Exception ex) {
            this.app.showMessage("Error at MobileHDBR.persistData() for " + this.dbname + " " + ex);
        }
    }

    public String get(String itemName) {
        if (this.chData.get(itemName) == null) {
            return null;
        }
        return this.chData.get(itemName).toString();
    }

    public void RMSDataLoaded(String chtdata) {
        this.chData = new CHashtable(chtdata);
        System.out.println("\n\ndata loaded via MobileHDBR " + this.chData);
        this.app.continueAfterLoad(this.dbname);
    }

    public CHashtable getData() {
        return this.chData;
    }

    public void set(String itemName, String value) {
        this.chData.put(itemName, value);
    }

    public int size() {
        return this.chData.size();
    }

    public String[] keys() {
        String[] strky = new String[this.size()];
        Enumeration kys = this.chData.keys();
        int i = 0;
        while (kys.hasMoreElements()) {
            strky[i] = kys.nextElement().toString();
            ++i;
        }
        return strky;
    }

    public String toString() {
        return this.chData.toString();
    }
}

