/*
 * Decompiled with CFR 0.152.
 */
package com.softgames.farmninja;

import com.kiwavi.mobileutils.MobileUtils;
import com.softgames.farmninja.FarmNinjaMidlet;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

class FMNLanguageMenu
extends GameCanvas {
    FarmNinjaMidlet app;
    int width;
    int height;
    int menu_item_height = 20;
    int menu_x;
    int menu_y;
    int menu_vspace = 7;
    int selectedItem = 0;
    int totalMenuHeight;
    int splashWidth;
    int splashHeight;
    int osh;
    int osw;
    int[] menu_posy;
    String[] languages = new String[]{"ENG", "POL", "DEU", "RUS", "FRA", "ESP"};
    String[] txtLanguages;
    Image img_background;

    FMNLanguageMenu(FarmNinjaMidlet app) {
        super(false);
        this.setFullScreenMode(true);
        try {
            this.app = app;
            this.width = this.getWidth();
            this.height = this.getHeight();
            this.img_background = app.imggeneralbg;
            this.txtLanguages = app.gameText.getLanguageList(app.getLanguage());
            this.redimension();
        }
        catch (Exception ex) {
            System.out.println("Error at FMNLanguageMenu.init() " + ex);
        }
    }

    public void sizeChanged(int w, int h) {
        this.width = w;
        this.height = h;
        this.splashWidth = w;
        this.splashHeight = h;
        this.img_background = MobileUtils.resizeImage(this.img_background, this.width, this.height);
        this.redimension();
    }

    void redimension() {
        try {
            int trq = this.height * 7 / 10;
            int rawmenuheight = this.app.gameAssets.controlFont.getHeight() * this.languages.length + 12 * (this.languages.length - 1);
            int pvspace = (trq - rawmenuheight) / (this.languages.length - 1);
            this.menu_vspace = Math.max(this.menu_vspace, pvspace);
            this.totalMenuHeight = this.menu_vspace * (this.languages.length - 1) + this.app.gameAssets.controlFont.getHeight() * this.languages.length;
            this.menu_y = (this.height - this.totalMenuHeight) / 2;
            this.menu_posy = new int[this.languages.length + 1];
            int i = 0;
            while (i < this.menu_posy.length) {
                this.menu_posy[i] = this.menu_y + i * this.app.gameAssets.controlFont.getHeight() + i * this.menu_vspace;
                ++i;
            }
        }
        catch (Exception ex) {
            System.out.println("Error at FMNLanguageMenu.redimension() " + ex);
        }
        this.repaint();
    }

    public void keyPressed(int keycode) {
        this.redimension();
        int gameAction = this.getGameAction(keycode);
        if (gameAction == 1 && this.selectedItem > 0) {
            --this.selectedItem;
            this.repaint();
            return;
        }
        if (gameAction == 6 && this.selectedItem < this.txtLanguages.length - 1) {
            ++this.selectedItem;
            this.repaint();
            return;
        }
        if (gameAction == 8) {
            this.app.setLanguage(this.languages[this.selectedItem]);
            if (this.app.firsttime) {
                this.app.gotoTutorialScreen();
                this.app.firsttime = false;
                return;
            }
            this.app.gotoMainMenu();
            return;
        }
    }

    public void pointerPressed(int x, int y) {
        int cursel = this.selectedItem;
        this.selectedItem = -1;
        int i = 0;
        while (i < this.menu_posy.length) {
            if (y >= this.menu_posy[i] && y < this.menu_posy[i] + this.app.gameAssets.controlFont.getHeight() && x > 5 && x < this.width - 10) {
                this.selectedItem = i;
            }
            ++i;
        }
        if (this.selectedItem == -1) {
            this.selectedItem = cursel;
            this.repaint();
            return;
        }
        this.pauseAndSelect();
    }

    synchronized void pauseAndSelect() {
        this.repaint();
        try {
            this.repaint();
            Thread.sleep(600L);
            this.app.setLanguage(this.languages[this.selectedItem]);
            if (this.app.firsttime) {
                this.app.gotoTutorialScreen();
            } else {
                this.app.gotoMainMenu();
            }
        }
        catch (Exception ex) {
            this.app.showMessage("Error at LanguageMenu.pauseAndSelect() " + ex);
        }
    }

    public void paint(Graphics g) {
        if (this.height < this.app.app_height) {
            this.sizeChanged(this.getWidth(), this.getHeight());
            return;
        }
        g.drawImage(this.img_background, 0, 0, 20);
        g.setFont(this.app.gameAssets.controlFont);
        int i = 0;
        while (i < this.txtLanguages.length) {
            if (this.selectedItem == i) {
                g.setColor(this.app.gameAssets.menu_hl_color);
                g.drawString(this.txtLanguages[i], this.width / 2, this.menu_posy[i], 17);
            } else {
                g.setColor(this.app.gameAssets.menu_normal_color);
                g.drawString(this.txtLanguages[i], this.width / 2, this.menu_posy[i], 17);
            }
            ++i;
        }
    }
}

