/*
 * Decompiled with CFR 0.152.
 */
package com.softgames.farmninja;

import com.softgames.farmninja.FMNPlayScreen;
import com.softgames.farmninja.FarmNinjaMidlet;
import com.softgames.farmninja.PointI;
import java.util.Random;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

class FMNFruitImage
extends Sprite {
    int xmov;
    int ymov;
    int width;
    int outx;
    int outy;
    int randnum;
    int height;
    int originx;
    int originy;
    int linetime = 0;
    int imgnum;
    int framecount = 0;
    FarmNinjaMidlet app;
    FMNPlayScreen playScreen;
    boolean full = false;
    boolean hasline = false;
    boolean isupper = false;
    private boolean ismushroom = false;
    float time = 0.0f;
    Image fruitImage;
    double angle = 0.0;
    double timeinterval;
    double gravity = 4.5;
    int velocity;
    boolean rightwards = true;
    int drorigx;
    int drorigy;
    int drendx;
    int drendy;
    int cutdx;
    int cutdy;
    int cutcount = 0;
    PointI[] cutPoints;

    FMNFruitImage(Image fruitImage, int frameWidth, int frameHeight, FMNPlayScreen playScreen, boolean full) {
        super(fruitImage, frameWidth, frameHeight);
        try {
            this.fruitImage = fruitImage;
            this.playScreen = playScreen;
            this.app = playScreen.app;
            this.full = full;
            this.width = frameWidth;
            this.height = frameHeight;
            if (full) {
                int[] nArray = new int[8];
                nArray[1] = 1;
                nArray[2] = 2;
                nArray[3] = 3;
                nArray[4] = 4;
                nArray[5] = 5;
                nArray[6] = 6;
                nArray[7] = 7;
                int[] framesequence = nArray;
                this.setFrameSequence(framesequence);
            }
        }
        catch (Exception ex) {
            this.app.showMessage("error at FruitImage.init() " + ex);
        }
    }

    void setMushroom(boolean ismush) {
        this.ismushroom = ismush;
        Random numrandom = this.playScreen.globalRandom;
        int pos3 = numrandom.nextInt(1000) % 3;
        int pos5 = 3 + numrandom.nextInt(1000) % 5;
        this.randnum = !this.ismushroom ? this.playScreen.fruit_nums[pos3] : this.playScreen.fruit_nums[pos5];
    }

    boolean isMushroom() {
        return this.ismushroom;
    }

    void setMotion(int origx, int origy, double angle, int velocity) {
        try {
            this.velocity = velocity;
            this.angle = angle;
            this.originy = origy;
            int traveldistance = (int)((double)(velocity * velocity) * Math.sin(2.0 * angle) / this.gravity);
            this.originy = origy;
            if (origx > this.playScreen.width / 2) {
                this.rightwards = false;
                this.originx = origx - traveldistance > this.playScreen.width - this.width * 2 ? this.playScreen.width + traveldistance - this.width * 2 : origx;
            } else {
                this.rightwards = true;
                this.originx = origx + this.width + 10 < -(traveldistance / 3) ? this.width + 10 - traveldistance / 3 : origx;
            }
            this.setPosition(this.originx, this.originy);
        }
        catch (Exception ex) {
            this.app.showMessage("Error at FruitImage.setMotion() " + ex);
        }
    }

    int getRandNum() {
        if (this.full) {
            return this.randnum;
        }
        return 0;
    }

    void setTime(float time) {
        this.time = time;
    }

    boolean isfull() {
        return this.full;
    }

    int getOutX() {
        return this.getX() + this.width;
    }

    int getOutY() {
        return this.getY() + this.height;
    }

    void doMove() {
        try {
            if (this.hasline && this.linetime >= 0 && this.linetime < 5) {
                this.nextFrame();
                ++this.linetime;
                if (this.linetime >= 5) {
                    this.hasline = false;
                }
                return;
            }
            if (!this.full) {
                if (this.getY() < this.playScreen.getHeight()) {
                    this.doDrop();
                } else {
                    this.playScreen.fruitList.removeElement((Object)this);
                }
                return;
            }
            this.xmov = (int)((double)((float)this.velocity * this.time) * Math.cos(this.angle));
            this.ymov = (int)((double)((float)this.velocity * this.time) * Math.sin(this.angle) - this.gravity * 0.5 * (double)this.time * (double)this.time);
            if (!this.rightwards && this.originx - (this.xmov - this.getWidth()) < 0 || this.originy - this.ymov > this.playScreen.getHeight()) {
                if (this.full && !this.ismushroom) {
                    this.playScreen.loseFruit(this);
                } else {
                    this.playScreen.fruitList.removeElement((Object)this);
                }
                return;
            }
            if (this.rightwards && this.originx + this.xmov > this.playScreen.getWidth() || this.originy - this.ymov > this.playScreen.getHeight()) {
                if (this.full && !this.ismushroom) {
                    this.playScreen.loseFruit(this);
                } else {
                    this.playScreen.fruitList.removeElement((Object)this);
                }
                return;
            }
            if (this.rightwards) {
                this.setPosition(this.originx + this.xmov, this.originy - this.ymov);
            } else {
                this.setPosition(this.originx - this.xmov, this.originy - this.ymov);
            }
            this.time = (float)((double)this.time + this.playScreen.fruit_fly_interval);
            if (this.framecount == 2) {
                this.nextFrame();
                this.framecount = 0;
            } else {
                ++this.framecount;
            }
        }
        catch (Exception ex) {
            this.app.showMessage("Error at FMNFruitImage.doMove()");
        }
    }

    void doDrop() {
        this.time = (float)((double)this.time + 0.7);
        this.ymov = (int)(0.5 * this.gravity * (double)this.time * (double)this.time);
        this.setPosition(this.originx, this.originy + this.ymov);
        if (this.framecount == 2) {
            this.nextFrame();
            this.framecount = 0;
        } else {
            ++this.framecount;
        }
    }

    void initposition() {
        this.setPosition(this.originx, this.originy);
    }

    FMNFruitImage[] splitFruit() throws Exception {
        int[] framesequence1 = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
        int[] framesequence2 = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
        FMNFruitImage[] splits = new FMNFruitImage[2];
        try {
            if (this.ismushroom) {
                this.playScreen.cutMushroom();
            }
            splits[0] = new FMNFruitImage(this.fruitImage, this.width, this.height, this.playScreen, false);
            splits[1] = new FMNFruitImage(this.fruitImage, this.width, this.height, this.playScreen, false);
            splits[0].setTime(0.0f);
            splits[0].setFrameSequence(framesequence1);
            splits[0].hasline = true;
            splits[0].isupper = true;
            splits[0].originx = this.getX() - 10;
            splits[0].originy = this.getY();
            splits[0].initposition();
            splits[0].cutPoints = this.playScreen.cutPoints;
            splits[1].originx = this.getX() + 10;
            splits[1].originy = this.getY();
            splits[1].initposition();
            splits[1].setTime(0.0f);
            splits[1].setFrameSequence(framesequence2);
            splits[1].hasline = true;
        }
        catch (Exception ex) {
            this.app.showMessage("Error at FruitImage.split() " + ex);
        }
        return splits;
    }
}

