/*
 * Decompiled with CFR 0.152.
 */
package com.softgames.farmninja;

import com.kiwavi.mobileutils.StringTokenizer;
import com.softgames.farmninja.FarmNinjaMidlet;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;

class FMNGameText {
    FarmNinjaMidlet app;
    String[] game_text;
    String helpText;
    String[] menu_text;
    String[] option_text;
    String[] sound_text;
    String[] languageList = new String[]{"ENG", "POL", "DEU", "RUS", "FRA", "ESP"};
    Hashtable htGameText = new Hashtable();
    Hashtable htMenuText = new Hashtable();
    Hashtable htSoundText = new Hashtable();
    Hashtable htOptionsText = new Hashtable();
    Hashtable htHelpText = new Hashtable();
    Hashtable htAboutText = new Hashtable();
    Hashtable htLanguagesText = new Hashtable();

    FMNGameText(FarmNinjaMidlet app) {
        this.app = app;
        try {
            InputStream is = this.getClass().getResourceAsStream("/gametext.txt");
            System.out.println("how are you -1" + is);
            char[] inread = new char[65535];
            InputStreamReader isr = new InputStreamReader(is, "UTF-8");
            int numread = isr.read(inread, 0, 65535);
            String stInread = new String(inread, 0, numread);
            stInread = stInread.replace('\u00a7', '\n');
            int versindex = stInread.indexOf("$(version)");
            while (versindex > 0) {
                String stInread1 = stInread.substring(0, versindex);
                String stInread2 = stInread.substring(versindex += 10);
                stInread = String.valueOf(stInread1) + " " + app.APP_VERSION + " " + stInread2;
                versindex = stInread.indexOf("$(version)", versindex);
            }
            this.processLanguages(stInread);
        }
        catch (Exception ex) {
            System.out.println("Error at FMNGameText.init() " + ex);
        }
        catch (OutOfMemoryError omex) {
            System.out.println("Out of memory Error at FMNGameText.init() " + omex);
        }
    }

    void processLanguages(String gametext) {
        try {
            int index1 = 0;
            int index2 = 0;
            int i = 0;
            while (i < this.languageList.length) {
                index1 = gametext.indexOf("HELP=", index2);
                index2 = gametext.indexOf("=ENDHLP", index1);
                if (index1 >= 0 && index2 >= 0) {
                    String helpString = gametext.substring(index1, index2);
                    helpString = helpString.substring(5).trim();
                    this.htHelpText.put(this.languageList[i], helpString);
                    index1 = gametext.indexOf("GAMETEXT=", index2);
                    index2 = gametext.indexOf("=ENDGAMETXT", index1);
                    String gametString = gametext.substring(index1, index2).substring(9).trim();
                    this.htGameText.put(this.languageList[i], gametString);
                    index1 = gametext.indexOf("ABOUT=", index2);
                    index2 = gametext.indexOf("=ENDABT", index1);
                    String aboutString = gametext.substring(index1, index2).substring(6).trim();
                    this.htAboutText.put(this.languageList[i], aboutString);
                    index1 = gametext.indexOf("LANGUAGES=", index2);
                    index2 = gametext.indexOf("=ENDLANGS", index1);
                    System.out.println("Index 1 " + index1 + " Index 2 " + index2);
                    String languagesString = gametext.substring(index1, index2).substring(10).trim();
                    this.htLanguagesText.put(this.languageList[i], languagesString);
                    index1 = gametext.indexOf("SOUND=", index2);
                    index2 = gametext.indexOf("=ENDSND", index1 + 1);
                    String soundString = gametext.substring(index1, index2).substring(6).trim();
                    this.htSoundText.put(this.languageList[i], soundString);
                    index1 = gametext.indexOf("MENU=", index2);
                    index2 = gametext.indexOf("=ENDMNU", index1 + 1);
                    String menuString = gametext.substring(index1, index2).substring(5).trim();
                    this.htMenuText.put(this.languageList[i], menuString);
                    index1 = gametext.indexOf("OPTIONS=", index2);
                    index2 = gametext.indexOf("=ENDOPTNS", index1 + 1);
                    String optionsString = gametext.substring(index1, index2).substring(8).trim();
                    this.htOptionsText.put(this.languageList[i], optionsString);
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            System.out.println("\n\nError at FMNGameText.processLanguages() " + ex);
        }
    }

    String[] getGameText(String language) {
        Vector<String> vctItems = new Vector<String>();
        String strItems = "" + this.htGameText.get(language);
        StringTokenizer stItems = new StringTokenizer(strItems, ";");
        while (stItems.hasMoreTokens()) {
            vctItems.addElement(stItems.nextToken().trim());
        }
        Object[] aryItems = new String[vctItems.size()];
        vctItems.copyInto(aryItems);
        return aryItems;
    }

    String[] getMenuItems(String language) {
        Vector<String> vctItems = new Vector<String>();
        String strItems = "" + this.htMenuText.get(language);
        StringTokenizer stItems = new StringTokenizer(strItems, ";");
        while (stItems.hasMoreTokens()) {
            String menuItem = stItems.nextToken().trim();
            vctItems.addElement(menuItem);
        }
        Object[] aryItems = new String[vctItems.size()];
        vctItems.copyInto(aryItems);
        return aryItems;
    }

    String[] getSoundItems(String language) {
        System.out.println("Requested langauge is " + language + "  " + this.htSoundText);
        Vector<String> vctItems = new Vector<String>();
        String strItems = "" + this.htSoundText.get(language);
        StringTokenizer stItems = new StringTokenizer(strItems, ";");
        while (stItems.hasMoreTokens()) {
            vctItems.addElement(stItems.nextToken().trim());
        }
        Object[] aryItems = new String[vctItems.size()];
        vctItems.copyInto(aryItems);
        return aryItems;
    }

    String[] getOptionItems(String language) {
        Vector<String> vctItems = new Vector<String>();
        String strItems = "" + this.htOptionsText.get(language);
        StringTokenizer stItems = new StringTokenizer(strItems, ";");
        while (stItems.hasMoreTokens()) {
            vctItems.addElement(stItems.nextToken().trim());
        }
        Object[] aryItems = new String[vctItems.size()];
        vctItems.copyInto(aryItems);
        return aryItems;
    }

    String getHelpText(String language) {
        String strItem = "" + this.htHelpText.get(language);
        return strItem.trim();
    }

    String getAboutText(String language) {
        String strItem = "" + this.htAboutText.get(language);
        return strItem.trim();
    }

    String[] getLanguageList(String language) {
        Vector<String> vctItems = new Vector<String>();
        String strItems = "" + this.htLanguagesText.get(language);
        StringTokenizer stItems = new StringTokenizer(strItems, ";");
        while (stItems.hasMoreTokens()) {
            vctItems.addElement(stItems.nextToken().trim());
        }
        Object[] aryItems = new String[vctItems.size()];
        vctItems.copyInto(aryItems);
        return aryItems;
    }
}

