/*
 * Decompiled with CFR 0.152.
 */
package com.softgames.farmninja;

import com.kiwavi.mobileutils.MobileUtils;
import com.softgames.farmninja.FarmNinjaMidlet;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

class FMNMenuOptions
extends GameCanvas {
    FarmNinjaMidlet app;
    int width;
    int height;
    int[] optionsy;
    int option = 0;
    int menu_y;
    int menu_vspacing = 10;
    int totalMenuHeight;
    Image img_background;
    String[] txtOptions = new String[]{"LANGUAGE", "SOUND"};
    String txtGotoMenu = "MAIN MENU";

    FMNMenuOptions(FarmNinjaMidlet app) {
        super(false);
        this.setFullScreenMode(true);
        try {
            this.optionsy = new int[]{60, 85};
            this.txtOptions = app.gameText.getOptionItems(app.getLanguage());
            String[] gameTexts = app.gameText.getGameText(app.getLanguage());
            this.txtGotoMenu = gameTexts[15];
            this.img_background = app.imggeneralbg;
        }
        catch (Exception ex) {
            app.showMessage("Error at FMNMenuOptions.init() " + ex);
        }
        this.app = app;
    }

    public void sizeChanged(int w, int h) {
        int trq = this.height / 5;
        int pvspace = (trq - (this.app.gameAssets.controlFont.getHeight() * this.txtOptions.length + 13)) / (this.txtOptions.length - 1);
        this.menu_vspacing = Math.max(this.menu_vspacing, pvspace);
        this.width = w;
        this.height = h;
        this.totalMenuHeight = this.txtOptions.length * this.app.gameAssets.controlFont.getHeight() + this.txtOptions.length * this.menu_vspacing;
        this.menu_y = this.height / 2 + 10;
        this.optionsy = new int[]{this.menu_y, this.menu_y + this.app.gameAssets.controlFont.getHeight() + this.menu_vspacing};
        this.img_background = MobileUtils.resizeImage(this.img_background, this.width, this.height);
        this.repaint();
    }

    public void keyPressed(int keycode) {
        if (keycode == -7) {
            this.app.gotoMainMenu();
            return;
        }
        int gameAction = this.getGameAction(keycode);
        if (gameAction == 1 && this.option > 0) {
            --this.option;
            this.repaint();
            return;
        }
        if (gameAction == 6 && this.option <= this.txtOptions.length) {
            ++this.option;
            this.repaint();
            return;
        }
        if (gameAction == 8) {
            this.goSelection();
            return;
        }
    }

    void goSelection() {
        if (this.option == 0) {
            this.app.gotoLanguageMenu();
            return;
        }
        if (this.option == 1) {
            this.app.gotoSoundOption();
            return;
        }
        if (this.option > 1) {
            this.app.gotoMainMenu();
            return;
        }
    }

    void pauseAndSelect() {
        System.out.println("Selected item is " + this.option);
        try {
            Thread.sleep(1200L);
            this.goSelection();
        }
        catch (Exception ex) {
            this.app.showMessage("Error at FMNMenuOptions.pauseAndSelect() " + ex);
        }
    }

    public void pointerPressed(int x, int y) {
        if (x > this.width / 2 - 30 && x < this.width / 2 + 30 && y < this.menu_y + this.totalMenuHeight && y > this.totalMenuHeight) {
            if (y > this.optionsy[0] && y < this.optionsy[1]) {
                this.option = 0;
                this.repaint();
                this.pauseAndSelect();
                return;
            }
            this.option = 1;
            this.repaint();
            this.pauseAndSelect();
        }
        if (x > this.width - 60 && y > this.getHeight() - (this.app.gameAssets.controlFont.getHeight() + 5)) {
            this.option = 2;
            this.repaint();
            this.pauseAndSelect();
        }
    }

    public void paint(Graphics g) {
        if (this.height < this.app.app_height) {
            this.sizeChanged(this.getWidth(), this.getHeight());
            return;
        }
        g.drawImage(this.img_background, 0, 0, 20);
        g.setFont(this.app.gameAssets.controlFont);
        int i = 0;
        while (i < this.txtOptions.length) {
            int ypos = this.menu_y + i * 20 + i * this.menu_vspacing;
            if (this.option == i) {
                g.setColor(this.app.gameAssets.ctrl_hl_color);
                g.drawString(this.txtOptions[i], this.width / 2, ypos, 17);
            } else {
                g.setColor(this.app.gameAssets.ctrl_normal_color);
                g.drawString(this.txtOptions[i], this.width / 2, ypos, 17);
            }
            ++i;
        }
        if (this.option >= this.txtOptions.length) {
            g.setColor(this.app.gameAssets.ctrl_hl_color);
            g.drawString(this.txtGotoMenu, this.width - (this.app.gameAssets.controlFont.stringWidth(this.txtGotoMenu) + 5), this.getHeight() - (this.app.gameAssets.controlFont.getHeight() + 5), 20);
        } else {
            g.setColor(this.app.gameAssets.ctrl_normal_color);
            g.drawString(this.txtGotoMenu, this.width - (this.app.gameAssets.controlFont.stringWidth(this.txtGotoMenu) + 5), this.getHeight() - (this.app.gameAssets.controlFont.getHeight() + 5), 20);
        }
    }
}

