/*
 * Decompiled with CFR 0.152.
 */
package BubbleCute;

import BubbleCute.MainPRG;
import BubbleCute.Serv;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class Sound {
    static final boolean IS_SOUND_ALLOWED = true;
    boolean started = false;
    boolean isVolumeVariable = true;
    int soundVol = 50;
    boolean volumeControl = true;
    boolean soundOn = false;
    private Serv srv;
    int currBuffer = 0;
    private int currPiece = 0;
    private int currPriority = 0;
    long cTime = 0L;
    long endBuffer = 0L;
    long startBuffer = 0L;
    long loopBuffer = 0L;
    public static final short MAX_PLAYER = 15;
    private static final boolean USE_SIMPLE_PREFETCH = false;
    private byte[] dBufferPriority = new byte[15];
    private VolumeControl[] VolCon = new VolumeControl[15];
    public Player[] dBuffer = new Player[15];

    Sound(Serv _srv) {
        this.srv = _srv;
        if (MainPRG.DEBUG) {
            System.out.println("Init Sound....");
        }
    }

    public void setVolume(int nBuffer, int value) {
        if (this.isVolumeVariable && this.VolCon[nBuffer] != null) {
            this.VolCon[nBuffer].setLevel(value);
        }
    }

    public void resetVolume(int value) {
        for (int i = 0; i < 15; ++i) {
            if (!this.isVolumeVariable || this.VolCon[i] == null) continue;
            this.VolCon[i].setLevel(value);
        }
    }

    public void setPriority(int nBuffer, int Value) {
        this.dBufferPriority[nBuffer] = (byte)Value;
    }

    public void loadSound(int nBuffer, String filename, int priority) {
        if (this.dBuffer[nBuffer] != null) {
            this.freeSound(nBuffer);
        }
        String file_format = "audio/midi";
        int[] temp = new int[6];
        try {
            InputStream in = this.getClass().getResourceAsStream(filename.toLowerCase());
            for (int i = 0; i < 6; ++i) {
                temp[i] = in.read();
            }
            in.close();
            if (temp[0] == 82) {
                if (temp[1] == 73 && temp[2] == 70 && temp[3] == 70) {
                    file_format = "audio/x-wav";
                }
            } else if (temp[2] == 65 && temp[3] == 77 && temp[4] == 82) {
                file_format = "audio/amr";
            }
            System.out.println("sound: " + filename + "  sound format = " + file_format);
            in = this.getClass().getResourceAsStream(filename.toLowerCase());
            this.dBuffer[nBuffer] = Manager.createPlayer((InputStream)in, (String)file_format);
            this.dBuffer[nBuffer].realize();
            try {
                this.VolCon[nBuffer] = (VolumeControl)this.dBuffer[nBuffer].getControl("VolumeControl");
            }
            catch (Exception ex) {
                this.VolCon[nBuffer] = null;
            }
            if (this.VolCon[nBuffer] == null) {
                this.isVolumeVariable = false;
            }
            this.dBuffer[nBuffer].prefetch();
            System.out.println("Load Sound Successful - " + nBuffer);
        }
        catch (Exception e) {
            System.out.println("NoSound " + filename + " " + e.toString() + " >> " + this.dBuffer[nBuffer]);
            return;
        }
        temp = null;
        this.dBufferPriority[nBuffer] = (byte)priority;
    }

    public boolean isSoundPlaying(int nBuffer) {
        if (nBuffer != this.currBuffer) {
            return false;
        }
        int start_state = 400;
        if (this.dBuffer[nBuffer] == null) {
            return false;
        }
        return this.dBuffer[nBuffer].getState() == start_state;
    }

    public boolean isSoundPlaying() {
        return this.currBuffer != 0 ? this.isSoundPlaying(this.currBuffer) : false;
    }

    public void freeSound(int nBuffer) {
        Player p = this.dBuffer[nBuffer];
        if (p != null) {
            this.stopSound(nBuffer);
            p.deallocate();
            p.close();
            this.dBuffer[nBuffer] = null;
        }
    }

    public void stopSound(int nBuffer) {
        Player p = this.dBuffer[nBuffer];
        if (p != null) {
            if (this.currBuffer == nBuffer) {
                this.currPiece = 0;
                this.currBuffer = 0;
                this.currPriority = 0;
                this.started = false;
                this.cTime = -1L;
            }
            try {
                p.stop();
            }
            catch (MediaException e) {
                e.printStackTrace();
            }
        }
    }

    public void releaseVarible() {
        this.currPiece = 0;
        this.currBuffer = 0;
        this.currPriority = 0;
        this.started = false;
        this.cTime = -1L;
    }

    public boolean playSound(int nBuffer, int nPiece, int locPriority, int Vol, int nloop, long start, long end) {
        if (this.soundVol == 0) {
            return true;
        }
        if (this.currBuffer != 0 && this.currPiece != 0) {
            return true;
        }
        System.out.println("priority curr:" + this.currPriority + "/" + locPriority);
        if (this.currBuffer > 0 && this.currPriority >= locPriority) {
            System.out.println("no priority for " + this.currPriority + "/" + locPriority);
            return false;
        }
        System.out.println("reach 1 position: nBuffer:" + nBuffer + " nPiece" + nPiece);
        Player n_player = this.dBuffer[nBuffer];
        if (n_player == null) {
            return false;
        }
        if (this.soundVol == 0) {
            if (this.currBuffer != 0) {
                this.stopSound(this.currBuffer);
            }
            return false;
        }
        try {
            n_player.setMediaTime(start);
            if (this.currBuffer != nBuffer) {
                n_player.setLoopCount(1);
                n_player.start();
            }
            this.started = false;
            this.startBuffer = start;
            this.endBuffer = end;
            this.loopBuffer = nloop;
            this.currPriority = locPriority;
            this.cTime = start;
            this.currBuffer = nBuffer;
            this.currPiece = nPiece;
            this.srv.initSync();
            return true;
        }
        catch (Exception e) {
            this.currBuffer = 0;
            this.currPriority = 0;
            this.cTime = -1L;
            System.out.println("Play Exception B - " + nBuffer);
            return false;
        }
    }

    public void handleSound() {
        if (this.currBuffer != 0 && this.currPiece != 0) {
            long tempcTime = this.dBuffer[this.currBuffer].getMediaTime();
            if (!this.started) {
                this.started = tempcTime > this.startBuffer && tempcTime < this.endBuffer;
                this.cTime = this.startBuffer;
            } else {
                this.cTime = tempcTime;
                if (this.cTime > this.endBuffer - 100L) {
                    if (this.loopBuffer > 1L) {
                        --this.loopBuffer;
                        try {
                            this.dBuffer[this.currBuffer].setMediaTime(this.startBuffer);
                        }
                        catch (Exception e) {
                            this.releaseVarible();
                            e.printStackTrace();
                        }
                    } else {
                        this.stopSound(this.currBuffer);
                    }
                }
            }
        }
    }

    public boolean playSound(int nBuffer, int vol, int nloop) {
        if (this.soundVol == 0) {
            return true;
        }
        Player n_player = this.dBuffer[nBuffer];
        if (n_player == null) {
            return false;
        }
        Player curr_player = this.dBuffer[this.currBuffer];
        if (this.soundVol == 0) {
            if (this.isSoundPlaying()) {
                this.stopSound(this.currBuffer);
            }
            this.currBuffer = 0;
            this.currPriority = 0;
            this.cTime = -1L;
            return false;
        }
        if (this.currBuffer > 0 && this.currBuffer != nBuffer && this.isSoundPlaying(this.currBuffer)) {
            if (this.dBufferPriority[this.currBuffer] <= this.dBufferPriority[nBuffer]) {
                this.stopSound(this.currBuffer);
                this.currBuffer = 0;
                this.currPriority = 0;
                this.cTime = -1L;
            } else {
                return false;
            }
        }
        try {
            this.setVolume(nBuffer, vol);
            try {
                n_player.setMediaTime(0L);
                this.endBuffer = n_player.getDuration();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.startBuffer = 0L;
            this.loopBuffer = nloop;
            n_player.setLoopCount(nloop);
            n_player.start();
            this.currBuffer = nBuffer;
            if (MainPRG.DEBUG) {
                System.out.println("Play Successful - " + nBuffer);
            }
            return true;
        }
        catch (Exception e) {
            this.currBuffer = 0;
            this.currPriority = 0;
            this.cTime = -1L;
            System.out.println("Play Exception - " + nBuffer);
            return false;
        }
    }

    boolean isSoundPlaying(int nBuffer, int nPiece) {
        return this.currPiece == nPiece && this.currBuffer == nBuffer;
    }
}

