/*
 * Decompiled with CFR 0.152.
 */
package boot;

import boot.CarCanvas;
import boot.DevKit;
import boot.OurCar;
import javax.microedition.lcdui.Graphics;

public class Snow {
    private static final int MAX_SNOW_CONSISTANCE_BACK = 1;
    private static final int MAX_SNOW_CONSISTANCE_FRONT = 1;
    private static final short[] random_shift_back = new short[]{0, 0, 0, -1, -1, -1, 0, 0, 0, 1, 1, 1};
    private static final short[] random_shift_front = new short[]{0, 0, 0, -1, -1, -1, -1, -2, -2, -2, -2, -2, -1, -1, -1, -1, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 1};
    private static final short[] x_front = new short[1 * CarCanvas.H / 2];
    private static final short[] y_front = new short[1 * CarCanvas.H / 2];
    private static final byte[] deep_front = new byte[1 * CarCanvas.H / 2];
    private static final short[] x_back = new short[1 * CarCanvas.H];
    private static final short[] y_back = new short[1 * CarCanvas.H];
    private static final byte[] deep_back = new byte[1 * CarCanvas.H];
    private static final int DEEP_COUNT = 64;
    private static final int COLOR_SHIFT_R = 191;
    private static final int COLOR_SHIFT_G = 171;
    private static final int COLOR_SHIFT_B = 171;
    private static final int SPEED_COUNT_FRONT = 3;
    private static final int SPEED_MIN_FRONT = 2;
    private static final int SPEED_K_FRONT = 21;
    private static final int SPEED_COUNT_BACK = 2;
    private static final int SPEED_MIN_BACK = 1;
    private static final int SPEED_K_BACK = 32;
    private static final int HOR_SPEED_COUNT_BACK = 2;
    private static final int HOR_SPEED_MIN_BACK = 0;
    private static final int HOR_SPEED_K_BACK = 32;
    private static final int HOR_SPEED_COUNT_FRONT = 2;
    private static final int HOR_SPEED_MIN_FRONT = 1;
    private static final int HOR_SPEED_K_FRONT = 32;
    private static final int WIND_SPEED_MAX = 2;
    private static final int WIND_CHANGE_TIME = 200;
    private static int wind_speed = 0;
    private static int wind_last_change_tick = 0;
    public static int tick = 0;

    public static void draw_front(Graphics g) {
        int x_shift = (int)(-OurCar.x * (float)CarCanvas.W / 10.0f);
        g.setClip(0, 0, CarCanvas.W, CarCanvas.H);
        for (int i = 0; i < 1 * CarCanvas.H / 2; ++i) {
            g.setColor(deep_front[i] + 191, deep_front[i] + 171, deep_front[i] + 171);
            g.fillRect((x_front[i] + x_shift + random_shift_front[(i + tick) % random_shift_front.length] - CarCanvas.W) % CarCanvas.W + CarCanvas.W, (y_front[i] - CarCanvas.H) % CarCanvas.H + CarCanvas.H, 2, 2);
        }
    }

    public static void draw_back(Graphics g) {
        int x_shift = (int)(-OurCar.x * (float)CarCanvas.W / 20.0f);
        g.setClip(0, 0, CarCanvas.W, CarCanvas.H);
        for (int i = 0; i < 1 * CarCanvas.H; ++i) {
            g.setColor(deep_back[i] + 191, deep_back[i] + 171, deep_back[i] + 171);
            g.fillRect((x_back[i] + x_shift + random_shift_back[(i + tick) % random_shift_back.length] - CarCanvas.W) % CarCanvas.W + CarCanvas.W, (y_back[i] - CarCanvas.H) % CarCanvas.H + CarCanvas.H, 1, 1);
        }
    }

    public static void update() {
        int i;
        if (++tick % 200 == 0) {
            if ((wind_speed += DevKit.rnd(1) - 1) < -2) {
                wind_speed = -2;
            }
            if (wind_speed > 2) {
                wind_speed = 2;
            }
        }
        for (i = 0; i < 1 * CarCanvas.H / 2; ++i) {
            int n = i;
            y_front[n] = (short)(y_front[n] + (2 + deep_front[i] / 21));
            if (y_front[i] >= CarCanvas.H) {
                Snow.y_front[i] = (short)(y_front[i] % CarCanvas.H);
            }
            Snow.x_front[i] = (short)((x_front[i] + wind_speed * (1 + deep_front[i]) / 32) % CarCanvas.W);
        }
        for (i = 0; i < 1 * CarCanvas.H; ++i) {
            int n = i;
            y_back[n] = (short)(y_back[n] + (1 + deep_back[i] / 32));
            if (y_back[i] >= CarCanvas.H) {
                Snow.y_back[i] = (short)(y_back[i] % CarCanvas.H);
            }
            Snow.x_back[i] = (short)((x_back[i] + wind_speed * (0 + deep_back[i]) / 32) % CarCanvas.W);
        }
    }

    public static void init() {
        int i;
        int a = 64;
        for (i = 0; i < 1 * CarCanvas.H / 2; ++i) {
            Snow.x_front[i] = (short)DevKit.rnd(CarCanvas.W - 1);
            Snow.y_front[i] = (short)DevKit.rnd(CarCanvas.H - 1);
            Snow.deep_front[i] = (byte)Math.abs((DevKit.rnd(2 * a - 1) + DevKit.rnd(2 * a - 1)) / 2 - a);
        }
        for (i = 0; i < 1 * CarCanvas.H; ++i) {
            Snow.x_back[i] = (short)DevKit.rnd(CarCanvas.W);
            Snow.y_back[i] = (short)DevKit.rnd(CarCanvas.H);
            Snow.deep_back[i] = (byte)Math.abs((DevKit.rnd(2 * a) + DevKit.rnd(2 * a)) / 2 - a);
        }
    }
}

