/*
 * Decompiled with CFR 0.152.
 */
package boot;

public class MD5Calculator {
    private static int A = 0;
    private static int B = 0;
    private static int C = 0;
    private static int D = 0;
    private static long[] T = new long[0];
    private static byte[] message = null;
    private static int[] decodedMessage = null;
    private static String data = null;

    public MD5Calculator() {
        MD5Calculator.calculateT();
    }

    public static String calculate(String s) {
        new MD5Calculator();
        data = s;
        message = null;
        MD5Calculator.initializeMDBuffer();
        int[] X = MD5Calculator.getNextMessageBlock();
        int AA = A;
        int BB = B;
        int CC = C;
        int DD = D;
        A = MD5Calculator.FF(A, B, C, D, X[0], 7, 1);
        D = MD5Calculator.FF(D, A, B, C, X[1], 12, 2);
        C = MD5Calculator.FF(C, D, A, B, X[2], 17, 3);
        B = MD5Calculator.FF(B, C, D, A, X[3], 22, 4);
        A = MD5Calculator.FF(A, B, C, D, X[4], 7, 5);
        D = MD5Calculator.FF(D, A, B, C, X[5], 12, 6);
        C = MD5Calculator.FF(C, D, A, B, X[6], 17, 7);
        B = MD5Calculator.FF(B, C, D, A, X[7], 22, 8);
        A = MD5Calculator.FF(A, B, C, D, X[8], 7, 9);
        D = MD5Calculator.FF(D, A, B, C, X[9], 12, 10);
        C = MD5Calculator.FF(C, D, A, B, X[10], 17, 11);
        B = MD5Calculator.FF(B, C, D, A, X[11], 22, 12);
        A = MD5Calculator.FF(A, B, C, D, X[12], 7, 13);
        D = MD5Calculator.FF(D, A, B, C, X[13], 12, 14);
        C = MD5Calculator.FF(C, D, A, B, X[14], 17, 15);
        B = MD5Calculator.FF(B, C, D, A, X[15], 22, 16);
        A = MD5Calculator.GG(A, B, C, D, X[1], 5, 17);
        D = MD5Calculator.GG(D, A, B, C, X[6], 9, 18);
        C = MD5Calculator.GG(C, D, A, B, X[11], 14, 19);
        B = MD5Calculator.GG(B, C, D, A, X[0], 20, 20);
        A = MD5Calculator.GG(A, B, C, D, X[5], 5, 21);
        D = MD5Calculator.GG(D, A, B, C, X[10], 9, 22);
        C = MD5Calculator.GG(C, D, A, B, X[15], 14, 23);
        B = MD5Calculator.GG(B, C, D, A, X[4], 20, 24);
        A = MD5Calculator.GG(A, B, C, D, X[9], 5, 25);
        D = MD5Calculator.GG(D, A, B, C, X[14], 9, 26);
        C = MD5Calculator.GG(C, D, A, B, X[3], 14, 27);
        B = MD5Calculator.GG(B, C, D, A, X[8], 20, 28);
        A = MD5Calculator.GG(A, B, C, D, X[13], 5, 29);
        D = MD5Calculator.GG(D, A, B, C, X[2], 9, 30);
        C = MD5Calculator.GG(C, D, A, B, X[7], 14, 31);
        B = MD5Calculator.GG(B, C, D, A, X[12], 20, 32);
        A = MD5Calculator.HH(A, B, C, D, X[5], 4, 33);
        D = MD5Calculator.HH(D, A, B, C, X[8], 11, 34);
        C = MD5Calculator.HH(C, D, A, B, X[11], 16, 35);
        B = MD5Calculator.HH(B, C, D, A, X[14], 23, 36);
        A = MD5Calculator.HH(A, B, C, D, X[1], 4, 37);
        D = MD5Calculator.HH(D, A, B, C, X[4], 11, 38);
        C = MD5Calculator.HH(C, D, A, B, X[7], 16, 39);
        B = MD5Calculator.HH(B, C, D, A, X[10], 23, 40);
        A = MD5Calculator.HH(A, B, C, D, X[13], 4, 41);
        D = MD5Calculator.HH(D, A, B, C, X[0], 11, 42);
        C = MD5Calculator.HH(C, D, A, B, X[3], 16, 43);
        B = MD5Calculator.HH(B, C, D, A, X[6], 23, 44);
        A = MD5Calculator.HH(A, B, C, D, X[9], 4, 45);
        D = MD5Calculator.HH(D, A, B, C, X[12], 11, 46);
        C = MD5Calculator.HH(C, D, A, B, X[15], 16, 47);
        B = MD5Calculator.HH(B, C, D, A, X[2], 23, 48);
        A = MD5Calculator.II(A, B, C, D, X[0], 6, 49);
        D = MD5Calculator.II(D, A, B, C, X[7], 10, 50);
        C = MD5Calculator.II(C, D, A, B, X[14], 15, 51);
        B = MD5Calculator.II(B, C, D, A, X[5], 21, 52);
        A = MD5Calculator.II(A, B, C, D, X[12], 6, 53);
        D = MD5Calculator.II(D, A, B, C, X[3], 10, 54);
        C = MD5Calculator.II(C, D, A, B, X[10], 15, 55);
        B = MD5Calculator.II(B, C, D, A, X[1], 21, 56);
        A = MD5Calculator.II(A, B, C, D, X[8], 6, 57);
        D = MD5Calculator.II(D, A, B, C, X[15], 10, 58);
        C = MD5Calculator.II(C, D, A, B, X[6], 15, 59);
        B = MD5Calculator.II(B, C, D, A, X[13], 21, 60);
        A = MD5Calculator.II(A, B, C, D, X[4], 6, 61);
        D = MD5Calculator.II(D, A, B, C, X[11], 10, 62);
        C = MD5Calculator.II(C, D, A, B, X[2], 15, 63);
        B = MD5Calculator.II(B, C, D, A, X[9], 21, 64);
        A += AA;
        B += BB;
        C += CC;
        D += DD;
        A = MD5Calculator.convertInt(A);
        B = MD5Calculator.convertInt(B);
        C = MD5Calculator.convertInt(C);
        D = MD5Calculator.convertInt(D);
        String md5sum = new String(MD5Calculator.addZeros(Integer.toHexString(A), 8) + MD5Calculator.addZeros(Integer.toHexString(B), 8) + MD5Calculator.addZeros(Integer.toHexString(C), 8) + MD5Calculator.addZeros(Integer.toHexString(D), 8));
        return md5sum;
    }

    private static void initializeMDBuffer() {
        D = 0;
        C = 0;
        B = 0;
        A = 0;
        A |= 0x67452301;
        B |= 0xEFCDAB89;
        C |= 0x98BADCFE;
        D |= 0x10325476;
    }

    private static int F(int X, int Y, int Z) {
        return X & Y | ~X & Z;
    }

    private static int G(int X, int Y, int Z) {
        return X & Z | Y & ~Z;
    }

    private static int H(int X, int Y, int Z) {
        return X ^ Y ^ Z;
    }

    private static int I(int X, int Y, int Z) {
        return Y ^ (X | ~Z);
    }

    private static int FF(int a, int b, int c, int d, int x, int s, int i) {
        int res = MD5Calculator.F(b, c, d);
        res += x;
        res += (int)T[i - 1];
        res += a;
        res = MD5Calculator.rotateLeft(res, s);
        return res += b;
    }

    private static int GG(int a, int b, int c, int d, int x, int s, int i) {
        int res = a + MD5Calculator.G(b, c, d) + x + (int)T[i - 1];
        res = MD5Calculator.rotateLeft(res, s);
        return res + b;
    }

    private static int HH(int a, int b, int c, int d, int x, int s, int i) {
        int res = a + MD5Calculator.H(b, c, d) + x + (int)T[i - 1];
        res = MD5Calculator.rotateLeft(res, s);
        return res + b;
    }

    private static int II(int a, int b, int c, int d, int x, int s, int i) {
        int res = a + MD5Calculator.I(b, c, d) + x + (int)T[i - 1];
        res = MD5Calculator.rotateLeft(res, s);
        return res + b;
    }

    private static int rotateLeft(int val, int numb) {
        return val << numb | val >>> 32 - numb;
    }

    private static void calculateT() {
        T = new long[64];
        for (int i = 0; i < T.length; ++i) {
            MD5Calculator.T[i] = (long)(4.294967296E9 * Math.abs(Math.sin(i + 1)));
        }
    }

    private static String addZeros(String val, int length) {
        StringBuffer temp = new StringBuffer(val);
        while (temp.length() < length) {
            temp.insert(0, "0");
        }
        return temp.toString();
    }

    public static int[] getNextMessageBlock() {
        int[] res = new int[16];
        message = MD5Calculator.getMessageFromFile();
        decodedMessage = MD5Calculator.decode(message);
        System.arraycopy(decodedMessage, 0, res, 0, 16);
        return res;
    }

    private static byte[] getMessageFromFile() {
        int bytesNumb = data.length();
        byte[] buf = new byte[bytesNumb];
        buf = data.getBytes();
        byte[] appBlock = MD5Calculator.getAppendBlock(bytesNumb);
        byte[] messageLength = MD5Calculator.encode(data.length());
        byte[] res = new byte[bytesNumb + appBlock.length + messageLength.length];
        System.arraycopy(buf, 0, res, 0, bytesNumb);
        System.arraycopy(appBlock, 0, res, bytesNumb, appBlock.length);
        System.arraycopy(messageLength, 0, res, bytesNumb + appBlock.length, messageLength.length);
        return res;
    }

    private static byte[] encode(long mesLength) {
        long mesLengthInBits = mesLength * 8L;
        byte[] res = new byte[8];
        for (int i = 0; i < 8; ++i) {
            res[i] = (byte)(mesLengthInBits >>> i * 8 & 0xFFL);
        }
        return res;
    }

    private static int[] decode(byte[] mes) {
        int[] res = new int[mes.length / 4];
        for (int i = 0; i < res.length; ++i) {
            res[i] = mes[i * 4] & 0xFF | mes[i * 4 + 1] << 8 & 0xFF00 | mes[i * 4 + 2] << 16 & 0xFF0000 | mes[i * 4 + 3] << 24 & 0xFF000000;
        }
        return res;
    }

    private static byte[] getAppendBlock(int length) {
        int p = length % 64;
        boolean firstByte = true;
        int blockLength = p < 56 ? 56 - p : 120 - p;
        byte[] res = new byte[blockLength];
        for (int i = 0; i < res.length; ++i) {
            if (firstByte) {
                firstByte = false;
                res[i] = (byte)(res[i] | 0x80);
                continue;
            }
            res[i] = 0;
        }
        return res;
    }

    public static int convertInt(int val) {
        byte[] t = new byte[4];
        t[3] = (byte)(val & 0xFF);
        t[2] = (byte)(val >>> 8 & 0xFF);
        t[1] = (byte)(val >>> 16 & 0xFF);
        t[0] = (byte)(val >>> 24 & 0xFF);
        int[] res = MD5Calculator.decode(t);
        return res[0];
    }
}

