/*
 * Decompiled with CFR 0.152.
 */
package boot;

import boot.CarM;
import boot.DevKit;
import boot.Menu;
import java.io.InputStream;
import javax.microedition.lcdui.Display;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.midlet.MIDlet;

public class Snd
implements Runnable {
    public static final int TYPE_MIDI = 0;
    public static final int TYPE_AMR = 1;
    public static final int TYPE_WAV = 2;
    private static final int TYPE_COUNT = 1;
    private static final int THREAD_MAIN = 0;
    private static int sndThread;
    private static final String[] typeParam;
    private static final String[] typeExtens;
    private static Player[] sndPlayer;
    private static boolean[] sndRepeat;
    private static int sndCount;
    private static int sndLast;
    private static int sndPlay;
    private static int sndStop;
    private static int sndOnPause;
    private static long sndTimeNext;
    private static boolean sndRun;
    private static boolean sndPause;
    private static boolean isFucked;
    public static Thread tread;
    private static Snd instance;

    public Snd() {
        sndPlay = -1;
        sndStop = -1;
        sndOnPause = -1;
        sndRun = true;
        sndPause = false;
        instance = this;
        sndThread = 0;
        tread = new Thread(instance);
        tread.setPriority(1);
        tread.start();
    }

    public static final void init(String[] fileName, int[] loopCount) {
        sndCount = fileName.length;
        sndPlayer = new Player[sndCount];
        sndRepeat = new boolean[sndCount];
        StringBuffer sndName = new StringBuffer();
        int length = 0;
        for (int i = 0; i < sndCount; ++i) {
            sndName.append(fileName[i]);
            length = sndName.length();
            for (int j = 0; j < 1; ++j) {
                sndName.append(typeExtens[j]);
                if (DevKit.fileExist(sndName.toString())) {
                    try {
                        Snd.sndPlayer[i] = Manager.createPlayer((InputStream)DevKit.getFile(sndName.toString()), (String)typeParam[j]);
                        Snd.sndPlayer[i].realize();
                        sndPlayer[i].prefetch();
                        sndPlayer[i].realize();
                        sndPlayer[i].setLoopCount(loopCount[i]);
                        Snd.sndRepeat[i] = loopCount[i] > 1;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                sndName.setLength(length);
            }
            sndName.setLength(0);
        }
        System.gc();
        sndLast = -1;
        Snd.changeLevel();
    }

    public static final void deInit() {
        sndRun = false;
        sndPause = false;
        for (int i = 0; i < sndCount; ++i) {
            try {
                sndPlayer[i].close();
                Snd.sndPlayer[i] = null;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.gc();
    }

    public static final void play(int index) {
        if (Menu.sndLev > 0) {
            Snd.stop(sndLast);
            sndPlay = index;
        }
    }

    private static final void play() {
        if (sndPlay != -1 && sndTimeNext < System.currentTimeMillis()) {
            try {
                sndPlayer[sndPlay].start();
            }
            catch (Exception e) {
                e.printStackTrace();
                for (int i = 0; i < sndCount; ++i) {
                    try {
                        sndPlayer[i].deallocate();
                        continue;
                    }
                    catch (Exception err) {
                        err.printStackTrace();
                    }
                }
                Thread.yield();
                try {
                    sndPlayer[sndPlay].start();
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
                isFucked = true;
            }
            sndTimeNext = System.currentTimeMillis() + 200L;
            sndLast = sndPlay;
            sndPlay = -1;
        }
    }

    public static final void stop(int index) {
        sndStop = index;
    }

    public static final void stopLast() {
        Snd.stop(sndLast);
    }

    private static final void stop() {
        if (sndStop != -1) {
            try {
                sndPlayer[sndStop].stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                sndPlayer[sndStop].setMediaTime(0L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (isFucked) {
                for (int i = 0; i < sndCount; ++i) {
                    try {
                        sndPlayer[i].deallocate();
                        continue;
                    }
                    catch (Exception err) {
                        err.printStackTrace();
                    }
                }
            }
            sndStop = -1;
            sndLast = -1;
        }
    }

    public void run() {
        while (sndRun) {
            if (Menu.sndLev != 0) {
                Snd.stop();
                if (!sndPause) {
                    Snd.play();
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Thread.yield();
        }
    }

    public static final void pause() {
        sndPause = true;
        if (sndLast != -1 && sndRepeat[sndLast]) {
            sndOnPause = sndLast;
        }
        Snd.stop(sndLast);
        sndPlay = -1;
        Snd.stop();
    }

    public static final void resume() {
        sndPause = false;
        if (sndOnPause != -1) {
            Snd.play(sndOnPause);
            sndOnPause = -1;
        }
    }

    public static final void changeLevel() {
        for (int i = 0; i < sndCount; ++i) {
            try {
                VolumeControl sndVolume = (VolumeControl)sndPlayer[i].getControl("VolumeControl");
                sndVolume.setLevel(Menu.sndLev * 10);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static final void playVibra() {
        if (Menu.vibra) {
            try {
                Display.getDisplay((MIDlet)CarM.instance).vibrate(500);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        typeParam = new String[]{"audio/midi"};
        typeExtens = new String[]{".mid"};
        sndRun = false;
        sndPause = false;
        isFucked = false;
    }
}

