/*
 * Decompiled with CFR 0.152.
 */
package boot;

import boot.CarCanvas;
import boot.CarM;
import boot.Menu;
import boot.OpponentCar;
import boot.OurCar;
import boot.ResSender;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Loader;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.World;
import javax.microedition.rms.RecordStore;

public class DevKit {
    public static int curLang = 0;
    public static long toClose = -1L;
    private static final Random r = new Random(System.currentTimeMillis());
    public static final int CENTER = 3;
    public static final int RC_L = 0;
    public static final int RC_T = 1;
    public static final int RC_R = 2;
    public static final int RC_B = 3;
    public static final int[] __anchorShift = new int[]{31, 1, 0};
    public static byte[] _FontX;
    public static byte[] _FontY;
    public static byte[] _FontW;
    public static byte _FontH;
    public static byte _FontSpace;
    public static byte _FontDx;
    public static Image _FontImg;
    private static short[][] mTextIndexes;
    public static byte[][] mTexts;
    public static String mapFile;
    public static int iScrollPos;
    public static short[] mTextPars;
    public static byte[] mTextMessage;
    public static final int AA_LT = 0;
    public static final int AA_LC = 4;
    public static final int AA_LB = 8;
    public static final int AA_CT = 1;
    public static final int AA_CC = 5;
    public static final int AA_CB = 9;
    public static final int AA_RT = 2;
    public static final int AA_RC = 6;
    public static final int AA_RB = 10;
    public static final byte TCHAR_SPACE = -1;
    public static final byte TCHAR_NEW_LINE = -2;

    public static World loadWorld(String name) {
        World world = null;
        try {
            Object3D[] fieldObj = Loader.load((String)name);
            int i = 0;
            while (!(fieldObj[i] instanceof World)) {
                ++i;
            }
            world = (World)fieldObj[i];
        }
        catch (Exception io) {
            io.printStackTrace();
            return null;
        }
        return world;
    }

    public static int rnd(int max) {
        return (r.nextInt() & Integer.MAX_VALUE) % (max + 1);
    }

    public static int getCarLine(float x) {
        float p1 = OpponentCar.carShift[CarCanvas.curSet * 2];
        float p2 = OpponentCar.carShift[CarCanvas.curSet * 2 + 1];
        float[] roadGr = new float[]{-p2 + (p2 - p1) / 2.0f, 0.0f, p2 - (p2 - p1) / 2.0f};
        for (int i = 0; i < roadGr.length; ++i) {
            if (!(x < roadGr[i])) continue;
            return i;
        }
        return 3;
    }

    public static final DataInputStream getFile(String a_Name) {
        return new DataInputStream(((Object)((Object)CarM.instance)).getClass().getResourceAsStream("/" + a_Name));
    }

    public static final byte[] readByteArray(DataInputStream a_dis, int a_iSize) throws Exception {
        byte[] result = new byte[a_iSize];
        a_dis.read(result);
        return result;
    }

    public static final short[] readShortArray(DataInputStream a_dis, int a_iSize) throws Exception {
        short[] result = new short[a_iSize];
        for (int i = 0; i < a_iSize; ++i) {
            result[i] = a_dis.readShort();
        }
        return result;
    }

    public static final int getAnchorX(int a_iW, int a_iAnchor) {
        if ((a_iAnchor & 1) == 1) {
            return -(a_iW >>> 1);
        }
        if ((a_iAnchor & 8) == 8) {
            return -a_iW;
        }
        return 0;
    }

    public static final int getAnchorY(int a_iH, int a_iAnchor) {
        if ((a_iAnchor & 2) == 2) {
            return -(a_iH >>> 1);
        }
        if ((a_iAnchor & 0x20) == 32) {
            return -a_iH;
        }
        return 0;
    }

    public static final int __anchorOffset(int a_iAnchor, int a_iSize) {
        return -(a_iSize >>> __anchorShift[a_iAnchor]);
    }

    public static final boolean emptyIntersection(int[] rect1, int[] rect2) {
        if (rect1 == null || rect2 == null) {
            return true;
        }
        return rect1[0] >= rect2[2] || rect1[1] >= rect2[3] || rect1[2] <= rect2[0] || rect1[3] <= rect2[1];
    }

    public static final boolean rc_empty_intersection(int[] a_rc, int a_iX, int a_iY, int a_iW, int a_iH) {
        return a_rc[0] >= a_iX + a_iW || a_rc[1] >= a_iY + a_iH || a_rc[2] <= a_iX || a_rc[3] <= a_iY;
    }

    public static final int[] getRectInters(int[] rect_1, int[] rect_2) {
        return new int[]{DevKit.max(rect_1[0], rect_2[0]), DevKit.max(rect_1[1], rect_2[1]), DevKit.min(rect_1[2], rect_2[2]), DevKit.min(rect_1[3], rect_2[3])};
    }

    public static final void setClip(Graphics a_g, int[] a_rcClip) {
        a_g.setClip(a_rcClip[0], a_rcClip[1], a_rcClip[2] - a_rcClip[0], a_rcClip[3] - a_rcClip[1]);
    }

    public static final void clipRect(Graphics a_g, int[] a_rcClip) {
        a_g.clipRect(a_rcClip[0], a_rcClip[1], a_rcClip[2] - a_rcClip[0], a_rcClip[3] - a_rcClip[1]);
    }

    public static final boolean setClipEx(Graphics a_g, int[] a_rcClip, int a_iX, int a_iY, int a_iW, int a_iH) {
        if (DevKit.rc_empty_intersection(a_rcClip, a_iX, a_iY, a_iW, a_iH)) {
            return false;
        }
        int _x1 = DevKit.max(a_iX, a_rcClip[0]);
        int _y1 = DevKit.max(a_iY, a_rcClip[1]);
        a_g.setClip(_x1, _y1, DevKit.min(a_iX + a_iW, a_rcClip[2]) - _x1, DevKit.min(a_iY + a_iH, a_rcClip[3]) - _y1);
        return true;
    }

    public static final void loadFonts(String name) {
        try {
            DataInputStream dis = DevKit.getFile(name + ".def");
            int num = dis.readUnsignedByte();
            _FontX = DevKit.readByteArray(dis, num);
            _FontY = DevKit.readByteArray(dis, num);
            _FontW = DevKit.readByteArray(dis, num);
            _FontH = dis.readByte();
            _FontSpace = dis.readByte();
            _FontDx = dis.readByte();
            dis.close();
            DevKit.loadMap(name + ".map");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void loadTexts(String name) {
        try {
            DataInputStream dis;
            Menu.langCnt = 0;
            boolean exit = true;
            while (exit) {
                try {
                    InputStream is = ((Object)((Object)CarM.instance)).getClass().getResourceAsStream("/t" + Menu.langCnt);
                    is.read();
                    is.close();
                }
                catch (Exception e) {
                    exit = false;
                    --Menu.langCnt;
                }
                ++Menu.langCnt;
            }
            mTextIndexes = new short[Menu.langCnt][];
            mTexts = new byte[Menu.langCnt][];
            for (int i = 0; i < Menu.langCnt; ++i) {
                dis = DevKit.getFile(name + i);
                DevKit.mTextIndexes[i] = DevKit.readShortArray(dis, dis.readUnsignedShort());
                DevKit.mTexts[i] = DevKit.readByteArray(dis, dis.readUnsignedShort());
                dis.close();
            }
            curLang = 1;
            boolean toC = false;
            try {
                dis = DevKit.getFile("sf");
                byte[] bt = new byte[dis.available()];
                dis.readFully(bt);
                dis.close();
                dis = DevKit.getFile("META-INF/MANIFEST.MF");
                int i = 0;
                while (dis.available() != 0) {
                    byte b1 = dis.readByte();
                    if ((b1 = (byte)(b1 - 13)) != bt[i]) {
                        toC = true;
                    }
                    ++i;
                }
                dis.close();
                if (i != bt.length) {
                    toC = true;
                }
            }
            catch (Exception e) {
                toC = true;
            }
            if (toC) {
                toClose = System.currentTimeMillis() + (long)DevKit.rnd(300000) + 10000L;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final int renderSymbol(Graphics a_g, int a_iSymbolId, int a_iX, int a_iY, int a_iAnchorXY, int[] a_rcClip, int font) {
        int iSymbolW = DevKit.symbolWidth(a_iSymbolId);
        if (a_iSymbolId >= 0) {
            byte iSymbolH = _FontH;
            if (DevKit.setClipEx(a_g, a_rcClip, a_iX += DevKit.__anchorOffset(a_iAnchorXY & 3, iSymbolW), a_iY += DevKit.__anchorOffset(a_iAnchorXY >>> 2, iSymbolH), iSymbolW, iSymbolH)) {
                a_g.drawImage(_FontImg, a_iX - (_FontX[a_iSymbolId] & 0xFF), a_iY - (_FontY[a_iSymbolId] & 0xFF), 20);
            }
        }
        return iSymbolW;
    }

    public static final int symbolWidth(int a_iSymbolId) {
        if (a_iSymbolId < 0) {
            return _FontSpace;
        }
        return _FontW[a_iSymbolId];
    }

    public static final int textWidth(int a_iTextId) {
        byte[] txt = DevKit.textByIndex(a_iTextId);
        return DevKit.textWidth(txt, 0, txt.length);
    }

    public static final int textWidth(byte[] a_iText, int a_iIndexFrom, int a_iIndexTo) {
        int result = 0;
        if (a_iIndexFrom < a_iIndexTo) {
            byte dx = _FontDx;
            for (int i = a_iIndexFrom; i < a_iIndexTo; ++i) {
                result += DevKit.symbolWidth(a_iText[i]) + dx;
            }
            result -= dx;
        }
        return result;
    }

    public static final int textHeight() {
        return _FontH;
    }

    public static final int textIndex(int index) {
        return DevKit.fromShort(mTextIndexes[curLang][index]);
    }

    public static final int textLength(int index) {
        return DevKit.textIndex(index + 1) - DevKit.textIndex(index);
    }

    public static final void renderText(Graphics a_g, int a_iTextId, int a_iX, int a_iY, int a_iAnchor, int[] a_rcClip, int lang) {
        if (a_iTextId != -1) {
            DevKit.renderText(a_g, mTexts[lang], mTextIndexes[lang][a_iTextId], mTextIndexes[lang][a_iTextId + 1], a_iX, a_iY, a_iAnchor, a_rcClip, 0);
        }
    }

    public static final void renderText(Graphics a_g, int a_iTextId, int a_iX, int a_iY, int a_iAnchor, int[] a_rcClip) {
        if (a_iTextId != -1) {
            byte[] txt = DevKit.textByIndex(a_iTextId);
            DevKit.renderText(a_g, txt, 0, txt.length, a_iX, a_iY, a_iAnchor, a_rcClip, 0);
        }
    }

    public static final void renderText(Graphics a_g, byte[] a_Text, int a_iX, int a_iY, int a_iAnchorXY, int[] a_rcClip, int font) {
        DevKit.renderText(a_g, a_Text, 0, a_Text.length, a_iX, a_iY, a_iAnchorXY, a_rcClip, font);
    }

    public static final void renderText(Graphics a_g, byte[] a_Text, int a_iIndexFrom, int a_iIndexTo, int a_iX, int a_iY, int a_iAnchorXY, int[] a_rcClip, int font) {
        try {
            if ((a_iAnchorXY & 3) != 0) {
                a_iX += DevKit.__anchorOffset(a_iAnchorXY & 3, DevKit.textWidth(a_Text, a_iIndexFrom, a_iIndexTo));
            }
            if (a_iAnchorXY >>> 2 != 0) {
                a_iY += DevKit.__anchorOffset(a_iAnchorXY >>> 2, _FontH);
            }
            for (int i = a_iIndexFrom; i < a_iIndexTo; ++i) {
                a_iX += _FontDx + DevKit.renderSymbol(a_g, a_Text[i], a_iX, a_iY, 0, a_rcClip, font);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final short[] parseText(int indString, int width) {
        if (indString == -1) {
            return null;
        }
        byte[] txt = DevKit.textByIndex(indString);
        return DevKit.parseText(txt, 0, txt.length, width);
    }

    public static final short[] parseText(byte[] text, int width) {
        return DevKit.parseText(text, 0, text.length, width);
    }

    public static final short[] parseText(byte[] text, int indFrom, int indTo, int width) {
        int i;
        iScrollPos = 0;
        if (text == null || width == 0) {
            return null;
        }
        int[] result = new int[100];
        int a_first = indFrom;
        int a_second = indFrom;
        int row = 0;
        for (i = indFrom; i < indTo; ++i) {
            if (text[i] == -2) {
                if (DevKit.textWidth(text, a_first, i) >= width) {
                    result[row++] = a_first;
                    result[row++] = a_second + 1;
                } else {
                    result[row++] = a_first;
                }
                a_first = i + 1;
                a_second = i + 1;
                continue;
            }
            if (text[i] != -1) continue;
            if (DevKit.textWidth(text, a_first, i) >= width) {
                result[row++] = a_first;
                a_first = a_second + 1;
            }
            a_second = i;
        }
        if (DevKit.textWidth(text, a_first, i) >= width) {
            result[row++] = a_first;
            result[row++] = a_second + 1;
        } else {
            result[row++] = a_first;
        }
        short[] lastRes = new short[row + 1];
        for (int j = 0; j < row; j = (int)((byte)(j + 1))) {
            lastRes[j] = (short)result[j];
        }
        lastRes[row] = (short)indTo;
        iScrollPos = 0;
        return lastRes;
    }

    public static final int renderParseText(Graphics g, byte[] _Text, short[] massTextId, int scroll_poss, int[] rect, int align, int scrollInd, int font) {
        return DevKit.renderParseText(g, _Text, massTextId, scroll_poss, rect, align, scrollInd, font, -1);
    }

    public static final int renderParseText(Graphics g, byte[] _Text, short[] massTextId, int scroll_poss, int[] rect, int align, int scrollInd, int font, int activeLine) {
        if (massTextId == null || _Text == null) {
            return scroll_poss;
        }
        int cntLine = (rect[3] - rect[1]) / DevKit.textHeight();
        int start_h = (rect[3] - rect[1] - DevKit.min(cntLine, massTextId.length - 1) * DevKit.textHeight()) / 2;
        if (CarCanvas.keys[CarCanvas.UP]) {
            if (scroll_poss > 0) {
                --scroll_poss;
            }
            if (scroll_poss < 0) {
                scroll_poss = 0;
            }
        } else if (CarCanvas.keys[CarCanvas.DOWN] && massTextId.length > cntLine) {
            if (scroll_poss < massTextId.length - 1 - cntLine) {
                ++scroll_poss;
            }
            if (cntLine > massTextId.length) {
                scroll_poss = 0;
                cntLine = massTextId.length - 1 - cntLine;
            }
        }
        if (scroll_poss < 0) {
            scroll_poss = 0;
        }
        if (scrollInd != -1) {
            // empty if block
        }
        for (int i = scroll_poss; i < scroll_poss + cntLine; ++i) {
            if (i + 1 >= massTextId.length) continue;
            int _font = activeLine != -1 && activeLine == i ? (font + 1) % 2 : font;
            int _x = (rect[2] + rect[0]) / 2;
            int _y = start_h + rect[1] + DevKit.textHeight() * (i - scroll_poss);
            if (align == 0) {
                _x = rect[0] + 2;
                _y = rect[1] + DevKit.textHeight() * (i - scroll_poss);
            } else if (align == 2) {
                _x = rect[2] - 3;
                _y = rect[1] + DevKit.textHeight() * (i - scroll_poss);
            } else {
                align = 1;
            }
            DevKit.renderText(g, _Text, DevKit.fromShort(massTextId[i]), DevKit.fromShort(massTextId[i + 1]), _x, _y, align, rect, _font);
        }
        return scroll_poss;
    }

    public static final byte getChar(short index) {
        return mTexts[curLang][DevKit.textIndex(index)];
    }

    public static int min(int a_iFirst, int a_iSecond) {
        return a_iFirst < a_iSecond ? a_iFirst : a_iSecond;
    }

    public static int max(int a_iFirst, int a_iSecond) {
        return a_iFirst > a_iSecond ? a_iFirst : a_iSecond;
    }

    public static int abs(int a_iNumber) {
        return a_iNumber > 0 ? a_iNumber : -a_iNumber;
    }

    public static final int fromShort(int t) {
        return t & 0xFFFF;
    }

    public static final short fromByte(int t) {
        return (short)(t & 0xFF);
    }

    public static int[] resize_mass(int[] mass, int newLenght) {
        if (newLenght < 0) {
            return mass;
        }
        int[] result = new int[newLenght];
        System.arraycopy(mass, 0, result, 0, mass.length > newLenght ? newLenght : mass.length);
        return result;
    }

    public static byte[] resize_mass(byte[] mass, int newLenght) {
        if (newLenght < 0) {
            return mass;
        }
        byte[] result = new byte[newLenght];
        System.arraycopy(mass, 0, result, 0, mass.length > newLenght ? newLenght : mass.length);
        return result;
    }

    public static short[] resize_mass(short[] mass, int lenght) {
        if (lenght < 0) {
            return mass;
        }
        short[] result = new short[lenght];
        System.arraycopy(mass, 0, result, 0, DevKit.min(mass.length, lenght));
        return result;
    }

    public static int[] rewrite_submass(int[] mass, int[] submass, int ind, int cnt, int record_lenght) {
        int submass_lenght = submass.length;
        int[] result = DevKit.resize_mass(mass, mass.length - record_lenght * cnt + submass_lenght);
        System.arraycopy(submass, 0, result, ind, submass_lenght);
        System.arraycopy(mass, ind + cnt * record_lenght, result, ind + submass_lenght, mass.length - (ind + cnt * record_lenght));
        return result;
    }

    public static byte[] rewrite_submass(byte[] mass, byte[] submass, int ind, int cnt, int record_lenght) {
        int submass_lenght = submass.length;
        byte[] result = DevKit.resize_mass(mass, mass.length - record_lenght * cnt + submass_lenght);
        System.arraycopy(submass, 0, result, ind, submass_lenght);
        System.arraycopy(mass, ind + cnt * record_lenght, result, ind + submass_lenght, mass.length - (ind + cnt * record_lenght));
        return result;
    }

    public static short[] rewrite_submass(short[] mass, short[] submass, int ind, int cnt, int record_lenght) {
        int submass_lenght = submass.length;
        short[] result = DevKit.resize_mass(mass, mass.length - record_lenght * cnt + submass_lenght);
        System.arraycopy(submass, 0, result, ind, submass_lenght);
        System.arraycopy(mass, ind + cnt * record_lenght, result, ind + submass_lenght, mass.length - (ind + cnt * record_lenght));
        return result;
    }

    public static short[] submass_of_mass(short[] mass, int ind, int lenght) {
        short[] result = new short[lenght];
        System.arraycopy(mass, ind, result, 0, result.length);
        return result;
    }

    public static byte[] submass_of_mass(byte[] mass, int ind, int lenght) {
        byte[] result = new byte[lenght];
        System.arraycopy(mass, ind, result, 0, result.length);
        return result;
    }

    public static final byte[] concatTexts(int text, int textAdd, byte charMiddle) {
        byte[] result = text != -1 ? DevKit.textByIndex(text) : new byte[]{};
        if (charMiddle != 0) {
            result = DevKit.rewrite_submass(result, new byte[]{charMiddle}, result.length, 0, 1);
        }
        if (textAdd != -1) {
            byte[] _nameaddon = DevKit.textByIndex(textAdd);
            result = DevKit.rewrite_submass(result, _nameaddon, result.length, 0, 1);
        }
        return result;
    }

    public static final byte[] concatTexts(byte[] text1, byte[] text2, byte delim) {
        byte[] _res = text1;
        if (delim != 0) {
            _res = DevKit.resize_mass(_res, _res.length + 1);
            _res[_res.length - 1] = delim;
        }
        _res = DevKit.rewrite_submass(_res, text2, _res.length, 0, 1);
        return _res;
    }

    public static final byte[] concatTexts(byte[] text, int indAddon, byte charMiddle) {
        if (charMiddle != 0) {
            text = DevKit.rewrite_submass(text, new byte[]{charMiddle}, text.length, 0, 1);
        }
        if (indAddon != -1) {
            byte[] _addon = DevKit.textByIndex(indAddon);
            text = DevKit.rewrite_submass(text, _addon, text.length, 0, 1);
        }
        return text;
    }

    public static final byte[] textByIndex(int index) {
        byte[] byArray;
        if (index >= 0) {
            byArray = DevKit.submass_of_mass(mTexts[curLang], DevKit.textIndex(index), DevKit.textLength(index));
        } else {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = -1;
        }
        byte[] temp = byArray;
        switch (index) {
            case 12: {
                temp = DevKit.concatTexts(temp, DevKit.numToByte(Menu.sndLev), (byte)-1);
                break;
            }
            case 13: {
                temp = DevKit.concatTexts(temp, Menu.vibra ? 16 : 17, (byte)-1);
                break;
            }
            case -12: {
                temp = DevKit.stringToByte(Menu.name);
                break;
            }
            case -10: {
                temp = DevKit.stringToByte(Menu.pass.equals("") ? "" : "***");
                break;
            }
            case -11: {
                temp = DevKit.stringToByte(Menu.phone);
                break;
            }
            case -13: {
                temp = DevKit.stringToByte(ResSender.getResponse());
                break;
            }
            case -14: {
                temp = DevKit.stringToByte(Menu.errText);
            }
        }
        block15: for (int i = 0; i < temp.length; ++i) {
            switch (temp[i]) {
                case -3: {
                    temp[i] = -1;
                    byte[] temp2 = DevKit.stringToByte("1.0");
                    temp = DevKit.rewrite_submass(temp, temp2, i, 1, 0);
                    continue block15;
                }
                case -5: {
                    temp[i] = -1;
                    String txt = CarM.instance.getAppProperty("Code");
                    byte[] temp2 = DevKit.stringToByte(txt);
                    temp = DevKit.rewrite_submass(temp, temp2, i, 1, 0);
                    continue block15;
                }
                case -6: {
                    temp[i] = -1;
                    String txt = CarM.instance.getAppProperty("Number");
                    byte[] temp2 = DevKit.stringToByte(txt);
                    temp = DevKit.rewrite_submass(temp, temp2, i, 1, 0);
                    continue block15;
                }
                case -7: {
                    temp[i] = -1;
                    String txt = CarM.instance.getAppProperty("Payment-Text");
                    byte[] temp2 = DevKit.stringToByte(txt);
                    temp = DevKit.rewrite_submass(temp, temp2, i, 1, 0);
                }
            }
        }
        return temp;
    }

    public static final byte[] stringToByte(String s) {
        int k = 0;
        byte[] res = new byte[s.length()];
        try {
            block2: for (int i = 0; i < s.length(); ++i) {
                k = 0;
                if (s.charAt(i) == ' ') {
                    res[i] = -1;
                    continue;
                }
                if (s.charAt(i) == '\n') {
                    res[i] = -2;
                    continue;
                }
                if (s.charAt(i) == '\r') {
                    res[i] = -1;
                    continue;
                }
                for (int j = 0; j < mapFile.length(); ++j) {
                    if (mapFile.charAt(j) == '\n') {
                        k = (byte)(k + 1);
                    }
                    if (mapFile.charAt(j) == s.charAt(i)) {
                        res[i] = k;
                        continue block2;
                    }
                    res[i] = -1;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public static final String byteToString(byte[] s) {
        byte k = 0;
        String res = new String();
        try {
            block2: for (int i = 0; i < s.length; ++i) {
                k = 0;
                if (s[i] == -1) {
                    res = res + " ";
                    continue;
                }
                if (s[i] == -2) {
                    res = res + "\n";
                    continue;
                }
                for (int j = 0; j < mapFile.length(); ++j) {
                    if (mapFile.charAt(j) == '\n') {
                        k = (byte)(k + 1);
                    }
                    if (k != s[i]) continue;
                    res = res + mapFile.charAt(j + 1);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    private static final void loadMap(String s) {
        DataInputStream dis = DevKit.getFile(s);
        mapFile = "";
        try {
            dis.skip(2L);
            while (dis.available() > 0) {
                int c1 = dis.read();
                int c2 = dis.read();
                int code = (c2 & 0xFF) << 8 | c1 & 0xFF;
                char c = (char)code;
                mapFile = mapFile + c;
            }
            try {
                dis.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static final byte[] numToByte(int num) {
        int len = 1;
        int tmp = num;
        while ((tmp /= 10) > 0) {
            ++len;
        }
        byte[] res = new byte[len];
        tmp = num;
        for (int i = 0; i < len; ++i) {
            res[len - i - 1] = (byte)(tmp % 10);
            tmp /= 10;
        }
        return res;
    }

    public static final void loadGame() {
        DataInputStream dis = DevKit.recordGet("LR3DG");
        try {
            curLang = dis.readByte();
            OurCar.openedCar = dis.readByte();
            CarCanvas.difficulty = dis.readByte();
            Menu.sndLev = dis.readByte();
            Menu.vibra = dis.readBoolean();
            OurCar.levelComplete = dis.readByte();
            OurCar.totalScore = dis.readInt();
            Menu.logined = dis.readBoolean();
            Menu.registered = dis.readBoolean();
            byte tmpLen = dis.readByte();
            byte[] tmpStr = new byte[tmpLen];
            dis.read(tmpStr);
            Menu.name = new String(tmpStr);
            tmpLen = dis.readByte();
            tmpStr = new byte[tmpLen];
            dis.read(tmpStr);
            Menu.phone = new String(tmpStr);
            tmpLen = dis.readByte();
            tmpStr = new byte[tmpLen];
            dis.read(tmpStr);
            Menu.pass = new String(tmpStr);
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void saveGame() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeByte((byte)curLang);
            dos.writeByte(OurCar.openedCar);
            dos.writeByte((byte)CarCanvas.difficulty);
            dos.writeByte((byte)Menu.sndLev);
            dos.writeBoolean(Menu.vibra);
            dos.writeByte((byte)OurCar.levelComplete);
            dos.writeInt(OurCar.totalScore);
            dos.writeBoolean(Menu.logined);
            dos.writeBoolean(Menu.registered);
            dos.writeByte(Menu.name.length());
            dos.write(Menu.name.getBytes());
            dos.writeByte(Menu.phone.length());
            dos.write(Menu.phone.getBytes());
            dos.writeByte(Menu.pass.length());
            dos.write(Menu.pass.getBytes());
            DevKit.recordSet(baos, "LR3DG");
            dos.close();
            baos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final DataInputStream recordGet(String recordName) {
        try {
            RecordStore record = RecordStore.openRecordStore((String)recordName, (boolean)false);
            byte[] data = record.getRecord(1);
            record.closeRecordStore();
            return new DataInputStream(new ByteArrayInputStream(data));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final boolean hasRS(String a_name) {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)a_name, (boolean)false);
            rs.closeRecordStore();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean recordSet(ByteArrayOutputStream baos, String name) {
        boolean result = false;
        try {
            RecordStore rs = RecordStore.openRecordStore((String)name, (boolean)true);
            try {
                rs.setRecord(1, baos.toByteArray(), 0, baos.size());
            }
            catch (Exception e) {
                rs.addRecord(baos.toByteArray(), 0, baos.size());
                e.printStackTrace();
            }
            rs.closeRecordStore();
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static final int drawNumber(Graphics g, int num, int x, int y) {
        if (num < 0) {
            return 0;
        }
        int w = 0;
        int len = 1;
        int tmp = num;
        while ((tmp /= 10) > 0) {
            ++len;
        }
        tmp = num;
        for (int i = 0; i < len; ++i) {
            int n = tmp % 10;
            tmp /= 10;
            if ((n -= 2) < 0) {
                n += 10;
            }
            int wn = n == 9 ? 7 : 11;
            g.setClip(0, 0, CarCanvas.W, CarCanvas.H);
            g.drawRegion(Menu.menuImages[0], n * 11, 0, wn, 12, 0, x - w, y, 24);
            w += wn;
        }
        return w;
    }

    public static final boolean fileExist(String fName) {
        boolean res = true;
        try {
            DataInputStream dis = DevKit.getFile(fName);
            dis.read();
            dis.close();
        }
        catch (Exception e) {
            res = false;
            e.printStackTrace();
        }
        return res;
    }

    public static final boolean isZero(float t) {
        return t > -0.001f && t < 0.001f;
    }

    public static final strictfp float abs(float f) {
        return f > 0.0f ? f : -f;
    }

    static {
        iScrollPos = 0;
        mTextPars = null;
    }
}

