/*
 * Decompiled with CFR 0.152.
 */
package boot;

import boot.All3D;
import boot.CarCanvas;
import boot.CarManager;
import boot.DevKit;
import boot.OurCar;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Transform;

public class OpponentCar {
    public static float[] matrix = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    public static float[] carShift = new float[]{0.6f, 2.0f, 0.6f, 2.0f, 0.8f, 1.9f};
    public static int[][] allCarEng = new int[][]{{0, 160, 300, 400, 480, 540}, {0, 160, 300, 400, 480, 540}, {0, 160, 300, 400, 480, 540}, {0, 160, 300, 400, 480, 540}};
    public static int[] allCarWeith = new int[]{100, 140, 150, 200};
    public static boolean[] pointers = new boolean[8];
    private Transform tr = new Transform();
    public boolean effectLob = false;
    public int effectHeith = 0;
    public byte posInArray;
    public byte model;
    public float pos = -3.0f;
    public int dir = -1;
    public Group car;
    public float speed = 0.0f;
    public float speedX = 0.0f;
    public float speedY = 0.0f;
    public float rotForce = 0.0f;
    public static float C_AIR = 0.4257f;
    public float C_GND;
    public static float C_WALL = 112.8f;
    public float engForce = 0.0f;
    public float engForceX = 0.0f;
    public float engForceY = 0.0f;
    public int[] engMAX = new int[]{0, 150, 350, 500, 800};
    public float[] speedMAX = new float[6];
    public int curPer = 1;
    public float WEITH;
    public float HEITH;
    public float WIDTH;
    public float x;
    public float y;
    public float z;
    public boolean dead = false;
    public int toRotate = -1;
    public boolean bEffect = false;
    private int iEffectCounter = 0;
    public int hitedBy = -2;
    public int checkCounter = 0;
    boolean[] collis = new boolean[CarManager.carCnt];

    public OpponentCar(byte model, byte pos) {
        this.WEITH = allCarWeith[model - 1];
        this.C_GND = 12.8f * this.WEITH / 100.0f;
        this.engMAX = allCarEng[model - 1];
        this.setSpeedMax();
        this.car = All3D.makeCar(model, -1);
        this.WIDTH = OurCar.WH[model * 2 - 2];
        this.HEITH = OurCar.WH[model * 2 - 1];
        All3D.world.addChild((Node)this.car);
        this.car.getTransform(this.tr);
        this.x = 10.0f;
        this.y = 100.0f;
        this.car.setTranslation(10.0f, 0.0f, 100.0f);
        this.model = model;
        this.posInArray = pos;
    }

    public final void setSpeedMax() {
        this.speedMAX[0] = 0.0f;
        for (int i = 1; i < this.engMAX.length; ++i) {
            float a = C_AIR;
            float b = this.C_GND;
            float c = -this.engMAX[i];
            this.speedMAX[i] = (float)(((double)(-b) + Math.sqrt(b * b - 4.0f * a * c)) / 2.0 / (double)a);
        }
    }

    public final void update(float ourX) {
        ++this.checkCounter;
        this.checkCounter %= 10;
        if (this.dead) {
            this.y += ourX;
            this.car.translate(0.0f, 0.0f, ourX);
            this.checkRespawn();
            return;
        }
        if (this.toRotate != -1) {
            float f = this.engForceY = this.toRotate == 2 ? (float)this.engMAX[this.curPer - 1] : (float)(-this.engMAX[this.curPer - 1]);
            if (this.toRotate == 2) {
                if (this.x > carShift[CarCanvas.curSet * 2 + 1]) {
                    this.speedY = 0.0f;
                    this.engForceY = 0.0f;
                    this.toRotate = -1;
                }
            } else if (this.x < carShift[CarCanvas.curSet * 2]) {
                this.speedY = 0.0f;
                this.engForceY = 0.0f;
                this.toRotate = -1;
            }
        }
        if (!DevKit.isZero(this.speedY) && this.toRotate == -1 && !this.bEffect) {
            this.engForceY += this.speedY > 0.0f ? (float)(-this.engMAX[this.curPer] / 10) : (float)(this.engMAX[this.curPer] / 10);
            this.speedY -= this.speedY / 100.0f;
            if (DevKit.isZero(this.speedY)) {
                this.speedY = 0.0f;
                this.engForceY = 0.0f;
            }
        }
        if (this.bEffect) {
            this.engForceY = 0.0f;
        }
        this.engForceX += 5.0f;
        if (DevKit.abs(this.speed - this.speedMAX[this.curPer]) < 0.1f && this.curPer < this.engMAX.length - 1) {
            this.speed = this.speedMAX[this.curPer++];
        }
        this.engForce = (float)Math.sqrt(this.engForceX * this.engForceX + this.engForceY * this.engForceY);
        if (this.engForceX > (float)this.engMAX[this.curPer]) {
            this.engForceX = this.engMAX[this.curPer];
        }
        if ((double)this.speed > (double)this.speedMAX[this.curPer] - 0.05 && this.curPer < this.speedMAX.length - 1) {
            this.engForceX = 0.0f;
        }
        float gndCoef = this.checkBorder();
        float acX = (this.engForceX - C_AIR * this.speedX * this.speed - gndCoef * this.speedX) / this.WEITH;
        float acY = (this.engForceY - C_AIR * this.speedY * this.speed - gndCoef * this.speedY) / this.WEITH;
        if (!DevKit.isZero(this.rotForce) && !DevKit.isZero(this.speed)) {
            this.car.postRotate(this.rotForce, 0.0f, 1.0f, 0.0f);
        }
        float dt = OurCar.dt;
        this.speedX += dt * acX / 1000.0f;
        this.speedY += dt * acY / 1000.0f;
        this.speed = (float)Math.sqrt(this.speedX * this.speedX + this.speedY * this.speedY);
        float dx = dt * this.speedX / 1000.0f;
        float dy = dt * this.speedY / 1000.0f;
        this.x += dy;
        this.y += ourX - dx * (float)this.dir;
        this.car.translate(dy, 0.0f, ourX - dx * (float)this.dir);
        if (!DevKit.isZero(this.speed)) {
            float cos;
            float sin = this.speedY / this.speed;
            OpponentCar.matrix[0] = cos = this.speedX / this.speed * (float)this.dir;
            OpponentCar.matrix[2] = -sin;
            OpponentCar.matrix[8] = sin;
            OpponentCar.matrix[10] = cos;
            this.tr.setIdentity();
            this.tr.set(matrix);
            this.car.setTransform(this.tr);
        }
        this.checkPointers();
        if (this.checkCounter == 0) {
            this.checkRespawn();
            this.checkAI();
        }
        this.checkEffect();
    }

    public final void resetCar() {
        this.car.setOrientation(0.0f, 0.0f, 0.0f, 0.0f);
        this.y = 100.0f;
        this.car.setTranslation(0.0f, 0.0f, this.y);
        All3D.setCarElement(this.car, 0, true);
        All3D.setCarElement(this.car, 3, false);
        All3D.setCarElement(this.car, 1, true);
        if (CarCanvas.isNight) {
            All3D.setCarElement(this.car, 2, true);
            All3D.setCarElement(this.car, 4, true);
        }
    }

    private final void checkAI() {
        boolean canRot = true;
        boolean needRot = false;
        float speedDec = 0.0f;
        if (this.dead) {
            return;
        }
        int ourLine = DevKit.getCarLine(this.x);
        if (DevKit.isZero(this.speedY)) {
            for (int i = 0; i < CarManager.carCnt; ++i) {
                if (i == this.posInArray || this.dir != 1 || CarManager.cars[i].dir != 1) continue;
                float oppSp = CarManager.cars[i].speedX;
                float oppY = CarManager.cars[i].y;
                int lineOpp = DevKit.getCarLine(CarManager.cars[i].x);
                if (lineOpp == ourLine) {
                    if (!(CarManager.cars[i].y < this.y) || !(oppSp < this.speedX) || !((this.speedX - oppSp) * 2.0f > this.y - oppY)) continue;
                    needRot |= true;
                    if (this.speedX - oppSp > this.y - oppY) {
                        canRot &= false;
                    }
                    speedDec = Math.max(this.speedX - oppSp, oppSp);
                    continue;
                }
                if (DevKit.abs(lineOpp - ourLine) != 1) continue;
                if (DevKit.abs(oppY - this.y) < 3.0f) {
                    canRot &= false;
                    continue;
                }
                if (oppY > this.y && oppY - oppSp * 2.0f > this.y + 2.0f || oppY < this.y && oppY - oppSp * 2.0f < this.y - 2.0f) {
                    canRot &= true;
                    continue;
                }
                canRot &= false;
            }
        }
        if (needRot) {
            if (!canRot) {
                this.speedX -= speedDec / 2.0f;
                this.engForceX -= this.engForceX / 30.0f;
            } else {
                this.toRotate = ourLine;
            }
        }
    }

    private final strictfp float checkBorder() {
        float border = 3.0f - this.WIDTH;
        if (Math.abs(this.x) > border) {
            if (this.speed > this.speedMAX[2]) {
                if (!this.bEffect) {
                    this.setEffect();
                    All3D.newEff(this.posInArray, 0);
                    this.speedY = -this.speedY;
                    this.engForceY = -this.engForceY;
                    if (this.hitedBy == -1) {
                        OurCar.score += 20;
                        OurCar.createMessage((short)50);
                    } else if (this.hitedBy > -1 && CarManager.cars[this.hitedBy].hitedBy == -1) {
                        OurCar.score += 40;
                        OurCar.createMessage((short)52);
                    }
                }
            } else {
                if (this.x > border) {
                    this.x = border;
                    this.car.setTranslation(this.x, 0.0f, this.y);
                    return C_WALL;
                }
                if (this.x < -border) {
                    this.x = -border;
                    this.car.setTranslation(this.x, 0.0f, this.y);
                    return C_WALL;
                }
            }
        }
        return this.C_GND;
    }

    public final void setEffect() {
        this.bEffect = true;
        All3D.setCarElement(this.car, 4, false);
        ((Mesh)this.car.getChild(0)).getAppearance(0).setTexture(0, All3D.carTex[0]);
    }

    private final void checkEffect() {
        if (this.bEffect) {
            this.car.postRotate(-10.0f, 1.0f, 0.0f, (float)(DevKit.rnd(10) * (this.x > 0.0f ? 1 : -1)));
            this.iEffectCounter += 10;
            this.z += this.iEffectCounter < 180 ? 0.1f : -0.1f;
            this.car.translate(0.0f, this.iEffectCounter < 180 ? 0.1f : -0.1f, 0.0f);
            if (this.iEffectCounter > 360) {
                this.bEffect = false;
                this.dead = true;
                All3D.setCarElement(this.car, 0, false);
                All3D.setCarElement(this.car, 2, false);
                All3D.setCarElement(this.car, 3, true);
                this.car.setOrientation(0.0f, 0.0f, 0.0f, 0.0f);
                this.car.setTranslation(this.x, 0.0f, this.y);
                if (!DevKit.isZero(this.speed)) {
                    float cos;
                    float sin = this.speedY / this.speed;
                    OpponentCar.matrix[0] = cos = this.speedX / this.speed * (float)this.dir;
                    OpponentCar.matrix[2] = -sin;
                    OpponentCar.matrix[8] = sin;
                    OpponentCar.matrix[10] = cos;
                    this.tr.setIdentity();
                    this.tr.set(matrix);
                    this.car.setTransform(this.tr);
                }
            }
        } else if (this.iEffectCounter > 0) {
            this.iEffectCounter = 0;
        }
    }

    private final void checkPointers() {
        if (CarCanvas.difficulty < 2) {
            if (this.y < -22.0f) {
                int posMass;
                int n = posMass = 4 + DevKit.getCarLine(this.x);
                pointers[n] = pointers[n] | true;
            } else if (this.y > 1.0f) {
                int posMass;
                int n = posMass = DevKit.getCarLine(this.x);
                pointers[n] = pointers[n] | true;
            }
        }
    }

    private final void checkRespawn() {
        if (this.y > 8.0f || this.y < -50.0f) {
            All3D.resetEff(this.posInArray);
            this.resetCar();
            this.dir = DevKit.rnd(2) > 0 ? 1 : -1;
            this.curPer = DevKit.rnd(2);
            if (this.dir == 1 && this.curPer < OurCar.curPer && this.curPer != 5) {
                ++this.curPer;
            }
            this.speedX = this.speedMAX[this.curPer];
            this.speedY = 0.0f;
            this.engForceX = this.engMAX[this.curPer];
            this.engForceY = 0.0f;
            this.rotForce = 0.0f;
            this.toRotate = -1;
            this.pos = 50 * this.dir;
            if (this.dir == 1) {
                this.pos = -30.0f;
            }
            int carX = DevKit.rnd(1);
            this.x = (float)this.dir * carShift[carX + CarCanvas.curSet * 2];
            this.y = this.pos;
            int ourLine = DevKit.getCarLine(this.x);
            boolean resp = true;
            for (int i = 0; i < CarManager.cars.length; ++i) {
                if (i == this.posInArray || DevKit.getCarLine(CarManager.cars[i].x) != ourLine || !(Math.abs(CarManager.cars[i].y - this.y) < 2.0f)) continue;
                resp = false;
            }
            if (!resp) {
                this.y = 100 * this.dir;
                return;
            }
            this.bEffect = false;
            this.iEffectCounter = 0;
            this.effectHeith = 0;
            this.z = 0.0f;
            this.car.setTranslation(this.x, this.z, this.y);
            this.car.setOrientation(0.0f, 0.0f, 0.0f, 0.0f);
            this.dead = false;
            this.hitedBy = -2;
            int ID = (this.model - 1) * 2;
            int textId = DevKit.rnd(All3D.textOfCar[ID + 1] - All3D.textOfCar[ID]) + All3D.textOfCar[ID];
            ((Mesh)this.car.getChild(0)).getAppearance(0).setTexture(0, All3D.carTex[textId]);
        }
    }
}

