/*
 * Decompiled with CFR 0.152.
 */
package boot;

import boot.CarCanvas;
import boot.CarManager;
import boot.DevKit;
import boot.OpponentCar;
import boot.OurCar;
import boot.Road;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Sprite3D;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.World;

public class All3D {
    public static final int CAR = 0;
    public static final int SHADOW = 1;
    public static final int GABARID = 2;
    public static final int DEAD = 3;
    public static final int LIGHT = 4;
    public static int[] LIGHT_N = new int[]{24704, 0x4000AA, 8403712};
    public static int[] LIGHT_D = new int[]{12294512, 0xFFFEDD, 14740991};
    public static int curLight = 0;
    public static Camera camera;
    public static World world;
    public static Graphics3D g3d;
    public static Light light;
    public static Mesh[] objLeft;
    public static Mesh[] objRight;
    public static Mesh[] objRoad;
    public static Mesh[] objOneSide;
    public static Mesh block;
    public static Group[] road;
    public static Mesh[] objPointers;
    public static Appearance[] app;
    public static Appearance[] carApp;
    public static Appearance carDead;
    public static Texture2D[] carTex;
    public static int[] textOfCar;
    public static Image2D effImg;
    public static Appearance effApp;
    public static Group effGr;
    public static final int effMax = 3;
    public static final int effCnt = 10;
    public static Sprite3D[][] effect;
    public static float[][] effectX;
    public static float[][] effectY;
    public static float[][] effectZ;
    public static int[] effLive;
    public static int[][] effCounter;
    public static int[] curCar;
    public static long[] effTime;
    public static int[] effStep;
    public static float[] effShift;
    public static final int sparkCnt = 10;
    public static Mesh[] sparkMesh;
    private static long sparkTime;
    public static boolean isSpark;
    public static float[] sparkX;
    public static float[] sparkY;
    public static float[] sparkZ;
    public static float[] sparkAlfa;
    public static final int EFF_MODE_BLOW = 0;
    public static final int EFF_MODE_FOG = 1;
    public static int textOfCarUsed;
    public static Group ourCar;
    public static Transform ourCarTr;

    public static final void makeRoad(int set) {
        objLeft = new Mesh[7];
        objRight = new Mesh[7];
        objRoad = new Mesh[4];
        objOneSide = new Mesh[2];
        System.gc();
        road = new Group[3];
        All3D.road[0] = new Group();
        All3D.road[1] = new Group();
        All3D.road[2] = new Group();
        System.gc();
        try {
            int i;
            World w = DevKit.loadWorld("/rm" + (set + 1) + ".m3g");
            Mesh m = (Mesh)w.find(2);
            w.removeChild((Node)m);
            m.setAppearance(0, app[3]);
            All3D.objRoad[0] = m;
            m = (Mesh)w.find(1);
            w.removeChild((Node)m);
            m.setAppearance(0, app[3]);
            All3D.objRoad[1] = m;
            All3D.objRoad[2] = (Mesh)m.duplicate();
            All3D.objRoad[3] = (Mesh)m.duplicate();
            System.gc();
            for (i = 11; i < 16; ++i) {
                m = (Mesh)w.find(i);
                m.translate(3.0f, 0.0f, 0.0f);
                w.removeChild((Node)m);
                m.setAppearance(0, app[3]);
                try {
                    m.setAppearance(1, app[4]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                All3D.objLeft[i - 9] = m;
                m = (Mesh)m.duplicate();
                m.setScale(-1.0f, 1.0f, 1.0f);
                m.translate(-6.0f, 0.0f, 0.0f);
                All3D.objRight[i - 9] = m;
            }
            System.gc();
            try {
                for (i = 21; i < 23; ++i) {
                    m = (Mesh)w.find(i);
                    m.translate(3.0f, 0.0f, 0.0f);
                    w.removeChild((Node)m);
                    m.setAppearance(0, app[3]);
                    try {
                        m.setAppearance(1, app[4]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    All3D.objLeft[i - 21] = m;
                    m = (Mesh)m.duplicate();
                    m.setScale(-1.0f, 1.0f, 1.0f);
                    m.translate(-6.0f, 0.0f, 0.0f);
                    All3D.objRight[i - 21] = m;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.gc();
            m = (Mesh)w.find(5);
            w.removeChild((Node)m);
            m.setAppearance(0, app[4]);
            All3D.objOneSide[0] = m;
            if (CarCanvas.curSet == 2) {
                m = (Mesh)w.find(7);
                w.removeChild((Node)m);
                m.setAppearance(0, app[3]);
                block = m;
            }
            m = (Mesh)w.find(6);
            w.removeChild((Node)m);
            if (set == 0) {
                m.setAppearance(0, app[4]);
            } else {
                m.setAppearance(0, app[3]);
            }
            All3D.objOneSide[1] = m;
            if (CarCanvas.difficulty < 2) {
                int i2;
                w = DevKit.loadWorld("/vm1.m3g");
                m = (Mesh)w.find(51);
                for (i2 = 0; i2 < objPointers.length / 2; ++i2) {
                    m = (Mesh)m.duplicate();
                    m.setTranslation(OpponentCar.carShift[CarCanvas.curSet * 2 + (i2 < 2 ? (i2 + 1) % 2 : i2 % 2)] * (float)(i2 < 2 ? -1 : 1), 0.3f, 1.0f);
                    All3D.objPointers[i2] = m;
                }
                m = (Mesh)w.find(52);
                for (i2 = 0; i2 < objPointers.length / 2; ++i2) {
                    m = (Mesh)m.duplicate();
                    m.setTranslation(OpponentCar.carShift[CarCanvas.curSet * 2 + (i2 < 2 ? (i2 + 1) % 2 : i2 % 2)] * (float)(i2 < 2 ? -1 : 1), 0.3f, -10.0f);
                    All3D.objPointers[i2 + 4] = m;
                }
                for (i2 = 0; i2 < objPointers.length; ++i2) {
                    objPointers[i2].setRenderingEnable(false);
                    world.removeChild((Node)objPointers[i2]);
                    world.addChild((Node)objPointers[i2]);
                }
            }
            System.gc();
            world.removeChild((Node)road[0]);
            world.removeChild((Node)road[1]);
            world.removeChild((Node)road[2]);
            world.addChild((Node)road[0]);
            world.addChild((Node)road[1]);
            world.addChild((Node)road[2]);
            Road.createRoad();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void makeOurCar(int text) {
        textOfCarUsed = 0;
        ourCar = All3D.makeCar(1, text);
        ourCar.translate(OpponentCar.carShift[CarCanvas.curSet * 2 + 1], 0.0f, 0.0f);
        world.removeChild((Node)ourCar);
        world.addChild((Node)ourCar);
        ourCar.getTransform(ourCarTr);
        OurCar.resetCar();
        CarCanvas.lastLoaded = -1;
    }

    public static final void makeOpponentCar() {
        CarManager.createCars();
    }

    public static final void makeWorld() {
        try {
            World w = DevKit.loadWorld("/om1.m3g");
            camera = (Camera)w.find(10);
            w.removeChild((Node)camera);
            world.addChild((Node)camera);
            camera.postRotate(4.0f, 1.0f, 0.0f, 0.0f);
            camera.translate(0.0f, -0.5f, -0.5f);
            camera.setPerspective(50.0f, 0.75f, 0.1f, 50.0f);
            world.setActiveCamera(camera);
            world.setActiveCamera(camera);
            light = new Light();
            light.setMode(128);
            light.setIntensity(8.0f);
            light.setColor(-1);
            curLight = LIGHT_D[DevKit.rnd(2)];
            if (CarCanvas.isNight) {
                curLight = LIGHT_N[DevKit.rnd(2)];
                light.setIntensity(8.0f);
            }
            light.setColor(curLight);
            Background bg = new Background();
            bg.setColor(0);
            bg.setColorClearEnable(true);
            world.setBackground(bg);
            world.addChild((Node)light);
            road[0].setTranslation(0.0f, 0.0f, 3.0f);
            road[1].setTranslation(0.0f, 0.0f, -15.0f);
            road[2].setTranslation(0.0f, 0.0f, -33.0f);
            world.addChild((Node)ourCar);
            for (int i = 0; i < 10; ++i) {
                ourCar.removeChild((Node)sparkMesh[i]);
                ourCar.addChild((Node)sparkMesh[i]);
            }
            System.gc();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static final void clearWorld() {
        textOfCarUsed = 1;
        while (world.getChildCount() > 0) {
            world.removeChild(world.getChild(0));
        }
        g3d = Graphics3D.getInstance();
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void draw3D(Graphics g) {
        boolean bound = false;
        try {
            g3d.bindTarget((Object)g);
            bound = true;
            g3d.render(world);
        }
        finally {
            if (bound) {
                g3d.releaseTarget();
            }
        }
    }

    public static final void loadAppearencesTextures(int set) {
        if (app[1] == null) {
            World w = DevKit.loadWorld("/om1.m3g");
            for (int i = 1; i < app.length; ++i) {
                All3D.app[i] = ((Mesh)w.find(i)).getAppearance(0);
            }
            app[1].setLayer(2);
            app[2].setLayer(1);
            app[5].setLayer(3);
            app[6].setLayer(3);
            app[7].setLayer(1);
        }
        System.gc();
        try {
            Image im = Image.createImage((String)("/et" + (set + 1) + ".png"));
            Image2D im2 = new Image2D(99, (Object)im);
            Texture2D tex = new Texture2D(im2);
            app[3].setTexture(0, tex);
            im = Image.createImage((String)"/et0.png");
            im2 = new Image2D(100, (Object)im);
            tex = new Texture2D(im2);
            app[4].setTexture(0, tex);
            im = Image.createImage((String)"/et4.png");
            im2 = new Image2D(99, (Object)im);
            tex = new Texture2D(im2);
            app[5].setTexture(0, tex);
            app[6].setTexture(0, tex);
            app[6].getCompositingMode().setAlphaThreshold(0.5f);
            im = Image.createImage((String)"/st0.png");
            effImg = new Image2D(100, (Object)im);
            if (carTex[1] == null) {
                for (int i = 0; i < carTex.length; ++i) {
                    im = Image.createImage((String)("/vt" + i + ".png"));
                    im2 = new Image2D(99, (Object)im);
                    All3D.carTex[i] = new Texture2D(im2);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.gc();
        if (carApp[0] == null) {
            carApp = new Appearance[CarManager.carCnt + 2];
            for (int i = 0; i < carApp.length; ++i) {
                All3D.carApp[i] = (Appearance)app[1].duplicate();
            }
            carDead = (Appearance)carApp[0].duplicate();
            carDead.setTexture(0, carTex[0]);
        }
        System.gc();
    }

    public static final Group makeCar(int carID, int text) {
        Group g = new Group();
        World w = DevKit.loadWorld("/vm1.m3g");
        Mesh m = (Mesh)w.find(10);
        w.removeChild((Node)m);
        for (int i = 0; i < 10; ++i) {
            if (sparkMesh[i] != null) continue;
            All3D.sparkMesh[i] = (Mesh)m.duplicate();
            sparkMesh[i].setRenderingEnable(false);
        }
        m = (Mesh)w.find(carID);
        w.removeChild((Node)m);
        int ID = (carID - 1) * 2;
        int textId = text != -1 ? text : DevKit.rnd(textOfCar[ID + 1] - textOfCar[ID]) + textOfCar[ID];
        carApp[++textOfCarUsed].setTexture(0, carTex[textId]);
        m.setAppearance(0, carApp[textOfCarUsed]);
        g.addChild((Node)m);
        int appShad = 6;
        m = (Mesh)sparkMesh[0].duplicate();
        m.scale(0.1f, 0.1f, 0.1f);
        m.setRenderingEnable(false);
        g.addChild((Node)m);
        m = (Mesh)w.find(carID + 20);
        w.removeChild((Node)m);
        m.setAppearance(0, app[5]);
        if (CarCanvas.isNight) {
            m.setRenderingEnable(true);
        } else {
            m.setRenderingEnable(false);
        }
        g.addChild((Node)m);
        m = (Mesh)w.find(5);
        w.removeChild((Node)m);
        m.setAppearance(0, carDead);
        m.setRenderingEnable(false);
        g.addChild((Node)m);
        m = (Mesh)w.find(40);
        w.removeChild((Node)m);
        m.setAppearance(0, app[5]);
        m.setRenderingEnable(CarCanvas.isNight);
        g.addChild((Node)m);
        return g;
    }

    public static final void loadEffects() {
        effCounter = new int[3][10];
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 10; ++i) {
                All3D.effect[j][i] = new Sprite3D(true, effImg, app[6]);
                effect[j][i].setCrop(0, 0, 32, 32);
                All3D.effCounter[j][i] = 30;
            }
        }
        for (int i = 0; i < 3; ++i) {
            All3D.curCar[i] = -2;
        }
        System.gc();
    }

    public static final void newSpark(float w, float h) {
        for (int i = 0; i < 10; ++i) {
            sparkMesh[i].setTranslation(w, 0.3f, (float)DevKit.rnd(50) * h / 50.0f);
            sparkMesh[i].setRenderingEnable(true);
            float scale = 0.25f + (float)DevKit.rnd(50) / 100.0f;
            sparkMesh[i].setScale(scale, scale, scale);
            All3D.sparkAlfa[i] = DevKit.rnd(30) - 15;
            All3D.sparkX[i] = (float)(DevKit.rnd(10) - 5) / 0.05f;
            All3D.sparkY[i] = (float)(DevKit.rnd(10) - 5) / 0.05f;
            All3D.sparkZ[i] = (float)(DevKit.rnd(10) - 5) / 0.05f;
            sparkMesh[i].setOrientation(sparkAlfa[i], 0.0f, 1.0f, 0.0f);
        }
        sparkTime = OurCar.time + 1000L;
        isSpark = true;
    }

    public static final void newSpark(float w, float h, float sin, float cos) {
        for (int i = 0; i < 10; ++i) {
            sparkMesh[i].setTranslation(w, 0.3f, h);
            sparkMesh[i].setRenderingEnable(true);
            float scale = 0.25f + (float)DevKit.rnd(50) / 100.0f;
            sparkMesh[i].setScale(scale, scale, scale);
            All3D.sparkAlfa[i] = DevKit.rnd(30) - 15;
            All3D.sparkX[i] = (float)(DevKit.rnd(10) - 5) / 0.05f;
            All3D.sparkY[i] = (float)(DevKit.rnd(10) - 5) / 0.05f;
            All3D.sparkZ[i] = (float)(DevKit.rnd(10) - 5) / 0.05f;
            sparkMesh[i].setOrientation(sparkAlfa[i], 0.0f, 1.0f, 0.0f);
            Transform tr = new Transform();
            tr.set(new float[]{cos, 0.0f, -sin, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, sin, 0.0f, cos, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
            sparkMesh[i].setTransform(tr);
        }
        sparkTime = OurCar.time + 100L;
        isSpark = true;
    }

    public static final void newEff(int curCarOpp, int mode) {
        if (mode == 0 && curCar[0] != -2) {
            mode = 2;
        }
        All3D.effCounter[mode] = new int[10];
        All3D.curCar[mode] = curCarOpp;
        All3D.effTime[mode] = OurCar.time;
        All3D.effStep[mode] = 0;
        All3D.effShift[mode] = 0.0f;
        for (int i = 0; i < 10; ++i) {
            effect[mode][i].setAppearance(app[5]);
            if (mode == 0 || mode == 2) {
                float angle = 60 + DevKit.rnd(60);
                All3D.effectX[mode][i] = 0.05f * (float)Math.cos(Math.toRadians(angle));
                All3D.effectY[mode][i] = 0.05f * (float)Math.sin(Math.toRadians(angle));
                All3D.effectZ[mode][i] = (float)DevKit.rnd(5) * 0.05f;
                All3D.effCounter[mode][i] = 0;
            } else {
                All3D.effectX[mode][i] = (float)(DevKit.rnd(100) - 50) * 0.001f;
                All3D.effectY[mode][i] = (float)(DevKit.rnd(100) - 50) * 0.001f;
                All3D.effectZ[mode][i] = (float)DevKit.rnd(100) * 0.003f;
                All3D.effCounter[mode][i] = DevKit.rnd(30);
            }
            effect[mode][i].setRenderingEnable(false);
            world.removeChild((Node)effect[mode][i]);
            world.addChild((Node)effect[mode][i]);
        }
    }

    public static final void updateEff() {
        if (isSpark) {
            int i;
            if (sparkTime < OurCar.time) {
                isSpark = false;
                for (i = 0; i < 10; ++i) {
                    sparkMesh[i].setRenderingEnable(false);
                    world.removeChild((Node)world);
                }
            } else {
                for (i = 0; i < 10; ++i) {
                    sparkMesh[i].translate(0.0f, 0.0f, CarCanvas.dx / 2.0f);
                }
            }
        }
        for (int j = 0; j < 3; ++j) {
            int i;
            float z;
            float y;
            float x;
            if (curCar[j] < -1) continue;
            if (curCar[j] == -1) {
                x = OurCar.x;
                y = OurCar.y;
                z = OurCar.z;
            } else {
                x = CarManager.cars[All3D.curCar[j]].x;
                y = CarManager.cars[All3D.curCar[j]].y;
                z = CarManager.cars[All3D.curCar[j]].z;
            }
            if (j == 0 || j == 2) {
                if (OurCar.time - effTime[j] > (long)(effStep[j] * 10)) {
                    int ind = effStep[j] % 10;
                    int prev = ind - 2 - DevKit.rnd(3);
                    if (prev < 0) {
                        prev += 10;
                    }
                    All3D.effCounter[j][ind] = ind;
                    effect[j][ind].setRenderingEnable(true);
                    effect[j][ind].setAppearance(app[5]);
                    effect[j][ind].setCrop(effCounter[j][ind] % 5 * 32, 0, 32, 32);
                    float scale = 0.3f + (float)DevKit.rnd(75) / 100.0f;
                    effect[j][ind].setScale(scale, scale, scale);
                    effect[j][ind].setTranslation(x + effectX[j][ind], z + 0.1f + effectZ[j][ind], y + effectY[j][ind]);
                    for (int i2 = 0; i2 < 10; ++i2) {
                        if (i2 == ind) continue;
                        if (i2 == prev) {
                            effect[j][i2].setAppearance(app[6]);
                            effect[j][i2].setCrop(DevKit.rnd(4) * 32, 32, 32, 32);
                        } else {
                            int cY = effect[j][i2].getCropY();
                            effect[j][i2].setCrop(DevKit.rnd(4) * 32, cY, 32, 32);
                        }
                        effect[j][i2].translate(0.0f, 0.0f, CarCanvas.dx);
                        int[] nArray = effCounter[j];
                        int n = i2;
                        nArray[n] = nArray[n] + 1;
                    }
                    int n = j;
                    effStep[n] = effStep[n] + 1;
                    continue;
                }
                for (i = 0; i < 10; ++i) {
                    effect[j][i].translate(0.0f, 0.0f, CarCanvas.dx);
                }
                continue;
            }
            for (i = 0; i < 10; ++i) {
                if (effCounter[j][i] > 20) {
                    effect[j][i].setAppearance(app[6]);
                    effect[j][i].setCrop(DevKit.rnd(4) * 32, 32, 32, 32);
                } else {
                    effect[j][i].setAppearance(app[5]);
                    effect[j][i].setCrop(DevKit.rnd(4) * 32, 0, 32, 32);
                }
                effect[j][i].setRenderingEnable(true);
                effect[j][i].setTranslation(x + effectX[j][i] * (float)effCounter[j][i], z + effectZ[j][i] * (float)effCounter[j][i], y + effectY[j][i] * (float)effCounter[j][i]);
                effect[j][i].setScale(0.7f + (float)effCounter[j][i] * 0.05f, 0.7f + (float)effCounter[j][i] * 0.05f, 0.7f + (float)effCounter[j][i] * 0.05f);
                int[] nArray = effCounter[j];
                int n = i;
                nArray[n] = nArray[n] + DevKit.rnd(3);
                if (effCounter[j][i] <= 30) continue;
                All3D.effCounter[j][i] = 0;
            }
        }
    }

    public static final void loadCarSelect() {
        CarCanvas.loaded = false;
        CarCanvas.loadProgress = 0;
        CarCanvas.loadProgressMax = 5;
        All3D.clearWorld();
        CarCanvas.progressUp();
        All3D.loadAppearencesTextures(0);
        CarCanvas.progressUp();
        All3D.makeOurCar(1);
        CarCanvas.progressUp();
        Background bg = new Background();
        bg.setColorClearEnable(false);
        world.setBackground(bg);
        ourCar.setTranslation(0.0f, 0.5f, 0.0f);
        CarCanvas.progressUp();
        camera = new Camera();
        camera.setPerspective(60.0f, (float)CarCanvas.W / (float)CarCanvas.H, 0.1f, 40.0f);
        camera.setTranslation(0.0f, 1.0f, 2.5f);
        camera.setOrientation(20.0f, -1.0f, 0.0f, 0.0f);
        Light l = new Light();
        l.setColor(-1);
        l.setMode(128);
        l.setIntensity(10.0f);
        world.addChild((Node)l);
        world.addChild((Node)camera);
        world.setActiveCamera(camera);
        CarCanvas.progressUp();
        CarCanvas.loaded = true;
    }

    public static final void resetEff(int car) {
        for (int j = 0; j < 3; ++j) {
            if (curCar[j] != car) continue;
            for (int i = 0; i < 10; ++i) {
                world.removeChild((Node)effect[j][i]);
                All3D.curCar[j] = -2;
            }
        }
    }

    public static void setCarElement(Group g, int ID, boolean val) {
        g.getChild(ID).setRenderingEnable(val);
    }

    static {
        world = new World();
        objLeft = new Mesh[7];
        objRight = new Mesh[7];
        objRoad = new Mesh[4];
        objOneSide = new Mesh[2];
        road = new Group[3];
        objPointers = new Mesh[8];
        app = new Appearance[10];
        carApp = new Appearance[CarManager.carCnt + 2];
        carTex = new Texture2D[14];
        textOfCar = new int[]{1, 5, 10, 13, 8, 9, 6, 7};
        effGr = new Group();
        effect = new Sprite3D[3][10];
        effectX = new float[3][10];
        effectY = new float[3][10];
        effectZ = new float[3][10];
        effLive = new int[]{10, 10};
        effCounter = new int[3][];
        curCar = new int[3];
        effTime = new long[3];
        effStep = new int[3];
        effShift = new float[3];
        sparkMesh = new Mesh[10];
        sparkTime = -1L;
        isSpark = false;
        sparkX = new float[10];
        sparkY = new float[10];
        sparkZ = new float[10];
        sparkAlfa = new float[10];
        textOfCarUsed = 0;
        ourCarTr = new Transform();
    }
}

