/*
 * Decompiled with CFR 0.152.
 */
package boot;

import boot.All3D;
import boot.CarM;
import boot.CarManager;
import boot.DevKit;
import boot.Menu;
import boot.OurCar;
import boot.Road;
import boot.Snd;
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CarCanvas
extends Canvas
implements Runnable {
    public static String[] snd = new String[]{"intro", "win", "loose", "boom", "chpoint"};
    public static int[] sndRep = new int[]{10, 1, 1, 1, 1};
    public static boolean isNight = false;
    public static Image imLogo;
    public static int logo;
    public static final String GAME_STORE = "LR3DG";
    public static final String OPT_STORE = "LR3DO";
    public static CarCanvas instance;
    public static final int STATE_GAME = 1;
    public static final int STATE_MENU = 0;
    public static int curState;
    public static int W;
    public static int H;
    public static String log;
    public static int curPlane;
    public static boolean loaded;
    public static long timeLogo;
    public static boolean bEffect;
    public static int iEffectCounter;
    public static int curSet;
    public static int difficulty;
    public static int curMission;
    public static int loadProgress;
    public static int loadProgressMax;
    public static float dx;
    public static int lastLoaded;
    private boolean isSnow = false;
    public static boolean bRun;
    public static int errInd;
    public static boolean[] keys;
    public static int UP;
    public static int DOWN;
    public static int LEFT;
    public static int RIGHT;
    public static int FIRE;
    public static int SOFT_L;
    public static int SOFT_R;
    public static boolean cheatAlban;
    public static boolean cheatGO;
    public static int cheatAlbanP;
    public static int cheatGOP;
    public static int[] cheatAlbanA;
    public static int[] cheatGOA;
    public static int lastPressed;

    private static final void setDistanse(int mission) {
        OurCar.distCheck = new int[12];
        int dist = (int)(OurCar.speedMAX[OurCar.speedMAX.length - 1] * 28.0f * (float)(mission + 1) * (float)(mission + 1) / (float)(mission + 2) / (float)(mission + 2));
        for (int i = 0; i < 12; ++i) {
            OurCar.distCheck[i] = dist * i;
        }
        OurCar.distanse = OurCar.distCheck[0];
    }

    protected final void paint(Graphics g) {
        if (loaded) {
            switch (curState) {
                case 0: {
                    Menu.update();
                    Menu.renderMenu(g);
                    break;
                }
                case 1: {
                    this.update();
                    All3D.draw3D(g);
                    OurCar.drawSpeed(g);
                }
            }
        } else {
            try {
                int color = logo < 2 ? -1 : 0;
                g.setColor(color);
                g.setClip(0, 0, W, H);
                g.fillRect(0, 0, W, H);
                if (logo < 2) {
                    if (imLogo != null) {
                        g.drawImage(imLogo, W / 2, H / 2, 3);
                    }
                } else if (logo == 2) {
                    if (imLogo != null) {
                        g.drawImage(imLogo, W / 2, 0, 17);
                    }
                } else {
                    g.setColor(-1);
                    g.fillRect(10, H - 30, (W - 20) * loadProgress / loadProgressMax, 20);
                    try {
                        DevKit.renderText(g, 18, W / 2, H / 2, 5, OurCar.RC);
                        DevKit.renderText(g, DevKit.numToByte(loadProgress), W / 2, H / 2 + 20, 5, OurCar.RC, 0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public final void run() {
        try {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                // empty catch block
            }
            Menu.loadMenuImg();
            int nextSt = 0;
            if (DevKit.hasRS(GAME_STORE)) {
                DevKit.loadGame();
                new Snd();
                Snd.init(snd, sndRep);
                nextSt = 0;
            } else {
                new Snd();
                Snd.init(snd, sndRep);
                nextSt = 8;
            }
            W = this.getWidth();
            H = this.getHeight();
            if (W < 176) {
                DevKit._FontDx = (byte)(DevKit._FontDx - 1);
            }
            new OurCar();
            try {
                for (int i = 0; i < 3; ++i) {
                    imLogo = Image.createImage((String)("/l" + i + ".png"));
                    timeLogo = System.currentTimeMillis() + 3000L;
                    while (timeLogo > System.currentTimeMillis()) {
                        this.repaint();
                    }
                    ++logo;
                }
                imLogo = null;
                System.gc();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            Menu.setNextState(nextSt);
            loaded = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        while (bRun) {
            this.repaint();
            this.serviceRepaints();
            if (curState != 0) continue;
            try {
                Thread.sleep(25L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        CarM.instance.destroyApp(false);
    }

    public CarCanvas() {
        instance = this;
        this.setFullScreenMode(true);
        new Thread(this).start();
    }

    public void keyReleased(int key) {
        if (key == 54 || key == -4) {
            CarCanvas.keys[CarCanvas.RIGHT] = false;
        } else if (key == 52 || key == -3) {
            CarCanvas.keys[CarCanvas.LEFT] = false;
        } else if (key == 50 || key == -1) {
            CarCanvas.keys[CarCanvas.UP] = false;
        } else if (key == 56 || key == -2) {
            CarCanvas.keys[CarCanvas.DOWN] = false;
        } else if (key != 57 && key != 51 && key != 49 && key != 35 && key != 55) {
            if (key == 53 || key == -5) {
                CarCanvas.keys[CarCanvas.FIRE] = false;
            } else if (key == -6) {
                CarCanvas.keys[CarCanvas.SOFT_L] = false;
            } else if (key == -7) {
                CarCanvas.keys[CarCanvas.SOFT_R] = false;
            }
        }
    }

    public void keyPressed(int key) {
        if (Menu.curSet == 8) {
            if (key == cheatAlbanA[cheatAlbanP]) {
                if (++cheatAlbanP == cheatAlbanA.length) {
                    cheatAlbanP = 0;
                    cheatAlban = true;
                }
            } else {
                cheatAlbanP = 0;
            }
            if (key == cheatGOA[cheatGOP]) {
                if (++cheatGOP == cheatGOA.length) {
                    cheatGOP = 0;
                    cheatGO = true;
                }
            } else {
                cheatGOP = 0;
            }
        }
        if (key == 54 || key == -4) {
            CarCanvas.keys[CarCanvas.RIGHT] = true;
        } else if (key == 52 || key == -3) {
            CarCanvas.keys[CarCanvas.LEFT] = true;
        } else if (key == 50 || key == -1) {
            CarCanvas.keys[CarCanvas.UP] = true;
        } else if (key == 56 || key == -2) {
            CarCanvas.keys[CarCanvas.DOWN] = true;
        } else if (key != 57 && key != 51 && key != 49 && key != 35) {
            if (key == 55) {
                OurCar.is2d = !OurCar.is2d;
            } else if (key == 53 || key == -5) {
                CarCanvas.keys[CarCanvas.FIRE] = true;
            } else if (key == -21 || key == 21) {
                CarCanvas.keys[CarCanvas.SOFT_L] = true;
                if (curState == 1 && OurCar.pause) {
                    CarCanvas.keys[CarCanvas.SOFT_L] = false;
                    curState = 0;
                    Menu.setNextState(0);
                }
            } else if (key == -22 || key == 22) {
                CarCanvas.keys[CarCanvas.SOFT_R] = true;
                if (curState == 1) {
                    CarCanvas.keys[CarCanvas.SOFT_R] = false;
                    if (OurCar.pause) {
                        OurCar.pause = false;
                        OurCar.time = 0L;
                    } else if (!OurCar.firsTime) {
                        OurCar.pause = true;
                    }
                }
            }
        }
    }

    private final void update() {
        if (OurCar.pause) {
            return;
        }
        dx = OurCar.update();
        Road.update(dx);
        CarManager.update(dx);
    }

    public void hideNotify() {
        if (curState == 1) {
            OurCar.pause = true;
        } else {
            Menu.pause = true;
        }
        Snd.stopLast();
    }

    public void showNotify() {
        Menu.pause = false;
    }

    public static final void createGame(int set, int text) {
        if (lastLoaded != curMission) {
            isNight = curMission % 3 == 0 ? true : DevKit.rnd(4) == 1;
            loaded = false;
            loadProgress = 0;
            loadProgressMax = 10;
            curSet = set;
            All3D.clearWorld();
            CarCanvas.progressUp();
            All3D.loadAppearencesTextures(curSet);
            CarCanvas.progressUp();
            All3D.makeRoad(curSet);
            CarCanvas.progressUp();
            CarCanvas.progressUp();
            All3D.makeOpponentCar();
            CarCanvas.progressUp();
            All3D.makeWorld();
            CarCanvas.progressUp();
            CarCanvas.setDistanse(curMission);
            All3D.loadEffects();
        } else {
            for (int i = 0; i < CarManager.carCnt; ++i) {
                CarManager.cars[i].resetCar();
            }
        }
        OurCar.dead = true;
        All3D.ourCar.setOrientation(0.0f, 0.0f, 0.0f, 0.0f);
        System.gc();
        OurCar.resetCar();
        OurCar.y = 2.0f;
        OurCar.timeStart = System.currentTimeMillis() + 5000L;
        loaded = true;
        OurCar.pause = false;
        OurCar.firsTime = true;
        lastLoaded = curMission;
        OurCar.fpsCnt = 0;
    }

    public static final void progressUp() {
        ++loadProgress;
        instance.repaint();
        instance.serviceRepaints();
        System.gc();
    }

    public void pointerPressed(int x, int y) {
        if (lastPressed != -1) {
            CarCanvas.keys[CarCanvas.lastPressed] = false;
        }
        if (y > H - DevKit.textHeight() * 3 / 2) {
            if (x < W / 2) {
                CarCanvas.keys[CarCanvas.SOFT_L] = true;
                lastPressed = SOFT_L;
                this.keyPressed(-6);
            } else {
                CarCanvas.keys[CarCanvas.SOFT_R] = true;
                lastPressed = SOFT_R;
                this.keyPressed(-7);
            }
        } else if (curState == 1) {
            if (x < W / 3) {
                CarCanvas.keys[CarCanvas.LEFT] = true;
                lastPressed = LEFT;
            } else if (x > W * 2 / 3) {
                CarCanvas.keys[CarCanvas.RIGHT] = true;
                lastPressed = RIGHT;
            } else {
                CarCanvas.keys[CarCanvas.FIRE] = true;
                lastPressed = FIRE;
            }
        }
    }

    protected void pointerReleased(int x, int y) {
        if (lastPressed != -1) {
            CarCanvas.keys[CarCanvas.lastPressed] = false;
            lastPressed = -1;
        }
    }

    static {
        logo = 0;
        curState = 0;
        log = "doit JJJ ";
        curPlane = 0;
        loaded = false;
        timeLogo = 0L;
        bEffect = false;
        iEffectCounter = 0;
        curSet = 0;
        difficulty = 0;
        curMission = 0;
        loadProgress = 0;
        loadProgressMax = 10;
        dx = 0.0f;
        lastLoaded = -1;
        bRun = true;
        errInd = 0;
        keys = new boolean[7];
        UP = 0;
        DOWN = 1;
        LEFT = 2;
        RIGHT = 3;
        FIRE = 4;
        SOFT_L = 5;
        SOFT_R = 6;
        cheatAlban = false;
        cheatGO = false;
        cheatAlbanP = 0;
        cheatGOP = 0;
        cheatAlbanA = new int[]{54, 54, 50, 52, 54, 54};
        cheatGOA = new int[]{54, 54, 50, 52, 54, 54};
        lastPressed = -1;
    }
}

