/*
 * Decompiled with CFR 0.152.
 */
package boot;

import boot.All3D;
import boot.CarCanvas;
import boot.DevKit;
import boot.OpponentCar;
import boot.OurCar;
import boot.Road;
import boot.Snd;

public class CarManager {
    public static boolean collis = false;
    public static int carCnt = 4;
    public static float dxReal = 0.0f;
    public static final OpponentCar[] cars = new OpponentCar[carCnt];
    public static final float[] blockWH = new float[]{0.6f, 2.0f};

    public static final void createCars() {
        int i;
        OurCar.collis = new boolean[carCnt];
        for (i = 0; i < carCnt; i = (int)((byte)(i + 1))) {
            CarManager.cars[i] = new OpponentCar((byte)(DevKit.rnd(3) + 1), (byte)i);
            OurCar.collis[i] = false;
        }
        for (i = 0; i < carCnt; ++i) {
            for (int j = 0; j < carCnt; ++j) {
                CarManager.cars[i].collis[j] = false;
            }
        }
        System.gc();
    }

    public static final void update(float dx) {
        int i;
        for (i = 0; i < OpponentCar.pointers.length; ++i) {
            OpponentCar.pointers[i] = false;
        }
        dxReal = dx;
        for (i = 0; i < carCnt; ++i) {
            cars[i].update(dxReal);
        }
        if (CarCanvas.difficulty < 2) {
            for (i = 0; i < OpponentCar.pointers.length; ++i) {
                if (OpponentCar.pointers[i]) {
                    All3D.objPointers[i].setRenderingEnable(true);
                    continue;
                }
                All3D.objPointers[i].setRenderingEnable(false);
            }
        }
        CarManager.checkColissions();
    }

    private static boolean caheckCollision(OpponentCar carCollis) {
        float y = carCollis.x - OurCar.x;
        float x = carCollis.y - OurCar.y;
        if ((double)(y * y + x * x) < 2.8899999999999997) {
            float[] ourProj = CarManager.getMinMax(OurCar.speedY, OurCar.speedX, OurCar.speed, OurCar.WIDTH * 2.0f, OurCar.HEITH);
            float[] oppProj = CarManager.getMinMax(carCollis.speedY, carCollis.speedX * (float)carCollis.dir, carCollis.speed, carCollis.WIDTH * 2.0f, carCollis.HEITH);
            ourProj[0] = ourProj[0] + OurCar.x;
            ourProj[1] = ourProj[1] + OurCar.x;
            oppProj[0] = oppProj[0] + carCollis.x;
            oppProj[1] = oppProj[1] + carCollis.x;
            oppProj[2] = oppProj[2] + carCollis.y;
            oppProj[3] = oppProj[3] + carCollis.y;
            if (ourProj[0] > oppProj[1] || oppProj[0] > ourProj[1] || ourProj[2] > oppProj[3] || oppProj[2] > ourProj[3]) {
                return false;
            }
            Snd.playVibra();
            carCollis.hitedBy = -1;
            if (!OurCar.collis[carCollis.posInArray]) {
                if (carCollis.dead) {
                    OurCar.makeDead();
                    OurCar.resurect = false;
                    All3D.newEff(-1, 1);
                } else if (!DevKit.isZero(OurCar.rotForce)) {
                    OurCar.makeDead();
                    OurCar.resurect = false;
                    All3D.newEff(-1, 1);
                    carCollis.setEffect();
                    All3D.newEff(carCollis.posInArray, 0);
                } else if (OurCar.dead) {
                    carCollis.dead = true;
                    All3D.newEff(-1, 1);
                } else if (carCollis.dir < 0) {
                    if ((double)DevKit.abs(OurCar.speedY / OurCar.speed - carCollis.speedY / carCollis.speed) < 0.5) {
                        if (DevKit.abs(y) < (OurCar.WIDTH + carCollis.WIDTH) / 2.0f) {
                            if (carCollis.WEITH > (float)OurCar.WEITH || DevKit.rnd(1) == 0) {
                                float singn = y > 0.0f ? 1.0f : -1.0f;
                                OurCar.setEffect();
                                All3D.newEff(-1, 0);
                                carCollis.rotForce = -singn * (OurCar.engForce + carCollis.engForce) * (float)OurCar.WEITH / carCollis.WEITH;
                                carCollis.speedY = singn * (OurCar.speed + carCollis.speed) * (float)OurCar.WEITH / carCollis.WEITH;
                            } else {
                                float singn = y > 0.0f ? 1.0f : -1.0f;
                                carCollis.setEffect();
                                All3D.newEff(carCollis.posInArray, 0);
                                OurCar.rotForce = singn * (OurCar.engForce + carCollis.engForce) * carCollis.WEITH / (float)OurCar.WEITH;
                                OurCar.speedY = -singn * (OurCar.speed + carCollis.speed) * carCollis.WEITH / (float)OurCar.WEITH / 8.0f;
                            }
                        } else if (DevKit.abs(y) > (OurCar.WIDTH + carCollis.WIDTH) * 4.0f / 5.0f) {
                            float singn = y > 0.0f ? -0.1f : 0.1f;
                            OurCar.speedY = singn * OurCar.speed * carCollis.WEITH / (float)OurCar.WEITH;
                            carCollis.speedY = -singn * carCollis.speed * (float)OurCar.WEITH / carCollis.WEITH;
                            OurCar.createMessage((short)49);
                            All3D.newSpark(y / 2.0f, OurCar.HEITH);
                            OurCar.addScore(20);
                        } else {
                            float singn = y > 0.0f ? 1.0f : -1.0f;
                            OurCar.rotForce = singn * (OurCar.engForce + carCollis.engForce) * carCollis.WEITH / (float)OurCar.WEITH;
                            OurCar.speedY = -singn * (OurCar.speed + carCollis.speed) * carCollis.WEITH / (float)OurCar.WEITH / 8.0f;
                            carCollis.rotForce = -singn * (OurCar.engForce + carCollis.engForce) * (float)OurCar.WEITH / carCollis.WEITH;
                            carCollis.speedY = singn * (OurCar.speed + carCollis.speed) * (float)OurCar.WEITH / carCollis.WEITH / 8.0f;
                        }
                    }
                } else if (DevKit.abs(x) > (OurCar.HEITH + carCollis.HEITH) * 3.0f / 8.0f || Math.abs(OurCar.speedY - carCollis.speedY) < 0.2f) {
                    carCollis.speedY += y / (OurCar.WIDTH + carCollis.WIDTH) * Math.abs(OurCar.speed - carCollis.speed) * (float)OurCar.WEITH / carCollis.WEITH;
                    OurCar.engForceY = 0.0f;
                    float spWas = OurCar.speedX;
                    if ((OurCar.speedX -= (OurCar.speedX - carCollis.speedX) * carCollis.WEITH / (float)OurCar.WEITH) <= 0.0f) {
                        OurCar.speedX = 0.1f;
                    }
                    carCollis.speedX += (spWas - carCollis.speedX) * (float)OurCar.WEITH / carCollis.WEITH;
                    carCollis.hitedBy = -1;
                } else {
                    float yForse = OurCar.engForceY - carCollis.engForceY;
                    carCollis.engForceY += yForse * (float)OurCar.WEITH / carCollis.WEITH;
                    OurCar.engForceY -= yForse * carCollis.WEITH / (float)OurCar.WEITH;
                    float ySpeed = OurCar.speedY - carCollis.speedY;
                    carCollis.speedY += ySpeed * (float)OurCar.WEITH / carCollis.WEITH;
                    OurCar.speedY -= ySpeed * carCollis.WEITH / (float)OurCar.WEITH;
                    All3D.newSpark(y / 2.0f, OurCar.HEITH);
                    carCollis.hitedBy = -1;
                }
            }
            return true;
        }
        return false;
    }

    private static void checkColissions() {
        int i;
        collis = false;
        if (!OurCar.dead) {
            for (i = 0; i < carCnt; ++i) {
                boolean curCollis = CarManager.caheckCollision(cars[i]);
                collis |= curCollis;
                OurCar.collis[i] = curCollis;
            }
        }
        for (i = 0; i < carCnt; ++i) {
            for (int j = 0; j < carCnt; ++j) {
                if (CarManager.cars[j].dir == 1 && CarManager.cars[i].y < CarManager.cars[j].y) {
                    CarManager.cars[i].collis[j] = CarManager.caheckCollision(cars[i], cars[j]);
                    continue;
                }
                if (CarManager.cars[j].dir != -1 || CarManager.cars[i].dir != -1 || !(CarManager.cars[i].y > CarManager.cars[j].y)) continue;
                CarManager.cars[i].collis[j] = CarManager.caheckCollision2(cars[i], cars[j]);
            }
        }
        if (CarCanvas.curSet == 2) {
            int i2;
            int ind = -1;
            for (i2 = 0; i2 < 2; ++i2) {
                if (Road.block[i2] != 1) continue;
                ind = i2;
            }
            if (ind != -1) {
                for (i2 = 0; i2 < carCnt; ++i2) {
                    float y = -CarManager.cars[i2].x;
                    float blockPos = Road.roadX[ind];
                    float x = blockPos - CarManager.cars[i2].y;
                    if (!(y * y + x * x < 4.0f)) continue;
                    float[] ourProj = CarManager.getMinMax(CarManager.cars[i2].speedY, CarManager.cars[i2].speedX, CarManager.cars[i2].speed, CarManager.cars[i2].WIDTH * 2.0f, CarManager.cars[i2].HEITH);
                    float[] oppProj = new float[]{-blockWH[0] / 2.0f, blockWH[0] / 2.0f, blockPos - blockWH[1] / 2.0f, blockPos + blockWH[1] / 2.0f};
                    ourProj[0] = ourProj[0] + CarManager.cars[i2].x;
                    ourProj[1] = ourProj[1] + CarManager.cars[i2].x;
                    ourProj[2] = ourProj[2] + CarManager.cars[i2].y;
                    ourProj[3] = ourProj[3] + CarManager.cars[i2].y;
                    if (ourProj[0] > oppProj[1] || oppProj[0] > ourProj[1] || ourProj[2] > oppProj[3] || oppProj[2] > ourProj[3]) continue;
                    if (ourProj[1] < oppProj[0] + blockWH[0] / 5.0f || ourProj[0] > oppProj[1] - blockWH[0] / 5.0f) {
                        float singn = y > 0.0f ? -0.1f : 0.1f;
                        CarManager.cars[i2].speedY = singn * CarManager.cars[i2].speed;
                        continue;
                    }
                    cars[i2].setEffect();
                    All3D.newEff(CarManager.cars[i2].posInArray, 0);
                }
                float y = -OurCar.x;
                float blockPos = Road.roadX[ind];
                float x = blockPos - OurCar.y;
                if (y * y + x * x < 6.0f) {
                    float[] ourProj = CarManager.getMinMax(OurCar.speedY, OurCar.speedX, OurCar.speed, OurCar.WIDTH * 2.0f, OurCar.HEITH);
                    float[] oppProj = new float[]{-blockWH[0] / 2.0f, blockWH[0] / 2.0f, blockPos - blockWH[1] / 2.0f, blockPos + blockWH[1] / 2.0f};
                    ourProj[0] = ourProj[0] + OurCar.x;
                    ourProj[1] = ourProj[1] + OurCar.x;
                    if (!(ourProj[0] > oppProj[1] || oppProj[0] > ourProj[1] || ourProj[2] > oppProj[3] || oppProj[2] > ourProj[3])) {
                        if (ourProj[1] < oppProj[0] + blockWH[0] / 8.0f || ourProj[0] > oppProj[1] - blockWH[0] / 8.0f) {
                            float singn = y > 0.0f ? -0.1f : 0.1f;
                            OurCar.speedY = singn * OurCar.speed;
                            OurCar.createMessage((short)49);
                        } else {
                            OurCar.setEffect();
                            All3D.newEff(-1, 0);
                        }
                    }
                }
            }
        }
    }

    private static final strictfp float[] getMinMax(float speedY, float speedX, float speed, float W2, float H2) {
        float[] result = new float[4];
        float sin2 = -speedY / speed;
        float cos2 = speedX / speed;
        float x0 = 0.0f;
        float y0 = 0.0f;
        float x1 = H2 * sin2;
        float y1 = H2 * cos2;
        float x3 = y1 * W2 / H2;
        float y3 = -x1 * W2 / H2;
        float x2 = (x1 + x3) / 2.0f;
        float y2 = (y1 + y3) / 2.0f;
        x0 -= x2;
        y0 -= y2;
        x1 -= x2;
        y1 -= y2;
        x3 -= x2;
        y3 -= y2;
        result[0] = x0;
        result[1] = y0;
        result[2] = x0;
        result[3] = y0;
        result[0] = Math.min(x1, result[0]);
        result[1] = Math.max(x1, result[1]);
        result[2] = Math.min(y1, result[2]);
        result[3] = Math.max(y1, result[3]);
        result[0] = Math.min(x2, result[0]);
        result[1] = Math.max(x2, result[1]);
        result[2] = Math.min(y2, result[2]);
        result[3] = Math.max(y2, result[3]);
        result[0] = Math.min(x3, result[0]);
        result[1] = Math.max(x3, result[1]);
        result[2] = Math.min(y3, result[2]);
        result[3] = Math.max(y3, result[3]);
        return result;
    }

    private static boolean caheckCollision(OpponentCar carCollis, OpponentCar carCollis2) {
        float y = carCollis.x - carCollis2.x;
        float x = carCollis.y - carCollis2.y;
        if ((double)(y * y + x * x) < 2.8899999999999997) {
            float[] ourProj = CarManager.getMinMax(carCollis2.speedY, carCollis2.speedX, carCollis2.speed, carCollis2.WIDTH, carCollis2.HEITH);
            float[] oppProj = CarManager.getMinMax(carCollis.speedY, carCollis.speedX * (float)carCollis.dir, carCollis.speed, carCollis.WIDTH, carCollis.HEITH);
            ourProj[0] = ourProj[0] + carCollis2.x;
            ourProj[1] = ourProj[1] + carCollis2.x;
            ourProj[2] = ourProj[2] + carCollis2.y;
            ourProj[3] = ourProj[3] + carCollis2.y;
            oppProj[0] = oppProj[0] + carCollis.x;
            oppProj[1] = oppProj[1] + carCollis.x;
            oppProj[2] = oppProj[2] + carCollis.y;
            oppProj[3] = oppProj[3] + carCollis.y;
            if (ourProj[0] > oppProj[1] || oppProj[0] > ourProj[1] || ourProj[2] > oppProj[3] || oppProj[2] > ourProj[3]) {
                return false;
            }
            if (carCollis.hitedBy == -1) {
                carCollis2.hitedBy = carCollis.posInArray;
            } else if (carCollis2.hitedBy == -1) {
                carCollis.hitedBy = carCollis2.posInArray;
            } else {
                carCollis.hitedBy = carCollis2.posInArray;
                carCollis2.hitedBy = carCollis.posInArray;
            }
            if (!carCollis2.collis[carCollis.posInArray]) {
                if (carCollis.dir < 0) {
                    if ((double)DevKit.abs(carCollis2.speedY / carCollis2.speed - carCollis.speedY / carCollis.speed) < 0.5) {
                        if (DevKit.abs(y) < (carCollis2.WIDTH + carCollis.WIDTH) / 4.0f) {
                            carCollis2.setEffect();
                            All3D.newEff(carCollis2.posInArray, 0);
                        } else if (DevKit.abs(y) > (carCollis2.WIDTH + carCollis.WIDTH) * 2.0f / 5.0f) {
                            float singn = y > 0.0f ? -0.1f : 0.1f;
                            carCollis2.speedY = singn * carCollis2.speed * carCollis.WEITH / carCollis2.WEITH;
                            carCollis.speedY = -singn * carCollis.speed * carCollis2.WEITH / carCollis.WEITH;
                        } else {
                            float singn = y > 0.0f ? 1.0f : -1.0f;
                            carCollis2.rotForce = singn * (carCollis2.engForce + carCollis.engForce) * carCollis.WEITH / carCollis2.WEITH;
                            carCollis2.speedY = -singn * (carCollis2.speedY + carCollis.speedY) * carCollis.WEITH / carCollis2.WEITH;
                            carCollis.rotForce = -singn * (carCollis2.engForce + carCollis.engForce) * carCollis2.WEITH / carCollis.WEITH;
                            carCollis.speedY = -carCollis2.speedY;
                        }
                    }
                } else if (DevKit.abs(x) > (carCollis2.HEITH + carCollis.HEITH) * 3.0f / 8.0f || Math.abs(carCollis2.speedY - carCollis.speedY) < 1.0f) {
                    int sign = x > 0.0f ? 1 : -1;
                    carCollis.speedY += (float)sign * carCollis2.speedY * carCollis2.WEITH / carCollis.WEITH;
                    carCollis.speedY += y / (carCollis2.WIDTH + carCollis.WIDTH) * 2.0f * (carCollis2.speed - carCollis.speed) * carCollis2.WEITH / carCollis.WEITH;
                    carCollis2.engForceY = 0.0f;
                    float spWas = carCollis2.speedX;
                    carCollis2.speedX -= (carCollis2.speedX - carCollis.speedX) * carCollis.WEITH / carCollis2.WEITH;
                    if (carCollis2.speedX <= 0.0f) {
                        carCollis2.speedX = 0.1f;
                    }
                    carCollis.speedX += (spWas - carCollis.speedX) * carCollis2.WEITH / carCollis.WEITH;
                } else {
                    float yForse = carCollis2.engForceY - carCollis.engForceY;
                    carCollis.engForceY += yForse * carCollis2.WEITH / carCollis.WEITH;
                    carCollis2.engForceY -= yForse * carCollis.WEITH / carCollis2.WEITH;
                    float ySpeed = carCollis2.speedY - carCollis.speedY;
                    carCollis.speedY += ySpeed * carCollis2.WEITH / carCollis.WEITH;
                    carCollis2.speedY -= ySpeed * carCollis.WEITH / carCollis2.WEITH;
                }
            }
            return true;
        }
        return false;
    }

    private static boolean caheckCollision2(OpponentCar carCollis, OpponentCar carCollis2) {
        float y = carCollis.x - carCollis2.x;
        float x = carCollis.y - carCollis2.y;
        if ((double)(y * y + x * x) < 2.8899999999999997) {
            float[] ourProj = CarManager.getMinMax(carCollis2.speedY, carCollis2.speedX, carCollis2.speed, carCollis2.WIDTH, carCollis2.HEITH);
            float[] oppProj = CarManager.getMinMax(carCollis.speedY, carCollis.speedX * (float)carCollis.dir, carCollis.speed, carCollis.WIDTH, carCollis.HEITH);
            oppProj[0] = oppProj[0] + y;
            oppProj[1] = oppProj[1] + y;
            float temp = oppProj[2];
            oppProj[2] = x - oppProj[3];
            oppProj[3] = x - temp;
            if (ourProj[0] > oppProj[1] || oppProj[0] > ourProj[1] || ourProj[2] > oppProj[3] || oppProj[2] > ourProj[3]) {
                return false;
            }
            if (carCollis.hitedBy == -1) {
                carCollis2.hitedBy = carCollis.posInArray;
            } else if (carCollis2.hitedBy == -1) {
                carCollis.hitedBy = carCollis2.posInArray;
            } else {
                carCollis.hitedBy = carCollis2.posInArray;
                carCollis2.hitedBy = carCollis.posInArray;
            }
            if (!carCollis2.collis[carCollis.posInArray]) {
                if (DevKit.abs(x) > (carCollis2.HEITH + carCollis.HEITH) * 3.0f / 8.0f || Math.abs(carCollis2.speedY - carCollis.speedY) < 1.0f) {
                    int sign = x > 0.0f ? 1 : -1;
                    carCollis.speedY += (float)sign * carCollis2.speedY * carCollis2.WEITH / carCollis.WEITH;
                    carCollis.speedY += y / (carCollis2.WIDTH + carCollis.WIDTH) * 2.0f * (carCollis2.speed - carCollis.speed) * carCollis2.WEITH / carCollis.WEITH;
                    carCollis2.engForceY = 0.0f;
                    float spWas = carCollis2.speedX;
                    carCollis2.speedX -= (carCollis2.speedX - carCollis.speedX) * carCollis.WEITH / carCollis2.WEITH;
                    if (carCollis2.speedX <= 0.0f) {
                        carCollis2.speedX = 0.1f;
                    }
                    carCollis.speedX += (spWas - carCollis.speedX) * carCollis2.WEITH / carCollis.WEITH;
                } else {
                    float yForse = carCollis2.engForceY - carCollis.engForceY;
                    carCollis.engForceY += yForse * carCollis2.WEITH / carCollis.WEITH;
                    carCollis2.engForceY -= yForse * carCollis.WEITH / carCollis2.WEITH;
                    float ySpeed = carCollis2.speedY - carCollis.speedY;
                    carCollis.speedY += ySpeed * carCollis2.WEITH / carCollis.WEITH;
                    carCollis2.speedY -= ySpeed * carCollis.WEITH / carCollis2.WEITH;
                }
            }
            return true;
        }
        return false;
    }
}

