/*
 * Decompiled with CFR 0.152.
 */
package com.gamsole.monsterninja;

import com.gamsole.monsterninja.GameSettings;
import com.gamsole.monsterninja.JavaSprite;
import com.gamsole.monsterninja.LanderAlpha;
import com.gamsole.monsterninja.LanguageSelector;
import com.gamsole.monsterninja.MonsterNinjaMIDlet;
import com.gamsole.monsterninja.models.LandaBase;
import java.io.InputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class MonsterNinjaScreen
extends GameCanvas
implements Runnable,
PlayerListener {
    MonsterNinjaMIDlet timberManMIDlet;
    int volume = 100;
    Font fontA;
    Font fontC;
    boolean sound;
    boolean isTouch;
    boolean touchOnly;
    boolean IsPage2;
    GameSettings gameSettings;
    Image buffer;
    Sprite bufferSprite;
    Graphics spriteBatch;
    LanderAlpha landerAlpha;
    int bufferTransform = 0;
    Font small;
    Font large;
    boolean loading;
    long mLastTime;
    double gameTime;
    JavaSprite foreground;
    JavaSprite background;
    JavaSprite items;
    JavaSprite numbers;
    JavaSprite board;
    JavaSprite text;
    JavaSprite load;
    JavaSprite extra;
    JavaSprite buttons;
    JavaSprite[] ninjaObjects;
    JavaSprite[] splat;
    boolean keyDown;
    boolean highlight;
    boolean switchKeys;
    boolean touchDown;
    int key;
    static boolean active = true;
    static boolean inbackground = false;

    public MonsterNinjaScreen(MonsterNinjaMIDlet timberManMIDlet) {
        super(false);
        this.setFullScreenMode(true);
        active = true;
        this.timberManMIDlet = timberManMIDlet;
        this.gameSettings = new GameSettings();
        this.gameSettings.Status = 0;
        this.gameSettings.ShowHelp = true;
        this.loadSound();
    }

    public void run() {
        while (MonsterNinjaScreen.getActive()) {
            try {
                Thread.sleep(1L);
                if (MonsterNinjaScreen.getRunningBackground()) continue;
                this.checkKeyInput();
                this.updategame();
                this.paint(this.getGraphics());
                this.flushGraphics();
            }
            catch (Exception e) {
                System.out.println("Error: " + e.getMessage());
            }
        }
        this.stopSound();
        this.timberManMIDlet.stopWhotMIDlet();
    }

    void setLoading() {
        this.loading = true;
        this.paint(this.getGraphics());
        this.flushGraphics();
    }

    private void playSound(String sound) {
        try {
            if (MonsterNinjaMIDlet.musicPlayer != null) {
                MonsterNinjaMIDlet.musicPlayer.deallocate();
                MonsterNinjaMIDlet.musicPlayer.close();
                MonsterNinjaMIDlet.musicPlayer = null;
            }
            InputStream in = this.getClass().getResourceAsStream("/" + sound);
            String type = "audio/midi";
            if (sound.endsWith(".wav")) {
                type = "audio/x-wav";
            } else if (sound.endsWith(".mp3")) {
                type = "audio/mpeg";
            }
            MonsterNinjaMIDlet.musicPlayer = Manager.createPlayer((InputStream)in, (String)type);
            MonsterNinjaMIDlet.musicPlayer.realize();
            MonsterNinjaMIDlet.musicPlayer.prefetch();
            MonsterNinjaMIDlet.musicPlayer.setLoopCount(-1);
            MonsterNinjaMIDlet.musicPlayer.start();
            MonsterNinjaMIDlet.volControl = (VolumeControl)MonsterNinjaMIDlet.musicPlayer.getControl("VolumeControl");
            MonsterNinjaMIDlet.volControl.setLevel(this.volume);
        }
        catch (Exception e) {
            System.out.println("Error Playing Music");
        }
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (event.equals("endOfMedia")) {
            this.playSound("gamesound.mid");
        }
    }

    private void stopSound() {
        try {
            MonsterNinjaMIDlet.musicPlayer.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void volumeUp() {
        if (this.volume < 100) {
            this.sound = true;
            this.volume += 10;
            MonsterNinjaMIDlet.volControl.setLevel(this.volume);
        }
    }

    private void volumeDown() {
        if (this.volume > 0) {
            this.volume -= 10;
            MonsterNinjaMIDlet.volControl.setLevel(this.volume);
        }
    }

    protected boolean deactivate() {
        MonsterNinjaScreen.setRunningBackground(true);
        this.stopSound();
        return true;
    }

    protected boolean activate() {
        MonsterNinjaScreen.setRunningBackground(false);
        return true;
    }

    protected void pointerDragged(int x, int y) {
        this.ProcessTouchDown(x, y, 1);
    }

    protected void pointerPressed(int x, int y) {
        this.ProcessTouchDown(x, y, 0);
    }

    protected void pointerReleased(int x, int y) {
        this.ProcessTouchRelease(x, y);
    }

    private void updategame() {
        long now = System.currentTimeMillis();
        if (this.mLastTime > now) {
            return;
        }
        if (this.mLastTime == 0L) {
            this.mLastTime = now;
        }
        this.gameTime = (double)(now - this.mLastTime) / 1000.0;
        this.mLastTime = now;
        if (this.gameTime > (double)0.021f) {
            // empty if block
        }
        try {
            if (!this.gameSettings.IsPaused) {
                if (this.gameSettings.Status == 0) {
                    this.gameSettings.DefaultAnimator = (float)((double)this.gameSettings.DefaultAnimator + this.gameTime * 1000.0);
                    if (this.gameSettings.DefaultAnimator >= 2000.0f) {
                        this.gameSettings.Status = 3;
                    }
                } else if (this.gameSettings.Status == 220) {
                    if (this.gameSettings.BoardY < 10) {
                        this.gameSettings.BoardY = (int)((float)this.gameSettings.BoardY + 500.0f * (float)this.gameTime);
                        if (this.gameSettings.BoardY >= 10) {
                            this.gameSettings.BoardY = 10;
                        }
                    }
                } else if (this.gameSettings.Status == 205) {
                    this.gameSettings.DefaultAnimator = (float)((double)this.gameSettings.DefaultAnimator + this.gameTime * 1000.0);
                    if (this.gameSettings.DefaultAnimator >= 1000.0f) {
                        this.Gameover();
                    }
                } else if (this.gameSettings.ShowHelp) {
                    this.gameSettings.DefaultAnimator = (float)((double)this.gameSettings.DefaultAnimator + this.gameTime * 1000.0);
                    if (this.gameSettings.DefaultAnimator >= 10000.0f) {
                        this.gameSettings.DefaultAnimator = 0.0f;
                    }
                } else if (this.gameSettings.Status == 100 && !this.gameSettings.ShowHelp && !this.gameSettings.IsPaused) {
                    this.gameSettings.updateGameRunning(this.gameTime);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void loadMainContent() {
        if (!this.isTouch) {
            this.gameSettings.SelectedMenu = 0;
        }
        this.setLoading();
        this.loadGameContent();
        this.loadMainOptions();
        this.gameSettings.Status = 1;
        this.loading = false;
    }

    void loadAllGameContent() {
        this.setLoading();
        this.loadGameOptions();
        this.gameSettings.SelectedMenu = 0;
    }

    void loadGameContent() {
        try {
            this.background = new JavaSprite("background.png", 320, 240);
            this.ninjaObjects = new JavaSprite[6];
            this.splat = new JavaSprite[5];
            for (int i = 0; i < this.ninjaObjects.length; ++i) {
                this.ninjaObjects[i] = new JavaSprite("ninjaobject" + i + ".png", 48, 48);
                if (i >= 5) continue;
                this.splat[i] = new JavaSprite("splat" + i + ".png", 24, 24);
            }
            this.extra = new JavaSprite("life.png", 36, 36);
            this.gameSettings.IsPaused = false;
            System.out.println("Loaded more");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void StartGame() {
        this.gameSettings.StartGame();
        this.loadAllGameContent();
        if (this.gameSettings.ShowHelp) {
            this.loadHelp();
        } else {
            this.loadPause();
        }
        this.loading = false;
    }

    void Gameover() {
        try {
            this.board = new JavaSprite("gameover.png", 140, 110);
            LanguageSelector.setRoundScreenLanguage();
            this.gameSettings.Status = 220;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void loadGameOptions() {
        try {
            this.gameSettings.IsPaused = false;
            System.out.println("Loaded loadGameOptions");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void loadMainOptions() {
        try {
            this.board = new JavaSprite("title.png", 250, 92);
            this.text = new JavaSprite("icons.png", 40, 40);
            this.buttons = new JavaSprite("buttons.png", 160, 50);
            this.gameSettings.IsPaused = false;
            System.out.println("Loaded loadMainOptions");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void loadHelp() {
        if (!this.loading) {
            this.setLoading();
        }
        try {
            this.items = new JavaSprite("crosshair.png", 100, 100);
            if (this.isTouch) {
                LanguageSelector.setTouchHelpScreenLanguage();
            } else {
                LanguageSelector.setHelpScreenLanguage();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loading = false;
    }

    void loadPause() {
        if (!this.loading) {
            this.setLoading();
        }
        try {
            this.board = new JavaSprite("crosshair.png", 100, 100);
            this.items = new JavaSprite("explosion.png", 40, 40);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loading = false;
    }

    void loadSound() {
        int sound = new LandaBase().getValue("sound");
        if (sound == 0) {
            this.gameSettings.Sound = true;
            this.playSound("gamesound.mid");
        } else {
            this.gameSettings.Sound = false;
        }
    }

    void LoadContent() {
        try {
            this.landerAlpha = new LanderAlpha();
            LanguageSelector.setLanguageSelect();
            this.background = new JavaSprite("developer.png", 240, 80);
            this.foreground = new JavaSprite("blackfilm.png", 40, 40);
            this.items = new JavaSprite("flags.png", 45, 30);
            this.load = new JavaSprite("load.png", 96, 96);
            this.buttons = new JavaSprite("buttons.png", 160, 50);
            this.numbers = new JavaSprite("numbers.png", 20, 24);
            this.large = Font.getFont((int)32, (int)0, (int)16);
            this.small = Font.getFont((int)64, (int)0, (int)8);
        }
        catch (Exception e) {
            System.out.println("Load Content:" + e.getMessage());
        }
    }

    public void keyPressed(int key) {
        this.isTouch = false;
        this.setKey(key);
        this.setKeyDown(true);
    }

    public void keyRepeated(int key) {
        this.isTouch = false;
        this.keyPressed(key);
    }

    public void keyReleased(int key) {
        this.isTouch = false;
        this.setKeyDown(false);
    }

    public synchronized boolean keyDown() {
        return this.keyDown;
    }

    public synchronized void setKeyDown(boolean keyDown) {
        this.keyDown = keyDown;
    }

    public synchronized void setKey(int key) {
        this.key = key;
    }

    public synchronized int getKey() {
        return this.key;
    }

    public void checkKeyInput() {
        int keyState = this.getKey();
        this.setKey(-10000);
        try {
            if (keyState == -7) {
                this.highlight = true;
            } else if (keyState == -8 || keyState == -6) {
                this.highlight = true;
                this.doBack();
            } else if (this.getGameAction(keyState) == 10) {
                this.highlight = true;
            } else if (this.getGameAction(keyState) == 9) {
                this.highlight = true;
            } else if (keyState == 2 || 2 == this.getGameAction(keyState)) {
                this.highlight = true;
                if (this.switchKeys) {
                    this.doDown();
                } else {
                    this.doLeft();
                }
            } else if (keyState == 5 || 5 == this.getGameAction(keyState)) {
                this.highlight = true;
                if (this.switchKeys) {
                    this.doUp();
                } else {
                    this.doRight();
                }
            } else if (keyState == 1 || 1 == this.getGameAction(keyState)) {
                this.highlight = true;
                if (this.switchKeys) {
                    this.doLeft();
                } else {
                    this.doUp();
                }
            } else if (keyState == 6 || 6 == this.getGameAction(keyState)) {
                this.highlight = true;
                if (this.switchKeys) {
                    this.doRight();
                } else {
                    this.doDown();
                }
            } else if (keyState == 8 || 8 == this.getGameAction(keyState)) {
                this.highlight = true;
                this.doFire();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void ProcessTouchRelease(int xx, int yy) {
        this.isTouch = true;
        int x = yy * 640 / JavaSprite.screenWidth;
        int y = (JavaSprite.screenHeight - xx) * 480 / JavaSprite.screenHeight;
        if (this.gameSettings.IsPaused) {
            if (x > 160 && x < 480) {
                if (y > 150 & y < 250) {
                    this.doBack();
                } else if (y > 250 & y < 350) {
                    this.doFire();
                } else if (y > 350 & y < 450) {
                    this.doFire();
                }
            }
        } else if (this.gameSettings.Status == 220) {
            if (x > 160 && x < 480) {
                if (y > 250 & y < 350) {
                    this.doFire();
                } else if (y > 350 & y < 450) {
                    this.doFire();
                }
            }
        } else if (this.gameSettings.Status == 1) {
            if (x > 160 && x < 480) {
                if (y > 250 & y < 350) {
                    this.doFire();
                } else if (y > 350 & y < 450) {
                    this.doFire();
                }
            }
        } else if (this.gameSettings.Status == 3) {
            if (y > 20 & y < 420) {
                this.doFire();
            }
        } else if (this.gameSettings.ShowHelp) {
            this.doFire();
        } else if (this.gameSettings.Status == 100 && y < 100 && x > 270 && x < 370) {
            this.doBack();
        }
        this.gameSettings.SelectedMenu = -1;
        this.touchOnly = false;
        this.touchDown = false;
    }

    void ProcessTouchDown(int xx, int yy, int touchType) {
        block4: {
            int y;
            int x;
            block11: {
                block9: {
                    block10: {
                        block7: {
                            block8: {
                                block3: {
                                    block6: {
                                        block5: {
                                            this.isTouch = true;
                                            x = yy * 640 / JavaSprite.screenWidth;
                                            y = (JavaSprite.screenHeight - xx) * 480 / JavaSprite.screenHeight;
                                            x -= JavaSprite.adjustX;
                                            if (!this.gameSettings.IsPaused) break block3;
                                            this.gameSettings.SelectedMenu = -1;
                                            if (x <= 160 || x >= 480) break block4;
                                            if (!(y > 150 & y < 250)) break block5;
                                            this.gameSettings.SelectedMenu = 0;
                                            break block4;
                                        }
                                        if (!(y > 250 & y < 350)) break block6;
                                        this.gameSettings.SelectedMenu = 1;
                                        break block4;
                                    }
                                    if (!(y > 350 & y < 450)) break block4;
                                    this.gameSettings.SelectedMenu = 2;
                                    break block4;
                                }
                                if (this.gameSettings.Status != 220) break block7;
                                this.gameSettings.SelectedMenu = -1;
                                if (x <= 160 || x >= 480) break block4;
                                if (!(y > 250 & y < 350)) break block8;
                                this.gameSettings.SelectedMenu = 0;
                                break block4;
                            }
                            if (!(y > 350 & y < 450)) break block4;
                            this.gameSettings.SelectedMenu = 1;
                            break block4;
                        }
                        if (this.gameSettings.Status != 1) break block9;
                        this.gameSettings.SelectedMenu = -1;
                        if (x <= 160 || x >= 480) break block4;
                        if (!(y > 250 & y < 350)) break block10;
                        this.gameSettings.SelectedMenu = 0;
                        break block4;
                    }
                    if (!(y > 350 & y < 450)) break block4;
                    this.gameSettings.SelectedMenu = 1;
                    break block4;
                }
                if (this.gameSettings.Status != 3) break block11;
                this.gameSettings.SelectedMenu = -1;
                if (!(y > 20 & y < 420)) break block4;
                this.gameSettings.SelectedMenu = (y - 20) / 80;
                break block4;
            }
            if (this.gameSettings.Status == 100 && !this.touchDown) {
                for (int i = 0; i < this.gameSettings.NinjaObjects.length; ++i) {
                    if (!this.gameSettings.NinjaObjects[i].coillides(x, y)) continue;
                    if (this.gameSettings.NinjaObjects[i].type == 5) {
                        this.gameSettings.Explosion = true;
                        this.gameSettings.Gameover();
                        break;
                    }
                    this.gameSettings.NinjaObjects[i].destroy();
                    this.gameSettings.updateScore();
                    break;
                }
            }
        }
    }

    void toggleSound() {
        if (this.gameSettings.Sound) {
            this.gameSettings.Sound = false;
            this.stopSound();
            new LandaBase().addValueCommit("sound", 1);
        } else {
            this.gameSettings.Sound = true;
            this.playSound("gamesound.mid");
            new LandaBase().addValueCommit("sound", 0);
        }
    }

    void doBack() {
        if (this.gameSettings.IsPaused) {
            this.gameSettings.IsPaused = false;
            if (!this.isTouch) {
                this.gameSettings.SelectedMenu = 0;
            }
        } else if (this.gameSettings.ShowHelp) {
            this.doFire();
        } else if (this.gameSettings.Status >= 100 && this.gameSettings.Status <= 205) {
            this.gameSettings.IsPaused = true;
        }
    }

    void doLeft() {
        this.doUp();
    }

    void doUp() {
        block4: {
            block6: {
                block5: {
                    block3: {
                        if (this.gameSettings.Status != 1 && this.gameSettings.Status != 220) break block3;
                        --this.gameSettings.SelectedMenu;
                        if (this.gameSettings.SelectedMenu >= 0) break block4;
                        this.gameSettings.SelectedMenu = 1;
                        break block4;
                    }
                    if (this.gameSettings.Status != 3) break block5;
                    --this.gameSettings.SelectedMenu;
                    if (this.gameSettings.SelectedMenu >= 0) break block4;
                    this.gameSettings.SelectedMenu = 4;
                    break block4;
                }
                if (!this.gameSettings.IsPaused) break block6;
                --this.gameSettings.SelectedMenu;
                if (this.gameSettings.SelectedMenu >= 0) break block4;
                this.gameSettings.SelectedMenu = 2;
                break block4;
            }
            if (this.gameSettings.Status == 100 && !this.gameSettings.ShowHelp) {
                int startIndex = this.gameSettings.SelectedNinjaObject;
                for (int i = 0; i < this.gameSettings.NinjaObjects.length; ++i) {
                    if (++startIndex >= this.gameSettings.NinjaObjects.length) {
                        startIndex = 0;
                    }
                    if (!this.gameSettings.IsActive[startIndex] || this.gameSettings.NinjaObjects[startIndex].status == -1 || !(this.gameSettings.NinjaObjects[startIndex].y < 440.0f)) continue;
                    this.gameSettings.SelectedNinjaObject = startIndex;
                    break;
                }
            }
        }
    }

    void doDown() {
        if (this.gameSettings.Status == 1 || this.gameSettings.Status == 220) {
            ++this.gameSettings.SelectedMenu;
            this.gameSettings.SelectedMenu %= 2;
        } else if (this.gameSettings.Status == 3) {
            ++this.gameSettings.SelectedMenu;
            this.gameSettings.SelectedMenu %= 5;
        } else if (this.gameSettings.IsPaused) {
            ++this.gameSettings.SelectedMenu;
            this.gameSettings.SelectedMenu %= 3;
        } else if (this.gameSettings.Status == 100 && !this.gameSettings.ShowHelp) {
            int startIndex = this.gameSettings.SelectedNinjaObject;
            for (int i = 0; i < this.gameSettings.NinjaObjects.length; ++i) {
                if (--startIndex < 0) {
                    startIndex = this.gameSettings.NinjaObjects.length - 1;
                }
                if (!this.gameSettings.IsActive[startIndex] || this.gameSettings.NinjaObjects[startIndex].status == -1 || !(this.gameSettings.NinjaObjects[startIndex].y < 440.0f)) continue;
                this.gameSettings.SelectedNinjaObject = startIndex;
                break;
            }
        }
    }

    void doRight() {
        this.doDown();
    }

    void doFire() {
        if (this.gameSettings.IsPaused) {
            if (this.gameSettings.SelectedMenu == 0) {
                this.doBack();
            } else if (this.gameSettings.SelectedMenu == 1) {
                this.StartGame();
            } else {
                this.loadMainContent();
                this.gameSettings.Status = 1;
                this.gameSettings.SelectedMenu = 0;
            }
            this.gameSettings.IsPaused = false;
        } else if (this.gameSettings.Status == 220) {
            if (this.gameSettings.SelectedMenu == 0) {
                this.StartGame();
            } else {
                this.loadMainContent();
                this.gameSettings.Status = 1;
                this.gameSettings.SelectedMenu = 0;
            }
        } else if (this.gameSettings.Status == 1) {
            if (this.gameSettings.SelectedMenu == 0) {
                this.StartGame();
            } else {
                this.toggleSound();
            }
        } else if (this.gameSettings.Status == 3) {
            LanguageSelector.SelectedLanguage = this.gameSettings.SelectedMenu * 1;
            this.loadMainContent();
            this.gameSettings.Status = 1;
            this.gameSettings.SelectedMenu = 0;
        } else if (this.gameSettings.ShowHelp) {
            ++this.gameSettings.HelpIndex;
            if (this.gameSettings.HelpIndex == 1 && this.isTouch) {
                ++this.gameSettings.HelpIndex;
            }
            if (this.gameSettings.HelpIndex >= 4) {
                this.gameSettings.ShowHelp = false;
                System.out.println("Help off");
                this.loadPause();
            }
        } else if (this.gameSettings.Status == 100 && this.gameSettings.SelectedNinjaObject != -1 && this.gameSettings.NinjaObjects[this.gameSettings.SelectedNinjaObject].y < 440.0f) {
            if (this.gameSettings.NinjaObjects[this.gameSettings.SelectedNinjaObject].type == 5) {
                this.gameSettings.Explosion = true;
                this.gameSettings.Gameover();
            } else if (this.gameSettings.NinjaObjects[this.gameSettings.SelectedNinjaObject].status != -1) {
                this.gameSettings.NinjaObjects[this.gameSettings.SelectedNinjaObject].destroy();
                this.gameSettings.updateScore();
            }
        }
    }

    public static synchronized void setActive(boolean act) {
        active = act;
    }

    public static synchronized boolean getActive() {
        return active;
    }

    public static synchronized void setRunningBackground(boolean active) {
        inbackground = active;
    }

    public static synchronized boolean getRunningBackground() {
        return inbackground;
    }

    void updateDrawVariables() {
        JavaSprite.adjustX = 0;
        JavaSprite.screenHeight = this.getHeight();
        JavaSprite.screenWidth = this.getWidth();
        if (this.getWidth() > this.getHeight()) {
            JavaSprite.screenHeight = this.getHeight();
            JavaSprite.screenWidth = this.getWidth();
            this.buffer = Image.createImage((int)JavaSprite.screenWidth, (int)JavaSprite.screenHeight);
            this.bufferSprite = new Sprite(this.buffer);
        } else {
            this.switchKeys = true;
            this.bufferTransform = 5;
            JavaSprite.screenHeight = this.getWidth();
            JavaSprite.screenWidth = this.getHeight();
            this.buffer = Image.createImage((int)JavaSprite.screenWidth, (int)JavaSprite.screenHeight);
            this.bufferSprite = new Sprite(this.buffer);
        }
        this.spriteBatch = this.buffer.getGraphics();
    }

    public void paint(Graphics graphics) {
        try {
            if (this.bufferSprite == null) {
                this.updateDrawVariables();
                this.LoadContent();
            }
            this.spriteBatch = this.buffer.getGraphics();
            this.spriteBatch.setColor(225, 225, 225);
            this.spriteBatch.fillRect(0, 0, this.buffer.getWidth(), this.buffer.getHeight());
            if (this.loading) {
                this.load.setRefPixelPosition(224, 150);
                this.load.paint(this.spriteBatch);
                this.landerAlpha.drawString(this.spriteBatch, this.large, LanguageSelector.getloadingText(), 0, 370, 640, (byte)1, 3);
            } else if (this.gameSettings.Status == 0) {
                this.fillLanderRect(graphics, 255, 255, 255, 0, 0, 640, 480);
                this.background.setRefPixelPosition(80, 250);
                this.background.paint(this.spriteBatch);
            } else if (this.gameSettings.Status == 3) {
                this.drawLanguage(this.spriteBatch);
            } else {
                this.background.setRefPixelPosition(0, 0);
                this.background.paint(this.spriteBatch);
                if (this.gameSettings.Status == 1) {
                    this.drawMainScreen(this.spriteBatch);
                } else if (this.gameSettings.Status == 220) {
                    if (this.gameSettings.Explosion) {
                        int frame = (int)this.gameSettings.DefaultAnimator / 250;
                        if (frame > 3) {
                            frame = 3;
                        }
                        this.items.setFrame(frame);
                        for (int y = 0; y < 480; y += 80) {
                            for (int x = 0; x < 640; x += 80) {
                                this.items.setRefPixelPosition(x, y);
                                this.items.paint(this.spriteBatch);
                            }
                        }
                    }
                    this.drawGameoverScreen(this.spriteBatch);
                } else if (this.gameSettings.Status >= 100) {
                    this.drawGameScreen(this.spriteBatch);
                    if (this.gameSettings.Explosion) {
                        int frame = (int)this.gameSettings.DefaultAnimator / 250;
                        if (frame > 3) {
                            frame = 3;
                        }
                        this.items.setFrame(frame);
                        for (int y = 0; y < 480; y += 80) {
                            for (int x = 0; x < 640; x += 80) {
                                this.items.setRefPixelPosition(x, y);
                                this.items.paint(this.spriteBatch);
                            }
                        }
                    }
                    if (this.gameSettings.Status == 100 && this.gameSettings.ShowHelp) {
                        this.DrawHelp(this.spriteBatch);
                    } else if (this.gameSettings.IsPaused) {
                        this.drawHUD(this.spriteBatch);
                        this.DrawPause(this.spriteBatch);
                    } else {
                        this.drawHUD(this.spriteBatch);
                    }
                }
            }
            this.bufferSprite.setImage(this.buffer, JavaSprite.screenWidth, JavaSprite.screenHeight);
            this.bufferSprite.setTransform(this.bufferTransform);
            this.bufferSprite.setRefPixelPosition(this.bufferTransform == 5 ? this.buffer.getHeight() : 0, 0);
            this.bufferSprite.paint(graphics);
        }
        catch (Exception e) {
            System.out.println("Paint Error" + e.getMessage() + " Status: " + this.gameSettings.Status);
            e.printStackTrace();
        }
    }

    void drawNumber(int number, Graphics graphics, int x, int y, int width, int type) {
        String stringnumber = "" + number;
        int numberwidth = 40 * stringnumber.length();
        int xStart = x;
        if (type == 1) {
            xStart += (width - numberwidth) / 2;
        } else if (type == 2) {
            xStart += width - numberwidth;
        }
        char[] num = stringnumber.toCharArray();
        for (int i = 0; i < num.length; ++i) {
            this.numbers.setFrame(Integer.parseInt("" + num[i]));
            this.numbers.setRefPixelPosition(xStart, y);
            this.numbers.paint(graphics);
            xStart += 40;
        }
    }

    void drawSelector(Graphics graphics, int x, int y, int width, int height) {
        int red = 100;
        int value = (int)this.gameSettings.DefaultAnimator % 4000;
        red = value < 2000 ? (red += 155 * value / 2000) : 255 - 155 * (value - 2000) / 2000;
        this.fillLanderRect(graphics, red, 0, 0, x, y, width, height);
    }

    void fillLanderRect(Graphics graphics, int red, int green, int blue, int x, int y, int width, int height) {
        graphics.setColor(red, green, blue);
        graphics.fillRect(x * JavaSprite.screenWidth / JavaSprite.DEFAULT_WIDTH + JavaSprite.adjustX, y * JavaSprite.screenHeight / JavaSprite.DEFAULT_HEIGHT, width * JavaSprite.screenWidth / JavaSprite.DEFAULT_WIDTH, height * JavaSprite.screenHeight / JavaSprite.DEFAULT_HEIGHT);
    }

    void drawGameScreen(Graphics graphics) {
        for (int i = 0; i < this.gameSettings.NinjaObjects.length; ++i) {
            this.gameSettings.NinjaObjects[i].draw(graphics, this.ninjaObjects[this.gameSettings.NinjaObjects[i].type], this.gameSettings.NinjaObjects[i].type == 5 ? null : this.splat[this.gameSettings.NinjaObjects[i].type]);
            if (this.gameSettings.SelectedNinjaObject != i) continue;
            this.board.setRefPixelPosition(this.gameSettings.NinjaObjects[i].x - 52.0f, this.gameSettings.NinjaObjects[i].y - 52.0f);
            if (!(this.gameSettings.NinjaObjects[i].y < 440.0f)) continue;
            this.board.paint(graphics);
        }
    }

    public void DrawPause(Graphics spriteBatch) {
        this.drawBlackfilm(spriteBatch, 0, 0, 640, 480);
        if (this.gameSettings.SelectedMenu == 0) {
            this.buttons.setFrame(1);
        } else {
            this.buttons.setFrame(0);
        }
        this.buttons.setRefPixelPosition(160, 150);
        this.buttons.paint(spriteBatch);
        this.text.setFrame(0);
        this.text.setRefPixelPosition(280, 160);
        this.text.paint(spriteBatch);
        if (this.gameSettings.SelectedMenu == 1) {
            this.buttons.setFrame(1);
        } else {
            this.buttons.setFrame(0);
        }
        this.buttons.setRefPixelPosition(160, 250);
        this.buttons.paint(spriteBatch);
        this.text.setFrame(3);
        this.text.setRefPixelPosition(280, 260);
        this.text.paint(spriteBatch);
        if (this.gameSettings.SelectedMenu == 2) {
            this.buttons.setFrame(1);
        } else {
            this.buttons.setFrame(0);
        }
        this.buttons.setRefPixelPosition(160, 350);
        this.buttons.paint(spriteBatch);
        this.text.setFrame(4);
        this.text.setRefPixelPosition(280, 360);
        this.text.paint(spriteBatch);
    }

    public void DrawHelp(Graphics graphics) {
        this.drawBlackfilm(graphics, 0, 0, 640, 480);
        if (this.gameSettings.HelpIndex < 2) {
            int y = 40;
            int x = 16;
            if (this.isTouch) {
                y = 100;
            }
            y = this.landerAlpha.drawString(graphics, this.large, LanguageSelector.Values[0], 10, y, 620, (byte)1, 1);
            y += 70;
            int targetIndex = (int)(this.gameSettings.DefaultAnimator / 2000.0f);
            int targetX = 0;
            int targetY = 0;
            for (int i = 0; i < this.ninjaObjects.length - 1; ++i) {
                this.ninjaObjects[i].setFrame(0);
                this.ninjaObjects[i].setRefPixelPosition(x, y);
                this.ninjaObjects[i].paint(graphics);
                if (i == targetIndex) {
                    targetX = x * 1;
                    targetY = y * 1;
                }
                x += 128;
            }
            this.items.setRefPixelPosition(targetX - 52, targetY - 52);
            this.items.paint(graphics);
            y += 160;
            y = this.landerAlpha.drawString(graphics, this.large, LanguageSelector.Values[this.gameSettings.HelpIndex + 1], 10, y, 620, (byte)1, 1) + 5;
        } else if (this.gameSettings.HelpIndex == 2) {
            int i;
            int y = 20;
            int x = 16;
            y = this.landerAlpha.drawString(graphics, this.large, LanguageSelector.Values[3], 10, y, 620, (byte)1, 1);
            y += 20;
            for (i = 0; i < 3; ++i) {
                this.ninjaObjects[5].setFrame(0);
                this.ninjaObjects[5].setRefPixelPosition(x += 128, y);
                this.ninjaObjects[5].paint(graphics);
            }
            y += 120;
            for (i = 1; i < 2; ++i) {
                y = this.landerAlpha.drawString(graphics, this.large, LanguageSelector.Values[i + 4], 10, y, 620, (byte)1, 1) + 15;
            }
            x = 192;
            for (i = 0; i < 3; ++i) {
                this.extra.setRefPixelPosition(x, y);
                this.extra.paint(graphics);
                x += 92;
            }
        } else if (this.gameSettings.HelpIndex == 3) {
            int y = 240;
            this.landerAlpha.drawString(graphics, this.large, LanguageSelector.Values[6], 20, y, 600, (byte)1, 1);
            int n = 200;
        }
    }

    void drawBlackfilm(Graphics graphics, int x, int y, int width, int height) {
        int columns = width / 80;
        int rows = height / 80;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                this.foreground.setRefPixelPosition(x + j * 80, y);
                this.foreground.paint(graphics);
            }
            y += 80;
        }
    }

    void drawLanguage(Graphics graphics) {
        this.fillLanderRect(graphics, 255, 255, 255, 0, 0, 640, 480);
        this.background.setRefPixelPosition(80, 250);
        int y = 20;
        for (int i = 0; i < LanguageSelector.Values.length; ++i) {
            if (this.gameSettings.SelectedMenu == i) {
                this.drawSelector(graphics, 0, y, 640, 80);
            }
            this.items.setFrame(i);
            this.items.setRefPixelPosition(140, y + 10);
            this.items.paint(graphics);
            this.landerAlpha.drawString(graphics, this.large, LanguageSelector.Values[i], 300, y + 15, 280, (byte)0, this.gameSettings.SelectedMenu == i ? 0 : 3);
            y += 80;
        }
    }

    void drawHUD(Graphics graphics) {
        this.drawNumber(this.gameSettings.Score, graphics, 10, 10, 240, 0);
        int x = 548;
        for (int i = 0; i < this.gameSettings.Lives; ++i) {
            this.extra.setRefPixelPosition(x, 10);
            this.extra.paint(graphics);
            x -= 92;
        }
        if (this.isTouch) {
            this.numbers.setFrame(10);
            this.numbers.setRefPixelPosition(300, 10);
            this.numbers.paint(graphics);
        }
    }

    void drawMainScreen(Graphics graphics) {
        this.board.setRefPixelPosition(50, 70);
        this.board.paint(graphics);
        this.drawBlackfilm(graphics, 0, 0, 640, 80);
        this.landerAlpha.drawString(graphics, this.large, LanguageSelector.getTitleText(), 10, 10, 390, (byte)0, 0);
        this.drawNumber(this.gameSettings.HighestScore, graphics, 320, 10, 320, 2);
        if (this.gameSettings.SelectedMenu == 0) {
            this.buttons.setFrame(1);
        } else {
            this.buttons.setFrame(0);
        }
        this.buttons.setRefPixelPosition(160, 250);
        this.buttons.paint(graphics);
        this.text.setFrame(0);
        this.text.setRefPixelPosition(280, 260);
        this.text.paint(graphics);
        if (this.gameSettings.SelectedMenu == 1) {
            this.buttons.setFrame(1);
        } else {
            this.buttons.setFrame(0);
        }
        this.buttons.setRefPixelPosition(160, 350);
        this.buttons.paint(graphics);
        this.text.setFrame(this.gameSettings.Sound ? 2 : 1);
        this.text.setRefPixelPosition(280, 360);
        this.text.paint(graphics);
    }

    void drawGameoverScreen(Graphics graphics) {
        this.board.setRefPixelPosition(180, this.gameSettings.BoardY);
        this.board.paint(graphics);
        this.landerAlpha.drawString(graphics, this.large, LanguageSelector.Values[2], 10, this.gameSettings.BoardY + 30, 620, (byte)1, 0);
        this.drawNumber(this.gameSettings.Score, graphics, 0, this.gameSettings.BoardY + 60, 640, 1);
        this.landerAlpha.drawString(graphics, this.large, LanguageSelector.Values[3], 10, this.gameSettings.BoardY + 100, 620, (byte)1, 0);
        this.drawNumber(this.gameSettings.HighestScore, graphics, 0, this.gameSettings.BoardY + 130, 640, 1);
        if (this.gameSettings.Status == 220) {
            if (this.gameSettings.SelectedMenu == 0) {
                this.buttons.setFrame(1);
            } else {
                this.buttons.setFrame(0);
            }
            this.buttons.setRefPixelPosition(160, 250);
            this.buttons.paint(graphics);
            this.text.setFrame(0);
            this.text.setRefPixelPosition(280, 260);
            this.text.paint(graphics);
            if (this.gameSettings.SelectedMenu == 1) {
                this.buttons.setFrame(1);
            } else {
                this.buttons.setFrame(0);
            }
            this.buttons.setRefPixelPosition(160, 350);
            this.buttons.paint(graphics);
            this.text.setFrame(5);
            this.text.setRefPixelPosition(280, 360);
            this.text.paint(graphics);
        }
    }
}

