/*
 * Decompiled with CFR 0.152.
 */
package com.zeemote.zc.j2me;

import com.zeemote.zc.DeviceFactory;
import com.zeemote.zc.IStreamConnector;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.midlet.MIDlet;

final class PropertyUtils {
    private static final String LAST_ZEEMOTE_PREFIX = "zp.lc.";
    private static final String AUTO_CONNECT_ENABLED_PROPERTY = "zp.ace";
    private static final String USE_GLOBAL_PREFIX = "ap.ug.";
    private static final char SEPARATOR_CHAR = '|';
    private static final char ESCAPE_CHAR = '\\';
    static final String TRUE_STRING = "true";
    static final String FALSE_STRING = "false";

    private PropertyUtils() {
    }

    private static String getMIDletName(MIDlet mIDlet) {
        return mIDlet.getAppProperty("MIDlet-Name");
    }

    private static String getMIDletVendor(MIDlet mIDlet) {
        return mIDlet.getAppProperty("MIDlet-Vendor");
    }

    private static String createUseGlobalPropertyName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(USE_GLOBAL_PREFIX);
        stringBuffer.append(PropertyUtils.encodeString(string));
        stringBuffer.append('|');
        stringBuffer.append(PropertyUtils.encodeString(string2));
        return stringBuffer.toString();
    }

    private static String createLastConnectedPropertyName(int n) {
        return LAST_ZEEMOTE_PREFIX + n;
    }

    private static boolean containsUseGlobalSetting(Hashtable hashtable, String string, String string2) {
        return hashtable.containsKey(PropertyUtils.createUseGlobalPropertyName(string, string2));
    }

    static boolean containsUseGlobalSetting(Hashtable hashtable, MIDlet object) {
        String string = PropertyUtils.getMIDletVendor(object);
        object = PropertyUtils.getMIDletName(object);
        return PropertyUtils.containsUseGlobalSetting(hashtable, string, (String)object);
    }

    static boolean useGlobalProperties(Hashtable object, String string, String string2) {
        return (object = (String)((Hashtable)object).get(string = PropertyUtils.createUseGlobalPropertyName(string, string2))) != null && ((String)object).equals(TRUE_STRING);
    }

    static boolean useGlobalProperties(Hashtable hashtable, MIDlet object) {
        String string = PropertyUtils.getMIDletVendor(object);
        object = PropertyUtils.getMIDletName(object);
        return PropertyUtils.useGlobalProperties(hashtable, string, (String)object);
    }

    static void setUseGlobalProperties(Hashtable hashtable, String string, String string2, boolean bl) {
        string = PropertyUtils.createUseGlobalPropertyName(string, string2);
        if (bl) {
            hashtable.put(string, TRUE_STRING);
            return;
        }
        hashtable.put(string, FALSE_STRING);
    }

    static void setUseGlobalProperties(Hashtable hashtable, MIDlet object, boolean bl) {
        String string = PropertyUtils.getMIDletVendor(object);
        object = PropertyUtils.getMIDletName(object);
        PropertyUtils.setUseGlobalProperties(hashtable, string, (String)object, bl);
    }

    static IStreamConnector getLastStreamConnector(Hashtable object, int n) {
        String string = PropertyUtils.createLastConnectedPropertyName(n);
        if ((object = (String)((Hashtable)object).get(string)) == null) {
            return null;
        }
        int n2 = PropertyUtils.findSeparator((String)object);
        if (n2 >= 0) {
            String string2 = PropertyUtils.decodeString(((String)object).substring(0, n2));
            object = PropertyUtils.decodeString(((String)object).substring(n2 + 1));
            return DeviceFactory.getStreamConnector(string2, (String)object);
        }
        return null;
    }

    static void setLastStreamConnector(Hashtable hashtable, int n, IStreamConnector iStreamConnector) {
        String string = PropertyUtils.createLastConnectedPropertyName(n);
        CharSequence charSequence = null;
        if (iStreamConnector != null) {
            try {
                charSequence = new StringBuffer();
                charSequence.append(PropertyUtils.encodeString(iStreamConnector.getName()));
                charSequence.append('|');
                charSequence.append(PropertyUtils.encodeString(iStreamConnector.getUri()));
                charSequence = charSequence.toString();
                hashtable.put(string, charSequence);
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
        hashtable.remove(string);
    }

    static boolean containsAutoConnectSetting(Hashtable hashtable) {
        return hashtable.containsKey(AUTO_CONNECT_ENABLED_PROPERTY);
    }

    static boolean isAutoConnectEnabled(Hashtable hashtable) {
        return hashtable.get(AUTO_CONNECT_ENABLED_PROPERTY).equals(TRUE_STRING);
    }

    static void setAutoConnectEnabled(Hashtable hashtable, boolean bl) {
        if (bl) {
            hashtable.put(AUTO_CONNECT_ENABLED_PROPERTY, TRUE_STRING);
            return;
        }
        hashtable.put(AUTO_CONNECT_ENABLED_PROPERTY, FALSE_STRING);
    }

    private static String encodeString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\\' || c2 == '|') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    private static String decodeString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (!bl && c2 == '\\') {
                bl = true;
                continue;
            }
            stringBuffer.append(c2);
            bl = false;
        }
        return stringBuffer.toString();
    }

    private static int findSeparator(String string) {
        boolean bl = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (!bl && c2 == '\\') {
                bl = true;
                continue;
            }
            if (!bl && c2 == '|') {
                return i2;
            }
            bl = false;
        }
        return -1;
    }

    static Vector listGlobalRegisteredApps(Hashtable object) {
        Vector<String> vector = new Vector<String>();
        object = ((Hashtable)object).keys();
        while (object.hasMoreElements()) {
            int n;
            String string = (String)object.nextElement();
            if (!string.startsWith(USE_GLOBAL_PREFIX) || (n = PropertyUtils.findSeparator(string = string.substring(USE_GLOBAL_PREFIX.length()))) < 0) continue;
            String string2 = PropertyUtils.decodeString(string.substring(0, n));
            string = PropertyUtils.decodeString(string.substring(n + 1));
            vector.addElement(string2);
            vector.addElement(string);
        }
        return vector;
    }
}

