/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.game.Sprite;

public class MiniGame
extends GameLayer {
    static final byte STATE_MOVE_CURSOR = 0;
    static final byte STATE_MOVE_PAWN = 1;
    static final byte STATE_MOVE_PAWN_WAIT = 2;
    static final byte STATE_MOVE_PAWN_BACK_WAIT = 3;
    static final byte STATE_EXPLODE_WAIT = 4;
    static final byte STATE_FALL_WAIT = 5;
    static final byte STATE_TUTORIAL = 6;
    static final byte STATE_GOAL_SCREEN = 7;
    static final byte STATE_GAVEOVER_SCREEN = 8;
    static final byte COLOR = 0;
    static final byte LINE = 1;
    StaticImage bg;
    Button leftSoft;
    Button rightSoft;
    Scroll scroll;
    int cellSize;
    Pawn[][] board;
    ColorBackground cursor;
    byte cursorX;
    byte cursorY;
    byte moveCellX;
    byte moveCellY;
    int[] cursorColor = new int[]{0xFFFFFF, 16449389, 16765440, 16670216, 16670216, 16670216, 16765440, 16449389};
    byte cursorColorFrame;
    byte arrowsFrame;
    StaticImage cursorArrowL;
    StaticImage cursorArrowR;
    StaticImage cursorArrowU;
    StaticImage cursorArrowD;
    StaticImage avatar;
    StaticImage avatar_smile;
    StaticImage avatar_eyes;
    byte emotion;
    byte emotionTimer;
    StaticImage[][] timeBar;
    ColorBackground timeBarClipper;
    StaticImage hourGlass;
    StaticImage[] miniorb;
    StaticImage[] miniorbExplosion;
    StaticImage[][] goalCounter;
    byte state;
    Pawn[] tmpPawns1 = new Pawn[8];
    Pawn[] tmpPawns2 = new Pawn[8];
    Menu menu;
    static boolean paused;
    long gameStartTime;
    long gameEndTime;
    int gameDurationTime;
    int gameTimeLeft;
    boolean drawJocker;
    short[][] pointsLine = new short[6][6];
    short[] pointsColor = new short[6];
    byte[][] goal;
    static boolean gameOver;
    boolean goalCompleted;
    GameLayer[] goalScreenLayers;

    public MiniGame() {
        int n;
        int n2;
        this.x = 20;
        this.y = 82;
        this.width = 200;
        this.height = 200;
        this.cellSize = this.width / 8;
        this.menu = new Menu(5);
        this.menu.add(new Label(ResourceManager.getText(4), 180), new Button(Game.rm.getSprite(11), 1), new Event(8));
        this.menu.add(new Label(ResourceManager.getText(52), 180), new Button(Game.rm.getSprite(11), 0), new Event(43, new Object[]{this, new Event(39)}));
        this.menu.add(new Label(ResourceManager.getText(51), 180), new Button(Game.rm.getSprite(11), 6), new Event(43, new Object[]{this, new Event(22)}));
        this.menu.setPosition(20, 105);
        this.menu.setBackground(true);
        this.menu.setVisible(false);
        this.bg = new StaticImage(Game.rm.getSprite(4), 0, 0, Game.canvasWidth, Game.canvasHeight);
        this.leftSoft = new Button(Game.rm.getSprite(2), 0);
        this.leftSoft.setPosition(0, Game.canvasHeight - this.leftSoft.getHeight());
        this.leftSoft.setFrame(3, 0);
        this.rightSoft = new Button(Game.rm.getSprite(2), 2);
        this.rightSoft.setPosition(Game.canvasWidth - this.rightSoft.getWidth(), Game.canvasHeight - this.rightSoft.getHeight());
        this.avatar = new StaticImage(Game.rm.getImage(19));
        this.avatar.setPosition(9, 8);
        this.avatar_smile = new StaticImage(Game.rm.getSprite(58));
        this.avatar_eyes = new StaticImage(Game.rm.getSprite(59));
        this.avatar_smile.setPosition(this.avatar.getX() + 14, this.avatar.getY() + 34);
        this.avatar_eyes.setPosition(this.avatar.getX() + 11, this.avatar.getY() + 20);
        this.timeBar = new StaticImage[2][3];
        Sprite sprite = Game.rm.getSprite(54);
        for (int i = 0; i < 2; ++i) {
            int n3 = i * 3;
            this.timeBar[i][0] = new StaticImage(sprite, n3 + 0, 0);
            this.timeBar[i][1] = new StaticImage(sprite, n3 + 1, 0, 124, sprite.getHeight());
            this.timeBar[i][2] = new StaticImage(sprite, n3 + 2, 0);
            this.timeBar[i][0].setPosition(90, 13);
            this.timeBar[i][1].setPosition(this.timeBar[i][0].getX() + this.timeBar[i][0].getWidth(), this.timeBar[i][0].getY());
            this.timeBar[i][2].setPosition(this.timeBar[i][1].getX() + this.timeBar[i][1].getWidth(), this.timeBar[i][0].getY());
        }
        this.timeBarClipper = new ColorBackground(90, 13, this.timeBar[1][0].getWidth() + this.timeBar[1][1].getWidth() + this.timeBar[1][2].getWidth(), this.timeBar[1][0].getHeight(), -1, -1);
        this.timeBar[1][0].setClipLayer(this.timeBarClipper);
        this.timeBar[1][1].setClipLayer(this.timeBarClipper);
        this.timeBar[1][2].setClipLayer(this.timeBarClipper);
        this.hourGlass = new StaticImage(Game.rm.getImage(55));
        this.hourGlass.setPosition(68, 9);
        this.goalCounter = new StaticImage[3][4];
        this.miniorb = new StaticImage[3];
        this.miniorbExplosion = new StaticImage[3];
        Sprite sprite2 = Game.rm.getSprite(56);
        Sprite sprite3 = Game.rm.getSprite(57);
        for (int i = 2; i >= 0; --i) {
            this.goalCounter[i][0] = new StaticImage(sprite3);
            this.goalCounter[i][1] = new StaticImage(sprite3);
            this.goalCounter[i][2] = new StaticImage(sprite3);
            this.goalCounter[i][3] = new StaticImage(sprite3);
            this.miniorb[i] = new StaticImage(sprite2);
        }
        paused = true;
        gameOver = false;
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = new byte[]{-1, -1, -1};
        byte[] byArray5 = new byte[]{0, 1, 2, 3, 4, 5};
        for (n2 = 0; n2 < 3; ++n2) {
            while (byArray4[n2] < 0) {
                byArray4[n2] = byArray5[Game.rand(6)];
                if (byArray4[n2] < 0) continue;
                byArray5[byArray4[n2]] = -1;
                if (byArray4[n2] == 3) {
                    byArray5[4] = -1;
                    continue;
                }
                if (byArray4[n2] != 4) continue;
                byArray5[3] = -1;
            }
        }
        switch (Game.level) {
            case 0: {
                byArray = new byte[]{0, 0, 0, 1};
                byArray2 = new byte[]{12, 12, 15, 15, 15, 18, 18};
                byArray3 = new byte[]{1, 1, 2};
                break;
            }
            case 1: {
                byArray = new byte[]{0, 0, 0, 1, 1};
                byArray2 = new byte[]{18, 18, 21, 21, 21, 24, 24};
                byArray3 = new byte[]{1, 1, 1, 2, 2};
                break;
            }
            case 2: {
                byArray = new byte[]{0, 0, 1, 1};
                byArray2 = new byte[]{24, 24, 27, 27, 27, 30, 30};
                byArray3 = new byte[]{1, 1, 2, 2};
                break;
            }
            case 3: {
                byArray = new byte[]{0, 0, 1, 1, 1};
                byArray2 = new byte[]{30, 30, 33, 33, 37, 37};
                byArray3 = new byte[]{1, 2, 2, 2, 3};
                break;
            }
            case 4: {
                byArray = new byte[]{0, 1, 1, 1};
                byArray2 = new byte[]{37, 40, 40, 43, 43, 46};
                byArray3 = new byte[]{2, 2, 3, 3};
            }
        }
        n2 = 1 + Game.level;
        if (Game.itemCategory == 0) {
            n2 += Game.rand(2);
            n = 0;
            while (n < byArray2.length) {
                int n4 = n++;
                byArray2[n4] = (byte)(byArray2[n4] + 3);
            }
        }
        if (Game.itemCategory == 2) {
            ++n2;
            n = 0;
            while (n < byArray2.length) {
                int n5 = n++;
                byArray2[n5] = (byte)(byArray2[n5] + 6);
            }
        }
        if (n2 > 3) {
            n2 = 3;
        }
        this.goal = new byte[n2][4];
        this.goal[0][0] = 0;
        for (n = 1; n < n2; ++n) {
            this.goal[n][0] = byArray[Game.rand(byArray.length)];
        }
        this.gameDurationTime = 0;
        for (n = 0; n < n2; ++n) {
            if (this.goal[n][0] == 0) {
                this.goal[n][1] = byArray2[Game.rand(byArray2.length)];
                this.goal[n][2] = byArray4[n];
                this.gameDurationTime += this.goal[n][1] * 3;
                continue;
            }
            this.goal[n][1] = byArray3[Game.rand(byArray3.length)];
            this.goal[n][2] = byArray4[n];
            this.goal[n][3] = 4;
            this.gameDurationTime += this.goal[n][1] * 36;
        }
        if (this.gameDurationTime < 90) {
            this.gameDurationTime = 90;
        }
    }

    void addNotify() {
        Game.layerManager.add(this.bg);
        this.createBoard();
        if (Game.miniGameTutorial) {
            this.scroll = new Scroll(40, 60, 160, 210, ResourceManager.getText(62), 1, 35);
            Game.layerManager.add(this.scroll);
            Game.layerManager.setKeyLeftListener(this.scroll);
            Game.layerManager.setKeyRightListener(this.scroll);
            this.state = (byte)6;
        } else {
            this.showGoalScreen();
            this.state = (byte)7;
        }
        Game.layerManager.add(this.leftSoft);
        Game.layerManager.setKeyFireListener(this);
        Game.layerManager.setKeySoft1Listener(this);
    }

    void createBoard() {
        int n;
        int n2;
        int n3;
        ColorBackground colorBackground = new ColorBackground(this.x, this.y, this.width, this.height, 0);
        Game.layerManager.add(colorBackground);
        Sprite sprite = Game.rm.getSprite(53);
        StaticImage staticImage = new StaticImage(sprite, 0, 0);
        staticImage.setPosition(this.x - sprite.getWidth(), this.y - sprite.getHeight());
        StaticImage staticImage2 = new StaticImage(sprite, 1, 0);
        staticImage2.setPosition(this.x + this.width, this.y - sprite.getHeight());
        StaticImage staticImage3 = new StaticImage(sprite, 2, 0);
        staticImage3.setPosition(staticImage.getX(), this.y + this.height);
        StaticImage staticImage4 = new StaticImage(sprite, 3, 0);
        staticImage4.setPosition(staticImage2.getX(), staticImage3.getY());
        StaticImage staticImage5 = new StaticImage(sprite, 4, 0, this.width, sprite.getHeight());
        staticImage5.setPosition(this.x, staticImage.getY());
        StaticImage staticImage6 = new StaticImage(sprite, 5, 0, this.width, sprite.getHeight());
        staticImage6.setPosition(staticImage5.getX(), staticImage3.getY());
        StaticImage staticImage7 = new StaticImage(sprite, 6, 0, sprite.getWidth(), this.height);
        staticImage7.setPosition(staticImage.getX(), this.y);
        StaticImage staticImage8 = new StaticImage(sprite, 7, 0, sprite.getWidth(), this.height);
        staticImage8.setPosition(staticImage2.getX(), staticImage7.getY());
        Game.layerManager.add(staticImage);
        Game.layerManager.add(staticImage2);
        Game.layerManager.add(staticImage3);
        Game.layerManager.add(staticImage4);
        Game.layerManager.add(staticImage7);
        Game.layerManager.add(staticImage8);
        Game.layerManager.add(staticImage5);
        Game.layerManager.add(staticImage6);
        ColorBackground colorBackground2 = new ColorBackground(this.avatar.getX() - 2, this.avatar.getY() - 2, this.avatar.getWidth() + 4, this.avatar.getHeight() + 4, 0, 15326308);
        Game.layerManager.add(colorBackground2);
        Game.layerManager.add(this.avatar);
        Game.layerManager.add(this.avatar_smile);
        Game.layerManager.add(this.avatar_eyes);
        ColorBackground colorBackground3 = new ColorBackground(55, 6, 179, 52, 0, 15326308);
        Game.layerManager.add(colorBackground3);
        for (n3 = 0; n3 < 2; ++n3) {
            Game.layerManager.add(this.timeBar[n3][0]);
            Game.layerManager.add(this.timeBar[n3][1]);
            Game.layerManager.add(this.timeBar[n3][2]);
        }
        Game.layerManager.add(this.hourGlass);
        for (n3 = 0; n3 < 8; ++n3) {
            for (n2 = 0; n2 < 8; ++n2) {
                ColorBackground colorBackground4 = new ColorBackground(this.x + n2 * this.cellSize + 1, this.y + n3 * this.cellSize + 1, this.cellSize - 2, this.cellSize - 2, 0x171717);
                Game.layerManager.add(colorBackground4);
            }
        }
        Sprite sprite2 = Game.rm.getSprite(16);
        this.board = new Pawn[8][8];
        for (n2 = 0; n2 < 8; ++n2) {
            for (int i = 0; i < 8; ++i) {
                Pawn pawn = new Pawn(sprite2, Game.rand(6));
                pawn.setPosition(this.x + n2 * this.cellSize, this.y + i * this.cellSize);
                pawn.setClipLayer(this);
                this.board[n2][i] = pawn;
                Game.layerManager.add(pawn);
            }
        }
        for (n2 = 0; n2 < 8; ++n2) {
            for (int i = 0; i < 8; ++i) {
                while (this.is3H(n2, i) || this.is3V(n2, i)) {
                    this.board[n2][i].color = (byte)(this.board[n2][i].color + 1);
                    if (this.board[n2][i].color != 6) continue;
                    this.board[n2][i].color = 0;
                }
            }
        }
        n2 = 0;
        for (n = 0; n < 8; ++n) {
            for (int i = 0; i < 8; ++i) {
                if (!this.isMovePossible(n, i)) continue;
                n2 = 1;
                break;
            }
            if (n2 != 0) break;
        }
        if (n2 == 0) {
            this.board[0][0].color = this.board[3][0].color;
            this.board[1][0].color = this.board[3][0].color;
            while (this.is3H(2, 0)) {
                this.board[2][0].color = (byte)(this.board[2][0].color + 1);
                if (this.board[2][0].color != 6) continue;
                this.board[2][0].color = 0;
            }
            for (n = 0; n < 3; ++n) {
                while (this.is3H(n, 1) || this.is3V(n, 1)) {
                    this.board[n][1].color = (byte)(this.board[n][1].color + 1);
                    if (this.board[n][1].color != 6) continue;
                    this.board[n][1].color = 0;
                }
            }
        }
        this.cursor = new ColorBackground(this.x, this.y, this.cellSize, this.cellSize, -1, 0xFFFFFF);
        Game.layerManager.add(this.cursor);
        Sprite sprite3 = Game.rm.getSprite(17);
        this.cursorArrowL = new StaticImage(sprite3, 0, 0);
        this.cursorArrowR = new StaticImage(sprite3, 0, 3);
        this.cursorArrowU = new StaticImage(sprite3, 0, 5);
        this.cursorArrowD = new StaticImage(sprite3, 0, 6);
        Game.layerManager.add(this.cursorArrowL);
        Game.layerManager.add(this.cursorArrowR);
        Game.layerManager.add(this.cursorArrowU);
        Game.layerManager.add(this.cursorArrowD);
        this.cursorArrowL.setVisible(false);
        this.cursorArrowR.setVisible(false);
        this.cursorArrowU.setVisible(false);
        this.cursorArrowD.setVisible(false);
        Pawn.moveCounter = 0;
        Pawn.explodeCounter = 0;
    }

    void showGoalScreen() {
        int n;
        int n2;
        int n3 = this.goalCounter[0][0].getHeight() * 3;
        int n4 = Math.min(Game.rm.getFont(0).stringWidth(ResourceManager.getText(56)) + 40, Game.canvasWidth - 32);
        int n5 = n3 * this.goal.length + Game.rm.getFont(0).getHeight();
        int n6 = this.goalCounter[0][0].getWidth() * 7 - this.goalCounter[0][0].getWidth() / 2;
        this.scroll = new Scroll(Game.canvasCenterX - n4 / 2, Game.canvasCenterY - n5 / 2, n4, n5, ResourceManager.getText(56), 1, -1);
        Game.layerManager.add(this.scroll);
        int n7 = n2 = this.scroll.getX() + this.scroll.getWidth() / 2 - n6 / 2;
        int n8 = this.scroll.getY() + Game.rm.getFont(0).getHeight() + this.goalCounter[0][0].getHeight();
        for (n = 0; n < this.goal.length; ++n) {
            n7 = n2;
            this.goalCounter[n][0].setPosition(n7, n8);
            this.goalCounter[n][1].setPosition(n7 += this.goalCounter[n][0].getWidth(), n8);
            this.goalCounter[n][2].setPosition(n7 += this.goalCounter[n][0].getWidth() + this.goalCounter[n][0].getWidth() / 2, n8);
            this.goalCounter[n][2].setFrame(10);
            this.goalCounter[n][3].setPosition(n7 += this.goalCounter[n][0].getWidth() + this.goalCounter[n][0].getWidth(), n8);
            this.miniorb[n].setPosition(this.goalCounter[n][3].getX() + this.goalCounter[n][3].getWidth() / 2 - this.miniorb[n].getWidth() / 2, this.goalCounter[n][3].getY() + this.goalCounter[n][3].getHeight() / 2 - this.miniorb[n].getHeight() / 2);
            n8 += n3;
        }
        for (n = 0; n < this.goal.length; ++n) {
            Game.layerManager.add(this.miniorb[n]);
            Game.layerManager.add(this.goalCounter[n][0]);
            Game.layerManager.add(this.goalCounter[n][1]);
            Game.layerManager.add(this.goalCounter[n][2]);
            Game.layerManager.add(this.goalCounter[n][3]);
        }
        this.updateGoalCounters();
    }

    boolean is2H(int n, int n2) {
        return n <= 6 && this.board[n][n2].isSameColor(this.board[n + 1][n2]);
    }

    boolean is2V(int n, int n2) {
        return n2 <= 6 && this.board[n][n2].isSameColor(this.board[n][n2 + 1]);
    }

    boolean isMovePossible(int n, int n2) {
        if (this.is2H(n, n2)) {
            if (n - 2 >= 0 && this.board[n][n2].isSameColor(this.board[n - 2][n2]) && this.board[n + 1][n2].isSameColor(this.board[n - 2][n2])) {
                return true;
            }
            if (n - 1 >= 0 && n2 - 1 >= 0 && this.board[n][n2].isSameColor(this.board[n - 1][n2 - 1]) && this.board[n + 1][n2].isSameColor(this.board[n - 1][n2 - 1])) {
                return true;
            }
            if (n - 1 >= 0 && n2 + 1 <= 7 && this.board[n][n2].isSameColor(this.board[n - 1][n2 + 1]) && this.board[n + 1][n2].isSameColor(this.board[n - 1][n2 + 1])) {
                return true;
            }
            if (n + 3 <= 7 && this.board[n][n2].isSameColor(this.board[n + 3][n2]) && this.board[n + 1][n2].isSameColor(this.board[n + 3][n2])) {
                return true;
            }
            if (n + 2 <= 7 && n2 - 1 >= 0 && this.board[n][n2].isSameColor(this.board[n + 2][n2 - 1]) && this.board[n + 1][n2].isSameColor(this.board[n + 2][n2 - 1])) {
                return true;
            }
            if (n + 2 <= 7 && n2 + 1 <= 7 && this.board[n][n2].isSameColor(this.board[n + 2][n2 + 1]) && this.board[n + 1][n2].isSameColor(this.board[n + 2][n2 + 1])) {
                return true;
            }
        } else if (this.is2V(n, n2)) {
            if (n2 - 2 >= 0 && this.board[n][n2].isSameColor(this.board[n][n2 - 2]) && this.board[n][n2 + 1].isSameColor(this.board[n][n2 - 2])) {
                return true;
            }
            if (n2 - 1 >= 0 && n - 1 >= 0 && this.board[n][n2].isSameColor(this.board[n - 1][n2 - 1]) && this.board[n][n2 + 1].isSameColor(this.board[n - 1][n2 - 1])) {
                return true;
            }
            if (n2 - 1 >= 0 && n + 1 <= 7 && this.board[n][n2].isSameColor(this.board[n + 1][n2 - 1]) && this.board[n][n2 + 1].isSameColor(this.board[n + 1][n2 - 1])) {
                return true;
            }
            if (n2 + 3 <= 7 && this.board[n][n2].isSameColor(this.board[n][n2 + 3]) && this.board[n][n2 + 1].isSameColor(this.board[n][n2 + 3])) {
                return true;
            }
            if (n2 + 2 <= 7 && n - 1 >= 0 && this.board[n][n2].isSameColor(this.board[n - 1][n2 + 2]) && this.board[n][n2 + 1].isSameColor(this.board[n - 1][n2 + 2])) {
                return true;
            }
            if (n2 + 2 <= 7 && n + 1 <= 7 && this.board[n][n2].isSameColor(this.board[n + 1][n2 + 2]) && this.board[n][n2 + 1].isSameColor(this.board[n + 1][n2 + 2])) {
                return true;
            }
        }
        return false;
    }

    boolean is3H(int n, int n2) {
        int n3 = n - 1;
        int n4 = n + 1;
        return n3 >= 0 && n4 <= 7 && n2 >= 0 && n2 <= 7 && this.board[n][n2].isSameColor(this.board[n3][n2]) && this.board[n][n2].isSameColor(this.board[n4][n2]) && this.board[n3][n2].isSameColor(this.board[n4][n2]);
    }

    boolean is3V(int n, int n2) {
        int n3 = n2 - 1;
        int n4 = n2 + 1;
        return n3 >= 0 && n4 <= 7 && n >= 0 && n <= 7 && this.board[n][n2].isSameColor(this.board[n][n3]) && this.board[n][n2].isSameColor(this.board[n][n4]) && this.board[n][n3].isSameColor(this.board[n][n4]);
    }

    void moveCursor(int n, int n2) {
        this.board[this.cursorX][this.cursorY].setState((byte)0);
        this.cursorX = (byte)(this.cursorX + n);
        if (this.cursorX < 0) {
            this.cursorX = 0;
        } else if (this.cursorX > 7) {
            this.cursorX = (byte)7;
        }
        this.cursorY = (byte)(this.cursorY + n2);
        if (this.cursorY < 0) {
            this.cursorY = 0;
        } else if (this.cursorY > 7) {
            this.cursorY = (byte)7;
        }
        this.board[this.cursorX][this.cursorY].setState((byte)1);
        this.showCursor();
    }

    void movePawn(int n, int n2) {
        this.moveCellX = (byte)(this.cursorX + n);
        this.moveCellY = (byte)(this.cursorY + n2);
        int n3 = this.x + this.cursorX * this.cellSize;
        int n4 = this.y + this.cursorY * this.cellSize;
        int n5 = this.x + this.moveCellX * this.cellSize;
        int n6 = this.y + this.moveCellY * this.cellSize;
        if (this.moveCellX >= 0 && this.moveCellX <= 7 && this.moveCellY >= 0 && this.moveCellY <= 7) {
            Pawn pawn = this.board[this.cursorX][this.cursorY];
            Pawn pawn2 = this.board[this.moveCellX][this.moveCellY];
            pawn.setState((byte)2);
            pawn.moveTo(n5, n6);
            pawn2.setState((byte)2);
            pawn2.moveTo(n3, n4);
            this.board[this.cursorX][this.cursorY] = pawn2;
            this.board[this.moveCellX][this.moveCellY] = pawn;
            this.state = (byte)2;
            this.showCursor();
        }
    }

    void movePawnBack() {
        int n = this.x + this.cursorX * this.cellSize;
        int n2 = this.y + this.cursorY * this.cellSize;
        int n3 = this.x + this.moveCellX * this.cellSize;
        int n4 = this.y + this.moveCellY * this.cellSize;
        Pawn pawn = this.board[this.cursorX][this.cursorY];
        Pawn pawn2 = this.board[this.moveCellX][this.moveCellY];
        pawn.setState((byte)2);
        pawn.moveTo(n3, n4);
        pawn2.setState((byte)2);
        pawn2.moveTo(n, n2);
        this.board[this.cursorX][this.cursorY] = pawn2;
        this.board[this.moveCellX][this.moveCellY] = pawn;
        this.state = (byte)3;
        this.showCursor();
    }

    void showCursor() {
        int n = this.x + this.cursorX * this.cellSize;
        int n2 = this.y + this.cursorY * this.cellSize;
        int n3 = this.cellSize / 2;
        this.cursor.setVisible(this.state == 0);
        this.cursor.setPosition(n, n2);
        this.cursorArrowL.setVisible(this.state == 1 && this.cursorX > 0);
        this.cursorArrowR.setVisible(this.state == 1 && this.cursorX < 7);
        this.cursorArrowU.setVisible(this.state == 1 && this.cursorY > 0);
        this.cursorArrowD.setVisible(this.state == 1 && this.cursorY < 7);
        this.cursorArrowL.setPosition(n - this.cursorArrowL.getWidth(), n2 + n3 - this.cursorArrowL.getHeight() / 2);
        this.cursorArrowR.setPosition(n + this.cellSize, this.cursorArrowL.getY());
        this.cursorArrowU.setPosition(n + n3 - this.cursorArrowU.getWidth() / 2, n2 - this.cursorArrowU.getHeight());
        this.cursorArrowD.setPosition(this.cursorArrowU.getX(), n2 + this.cellSize);
    }

    boolean removeLines() {
        boolean bl = false;
        this.drawJocker = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                if (!this.board[j][i].isJocker()) {
                    n12 = 1;
                    n11 = 1;
                    n10 = j;
                    n9 = j;
                    n8 = i;
                    n7 = i;
                    n6 = 0;
                    n5 = 0;
                    n4 = 1;
                    n3 = 1;
                    for (n2 = j - 1; n2 >= 0 && this.board[n2][i].isSameColor(this.board[j][i]); --n2) {
                        n10 = n2;
                        if (this.board[n2][i].isJocker()) {
                            this.tmpPawns1[n6++] = this.board[n2][i];
                        }
                        if (!this.board[n2][i].isExploding()) continue;
                        n4 = 0;
                    }
                    for (n2 = j + 1; n2 <= 7 && this.board[n2][i].isSameColor(this.board[j][i]); ++n2) {
                        n9 = n2;
                        if (this.board[n2][i].isJocker()) {
                            this.tmpPawns1[n6++] = this.board[n2][i];
                        }
                        if (!this.board[n2][i].isExploding()) continue;
                        n4 = 0;
                    }
                    for (n2 = i - 1; n2 >= 0 && this.board[j][n2].isSameColor(this.board[j][i]); --n2) {
                        n8 = n2;
                        if (this.board[j][n2].isJocker()) {
                            this.tmpPawns2[n5++] = this.board[j][n2];
                        }
                        if (!this.board[j][n2].isExploding()) continue;
                        n3 = 0;
                    }
                    for (n2 = i + 1; n2 <= 7 && this.board[j][n2].isSameColor(this.board[j][i]); ++n2) {
                        n7 = n2;
                        if (this.board[j][n2].isJocker()) {
                            this.tmpPawns2[n5++] = this.board[j][n2];
                        }
                        if (!this.board[j][n2].isExploding()) continue;
                        n3 = 0;
                    }
                    if ((n12 += n9 - n10) >= 4 || (n11 += n7 - n8) >= 4) {
                        this.drawJocker = true;
                    }
                    if (n12 > 3 || n11 > 3) {
                        this.board[j][i].setState((byte)4);
                        bl = true;
                        bl3 = true;
                    } else if (n12 == 3 || n11 == 3) {
                        this.board[j][i].setState((byte)3);
                        bl = true;
                        bl2 = true;
                    }
                    if (!this.board[j][i].isExploding()) continue;
                    if (n4 != 0) {
                        n2 = n12 - 3;
                        while (n2 >= 0) {
                            short[] sArray = this.pointsLine[this.board[j][i].color];
                            int n13 = n2--;
                            sArray[n13] = (short)(sArray[n13] + 1);
                        }
                        this.addGoalExplosion((byte)1, this.board[j][i].color, (byte)n12);
                    }
                    if (n3 != 0) {
                        n2 = n11 - 3;
                        while (n2 >= 0) {
                            short[] sArray = this.pointsLine[this.board[j][i].color];
                            int n14 = n2--;
                            sArray[n14] = (short)(sArray[n14] + 1);
                        }
                        this.addGoalExplosion((byte)1, this.board[j][i].color, (byte)n11);
                    }
                    n2 = 1;
                    for (n = 0; n < n6; ++n) {
                        n2 = this.tmpPawns1[n].multiplyPoints(n2);
                    }
                    for (n = 0; n < n5; ++n) {
                        n2 = this.tmpPawns2[n].multiplyPoints(n2);
                    }
                    byte by = this.board[j][i].color;
                    this.pointsColor[by] = (short)(this.pointsColor[by] + n2);
                    this.addGoalExplosion((byte)0, this.board[j][i].color, (byte)0);
                    continue;
                }
                n12 = this.board[j][i].color;
                n11 = this.board[j][i].multiplyPoints(1);
                for (n10 = 0; n10 < 6; ++n10) {
                    int n15;
                    this.board[j][i].color = (byte)n10;
                    n8 = 1;
                    n7 = 1;
                    n6 = j;
                    n5 = j;
                    n4 = i;
                    n3 = i;
                    n2 = 0;
                    n = 0;
                    int n16 = 0;
                    int n17 = 0;
                    for (n15 = j - 1; n15 >= 0 && this.board[n15][i].isSameColor(this.board[j][i]); --n15) {
                        n6 = n15;
                        if (this.board[n15][i].isJocker()) {
                            this.tmpPawns1[n2++] = this.board[n15][i];
                            continue;
                        }
                        ++n16;
                    }
                    for (n15 = j + 1; n15 <= 7 && this.board[n15][i].isSameColor(this.board[j][i]); ++n15) {
                        n5 = n15;
                        if (this.board[n15][i].isJocker()) {
                            this.tmpPawns1[n2++] = this.board[n15][i];
                            continue;
                        }
                        ++n16;
                    }
                    for (n15 = i - 1; n15 >= 0 && this.board[j][n15].isSameColor(this.board[j][i]); --n15) {
                        n4 = n15;
                        if (this.board[j][n15].isJocker()) {
                            this.tmpPawns2[n++] = this.board[j][n15];
                            continue;
                        }
                        ++n17;
                    }
                    for (n15 = i + 1; n15 <= 7 && this.board[j][n15].isSameColor(this.board[j][i]); ++n15) {
                        n3 = n15;
                        if (this.board[j][n15].isJocker()) {
                            this.tmpPawns2[n++] = this.board[j][n15];
                            continue;
                        }
                        ++n17;
                    }
                    if ((n8 += n5 - n6) > 3 || (n7 += n3 - n4) > 3) {
                        this.board[j][i].setState((byte)4);
                        bl = true;
                    } else if (n8 == 3 || n7 == 3) {
                        this.board[j][i].setState((byte)3);
                        bl = true;
                    }
                    if (n16 != 0 && n8 >= 3) {
                        n9 = n11;
                        for (n15 = 0; n15 < n2; ++n15) {
                            n9 = this.tmpPawns1[n15].multiplyPoints(n9);
                        }
                        byte by = this.board[j][i].color;
                        this.pointsColor[by] = (short)(this.pointsColor[by] + n9);
                    }
                    if (n17 == 0 || n7 < 3) continue;
                    n9 = n11;
                    for (n15 = 0; n15 < n; ++n15) {
                        n9 = this.tmpPawns2[n15].multiplyPoints(n9);
                    }
                    byte by = this.board[j][i].color;
                    this.pointsColor[by] = (short)(this.pointsColor[by] + n9);
                }
                this.board[j][i].color = n12;
            }
        }
        if (bl2 || bl3) {
            Game.mixer.playSound(bl3 ? 2 : 1, false);
            if (bl3) {
                this.emotion = (byte)3;
            } else if (this.emotion < 2) {
                this.emotion = (byte)2;
            }
            this.emotionTimer = 0;
        }
        this.testGoal();
        return bl;
    }

    void drawNextPawns() {
        int n;
        int n2;
        for (n2 = 0; n2 < 8; ++n2) {
            int n3;
            int n4 = 0;
            int n5 = 0;
            for (n = 7; n >= 0; --n) {
                if (this.board[n2][n].state != 5) {
                    this.tmpPawns1[n4++] = this.board[n2][n];
                    continue;
                }
                this.tmpPawns2[n5++] = this.board[n2][n];
            }
            n = 7;
            for (n3 = 0; n3 < n4; ++n3) {
                this.board[n2][n] = this.tmpPawns1[n3];
                this.tmpPawns1[n3].setState((byte)2);
                this.tmpPawns1[n3].moveTo(this.tmpPawns1[n3].getX(), this.y + n * this.cellSize);
                --n;
            }
            int n6 = this.y - this.cellSize;
            for (n3 = 0; n3 < n5; ++n3) {
                this.tmpPawns2[n3].color = (byte)Game.rand(6);
                this.board[n2][n] = this.tmpPawns2[n3];
                this.tmpPawns2[n3].setPosition(this.tmpPawns2[n3].getX(), n6);
                this.tmpPawns2[n3].moveTo(this.tmpPawns2[n3].getX(), this.y + n * this.cellSize);
                --n;
                n6 -= this.cellSize;
            }
        }
        if (this.drawJocker) {
            n2 = Game.rand(8);
            while (this.drawJocker) {
                for (n = 7; n >= 0; --n) {
                    if (this.board[n2][n].state != 5) continue;
                    this.board[n2][n].color = (byte)(Game.rand(2) == 0 ? 6 : 7);
                    this.drawJocker = false;
                    break;
                }
                if (++n2 != 8) continue;
                n2 = 0;
            }
        }
        boolean bl = false;
        for (n2 = 0; n2 < 8; ++n2) {
            for (n = 0; n < 8; ++n) {
                if (!this.isMovePossible(n2, n)) continue;
                bl = true;
                break;
            }
            if (bl) break;
        }
        if (!bl) {
            byte by;
            for (n2 = 0; n2 <= 5; ++n2) {
                if (this.board[n2][0].state != 5 || this.board[n2 + 1][0].state != 5 || this.board[n2 + 2][0].state != 5) continue;
                if (n2 == 0) {
                    this.board[n2][0].color = by = this.board[n2 + 3][0].color;
                    this.board[n2 + 1][0].color = by;
                    this.board[n2 + 2][0].color = (byte)Game.rand(6);
                } else {
                    by = this.board[n2 - 1][0].color;
                    this.board[n2][0].color = (byte)Game.rand(6);
                    this.board[n2 + 1][0].color = by;
                    this.board[n2 + 2][0].color = by;
                }
                bl = true;
                break;
            }
            if (!bl) {
                for (n2 = 0; n2 < 8; ++n2) {
                    if (this.board[n2][0].state != 5 || this.board[n2][1].state != 5 || this.board[n2][2].state != 5) continue;
                    this.board[n2][0].color = by = this.board[n2][3].color;
                    this.board[n2][1].color = by;
                    this.board[n2][2].color = (byte)Game.rand(6);
                    bl = true;
                    break;
                }
            }
        }
        for (n2 = 0; n2 < 8; ++n2) {
            for (n = 0; n < 8; ++n) {
                if (this.board[n2][n].state != 5) continue;
                this.board[n2][n].setState((byte)2);
            }
        }
    }

    void keyFire() {
        switch (this.state) {
            case 6: {
                Game.layerManager.remove(this.scroll);
                this.scroll.release();
                this.scroll = null;
                Game.layerManager.setKeyLeftListener(null);
                Game.layerManager.setKeyRightListener(null);
                this.showGoalScreen();
                this.leftSoft.setFrame(3, 0);
                Game.miniGameTutorial = false;
                this.state = (byte)7;
                break;
            }
            case 7: {
                Game.layerManager.remove(this.scroll);
                this.scroll.release();
                this.scroll = null;
                this.leftSoft.setFrame(0, 0);
                Game.layerManager.remove(this.leftSoft);
                Game.layerManager.add(this.rightSoft);
                Game.layerManager.add(this.menu);
                Game.layerManager.setKeyUpListener(this);
                Game.layerManager.setKeyDownListener(this);
                Game.layerManager.setKeyLeftListener(this);
                Game.layerManager.setKeyRightListener(this);
                Game.layerManager.setKeySoft2Listener(this);
                int n = this.goalCounter[0][0].getWidth();
                int n2 = (n * 5 + n / 2) * this.goal.length + n * (this.goal.length - 1) + n / 2;
                int n3 = 144 - n2 / 2;
                int n4 = 38;
                for (int i = 0; i < this.goal.length; ++i) {
                    this.goalCounter[i][0].setPosition(n3, n4);
                    this.goalCounter[i][1].setPosition(n3 += n, n4);
                    this.goalCounter[i][2].setPosition(n3 += n + n / 2, n4);
                    this.goalCounter[i][2].setFrame(10);
                    this.goalCounter[i][3].setPosition(n3 += n + n, n4);
                    this.miniorb[i].setPosition(this.goalCounter[i][3].getX() + this.goalCounter[i][3].getWidth() / 2 - this.miniorb[i].getWidth() / 2, this.goalCounter[i][3].getY() + this.goalCounter[i][3].getHeight() / 2 - this.miniorb[i].getHeight() / 2);
                    n3 += n + n;
                }
                this.state = 0;
                this.moveCursor(0, 0);
                paused = false;
                this.gameStartTime = System.currentTimeMillis();
                this.gameTimeLeft = this.gameDurationTime * 1000;
                this.gameEndTime = this.gameStartTime + (long)this.gameTimeLeft;
                break;
            }
            case 0: {
                this.state = 1;
                this.showCursor();
                break;
            }
            case 1: {
                this.state = 0;
                this.showCursor();
                break;
            }
            case 8: {
                if (this.goalCompleted) {
                    Game.currGameItem.state = (byte)2;
                    Game.updateLevel();
                    Game.event(new Event(38));
                    break;
                }
                Game.event(new Event(39));
            }
        }
    }

    void keySoft1() {
        this.keyFire();
    }

    void keySoft2() {
        if (this.menu.isVisible()) {
            this.menu.setVisible(false);
            Game.layerManager.remove(this.leftSoft);
            Game.layerManager.setKeyFireListener(this);
            Game.layerManager.setKeySoft1Listener(this);
            Game.layerManager.setKeyUpListener(this);
            Game.layerManager.setKeyDownListener(this);
            Game.layerManager.setKeyLeftListener(this);
            Game.layerManager.setKeyRightListener(this);
            paused = false;
            this.gameEndTime = System.currentTimeMillis() + (long)this.gameTimeLeft;
        } else {
            Game.layerManager.moveToTop(this.menu);
            this.menu.setVisible(true);
            Game.layerManager.add(this.leftSoft);
            Game.layerManager.setKeyFireListener(this.menu);
            Game.layerManager.setKeySoft1Listener(this.menu);
            Game.layerManager.setKeyUpListener(this.menu);
            Game.layerManager.setKeyDownListener(this.menu);
            Game.layerManager.setKeyLeftListener(null);
            Game.layerManager.setKeyRightListener(null);
            paused = true;
        }
    }

    void keyLeft() {
        switch (this.state) {
            case 0: {
                this.moveCursor(-1, 0);
                break;
            }
            case 1: {
                this.movePawn(-1, 0);
            }
        }
    }

    void keyRight() {
        switch (this.state) {
            case 0: {
                this.moveCursor(1, 0);
                break;
            }
            case 1: {
                this.movePawn(1, 0);
            }
        }
    }

    void keyUp() {
        switch (this.state) {
            case 0: {
                this.moveCursor(0, -1);
                break;
            }
            case 1: {
                this.movePawn(0, -1);
            }
        }
    }

    void keyDown() {
        switch (this.state) {
            case 0: {
                this.moveCursor(0, 1);
                break;
            }
            case 1: {
                this.movePawn(0, 1);
            }
        }
    }

    void testGoal() {
        int n = 0;
        for (int i = 0; i < this.goal.length; ++i) {
            if (this.goal[i][0] == 0 && this.pointsColor[this.goal[i][2]] >= this.goal[i][1]) {
                ++n;
                continue;
            }
            if (this.goal[i][0] != 1 || this.pointsLine[this.goal[i][2]][this.goal[i][3] - 3] < this.goal[i][1]) continue;
            ++n;
        }
        if (n == this.goal.length) {
            this.goalCompleted = true;
        }
        this.updateGoalCounters();
    }

    void addGoalExplosion(byte by, byte by2, byte by3) {
        for (int i = 0; i < this.goal.length; ++i) {
            if (by != this.goal[i][0] || by2 != this.goal[i][2] || this.miniorbExplosion[i] != null || by == 1 && by3 < this.goal[i][3]) continue;
            this.miniorbExplosion[i] = new StaticImage(Game.rm.getSprite(20));
            this.miniorbExplosion[i].setPosition(this.miniorb[i].getX() + this.miniorb[i].getWidth() / 2 - this.miniorbExplosion[i].getWidth() / 2, this.miniorb[i].getY() + this.miniorb[i].getHeight() / 2 - this.miniorbExplosion[i].getHeight() / 2);
            Game.layerManager.add(this.miniorbExplosion[i]);
        }
    }

    void updateGoalCounters() {
        for (int i = 0; i < this.goal.length; ++i) {
            int n;
            int n2;
            int n3;
            if (this.goal[i][0] == 0) {
                n3 = this.goal[i][1] - this.pointsColor[this.goal[i][2]];
                if (n3 < 0) {
                    n3 = 0;
                }
                n2 = n3 / 10;
                n = n3 % 10;
                if (n2 != 0) {
                    this.goalCounter[i][0].setVisible(true);
                    this.goalCounter[i][0].setFrame(n2);
                } else {
                    this.goalCounter[i][0].setVisible(false);
                }
                this.goalCounter[i][1].setVisible(true);
                this.goalCounter[i][1].setFrame(n);
                this.goalCounter[i][3].setVisible(false);
                this.miniorb[i].setFrame(this.goal[i][2]);
                continue;
            }
            if (this.goal[i][0] != 1) continue;
            n3 = this.goal[i][1] - this.pointsLine[this.goal[i][2]][this.goal[i][3] - 3];
            if (n3 < 0) {
                n3 = 0;
            }
            n2 = n3 / 10;
            n = n3 % 10;
            if (n2 != 0) {
                this.goalCounter[i][0].setVisible(true);
                this.goalCounter[i][0].setFrame(n2);
            } else {
                this.goalCounter[i][0].setVisible(false);
            }
            this.goalCounter[i][1].setVisible(true);
            this.goalCounter[i][1].setFrame(n);
            this.goalCounter[i][3].setVisible(true);
            this.goalCounter[i][3].setFrame(this.goal[i][3]);
            this.miniorb[i].setFrame(this.goal[i][2]);
        }
    }

    void processEvent(Event event) {
        switch (event.id) {
            case 22: 
            case 39: {
                this.menu.setVisible(false);
                this.scroll = new Scroll(40, 60, 160, 210, ResourceManager.getText(53), 1, -1);
                this.scroll.fitHeightToText();
                this.scroll.setPosition(this.scroll.getX(), Game.canvasCenterY - this.scroll.getHeight() / 2);
                Game.layerManager.add(this.scroll);
                Game.layerManager.setKeyLeftListener(this.scroll);
                Game.layerManager.setKeyRightListener(this.scroll);
                this.leftSoft.setEvent(event);
                Game.layerManager.setKeySoft1Listener(this.leftSoft);
                this.rightSoft.setEvent(new Event(43, new Object[]{this, new Event(44)}));
                Game.layerManager.setKeySoft2Listener(this.rightSoft);
                Game.layerManager.setKeyFireListener(null);
                Game.layerManager.setKeyUpListener(null);
                Game.layerManager.setKeyDownListener(null);
                break;
            }
            case 44: {
                Game.layerManager.remove(this.scroll);
                this.scroll.release();
                this.scroll = null;
                this.menu.setVisible(true);
                this.leftSoft.setEvent(null);
                this.rightSoft.setEvent(null);
                Game.layerManager.setKeyFireListener(this.menu);
                Game.layerManager.setKeySoft1Listener(this.menu);
                Game.layerManager.setKeyUpListener(this.menu);
                Game.layerManager.setKeyDownListener(this.menu);
                Game.layerManager.setKeyLeftListener(null);
                Game.layerManager.setKeyRightListener(null);
                Game.layerManager.setKeySoft2Listener(this);
            }
        }
    }

    void animate() {
        int n;
        if (paused) {
            return;
        }
        if (this.avatar_smile.frame < this.emotion && this.avatar_smile.frame < 3) {
            this.avatar_smile.setFrame(this.avatar_smile.frame + 1);
        } else if (this.avatar_smile.frame > this.emotion && this.avatar_smile.frame > 0) {
            this.avatar_smile.setFrame(this.avatar_smile.frame - 1);
        }
        if (this.avatar_eyes.frame < this.emotion && this.avatar_eyes.frame < 2) {
            this.avatar_eyes.setFrame(this.avatar_eyes.frame + 1);
        } else if (this.avatar_eyes.frame > this.emotion && this.avatar_eyes.frame > 0) {
            this.avatar_eyes.setFrame(this.avatar_eyes.frame - 1);
        }
        if (this.emotion > 0) {
            this.emotionTimer = (byte)(this.emotionTimer + 1);
            if (this.emotionTimer == 60) {
                this.emotion = (byte)(this.emotion - 1);
                this.emotionTimer = 0;
            }
        }
        if (gameOver) {
            if (this.goalCompleted) {
                for (int i = 0; i < this.miniorbExplosion.length; ++i) {
                    int n2;
                    int n3;
                    if (this.miniorbExplosion[i] == null) continue;
                    if (this.miniorbExplosion[i].isNextFrame() && this.miniorbExplosion[i].isVisible()) {
                        this.miniorbExplosion[i].setFrame(this.miniorbExplosion[i].frame + 1, Game.rand(8));
                        continue;
                    }
                    this.miniorbExplosion[i].setFrame(Game.rand(this.miniorbExplosion[i].getFrameCount()), Game.rand(8));
                    int n4 = Game.rand(4);
                    if (n4 == 0) {
                        n3 = this.scroll.getX() - this.miniorbExplosion[i].getWidth();
                        n2 = this.scroll.getY() + Game.rand(this.scroll.getHeight()) - this.miniorbExplosion[i].getHeight() / 2;
                    } else if (n4 == 1) {
                        n3 = this.scroll.getX() + Game.rand(this.scroll.getWidth()) - this.miniorbExplosion[i].getWidth() / 2;
                        n2 = this.scroll.getY() - this.miniorbExplosion[i].getHeight();
                    } else if (n4 == 2) {
                        n3 = this.scroll.getX() + this.scroll.getWidth();
                        n2 = this.scroll.getY() + Game.rand(this.scroll.getHeight()) - this.miniorbExplosion[i].getHeight() / 2;
                    } else {
                        n3 = this.scroll.getX() + Game.rand(this.scroll.getWidth()) - this.miniorbExplosion[i].getWidth() / 2;
                        n2 = this.scroll.getY() + this.scroll.getHeight();
                    }
                    this.miniorbExplosion[i].setPosition(n3, n2);
                    if (this.miniorbExplosion[i].isVisible()) continue;
                    this.miniorbExplosion[i].setVisible(true);
                }
            }
            return;
        }
        for (n = 0; n < this.goal.length; ++n) {
            if (this.miniorbExplosion[n] == null) continue;
            if (this.miniorbExplosion[n].frame < 7) {
                this.miniorbExplosion[n].setFrame(this.miniorbExplosion[n].frame + 1);
                continue;
            }
            Game.layerManager.remove(this.miniorbExplosion[n]);
            this.miniorbExplosion[n].release();
            this.miniorbExplosion[n] = null;
        }
        this.gameTimeLeft = (int)(this.gameEndTime - System.currentTimeMillis());
        if (this.gameTimeLeft < 0) {
            this.gameTimeLeft = 0;
        }
        if ((this.gameTimeLeft == 0 || this.goalCompleted) && Pawn.explodeCounter == 0) {
            int n5;
            gameOver = true;
            String string = this.goalCompleted ? ResourceManager.getText(55) : ResourceManager.getText(54);
            this.scroll = new Scroll(40, 60, 160, 210, string, 1, -1);
            this.scroll.fitHeightToText();
            this.scroll.setPosition(this.scroll.getX(), Game.canvasCenterY - this.scroll.getHeight() / 2);
            Game.layerManager.add(this.scroll);
            Game.layerManager.remove(this.rightSoft);
            Game.layerManager.add(this.leftSoft);
            Game.layerManager.setKeySoft1Listener(this);
            Game.layerManager.setKeySoft2Listener(null);
            for (n5 = 0; n5 < this.miniorbExplosion.length; ++n5) {
                if (this.miniorbExplosion[n5] == null) continue;
                Game.layerManager.remove(this.miniorbExplosion[n5]);
                this.miniorbExplosion[n5].release();
                this.miniorbExplosion[n5] = null;
            }
            if (this.goalCompleted) {
                this.miniorbExplosion = new StaticImage[5];
                for (n5 = 0; n5 < this.miniorbExplosion.length; ++n5) {
                    this.miniorbExplosion[n5] = new StaticImage(Game.rm.getSprite(20));
                    this.miniorbExplosion[n5].setPosition(this.scroll.getX() + Game.rand(this.scroll.getWidth()) - this.miniorbExplosion[n5].getWidth() / 2, this.scroll.getY() + Game.rand(this.scroll.getHeight()) - this.miniorbExplosion[n5].getHeight() / 2);
                    this.miniorbExplosion[n5].setFrame(Game.rand(this.miniorbExplosion[n5].getFrameCount()), Game.rand(8));
                    this.miniorbExplosion[n5].setVisible(false);
                    Game.layerManager.add(this.miniorbExplosion[n5]);
                }
            }
            this.emotion = (byte)(this.goalCompleted ? 3 : 0);
            this.state = (byte)8;
            return;
        }
        n = Game.fixDiv(this.gameTimeLeft / 1000 << 16, this.gameDurationTime << 16);
        int n6 = this.timeBar[1][0].getWidth() + this.timeBar[1][1].getWidth() + this.timeBar[1][2].getWidth();
        int n7 = Game.fixMul(n, n6 << 16) >> 16;
        if (this.timeBarClipper.getWidth() != n7) {
            this.timeBarClipper.setWidth(n7);
        }
        switch (this.state) {
            case 0: {
                this.cursorColorFrame = (byte)(this.cursorColorFrame + 1);
                if (this.cursorColorFrame == this.cursorColor.length) {
                    this.cursorColorFrame = 0;
                }
                this.cursor.setOutline(this.cursorColor[this.cursorColorFrame]);
                break;
            }
            case 1: {
                this.arrowsFrame = (byte)(this.arrowsFrame + 1);
                if (this.arrowsFrame == 3) {
                    this.arrowsFrame = 0;
                }
                this.cursorArrowL.setFrame(this.arrowsFrame);
                this.cursorArrowR.setFrame(this.arrowsFrame);
                this.cursorArrowU.setFrame(this.arrowsFrame);
                this.cursorArrowD.setFrame(this.arrowsFrame);
                break;
            }
            case 2: {
                if (Pawn.moveCounter != 0) break;
                if (this.removeLines()) {
                    this.state = (byte)4;
                    this.showCursor();
                    break;
                }
                this.movePawnBack();
                if (this.emotion <= 0) break;
                this.emotion = (byte)(this.emotion - 1);
                break;
            }
            case 3: {
                if (Pawn.moveCounter != 0) break;
                this.state = 0;
                this.board[this.cursorX][this.cursorY].setState((byte)1);
                this.showCursor();
                break;
            }
            case 4: {
                if (Pawn.explodeCounter != 0) break;
                this.drawNextPawns();
                this.state = (byte)5;
                this.showCursor();
                break;
            }
            case 5: {
                if (Pawn.moveCounter != 0) break;
                if (this.removeLines()) {
                    this.state = (byte)4;
                    this.showCursor();
                    break;
                }
                this.state = 0;
                this.board[this.cursorX][this.cursorY].setState((byte)1);
                this.showCursor();
            }
        }
    }

    void release() {
        super.release();
    }
}

