/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.game.Sprite;

public class Menu
extends GameLayer {
    byte id;
    Vector items;
    int selected;
    Button highLight;
    StaticImage borderT;
    StaticImage borderB;
    ColorBackground bg;

    public Menu(byte by) {
        this.id = by;
        Byte by2 = (Byte)Game.data.get("menu." + by + ".index");
        if (by2 != null) {
            this.selected = by2.byteValue();
        }
        this.items = new Vector(10);
        this.highLight = new Button(Game.rm.getSprite(14), 0);
    }

    void add(Label label, Button button, Event event) {
        Object[] objectArray = new Object[2];
        if (event != null) {
            label.setEvent(event);
            button.setEvent(event);
        }
        objectArray[0] = button;
        objectArray[1] = label;
        this.items.addElement(objectArray);
        label.setAnchor(20);
        int n = this.highLight.getWidth() + 2 + label.getWidth();
        if (n > this.width) {
            this.width = n;
        }
        this.height += Math.max(button.getHeight(), label.getHeight());
    }

    void setPosition(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.positionItems();
    }

    void setVisible(boolean bl) {
        super.setVisible(bl);
        this.highLight.setVisible(bl);
        for (int i = 0; i < this.items.size(); ++i) {
            Object[] objectArray = (Object[])this.items.elementAt(i);
            Button button = (Button)objectArray[0];
            Label label = (Label)objectArray[1];
            button.setVisible(bl);
            label.setVisible(bl);
        }
        if (this.borderT != null) {
            this.borderT.setVisible(bl);
        }
        if (this.borderB != null) {
            this.borderB.setVisible(bl);
        }
        if (this.bg != null) {
            this.bg.setVisible(bl);
        }
    }

    void setBackground(boolean bl) {
        if (bl) {
            this.bg = new ColorBackground(0, this.y, Game.canvasWidth, this.height, 0);
            Sprite sprite = Game.rm.getSprite(7);
            this.borderT = new StaticImage(sprite, 1, 0, Game.canvasWidth, sprite.getHeight());
            this.borderT.setPosition(0, this.y - this.borderT.getHeight());
            this.borderB = new StaticImage(sprite, 1, 3, Game.canvasWidth, sprite.getHeight());
            this.borderB.setPosition(0, this.y + this.height);
        }
    }

    void addNotify() {
        Game.layerManager.add(this.bg);
        Game.layerManager.add(this.borderT);
        Game.layerManager.add(this.borderB);
        Game.layerManager.add(this.highLight);
        for (int i = 0; i < this.items.size(); ++i) {
            Object[] objectArray = (Object[])this.items.elementAt(i);
            Button button = (Button)objectArray[0];
            Label label = (Label)objectArray[1];
            Game.layerManager.add(button);
            Game.layerManager.add(label);
        }
        this.positionItems();
    }

    void removeNotify() {
        Game.layerManager.remove(this.bg);
        Game.layerManager.remove(this.borderT);
        Game.layerManager.remove(this.borderB);
        Game.layerManager.remove(this.highLight);
        for (int i = 0; i < this.items.size(); ++i) {
            Object[] objectArray = (Object[])this.items.elementAt(i);
            Button button = (Button)objectArray[0];
            Label label = (Label)objectArray[1];
            Game.layerManager.remove(button);
            Game.layerManager.remove(label);
        }
    }

    void setSelected(int n) {
        Object[] objectArray = (Object[])this.items.elementAt(this.selected);
        Object[] objectArray2 = (Object[])this.items.elementAt(n);
        Label label = (Label)objectArray[1];
        label.setFont(0);
        label = (Label)objectArray2[1];
        label.setFont(1);
        Button button = (Button)objectArray2[0];
        this.highLight.setPosition(button.getX() + button.getWidth() / 2 - this.highLight.getWidth() / 2, button.getY() + button.getHeight() / 2 - this.highLight.getHeight() / 2);
        this.selected = n;
        Game.data.put("menu." + this.id + ".index", new Byte((byte)this.selected));
    }

    void positionItems() {
        Object[] objectArray = (Object[])this.items.elementAt(0);
        Button button = (Button)objectArray[0];
        Label label = (Label)objectArray[1];
        int n = this.x;
        int n2 = this.y;
        int n3 = this.x + this.highLight.getWidth() + 2;
        int n4 = button.getHeight();
        for (int i = 0; i < this.items.size(); ++i) {
            objectArray = (Object[])this.items.elementAt(i);
            button = (Button)objectArray[0];
            label = (Label)objectArray[1];
            if (button.getHeight() >= label.getHeight()) {
                button.setPosition(n, n2);
                label.setPosition(n3, n2 + button.getHeight() / 2 - label.getHeight() / 2);
                n4 = button.getHeight();
            } else {
                button.setPosition(n, n2 + label.getHeight() / 2 - button.getHeight() / 2);
                label.setPosition(n3, n2);
                n4 = button.getHeight();
            }
            n2 += n4;
        }
        if (this.borderT != null) {
            this.borderT.setPosition(0, this.y - this.borderT.getHeight());
        }
        if (this.borderB != null) {
            this.borderB.setPosition(0, this.y + this.height);
        }
        if (this.bg != null) {
            this.bg.setPosition(0, this.y);
        }
        this.setSelected(this.selected);
    }

    void keyUp() {
        int n = this.selected - 1;
        if (n < 0) {
            n = this.items.size() - 1;
        }
        this.setSelected(n);
    }

    void keyDown() {
        int n = this.selected + 1;
        if (n > this.items.size() - 1) {
            n = 0;
        }
        this.setSelected(n);
    }

    void keySoft1() {
        this.keyFire();
    }

    void keyFire() {
        super.keyFire();
        Object[] objectArray = (Object[])this.items.elementAt(this.selected);
        Button button = (Button)objectArray[0];
        button.keyFire();
    }

    void processEvent(Event event) {
    }

    void release() {
        this.items = null;
    }
}

