/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Label
extends GameLayer {
    Vector lines;
    boolean blink;
    int blinkTimer = 5;
    int fontId = 0;
    int anchor = 17;

    public Label(String string) {
        this(string, Game.canvasWidth);
    }

    public Label(String string, int n) {
        this.setText(string, n);
    }

    void setFont(int n) {
        this.fontId = n;
        this.repaint();
    }

    void setBlink(boolean bl) {
        this.blink = bl;
    }

    void setAnchor(int n) {
        this.anchor = n;
    }

    void setText(String string) {
        this.setText(string, Game.canvasWidth);
    }

    void setText(String string, int n) {
        this.repaint();
        BitmapFont bitmapFont = Game.rm.getFont(this.fontId);
        this.lines = bitmapFont.stringToLines(string, n);
        if (this.lines.size() == 1) {
            this.width = bitmapFont.stringWidth(string);
            this.height = bitmapFont.getHeight();
        } else {
            this.width = 0;
            for (int i = 0; i < this.lines.size(); ++i) {
                int n2 = bitmapFont.stringWidth((String)this.lines.elementAt(i));
                if (n2 <= this.width) continue;
                this.width = n2;
            }
            this.height = bitmapFont.getHeight() * this.lines.size();
        }
        this.repaint();
    }

    public void animate() {
        if (this.blink) {
            --this.blinkTimer;
            if (this.blinkTimer <= 0) {
                this.blinkTimer = 5;
                this.setVisible(!this.visible);
            }
        }
    }

    public void paint(Graphics graphics) {
        BitmapFont bitmapFont = Game.rm.getFont(this.fontId);
        int n = bitmapFont.getHeight();
        int n2 = this.x + this.width / 2;
        int n3 = this.y;
        if ((this.anchor & 4) != 0) {
            n2 = this.x;
        } else if ((this.anchor & 1) != 0) {
            n2 = this.x + this.width / 2;
        } else if ((this.anchor & 8) != 0) {
            n2 = this.x + this.width;
        }
        int n4 = graphics.getClipX();
        int n5 = graphics.getClipY();
        int n6 = graphics.getClipWidth();
        int n7 = graphics.getClipHeight();
        graphics.clipRect(this.x, this.y, this.width, this.height);
        for (int i = 0; i < this.lines.size(); ++i) {
            String string = (String)this.lines.elementAt(i);
            bitmapFont.drawText(string, n2, n3, this.anchor, graphics);
            n3 += n;
        }
        graphics.setClip(n4, n5, n6, n7);
    }

    void release() {
        super.release();
        this.lines = null;
    }
}

