/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public class Button
extends GameLayer {
    public static final byte ANIM_NONE = 0;
    public static final byte ANIM_MOVE_LEFT_RETURN = 1;
    public static final byte ANIM_MOVE_RIGHT_RETURN = 2;
    int frame;
    int transform;
    Sprite sprite;
    int animType = 0;
    int animFrame = 0;
    int currMoveDir = 0;

    public Button(Sprite sprite, int n) {
        this.sprite = sprite;
        this.frame = n;
        this.width = sprite.getWidth();
        this.height = sprite.getHeight();
    }

    public Button(Sprite sprite, int n, int n2) {
        this(sprite, n);
        this.transform = n2;
    }

    void setFrame(int n, int n2) {
        this.frame = n;
        this.transform = n2;
        this.repaint();
    }

    void setAnimation(byte by) {
        this.animType = by;
        switch (this.animType) {
            case 1: {
                this.currMoveDir = -1;
                break;
            }
            case 2: {
                this.currMoveDir = 1;
            }
        }
    }

    public void paint(Graphics graphics) {
        this.sprite.setFrame(this.frame);
        this.sprite.setTransform(this.transform);
        this.sprite.setPosition(this.x, this.y);
        this.sprite.paint(graphics);
    }

    void animate() {
        switch (this.animType) {
            case 1: 
            case 2: {
                if (this.currMoveDir < 0) {
                    this.setPosition(this.x - 1, this.y);
                    ++this.animFrame;
                    if (this.animFrame != 3) break;
                    this.currMoveDir = 1;
                    this.animFrame = 0;
                    break;
                }
                this.setPosition(this.x + 1, this.y);
                ++this.animFrame;
                if (this.animFrame != 3) break;
                this.currMoveDir = -1;
                this.animFrame = 0;
            }
        }
    }

    void release() {
        this.sprite = null;
    }
}

