/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.bluetooth;

import com.lemonquest.bluetooth.BlueToothProtocol;
import com.lemonquest.bluetooth.Log;
import java.io.IOException;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.LocalDevice;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ServerThread
extends Thread {
    private BlueToothProtocol a;
    public boolean isRunning = true;
    public StreamConnectionNotifier a;
    public StreamConnection a;

    public ServerThread(BlueToothProtocol blueToothProtocol) {
        this.a = blueToothProtocol;
    }

    public void run() {
        try {
            LocalDevice localDevice = LocalDevice.getLocalDevice();
            localDevice.setDiscoverable(10390323);
            String string = BlueToothProtocol.url;
            Log.log("Create server by uri: " + string);
            this.a = (StreamConnectionNotifier)Connector.open((String)string);
            while (this.isRunning) {
                Log.log("Waiting for connection...");
                this.a = this.a.acceptAndOpen();
                Log.log("get a connection");
                if (this.a != null) {
                    LocalDevice.getLocalDevice().setDiscoverable(0);
                }
                this.a.handleServerConnection(this.a);
                this.isRunning = false;
            }
            return;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
            return;
        }
        catch (Exception exception) {
            this.a.ui.error(exception.getMessage(), (byte)5, "serverThread-run");
            this.isRunning = false;
            exception.printStackTrace();
            return;
        }
    }

    public void closeServices() {
        try {
            LocalDevice localDevice = LocalDevice.getLocalDevice();
            localDevice.setDiscoverable(0);
            return;
        }
        catch (BluetoothStateException bluetoothStateException) {
            this.a.ui.error(bluetoothStateException.getMessage(), (byte)1, "serverThread-close server services error");
            bluetoothStateException.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeServer() {
        this.closeServices();
        if (this.a != null) {
            try {
                StreamConnectionNotifier streamConnectionNotifier = this.a;
                synchronized (streamConnectionNotifier) {
                    Log.log("========begin notifier close ");
                    this.a.notify();
                    this.a.close();
                    Log.log("========notifier close successfull");
                    this.a = null;
                }
                return;
            }
            catch (IOException iOException) {
                Log.log("========serverThread closeServer error");
                this.a = null;
                iOException.printStackTrace();
            }
        }
    }
}

