/**
 * IGP class - the InGamePromotion module v 1.4
 */


































// 2 + 28 * 2















// file generated by make_res.bat 















































// IGPPlatformSpecific.h


//#define MIDP1
//#define SPRINT


//#define GAME_PLATFORM_REQUEST_ON_RUN
//#define GAME_PLATFORM_REQUEST_ON_PAINT
//#define GAME_PLATFORM_REQUEST_ON_NEW_THREAD

//#define GAME_PLATFORM_REQUEST_CLOSE_APP


//#define USE_SYSTEM_BAR


////////////////////////////////////////////////////////////////
// Phone constants
////////////////////////////////////////////////////////////////




//Key constants























/////////////////////////////////////////////////////////////////////
// Keys environment
/////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////
// Loading method defines
/////////////////////////////////////////////////////////////////////

// When entering IGP, load all resources and free the dataIGP file
// ( bigger memory consumption )


// When entering IGP, load only first valid page, keep pack open and load resources when changing page
// ( page changes faster but additional 30k+ loaded )
//#define LOAD_GFX_ON_PAGE_CHANGE

// Open the file and read and load the necessary data on every page change
// ( slower but with less memory )
//#define LOAD_ALL_ON_PAGE_CHANGE




	


/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////

// Read byte by byte from InputStream ( Nokia S60 bug )
//#define READ_FROM_STREAM_BUG

/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////

// If the game has a backbuffer available in MM, you can use it
// uncomment the #define USE_GAME_BACKBUFFER
// Fill in the variable that holds the reference to your backbuffer Image
// and Graphics
//#define USE_GAME_BACKBUFFER


/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////

// For MIDP1 sprint phones
// If you must use system softkeys uncomment the #define IGP_USE_SYSTEM_BAR
//and uncomment the #define USE_SYSTEM_BAR in file TestGame.h
// and fill in the call to the function that draws the system softkeys in your application

//#define IGP_USE_SYSTEM_BAR


/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////


// For Series60 and other phones with clipping bug
//#define SETCLIP(g,x,y,w,h) g.setClip(0, 0, DEF.SCR_W, DEF.SCR_H); g.clipRect(x, y, w, h)
// For Exclusive O2XM there are some problems when clipping outside the screen...
//#define SETCLIP(g,x,y,w,h) g.setClip(Math.max(x, 0), Math.max(y, 0), Math.min(w, DEF.SCR_W), Math.min(h, DEF.SCR_H))

// drawRegion and filltrinagle wrapper
// drawregion: no transform, anchor point defaults to Graphics.TOP|Graphics.LEFT
//#define MIDP1

	
	



/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////


import java.io.*;
import java.util.*;
import javax.microedition.io.*;
import javax.microedition.lcdui.*;
import javax.microedition.midlet.*;


public class IGP
{

	//IGPDebug.h

//#define NO_JAD
//#define IGP_DEBUG

	
	
	




	
//CONSTANTS TO DRAW ARROWS



// offset to move the igp arrows ( 4 /6 )













	//demo gradient
	//0x8E2E06
	//0xFF6200



	//promotion gradient
	
	

































//#define LIST_SELECTION_DOUBLE_RECT

//min distance from the page title




















	//IGPProjectSpecific.h

// Fill in this define with the variable/macro name that holds 
// the screen dimensions of your platform






// If your game uses for resources the ResCompiler.exe tool
// and implements the folowing functions:
// - static boolean Lib_Open(String sLibFileName, boolean bRead)
// - static byte[] Lib_GetData(int index, boolean bCopy)
// - static void Lib_Close(), 
// uncomment the USE_GAME_LIB_FUNCTIONS define
// These functions take up approximatly 0.7k jar-size

//#define USE_GAME_LIB_FUNCTIONS  


	
	
	



	



	
	
	
		
		
	




//Font Colors


//cp






	// IGPInternalConstants.h

// macros



// IGP internal states
final static int STATE_LOADING				= 0;
final static int STATE_PAGE					= 1;
final static int STATE_INTERPAGE_LOADING	= 2;

	final static int STATE_EXIT_IGP				= 3;


// IGP actions ( public - used by game class ) 
public final static int ACTION_NONE			= 0;

public final static int ACTION_UP			= 21;
public final static int ACTION_DOWN			= 32;
public final static int ACTION_LEFT			= 23;
public final static int ACTION_RIGHT		= 24;
public final static int ACTION_SELECT		= 25;
public final static int ACTION_BACK			= 26;

public final static int ACTION_KEY_0			= 1;
public final static int ACTION_KEY_1			= 2;
public final static int ACTION_KEY_2			= 3;
public final static int ACTION_KEY_3			= 4;
public final static int ACTION_KEY_4			= 5;
public final static int ACTION_KEY_5			= 6;
public final static int ACTION_KEY_6			= 7;
public final static int ACTION_KEY_7			= 8;
public final static int ACTION_KEY_8			= 9;
public final static int ACTION_KEY_9			= 10;
public final static int ACTION_KEY_POUND		= 11;


// IGP jad attributes indexes for page urls
final static int IGP_URL_IDX_GAME_0 = 0;
final static int IGP_URL_IDX_GAME_1 = 1;
final static int IGP_URL_IDX_GAME_2 = 2;
final static int IGP_URL_IDX_CATEGORY = 3;
final static int IGP_URL_IDX_OPERATOR = 4;

// IGP jad attributes
final static String	URL_PREFIX="URL";
final static String URL_OPERATOR="OPERATOR";

// IGP data file name


// Display constants
final static int PROGRESSBAR_BORDER_COLOR	= 0xFFFFFF;
final static int PROGRESSBAR_FILL_COLOR		= 0xFF0000;
final static int PROGRESSBAR_FILL_HEIGHT	= 3;
final static int PROGRESSBAR_BORDER_SPACING = 1;
final static int PROGRESSBAR_BORDER_HEIGHT	= PROGRESSBAR_FILL_HEIGHT + 2* PROGRESSBAR_BORDER_SPACING + 1;

// IGP Loading steps
final static int LOAD_START					= 0;
final static int LOAD_LIBOPEN				= 1;
final static int LOAD_TEXTS					= 2 + 0 ;		
final static int LOAD_FONT					= 2 + 1 ;	
final static int LOAD_GLOBAL_RES			= 2 + 2 ;
final static int LOAD_PROMO0				= 2 + 3 ;


	final static int LOAD_PROMOTION				=  2 + 6 ;



	final static int LOAD_DEMO0				= 2 + 7 ;



	final static int LOAD_WH				= 2 + 8 ;
	final static int LOAD_BS				= 2 + 9 ;



	final static int LOAD_COMPLETE_CATALOG		= 2 + 10 ;



	final static int LOAD_ORANGE				= 2 + 11 ;
	final static int LOAD_STEP_CATALOG			= LOAD_ORANGE;


	final static int LOAD_END			= LOAD_STEP_CATALOG + 1;

// IGP page constants
final static int PAGE_PROMO_0				= 0;

	final static int PAGE_PROMO_1			= 4  - 2  - 1;


	final static int PAGE_PROMO_2			= 5  - 2  - 1;



	final static int PAGE_PROMOTION				= 6  - 2  - 1;



	final static int PAGE_DEMO_0				= 7  - 2  - 1;



	final static int PAGE_WHATS_HOT			= 8  - 2  - 1;
	final static int PAGE_BESTSELLERS		= 9  - 2  - 1;



	final static int PAGE_COMPLETE_CATALOG	= 10  - 2  - 1;



	final static int PAGE_ORANGE				= 11  - 2  - 1;
	final static int LAST_PAGE_CATALOG		= PAGE_ORANGE;


	final static int MAX_PAGE_NUMBER		= LAST_PAGE_CATALOG + 1;

	final static int DISPLAY_SELECT_SK	= 0x1;	
	final static int DISPLAY_BACK_SK	= 0x2;

	
		
		
	
	
		
	



	//IGPDrawing.h

// Draws a full-screen gradient C1 >> C2 >> C1, clipped by 
// the region described by x, y, wx, wy.
// First, set the above variable to the RGB of both colors.
static void drawGradient( Graphics g, int x, int y, int wx, int wy, int C1, int C2 )
{
	int gradR1 = C1 >> 16;
	int gradG1 = (C1 >> 8) & 0x0000FF;
	int gradB1 = C1 & 0x0000FF;

	int gradR2 = C2 >> 16;
	int gradG2 = (C2 >> 8) & 0x0000FF;
	int gradB2 = C2 & 0x0000FF;
	if ( y+wy > 320   ) wy = 320  -y;
	if ( x+wx > 240   ) wx = 240  -x;

	int dr = gradR2 - gradR1;
	int dg = gradG2 - gradG1;
	int db = gradB2 - gradB1;
	int intr = gradR1;
	int intg = gradG1;
	int intb = gradB1;

	int stp = 0;

	for ( int i = y; i < y+wy; i++ )
	{
		if ( i < 320  /2 )
		{
			stp = i;
		} else
		if ( i == 320  /2 )
		{
			intr = gradR2; intg = gradG2; intb = gradB2;
			stp = 0;
		} else
		{
			stp = 320  /2 - i;
		}
		g.setColor( intr + dr * stp / (320  /2), intg + dg * stp / (320  /2), intb + db * stp / (320  /2) );
		g.drawLine( x, i, x+wx, i );
	}

}

// Draws a progressbar horizontally centered, at y, with total width wx
static void drawProgressBar( Graphics g, int y, int wx, int progress, int total )
{
	if ( progress > total ) progress = total;
	int x = ( 240   - wx )/2;
	g.setColor( PROGRESSBAR_BORDER_COLOR );
	g.drawRect( x , y, wx, PROGRESSBAR_BORDER_HEIGHT );
	int fillWidth = ( wx - 2 * PROGRESSBAR_BORDER_SPACING - 2 * 1) * progress / total + 1;
	g.setColor( PROGRESSBAR_FILL_COLOR );
	g.fillRect( x + 1 + PROGRESSBAR_BORDER_SPACING, y + 1 +PROGRESSBAR_BORDER_SPACING, fillWidth, PROGRESSBAR_FILL_HEIGHT );
}





	//IGPResourceDefines.h

//
// Data file structure defines
//
	final static int IMG_4BLUE				= 0;
	final static int IMG_4WHITE				= 1;
	final static int IMG_6BLUE				= 2;
	final static int IMG_6WHITE				= 3;
	final static int IMG_BACK				= 4;
	final static int IMG_TICK				= 5;
	final static int IMG_GAMELOFT			= 6;
	
		final static int IMG_MORE			= 7;
		final static int EN_IMG_COUNT		= IMG_MORE + 1;
	

	
		final static int DATA_IMG_COUNT		= EN_IMG_COUNT;
	


	//IGPResources.h

// File



// ---------------------------------------------------------------
// Lib File Format:
//		size(bytes)    description
//		----------------------------------------------------------
//		2           -> nf = number of chunks
//		4 * nf      -> offset for each chunk
//		...         -> data for each chunk (last chunk must be an empty one)
// ---------------------------------------------------------------

	static String		_lib_sFileName;		// name of opened lib file
	static int			_lib_nChunks;		// number of chunks
	static int[]		_lib_pOffset;		// offset of each chunk
	static byte[][]		_lib_pData;			// cache data for each chunk

////////////////////////////////////////////////////////////////////////////////////////////////////

	static boolean Lib_Open(String sLibFileName, boolean bRead)
	{

		Lib_Close();

		_lib_sFileName = sLibFileName;
		try
		{
			System.gc();
			InputStream is = "a".getClass().getResourceAsStream(sLibFileName);
			System.gc();

			// Number of chunks...
			_lib_nChunks  = (is.read() & 0xFF);
			_lib_nChunks += (is.read() & 0xFF) << 8;

			// Offset of each chunk...
			_lib_pOffset = new int[_lib_nChunks];
			for (int i = 0; i < _lib_nChunks; i++)
			{
				_lib_pOffset[i]  = (is.read() & 0xFF);
				_lib_pOffset[i] += (is.read() & 0xFF) << 8;
				_lib_pOffset[i] += (is.read() & 0xFF) << 16;
				_lib_pOffset[i] += (is.read() & 0xFF) << 24;
			}

			if (bRead)
			{
				_lib_pData = new byte[_lib_nChunks][];
				for (int i = 0; i < _lib_nChunks-1; i++)
				{
					int chunk_size = _lib_pOffset[i+1] - _lib_pOffset[i];
					if (chunk_size > 0)
					{
						_lib_pData[i] = new byte[chunk_size];
//READ_FROM_STREAM_BUG
						is.read(_lib_pData[i]);
//READ_FROM_STREAM_BUG
					}
				}
			}

			is.close();
			is = null;
			System.gc();
		}
		catch (Exception e)
		{
			 ;
			return false;
		}
		return true;
	}

////////////////////////////////////////////////////////////////////////////////////////////////////

	static void Lib_Close()
	{
		_lib_sFileName = null;
		_lib_pOffset = null;
		_lib_pData = null;
		_lib_nChunks = 0;
		System.gc();
	}

////////////////////////////////////////////////////////////////////////////////////////////////////

	static void Lib_FreeData(int index)
	{
		if (index < 0 || index >= _lib_nChunks-1 || _lib_pData == null) return;
		_lib_pData[index] = null;
	}

////////////////////////////////////////////////////////////////////////////////////////////////////

	static byte[] Lib_GetData(int index, boolean bCopy)
	{
		if (index < 0 || index >= _lib_nChunks-1)
			return null;

		int chunk_size = _lib_pOffset[index+1] - _lib_pOffset[index];
		if (chunk_size == 0)
			return null;

		if (_lib_pData != null)
		{
			if (bCopy)
			{
				byte[] data = new byte[chunk_size];
				System.arraycopy(_lib_pData, index, data, 0, chunk_size);
				return data;
			}
			else
				return _lib_pData[index];
		}
		else
		{
			byte[] data = null;
			try
			{
				InputStream is = null;
				is = "a".getClass().getResourceAsStream(_lib_sFileName);
				is.skip(2 + 4 * _lib_nChunks + _lib_pOffset[index]);
				data = new byte[chunk_size];
//READ_FROM_STREAM_BUG
				is.read(data);
//READ_FROM_STREAM_BUG
				is.close();
				is = null;
			}
			catch (Exception e)
			{
				 ;
			}
			System.gc();
			return data;
		}
	}




// ---------------------------------------------------------------
// Array parsing methods
// ---------------------------------------------------------------

	static int dataOffset;

	static int readInt( byte[] data )
	{
		return ( data[dataOffset++]&0xFF ) + ( (data[dataOffset++]&0xFF) << 8 );
	}

	static byte readByte( byte[] data )
	{
		return (byte)( data[dataOffset++]&0xFF );
	}


	static Image readImage( byte[] data )
	{
		int size = readInt( data );
		Image img = Image.createImage( data, dataOffset, size );
		dataOffset += size;
		return img;
	}

	static String readPlainString( byte[] data )
	{
		int size = readInt( data );
		//String s = new String( data, dataOffset, size );
		dataOffset += size;
		return null; //s
	}



	//IGP12Fonts.h

	//cp will store x, y, w, h of every letter in the font
	private static byte[][] fontDescriptor;
	private static int fontHeight;


	final static int FONT_X=0;
	final static int FONT_Y=1;
	final static int FONT_W=2;
	final static int FONT_H=3;

	private static Image[] fontImage;	

	private static Image createFont(byte [] buffer, int offset, int length, int paletteIndex, int finalColor)
	{
		int pngPlteOffset = 0;
		int tmpIndex = offset;
		long c;

		while ((pngPlteOffset == 0) && (tmpIndex < offset + length))
		{
			if (((buffer[tmpIndex]&0xFF) == (80&0xFF)) &&		//P 
				((buffer[tmpIndex + 1]&0xFF) == (76&0xFF)) &&	//L
				((buffer[tmpIndex + 2]&0xFF) == (84&0xFF)) &&	//T
				((buffer[tmpIndex + 3]&0xFF) == (69&0xFF)))		//e
			{
				pngPlteOffset = tmpIndex;
			}
			tmpIndex++;

		}

		int plteBytesSize = (int)((buffer[pngPlteOffset - 4] << 24)&0xFF000000) + (int)((buffer[pngPlteOffset - 3] << 16)&0x00FF0000) + (int)((buffer[pngPlteOffset - 2] << 8)&0x0000FF00) + (int)((buffer[pngPlteOffset - 1] << 0)&0x000000FF);

		buffer[pngPlteOffset + 4 + (3 * paletteIndex)] = (byte)((finalColor&0xFF0000) >> 16);
		buffer[pngPlteOffset + 4 + (3 * paletteIndex) + 1] = (byte)((finalColor&0xFF00) >> 8);
		buffer[pngPlteOffset + 4 + (3 * paletteIndex) + 2] = (byte)((finalColor&0xFF));

		byte [] tmpBuf = new byte [plteBytesSize + 4];
		System.arraycopy(buffer, pngPlteOffset, tmpBuf, 0, plteBytesSize + 4);

		long [] crc_table = new long [256];
		for (int n = 0; n < 256; n++) 
		{
			c = (long) n;
			for (int k = 0; k < 8; k++) 
			{
				if ((c & 1) == 1)
				c = 0xedb88320L ^ (c >> 1);
				else
				c = c >> 1;
			}
			crc_table[n] = c;
		}

		// Return the CRC of the bytes buf[0..len-1]. 
		c = 0xffffffffL;
		for (int n = 0; n < tmpBuf.length; n++) 
		{
			c = crc_table[(int)(c ^ tmpBuf[n]) & 0xff] ^ (c >> 8);
		}
		c ^=0xffffffffL;

		buffer[pngPlteOffset + 4 + plteBytesSize] = (byte)((c & 0xFF000000) >> 24);
		buffer[pngPlteOffset + 4 + plteBytesSize + 1] = (byte)((c & 0x00FF0000) >> 16);
		buffer[pngPlteOffset + 4 + plteBytesSize + 2] = (byte)((c & 0x0000FF00) >> 8);
		buffer[pngPlteOffset + 4 + plteBytesSize + 3] = (byte)((c & 0x000000FF) >> 0);
		tmpBuf = null;
		crc_table = null;
		System.gc();

		return Image.createImage(buffer, offset, length);
	}




	//IGPStrings.h

	static int drawColor;
	final static int MAX_NB_LINES = 10;
	final static byte lineSeparator = '\n';
	static int[] s_line_w;
	
	static int s_text_h;
	static int s_text_w;

	static int char_spacing = 0 ;
	static int line_spacing = 0 ;

	static boolean bDetermineSizeOnly;
	static int nbLines;


	public static String getString(int strIdx)
	{
		//anup return new String( _StrMgr_Pack, (_StrMgr_Offsets[strIdx - 1] & 0xFFFF), (_StrMgr_Offsets[strIdx] & 0xFFFF) - (_StrMgr_Offsets[strIdx - 1] & 0xFFFF) - 1);
	


				//Anup
				int off = (strIdx == 0) ? 0 : (_StrMgr_Offsets[strIdx - 1] & 0xFFFF);
				int len = (_StrMgr_Offsets[strIdx] & 0xFFFF) - off - 1;
				if (len == 0)
							return "String not found";
		return new String(_StrMgr_Pack, off, len);
	}
	static void drawString(int strIdx, Graphics g, int x, int y, int anchor)
	{
		int off = (strIdx == 0) ? 0 : (_StrMgr_Offsets[strIdx - 1] & 0xFFFF);
		int len = (_StrMgr_Offsets[strIdx] & 0xFFFF) - off - 1;

		if (len == 0)
			return ;
		drawString(_StrMgr_Pack, off, len, g, x, y, anchor);
	}
	static void drawString(String str, Graphics g, int x, int y, int anchor)
	{
		drawString(str.getBytes(), 0, str.length(), g, x, y, anchor);
	}
	static void drawString(byte[] strBuff, int off, int len, Graphics g, int x, int y, int anchor)
	{
		s_line_w[0] = 0;
		s_text_w = 0;
		int line = 0;
		int c;
		int i;
		for (i = off; i < off+len; i++)
		{
			c = strBuff[i] & 0xFF;

			if(c == lineSeparator && line < MAX_NB_LINES) 
			{
				s_line_w[line] -= char_spacing;
				if(s_line_w[line] > s_text_w)
					s_text_w = s_line_w[line];
				s_line_w[++line] = 0;
			}
			else if ( c != 0 && c != 1 )
			{
				s_line_w[line] += fontDescriptor[c][FONT_W] + char_spacing;
			}
		}
		s_line_w[line] -= char_spacing;
		if(s_line_w[line] > s_text_w)
			s_text_w = s_line_w[line];
		s_text_h = ( line + 1 ) * fontHeight + line * line_spacing;
		nbLines = line + 1;

		if(bDetermineSizeOnly)
		{
			bDetermineSizeOnly = false;
			return;
		}
		
		y += line_spacing*( line )/2 ;
		line = 0;
		if ((anchor & Graphics.BOTTOM)  != 0)	
	 		y -= s_text_h;
		else if ((anchor & Graphics.VCENTER) != 0)	
			y -= s_text_h>>1;
			
		int posX = x;

		boolean newLine = true;
		for (i = off; i < off+len; i++)
		{
			c = strBuff[i] & 0xFF;

			if(newLine)
			{
				posX = x;
				if ((anchor & Graphics.RIGHT)   != 0)	
					posX -= s_line_w[line];
				else if ((anchor & Graphics.HCENTER) != 0)	
					posX -= s_line_w[line]>>1;
				newLine = false;
			}
			if(c == lineSeparator && line < MAX_NB_LINES)
			{
				y += fontHeight + line_spacing;
				line++;
				newLine = true;
			}
			else if ( c == 0 )
			{
				drawColor = strBuff[++i] & 0xFF;
			}
			else
			{
				 g .setClip(  posX ,  y ,  fontDescriptor[c][FONT_W] ,  fontDescriptor[c][FONT_H] ) ;
				  g .drawRegion(   fontImage[drawColor] ,   fontDescriptor[c][FONT_X] ,   fontDescriptor[c][FONT_Y] ,   fontDescriptor[c][FONT_W] ,   fontDescriptor[c][FONT_H] , 0,   posX ,   y , Graphics.TOP|Graphics.LEFT); ;
				posX += fontDescriptor[c][FONT_W] + char_spacing;
			}
		}
		 g .setClip(  0 ,  0 ,  240   ,  320   ) ;
		drawColor = 0 ;
	}	


	// Added by Anup
		public static int getStringWidth(String s)
		{
			byte[] b=s.getBytes();
			return getStringWidth(b, 0, b.length);
		}

		public static int getStringWidth(byte[] strBuff, int off, int len)
		{
			int posX = 0;
				for (int i = off; i < off+len; i++)
				{
					int c = strBuff[i] & 0xFF;
						if(c != lineSeparator && c != 0 )
						{
							posX += fontDescriptor[c][FONT_W] + 0 ;
						}
				}
			return posX;
		}

		public static String insertNewLine(String str , int max_width)
		{

		if (getStringWidth(str)<=max_width)
		 	return str;
		if ( str.indexOf("\n")!=-1) // if string already contains newline charecter then skip
			return str;

		int fromIndex=0;
		int indexOfSpace;
		int lastSpace=0;

		while(true)
			{
				indexOfSpace=str.indexOf(' ',fromIndex);
				if(indexOfSpace==-1)
					return str.substring(0,lastSpace)+"\n"+str.substring(lastSpace+1,str.length());
				fromIndex=indexOfSpace+1;

				if (getStringWidth(str.substring(0,indexOfSpace)) > max_width)
				{

					return (str.substring(0,lastSpace)+"\n"+insertNewLine(str.substring(lastSpace+1,str.length()),max_width));
				}

				lastSpace=indexOfSpace;
			}

		}




	//IGPLoad.h
	public static void initialize(MIDlet midlet)
	{
		MidletInstance = midlet;

		// Verify presence of data file
		//IsAvailable = IGP_LIB_OPEN( IGP_DATA_FILE, false );

		//url's and settings computed from jad
		//if ( IsAvailable )
		{
			readAndParseURLs();
		}

		//Loading steps ;)

		TotalLoadingSteps = 1 + // lib_open
							1 + // text
							1 + // font
							1 +	// general data
							3  + 
	
							1  + 
	
	
							1 + 
							1 + 
	
	
							1 + 
	
	
							1 + 
	
	
							1 + 
	
							1; // end load
//LOAD_ALL_IGP_RESOURCES



	}

	final static byte k_Check_NULL = (1 << 0);
	final static byte k_Check_DEL = (1 << 1);
	final static byte k_Check_NO = (1 << 2);
	final static byte k_Check_ALL = k_Check_DEL | k_Check_NULL | k_Check_NO;

	final static byte k_Check_PROMO = k_Check_DEL;
	final static byte k_Check_DEMO = k_Check_ALL;
	final static byte k_Check_ORANGE = k_Check_DEL;
	
	static boolean checkURL(String url, int checkFlags)
	{
		if ( url == null ) 
			return (checkFlags & k_Check_NULL) == 0;
		
		url = url.trim();
/*		
		if( url.length() == 0 )
		{
			return (checkFlags & k_Check_NULL) == 0;
		}

		if( url.toUpperCase().compareTo("NO") == 0 || url.toUpperCase().compareTo("0") == 0 )
		{
			return (checkFlags & k_Check_NO) == 0;
		}

		if( url.toUpperCase().compareTo("DEL") == 0 )
		{
			return (checkFlags & k_Check_DEL) == 0;
		}
		return true;
*/
		return ( ( (checkFlags & k_Check_NULL) == 0 || url.length() != 0 )
				&&((checkFlags & k_Check_DEL) == 0  || url.toUpperCase().compareTo("DEL") != 0 )
				&&((checkFlags & k_Check_NO) == 0   || (url.toUpperCase().compareTo("NO")!=0 && url.toUpperCase().compareTo("0")!=0) ) );
	}

		final static String[] PAGE_LIST_PREFIXES = 
		{

			URL_PREFIX + "-" + "WN"  , 
			URL_PREFIX + "-" + "BS"  , 


			URL_PREFIX, 


		};

		final static String s_IGP_PROMOS = "IGP-PROMOS";
		final static String s_IGP_DEMOS = "IGP-DEMOS";
		final static String s_IGP_WN = "IGP-WN";
		final static String s_IGP_BS = "IGP-BS";
		final static String s_IGP_HOST = "IGP-HOST";
		final static String s_IGP_CATEGORIES = "IGP-CATEGORIES";
		final static String k_URL_TEMPLATE_GAME = "URL-TEMPLATE-GAME";
//		final static String k_URL_TEMPLATE_CATEGORY = "URL-TEMPLATE-CATEGORY";
		final static String s_PLACEHOLDER = "XXXX";
		final static String s_ctg_PLACEHOLDER = "&ctg="+s_PLACEHOLDER;
		final static String s_GAME_SEPARATOR = ";";
//		final static String s_VAL_SEPARATOR = ",";

		static String s_URL_TEMPLATE_GAME;
//		static String s_URL_TEMPLATE_CATEGORY;
		static boolean b_useIGPRedir;
		

		private static String getRedirLink(String appProp, String code, String urlTemplate)
		{
			String url = "";
//			String adid = "";


			try{
				if(urlTemplate != null && appProp != null && code != null) 
				{
					int startPos = appProp.indexOf(code+"=");
					urlTemplate = urlTemplate.trim();
					if(startPos >= 0 && urlTemplate.length() > 0)
					{
						startPos += code.length()+1;
						int endPos = appProp.indexOf(s_GAME_SEPARATOR, startPos);
						if(endPos < 0)
							endPos = appProp.length();
						url = appProp.substring(startPos, endPos);

						url = url.trim();
						if(url.length() == 0 || url.compareTo("0")==0 || url.toUpperCase().compareTo("NO")==0 )
							url = "";
						else if(url.toUpperCase().compareTo("DEL")!=0)
						{
							int separatorPos = urlTemplate.indexOf(s_PLACEHOLDER);
							url = urlTemplate.substring(0, separatorPos)
								+ url
								+ urlTemplate.substring(separatorPos + s_PLACEHOLDER.length());
						}
					}
				}
			} 
			catch(Exception e)
			{
				url = "";
			}
			return url;
		}

		private static void parseSplash(int page, String code, int check, String jadEntry, String urlTemplate)
		{
			try
			{
				if(b_useIGPRedir)
					PageURLs[page] = getRedirLink( MidletInstance.getAppProperty(jadEntry), code, urlTemplate);

				else if(jadEntry ==  s_IGP_DEMOS)
				{
					PageURLs[page] = MidletInstance.getAppProperty(URL_PREFIX + "-" + "DEMO"   + "-" + code);
				}

				else
					PageURLs[page] = MidletInstance.getAppProperty(URL_PREFIX + "-" + code);
				if(checkURL( PageURLs[page], check ))
				{
					ValidPagesIdx[ValidPages++] = page;
					if(PageURLs[page].toUpperCase().compareTo("NO")==0 || PageURLs[page].toUpperCase().compareTo("0")==0)
						PageURLs[page] = "";
				}
			}
			catch( Exception e )
			{}
		}


		private static void parseList(int list, String[] list_codes, int page, int itemNo, int currentList_item_start, String jadEntry)
		{
			LIST_URLs[list]		= new String[itemNo];
			ValidLISTIdx[list]	= new int[itemNo];
			LIST_Texts[list]	= new int[itemNo];

			int nbItems = 0;


			if(bOrangeCatalog) return;


			String urlTemplate = "";
			if(b_useIGPRedir)
			{
				try
				{
					jadEntry = MidletInstance.getAppProperty(jadEntry);
					if(list != 2 )
						urlTemplate = s_URL_TEMPLATE_GAME;
					else if(s_urlOperator.length() > 0)
						urlTemplate = s_urlOperator + s_ctg_PLACEHOLDER;
				}
				catch(Exception e)
				{}

			}
			for ( int j = 0; j < list_codes.length; j++ )
			{
				try
				{
					String url = "";
					if( list != 2  && j == itemNo - 1)
					{
						if(!b_useIGPRedir)
							url = MidletInstance.getAppProperty(PAGE_LIST_PREFIXES[list] );
						else if(s_urlOperator.length() > 0)
							url = getRedirLink(MidletInstance.getAppProperty(s_IGP_CATEGORIES), list_codes[j], s_urlOperator + s_ctg_PLACEHOLDER);
					}
					else if(b_useIGPRedir)
					{
						//complete catalogue

						if(list_codes[j].compareTo("GLDT"  )==0)
							url = getRedirLink(jadEntry, list_codes[j], s_URL_TEMPLATE_GAME);
						else

						if(list_codes[j].compareTo("OPERATOR"  )==0)
							url = s_urlOperator;
						else 
							url = getRedirLink(jadEntry, list_codes[j], urlTemplate);
					}
					else
						url = MidletInstance.getAppProperty(PAGE_LIST_PREFIXES[list] + "-" + list_codes[j]);


					if( checkURL(url, k_Check_ALL) )
					{
						LIST_URLs[list][nbItems] = url;
						ValidLISTIdx[list][nbItems++] = j;
						LIST_Texts[list][j]	= currentList_item_start + j;
					}
				}
				catch (Exception e)
				{}

			}
			if(nbItems > 0)
			{
				ValidPagesIdx[ValidPages++] = page;
				LIST_nbItems[list] = nbItems;
			}
		}

	private static void readAndParseURLs()
	{
		//page arrays initialization
		String[] PROMOS = { "BBRK", "PSOL", "PKKR", } ;


		String[] DEMOS = { "BCDE", } ;


		ValidPages=0;
		ValidPagesIdx		= new int[ MAX_PAGE_NUMBER ];
		PageURLs			= new String[ MAX_PAGE_NUMBER ];


		//list arrays initialization
		String[][] LIST = 
		{

			{ "TO07", "GANG", "DEHO", "MHMP", "WN" } ,
			{ "BUBA", "PMHJ", "DOGZ", "MMN", "BS" } ,


			{ "GOTW", "GLDT", "BRAIN", "OPERATOR" } ,

		};

		LIST_URLs		= new String[ 3  ][];
		ValidLISTIdx	= new int[ 3  ][];
		LIST_Texts		= new int[ 3  ][];
		LIST_nbItems	= new int[ 3  ];


		//special case - operator Orange FR

		try{
			bOrangeCatalog = Integer.parseInt(MidletInstance.getAppProperty(URL_PREFIX + "-" + "ORANGE"  )) == 1;
		}
		catch(Exception e){}


		//detect if we have redir or direct links
		try
		{
			s_URL_TEMPLATE_GAME = MidletInstance.getAppProperty(k_URL_TEMPLATE_GAME).trim();
			b_useIGPRedir = true;
		} 
		catch(Exception e)
		{}


		//parse promos and demos

		for(int promo = 0; promo < 3 ; promo++ )
		{
			parseSplash(promo, PROMOS[promo], k_Check_PROMO, s_IGP_PROMOS, s_URL_TEMPLATE_GAME);
		}		

		String l_urlOperator = null;
		try
		{
			l_urlOperator = MidletInstance.getAppProperty(URL_PREFIX  + "-" + "OPERATOR"  );
			if(checkURL(l_urlOperator, k_Check_ALL))
				s_urlOperator = l_urlOperator;


			String str = MidletInstance.getAppProperty("URL-PT"  );
			if( str != null )
			{
				//fix sequential JAD reading
				s_textPt = "";
				int len = str.length();
				for(int i = 0; i < len; i++ )
				{
					char c = str.charAt( i );
					if(i < len - 1 && c == '\\' && (str.charAt( i + 1 ) == 'n' || str.charAt( i + 1 ) == 'N') )
					{
						s_textPt += '\n';
						i++;
					}
					else
						s_textPt += c;
				}
				s_textPt = s_textPt.toUpperCase();
				if(!checkURL(s_textPt, k_Check_ALL))
					s_textPt = null;
			}



		}
		catch (Exception e)
		{}
		

		if(!bOrangeCatalog)

		if( checkURL(s_urlOperator, k_Check_ALL) )
		{

			parseSplash(PAGE_PROMOTION, "PROMO"  , k_Check_ALL, s_IGP_CATEGORIES, s_urlOperator + s_ctg_PLACEHOLDER);

		}


		if(!bOrangeCatalog)


		for(int demo = 0; demo < 1 ; demo++ )
		{
			parseSplash(PAGE_DEMO_0 +demo, DEMOS[demo], k_Check_DEMO, s_IGP_DEMOS, s_URL_TEMPLATE_GAME);
		}



		//parse What's New and Bestsellers
		parseList(0 , LIST[0 ],  PAGE_WHATS_HOT, 4  + 1, 11  , s_IGP_WN);
		parseList(1 , LIST[1 ], PAGE_BESTSELLERS, 4  + 1, 16  , s_IGP_BS);



		//parse Complete Catalog
		parseList(2 , LIST[2 ], PAGE_COMPLETE_CATALOG, 4 , 21  , s_IGP_CATEGORIES);



	
		if(bOrangeCatalog) 
	
		{
			try
			{
				PageURLs[PAGE_ORANGE] = s_urlOperator;
				if(checkURL(l_urlOperator, k_Check_ORANGE) ) 	
				{
					ValidPagesIdx[ValidPages++] = PAGE_ORANGE;
				}
			}
			catch (Exception e)
			{}
		}



		LIST = null;

		PROMOS = null;

		IsAvailable = ValidPages > 0;
	}
	
	public static void enterIGP( String loadingMsg, int lang )
	{


		CurrentLanguage = lang;


		StringLoading = loadingMsg;

		CurrentLoadingStep = -1;
		CurrentState = STATE_LOADING;

		CurrentPageIdx = 0;
		CurrentPage = ValidPagesIdx[0];

		s_igpListDisplayItemStart = 0;
		s_ItemListIndex = 0;

		drawColor = 0 ;
		 ;

		s_line_w = new int[MAX_NB_LINES];
//USE_GAME_BACKBUFFER
	}


	static boolean isPageVisible( int page )
	{
		boolean visible = false;
		for ( int i = 0; i < ValidPages; i++ )
		{
			if ( ValidPagesIdx[i] == page )
			{	
				visible=true;
				break;
			}
		}
		return visible;
	}



		static byte[]	_StrMgr_Pack;

	static short[]	_StrMgr_Offsets;

	private static void loadResources( int loadStep )
	{

		byte[] data;
		dataOffset = 0;
		int i, idx = 0;
		int page = loadStep - LOAD_PROMO0;

		int list				= 0;
		int resource_slot		= 0;
		int resource_nbItems	= 0;
//IGP_HAS_LIST

		if ( page > 0 && loadStep < LOAD_END ) 
		{

			if( !isPageVisible( page ) )
				return;


			PageImages[ page ] = GlobalImages[ IMG_GAMELOFT ];
		}
		 ;

		switch ( loadStep )
		{
			case LOAD_START:
				//init global arrays
				GlobalImages		= new Image[ DATA_IMG_COUNT ];
				PageImages			= new Image[ MAX_PAGE_NUMBER ];

				// LIST specific
				LIST_Images		= new Image	[ 3  ][];
	
				LIST_Images[0 ]	= new Image	[ 4  + 1];
				LIST_Images[1 ]	= new Image	[ 4  + 1];
	//IGP_HAS_WHBS
	
				LIST_Images[2 ]	= new Image	[ 4  ];
	
//IGP_HAS_LIST
				break;

			case LOAD_LIBOPEN:
				// igp data file opening
				Lib_Open(  "/dataIGP"  ,   true  ) ;
				 ;
				break;

			case LOAD_TEXTS:
				data = Lib_GetData(  0  ,   false  ) ;
				int size;

				//skip languages
				for ( i = 0; i < CurrentLanguage; i++ )
				{
					size = readInt( data );
					dataOffset += size;
				}


				readInt( data );//sizePack
				size = readInt( data );

				_StrMgr_Pack = new byte[size];
				System.arraycopy(data, dataOffset, _StrMgr_Pack, 0, size);


				dataOffset += size;
				readInt( data );//sg dumb...
				int nStrings = (data[dataOffset++] & 0xFF) | ((data[dataOffset++] & 0xFF) << 8);
				_StrMgr_Offsets = new short[nStrings];
				for ( i = 0; i < nStrings-1; i++)
				{
					_StrMgr_Offsets[i] = (short)((data[dataOffset++]&0xFF) + ((data[dataOffset++]&0xFF)<<8));
				}
				_StrMgr_Offsets[nStrings-1] = (short)size;

				break;

			case LOAD_FONT:
				// fonts
				// font image with palette

				fontImage = new Image[2 ];

				fontDescriptor = new byte[256][4];

				data = Lib_GetData(  1  ,   false  ) ;

				int imageSize = readInt( data );
				dataOffset = 0;

				fontImage[0 ] = readImage( data );
				fontImage[1 ] = createFont( data, 2, imageSize, 1, 0x00FF0000);
				//font descriptor

				int nrChars = readInt( data ) / 5; //5 bytes / char >> ascii, x, y, w, h x 1 b

				int imageNameInt;
				for ( i = 0; i < nrChars; i++ )
				{

					imageNameInt = readByte( data )&0xFF;

					fontDescriptor[imageNameInt][FONT_X] = readByte( data );
					fontDescriptor[imageNameInt][FONT_Y] = readByte( data );
					fontDescriptor[imageNameInt][FONT_W] = readByte( data );
					fontDescriptor[imageNameInt][FONT_H] = readByte( data );
					if(imageNameInt == 32)//space
						fontHeight = /*( fontDescriptor[imageNameInt][FONT_H] > fontHeight ) ? */fontDescriptor[imageNameInt][FONT_H] /*: fontHeight*/;
				}
				 ;
				break;


			case LOAD_GLOBAL_RES:
				data = Lib_GetData(  2  ,   false  ) ;
				for ( i = 0; i < DATA_IMG_COUNT; i++ )
				{
					GlobalImages[i] = readImage( data );
				}
				 ;
				break;
			default:
				idx = 3  + page;	//promo

				if(loadStep >= LOAD_DEMO0 )		//demo
					idx = 7  + page - PAGE_DEMO_0;

				PageImages[ page ] = readImage( Lib_GetData(  idx  ,   false  )  );
				 ;
				break;

	
			case LOAD_WH:
				resource_nbItems	= 4 ;
				resource_slot		= 8 ;
			case LOAD_BS:
				if ( loadStep == LOAD_BS )
				{
					list			= 1 ;
					resource_nbItems= 4 ;
					resource_slot	= 9 ;
				}

	
	
			case LOAD_COMPLETE_CATALOG:
				if ( loadStep == LOAD_COMPLETE_CATALOG )
				{
					list			= 2 ;
					resource_nbItems= 4 ;
					resource_slot	= 10 ;
				}
	
				data = Lib_GetData(  resource_slot  ,   false  ) ;

				for ( ; idx < resource_nbItems;idx++ )
				{
					LIST_Images[ list ][ idx ] = readImage( data );
				}

	
		
				if ( loadStep != LOAD_COMPLETE_CATALOG )
		
				LIST_Images[ list ][ idx ] = GlobalImages[IMG_MORE];
	
				break;
//IGP_HAS_LIST


			case LOAD_ORANGE:
				
				if (bOrangeCatalog) 
				
				{
					data = Lib_GetData(  11  ,   false  ) ;
					PageImages[ PAGE_ORANGE ] = readImage( data );
					PageFROGLogo = readImage( data );
				}
				break;


			case LOAD_PROMOTION:
				{
					data = Lib_GetData(  6  ,   false  ) ;
					PagePromotionImage = readImage( data );
				}
				break;

			case LOAD_END:
				Lib_Close() ;
				break;

		}
//		try{ Thread.sleep(1000); } catch ( Exception e ) {}
	}

	static void unloadResources( boolean complete )
	{
		int i = 0;

		if ( complete ) 
		{
			
				//lib is left open, so close it on exit
				Lib_Close() ;
			
		
			fontDescriptor = null;
			fontImage = null;

			for ( i = 0; i < DATA_IMG_COUNT; i++ ) 
			{
				GlobalImages[ i ] = null;
			}
			GlobalImages = null;
		}

		for ( i = 0; i < MAX_PAGE_NUMBER; i++ ) 
		{
			PageImages[ i ] = null;
		}
		if ( complete ) 
		{
			PageImages = null;

			PageFROGLogo = null;


			PagePromotionImage = null;

		}


		for ( i = 0; i < LIST_Images.length; i++ ) 
		{
			if ( LIST_Images[ i ] != null )
			for ( int j = 0; j < LIST_Images[ i ].length; j ++ )
			{
				LIST_Images[i][ j ] = null;
			}
		}
		if ( complete )
		{
			LIST_Images = null;
		}


		if ( complete )
		{
			_StrMgr_Offsets = null;

			_StrMgr_Pack = null;
			s_line_w = null;
			//USE_GAME_BACKBUFFER
			StringLoading = null;
			
		}
		System.gc();

	}


	//IGPUpdate.h
	public static boolean updateIGP( int action )
	{

		//safeguard
		if ( !IsAvailable ) return true;

		int i;
		switch ( CurrentState )
		{
			case STATE_LOADING:
				if ( CurrentLoadingStep++ >= TotalLoadingSteps )
				{
					initPage();
					CurrentState = STATE_PAGE;

				}
				else
				{
					
						loadResources( CurrentLoadingStep );
					

					

				}
				break;
			case STATE_PAGE:
				switch(action)
				{
					case ACTION_BACK:
						CurrentState = STATE_EXIT_IGP;
						break;
					case ACTION_KEY_4:
					case ACTION_LEFT:
						if( ValidPages <= 1 )
							break;
						if( CurrentPageIdx-- == 0 )
							CurrentPageIdx = ValidPages - 1;
						_redArrowLeft = true;
					case ACTION_KEY_6:
					case ACTION_RIGHT:
						if( ValidPages <= 1 )
							break;
						if(!_redArrowLeft)//right pressed
						{
							if( CurrentPageIdx++ == ValidPages - 1 )
								CurrentPageIdx = 0;
							_redArrowRight = true;
						}

						s_igpListDisplayItemStart = 0;
						s_ItemListIndex = 0;

						initPage();
						break;

					case ACTION_KEY_8:
					case ACTION_DOWN:

						if( bIsListPage && s_ItemListIndex < currentList_nbItems - 1 )
						{	
							s_ItemListIndex++;
							if(s_ItemListIndex - s_igpListDisplayItemStart >= LIST_visibleItemCount)
							{
								s_igpListDisplayItemStart++;
							}

						}
//IGP_HAS_LIST
						break;

					case ACTION_KEY_2:
					case ACTION_UP:

						if( bIsListPage && s_ItemListIndex > 0 )
						{
							s_ItemListIndex--;
							if(s_ItemListIndex - s_igpListDisplayItemStart < 0)
							{
								s_igpListDisplayItemStart--;
							}


						}
//IGP_HAS_LIST
						break;
					case ACTION_KEY_5:
					case ACTION_SELECT:
						String url = PageURLs[ CurrentPage ];

						if( bIsListPage )
							url = LIST_URLs[ currentList ][ s_ItemListIndex ];


						// URL for platform request set
						if(url != null && url.length() > 0)
						{

	
							URLPlatformRequest = url;
	

						}
						break;
				}
				break;






			case STATE_EXIT_IGP:
				//exit , unload all resources
				unloadResources( true );
				 ;
				return true;
		}
		return false;
	}

	static void initPage()
	{


		CurrentPage = ValidPagesIdx[ CurrentPageIdx ];
		s_displaySoftKeys = 0;
		pageTextId = CurrentPage;

		s_ItemListIndex = 0;
		currentList_nbItems = 0;
		s_igpListDisplayItemStart = 0;
		bIsListPage = false;

		bDisplayButton = (PageURLs[ CurrentPage] != null) && (PageURLs[ CurrentPage].length() > 0) && (PageURLs[ CurrentPage].compareTo("DEL")!= 0);
		s_box_color = 0xFF0000 ;


	
		if(CurrentPage == PAGE_WHATS_HOT)
		{
			currentList = 0 ;
			bIsListPage = true;
		}

		if(CurrentPage == PAGE_BESTSELLERS)
		{
			currentList = 1 ;
			bIsListPage = true;
		}
	
	
		if(CurrentPage == PAGE_COMPLETE_CATALOG)
		{
			currentList = 2 ;
			//currentList_nbItems = BS_nbItems;
			//currentList_item_start = FIRST_IGP_TEXT_BS;
			bIsListPage = true;
			bDisplayButton = true;
		}
	
		if(bIsListPage)
		{
			currentList_nbItems = LIST_nbItems[currentList];
		}



		if( bDisplayButton
		
			|| bIsListPage
		
			)
			 s_displaySoftKeys |= DISPLAY_SELECT_SK;
			;
				s_displaySoftKeys |= DISPLAY_BACK_SK;


		iButtonStringId = 9 ;


		bIsSplashPage = CurrentPage < 3  

			|| (CurrentPage >= PAGE_DEMO_0 && CurrentPage < PAGE_DEMO_0 + 1 )

			;
		if(bIsSplashPage)
			iButtonStringId = 10 ;

		getFlashingBoxRect();


		if ( CurrentPage == PAGE_ORANGE )
			box_y = 320   - box_h - 75 ;



	}

	static int dirty_y;
	static int dirty_h;



	static public String encode(String str)
	{
		char[] out = new char[str.length()];
		for (int i = 0; i < str.length(); i++) 
		{
			out[ i ] = (char)('A' + ( str.charAt(i) - '0'));
		}
      return new String(out);
   }


   public static void getFlashingBoxRect()
   {
		bDetermineSizeOnly = true;
		drawString( iButtonStringId, null, 0, 0, Graphics.VCENTER | Graphics.HCENTER);

		box_w = s_text_w + 4 ;
		box_h = s_text_h + 0 ;

		box_x = ( 240   >> 1 )  - box_w/2;
		box_y = ( 320   >> 1 )  - box_h/2;

		if( !bIsSplashPage )
			box_y = 320   - box_h - 10 ;   

		else if (CurrentPage >= PAGE_DEMO_0)
			box_y += 20 ;


   }


	//anup
public static boolean updateIGPKey(int keyCode)
{



				int igpAction = IGP.ACTION_NONE;
int _currentKey=getKeyMask (keyCode);
				switch ( _currentKey )
				{
					case ACTION_UP:
						igpAction = ACTION_UP;
						break;
					case ACTION_DOWN:
						igpAction = ACTION_DOWN;
						break;
					case ACTION_LEFT:
						igpAction = ACTION_LEFT;
						break;
					case ACTION_RIGHT:
						igpAction = ACTION_RIGHT;
						break;
					case ACTION_BACK:
						igpAction = ACTION_BACK;
						break;
					case ACTION_SELECT:
						igpAction = ACTION_SELECT;
						break;
					default:
						if(_currentKey == ACTION_KEY_POUND)
							igpAction = ACTION_KEY_POUND;
						else if(_currentKey >= ACTION_KEY_0 && _currentKey <= ACTION_KEY_9)
							igpAction = ACTION_KEY_0 + (_currentKey - ACTION_KEY_0);
						break;
				}

				return(updateIGP( igpAction ));



}
private static int getKeyMask(int keyCode)
	{
	    switch ( keyCode )
	    {
	        case Canvas.KEY_NUM0 :				return ACTION_KEY_0;
	        case Canvas.KEY_NUM1 :				return ACTION_KEY_1;
	        case Canvas.KEY_NUM2 :				return ACTION_KEY_2;
	        case Canvas.KEY_NUM3 :				return ACTION_KEY_3;
	        case Canvas.KEY_NUM4 :				return ACTION_KEY_4;
	        case Canvas.KEY_NUM5 :				return ACTION_KEY_5;
	        case Canvas.KEY_NUM6 :				return ACTION_KEY_6;
	        case Canvas.KEY_NUM7 :				return ACTION_KEY_7;
	        case Canvas.KEY_NUM8 :				return ACTION_KEY_8;
	        case Canvas.KEY_NUM9 :				return ACTION_KEY_9;
	        case Canvas.KEY_STAR :
	        case Canvas.KEY_POUND :         return ACTION_KEY_POUND;

	        case -1 :             return ACTION_UP;
	        case -2 :           return ACTION_DOWN;
	        case -3 :           return ACTION_LEFT;
	        case -4 :          return ACTION_RIGHT;
	        case -5 :         return ACTION_SELECT;

			//For usability on more devices, Star LSK, and Pound RSk have the same function

	        case -6 :			return ACTION_SELECT;
	        case -7 :			return ACTION_BACK;
//INVERSE_SOFTKEYS
	    }
	    return 0;
	}


	//IGPPaint.h


	


	static int		_arrowPressedCounter;
	static boolean	_redArrowLeft;
	static boolean	_redArrowRight;

	public static void paintIGP( Graphics g )
	{
		 g .setClip(  0 ,  0 ,  240   ,  320    ) ;

		//safeguard
		if ( !IsAvailable ) return;
		switch ( CurrentState )
		{
			case STATE_LOADING:
				g.setColor(0);
				g.fillRect( 0, 0, 240  , 320   );
				drawProgressBar( g, ( 320   >> 1 ) , 240  *3/4, CurrentLoadingStep, TotalLoadingSteps );
		
				if (StringLoading == null || StringLoading.trim().equals(""))
				{
				
					break; //default value!
				
				}
				g.setColor( 0xFFFFFF );
				g.setFont( Font.getFont( Font.FACE_SYSTEM , Font.STYLE_PLAIN , Font.SIZE_SMALL  ) );
				g.drawString( StringLoading, ( 240   >> 1 ) , ( 320   >> 1 )  - 5, Graphics.BOTTOM | Graphics.HCENTER );
				break;

			case STATE_PAGE:
				//draw gradient
				 g  .setClip(  0 ,  0 ,  240   ,  320    ) ;
				int number_length = 0;


				{
					//DRAW GRADIENT

					int gradientTop = 0x03141C ;
					int gradientCenter = 0x0088D7 ;

					if( bIsSplashPage && CurrentPage >= PAGE_DEMO_0 )
					{
						gradientTop = 0xFFB006 ;
						gradientCenter = 0xF4F201 ;
					}


					if( CurrentPage == PAGE_PROMOTION )
					{
						gradientTop = 0xFFB006 ;
						gradientCenter = 0xF4F201 ;
					}

					int listSelectionColor = 0xFFFFFF ;

	
					if ( CurrentPage == PAGE_ORANGE )
					{
						gradientTop = 0;
						gradientCenter = 0;
					}
	

					drawGradient( g , 0, 0, 240  , 320  , gradientTop, gradientCenter );

					drawSoftkeys(g );

					//DRAW PAGE ELEMENTS

					int image_y = 10 ;
					int text_y = 39 ;
					int text_anchor = Graphics.HCENTER | Graphics.TOP;
					boolean bDrawPageImage = PageImages[ CurrentPage ] != null;
					boolean bDrawPageText = true;
					//promos

					if(bIsSplashPage)
					{
						image_y = 15 ;
						text_y	= ( 320   >> 1 )  + ( 15  + PageImages[CurrentPage].getHeight() )/2

						;
						text_anchor = Graphics.HCENTER | Graphics.VCENTER;
					}
					else

					if( !bIsListPage )

					{
						text_anchor = Graphics.HCENTER | Graphics.VCENTER;
						text_y	= ( 320   >> 1 ) ;
					}

					//category

					//catalog
					if(CurrentPage == PAGE_ORANGE)
					{
						image_y = 25 ;
						g .drawImage( PageFROGLogo, 240  -15 , 320  -15 , ( Graphics.BOTTOM|Graphics.RIGHT )  );

						//Orange FR catalog string
						drawString( 8 , g , 30 ,  (( 320   >> 1 )  - 48) ,  Graphics.LEFT | Graphics.TOP);
						bDrawPageText = false;
					}



					if( CurrentPage == PAGE_PROMOTION )
					{

						if(s_textPt != null && s_textPt.length() > 0)
						{
							text_y = 120 ;
							drawString( s_textPt, g , ( 240   >> 1 ) ,  220 ,  Graphics.HCENTER | Graphics.VCENTER);
	
						}

						g .drawImage( PagePromotionImage,  ( 240   >> 1 ) ,  text_y,  Graphics.HCENTER | Graphics.VCENTER);
					}



				if( bIsListPage )
				{
					// LIST list draw

					//check if we need to scroll
					int list_vspace =Math.max( 2 * fontHeight, LIST_Images[ currentList ][ ValidLISTIdx[currentList][0]].getHeight());

					bDetermineSizeOnly = true;
					drawString( pageTextId, null, 0, 0, 0);

						int list_y = text_y + s_text_h;


					int arrow_height = 16  - 2 ;
					int listArea_maxHeight;

					if(currentList == 2  )
					{
						list_vspace += 4 ;
						listArea_maxHeight = box_y - list_y - 2* 5 ;
					}
					else

					{
						list_vspace += 8 ;
						listArea_maxHeight = 320   - list_y - 2* 5 ;
					}

					LIST_visibleItemCount = currentList_nbItems;

					if(listArea_maxHeight / list_vspace < currentList_nbItems)
					{
						//scroll
						LIST_visibleItemCount = (listArea_maxHeight - 2*arrow_height) / list_vspace;
					}

					list_y  += (listArea_maxHeight - LIST_visibleItemCount * list_vspace)/2 + 5 ;

					int y = list_y;

					if(LIST_visibleItemCount < currentList_nbItems)
					{
						if ( s_ItemListIndex > 0 )
							drawArrow(g , ( 240   >> 1 )   , list_y - arrow_height, 16 , 0x00FFFF , true, false);
						if ( s_ItemListIndex < currentList_nbItems - 1)
							drawArrow(g , ( 240   >> 1 )   , list_y + LIST_visibleItemCount * list_vspace + arrow_height, 16 , 0x00FFFF , true, true);
					}
					y = list_y + list_vspace/2;
					//copied from down, by anup
					int selIndex = s_ItemListIndex - s_igpListDisplayItemStart;
					int sel_x = 27  - (3) ;
					int sel_h = list_vspace;
					int sel_y = list_y + list_vspace * selIndex;
					int sel_w = 240   - 2* sel_x;
					//draw item list
					for ( int i = s_igpListDisplayItemStart; i < s_igpListDisplayItemStart + LIST_visibleItemCount; i ++ )
					{
						int item = ValidLISTIdx[currentList][i];

						//draw item's icon
						g .drawImage( LIST_Images[ currentList ][ item ], 27  , y, Graphics.VCENTER | Graphics.LEFT );

						//draw item's title

						// coomented by anup drawString(LIST_Texts[ currentList ][ item ], _gBB, LIST_X + LIST_Images[ currentList ][ item ].getWidth() + LIST_ITEM_TEXT_OFFSET_X, y + LIST_ITEM_TEXT_OFFSET_Y, Graphics.VCENTER | Graphics.LEFT);
						//added by anup
						drawString(insertNewLine(getString(LIST_Texts[ currentList ][ item ]),sel_w-LIST_Images[ currentList ][ item ].getWidth() - 2 ), g , 27  + LIST_Images[ currentList ][ item ].getWidth() + 2 , y + 0 , Graphics.VCENTER | Graphics.LEFT);

						y += list_vspace;
					}

				//this is moved up
				//draw item selection
				/*	int selIndex = s_ItemListIndex - s_igpListDisplayItemStart;
					int sel_x = LIST_X - LIST_HSPACE;
					int sel_h = list_vspace;
					int sel_y = list_y + list_vspace * selIndex;
					int sel_w = IGP_SCRW - 2* sel_x; */

					g .setColor( listSelectionColor );
			
					g .drawRect( sel_x, sel_y,  sel_w, sel_h );
			

				}
//IGP_HAS_LIST
					if(bDrawPageImage)
						g .drawImage( PageImages[ CurrentPage ],  ( 240   >> 1 ) ,  image_y,  Graphics.HCENTER | Graphics.TOP);

					//draw title/description text
					if(bDrawPageText)
					{
						// coomented by anup drawString( pageTextId, _gBB, IGP_HALF_SCRW,  text_y,  text_anchor);
						if(pageTextId<=4)
						{
							drawString( insertNewLine(getString(pageTextId),240  -10), g , ( 240   >> 1 ) ,  text_y,  text_anchor);

						}
						else
							drawString( pageTextId, g , ( 240   >> 1 ) ,  text_y,  text_anchor);
					}

					if( bIsSplashPage && CurrentPage >= PAGE_DEMO_0 )
					{
						drawString(25 , g , 133 , 108 ,  Graphics.HCENTER | Graphics.VCENTER);
					}


				}



				if((System.currentTimeMillis() % 1000 ) > (1000  >> 1))
				{
					//DRAW FLASHING BOX
					 drawFlashingBox(g);
				}

				//DRAW 4/6 SIDE ARROWS]
				if( ValidPages <= 1 )
					break;

				int interval = Math.abs(((Math.abs((int)System.currentTimeMillis()) / 50 ) % 14 ) - 14 /2) - 14 /4  ;

				int img4 = IMG_4WHITE;
				int img6 = IMG_6WHITE;

				if (_redArrowLeft)
				{
					img4 =IMG_4BLUE;
					_arrowPressedCounter++;
				}
				g.drawImage(GlobalImages[img4], 2  + interval,  ( 320   >> 1 ) , Graphics.LEFT | Graphics.VCENTER);

				if (_redArrowRight)
				{
					img6 =IMG_6BLUE;
					_arrowPressedCounter++;
				}
				g.drawImage(GlobalImages[img6], 240   - 2  - interval,  ( 320   >> 1 ) , Graphics.RIGHT | Graphics.VCENTER);

				if (_arrowPressedCounter > 4)
				{
					_redArrowLeft = false;
					_redArrowRight = false;
					_arrowPressedCounter = 0;
				}

		break;



		}

	}


   public static void drawArrow(Graphics g, int x, int y, int height, int fillColor, boolean rotate, boolean flip)
   {
   		int iFlip = flip ? -1 : 1;

   		if(height % 2 == 0) height--;
   		g.setColor(0xffffff );
		if(rotate)
		{
   			 g .fillTriangle(  x ,   y ,   x - (height >> 1) ,   y + iFlip*(height >> 1) ,   x + (height >> 1) ,    y  + iFlip*(height >> 1) ); 
		}
		else
		{
   			 g .fillTriangle(  x ,   y ,   x - iFlip*(height >> 1) ,   y - (height >> 1) ,   x - iFlip*(height >> 1) ,    y + (height >> 1) ); 
		}

		g.setColor(fillColor);
		if(rotate)
		{
			 g .fillTriangle(  x ,   y + iFlip ,   x - (height >> 1) + 2 ,   y + iFlip* (height >> 1) - iFlip ,   x + (height >> 1) - 2 ,    y + iFlip* (height >> 1) - iFlip ); 
		}
		else
		{
			 g .fillTriangle(  x - iFlip ,   y ,   x - iFlip*(height >> 1) + iFlip ,   y - (height >> 1) + 2 ,   x - iFlip*(height >> 1) + iFlip ,    y + (height >> 1) - 2 ); 
		}
   }

   static int s_box_color;
   public static void drawFlashingBox(Graphics g)
   {
		if( bDisplayButton)
		{
			g.setColor( s_box_color );
			g.fillRect( box_x, box_y, box_w, box_h );
			drawString( iButtonStringId, g, ( 240   >> 1 ) , box_y +  (box_h >> 1) + -1 , Graphics.VCENTER | Graphics.HCENTER );
		}
   }

   public static void drawSoftkeys(Graphics g)
   {
	  //DRAW SOFTKEYS

	
		// ! IGP_INVERSE_SOFTKEYS_CONDITIONAL is set externally (GLLib)
		
			
				final boolean invertSoftkeys = true;
			
		

		if(invertSoftkeys)
		{
			if( (s_displaySoftKeys & DISPLAY_SELECT_SK) != 0 )
				g.drawImage( GlobalImages[ IMG_TICK ], 2 , (320   - 2) , Graphics.LEFT | Graphics.BOTTOM);
			if( (s_displaySoftKeys & DISPLAY_BACK_SK) != 0 )
				g.drawImage( GlobalImages[ IMG_BACK ], (240   - 2 ) , (320   - 2) , Graphics.RIGHT | Graphics.BOTTOM);
		}
		else
		{
			if( (s_displaySoftKeys & DISPLAY_BACK_SK) != 0 )
				g.drawImage( GlobalImages[ IMG_BACK ], 2 , (320   - 2) , Graphics.LEFT | Graphics.BOTTOM);
			if( (s_displaySoftKeys & DISPLAY_SELECT_SK) != 0 )
				g.drawImage( GlobalImages[ IMG_TICK ], (240   - 2 ) , (320   - 2) , Graphics.RIGHT | Graphics.BOTTOM);
		}
	//USE_SYSTEM_BAR
   }


	// midlet
	static MIDlet MidletInstance;
	//Platformrequest URL
	static String	URLPlatformRequest;




	// Global IGP variables
	static boolean IsAvailable;

	// State variables
	static int CurrentState;
	static int CurrentPage;
	static int CurrentPageIdx;
	// Loading variables
	static int CurrentLoadingStep;
	static int TotalLoadingSteps;

	static int		ValidPages;
	static int[]	ValidPagesIdx;



	// IGP data structures
	//Images
	static Image[]	GlobalImages;
	static Image[]	PageImages;


	// images lists
	static Image[][]	LIST_Images;
	// URLs lists
	static String[][]	LIST_URLs;// urls for each LIST item
	static int[][] ValidLISTIdx;
	static int[][]	LIST_Texts;
	static int[]	LIST_nbItems;

	//list specific
	static int currentList;
	static int currentList_nbItems;//refference
	//static int currentList_item_start;

	static int LIST_visibleItemCount;		//nb of visible items in the scrollable list

	static int s_igpListDisplayItemStart;	//first item of the list to display
	static int s_ItemListIndex;				//selected item of the list


	//URLs
	static String[]	PageURLs;// urls for buttons

	static int pageTextId;
	static boolean bDisplayButton;
	static byte s_displaySoftKeys;


	static boolean bIsListPage;

	static boolean bIsSplashPage;
	static int iButtonStringId;
	static int box_w;
	static int box_h;

	static int box_x;
	static int box_y;



	static int CurrentLanguage;


	static Image PageFROGLogo;



	static Image PagePromotionImage;
	
		static String s_textPt;
	

	static String StringLoading;


	static boolean bOrangeCatalog;

	static String s_urlOperator;

}
