

//---------MIDP type--------------------
// #define MIDP2
// #define NOKIA
// #define MIDP1

//---------SCREEN type------------------
// #define SCREEN_176X204
// #define SCREEN_128X140

/// --- MACRO DEFINATION COMMENT AREA ---
/// --- Edited by Delun Zhu @ gameloft SHA, 051220
// #define MIDP1			// suit 4 phone using J2ME's MIDP 1.0 & CLDP API, don't have the pallette in same font
// #define MIDP2			// suit 4 phone using J2ME's MIDP 2.0 & CLDP API
// #define NEED_COMMANDLISTENER //some midp1 phones need command listener to response softkey press event
// #define USE_PAK_RES        		//pak images and sprite to a package, it has three main pak, res.dat, bg,dat & sound.dat
// #define SMALL_JAR_SIZE     		//when use this, only 6 background images, 100 sudoku database
// #define CHOOSE_GRID			// the version have the chose grid style function.
// #define HAVE_SPLASH_ANIM		// game have the animation style splash
// #define DRAW_ABOUT_BG		// game show the background pic during show the credits(about).
// #define HAVE_SOUND			//have soundplay during playing game.
// #define HAVE_CHEATCODE		//U can cheat the gameplay if U define this.
// #define DRAW_CELL_FILLRECT 	//use fill rect to draw cell's bk
// #define SCROLL_PAGE 			// scroll the page 4 small screen cell phone during the baby time (drawBaby() or drawBabeMenu())
// #define SCROLL_TUTORIAL		// scroll the page 4 small screen cell phone during the tutorial mode
// #define NEED_DOUBLE_BUFFER	// use to big image buffer to draw the screen 4 some phone flash screen during display the graphics.
// #define HAVE_HINT_ICON		// some cell phone which screen bigger than 128x140, include 128x140, needs draw hint icon during gameplay.
// #define SOUND_TIME_CONTROL	// some cellphone can't update sound player's state with itself,
								// so we use a timer(number counter) to control sound play's states. i.e: Samsung E700

/// - GAMEPLAY MACRO DEFINATION COMMENT -
// #define HAVE_XMODE			//have the x-sudoku solution gameplay mode
// #define HAVE_SOLVER        		//have solver mode or not. may save memory and
// #define HAVE_PAPER_EFFECT		//have Congratrulation Show after U win a Sudoku solution
// 12.07 / 673
// #define HAVE_DRAFT_MODE    	//have draft mode or not. Can't be seen clearly in small screen phones.

// - DEBUG DEFINATION COMMENT -
// #define _SHOW_CONSOLE		// used for displaying the debug console during run on phone. U should modify details after paint() func.

// Added by Lu Ming, 2005.12.20. // for direct define of the number of background images.
//#define BG_NUM 12			// The number of background images used in this version.
//#define BABE_SPEAK_TEXT_APPEARS_ONCE	// Added by Lu Ming, 2005.12.21. // for show all words immediately with the babe speak dialog.
//#define KEY_UPDATE_COUNT 2  // Added by Lu Ming, 2005.01.10. // for key register problem, this is the count for certain frames, app will clear these key in the device key pool within these frames.
//#define GC_INTERVAL 30  // Added by Lu Ming, 2005.01.16. // for call System.gc() when game update, this value should be the in interval frames, and DO NOT set this value to ZERO!!!

// UI for softkey rule: some phones need reverse position of "OK" and "back"
//#define REVERSE_SOFTKEY_UI
//#define UNPAK_BG_IMAGES //didn't put all bg images to a single pak file
//#define CONCURRING_KEY_PRESSED // handle with concurring key problem.

// - Asprite Engine's parameter comment -
// public int _line_spacing = xx;		// this var decide the space pixels betweent two lines when display hint screen
								// in drawBaby() or drawBabeMenu() func. The number is -1(for big screen phone)
								// or -2(for small screen phone).ZDL


/// ~~~ END OF MACRO DEFINATION COMMENT ~~~

//default setting for all phones, if you need more, redefine it in your phone.
























































// 01.09 / 673
// Nokia_S40 --+-- Nokia_7210 (low memory, 63.8K limit, old S40 model, popular phone)
//             |   (without solver mode, 6 BGs)
//             +-- Nokia_6230 (new S40 model, up to 128K, powerful phone)
//             |   (full function version)
//             +-- Nokia_3510 (actually S30, 63.8K limit, especially small screen size & no left, right key)
//                 (without solver mode, without draft mode, 6 BGs)
// default: Nokia_7210





// S40 base model



// 02.07 / 673


// 02.13 / 673


//Akira.Y 	2005-12-26 17:54









///////////////////////////////////////////////
// SHARP SERIES GX10
///////////////////////////////////////////////

























	
	
  
	/// SCREEN SIZE IS SO BIG, USE BLOD FONT SIZE !DLZ
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	//#define HAVE_ALL_LANGUAGES
	
	
	
	
	
	
	
	
	
  


    
/////// category for font's size in different screen size
// Delun Zhu @ gameloft SHA, 051226



// 02.15 / 673

import java.util.*;
import java.io.*;

public class Sudoku
{


  //database count

  final static int k_iDatabaseCount = 500;

  final static int k_iXCount = 50;

  //question data
  public int m_iGrid[][];

  //grid id, every difficult grid will have an unique id. but in easy or normall mode, 
  // one id may map to a lot of grids. because we need to add random data to the original grid.
  public int m_iGridId = 0;
  // solution data
  public int m_iSolution[][];// the solved grid goes here
  //solution count
  public int m_iSolCount=0;
  public int m_iErrors = 0; // amount of uncorrected grid
  public int m_iBlank; //amout of blank grid
  public int m_iMode = DEF.LEVEL_MODE_NORMAL;
  public short m_iCurrentGrid[][];
  //indicate the cell whether repeat or not
  //public boolean m_isRepeatedGrid[][];

  ///use one bit to record the repeat info,1 stands for wrong cell
  public static int m_isRepeatedGrid[] = {0, 0, 0};
  //the list of cells repeated need flash...
  //two bytes present one cell, first byte: position, second: timer
  public byte m_bRepeat_list[] = new byte[162];
  public int m_iRepeat_list_count;
  //the list of cells need redraw
  //one byte present one cell: x*szie+y
  public byte m_bUpdate_list[] = new byte[81];
  public int m_iUpdate_list_count;
  


  //the grid size
  final static int k_iSize=9;
  //width and height of a group,
  final static byte k_bGroupW = 3;
  final static byte k_bGroupH = 3;
  //group count in per row and per column
  final static byte k_bGroupCountW = 3;
  final static byte k_bGroupCountH = 3;
  //the grid for tutorial
  /*
  final static int [][]k_tutorialGrid1 = {
      {0,0,5,8,3,7,2,0,0},
      {8,7,0,0,1,0,0,3,5},
      {3,6,0,2,0,5,4,8,7},
      {0,4,3,5,7,8,6,9,0},
      {7,8,9,6,0,0,5,2,3},
      {1,0,6,3,2,0,8,7,0},
      {6,3,0,7,0,0,1,5,9},
      {9,2,7,1,5,4,3,6,0},
      {0,1,0,9,0,0,7,0,2}
  };
  //the solution of the tutorial grid
  final static int [][]k_tutorialGrid2 = {
    {4,9,5,8,3,7,2,1,6},
    {8,7,2,4,1,6,9,3,5},
    {3,6,1,2,9,5,4,8,7},
    {2,4,3,5,7,8,6,9,1},
    {7,8,9,6,4,1,5,2,3},
    {1,5,6,3,2,9,8,7,4},
    {6,3,4,7,8,2,1,5,9},
    {9,2,7,1,5,4,3,6,8},
    {5,1,8,9,6,3,7,4,2}
};*/

/// allocate memory for member varibles;
// 02.15 / 673

  public Sudoku()

  {
    //release old resource
    m_iSolCount = 0;
    //Akira.Y 2006-1-18 14:59
        System.gc();
		

    m_iGrid = new int[k_iSize][k_iSize];
    m_iSolution = new int[k_iSize][k_iSize];
    m_iCurrentGrid = new short[k_iSize][k_iSize];
    m_isRepeatedGrid[0] = m_isRepeatedGrid[1] = m_isRepeatedGrid[2] = 0;//= new boolean[k_iSize][k_iSize];
    
  }

  ///set repeated info
  ///@param int x: x of the cell
  ///@param int y: y of the cell
  ///@param boolean tag: if the cell is wrong
  final static void setRepeatedTag(int x, int y, boolean tag)
  {
    int bit = y * 9 + x;
    if (tag)
      m_isRepeatedGrid[bit / 32] |= (1 <<(bit % 32));
    else
      m_isRepeatedGrid[bit / 32] &= ~(1 <<(bit % 32));
  }
  
  ///read a data matrix from the database
  ///@param int index: the matrix's index
  ///@param int type: the db's index
  ///@return int[][]: if the cell is wrong
  short [][]readMatrix(int index, int dbtype)
  {
		//Akira.Y 2006-1-17 16:43//#ifndef KEEP_SUDOKU_DB_MEMORY_RESIDENT
    	InputStream in_files;
    
    
    try
    {
      short [][]re = new short[k_iSize][k_iSize];
      int count = k_iSize*k_iSize;
      if (dbtype == 1) //"X"
      {
      	//Akira.Y 2006-1-17 16:40//#ifndef KEEP_SUDOKU_DB_MEMORY_RESIDENT
        	in_files = this.getClass().getResourceAsStream("/x.dat");
        
      }
      else
      {
      	//Akira.Y 2006-1-17 16:40//#ifndef KEEP_SUDOKU_DB_MEMORY_RESIDENT
        	in_files = this.getClass().getResourceAsStream("/sol9.dat");
        
      }
      
      
//Akira.Y 2006-1-17 16:48
      byte [] data = new byte[count];
      in_files.skip(index*count);	    	      
      
//Akira.Y 2006-1-16 17:36
	    in_files.read(data, 0, count);

	    in_files.close();
//#ifndef KEEP_SUDOKU_DB_MEMORY_RESIDENT

      for (int j = 0; j < k_iSize; j++) 
      {
        for (int i = 0; i < k_iSize; i++) 
        {
        	//Akira.Y 2006-1-17 16:58//#ifndef KEEP_SUDOKU_DB_MEMORY_RESIDENT/
            re[i][j] = data[j*k_iSize+i];
          
        }
      }
      return re;
    }
    catch (Exception e)
    {}
    return null;
  }

  final static int k_iSwitchCount = 6*6*6*6;
/// this function generate a grid in defined type;
/// it will set the question, solution data and m_iError, m_iBlank
/// @param mode The game mode: easy, normal, difficult,
///             profession or tutorial
/// @return void
/// @note: we use (6**4)*500 = 648000 as the maxinum id of sudoku
///        one 6 present switch between row groups, 
///        one 6 present switch between column groups
///        one 6 present choose any one row group or column group
///        ont 6 present switch between row lines or column lines in the choosed group
  void generate(int mode)
  {
    m_iMode = mode;
    m_iErrors = m_iBlank = 81;
    if(mode >= DEF.LEVEL_MODE_SOLVER)
    {
      return;
    }
    m_iGridId = 0;    
    try
    {
      //calculate the no. of question we need. 
      int num;

      if (mode == DEF.LEVEL_MODE_SPECIAL)
      {
        num = cGame.getRandomInt(k_iXCount);
        m_iGridId = k_iSwitchCount*k_iDatabaseCount+num;
      }
      else

      if(mode == DEF.LEVEL_MODE_TOTURIAL)
      {
        num = k_iDatabaseCount;
      }
      else
      {
        m_iGridId = cGame.getRandomInt(k_iSwitchCount*k_iDatabaseCount);
        num = m_iGridId%k_iDatabaseCount;
      }
      
      //load a question from the database
      int i, j;
      short [][]temp = readMatrix(num, mode==DEF.LEVEL_MODE_SPECIAL?1:0);
      
      //decoding to question and solution grid
      //if the first bit of cell's value is 1, then it's empty cell
      m_iErrors = 0;
      m_iSolCount = 1;
      for (j = 0; j < k_iSize; j++) 
      {
        for (i = 0; i < k_iSize; i++) 
        {
        	m_iSolution[i][j] = temp[i][j];
          if (m_iSolution[i][j] >= 0)
          { //filled cell
            m_iGrid[i][j] = m_iSolution[i][j];
          }
          else
          { //empty cell
            m_iSolution[i][j] &= 0x1f;
            m_iGrid[i][j] = 0;
            m_iErrors++;
          }
        }
      }
      if (mode != DEF.LEVEL_MODE_SPECIAL && mode != DEF.LEVEL_MODE_TOTURIAL)
      {
        switchGrid();
      }
      
      for (j = 0; j < k_iSize; j++) 
      {
        for (i = 0; i < k_iSize; i++) 
        {
          m_iCurrentGrid[i][j] = (byte)m_iGrid[i][j];          
        }
      }
      

      if (m_iMode == DEF.LEVEL_MODE_EASY || m_iMode == DEF.LEVEL_MODE_NORMAL)
      {
        //ADD SOME MORE DATA TO GRID to get easier mode
        int tsize = k_iSize*k_iSize;
        int add = ((m_iMode == DEF.LEVEL_MODE_NORMAL)?33:43)-(tsize-m_iErrors)-cGame.getRandomInt(3);
        for (i=0; i<add; i++)
        {
          while(tsize>0)
          {
            j = cGame.getRandomInt(tsize);
            if (m_iGrid[j / k_iSize][j % k_iSize] == 0)
            {
              m_iGrid[j / k_iSize][j % k_iSize] = m_iSolution[j / k_iSize][j %
                  k_iSize];
              m_iCurrentGrid[j / k_iSize][j % k_iSize] = (byte)m_iGrid[j / k_iSize][j % k_iSize];
              break;
            }
          }
        }
        m_iErrors-=add;
      }
      m_iBlank = m_iErrors;
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
  }

    final static int k_iChangeCount = 6;
/// exchange the whole grid randomly to get a new sudoku;
/// exchanges may happened between rows, columns, row groups, column groups
/// @return void
  protected void switchGrid()
  {
    int base=m_iGridId/k_iDatabaseCount;
    int a = base%k_iChangeCount;
    
    //switch between row groups
    switchRowGroup(0, a%3);
    if (a/2 == 1)
      switchRowGroup(1, 2);
    
    //switch between column groups
    base /= k_iChangeCount; 
    a = base%k_iChangeCount;
    switchColGroup(0, a%3);
    if (a/3 == 1)
      switchColGroup(1, 2);
    
    //choose a row group or column group
    base /= k_iChangeCount; 
    a = base%k_iChangeCount;    
    boolean bRow = a<3;
    int rowGroup = a<3?a:a-3;
        
    base /= k_iChangeCount; 
    a = base%k_iChangeCount;    
    
    if (bRow)
    {
      switchRow(rowGroup*3+0, rowGroup*3+a%3);
      if (a/3 == 1)
        switchRow(rowGroup*3+1, rowGroup*3+2);
    }
    else
    {
      switchCol(rowGroup*3+0, rowGroup*3+a%3);
      if (a/3 == 1)
        switchCol(rowGroup*3+1, rowGroup*3+2);
    }    
  }

/// exchange two rows;
/// @param la the first row index
/// @param lb the second row index
  protected void switchRow(int la, int lb)
  {
    if (la == lb) return;

    //exchange question
    int [] row = m_iGrid[la];
    m_iGrid[la] = m_iGrid[lb];
    m_iGrid[lb] = row;

    //exchange solution
    row = m_iSolution[la];
    m_iSolution[la] = m_iSolution[lb];
    m_iSolution[lb] = row;
  }

/// exchange two columns;
/// @param la the first row index
/// @param lb the second row index
  protected void switchCol(int ca, int cb)
  {
    if (ca == cb) return;
    int temp;
    for (int i=0; i<k_iSize; i++)
    {
      temp = m_iGrid[i][ca];
      m_iGrid[i][ca] = m_iGrid[i][cb];
      m_iGrid[i][cb] = temp;

      //exchange solution
      temp = m_iSolution[i][ca];
      m_iSolution[i][ca] = m_iSolution[i][cb];
      m_iSolution[i][cb] = temp;
    }
  }

/// exchange two row of groups;
/// @param la the first group row index
/// @param lb the second group row index
  protected void switchRowGroup(int la, int lb)
  {
    if (la == lb) return;
    for (int i=0; i<k_bGroupH; i++)
    {
      switchRow(la*k_bGroupCountW+i, lb*k_bGroupCountW+i);
    }
  }

/// exchange two column of groups;
/// @param la the first group column index
/// @param lb the second group column index
  protected void switchColGroup(int ca, int cb)
  {
    if (ca == cb) return;
    for (int i=0; i<k_bGroupW; i++)
    {
      switchCol(ca*k_bGroupCountH+i, cb*k_bGroupCountH+i);
    }
  }

/// get the valid numbers can filled in the cell.
/// @param x the cell's x position
/// @param y the cell's y position
/// @return The array of number valid or not. It means if re[6] = 1, then 6 is valid for this grid
  public byte [] getValid(int x, int y)
  {
    byte [] valid = new byte[10];
    int i;
    for (i=0; i<10; i++)
    {
      valid[i] = 1;
    }
    int groupi = (x/k_bGroupW)*k_bGroupW, groupj = (y/k_bGroupH)*k_bGroupH;
    for (i=0; i<k_iSize; i++)
    {
      if (m_iCurrentGrid[i][y]>0 && i!=x)
      {
        valid[m_iCurrentGrid[i][y]] = 0;
      }
      if (m_iCurrentGrid[x][i]>0 && i!=y)
      {
        valid[m_iCurrentGrid[x][i]] = 0;
      }
      if (m_iCurrentGrid[groupi+i%k_bGroupW][groupj+i/k_bGroupW]>0 && 
        groupi+i%k_bGroupW!=x && groupj+i/k_bGroupW != y)
      {
        valid[m_iCurrentGrid[groupi+i%k_bGroupW][groupj+i/k_bGroupW]] = 0;
      }


      if (m_iMode == DEF.LEVEL_MODE_SPECIAL) //FOR X MODE
      {
        if (m_iCurrentGrid[i][i]>0 && x == y && i != x)
        {
          valid[m_iCurrentGrid[i][i]] = 0;
        }
        else if (m_iCurrentGrid[k_iSize-1-i][i]>0 && x == k_iSize-1-y && x != k_iSize-1-i)
        {
          valid[m_iCurrentGrid[k_iSize-1-i][i]] = 0;
        }
      }


    }
    valid[0] = 1;
    return valid;
  }

  final static int [] s_iTenTimes = {1, 10, 100, 1000};

  public void setSplitGrid(int x, int y, int value, int order)
  {
      int num = getSplitNum(x,y,order);
      if(m_iCurrentGrid[x][y] > 0)
        m_iBlank ++;
      if( num != value)
      {
        m_iCurrentGrid[x][y] += num * s_iTenTimes[order];
      }
      m_iCurrentGrid[x][y] -= value * s_iTenTimes[order];
  }

  int getSplitNum(int x, int y, int order)
    {
      int num = -m_iCurrentGrid[x][y];
      if(order > 0)
      {
        num /= s_iTenTimes[order];
      }
      return ( num % 10);
    }

/// set the draft value of the cell
/// @param x The cell's x position
/// @param y The cell's y position
/// @param value The value be set
/// @param up It's first number or second number in draft mode
/// @return


///input number true or false 
static boolean m_bInputFalse;

/// write a value to the grid. it will do judgement that if this cell repeat with
/// other cells. and add the repeated cell to blink list or update list.
/// @param x The cell's x position
/// @param y The cell's y position
/// @param value The value be set
/// @return
  public void SetGrid(int x, int y, int value)
  {
    //if the cell was clear, only need to update this cell
    if(value == 0 && (m_iCurrentGrid[x][y] < 0 || m_iGrid[x][y] < 0))
    {
      m_iCurrentGrid[x][y] = 0;
      m_iGrid[x][y] = 0;
      m_bUpdate_list [0] = (byte)(y*k_iSize+x);
      m_iUpdate_list_count =1;
      return;
    }

    if (value == m_iCurrentGrid[x][y])
      return;
    if(!(value >0 && m_iCurrentGrid[x][y]>0))
    {
      if (value == m_iSolution[x][y])
        m_iErrors--;
      else if (m_iCurrentGrid[x][y] == m_iSolution[x][y])
        m_iErrors++;
      if(value > 0 && m_iCurrentGrid[x][y] <= 0)
        m_iBlank --;
      else if(value <= 0 && m_iCurrentGrid[x][y] > 0)
        m_iBlank ++;
    }
    //if the we write a value to a filled cell, we need clear it first then fill it
    else
    {
      SetGrid(x, y, 0);
      SetGrid(x, y, value);
      return;
    }
    boolean bRemove = value==0;


    int i;
    int px, py;

    //the check value would not be 0;
    int checkvalue = value==0?m_iCurrentGrid[x][y]:value;
    //do this, then don't need to take care the grid itself
    if (value == 0)
      m_iCurrentGrid[x][y] = 0;
    boolean isNeedBlink = false;

    //find all the repeat grids
    for (i = 0; i < k_iSize; i++)
    {
        px = 3 * (x / 3) + i % 3;
        py = 3 * (y / 3) + i / 3;

      //finding in row
      if (m_iCurrentGrid[i][y] == checkvalue)
      {
        updateRepeatList(i, y, bRemove);
        isNeedBlink = true;
      }
      //finding in column
      if (m_iCurrentGrid[x][i] == checkvalue)
      {
        updateRepeatList(x, i, bRemove);
        isNeedBlink = true;
      }
      if (m_iCurrentGrid[px][py] == checkvalue && px != x &&
               py != y)
      {
        updateRepeatList(px, py, bRemove);
        isNeedBlink = true;
      }

      //for x mode
      if (m_iMode == DEF.LEVEL_MODE_SPECIAL)
      {
        if(x == y)
        {

          if (m_iCurrentGrid[i][i] == checkvalue)
          {
            updateRepeatList(i, i, bRemove);
            isNeedBlink = true;
          }
        }
        if(k_iSize-1-x == y)
        {
          if (m_iCurrentGrid[k_iSize - 1 - i][i] == checkvalue)
          {
            updateRepeatList(k_iSize - 1 - i, i, bRemove);
          isNeedBlink = true;
        }

        }
      }

    }

    m_iCurrentGrid[x][y] = (byte)value;
    if (isNeedBlink && !bRemove)
    {
      m_bInputFalse = true;
      add2BlinkList(x, y);
      setRepeatedTag(x, y, true);
    }
    else
    {
      m_bUpdate_list[m_iUpdate_list_count++] = (byte)(y*k_iSize+x);
      m_bInputFalse = false;
    }
    if (bRemove)
    {
      setRepeatedTag(x, y, false);
      //remove from blink list
      for (i=0; i<m_iRepeat_list_count; i++)
      {
        if (y * k_iSize + x == m_bRepeat_list[i * 2])
        {
          removeBlink(i);
        }
      }
    }
  }


/// given a repeat filled cell then update the repead list.
/// @param x This cell's x position
/// @param y This cell's y position
/// @param bRemove To identicate the origin cell that this cell is repeat with is removed or added.
/// @return
  protected void updateRepeatList(int x, int y, boolean bRemove)
  {

    //if need remove, check this value is repeat with other grids
    int px, py;
    int i;

    if (bRemove)
    {
      //if the data in this cell is not repeat any more, remove it from repeat list timer
      for (i = 0; i < k_iSize; i++)
      {
        //if there are other cells repeat with this cell, then break
        px = 3 * (x / 3) + i % 3;
        py = 3 * (y / 3) + i / 3;
        if (m_iCurrentGrid[i][y] == m_iCurrentGrid[x][y] && x != i)
          break;
        else if (m_iCurrentGrid[x][i] == m_iCurrentGrid[x][y] && y != i)
          break;
        else if (m_iCurrentGrid[px][py] == m_iCurrentGrid[x][y] && px != x &&
            py != y)
          break;

        else if (m_iMode == DEF.LEVEL_MODE_SPECIAL)
        {
          if(x == y && m_iCurrentGrid[i][i] == m_iCurrentGrid[x][y] && x != i)break;
          if(x + y == k_iSize - 1 && m_iCurrentGrid[i][k_iSize - 1 - i] == m_iCurrentGrid[x][y] && x != i)break;
        }

      }
      if (i == k_iSize) //this cell is not repeated anymore
        setRepeatedTag(x, y, false);

      //add to update list
      m_bUpdate_list[m_iUpdate_list_count++] = (byte)(y*k_iSize+x);

      //remove from blink list
      for (i=0; i<m_iRepeat_list_count; i++)
      {
        if (y * k_iSize + x == m_bRepeat_list[i * 2])
        {
          removeBlink(i);
        }
      }
    }
    else
    {
        setRepeatedTag(x, y, true);
        //need blink
        add2BlinkList(x, y);
    }
  }

/// add the cell to the list that need blink.
/// @param x This cell's x position
/// @param y This cell's y position
/// @return
  void add2BlinkList(int x, int y)
  {
    if (m_iRepeat_list_count <= 81)
    {
      int value = y * k_iSize + x;
      for (int i=0; i<m_iRepeat_list_count; i++)
      {
        if (m_bRepeat_list[i * 2] == value)
        {
          m_bRepeat_list[i * 2 + 1] = cGame.WARNING_FRAME;
          return;
        }
      }
      m_bRepeat_list[m_iRepeat_list_count * 2] = (byte) (value);
      m_bRepeat_list[m_iRepeat_list_count * 2 + 1] = cGame.WARNING_FRAME;
      m_iRepeat_list_count++;
    }
  }

/// Remove a blink.
/// @param index The blink's index
  void removeBlink(int index)
  {
    m_iRepeat_list_count--;
    m_bRepeat_list[index * 2] = m_bRepeat_list[m_iRepeat_list_count * 2];
    m_bRepeat_list[index * 2 + 1] = m_bRepeat_list[m_iRepeat_list_count * 2 + 1];
  }


/// clear current puzzle's data.
  public void releaseData()
  {
    if (m_iGrid != null)
    {
      for (int i=0; i<k_iSize; i++)
      {
        for (int j=0; j<k_iSize; j++)
        {
          
          m_iSolution[i][j] = 0;
          m_iGrid[i][j] = 0;
          m_iCurrentGrid[i][j] = 0;
        }
      }
    }
    m_isRepeatedGrid[0] = m_isRepeatedGrid[1] = m_isRepeatedGrid[2] = 0;
    m_iUpdate_list_count = 0;
    m_iRepeat_list_count = 0;
    m_iErrors = 0;
    m_iBlank = 0;
  }
  
  


//end SOLVER_ALGORITHM_ARRAY

  ////////////////////////////solver//////////////////////////////////////////
//NOTE: to solve a 9x9 sudoku, it need a lost memory for the dancing links data stucture
//
  // statistics
  protected int m_iDequeRemovals;

// main 2D doubly-linked structure
  private Header root = new Header();

// exhaustive list of columns
  private Vector columns = new Vector();

// list of non-empty rows
  private Vector rows = new Vector();

// solution solStack, and pointers to browse it
  private Vector solStack = new Vector();
  private int stackPos, iterStack;
  private Node iterRow, iterCol;

// Search() temporary variables (not local to reduce recursion load)
  private Header column;
  private Node row;
  private boolean more;

  // private classes
  private class Node {
    public Node left = this, right = this, up = this, down = this;
    public Header head;
    public void unplug() {
      left = right = up = down = head = null;
    }
  };
  private class Header
      extends Node {
    public int size = 0;
    public int id = 0;
    public Header() {
      head = this;
    }
  };

/// initialize a dancing links data structure.
  void initialize()
  {    
    clearSolver();
    if (DEF.DEBUG)
      System.out.println("before "+Runtime.getRuntime().freeMemory() );
    int index;
    // define columns for individual cells
      // ("a cell contains 1 and only 1 digit")
    for (int R = 0; R < k_iSize; R++) {
      for (int C = 0; C < k_iSize; C++) {
        addColumn(R*k_iSize+C, true);
      }
    }

    //define columns for the 3x3 group's restrict
    for (int d=0; d<k_iSize; d++)
    {
      for (int j=0; j<k_iSize; j++)
      {
        index = 81+(d*k_iSize+j)*3;
        addColumn(index, true);
        addColumn(index+1, true);
        addColumn(index+2, true);
      }
    }

    // create rows ("there could be any digit in any empty cell")
    for (int R = 0; R < k_iSize; R++) {
      for (int C = 0; C < k_iSize; C++) {
        for (int d = 0; d < k_iSize; d++) {
          row = null;
          index = d*k_iSize;
          setColumn(R*k_iSize+C);
          setColumn(81+(index+R)*3);
          setColumn(81+(index+C)*3+1);
          setColumn(81+(index+((R / k_bGroupH) * k_bGroupCountW + (C / k_bGroupW)))*3+2);
        }
      }
    }    
    if (DEF.DEBUG)
      System.out.println("end "+Runtime.getRuntime().freeMemory() );
  }  
  
  /// clear memory used for solver mode. 
  void clearSolver()
  {    
    Header h;
    Node r;
    int size, i;
    size = columns.size();
    for (i=0; i<size; i++)
    {
      h = (Header) columns.elementAt(i);
      h.unplug();
    }
    
    size = rows.size();
    for (i = 0; i < size; i++) {
      r = (Node) rows.elementAt(i);
      r.left.right = null;
      do {
        Node n = r.right;
        r.unplug();
        r = n;
      }
      while (r != null);
    }
    
    iterCol = null;
    iterRow = null;
    row = null;
    column = null;
    root.unplug();
    root = new Header();
    
    columns.removeAllElements();
    rows.removeAllElements();
    solStack.removeAllElements();
    
    if (DEF.DEBUG)    
      System.out.println("cleard "+Runtime.getRuntime().freeMemory() );
  }

/// set a cell's value and init the dancing links data.
/// @param R The cell's row position
/// @param C The cell's column position
/// @param d The value be set
  public void setCell2(int R, int C, int d)
  {
    int index = R * k_iSize * k_iSize + C * k_iSize;
    m_iGrid[R][C] = d;
    for (int i = 0; i < k_iSize; i++) {
      if (d <= 0 || i == d-1) {
        enableRow(index+i);
      }
      else {
        disableRow(index+i);
      }
    }
  }

/// set restricts of the dancing links data structure.
/// @param grid The question data we want to set
  public void setGrid(short grid[][])
  {
    for (int R = 0; R < k_iSize; R++) {
      for (int C = 0; C < k_iSize; C++) {
        if (grid[R][C] != m_iGrid[R][C]) {
          setCell2(R, C, grid[R][C]);
        }
        m_iSolution[R][C]
            = 0;
      }
    }
    m_iSolCount = 0;
  }

/// get the solution data from stack
  protected boolean record()
  {
    if (++m_iSolCount > 1)return false;
    for (int s = getSol(); s != -1; s = getSol())
    {
      int R = -1, C = -1;
      for (; s != -1; s = getSol())
      {
        if (s < 81)
          continue;
        if ( (s - 81) % 3 == 0)
        {
          R = ( (s - 81) / 3) % 9;
        }
        if ( (s - 81) % 3 == 1)
        {
          C = ( (s - 81) / 3) % 9;
        }
        if (R >= 0 && C >= 0) m_iSolution[R][C] = ( (s - 81) / 3) / 9 + 1;
      }
    }
    return true;
  }


/// get the solution data from stack
  public void addColumn(int id, boolean mandatory)
   {
     Header col = new Header();
     col.id = id;
     col.size = 0;
     if (mandatory) {
       col.right = root;
       col.left = root.left;
       root.left.right = col;
       root.left = col;
     }
     columns.addElement(col);
   }

/// add row node for the column
/// @param num The index of the column need be set
  public void setColumn(int num)
  {
    Header header = (Header) columns.elementAt(num);
    Node node = new Node();
    if (row == null) {
      row = node;
      rows.addElement(node);
    }
    else {
      node.left = row;
      node.right = row.right;
      row.right.left = node;
      row.right = node;
    }
    node.head = header;
    node.up = header;
    node.down = header.down;
    header.down.up = node;
    header.down = node;
    header.size++;
  }

/// disable row nodes
/// @param num The index of row need to be disabled
  public void disableRow(int num)
  {
    Node i = (Node) rows.elementAt(num);
    if (i.up == i)return; // already disabled
    Node j = i;
    do {
      j.up.down = j.down;
      j.down.up = j.up;
      j.down = j.up = j;
      j.head.size--;
      j = j.right;
    }
    while (i != j);
  }

/// enable row nodes
/// @param num The index of row need to be enabled
  public void enableRow(int num)
  {
    Node i = (Node) rows.elementAt(num);
    if (i.up != i)return; // already enabled
    Node j = i;
    do {
      j.up = j.head;
      j.down = j.head.down;
      j.up.down = j;
      j.down.up = j;
      j.head.size++;
      j = j.right;
    }
    while (i != j);
  }

  int m_iSolveStep = 0;
/// solve the question in m_iGrid
/// @param
  public boolean solve()
  {
    switch (m_iSolveStep)
    {
      case 0:
        initialize();
        m_iSolveStep++;
        return false;
      case 1:
        setGrid(m_iCurrentGrid);
        m_iSolveStep++;
        return false;
      case 2:
        {
          if (m_iSolCount == 1)
          {
            m_iSolveStep++;
            break;
          }
          more = true;
          solStack.setSize(columns.size());
          stackPos = 0;
          iterStack = 0;
          m_iDequeRemovals = 0;
          m_iSolCount = 0;
          iterCol = null;
          iterRow = null;
          column = null;
          search();
          if(m_iSolCount == 0 
             || m_iMode == DEF.LEVEL_MODE_CUSTOM
          )
          {
            for (int i = 0; i < k_iSize; i++)
            {
              for (int j = 0; j < k_iSize; j++)
              {
                m_iGrid[i][j] = 0;
              }
            }
          }
          if(m_iMode == DEF.LEVEL_MODE_CUSTOM && m_iSolCount == 1)
          {
            for (int i=0; i<k_iSize; i++)
            {
              for (int j=0; j<k_iSize; j++)
              {
                m_iGrid[i][j] = m_iCurrentGrid[i][j];
              }
            }
            m_iErrors = m_iBlank;
          }
          else
           if (m_iMode == DEF.LEVEL_MODE_SOLVER && m_iSolCount > 0)
          {
            for (int i=0; i<k_iSize; i++)
            {
              for (int j=0; j<k_iSize; j++)
              {
                m_iCurrentGrid[i][j] = (byte)m_iSolution[i][j];
              }
            }
          }
          m_iSolveStep++;
          return false;
        }

      case 3:

        {
          //delete columns and rows
          clearSolver();
          //Akira.Y 2006-1-18 14:59
             System.gc();
					
          m_iSolveStep++;
          return true;
        }

    }
    return true;
  }

/// get next solutioned cell index
/// @param
  protected int getSol()
  {
    if (iterCol != null) {
      int ret = iterCol.head.id;
      iterCol = iterCol.right;
      if (iterCol == iterRow) iterCol = null;
      return ret;
    }
    if (++iterStack < stackPos) {
      iterCol = iterRow = (Node) solStack.elementAt(iterStack);
    }
    return -1;
  }

  int timer=0;


/// solve process
/// @param
  private void search()
  {
    timer ++;
    if (root.right == root) {
      iterStack = 0;
      iterCol = iterRow = (stackPos > 0 ? (Node) solStack.elementAt(0) : null);
      more = record();
      return;
    }
    choose();
    cover(column);
    for (row = column.down; row != column; row = row.down) {
      for (Node i = row.right; i != row; i = i.right) {
        cover(i.head);
      }
      solStack.setElementAt(row, stackPos++);
      search();
       row = (Node) solStack.elementAt(--stackPos);
      column = row.head;
      for (Node i = row.left; i != row; i = i.left) {
        uncover(i.head);
      }
      if (!more)break;
    }
    uncover(column);
  }

///set a colomn as searched
///@param col The colomn need be set
  private void cover(Header col)
  {
    col.right.left = col.left;
    col.left.right = col.right;
    m_iDequeRemovals++;
    for (Node i = col.down; i != col; i = i.down) {
      for (Node j = i.right; j != i; j = j.right) {
        j.down.up = j.up;
        j.up.down = j.down;
        j.head.size--;
        m_iDequeRemovals++;
      }
    }
  }

///recover a colomn with searched tag
///@param col The colomn need be recovered
  private void uncover(Header col)
  {
    for (Node i = col.up; i != col; i = i.up) {
      for (Node j = i.left; j != i; j = j.left) {
        j.head.size++;
        j.down.up = j;
        j.up.down = j;
      }
    }
    col.right.left = col;
    col.left.right = col;
  }

///choose a colomn with shorted node lists
  private void choose()
  {
    int best = Integer.MAX_VALUE;
    for (Header i = (Header) root.right; i != root; i = (Header) i.right) {
      if (i.size < best) {
        column = i;
        best = i.size;
      }
    }
  }
//not SOLVER_ALGORITHM_ARRAY
/////////////////////////////////End solve//////////////////////////////////////
//HAVE_SOLVER

////////////////calculate the next easiest solvable cell in the grid////////////
  
  byte m_bEasier = -1; //the easiest solvable cell's position
  byte m_bShort; //the shortest clue's number
  ///calculate every empty cells's clue
  public void getAllClues()
  {
  //array to install clue number of every cell  
    byte m_bClues[][] = new byte[9][9];
    m_bEasier = -1;
    m_bShort = 90;
    int i, j;
    for (i=0; i<k_iSize; i++)
    {
      for (j=0; j<k_iSize; j++)
      {
        if (m_iCurrentGrid[i][j] == 0)
        {
          m_bClues[i][j] = getCellClue(i, j);
          if (m_bClues[i][j] < m_bShort)
          {
            m_bShort = m_bClues[i][j];
            m_bEasier = (byte)(i*9+j);
          }
        }
        else
        {
          m_bClues[i][j] = 90;
        }
      }
    }
  }

  
  ///get the cell's clue
  private byte getCellClue(int x, int y)
  {
    byte clue = 0;
    byte [] valid = new byte[10];
    int i;
    int a=0,b=0,c=0;
    int groupi = (x/k_bGroupW)*k_bGroupW, groupj = (y/k_bGroupH)*k_bGroupH;
    for (i=0; i<k_iSize; i++)
    {
      if (m_iCurrentGrid[i][y]>0 && i!=x && !isRepeat(i, y))
      {
        valid[m_iCurrentGrid[i][y]] = 1;
        a++;
      }
      if (m_iCurrentGrid[x][i]>0 && i!=y && !isRepeat(x, i))
      {
        valid[m_iCurrentGrid[x][i]] = 1;
        b++;
      }
      if (m_iCurrentGrid[groupi+i%k_bGroupW][groupj+i/k_bGroupW]>0 && 
        (groupi+i%k_bGroupW!=x || groupj+i/k_bGroupW != y) 
        && !isRepeat(groupi+i%k_bGroupW, groupj+i/k_bGroupW))
      {
        valid[m_iCurrentGrid[groupi+i%k_bGroupW][groupj+i/k_bGroupW]] = 1;
        c++;
      }


      if (m_iMode == DEF.LEVEL_MODE_SPECIAL) //FOR X MODE
      {
        if ((m_iCurrentGrid[i][i]>0 && x == y && i != x) && !isRepeat(i, i))
        {
          valid[m_iCurrentGrid[i][i]] = 1;
        }
        else if (m_iCurrentGrid[k_iSize-1-i][i]>0 && x == k_iSize-1-y && x != k_iSize-1-i && !isRepeat(k_iSize-1-i, i))
        {
          valid[m_iCurrentGrid[k_iSize-1-i][i]] = 1;
        }
      }

    }
    clue = 9;
    for (i=1; i<10; i++)
    {
      if (valid[i] == 0)
        clue+=9;
    }
    //if a row or column or group have more numbers, this cell have higher priority
    if (a<b) a = b;
    if (a<c) a = c;
    clue -= a;
    return clue;
  }
  
  boolean isRepeat(int x, int y)
  {
    int bit = y * 9 + x;
    return ((m_isRepeatedGrid[bit / 32]& (1 <<(bit % 32))) != 0 && m_iGrid[x][y]==0);
  }
// 02.15 / 673

}

