/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CUnit {
    public static final byte TYPE_SOLDIER = 0;
    public static final byte TYPE_MEDIC = 1;
    public static final byte TYPE_MECHANIC = 2;
    public static final byte TYPE_SNIPER = 3;
    public static final byte TYPE_GUERRILLA = 4;
    public static final byte TYPE_VIP = 5;
    public static final byte TYPE_MORTAR = 6;
    public static final byte TYPE_CANNON = 7;
    public static final byte TYPE_ANTI_AIR = 8;
    public static final byte TYPE_TANK_LIGHT = 9;
    public static final byte TYPE_TANK_MEDIUM = 10;
    public static final byte TYPE_TANK_HARD = 11;
    public static final byte TYPE_FIGHTER = 12;
    public static final byte TYPE_BOMBER = 13;
    public static final byte types = 14;
    public byte type = (byte)-1;
    private static final byte[] paramTable = new byte[]{15, 35, 1, 3, -10, 30, 1, 3, -10, 30, 1, 3, 25, 30, 2, 3, 60, 40, 1, 3, 0, 40, 1, 3, 35, 50, 2, 2, 50, 70, 3, 2, 50, 55, 2, 3, 45, 90, 2, 4, 65, 105, 3, 3, 80, 120, 3, 3, 50, 65, 1, 5, 120, 55, 1, 4};
    private static final byte[] attackIntensity = new byte[]{100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 0, 0, 100, 100, 100, 100, 100, 100, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 100, 100, 90, 80, 70, 60, 50, 50, 100, 100, 100, 100, 100, 100, 50, 50, 0, 0, 0, 0, 0, 0, 25, 25, 25, 25, 25, 25, 50, 50, 100, 100, 100, 100, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 100, 100, 100, 100, 75, 100, 75, 75, 75, 75, 75, 75, 0, 0, 75, 75, 75, 75, 50, 75, 100, 100, 100, 100, 100, 100, 0, 0, 50, 50, 50, 50, 25, 50, 50, 50, 50, 50, 50, 50, 120, 120, 100, 100, 100, 100, 75, 100, 50, 50, 50, 50, 50, 50, 0, 0, 75, 75, 75, 75, 75, 75, 100, 100, 100, 100, 100, 100, 50, 50, 100, 100, 100, 100, 75, 100, 100, 100, 100, 100, 100, 100, 50, 50, 100, 100, 100, 100, 50, 100, 50, 50, 50, 50, 50, 50, 100, 100, 100, 100, 100, 100, 50, 100, 100, 100, 100, 100, 100, 100, 15, 15};
    private static final byte[] movement = new byte[]{2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 3, 3, 3, 3, 2, 2, 120, 120, 120, 120, 120, 120, 1, 1, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 1, 2, 2, 2, 3, 4, 120, 120, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1};
    public byte ATTACK = 0;
    public byte DEFENCE = 0;
    public byte DISTANCE = 0;
    public byte SPEED = 0;
    public static final byte params = 4;
    public byte maxCount = 0;
    public byte count = 0;
    public int health = 0;
    public byte landDef = 0;
    public byte unitsDown = 0;
    public boolean attacked = false;
    public boolean moveMade = false;
    public byte xMap = 0;
    public byte yMap = 0;
    public int xScr = 0;
    public int yScr = 0;
    public int dx = 0;
    public int dy = 0;
    private byte vx = 0;
    private byte vy = 0;
    public byte tx = 0;
    public byte ty = 0;
    public byte nx = 0;
    public byte ny = 0;
    private byte moveCount = 0;
    private int[] move = new int[15];
    private byte moveTact = 0;
    private byte company = 0;
    private static final byte imgCount = 56;
    private static Image[] imgUnit = new Image[112];
    public static Image imgMoveDone = null;
    private byte side = 0;
    private byte curTact = 0;
    private static final byte tacts = 6;

    public void setSide(byte by) {
        this.side = by;
    }

    public byte getSide() {
        return this.side;
    }

    public void create(CGame cGame, int n, byte by, int n2, int n3, int n4) {
        this.unitsDown = (byte)-1;
        this.company = (byte)n;
        this.type = by;
        this.maxCount = this.count = (byte)n2;
        this.moveMade = false;
        this.dx = 0;
        this.dy = 0;
        this.loadParams();
        this.health = this.DEFENCE * this.count;
        this.xMap = (byte)n3;
        this.yMap = (byte)n4;
        this.landDef = this.type < 12 ? cGame.getLandDef(this.xMap, this.yMap) : (byte)0;
        this.curTact = (byte)Math.abs(cGame.rand.nextInt() % 24);
    }

    private void loadParams() {
        this.ATTACK = paramTable[4 * this.type];
        this.DEFENCE = paramTable[4 * this.type + 1];
        this.DISTANCE = paramTable[4 * this.type + 2];
        this.SPEED = paramTable[4 * this.type + 3];
    }

    public void loadLevelImgs(CCanvas cCanvas) {
        try {
            int n;
            int n2;
            Image image = Image.createImage((String)"/img/unit0.png");
            cCanvas.drawLoading(1, 23);
            int n3 = 6;
            int n4 = 4;
            int n5 = image.getWidth() / n3;
            int n6 = image.getHeight() / n4;
            int n7 = 0;
            for (n2 = 0; n2 < 12; ++n2) {
                n = n2 < 6 ? n2 << 2 : (n2 - 6 << 2) + 56;
                CUnit.imgUnit[n] = cCanvas.createImage(image, n7 % n3, n7 / n3, n5, n6, false);
                CUnit.imgUnit[n + 1] = cCanvas.createImage(image, ++n7 % n3, n7 / n3, n5, n6, false);
                ++n7;
                CUnit.imgUnit[n + 2] = cCanvas.createImage(imgUnit[n], 0, 0, n5, n6, true);
                CUnit.imgUnit[n + 3] = cCanvas.createImage(imgUnit[n + 1], 0, 0, n5, n6, true);
                cCanvas.drawLoading(1, 24 + n2);
            }
            image = null;
            image = Image.createImage((String)"/img/unit1.png");
            cCanvas.drawLoading(1, 36);
            n3 = 4;
            n4 = 4;
            n5 = image.getWidth() / n3;
            n6 = image.getHeight() / n4;
            n7 = 0;
            for (n2 = 0; n2 < 8; ++n2) {
                n = 24 + (n2 << 2);
                CUnit.imgUnit[n] = cCanvas.createImage(image, n7 % n3, n7 / n3, n5, n6, false);
                CUnit.imgUnit[n + 1] = cCanvas.createImage(image, ++n7 % n3, n7 / n3, n5, n6, false);
                ++n7;
                CUnit.imgUnit[n + 2] = cCanvas.createImage(imgUnit[n], 0, 0, n5, n6, true);
                CUnit.imgUnit[n + 3] = cCanvas.createImage(imgUnit[n + 1], 0, 0, n5, n6, true);
                cCanvas.drawLoading(1, 37 + n2);
            }
            image = null;
            image = Image.createImage((String)"/img/unit2.png");
            cCanvas.drawLoading(1, 45);
            n7 = 0;
            for (n2 = 0; n2 < 8; ++n2) {
                n = 80 + (n2 << 2);
                CUnit.imgUnit[n] = cCanvas.createImage(image, n7 % n3, n7 / n3, n5, n6, false);
                CUnit.imgUnit[n + 1] = cCanvas.createImage(image, ++n7 % n3, n7 / n3, n5, n6, false);
                ++n7;
                CUnit.imgUnit[n + 2] = cCanvas.createImage(imgUnit[n], 0, 0, n5, n6, true);
                CUnit.imgUnit[n + 3] = cCanvas.createImage(imgUnit[n + 1], 0, 0, n5, n6, true);
                cCanvas.drawLoading(1, 46 + n2);
            }
            image = null;
            imgMoveDone = Image.createImage((String)"/img/movedone.png");
            cCanvas.drawLoading(1, 54);
        }
        catch (Exception exception) {
            System.err.println("Unit.loadLevelImgs(): " + exception.toString());
        }
    }

    public byte getMovePts(int n) {
        return movement[n * 14 + this.type];
    }

    public void releaseImages() {
        int n = 112;
        for (int n2 = 0; n2 < n; n2 = (int)((byte)(n2 + 1))) {
            CUnit.imgUnit[n2] = null;
        }
        imgMoveDone = null;
    }

    public byte getCom() {
        return this.company;
    }

    public void draw(CCanvas cCanvas, int n, int n2) {
        if (this.count <= 0) {
            return;
        }
        this.xScr = n + this.dx;
        this.yScr = n2 + this.dy - 11;
        n = this.xScr;
        n2 = this.yScr;
        int n3 = this.company * 56 + (this.type << 2) + this.side;
        if (this.type <= 5) {
            n2 -= this.curTact / 12;
        } else {
            n2 += 11;
            n2 -= this.curTact / 3 % 2;
        }
        cCanvas.scrGrap.drawImage(imgUnit[n3], n, n2, 33);
        if (this.moveMade) {
            cCanvas.scrGrap.drawImage(imgMoveDone, this.xScr, this.yScr, 33);
        }
    }

    public void drawHealthLine(Graphics graphics) {
        if (this.health == 0) {
            return;
        }
        int n = 26;
        int n2 = 2;
        int n3 = this.xScr - (n >> 1);
        int n4 = this.yScr;
        int n5 = this.type > 5 ? -2 : 2;
        graphics.setColor(0xFF0000);
        graphics.fillRect(n3, n4 += n5, n, n2);
        graphics.setColor(65280);
        int n6 = n * this.health / (this.DEFENCE * this.maxCount);
        graphics.fillRect(n3, n4, n6, n2);
    }

    public Image getImg() {
        int n = 56 * this.company + (this.type << 2) + 1;
        return imgUnit[n];
    }

    public void tactAnimation() {
        this.curTact = (byte)(this.curTact + 1);
        if (this.curTact >= 24) {
            this.curTact = 0;
        }
    }

    public int getDamage(CUnit cUnit, int n) {
        int n2 = this.ATTACK;
        if (n2 > 0) {
            n2 -= cUnit.landDef;
        }
        int n3 = n2 * this.count * n / 100;
        byte by = attackIntensity[this.type * 14 + cUnit.type];
        return n3 * by / 100;
    }

    private int getDamagePossible(int n) {
        int n2 = this.health - n;
        if (n2 < 0) {
            return this.health;
        }
        int n3 = this.maxCount * this.DEFENCE;
        if (n2 > n3) {
            return this.health - n3;
        }
        return n;
    }

    public byte unitDown(int n) {
        int n2 = this.health - n;
        int n3 = n2 / this.DEFENCE + (n2 % this.DEFENCE > 0 ? 1 : 0);
        return (byte)(this.count - n3);
    }

    public byte getName(char[] cArray) {
        switch (this.type) {
            case 0: {
                cArray[0] = 83;
                cArray[1] = 111;
                cArray[2] = 108;
                cArray[3] = 100;
                cArray[4] = 105;
                cArray[5] = 101;
                cArray[6] = 114;
                return 7;
            }
            case 1: {
                cArray[0] = 77;
                cArray[1] = 101;
                cArray[2] = 100;
                cArray[3] = 105;
                cArray[4] = 99;
                return 5;
            }
            case 2: {
                cArray[0] = 77;
                cArray[1] = 101;
                cArray[2] = 99;
                cArray[3] = 104;
                cArray[4] = 97;
                cArray[5] = 110;
                cArray[6] = 105;
                cArray[7] = 99;
                return 8;
            }
            case 4: {
                cArray[0] = 71;
                cArray[1] = 117;
                cArray[2] = 101;
                cArray[3] = 114;
                cArray[4] = 114;
                cArray[5] = 105;
                cArray[6] = 108;
                cArray[7] = 108;
                cArray[8] = 97;
                return 9;
            }
            case 3: {
                cArray[0] = 83;
                cArray[1] = 110;
                cArray[2] = 105;
                cArray[3] = 112;
                cArray[4] = 101;
                cArray[5] = 114;
                return 6;
            }
            case 5: {
                cArray[0] = 86;
                cArray[1] = 73;
                cArray[2] = 80;
                return 3;
            }
            case 6: {
                cArray[0] = 77;
                cArray[1] = 111;
                cArray[2] = 114;
                cArray[3] = 116;
                cArray[4] = 97;
                cArray[5] = 114;
                return 6;
            }
            case 7: {
                cArray[0] = 67;
                cArray[1] = 97;
                cArray[2] = 110;
                cArray[3] = 110;
                cArray[4] = 111;
                cArray[5] = 110;
                return 6;
            }
            case 8: {
                cArray[0] = 65;
                cArray[1] = 110;
                cArray[2] = 116;
                cArray[3] = 105;
                cArray[4] = 45;
                cArray[5] = 97;
                cArray[6] = 105;
                cArray[7] = 114;
                return 8;
            }
            case 9: {
                cArray[0] = 76;
                cArray[1] = 45;
                cArray[2] = 116;
                cArray[3] = 97;
                cArray[4] = 110;
                cArray[5] = 107;
                return 6;
            }
            case 10: {
                cArray[0] = 77;
                cArray[1] = 45;
                cArray[2] = 116;
                cArray[3] = 97;
                cArray[4] = 110;
                cArray[5] = 107;
                return 6;
            }
            case 11: {
                cArray[0] = 72;
                cArray[1] = 45;
                cArray[2] = 116;
                cArray[3] = 97;
                cArray[4] = 110;
                cArray[5] = 107;
                return 6;
            }
            case 12: {
                cArray[0] = 70;
                cArray[1] = 105;
                cArray[2] = 103;
                cArray[3] = 104;
                cArray[4] = 116;
                cArray[5] = 101;
                cArray[6] = 114;
                return 7;
            }
            case 13: {
                cArray[0] = 66;
                cArray[1] = 111;
                cArray[2] = 109;
                cArray[3] = 98;
                cArray[4] = 101;
                cArray[5] = 114;
                return 6;
            }
        }
        return 0;
    }

    public String getInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.type) {
            case 0: {
                stringBuffer.append("Soldiers are able to shoot a certain distance and inflict loss on enemy infantry. They are not effective against tanks and artillery. Soldiers are also able to dig trenches and sit in them, thus increasing it's protection. ");
                break;
            }
            case 1: {
                stringBuffer.append("Doctors can restore the initial number of soldiers and guerrillas up to the maximum quantity. ");
                break;
            }
            case 2: {
                stringBuffer.append("Mechanics are able to repair equipment - tanks and artillery. ");
                break;
            }
            case 4: {
                stringBuffer.append("Guerrillas inflict loss to tanks and artillery and move faster in woods, mountains and water. ");
                break;
            }
            case 3: {
                stringBuffer.append("Snipers from long distances can inflict heavy losses on infantry. ");
                break;
            }
            case 5: {
                stringBuffer.append("Protect your VIP! ");
                break;
            }
            case 6: {
                stringBuffer.append("Mortars are effective against infantry. ");
                break;
            }
            case 7: {
                stringBuffer.append("Cannons are effective against artillery and heavy armor and superior at greater distances than mortars. ");
                break;
            }
            case 8: {
                stringBuffer.append("Anti-aircraft installations inflict severe loss to enemy planes. ");
                break;
            }
            case 9: {
                stringBuffer.append("Light tanks inflict significant loss on infantry. ");
                break;
            }
            case 10: {
                stringBuffer.append("Medium tanks have heavy armor, and are more effective than light tanks against heavy armor. ");
                break;
            }
            case 11: {
                stringBuffer.append("Heavy tanks are able to inflict significant loss to equipment and infantry as well as attack planes. ");
                break;
            }
            case 12: {
                stringBuffer.append("No infantry is able to inflict loss on aircraft. Fighters aircraft inflict significant loss to planes and enemy infantry. They are not effective against land based equipment. ");
                break;
            }
            case 13: {
                stringBuffer.append("Bombers inflict significant loss to everything on the ground. ");
            }
        }
        return new String(stringBuffer);
    }

    public boolean canAttack(CUnit cUnit) {
        if (attackIntensity[this.type * 14 + cUnit.type] <= 0) {
            return false;
        }
        if (cUnit.getCom() == this.company) {
            return this.ATTACK < 0;
        }
        return this.ATTACK > 0;
    }

    public int getParamSum() {
        int n = Math.abs(this.ATTACK);
        n += this.DEFENCE;
        n += this.DISTANCE * 10;
        return (n += this.SPEED * 10) >> 2;
    }

    public int getAttackScores(CUnit cUnit, boolean bl) {
        int n;
        int n2 = 0;
        byte by = 0;
        if (this.canAttack(cUnit) && (n = this.getAttackChance(cUnit)) > 0) {
            int n3 = this.getDamage(cUnit, n);
            int n4 = cUnit.getDamagePossible(n3);
            by = cUnit.unitDown(n4);
            int n5 = cUnit.getParamSum();
            n2 = n4 * n5;
            if (n3 < 0) {
                n2 <<= 1;
                if (!bl) {
                    n2 = -n2;
                    n2 += n;
                }
            }
        }
        if (!bl) {
            cUnit.count = (byte)(cUnit.count - by);
            n = cUnit.getAttackScores(this, true);
            cUnit.count = (byte)(cUnit.count + by);
            n2 -= n;
        }
        return n2;
    }

    public void attack(CUnit cUnit, int n) {
        int n2 = cUnit.getDamagePossible(this.getDamage(cUnit, n));
        cUnit.unitsDown = cUnit.unitDown(n2);
        cUnit.health -= n2;
        cUnit.count = (byte)(cUnit.count - cUnit.unitsDown);
        cUnit.attacked = true;
    }

    public byte getAttackChance(CUnit cUnit) {
        if (this.DISTANCE == 0) {
            return 0;
        }
        byte by = this.DISTANCE;
        int n = 100 / by;
        int n2 = Math.abs(this.xMap - cUnit.xMap) + Math.abs(this.yMap - cUnit.yMap) - 1;
        int n3 = 100 - n2 * n;
        return (byte)(n3 > 0 ? n3 : 0);
    }

    public boolean move(CGame cGame) {
        if (this.moveCount <= 0) {
            return false;
        }
        if (this.moveTact % 4 == 0) {
            byte by = (byte)(this.moveTact / 4);
            if (by < this.moveCount) {
                switch (this.move[by]) {
                    case 1: {
                        this.nx = (byte)(this.nx + 1);
                        this.tx = (byte)(this.tx + 1);
                        this.ty = (byte)(this.ty - 1);
                        this.vx = (byte)5;
                        this.vy = (byte)-2;
                        this.side = 0;
                        break;
                    }
                    case 6: {
                        this.nx = (byte)(this.nx - 1);
                        this.tx = (byte)(this.tx - 1);
                        this.ty = (byte)(this.ty + 1);
                        this.vx = (byte)-5;
                        this.vy = (byte)2;
                        this.side = (byte)3;
                        break;
                    }
                    case 2: {
                        this.ny = (byte)(this.ny - 1);
                        this.tx = (byte)(this.tx - 1);
                        this.ty = (byte)(this.ty - 1);
                        this.vx = (byte)-5;
                        this.vy = (byte)-2;
                        this.side = (byte)2;
                        break;
                    }
                    case 5: {
                        this.ny = (byte)(this.ny + 1);
                        this.tx = (byte)(this.tx + 1);
                        this.ty = (byte)(this.ty + 1);
                        this.vx = (byte)5;
                        this.vy = (byte)2;
                        this.side = 1;
                    }
                }
                this.dx = (this.tx * 44 >> 1) - this.vx * 4;
                this.dy = (this.ty * 22 >> 1) - this.vy * 4;
            } else {
                this.xMap = (byte)(this.xMap + this.nx);
                this.yMap = (byte)(this.yMap + this.ny);
                this.moveCount = 0;
                this.moveTact = 0;
                this.ny = 0;
                this.nx = 0;
                this.dy = 0;
                this.dx = 0;
                this.ty = 0;
                this.tx = 0;
                this.landDef = this.type < 12 ? cGame.getLandDef(this.xMap, this.yMap) : (byte)0;
                return false;
            }
        }
        this.dx += this.vx;
        this.dy += this.vy;
        this.xScr += this.vx;
        this.yScr += this.vy;
        this.moveTact = (byte)(this.moveTact + 1);
        return true;
    }

    public void addMove(int n) {
        this.move[this.moveCount] = n;
        this.moveCount = (byte)(this.moveCount + 1);
    }

    public void setSide(CUnit cUnit) {
        if (this.xScr > cUnit.xScr) {
            if (this.yScr > cUnit.yScr) {
                this.side = (byte)2;
                cUnit.side = 1;
            } else {
                this.side = (byte)3;
                cUnit.side = 0;
            }
        } else if (this.yScr > cUnit.yScr) {
            this.side = 0;
            cUnit.side = (byte)3;
        } else {
            this.side = 1;
            cUnit.side = (byte)2;
        }
    }

    public int save(byte[] byArray, int n) {
        byArray[n] = this.type;
        byArray[++n] = (byte)(this.health / 100);
        byArray[++n] = (byte)(this.health % 100);
        byArray[++n] = this.count;
        byArray[++n] = this.maxCount;
        byArray[++n] = this.xMap;
        byArray[++n] = this.yMap;
        byArray[++n] = this.moveMade ? (byte)1 : 0;
        byArray[++n] = this.side;
        return ++n;
    }

    public int load(CGame cGame, byte[] byArray, int n, byte by) {
        this.company = by;
        this.unitsDown = (byte)-1;
        this.dx = 0;
        this.dy = 0;
        this.type = byArray[n];
        this.health = byArray[++n] * 100;
        this.health += byArray[++n];
        this.count = byArray[++n];
        this.maxCount = byArray[++n];
        this.xMap = byArray[++n];
        this.yMap = byArray[++n];
        this.moveMade = byArray[++n] != 0;
        this.side = byArray[++n];
        this.loadParams();
        this.landDef = this.type < 12 ? cGame.getLandDef(this.xMap, this.yMap) : (byte)0;
        this.curTact = (byte)Math.abs(cGame.rand.nextInt() % 24);
        return ++n;
    }
}

