/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.util.Date;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class CMenu {
    private CCanvas Can = null;
    private CGame Game = null;
    public boolean Melody = false;
    public boolean Sounds = false;
    public boolean Vibration = true;
    public boolean Animation = true;
    public boolean Locked = true;
    public Player sndSplash = null;
    public VolumeControl sndVolume = null;
    public byte volume = (byte)9;
    private byte saves = (byte)3;
    private byte[] missions = new byte[2];
    private String[] saveStr = new String[]{"EMPTY", "EMPTY", "EMPTY"};
    private int[] saveSize = new int[this.saves];
    private static final byte MI_PLAY = 0;
    private static final byte MI_OPTIONS = 1;
    private static final byte MI_HELP = 2;
    private static final byte MI_ABOUT = 3;
    private static final byte MI_EXIT = 4;
    private static final byte MI_MELODY = -5;
    private static final byte MI_SOUNDS = -6;
    private static final byte MI_VOLUME = -7;
    private static final byte MI_VIBRATION = -8;
    private static final byte MI_ANIMATION = -9;
    private static final byte MI_BACK = 10;
    private static final byte MI_RETURN = 11;
    private static final byte MI_SAVE = 12;
    private static final byte MI_OBJECTIVE = 13;
    private static final byte MI_MAIN = 15;
    private static final byte MI_YES = 16;
    private static final byte MI_NO = 17;
    private static final byte MI_LOAD = 18;
    private static final byte MI_NEW_GAME = 19;
    private static final byte MI_MISSION = -20;
    private static final byte MI_ALLIED = 21;
    private static final byte MI_AXIS = 22;
    private static final byte MI_RESTART = 23;
    private static final byte MI_SAVE_SLOT = 24;
    private byte[] itemStr = null;
    private final int[] itemStrIdx = new int[]{0, 4, 11, 15, 20, 24, 32, 40, 48, 59, 70, 74, 80, 84, 93, 101, 110, 113, 115, 119, 127, 135, 148, 159, 174};
    private byte Selected = 0;
    private static final byte maxItems = 10;
    private int[] items = new int[60];
    private byte itemCount = 0;
    public static final byte TYPE_LOGO = 0;
    public static final byte TYPE_SPLASH = 1;
    public static final byte TYPE_MAIN = 2;
    public static final byte TYPE_OPTIONS = 3;
    public static final byte TYPE_INGAME = 4;
    public static final byte TYPE_HELP = 5;
    public static final byte TYPE_ASK = 6;
    public static final byte TYPE_PLAY = 7;
    public static final byte TYPE_LOAD = 8;
    public static final byte TYPE_SAVE = 9;
    public static final byte TYPE_MISSION = 10;
    public static final byte TYPE_GAME = 11;
    public static final byte TYPE_ABOUT = 12;
    public static final byte TYPE_OBJECTIVES = 13;
    public static final byte TYPE_SOUNDS = 14;
    public static final byte TYPE_GAMEOVER = 15;
    public static final byte TYPE_LOADING = 16;
    private static final byte maxTypes = 10;
    private byte[] typeSeq = new byte[10];
    private byte typeStep = 0;
    private Image imgTitle = null;
    private Image imgSplash = null;
    private Image imgLogo = null;
    private Image imgMenu = null;
    private boolean active = false;
    private boolean keyBack = false;
    private int xanim = 0;
    private int yanim = 0;
    private String title = null;
    private byte itemPrev = 0;
    private byte option = 0;
    private byte company = 0;

    public CMenu(CCanvas cCanvas) {
        this.Can = cCanvas;
        this.loadValues();
        this.itemStrInit();
        this.setType((byte)14);
    }

    private void itemStrInit() {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("menu.txt");
            int n = inputStream.available();
            this.itemStr = new byte[n];
            inputStream.read(this.itemStr);
            inputStream.close();
            for (int i = 0; i < n; ++i) {
                this.itemStr[i] = (byte)(this.itemStr[i] - 65);
            }
        }
        catch (Exception exception) {
            System.err.println("CMenu.itemStrInit: " + exception.toString());
        }
    }

    public void setType(byte by) {
        if (this.typeStep + 1 < 10) {
            this.typeStep = (byte)(this.typeStep + 1);
            this.typeSeq[this.typeStep] = by;
        }
        this.itemPrev = (byte)this.items[this.Selected];
        this.active = true;
        this.title = null;
        this.itemCount = 0;
        this.Selected = 0;
        this.xanim = 0;
        switch (by) {
            case 14: {
                this.itemPrev = (byte)-6;
                this.title = new String("Enable sounds?");
                this.items[0] = 16;
                this.items[1] = 17;
                this.itemCount = (byte)2;
                break;
            }
            case 15: {
                this.title = new String("Game over");
                this.items[0] = 23;
                this.items[1] = 18;
                this.items[2] = 15;
                this.itemCount = (byte)3;
                this.typeStep = 0;
                this.typeSeq[this.typeStep] = by;
                break;
            }
            case 0: {
                this.active = false;
                this.typeStep = 0;
                this.typeSeq[this.typeStep] = by;
                break;
            }
            case 1: {
                this.Can.scrGrap.drawImage(this.imgSplash, 128 >> 1, 1, 17);
                this.Can.scrGrap.drawImage(this.imgTitle, 128 >> 1, 128, 33);
                this.xanim = 0;
                this.yanim = 5;
                break;
            }
            case 2: {
                this.items[0] = 0;
                this.items[1] = 1;
                this.items[2] = 2;
                this.items[3] = 3;
                this.items[4] = 4;
                this.itemCount = (byte)5;
                break;
            }
            case 7: {
                this.items[0] = 21;
                this.items[1] = 22;
                this.items[2] = 18;
                this.items[3] = 10;
                this.itemCount = (byte)4;
                break;
            }
            case 3: {
                this.title = new String("OPTIONS");
                this.items[0] = -5;
                this.items[1] = -6;
                this.items[2] = -7;
                this.items[3] = -8;
                this.items[4] = 10;
                this.itemCount = (byte)5;
                break;
            }
            case 4: {
                this.items[0] = 11;
                this.items[1] = 13;
                this.items[2] = 12;
                this.items[3] = 18;
                this.items[4] = 23;
                this.items[5] = 1;
                this.items[6] = 15;
                this.itemCount = (byte)7;
                break;
            }
            case 12: {
                this.aboutStringPrepare();
                this.drawHelp();
                break;
            }
            case 5: {
                this.helpStringPrepare();
                this.drawHelp();
                break;
            }
            case 6: {
                switch (this.itemPrev) {
                    case 24: {
                        switch (this.typeSeq[this.typeStep - 1]) {
                            case 8: {
                                this.title = new String("Are you sure?");
                                break;
                            }
                            case 9: {
                                this.title = new String("Overwrite save?");
                            }
                        }
                        break;
                    }
                    case 4: {
                        this.title = new String("Exit Game?");
                        break;
                    }
                    case 15: 
                    case 23: {
                        this.title = new String("Are you sure?");
                    }
                }
                this.items[0] = 16;
                this.items[1] = 17;
                this.itemCount = (byte)2;
                break;
            }
            case 8: {
                this.title = new String("Load Game");
                for (byte by2 = 0; by2 < this.saves; by2 = (byte)(by2 + 1)) {
                    this.items[this.itemCount] = 24;
                    this.itemCount = (byte)(this.itemCount + 1);
                }
                this.items[this.itemCount] = 10;
                this.itemCount = (byte)(this.itemCount + 1);
                break;
            }
            case 10: {
                if (this.itemPrev != 21 && this.Locked) {
                    this.title = new String("This company is LOCKED");
                    this.items[0] = 10;
                    this.itemCount = 1;
                    break;
                }
                this.option = 0;
                this.title = new String(this.itemPrev == 21 ? "ALLIED POWERS" : "AXIS POWERS");
                this.items[0] = 19;
                if (this.missions[this.itemPrev == 21 ? 0 : 1] > 1) {
                    this.items[1] = -20;
                    this.items[2] = 10;
                    this.itemCount = (byte)3;
                    break;
                }
                this.items[1] = 10;
                this.itemCount = (byte)2;
                break;
            }
            case 9: {
                this.title = new String("Save Game");
                for (byte by3 = 0; by3 < this.saves; by3 = (byte)(by3 + 1)) {
                    this.items[this.itemCount] = 24;
                    this.itemCount = (byte)(this.itemCount + 1);
                }
                this.items[this.itemCount] = 10;
                this.itemCount = (byte)(this.itemCount + 1);
                break;
            }
            case 11: {
                break;
            }
            case 16: {
                this.active = false;
                this.Can.scrGrap.setColor(0);
                this.Can.scrGrap.fillRect(0, 0, 128, 128);
                this.sndStop();
            }
        }
    }

    public void commandAction(boolean bl) {
        byte by = this.typeSeq[this.typeStep];
        if (by == 11) {
            this.Game.commandAction(bl);
        } else if (bl) {
            this.keyPressed(53);
        } else if (this.title == null) {
            this.menuBack();
        } else {
            switch (by) {
                case 5: 
                case 12: {
                    this.menuBack();
                    break;
                }
                default: {
                    if (this.typeStep <= 0) break;
                    this.active = false;
                    this.keyBack = true;
                }
            }
        }
    }

    public void keyReleased(int n) {
    }

    public void keyPressed(int n) {
        if (!this.active) {
            return;
        }
        int n2 = this.Can.getGameAction(n);
        block0 : switch (this.typeSeq[this.typeStep]) {
            case 11: {
                this.Game.keyPressed(n);
                break;
            }
            case 0: 
            case 1: {
                this.menuBack();
                break;
            }
            case 5: 
            case 12: {
                switch (n2) {
                    case 1: {
                        if (this.Selected <= 0) break;
                        this.Selected = (byte)(this.Selected - 1);
                        this.drawHelp();
                        break;
                    }
                    case 6: {
                        if (this.Selected + 10 >= this.itemCount) break;
                        this.Selected = (byte)(this.Selected + 1);
                        this.drawHelp();
                        break;
                    }
                    case 8: {
                        this.menuBack();
                    }
                }
                break;
            }
            default: {
                switch (n2) {
                    case 1: {
                        this.nextItem(false);
                        break block0;
                    }
                    case 6: {
                        this.nextItem(true);
                        break block0;
                    }
                    case 8: {
                        if (this.items[this.Selected] < 0) {
                            if (this.items[this.Selected] == -20) {
                                this.itemAction(this.items[this.Selected]);
                                break block0;
                            }
                            this.itemOption(this.items[this.Selected], true);
                            break block0;
                        }
                        if (this.title != null) {
                            this.active = false;
                            break block0;
                        }
                        this.itemAction(this.items[this.Selected]);
                        break block0;
                    }
                    case 2: {
                        if (this.items[this.Selected] >= 0) break block0;
                        this.itemOption(this.items[this.Selected], false);
                        break block0;
                    }
                    case 5: {
                        if (this.items[this.Selected] >= 0) break block0;
                        this.itemOption(this.items[this.Selected], true);
                    }
                }
            }
        }
    }

    private byte optionValue(int n, boolean bl, int n2) {
        if (bl) {
            if (++n >= n2) {
                n = 0;
            }
        } else if (--n < 0) {
            n = n2 - 1;
        }
        return (byte)n;
    }

    private void itemOption(int n, boolean bl) {
        switch (n) {
            case -7: {
                this.volume = this.optionValue(this.volume, bl, 10);
                this.setVolume();
                break;
            }
            case -5: {
                boolean bl2 = this.Melody = !this.Melody;
                if (this.Game != null) break;
                if (this.Melody) {
                    this.sndPlay();
                    break;
                }
                this.sndStop();
                break;
            }
            case -6: {
                this.Sounds = !this.Sounds;
                break;
            }
            case -8: {
                this.Vibration = !this.Vibration;
                break;
            }
            case -9: {
                this.Animation = !this.Animation;
                break;
            }
            case -20: {
                this.option = this.optionValue(this.option, bl, this.missions[this.itemPrev == 21 ? 0 : 1]);
            }
        }
    }

    private void nextItem(boolean bl) {
        if (bl) {
            this.Selected = (byte)(this.Selected + 1);
            if (this.Selected == this.itemCount) {
                this.Selected = 0;
            }
        } else {
            this.Selected = (byte)(this.Selected - 1);
            if (this.Selected < 0) {
                this.Selected = (byte)(this.itemCount - 1);
            }
        }
    }

    private void itemAction(int n) {
        switch (n) {
            case 0: {
                this.setType((byte)7);
                break;
            }
            case 1: {
                this.setType((byte)3);
                break;
            }
            case 2: {
                this.setType((byte)5);
                break;
            }
            case 3: {
                this.setType((byte)12);
                break;
            }
            case 4: {
                this.setType((byte)6);
                break;
            }
            case 10: 
            case 11: {
                this.menuBack();
                break;
            }
            case 12: {
                this.setType((byte)9);
                break;
            }
            case 13: {
                this.setType((byte)11);
                this.Game.setState((byte)4);
                break;
            }
            case 15: {
                this.setType((byte)6);
                break;
            }
            case 16: {
                switch (this.itemPrev) {
                    case -6: {
                        this.Sounds = true;
                        this.Melody = true;
                        this.menuBack();
                        break;
                    }
                    case 4: {
                        this.Can.quit();
                        break;
                    }
                    case 24: {
                        switch (this.typeSeq[this.typeStep - 1]) {
                            case 8: {
                                this.setType((byte)16);
                                break;
                            }
                            case 9: {
                                this.saveGame(this.option);
                                this.typeStep = (byte)(this.typeStep - 1);
                                this.menuBack();
                            }
                        }
                        break;
                    }
                    case 23: {
                        this.setType((byte)11);
                        this.Game.setState((byte)0);
                        break;
                    }
                    case 15: {
                        this.setType((byte)0);
                    }
                }
                break;
            }
            case 17: {
                this.menuBack();
                break;
            }
            case 18: {
                this.setType((byte)8);
                break;
            }
            case 19: {
                this.option = 0;
                this.setType((byte)16);
                break;
            }
            case -20: {
                this.setType((byte)16);
                break;
            }
            case 21: 
            case 22: {
                this.company = this.Selected;
                this.setType((byte)10);
                break;
            }
            case 24: {
                switch (this.typeSeq[this.typeStep]) {
                    case 9: {
                        if (this.saveSize[this.Selected] > 0) {
                            this.option = this.Selected;
                            this.setType((byte)6);
                            break;
                        }
                        this.saveGame(this.Selected);
                        this.menuBack();
                        break;
                    }
                    case 8: {
                        if (this.saveSize[this.Selected] > 0) {
                            this.option = -this.Selected;
                            this.option = (byte)(this.option - 1);
                            this.setType(this.typeSeq[this.typeStep - 1] == 4 ? (byte)6 : 16);
                            break;
                        }
                        this.menuBack();
                    }
                }
                break;
            }
            case 23: {
                if (this.typeSeq[this.typeStep] == 4) {
                    this.setType((byte)6);
                    break;
                }
                this.setType((byte)11);
                this.Game.setState((byte)0);
            }
        }
    }

    private void createGame(byte by) {
        if (this.typeSeq[0] == 2) {
            this.release();
            if (this.Game != null) {
                this.Game.release();
                this.Game = null;
            }
            CCanvas.memClean();
            this.Game = new CGame(this.Can, this, this.company);
        }
        this.Game.start(by);
        this.typeStep = (byte)-1;
        this.setType((byte)11);
    }

    public void saveGame(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        this.saveStr[n] = null;
        String string = new Date().toString();
        byte by = this.Game.getMission();
        by = (byte)(by + 1);
        byte by2 = this.Game.getCompany();
        stringBuffer.append(by2 == 0 ? "ALLIED" : "AXIS");
        stringBuffer.append(" M" + by + " - ");
        stringBuffer.append(string.substring(4, 16));
        this.saveStr[n] = stringBuffer.toString();
        byte[] byArray = this.Game.saveMap();
        byte[] byArray2 = this.loadGame(-1);
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"saves", (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            int n2 = 0;
            for (byte by3 = 0; by3 < this.saves; by3 = (byte)(by3 + 1)) {
                if (by3 == n) {
                    dataOutputStream.write(byArray);
                } else if (this.saveSize[by3] > 0) {
                    dataOutputStream.write(byArray2, n2, this.saveSize[by3]);
                }
                n2 += this.saveSize[by3];
            }
            byte[] byArray3 = byteArrayOutputStream.toByteArray();
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray3, 0, byArray3.length);
            } else {
                RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, true);
                recordStore.setRecord(recordEnumeration.nextRecordId(), byArray3, 0, byArray3.length);
            }
            byArray3 = null;
            byteArrayOutputStream = null;
            dataOutputStream = null;
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            System.err.println("CMenu.saveGame(): " + exception.toString());
        }
        this.saveSize[n] = byArray.length;
        this.saveValues();
        byArray = null;
        byArray2 = null;
    }

    public byte[] loadGame(int n) {
        int n2 = 0;
        byte[] byArray = null;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"saves", (boolean)true);
            if (recordStore.getNumRecords() == 1) {
                RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, true);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(recordStore.getRecord(recordEnumeration.nextRecordId()));
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                if (n == -1) {
                    byArray = new byte[dataInputStream.available()];
                    n2 = dataInputStream.read(byArray);
                } else {
                    n2 = 0;
                    for (int n3 = 0; n3 < n; n3 = (int)((byte)(n3 + 1))) {
                        n2 += this.saveSize[n3];
                    }
                    byArray = new byte[this.saveSize[n]];
                    dataInputStream.skipBytes(n2);
                    dataInputStream.read(byArray, 0, this.saveSize[n]);
                    n2 = this.saveSize[n];
                }
                byteArrayInputStream = null;
                dataInputStream = null;
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            System.err.println("CMenu.loadGame(): " + exception.toString());
        }
        return byArray;
    }

    private void menuBack() {
        byte by = this.typeSeq[this.typeStep];
        if (this.typeStep <= 0) {
            switch (by) {
                case 14: {
                    this.typeStep = (byte)(this.typeStep - 1);
                    this.setType((byte)0);
                    break;
                }
                case 0: {
                    this.typeStep = (byte)(this.typeStep - 1);
                    this.setType((byte)1);
                    break;
                }
                case 1: {
                    this.typeStep = (byte)(this.typeStep - 1);
                    this.setType((byte)2);
                    break;
                }
                case 2: {
                    this.items[this.Selected] = 4;
                    this.itemAction(4);
                    break;
                }
                case 4: {
                    this.setType((byte)11);
                }
            }
        } else {
            this.typeStep = (byte)(this.typeStep - 2);
            this.setType(this.typeSeq[this.typeStep + 1]);
        }
    }

    public void draw() {
        switch (this.typeSeq[this.typeStep]) {
            case 0: {
                this.drawLogo();
                break;
            }
            case 1: {
                this.drawSplash();
                break;
            }
            case 2: {
                this.drawMain();
                break;
            }
            case 5: 
            case 12: {
                break;
            }
            case 11: {
                this.Game.draw();
                break;
            }
            case 16: {
                this.drawLoading();
                break;
            }
            default: {
                this.drawInGame();
            }
        }
    }

    private void drawLoading() {
        switch (this.Selected) {
            case 0: {
                int n = this.Can.strH + 4;
                this.Can.drawLoading(0, this.xanim);
                if (this.xanim == n) {
                    this.Selected = (byte)(this.Selected + 1);
                    break;
                }
                this.xanim = CCanvas.f(this.xanim, n);
                break;
            }
            default: {
                this.createGame(this.option);
            }
        }
    }

    private void drawLogo() {
        switch (this.Selected) {
            case 0: {
                this.active = false;
                this.Can.scrGrap.setColor(0);
                this.Can.scrGrap.fillRect(0, 0, 128, 128);
                this.Can.drawLoading(-1, 0);
                this.Selected = (byte)(this.Selected + 1);
                break;
            }
            case 1: {
                if (this.Game != null) {
                    this.Game.release();
                    this.Game = null;
                }
                try {
                    if (this.imgLogo == null) {
                        this.imgLogo = Image.createImage((String)"/img/logo.png");
                    }
                    if (this.imgTitle == null) {
                        this.imgTitle = Image.createImage((String)"/img/title.png");
                    }
                    if (this.imgSplash == null) {
                        this.imgSplash = Image.createImage((String)"/img/splash.png");
                    }
                    if (this.imgMenu == null) {
                        this.imgMenu = Image.createImage((String)"/img/menu.png");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.sndLoad();
                if (this.Melody) {
                    this.sndPlay();
                }
                this.Can.scrGrap.setColor(0);
                this.Can.scrGrap.fillRect(0, 0, 128, 128);
                this.yanim = 128 + (this.imgLogo.getHeight() >> 1);
                this.active = true;
                this.Selected = (byte)(this.Selected + 1);
                break;
            }
            case 2: {
                this.Can.scrGrap.drawImage(this.imgLogo, 128 >> 1, this.yanim, 3);
                this.yanim -= 2;
                if (this.yanim > 128 >> 1) break;
                this.xanim = 0;
                this.Selected = (byte)(this.Selected + 1);
                break;
            }
            case 3: {
                ++this.xanim;
                if (this.xanim < 20) break;
                this.menuBack();
            }
        }
    }

    private void drawSplash() {
        ++this.xanim;
        if (this.xanim >= 60) {
            this.menuBack();
        }
    }

    private void drawMain() {
        this.drawBackground();
        int n = 2;
        int n2 = this.Can.strH + (n << 1);
        int n3 = 11;
        int n4 = 128 - n3 - n2 * this.itemCount;
        this.drawCursor(n4 + n2 * this.Selected, n2);
        this.drawStrings(n4, n2);
    }

    private void drawCursor(int n, int n2) {
        boolean bl = false;
        if (this.yanim != n) {
            this.yanim = Math.abs(this.yanim - n) < 2 ? n : this.yanim + n >> 1;
        } else if (this.items[this.Selected] < 0) {
            bl = true;
        }
        this.Can.scrGrap.setColor(150, 160, 150);
        this.Can.scrGrap.fillRect(0, this.yanim, 128, n2);
        this.Can.scrGrap.setColor(0, 150, 0);
        this.Can.scrGrap.drawLine(0, this.yanim - 1, 128, this.yanim - 1);
        this.Can.scrGrap.drawLine(0, this.yanim + n2, 128, this.yanim + n2);
        if (bl) {
            int n3 = this.getItemStr(this.items[this.Selected]);
            int n4 = this.Can.charsWidth(this.Can.bytes, n3);
            int n5 = n + (n2 >> 1);
            this.Can.scrGrap.setColor(0xFFFFFF);
            this.Can.drawTriagle((128 - n4 >> 1) - 7, n5 - 1, 2, 4);
            this.Can.drawTriagle((128 + n4 >> 1) + 7, n5 - 1, 3, 4);
        }
    }

    private void drawHelp() {
        this.drawBackground();
        int n = 0;
        this.Can.scrGrap.setColor(0);
        this.Can.scrGrap.fillRect(n, n, 128 - (n << 1), 128 - (n << 1));
        this.Can.scrGrap.setColor(0, 120, 0);
        this.Can.scrGrap.drawRect(n, n, 128 - (n << 1), 128 - (n << 1));
        this.Can.scrGrap.setColor(0, 150, 0);
        this.Can.scrGrap.drawRect(++n, n, 128 - (n << 1), 128 - (n << 1));
        this.Can.scrGrap.setColor(0, 120, 0);
        this.Can.scrGrap.drawRect(++n, n, 128 - (n << 1), 128 - (n << 1));
        this.Can.scrGrap.setColor(0, 80, 0);
        this.Can.scrGrap.drawRect(++n, n, 128 - (n << 1), 128 - (n << 1));
        n = 8;
        this.Can.scrGrap.setColor(this.Selected > 0 ? 0xFFFFFF : 0x444444);
        this.Can.drawTriagle(128 >> 1, n, 0, 5);
        this.Can.scrGrap.setColor(this.Selected + 10 < this.itemCount ? 0xFFFFFF : 0x444444);
        this.Can.drawTriagle(128 >> 1, 128 - n, 1, 5);
        int n2 = 16;
        for (byte by = this.Selected; by - this.Selected < 10 && by < this.itemCount; by = (byte)(by + 1)) {
            String string = new String(this.title.substring(this.items[by << 1], this.items[(by << 1) + 1]));
            this.Can.drawString(string, 128 >> 1, n2, 17);
            n2 += this.Can.strH + 2;
        }
    }

    private void drawInGame() {
        int n = 2;
        int n2 = this.Can.strH + (n << 1);
        int n3 = this.itemCount * n2;
        int n4 = 128 - n3 >> 1;
        if (this.Game == null) {
            if (this.typeSeq[this.typeStep] == 14) {
                this.Can.scrGrap.setColor(0);
                this.Can.scrGrap.fillRect(0, 0, 128, 128);
            } else {
                this.drawBackground();
            }
        } else {
            this.Game.drawLevel();
        }
        this.Can.scrGrap.setColor(0);
        this.Can.scrGrap.fillRect(0, n4, 128, n3);
        this.Can.scrGrap.setColor(0, 150, 0);
        this.Can.scrGrap.drawLine(0, n4 - 1, 128, n4 - 1);
        this.Can.scrGrap.drawLine(0, n4 + n3, 128, n4 + n3);
        this.drawCursor(n4 + n2 * this.Selected, n2);
        this.drawStrings(n4, n2);
        if (this.title != null) {
            int n5 = 0;
            if (this.active) {
                n5 = n2 + 10;
            } else if (this.xanim == n5) {
                if (this.keyBack) {
                    this.keyBack = false;
                    this.menuBack();
                } else {
                    this.itemAction(this.items[this.Selected]);
                }
                return;
            }
            this.xanim = CCanvas.f(this.xanim, n5);
            this.Can.scrGrap.setColor(0);
            this.Can.scrGrap.fillRect(0, this.xanim - n2, 128, n2);
            this.Can.scrGrap.setColor(0, 150, 0);
            this.Can.scrGrap.drawLine(0, this.xanim - n2 - 1, 128, this.xanim - n2 - 1);
            this.Can.scrGrap.drawLine(0, this.xanim, 128, this.xanim);
            this.Can.drawString(this.title, 128 >> 1, this.xanim - n2 + n, 17);
        }
    }

    private int getItemStr(int n) {
        int n2 = Math.abs(n);
        int n3 = this.itemStrIdx[n2];
        int n4 = this.itemStrIdx[n2 + 1];
        int n5 = n4 - n3;
        System.arraycopy(this.itemStr, n3, this.Can.bytes, 0, n5);
        if (n < 0) {
            switch (n) {
                case -5: {
                    n5 += this.addBoolValue(n5, this.Melody);
                    break;
                }
                case -6: {
                    n5 += this.addBoolValue(n5, this.Sounds);
                    break;
                }
                case -8: {
                    n5 += this.addBoolValue(n5, this.Vibration);
                    break;
                }
                case -9: {
                    n5 += this.addBoolValue(n5, this.Animation);
                    break;
                }
                case -7: {
                    n5 += this.addIntValue(n5, this.volume + 1);
                    break;
                }
                case -20: {
                    n5 += this.addIntValue(n5, this.option + 1);
                }
            }
        }
        return n5;
    }

    private void drawStrings(int n, int n2) {
        for (byte by = 0; by < this.itemCount; by = (byte)(by + 1)) {
            if (this.items[by] == 24) {
                this.Can.drawString(this.saveStr[by], 128 >> 1, n + 2, 17);
            } else {
                int n3 = this.getItemStr(this.items[by]);
                this.Can.drawChars(false, this.Can.bytes, n3, 128 >> 1, n + 2, 17);
            }
            n += n2;
        }
    }

    private int addBoolValue(int n, boolean bl) {
        if (bl) {
            this.Can.bytes[n] = (byte)this.Can.getCharID('O');
            this.Can.bytes[n + 1] = (byte)this.Can.getCharID('N');
            return 2;
        }
        this.Can.bytes[n] = (byte)this.Can.getCharID('O');
        this.Can.bytes[n + 1] = (byte)this.Can.getCharID('F');
        this.Can.bytes[n + 2] = (byte)this.Can.getCharID('F');
        return 3;
    }

    private int addIntValue(int n, int n2) {
        int n3 = this.Can.IntToChars(n2, 10);
        for (int i = 0; i < n3; ++i) {
            this.Can.bytes[n + i] = (byte)this.Can.getCharID(this.Can.chars[10 - n3 + i]);
        }
        return n3;
    }

    private void drawBackground() {
        this.Can.scrGrap.drawImage(this.imgSplash, 128 >> 1, 1, 17);
        this.Can.scrGrap.drawImage(this.imgMenu, 128 >> 1, 128, 33);
        this.Can.drawDark();
    }

    private void helpStringPrepare() {
        this.title = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("The primary goal of the player is to carry out the task. ");
        stringBuffer.append("The Game process consists of managing the cursor by which ");
        stringBuffer.append("you can move the your units for the performance of tasks, ");
        stringBuffer.append("movements on a map and performing operations. ");
        stringBuffer.append("If the task should fail, then the game is considered to be over (lost). ");
        stringBuffer.append("The player moves on to the following mission as soon as ");
        stringBuffer.append("the previous mission has been completed. ");
        stringBuffer.append("\n--------------------------------------");
        stringBuffer.append("\nControls: \nUp, Down, Left, Right - cursor movements \nOk, 5 - action\n1,3 - show info\n*,# - switch units  ");
        this.title = new String(stringBuffer);
        stringBuffer = null;
        this.itemCount = this.Can.textPrepare(this.title, 128 - 15, this.items);
    }

    private void aboutStringPrepare() {
        this.title = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Another Conflict\n(c) Softeks, 2007\nVersion: 1.0\n\n");
        stringBuffer.append("Programming:\nPavel Ahmadulin\n\nGraphics:\nLena\n\nMusic:\n");
        stringBuffer.append("Oreola\n\nSupport:\nsupport@softeks.net ");
        this.title = new String(stringBuffer);
        stringBuffer = null;
        this.itemCount = this.Can.textPrepare(this.title, 128 - 15, this.items);
    }

    public void saveValues() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"values", (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            byte by = 0;
            by = (byte)(by | (this.Vibration ? 1 : 0));
            by = (byte)(by | (this.Animation ? 2 : 0));
            by = (byte)(by | (this.Locked ? 4 : 0));
            dataOutputStream.writeByte(by);
            dataOutputStream.writeByte(this.volume);
            dataOutputStream.writeByte(this.missions[0]);
            dataOutputStream.writeByte(this.missions[1]);
            for (byte by2 = 0; by2 < this.saves; by2 = (byte)(by2 + 1)) {
                dataOutputStream.writeInt(this.saveSize[by2]);
                dataOutputStream.writeUTF(this.saveStr[by2]);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, true);
                recordStore.setRecord(recordEnumeration.nextRecordId(), byArray, 0, byArray.length);
            }
            byArray = null;
            byteArrayOutputStream = null;
            dataOutputStream = null;
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadValues() {
        this.missions[0] = 0;
        this.missions[1] = 0;
        for (byte by = 0; by < this.saves; by = (byte)(by + 1)) {
            this.saveSize[by] = 0;
        }
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"values", (boolean)true);
            if (recordStore.getNumRecords() == 1) {
                RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, true);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(recordStore.getRecord(recordEnumeration.nextRecordId()));
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                byte by = dataInputStream.readByte();
                this.Vibration = (by & 1) == 1;
                this.Animation = (by & 2) == 2;
                this.Locked = (by & 4) == 4;
                this.volume = dataInputStream.readByte();
                this.missions[0] = dataInputStream.readByte();
                this.missions[1] = dataInputStream.readByte();
                for (byte by2 = 0; by2 < this.saves; by2 = (byte)(by2 + 1)) {
                    this.saveSize[by2] = dataInputStream.readInt();
                    this.saveStr[by2] = dataInputStream.readUTF();
                }
                byteArrayInputStream = null;
                dataInputStream = null;
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setVolume() {
        if (this.sndVolume != null) {
            this.sndVolume.setLevel(this.volume * 10);
        }
    }

    private void sndLoad() {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("/snd/splash.mid");
            this.sndSplash = Manager.createPlayer((InputStream)inputStream, (String)"audio/midi");
            inputStream = null;
            this.sndSplash.realize();
            this.sndSplash.setLoopCount(10);
            this.sndVolume = (VolumeControl)this.sndSplash.getControl("VolumeControl");
        }
        catch (Exception exception) {
            System.err.println("CMenu.sndLoad(): " + exception.toString());
        }
    }

    private void sndPlay() {
        try {
            this.setVolume();
            this.sndSplash.start();
        }
        catch (Exception exception) {
            System.err.println("CMenu.sndPlay(): " + exception.toString());
        }
    }

    private void sndStop() {
        try {
            if (this.sndSplash.getState() == 400) {
                this.sndSplash.stop();
                this.sndSplash.setMediaTime(0L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sndDelete() {
        if (this.sndSplash != null) {
            this.sndSplash.close();
            this.sndSplash = null;
        }
    }

    public void addMission(byte by, byte by2) {
        if (this.missions[by] < (by2 = (byte)(by2 + 1))) {
            this.missions[by] = by2;
            this.saveValues();
        }
    }

    public void release() {
        this.imgTitle = null;
        this.imgSplash = null;
        this.imgLogo = null;
        this.imgMenu = null;
        this.sndDelete();
    }
}

