/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class CGame {
    private Player snd = null;
    private CMenu Menu = null;
    private CCanvas Can = null;
    private CCursor Cursor = null;
    public Random rand = null;
    private byte mission = 0;
    private byte state = (byte)-1;
    public static final byte STATE_LOADING = 0;
    public static final byte STATE_PLAY = 1;
    public static final byte STATE_INFO = 3;
    public static final byte STATE_OBJECTIVES = 4;
    public static final byte STATE_WIN = 5;
    public static final byte STATE_NEXT_LEVEL = 6;
    public static final byte STATE_LOSE = 7;
    public static final byte STATE_GAME_END = 8;
    public static final byte PHASE_TURN = 0;
    public static final byte PHASE_SEEK = 1;
    public static final byte PHASE_SELECTION = 2;
    public static final byte PHASE_ACTION = 3;
    public static final byte PHASE_MOVING = 4;
    public static final byte PHASE_MOVED = 5;
    public static final byte PHASE_ATTACK = 6;
    public static final byte PHASE_ENDTURN = 7;
    public static final byte PHASE_DESTINATION = 8;
    private byte phase = 0;
    private String text = null;
    private static final byte chIdx = 10;
    private int[] strIdx = new int[50];
    private byte strCount = 0;
    private final byte[] maxStr = new byte[]{3, 5};
    public static final byte idh = 4;
    private boolean drawAtt = false;
    private byte attCh = 0;
    private byte comPlayer = 0;
    private byte comCount = (byte)2;
    private byte comTurn = 0;
    private byte[][] comCursor = new byte[this.comCount][2];
    private byte unitSide = 0;
    private static final byte maxUnits = 40;
    private CUnit[] Units = new CUnit[40];
    private byte[][] uIdx = new byte[this.comCount][40 / this.comCount];
    private byte[] uCount = new byte[this.comCount];
    private byte selected = 0;
    private byte target = 0;
    private byte[] unitMap = null;
    private static final byte maxExp = 20;
    private CExplosion[] Explosion = new CExplosion[20];
    public static final int wCell = 44;
    public static final int hCell = 22;
    private int xanim = 0;
    private int yanim = 0;
    public static final byte frames = 4;
    public static final byte vx = 5;
    public static final byte vy = 2;
    private static final byte imgCount = 34;
    private Image[] imgLand = new Image[34];
    private Image[] imgTools = new Image[2];
    private Image[] imgToolTile = new Image[3];
    private Image imgThink = null;
    public static final byte LAND_GROUND = 0;
    public static final byte LAND_WATER = 1;
    public static final byte LAND_EXPLOSED = 2;
    public static final byte LAND_TRENCH = 3;
    public static final byte LAND_ROAD = 4;
    public static final byte LAND_BRIDGE = 5;
    public static final byte LAND_WOOD = 6;
    public static final byte LAND_ROCK = 7;
    public static final byte LAND_AIRPORT = 8;
    public static final byte LAND_BUILDING = 9;
    public static final byte landTypes = 10;
    private static final byte[] landDef = new byte[]{2, -3, 3, 7, 0, 0, 5, 6, 8, 9};
    public static final byte[] landType = new byte[]{0, 1, 14, 17, 18, 24, 26, 27, 28, 30, 34};
    private byte wMap = 0;
    private byte hMap = 0;
    private int mapSize = 0;
    private byte[] Map = null;
    private byte phaseAI = 0;
    private int[] moveWeights = null;
    private byte[] xTmp = null;
    private byte[] yTmp = null;
    private int steps = 0;
    private byte xSel = 0;
    private byte ySel = 0;
    private byte[] xMove = null;
    private byte[] yMove = null;
    private int moveSteps = 0;
    private byte[][] moveGrid = new byte[70][2];
    private byte mmCount = 0;
    private byte curStep = 0;
    private byte fastSelection = 0;
    private boolean firstLoad = true;
    private boolean showObjectives = false;
    private boolean cpuAnyAttack = false;

    public CGame(CCanvas cCanvas, CMenu cMenu, byte by) {
        this.Can = cCanvas;
        this.Menu = cMenu;
        this.comPlayer = by;
        this.firstLoad = true;
        this.Cursor = new CCursor(this.Can);
        this.rand = new Random();
    }

    public void start(byte by) {
        this.mission = by;
        this.setState((byte)0);
    }

    public void loadLevel(byte[] byArray) {
        int n;
        this.freeMem();
        this.loadMap(byArray);
        this.moveWeights = new int[this.mapSize];
        this.xTmp = new byte[this.mapSize];
        this.yTmp = new byte[this.mapSize];
        this.xMove = new byte[this.mapSize];
        this.yMove = new byte[this.mapSize];
        this.comCursor = new byte[this.comCount][2];
        for (n = 0; n < this.comCount; ++n) {
            this.comCursor[n][0] = this.Units[this.uIdx[n][0]].xMap;
            this.comCursor[n][1] = this.Units[this.uIdx[n][0]].yMap;
        }
        this.Cursor.x = this.comCursor[this.comPlayer][0];
        this.Cursor.y = this.comCursor[this.comPlayer][1];
        this.curTypeDefine();
        for (n = 0; n < 20; ++n) {
            this.Explosion[n].dead = true;
        }
        this.selected = (byte)-1;
    }

    private int getDeadUnit() {
        for (int i = 0; i < 40; ++i) {
            if (this.Units[i].health != 0) continue;
            return i;
        }
        return 0;
    }

    private CUnit addUnit(int n, byte by, byte by2, int n2, int n3) {
        int n4 = this.getDeadUnit();
        this.Units[n4].create(this, n, by, by2, n2, n3);
        this.uIdx[n][this.uCount[n]] = (byte)n4;
        int n5 = n;
        this.uCount[n5] = (byte)(this.uCount[n5] + 1);
        return this.Units[n4];
    }

    public void commandAction(boolean bl) {
        if (bl) {
            this.keyPressed(53);
        } else {
            switch (this.state) {
                case 1: {
                    if (!this.Cursor.active) {
                        return;
                    }
                    switch (this.phase) {
                        case 2: {
                            this.Menu.setType((byte)4);
                            break;
                        }
                        case 3: {
                            this.steps = 0;
                            this.setPhase((byte)2);
                            break;
                        }
                        case 5: {
                            this.Units[this.selected].xMap = this.xSel;
                            this.Units[this.selected].yMap = this.ySel;
                            this.Units[this.selected].setSide(this.unitSide);
                            this.createUnitsMap();
                            this.phase = (byte)3;
                            this.createMoveMap();
                            this.curTypeDefine();
                            break;
                        }
                        case 7: {
                            this.setPhase((byte)2);
                        }
                    }
                    break;
                }
                case 3: 
                case 4: {
                    this.keyPressed(53);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void keyPressed(int n) {
        block33: {
            int n2 = this.Can.getGameAction(n);
            block0 : switch (this.state) {
                case 1: {
                    if (this.comTurn != this.comPlayer || !this.Cursor.active) {
                        return;
                    }
                    switch (this.phase) {
                        case 2: {
                            switch (n) {
                                case 49: 
                                case 51: {
                                    if (this.target == -1) break;
                                    this.setState((byte)3);
                                    break;
                                }
                                case 42: {
                                    this.switchUnit(this.fastSelection - 1);
                                    return;
                                }
                                case 35: {
                                    this.switchUnit(this.fastSelection + 1);
                                    return;
                                }
                            }
                        }
                        case 3: 
                        case 5: {
                            switch (n2) {
                                case 8: {
                                    if (this.Cursor.moveDir != -1) break;
                                    this.cursorAction();
                                    return;
                                }
                                case 1: {
                                    if (this.Cursor.x >= this.wMap - 1) break;
                                    this.Cursor.setMoveDir(n2);
                                    return;
                                }
                                case 6: {
                                    if (this.Cursor.x <= 0) break;
                                    this.Cursor.setMoveDir(n2);
                                    return;
                                }
                                case 2: {
                                    if (this.Cursor.y <= 0) break;
                                    this.Cursor.setMoveDir(n2);
                                    return;
                                }
                                case 5: {
                                    if (this.Cursor.y >= this.hMap - 1) break;
                                    this.Cursor.setMoveDir(n2);
                                }
                            }
                            return;
                        }
                        case 7: {
                            if (n2 != 8) break;
                            this.setPhase((byte)0);
                        }
                    }
                    return;
                }
                case 3: 
                case 4: {
                    switch (n2) {
                        case 8: {
                            this.setState((byte)1);
                            if (!this.showObjectives) return;
                            this.showObjectives = false;
                            if (!this.setCur2Dest()) return;
                            this.setPhase((byte)8);
                            this.yanim = 30;
                            break block0;
                        }
                        case 1: {
                            if (this.xanim <= 0) return;
                            --this.xanim;
                            if (this.state == 3) {
                                this.drawInfo();
                                break block0;
                            }
                            this.drawObjectives();
                            break block33;
                        }
                        case 6: {
                            if (this.xanim + this.maxStr[this.state == 3 ? 0 : 1] >= this.strCount) return;
                            ++this.xanim;
                            if (this.state == 3) {
                                this.drawInfo();
                                break block0;
                            }
                            this.drawObjectives();
                        }
                    }
                }
            }
        }
    }

    public void keyReleased(int n) {
    }

    private void switchUnit(int n) {
        byte by;
        if (n < 0) {
            n = this.uCount[this.comTurn] - 1;
        } else if (n >= this.uCount[this.comTurn]) {
            n = 0;
        }
        this.fastSelection = (byte)n;
        this.target = by = this.uIdx[this.comTurn][this.fastSelection];
        this.Cursor.x = this.Units[by].xMap;
        this.Cursor.y = this.Units[by].yMap;
        this.Cursor.type = (byte)-1;
    }

    private void cursorAction() {
        switch (this.Cursor.type) {
            case -3: 
            case -2: {
                switch (this.phase) {
                    case 5: {
                        this.Units[this.selected].moveMade = true;
                        this.setPhase((byte)2);
                        break;
                    }
                    case 7: {
                        this.setPhase((byte)0);
                        break;
                    }
                    case 2: {
                        this.setPhase((byte)7);
                    }
                }
                break;
            }
            case -1: {
                this.setPhase((byte)3);
                break;
            }
            case 0: 
            case 2: 
            case 3: {
                this.attackPrepare();
                break;
            }
            case 1: {
                this.setPhase((byte)4);
                break;
            }
            case 4: {
                int n = this.Units[this.selected].yMap * this.wMap + this.Units[this.selected].xMap;
                this.Map[n] = landType[3];
                this.Units[this.selected].landDef = landDef[3];
                this.Units[this.selected].moveMade = true;
                this.setPhase((byte)2);
            }
        }
    }

    private void attackPrepare() {
        if (this.attCh > 0) {
            this.Units[this.selected].setSide(this.Units[this.target]);
            this.change(this.target);
            this.setPhase((byte)6);
        }
    }

    public void setState(byte by) {
        this.phase = 0;
        this.state = by;
        this.xanim = 0;
        this.yanim = 0;
        this.text = null;
        switch (this.state) {
            case 0: {
                break;
            }
            case 1: {
                this.setPhase((byte)2);
                break;
            }
            case 3: {
                this.text = this.Units[this.target].getInfo();
                this.strCount = this.Can.textPrepare(this.text, 128 - 10, this.strIdx);
                this.drawInfo();
                break;
            }
            case 4: {
                this.text = this.objText(this.mission);
                this.strCount = this.Can.textPrepare(this.text, 128 - 10, this.strIdx);
                this.drawLevel();
                this.drawObjectives();
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                this.sndLoad(2);
                this.sndPlay();
            }
        }
    }

    private boolean setCur2Dest() {
        int n = 0;
        int n2 = 0;
        block0 : switch (this.comPlayer) {
            case 0: {
                switch (this.mission) {
                    case 0: {
                        n = 8;
                        n2 = 2;
                        break block0;
                    }
                    case 1: {
                        n = 1;
                        n2 = 1;
                        break block0;
                    }
                }
                return false;
            }
            case 1: {
                switch (this.mission) {
                    case 20: {
                        break block0;
                    }
                }
                return false;
            }
        }
        this.Cursor.x = n;
        this.Cursor.y = (byte)n2;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean lose() {
        switch (this.comPlayer) {
            case 0: {
                switch (this.mission) {
                    case 9: {
                        if (this.Units[this.uIdx[1][0]].health > 0) break;
                        return true;
                    }
                }
                break;
            }
        }
        if (this.uCount[this.comPlayer] > 0) return false;
        return true;
    }

    private boolean win() {
        block0 : switch (this.comPlayer) {
            case 0: {
                switch (this.mission) {
                    case 0: {
                        if (this.Units[0].xMap < 8 || this.Units[0].yMap != 2 || this.uCount[1] != 0) break block0;
                        return true;
                    }
                    case 1: {
                        if (this.Units[0].xMap < 1 || this.Units[0].yMap != 1) break block0;
                        return true;
                    }
                    case 9: {
                        if (this.uCount[1] != 1 || this.Units[this.uIdx[1][0]].type != 5) break block0;
                        return true;
                    }
                }
                if (this.uCount[1] != 0) break;
                return true;
            }
            case 1: {
                switch (this.mission) {
                    default: 
                }
                if (this.uCount[0] != 0) break;
                return true;
            }
        }
        return false;
    }

    private void setPhase(byte by) {
        this.Cursor.active = false;
        this.phase = by;
        this.xanim = 0;
        this.yanim = 0;
        this.phaseAI = 0;
        this.createUnitsMap();
        switch (this.phase) {
            case 0: {
                for (int i = 0; i < this.uCount[this.comTurn]; ++i) {
                    this.Units[this.uIdx[this.comTurn][i]].moveMade = false;
                }
                this.comCursor[this.comTurn][0] = this.Cursor.x;
                this.comCursor[this.comTurn][1] = this.Cursor.y;
                do {
                    this.comTurn = (byte)(this.comTurn + 1);
                    if (this.comTurn < this.comCount) continue;
                    this.comTurn = 0;
                } while (this.uCount[this.comTurn] <= 0);
                this.text = this.comTurn % 2 == 0 ? new String("Allied turn") : new String("Axis turn");
                this.selected = (byte)-1;
                break;
            }
            case 1: {
                this.goTo(this.comCursor[this.comTurn][0], this.comCursor[this.comTurn][1]);
                this.Cursor.active = true;
                break;
            }
            case 2: {
                if (this.lose()) {
                    this.setState((byte)7);
                    break;
                }
                if (this.win()) {
                    this.setState((byte)5);
                    break;
                }
                this.selected = (byte)-1;
                this.Cursor.active = true;
                this.curTypeDefine();
                break;
            }
            case 3: {
                this.Cursor.active = true;
                this.selected = this.target;
                this.change(this.selected);
                this.xSel = this.Cursor.x;
                this.ySel = this.Cursor.y;
                this.getMoveMap(this.Units[this.selected]);
                this.createMoveMap();
                this.curTypeDefine();
                break;
            }
            case 4: {
                this.unitSide = this.Units[this.selected].getSide();
                this.getTrajectory(this.Units[this.selected].xMap, this.Units[this.selected].yMap);
                for (int i = 0; i < this.steps; ++i) {
                    this.xMove[i] = this.xTmp[this.steps - 1 - i];
                    this.yMove[i] = this.yTmp[this.steps - 1 - i];
                }
                this.moveSteps = this.steps;
                this.addTrajectory(this.Units[this.selected]);
                this.Cursor.type = (byte)-2;
                break;
            }
            case 5: {
                this.steps = 0;
                this.curTypeDefine();
                this.Cursor.active = true;
                break;
            }
            case 6: {
                this.xanim = 20;
                this.drawAtt = this.state == 1;
                this.attackUnit(this.Units[this.selected], this.Units[this.target], this.state == 1);
                break;
            }
            case 7: {
                this.Cursor.active = true;
                this.text = new String("End turn?");
            }
        }
    }

    private void attackUnit(CUnit cUnit, CUnit cUnit2, boolean bl) {
        cUnit.attack(cUnit2, this.attCh);
        if (bl && cUnit.ATTACK > 0) {
            this.sndPlay();
            if (cUnit2.count > 0) {
                int n = cUnit2.xScr;
                int n2 = cUnit2.yScr - 11;
                this.createExp((byte)0, n, n2, 0, 20, 0, true);
            } else {
                this.unitExplode(cUnit2);
            }
        }
    }

    private void drawExplosion(int n, int n2, boolean bl) {
        for (int i = n; i < n2; ++i) {
            if (this.Explosion[i].dead) continue;
            this.Explosion[i].draw(this.Can.scrGrap, bl);
        }
    }

    private void change(byte by) {
        byte by2 = this.Units[by].getCom();
        for (int i = 0; i < this.uCount[by2]; ++i) {
            if (this.uIdx[by2][i] != by) continue;
            this.uIdx[by2][i] = this.uIdx[by2][this.uCount[by2] - 1];
            this.uIdx[by2][this.uCount[by2] - 1] = by;
            return;
        }
        System.err.println("CGame.change() error!");
    }

    public void draw() {
        switch (this.state) {
            case 1: {
                this.tact();
                this.drawLevel();
                this.drawInterface();
                break;
            }
            case 0: {
                this.drawLoading();
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.drawWin();
                break;
            }
            case 6: {
                this.drawNextLevel();
                break;
            }
            case 7: {
                this.drawLose();
                break;
            }
            case 8: {
                this.drawGameEnd();
            }
        }
    }

    private void drawGameEnd() {
        switch (this.phase) {
            case 0: {
                this.release();
                try {
                    this.imgTools[0] = Image.createImage((String)("/img/win" + this.comPlayer + ".png"));
                }
                catch (Exception exception) {
                    System.err.println("CGame.drawGameEnd(): " + exception.toString());
                }
                this.phase = (byte)(this.phase + 1);
                break;
            }
            case 1: {
                this.yanim += 10;
                if (this.yanim < 128 >> 1) {
                    this.Can.scrGrap.setColor(0, 0, 0);
                    this.Can.scrGrap.fillRect(0, 0, 128, this.yanim);
                    this.Can.scrGrap.fillRect(0, 128 - this.yanim, 128, this.yanim);
                    this.Can.scrGrap.setColor(0, 150, 0);
                    this.Can.scrGrap.drawLine(0, this.yanim, 128, this.yanim);
                    this.Can.scrGrap.drawLine(0, 128 - this.yanim, 128, 128 - this.yanim);
                    break;
                }
                this.Can.scrGrap.setColor(0, 0, 0);
                this.Can.scrGrap.fillRect(0, 0, 128, 128);
                this.yanim = 128 >> 1;
                this.phase = (byte)(this.phase + 1);
                break;
            }
            case 2: {
                this.yanim -= 10;
                this.Can.scrGrap.setColor(0, 0, 0);
                this.Can.scrGrap.fillRect(0, 0, 128, 128);
                this.Can.scrGrap.drawImage(this.imgTools[0], 128 >> 1, 128 - 3, 33);
                this.Can.drawString("Congratulations!", 128 >> 1, 5, 17);
                this.Can.drawString("Because of you", 128 >> 1, 18, 17);
                this.Can.drawString("it was possible", 128 >> 1, 28, 17);
                this.Can.drawString("to win the war.", 128 >> 1, 38, 17);
                this.Can.drawString("The enemy is", 128 >> 1, 48, 17);
                this.Can.drawString("finally\u00a0defeated.", 128 >> 1, 58, 17);
                if (this.yanim > 0) {
                    this.Can.scrGrap.setColor(0, 0, 0);
                    this.Can.scrGrap.fillRect(0, 0, this.yanim, 128);
                    this.Can.scrGrap.fillRect(128 - this.yanim, 0, this.yanim, 128);
                    this.Can.scrGrap.setColor(0, 150, 0);
                    this.Can.scrGrap.drawLine(this.yanim, 0, this.yanim, 128);
                    this.Can.scrGrap.drawLine(128 - this.yanim, 0, 128 - this.yanim, 128);
                    break;
                }
                this.yanim = 0;
                this.phase = (byte)(this.phase + 1);
                break;
            }
            case 3: {
                ++this.yanim;
                if (this.yanim <= 150) break;
                this.imgLand[0] = null;
                this.Menu.Locked = false;
                this.Menu.saveValues();
                this.Menu.setType((byte)0);
            }
        }
    }

    private void drawLose() {
        int n = (this.Can.strH << 1) + 6;
        this.tactUnits();
        this.drawLevel();
        switch (this.phase) {
            case 0: {
                this.Can.scrGrap.setColor(0, 150, 0);
                this.Can.scrGrap.drawLine(0, 128 >> 1, 128, 128 >> 1);
                this.xanim = 0;
                this.phase = (byte)(this.phase + 1);
                break;
            }
            case 1: {
                this.xanim += 4;
                this.Can.scrGrap.setClip(0, 128 - this.xanim >> 1, 128, this.xanim);
                this.Can.scrGrap.setColor(0, 0, 0);
                this.Can.scrGrap.fillRect(0, 128 - this.xanim >> 1, 128, this.xanim);
                this.Can.scrGrap.setColor(0, 150, 0);
                this.Can.scrGrap.drawLine(0, 128 - this.xanim >> 1, 128, 128 - this.xanim >> 1);
                this.Can.scrGrap.drawLine(0, 128 + this.xanim >> 1, 128, 128 + this.xanim >> 1);
                this.Can.drawString("MISSION", 128 >> 1, (128 >> 1) - this.Can.strH - 1, 17);
                this.Can.drawString("FAILED", 128 >> 1, (128 >> 1) + 1, 17);
                this.Can.scrGrap.setClip(0, 0, 128, 128);
                if (this.xanim <= n) break;
                this.xanim = 0;
                this.phase = (byte)(this.phase + 1);
                break;
            }
            case 2: {
                this.Can.scrGrap.setColor(0, 0, 0);
                this.Can.scrGrap.fillRect(0, 128 - n >> 1, 128, n);
                this.Can.scrGrap.setColor(0, 150, 0);
                this.Can.scrGrap.drawLine(0, 128 - n >> 1, 128, 128 - n >> 1);
                this.Can.scrGrap.drawLine(0, 128 + n >> 1, 128, 128 + n >> 1);
                this.Can.drawString("MISSION", 128 >> 1, (128 >> 1) - this.Can.strH - 1, 17);
                this.Can.drawString("FAILED", 128 >> 1, (128 >> 1) + 1, 17);
                ++this.xanim;
                if (this.xanim <= 50) break;
                this.Menu.setType((byte)15);
            }
        }
    }

    public void drawLevel() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        this.Can.scrGrap.setColor(0);
        this.Can.scrGrap.fillRect(0, 0, 128, 128);
        int n9 = 128 >> 1;
        int n10 = 128 + 22 - 28 >> 1;
        int n11 = this.Cursor.x + 1;
        int n12 = this.Cursor.y - 4;
        int n13 = n9 + -66 + this.Cursor.dx;
        int n14 = n10 + -55 + this.Cursor.dy;
        int n15 = 4;
        int n16 = 11;
        for (n8 = 0; n8 < n16; ++n8) {
            for (n7 = 0; n7 < n15; ++n7) {
                n6 = n11 + n7;
                n5 = n12 + n7;
                n4 = n13 + n7 * 44;
                n3 = n14;
                if (n6 >= 0 && n6 < this.wMap && n5 >= 0 && n5 < this.hMap) {
                    n2 = n5 * this.wMap + n6;
                    this.drawTile(false, n2, n4, n3);
                    n = this.unitMap[n2];
                    if (n > -3 && n < 0) {
                        this.Can.scrGrap.drawImage(this.imgToolTile[-n], n4, n3, 33);
                        continue;
                    }
                    if (this.selected != n || this.phase != 3 && this.phase != 5) continue;
                    this.Can.scrGrap.setColor(65280);
                    this.Cursor.drawRect(this.Can.scrGrap, n4, n3);
                    continue;
                }
                this.Can.scrGrap.drawImage(this.imgToolTile[0], n4, n3, 33);
            }
            if (n8 % 2 == 0) {
                ++n15;
                --n11;
                n13 -= 22;
                n14 += 11;
                continue;
            }
            --n15;
            ++n12;
            n13 += 22;
            n14 += 11;
        }
        this.drawExplosion(0, 20, false);
        n8 = 0;
        if (this.state == 1) {
            switch (this.phase) {
                case 8: {
                    if (this.xanim / 5 % 2 != 0) break;
                    n8 = 1;
                    this.Cursor.draw(this.Can.scrGrap, n9, n10, false);
                    break;
                }
                case 0: 
                case 4: 
                case 6: 
                case 7: {
                    break;
                }
                default: {
                    n8 = 1;
                    this.Cursor.draw(this.Can.scrGrap, n9, n10, false);
                }
            }
        }
        n11 = this.Cursor.x + 1;
        n12 = this.Cursor.y - 4;
        n13 = n9 + -66 + this.Cursor.dx;
        n14 = n10 + -55 + this.Cursor.dy;
        n15 = 4;
        n16 = 12;
        for (n7 = 0; n7 < n16; ++n7) {
            for (n6 = 0; n6 < n15; ++n6) {
                n5 = n11 + n6;
                n4 = n12 + n6;
                if (n5 < 0 || n5 >= this.wMap || n4 < 0 || n4 >= this.hMap) continue;
                n3 = n6 * 44 + n13;
                n2 = n14;
                n = n4 * this.wMap + n5;
                this.drawTile(true, n, n3, n2);
                byte by = this.unitMap[n];
                if (by < 0) continue;
                this.Units[by].draw(this.Can, n3, n2);
            }
            if (n7 % 2 == 0) {
                ++n15;
                --n11;
                n13 -= 22;
                n14 += 11;
                continue;
            }
            --n15;
            ++n12;
            n13 += 22;
            n14 += 11;
        }
        this.drawExplosion(0, 20, true);
        if (n8 != 0) {
            this.Cursor.draw(this.Can.scrGrap, n9, n10, true);
        }
        if (this.drawAtt) {
            this.drawDamage();
        }
        this.drawFastInfo();
    }

    private void drawInterface() {
        boolean bl = false;
        boolean bl2 = false;
        switch (this.phase) {
            case 0: {
                bl2 = true;
                break;
            }
            case 5: {
                bl = true;
                break;
            }
            case 7: {
                bl = true;
                bl2 = true;
            }
        }
        if (bl) {
            this.drawAsk();
        }
        if (bl2) {
            this.drawTextLine(this.text, true, 128 >> 1);
        }
    }

    private void createUnitsMap() {
        int n;
        for (n = 0; n < this.mapSize; ++n) {
            this.unitMap[n] = -3;
        }
        for (n = 0; n < this.comCount; n = (int)((byte)(n + 1))) {
            for (int i = 0; i < this.uCount[n]; ++i) {
                byte by = this.uIdx[n][i];
                int n2 = this.Units[by].yMap * this.wMap + this.Units[by].xMap;
                this.unitMap[n2] = by;
            }
        }
    }

    private void createMoveMap() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.mmCount; ++n) {
            n2 = this.moveGrid[n][1] * this.wMap + this.moveGrid[n][0];
            this.unitMap[n2] = -1;
        }
        for (n = 0; n < this.steps; ++n) {
            n2 = this.yTmp[n] * this.wMap + this.xTmp[n];
            if (this.unitMap[n2] >= 0) continue;
            this.unitMap[n2] = -2;
        }
    }

    private void drawAsk() {
        this.Can.scrGrap.drawImage(this.imgTools[0], 0, 128 - 2, 36);
        this.Can.scrGrap.drawImage(this.imgTools[1], 128, 128 - 2, 40);
    }

    private void drawTextLine(String string, boolean bl, int n) {
        if (this.text == null) {
            return;
        }
        int n2 = 2;
        int n3 = (bl ? this.Can.strH : this.Can.strH) + (n2 << 1);
        int n4 = 128 - n3 >> 1;
        this.Can.scrGrap.setColor(0, 0, 0);
        this.Can.scrGrap.fillRect(0, n4, 128, n3);
        this.Can.scrGrap.setColor(0, 150, 0);
        this.Can.scrGrap.drawLine(0, n4 - 1, 128, n4 - 1);
        this.Can.scrGrap.drawLine(0, n4 + n3, 128, n4 + n3);
        this.Can.drawString(string, n, n4 + n2, 17);
    }

    private void drawLoading() {
        int n = this.phase == 0 ? this.Can.strH + 4 : this.Can.strH + 8;
        block0 : switch (this.phase) {
            case 0: {
                switch (this.xanim) {
                    case 0: {
                        if (this.firstLoad || this.mission < 0) {
                            ++this.xanim;
                            break;
                        }
                        this.Can.scrGrap.setColor(0);
                        this.Can.scrGrap.fillRect(0, 0, 128, 128);
                        this.Can.drawLoading(0, this.yanim);
                        this.yanim = CCanvas.f(this.yanim, n);
                        if (this.yanim != n) break block0;
                        ++this.xanim;
                        break;
                    }
                    case 1: {
                        this.loadMission();
                        this.yanim = n;
                        ++this.xanim;
                        break;
                    }
                    default: {
                        this.Can.scrGrap.setColor(0);
                        this.Can.scrGrap.fillRect(0, 0, 128, 128);
                        this.yanim = CCanvas.f(this.yanim, 0);
                        this.Can.drawLoading(2, this.yanim);
                        if (this.yanim != 0) break block0;
                        this.phase = (byte)(this.phase + 1);
                        break;
                    }
                }
                break;
            }
            case 1: {
                this.Can.chars[0] = 77;
                this.Can.chars[1] = 73;
                this.Can.chars[2] = 83;
                this.Can.chars[3] = 83;
                this.Can.chars[4] = 73;
                this.Can.chars[5] = 79;
                this.Can.chars[6] = 78;
                this.Can.chars[7] = 32;
                this.mission = (byte)(this.mission + 1);
                if (this.mission < 10) {
                    this.Can.chars[8] = (char)(48 + this.mission);
                    this.xTmp[1] = 9;
                } else {
                    this.Can.chars[8] = (char)(48 + this.mission / 10);
                    this.Can.chars[9] = (char)(48 + this.mission % 10);
                    this.xTmp[1] = 10;
                }
                this.mission = (byte)(this.mission - 1);
                this.Can.scrGrap.setColor(0);
                this.Can.scrGrap.fillRect(0, 0, 128, 128);
                this.Can.scrGrap.setColor(0, 150, 0);
                this.xanim = 0;
                this.yanim = 128 - this.Can.strH >> 1;
                this.yanim -= 4;
                this.phase = (byte)(this.phase + 1);
                break;
            }
            case 2: {
                this.xanim += 15;
                this.Can.scrGrap.drawLine(0, this.yanim, this.xanim, this.yanim);
                this.Can.scrGrap.drawLine(128, this.yanim + n, 128 - this.xanim, this.yanim + n);
                if (this.xanim < 128) break;
                this.xanim = 0;
                this.phase = (byte)(this.phase + 1);
                break;
            }
            case 3: {
                this.xanim += 2;
                this.Can.scrGrap.setClip(0, (128 >> 1) - this.xanim, 128, this.xanim << 1);
                this.Can.drawChars(true, this.Can.chars, 0, this.xTmp[1], 128 >> 1, this.yanim + 4, 17);
                this.Can.scrGrap.setClip(0, 0, 128, 128);
                if (this.xanim <= this.Can.strH) break;
                this.phase = (byte)(this.phase + 1);
                this.xanim = 0;
                break;
            }
            case 4: {
                this.xanim += 5;
                if (this.xanim >= 100) {
                    this.xanim = 0;
                    this.phase = (byte)(this.phase + 1);
                    break;
                }
                this.Can.scrGrap.setColor(this.xanim, this.xanim, 0);
                this.Can.scrGrap.fillRect(0, this.yanim, 128, n);
                this.Can.drawChars(true, this.Can.chars, 0, this.xTmp[1], 128 >> 1, this.yanim + 4, 17);
                this.Can.scrGrap.setColor(0, 150, 0);
                this.Can.scrGrap.drawLine(0, this.yanim, 128, this.yanim);
                this.Can.scrGrap.drawLine(0, this.yanim + n, 128, this.yanim + n);
                break;
            }
            case 5: {
                this.xanim += 10;
                this.Can.scrGrap.setColor(100, 100, 0);
                this.Can.scrGrap.fillRect(0, this.yanim, 128, n);
                this.Can.drawChars(true, this.Can.chars, 0, this.xTmp[1], 128 >> 1, this.yanim + 4, 17);
                this.Can.scrGrap.setColor(200, 200, 0);
                this.Can.scrGrap.drawLine(this.xanim, this.yanim, this.xanim - 10, this.yanim + n);
                --this.xanim;
                this.Can.scrGrap.drawLine(this.xanim, this.yanim, this.xanim - 10, this.yanim + n);
                --this.xanim;
                this.Can.scrGrap.drawLine(this.xanim, this.yanim, this.xanim - 10, this.yanim + n);
                this.xanim += 2;
                this.Can.scrGrap.setColor(0, 150, 0);
                this.Can.scrGrap.drawLine(0, this.yanim, 128, this.yanim);
                this.Can.scrGrap.drawLine(0, this.yanim + n, 128, this.yanim + n);
                if (this.xanim <= 128 + 10) break;
                this.xanim = 0;
                this.phase = (byte)(this.phase + 1);
                break;
            }
            case 6: {
                this.yanim += 2;
                if (this.yanim << 1 >= 128) {
                    this.Can.scrGrap.setColor(0, 0, 0);
                    this.Can.scrGrap.fillRect(0, 0, 128, 128);
                    this.Can.scrGrap.setColor(0, 150, 0);
                    this.Can.scrGrap.drawLine(0, 128 >> 1, 128, 128 >> 1);
                    this.phase = (byte)(this.phase + 1);
                    this.yanim = 128 >> 1;
                    break;
                }
                this.Can.scrGrap.setColor(0, 0, 0);
                this.Can.scrGrap.fillRect(0, 0, 128, this.yanim);
                this.Can.scrGrap.fillRect(0, 128 - this.yanim, 128, this.yanim);
                this.Can.scrGrap.setColor(0, 150, 0);
                this.Can.scrGrap.drawLine(0, this.yanim, 128, this.yanim);
                this.Can.scrGrap.drawLine(0, 128 - this.yanim, 128, 128 - this.yanim);
                break;
            }
            case 7: {
                this.yanim -= 5;
                if (this.yanim <= 0) {
                    this.phase = (byte)(this.phase + 1);
                    this.yanim = 0;
                    break;
                }
                this.drawLevel();
                this.Can.scrGrap.setColor(0, 0, 0);
                this.Can.scrGrap.fillRect(0, 0, 128, this.yanim);
                this.Can.scrGrap.fillRect(0, 128 - this.yanim, 128, this.yanim);
                this.Can.scrGrap.setColor(0, 150, 0);
                this.Can.scrGrap.drawLine(0, this.yanim, 128, this.yanim);
                this.Can.scrGrap.drawLine(0, 128 - this.yanim, 128, 128 - this.yanim);
                break;
            }
            default: {
                this.setState(this.showObjectives ? (byte)4 : 1);
            }
        }
    }

    public byte getMission() {
        return this.mission;
    }

    public byte getCompany() {
        return this.comPlayer;
    }

    private void loadMission() {
        if (this.firstLoad) {
            this.loadImages();
            this.firstLoad = false;
        }
        int n = 0;
        byte[] byArray = null;
        if (this.mission < 0) {
            this.showObjectives = false;
            byArray = this.Menu.loadGame(Math.abs(this.mission) - 1);
            n = byArray.length;
        } else {
            this.showObjectives = true;
            try {
                InputStream inputStream = this.getClass().getResourceAsStream(this.comPlayer + "" + this.mission + ".txt");
                n = inputStream.available();
                byArray = new byte[n];
                inputStream.read(byArray);
                inputStream.close();
            }
            catch (Exception exception) {
                System.err.println("CGame.loadMission(): " + exception.toString());
            }
            for (int i = 0; i < n; ++i) {
                byArray[i] = (byte)(byArray[i] - 65);
            }
        }
        this.loadLevel(byArray);
        this.createUnitsMap();
        this.sndLoad(0);
        this.Menu.addMission(this.comPlayer, this.mission);
    }

    private void curTypeDefine() {
        block24: {
            block23: {
                this.target = (byte)-1;
                this.Cursor.type = (byte)-2;
                if (this.phase == 1) {
                    return;
                }
                int n = this.Cursor.y * this.wMap + this.Cursor.x;
                byte by = this.unitMap[n];
                switch (by) {
                    case -3: {
                        if (this.phase == 3) {
                            this.steps = 0;
                            this.createMoveMap();
                        }
                        return;
                    }
                    case -2: 
                    case -1: {
                        this.getTrajectory(this.Units[this.selected].xMap, this.Units[this.selected].yMap);
                        this.createMoveMap();
                        this.Cursor.type = 1;
                        return;
                    }
                }
                if (this.phase == 3) {
                    this.steps = 0;
                    this.createMoveMap();
                }
                this.target = by;
                if (this.Units[this.target].getCom() != this.comTurn) break block23;
                block4 : switch (this.phase) {
                    case 3: 
                    case 5: {
                        int n2;
                        if (this.selected != this.target) {
                            if (this.Units[this.selected].canAttack(this.Units[this.target])) {
                                this.attCh = this.Units[this.selected].getAttackChance(this.Units[this.target]);
                                if (this.attCh == 100) {
                                    switch (this.Units[this.selected].type) {
                                        case 1: {
                                            this.Cursor.type = (byte)2;
                                            break block4;
                                        }
                                        case 2: {
                                            this.Cursor.type = (byte)3;
                                        }
                                    }
                                    break;
                                }
                            }
                        } else if (this.Units[this.selected].type == 0 && ((n2 = this.getLandType(this.Units[this.selected].yMap * this.wMap + this.Units[this.selected].xMap)) == 0 || n2 == 2)) {
                            this.Cursor.type = (byte)4;
                            break;
                        }
                        break block24;
                    }
                    default: {
                        if (!this.Units[this.target].moveMade) {
                            this.Cursor.type = (byte)-1;
                            break;
                        }
                        break block24;
                    }
                }
                break block24;
            }
            switch (this.phase) {
                case 3: 
                case 5: {
                    this.Cursor.type = (byte)-3;
                    if (this.Units[this.selected].ATTACK <= 0 || !this.Units[this.selected].canAttack(this.Units[this.target])) break;
                    this.attCh = this.Units[this.selected].getAttackChance(this.Units[this.target]);
                    if (this.attCh <= 0) break;
                    this.Cursor.type = 0;
                    break;
                }
                default: {
                    this.Cursor.type = (byte)-3;
                }
            }
        }
    }

    private void getMoveMap(CUnit cUnit) {
        byte by;
        for (by = 0; by < this.mapSize; ++by) {
            this.moveWeights[by] = 1000;
        }
        this.mmCount = 0;
        by = cUnit.SPEED;
        byte by2 = cUnit.getMovePts(this.getLandType(cUnit.yMap * this.wMap + cUnit.xMap));
        this.getPossibleMoves(cUnit, by, -by2, cUnit.xMap, cUnit.yMap);
    }

    private void getPossibleMoves(CUnit cUnit, byte by, int n, int n2, int n3) {
        int n4 = n3 * this.wMap + n2;
        if ((n += cUnit.getMovePts(this.getLandType(n4))) >= this.moveWeights[n4] || n > by) {
            return;
        }
        byte by2 = this.unitMap[n4];
        if (by2 >= 0) {
            if (this.Units[by2].getCom() != this.comTurn) {
                return;
            }
            this.moveWeights[n4] = n;
        } else {
            if (this.moveWeights[n4] == 1000) {
                this.moveGrid[this.mmCount][0] = (byte)n2;
                this.moveGrid[this.mmCount][1] = (byte)n3;
                this.mmCount = (byte)(this.mmCount + 1);
            }
            this.moveWeights[n4] = n;
        }
        if (n == by) {
            return;
        }
        if (n2 > 0) {
            this.getPossibleMoves(cUnit, by, n, n2 - 1, n3);
        }
        if (n2 + 1 < this.wMap) {
            this.getPossibleMoves(cUnit, by, n, n2 + 1, n3);
        }
        if (n3 > 0) {
            this.getPossibleMoves(cUnit, by, n, n2, n3 - 1);
        }
        if (n3 + 1 < this.hMap) {
            this.getPossibleMoves(cUnit, by, n, n2, n3 + 1);
        }
    }

    private void goTo(byte by, byte by2) {
        byte by3 = this.Cursor.x;
        byte by4 = this.Cursor.y;
        this.curStep = 0;
        this.moveSteps = 0;
        while (by != by3 || by2 != by4) {
            if (by != by3) {
                by3 = (byte)(by3 + (by3 > by ? -1 : 1));
            } else {
                by4 = (byte)(by4 + (by4 > by2 ? -1 : 1));
            }
            this.xMove[this.moveSteps] = by3;
            this.yMove[this.moveSteps] = by4;
            ++this.moveSteps;
        }
    }

    public byte getLandDef(int n, int n2) {
        return landDef[this.getLandType(n2 * this.wMap + n)];
    }

    private void getTrajectory(int n, int n2) {
        int n3 = this.Cursor.x;
        int n4 = this.Cursor.y;
        int n5 = 0;
        int n6 = 0;
        this.steps = 0;
        while (n3 != n || n4 != n2) {
            this.xTmp[this.steps] = n3;
            this.yTmp[this.steps] = n4;
            ++this.steps;
            n5 = n3;
            n6 = n4;
            int n7 = n6 * this.wMap + n5;
            int n8 = n4 * this.wMap + n3;
            if (n3 > 0 && this.moveWeights[n7] > this.moveWeights[n8 - 1]) {
                n5 = n3 - 1;
                n6 = n4;
            }
            if (n3 + 1 < this.wMap && this.moveWeights[n7] > this.moveWeights[n8 + 1]) {
                n5 = n3 + 1;
                n6 = n4;
            }
            if (n4 > 0 && this.moveWeights[n7] > this.moveWeights[n8 - this.wMap]) {
                n5 = n3;
                n6 = n4 - 1;
            }
            if (n4 + 1 < this.hMap && this.moveWeights[n7] > this.moveWeights[n8 + this.wMap]) {
                n5 = n3;
                n6 = n4 + 1;
            }
            n3 = (byte)n5;
            n4 = (byte)n6;
        }
    }

    private void getTrajectory(CUnit cUnit, byte by, byte by2) {
        int n;
        this.moveSteps = 0;
        this.steps = 0;
        byte by3 = cUnit.xMap;
        byte by4 = cUnit.yMap;
        byte by5 = cUnit.getMovePts(this.getLandType(by4 * this.wMap + by3));
        for (n = 0; n < this.mapSize; ++n) {
            this.moveWeights[n] = 1000;
        }
        this.moveSearch(cUnit, by3, by4, 0, -by5, by, by2);
        this.moveSteps = this.steps;
        for (n = 0; n < this.moveSteps - 1; ++n) {
            this.xMove[n] = this.xMove[n + 1];
            this.yMove[n] = this.yMove[n + 1];
        }
        --this.moveSteps;
    }

    private void moveSearch(CUnit cUnit, int n, int n2, int n3, int n4, byte by, byte by2) {
        int n5 = n2 * this.wMap + n;
        if ((n4 += cUnit.getMovePts(this.getLandType(n5))) >= this.moveWeights[n5] || n4 >= this.moveWeights[by2 * this.wMap + by]) {
            return;
        }
        this.moveWeights[n5] = n4;
        byte by3 = this.unitMap[n5];
        if (by3 >= 0 && this.Units[by3].getCom() != this.comTurn) {
            return;
        }
        this.xTmp[n3] = (byte)n;
        this.yTmp[n3] = (byte)n2;
        ++n3;
        if (n == by && n2 == by2) {
            this.steps = n3;
            for (int i = 0; i < n3; ++i) {
                this.xMove[i] = this.xTmp[i];
                this.yMove[i] = this.yTmp[i];
            }
            return;
        }
        if (n > 0) {
            this.moveSearch(cUnit, n - 1, n2, n3, n4, by, by2);
        }
        if (n + 1 < this.wMap) {
            this.moveSearch(cUnit, n + 1, n2, n3, n4, by, by2);
        }
        if (n2 > 0) {
            this.moveSearch(cUnit, n, n2 - 1, n3, n4, by, by2);
        }
        if (n2 + 1 < this.hMap) {
            this.moveSearch(cUnit, n, n2 + 1, n3, n4, by, by2);
        }
    }

    private void addTrajectory(CUnit cUnit) {
        byte by = cUnit.xMap;
        byte by2 = cUnit.yMap;
        for (int i = 0; i < this.moveSteps; ++i) {
            if (by != this.xMove[i]) {
                if (this.xMove[i] > by) {
                    this.Units[this.selected].addMove(1);
                    by = (byte)(by + 1);
                    continue;
                }
                this.Units[this.selected].addMove(6);
                by = (byte)(by - 1);
                continue;
            }
            if (this.yMove[i] > by2) {
                this.Units[this.selected].addMove(5);
                by2 = (byte)(by2 + 1);
                continue;
            }
            this.Units[this.selected].addMove(2);
            by2 = (byte)(by2 - 1);
        }
    }

    private int getMaxScore(CUnit cUnit) {
        int n = this.getPositionScore(cUnit, cUnit.xMap, cUnit.yMap);
        for (int i = 0; i < this.mmCount; ++i) {
            int n2 = this.getPositionScore(cUnit, this.moveGrid[i][0], this.moveGrid[i][1]);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private byte cpuSelection() {
        if (this.uCount[this.comTurn] <= 0) {
            return -1;
        }
        boolean bl = false;
        byte by = -1;
        int n = 0;
        for (int i = 0; i < this.uCount[this.comTurn]; ++i) {
            byte by2 = this.uIdx[this.comTurn][i];
            if (this.Units[by2].moveMade) continue;
            this.getMoveMap(this.Units[by2]);
            int n2 = this.getMaxScore(this.Units[by2]);
            if (bl) {
                if (n >= n2) continue;
                by = by2;
                n = n2;
                continue;
            }
            bl = true;
            by = by2;
            n = n2;
        }
        return by;
    }

    private void tactAI() {
        if (this.phaseAI == 0) {
            switch (this.phase) {
                case 2: {
                    byte by = this.cpuSelection();
                    if (by >= 0) {
                        this.Cursor.x = this.Units[by].xMap;
                        this.Cursor.y = this.Units[by].yMap;
                        this.curTypeDefine();
                        this.cursorAction();
                        break;
                    }
                    this.setPhase((byte)0);
                    break;
                }
                case 3: {
                    if (this.mmCount > 0) {
                        int n = this.Units[this.selected].xScr - 1;
                        int n2 = this.Units[this.selected].yScr;
                        n2 = this.Units[this.selected].type <= 5 || this.Units[this.selected].type >= 12 ? (n2 -= 22) : (n2 -= 14);
                        this.Can.scrGrap.drawImage(this.imgThink, n, n2, 36);
                        this.Can.repaintScreen();
                        int n3 = this.cpuMove(this.Units[this.selected]);
                        if (n3 == -1) {
                            this.setPhase((byte)5);
                            break;
                        }
                        this.goTo(this.moveGrid[n3][0], this.moveGrid[n3][1]);
                        this.xanim = 0;
                        this.phaseAI = (byte)(this.phaseAI + 1);
                        break;
                    }
                    this.setPhase((byte)5);
                    break;
                }
                case 5: {
                    byte by = this.cpuAttack(this.Units[this.selected]);
                    if (by >= 0) {
                        this.goTo(this.Units[by].xMap, this.Units[by].yMap);
                        this.xanim = 0;
                        this.phaseAI = (byte)(this.phaseAI + 1);
                        break;
                    }
                    this.Units[this.selected].moveMade = true;
                    this.setPhase((byte)2);
                }
            }
        } else if (this.moveCursor()) {
            this.cursorAction();
        }
    }

    private boolean moveCursor() {
        if (this.Cursor.active) {
            if (this.curStep == this.moveSteps) {
                return true;
            }
            this.Cursor.active = false;
            int n = CGame.getDirection(this.Cursor.x, this.Cursor.y, this.xMove[this.curStep], this.yMove[this.curStep]);
            this.Cursor.setMoveDir(n);
            this.curStep = (byte)(this.curStep + 1);
        }
        return false;
    }

    public static int getDirection(byte by, byte by2, byte by3, byte by4) {
        int n = 0;
        if (by3 != by) {
            n = by3 > by ? 1 : 6;
        } else if (by4 != by2) {
            n = by4 > by2 ? 5 : 2;
        }
        return n;
    }

    private void tact() {
        this.tactUnits();
        if (this.comTurn != this.comPlayer) {
            this.tactAI();
        }
        this.tactExplosion();
        this.tactEngine();
        if (this.Cursor.tact() || this.Cursor.tact()) {
            this.curTypeDefine();
        }
    }

    private void tactUnits() {
        for (byte by = 0; by < this.comCount; by = (byte)(by + 1)) {
            for (int i = 0; i < this.uCount[by]; ++i) {
                byte by2 = this.uIdx[by][i];
                this.Units[by2].tactAnimation();
            }
        }
    }

    private void tactEngine() {
        switch (this.phase) {
            case 0: {
                if (this.yanim > 30) {
                    if (this.comTurn == this.comPlayer) {
                        this.Cursor.x = this.comCursor[this.comTurn][0];
                        this.Cursor.y = this.comCursor[this.comTurn][1];
                    }
                    this.setPhase((byte)2);
                    break;
                }
                ++this.yanim;
                break;
            }
            case 1: {
                if (!this.moveCursor()) break;
                this.setPhase((byte)2);
                break;
            }
            case 3: {
                this.xanim += this.yanim == 0 ? 10 : -10;
                if (this.xanim >= 100) {
                    this.yanim = 1;
                }
                if (this.xanim > 0) break;
                this.yanim = 0;
                break;
            }
            case 4: {
                if (!this.moveUnits()) break;
                this.setPhase((byte)5);
                break;
            }
            case 6: {
                if (this.yanim > 11) {
                    this.drawAtt = false;
                    this.Units[this.target].attacked = false;
                    this.Units[this.target].dx = 0;
                    this.Units[this.target].dy = 0;
                    if (this.inverseAttack()) {
                        this.setPhase((byte)6);
                        return;
                    }
                    this.Units[this.selected].moveMade = true;
                    this.checkDeadUnits(true);
                    this.setPhase((byte)2);
                    break;
                }
                ++this.yanim;
                if (this.xanim <= 4) break;
                --this.xanim;
                break;
            }
            case 8: {
                ++this.xanim;
                if (this.xanim < this.yanim) break;
                this.setPhase((byte)1);
            }
        }
    }

    private boolean moveUnits() {
        boolean bl = true;
        for (byte by = 0; by < this.comCount; by = (byte)(by + 1)) {
            for (int i = 0; i < this.uCount[by]; ++i) {
                byte by2 = this.uIdx[by][i];
                if (!this.Units[by2].move(this)) continue;
                bl = false;
            }
        }
        return bl;
    }

    private boolean inverseAttack() {
        if (this.Units[this.selected].getCom() == this.comTurn) {
            if (this.Units[this.selected].ATTACK > 0 && this.Units[this.target].count > 0 && this.Units[this.target].canAttack(this.Units[this.selected])) {
                this.attCh = this.Units[this.target].getAttackChance(this.Units[this.selected]);
                if (this.attCh > 0) {
                    byte by = this.selected;
                    this.selected = this.target;
                    this.target = by;
                    return true;
                }
            }
        } else {
            byte by = this.selected;
            this.selected = this.target;
            this.target = by;
        }
        return false;
    }

    private void createDebris(int n, int n2, int n3) {
        for (int n4 = 0; n4 < n; n4 = (int)((byte)(n4 + 1))) {
            boolean bl = false;
            for (int i = 0; i < 20; ++i) {
                if (!this.Explosion[i].dead) continue;
                this.Explosion[i].create(this.rand, (byte)1, n2, n3, 0, true);
                bl = true;
                break;
            }
            if (!bl) break;
        }
    }

    private boolean createExp(byte by, int n, int n2, int n3, int n4, int n5, boolean bl) {
        for (int i = n3; i < n4; ++i) {
            if (!this.Explosion[i].dead) continue;
            this.Explosion[i].create(this.rand, by, n, n2, n5, bl);
            return true;
        }
        return false;
    }

    private boolean tactExplosion() {
        boolean bl = true;
        for (int i = 0; i < 20; ++i) {
            if (this.Explosion[i].dead) continue;
            this.Explosion[i].tact();
            bl = false;
        }
        return bl;
    }

    private void drawNextLevel() {
        switch (this.phase) {
            case 0: {
                this.sndLoad(1);
                this.sndPlay();
                this.tact();
                this.drawLevel();
                this.Can.scrGrap.setColor(0, 150, 0);
                this.Can.scrGrap.drawLine(0, 128 >> 1, 128, 128 >> 1);
                this.xanim = 0;
                this.phase = (byte)(this.phase + 1);
                break;
            }
            case 1: {
                this.tact();
                this.drawLevel();
                this.xanim += 4;
                this.Can.scrGrap.setClip(0, 128 - this.xanim >> 1, 128, this.xanim);
                this.Can.scrGrap.setColor(0, 0, 0);
                this.Can.scrGrap.fillRect(0, 128 - this.xanim >> 1, 128, this.xanim);
                this.Can.scrGrap.setColor(0, 150, 0);
                this.Can.scrGrap.drawLine(0, 128 - this.xanim >> 1, 128, 128 - this.xanim >> 1);
                this.Can.scrGrap.drawLine(0, 128 + this.xanim >> 1, 128, 128 + this.xanim >> 1);
                this.Can.drawString("MISSION", 128 >> 1, (128 >> 1) - this.Can.strH - 1, 17);
                this.Can.drawString("COMPLETED", 128 >> 1, (128 >> 1) + 1, 17);
                this.Can.scrGrap.setClip(0, 0, 128, 128);
                if (this.xanim + 4 <= (this.Can.strH << 1) + 6) break;
                this.xanim = 0;
                this.phase = (byte)(this.phase + 1);
                break;
            }
            case 2: {
                this.tact();
                this.drawLevel();
                this.Can.scrGrap.setColor(0, 0, 0);
                this.Can.scrGrap.fillRect(0, (128 >> 1) - this.Can.strH - 3, 128, (this.Can.strH << 1) + 6);
                this.Can.scrGrap.setColor(0, 150, 0);
                this.Can.scrGrap.drawLine(0, (128 >> 1) - this.Can.strH - 3, 128, (128 >> 1) - this.Can.strH - 3);
                this.Can.scrGrap.drawLine(0, (128 >> 1) + this.Can.strH + 3, 128, (128 >> 1) + this.Can.strH + 3);
                this.Can.drawString("MISSION", 128 >> 1, (128 >> 1) - this.Can.strH - 1, 17);
                this.Can.drawString("COMPLETED", 128 >> 1, (128 >> 1) + 1, 17);
                ++this.xanim;
                if (this.xanim <= 50) break;
                this.phase = (byte)(this.phase + 1);
                break;
            }
            case 3: {
                this.mission = (byte)(this.mission + 1);
                this.setState(this.mission < 12 ? (byte)0 : 8);
            }
        }
    }

    private void drawWin() {
        block0 : switch (this.comPlayer) {
            case 0: {
                switch (this.mission) {
                    case 0: {
                        switch (this.phase) {
                            case 0: {
                                ++this.xanim;
                                if (this.xanim <= 5) break;
                                this.xanim = 0;
                                this.phase = (byte)(this.phase + 1);
                                break;
                            }
                            case 1: {
                                if (this.xanim == 0) {
                                    this.addUnit(1, (byte)0, (byte)10, 6, 1).addMove(1);
                                    this.addUnit(1, (byte)0, (byte)10, 7, 6).addMove(2);
                                    this.addUnit(1, (byte)0, (byte)10, 8, 3).addMove(1);
                                    this.createUnitsMap();
                                    ++this.xanim;
                                    break;
                                }
                                ++this.xanim;
                                if (!this.moveUnits()) break;
                                this.createUnitsMap();
                                this.phase = (byte)(this.phase + 1);
                                break;
                            }
                            case 2: {
                                ++this.xanim;
                                if (this.xanim <= 30) break;
                                this.setState((byte)6);
                            }
                        }
                        this.tact();
                        this.drawLevel();
                        break block0;
                    }
                }
                this.setState((byte)6);
                break;
            }
            case 1: {
                switch (this.mission) {
                    default: 
                }
                this.setState((byte)6);
            }
        }
    }

    private void drawDamage() {
        for (byte by = 0; by < this.comCount; by = (byte)(by + 1)) {
            for (int i = 0; i < this.uCount[by]; ++i) {
                int n;
                byte by2 = this.uIdx[by][i];
                if (!this.Units[by2].attacked) continue;
                this.Units[by2].drawHealthLine(this.Can.scrGrap);
                int n2 = this.Can.IntToChars(this.Units[by2].unitsDown, 10);
                ++n2;
                if (this.Cursor.type == 0) {
                    this.Can.chars[10 - n2] = 45;
                    n = this.xanim / 4;
                    if (n > 0) {
                        this.Units[by2].dx = (byte)(this.rand.nextInt() % n);
                        this.Units[by2].dy = (byte)(this.rand.nextInt() % n);
                    }
                } else {
                    this.Can.chars[10 - n2] = 43;
                }
                n = this.Units[by2].xScr;
                int n3 = this.Units[by2].yScr - 11 - this.yanim;
                this.Can.drawChars(false, this.Can.chars, 10 - n2, n2, n, n3, 33);
            }
        }
    }

    private void drawFastInfo() {
        int n = (this.Can.strH + 4 << 1) + 4;
        int n2 = 0;
        int n3 = 128 - n;
        this.Can.scrGrap.setColor(0);
        this.Can.scrGrap.fillRect(0, n3, 128, n);
        this.Can.scrGrap.setColor(43520);
        this.Can.scrGrap.drawLine(0, n3, 128, n3);
        this.Can.scrGrap.drawLine(0, n3 + n - 1, 128, n3 + n - 1);
        int n4 = 80;
        n3 += 4;
        n = this.Can.strH + 4;
        int n5 = this.Cursor.y * this.wMap + this.Cursor.x;
        byte by = landDef[this.getLandType(n5)];
        n2 = this.Can.IntToChars(by, 10);
        if (by < 0) {
            this.Can.chars[10 - ++n2] = 45;
        }
        this.Can.chars[10 - ++n2] = 58;
        this.Can.chars[10 - ++n2] = 102;
        this.Can.chars[10 - ++n2] = 101;
        this.Can.chars[10 - ++n2] = 68;
        this.Can.drawChars(false, this.Can.chars, 10 - n2, n2, n4, n3, 20);
        int n6 = -1;
        if (this.selected != -1) {
            n6 = this.selected;
            n2 = this.Can.IntToChars(this.Units[this.selected].getMovePts(this.getLandType(n5)), 10);
            this.Can.chars[10 - ++n2] = 58;
            this.Can.chars[10 - ++n2] = 101;
            this.Can.chars[10 - ++n2] = 118;
            this.Can.chars[10 - ++n2] = 111;
            this.Can.chars[10 - ++n2] = 77;
            this.Can.drawChars(false, this.Can.chars, 10 - n2, n2, n4, n3 + n, 20);
        }
        if (this.target != -1) {
            n6 = this.target;
        }
        n4 = CUnit.imgMoveDone.getWidth() + 8;
        if (n6 != -1) {
            if (this.Units[n6].moveMade) {
                this.Can.scrGrap.drawImage(CUnit.imgMoveDone, 4, n3, 20);
            }
            n2 = this.Units[n6].getName(this.Can.chars);
            this.Can.drawChars(false, this.Can.chars, 0, n2, n4, n3, 20);
            int n7 = this.Can.charsWidth(this.Can.chars, 0, n2);
            n2 = this.Can.IntToChars(this.Units[n6].count, 10);
            this.Can.chars[10 - ++n2] = 40;
            this.Can.chars[10] = 41;
            this.Can.drawChars(false, this.Can.chars, 10 - ++n2 + 1, n2, n4 + n7, n3, 20);
        }
        if (this.Cursor.type == 0) {
            n2 = this.Can.IntToChars(this.attCh, 10);
            this.Can.chars[10 - ++n2] = 58;
            this.Can.chars[10 - ++n2] = 46;
            this.Can.chars[10 - ++n2] = 99;
            this.Can.chars[10 - ++n2] = 99;
            this.Can.chars[10 - ++n2] = 65;
            this.Can.chars[10] = 37;
            this.Can.drawChars(false, this.Can.chars, 10 - ++n2 + 1, n2, n4, n3 + n, 20);
        }
    }

    private void drawInfo() {
        int n;
        int n2;
        int n3;
        int n4 = 128 - 1;
        int n5 = 128 - 1;
        int n6 = 128 - n4 >> 1;
        this.Can.scrGrap.setColor(0);
        this.Can.scrGrap.fillRect(n6, 0, n4, n5);
        this.Can.scrGrap.setColor(43520);
        this.Can.scrGrap.drawRect(n6, 0, n4, n5);
        int n7 = n6 + 2;
        int n8 = 2;
        int n9 = n4 - 4;
        int n10 = n8;
        int n11 = 38;
        int n12 = 30;
        int n13 = n11;
        int n14 = this.Units[this.target].getName(this.Can.chars);
        this.Can.drawChars(true, this.Can.chars, 0, n14, n7 + 4 + n13, n8 += 4, 20);
        this.Can.scrGrap.drawImage(this.Units[this.target].getImg(), n7 + (n11 >> 1) + 4, (n8 += n12) - (n12 >> 1), 3);
        n14 = this.Can.IntToChars(this.Units[this.target].count, 10);
        this.Can.drawChars(false, this.Can.chars, 10 - n14, n14, n7 + 4 + n13, n8, 36);
        this.Can.drawString("Attack:", n7 + 4, n8 += 4, 20);
        this.Can.drawString("Def.:", n7 + 4, n8 + 4 + this.Can.strH, 20);
        this.Can.drawString("Distance:", n7 + (n9 >> 1) + 4, n8, 20);
        this.Can.drawString("Speed:", n7 + (n9 >> 1) + 4, n8 + 4 + this.Can.strH, 20);
        this.xMove[0] = (byte)Math.abs(this.Units[this.target].ATTACK);
        this.xMove[1] = this.Units[this.target].DEFENCE;
        this.xMove[2] = this.Units[this.target].DISTANCE;
        this.xMove[3] = this.Units[this.target].SPEED;
        for (n3 = 0; n3 < 4; ++n3) {
            byte by;
            n14 = this.Can.IntToChars(this.xMove[n3], 10);
            n2 = n7 + (n3 / 2 == 0 ? (n9 >> 1) - 4 : n9 - 4);
            n = n8 + (this.Can.strH + 4) * (n3 % 2);
            if (n3 == 1 && (by = this.Units[this.target].landDef) != 0) {
                this.Can.drawString(this.xMove[n3] + (by > 0 ? "+" : "") + by, n2, n, 24);
                continue;
            }
            this.Can.drawChars(false, this.Can.chars, 10 - n14, n14, n2, n, 24);
        }
        this.Can.scrGrap.drawRect(n7, n10, n9, (n8 += 4 + this.Can.strH << 1) - n10);
        n10 = n8 += 2;
        this.Can.scrGrap.setColor(this.xanim > 0 ? 0xFFFFFF : 0x555555);
        this.Can.drawTriagle(n7 + (n9 >> 1), n8 += 4, 0, 5);
        n3 = n8 += 9;
        for (n2 = 0; n2 + this.xanim < this.strCount && n2 < this.maxStr[0]; ++n2) {
            n = n2 + this.xanim << 1;
            String string = new String(this.text.substring(this.strIdx[n], this.strIdx[n + 1]));
            this.Can.drawString(string, n7 + (n9 >> 1), n8, 17);
            string = null;
            n8 += this.Can.strH + 4;
        }
        n8 = n3 + 5 + (this.Can.strH + 4) * this.maxStr[0];
        this.Can.scrGrap.setColor(this.xanim + this.maxStr[0] < this.strCount ? 0xFFFFFF : 0x555555);
        this.Can.drawTriagle(n7 + (n9 >> 1), n8, 1, 5);
        this.Can.scrGrap.setColor(43520);
        this.Can.scrGrap.drawRect(n7, n10, n9, (n8 += 4) - n10 + 1);
    }

    private void drawObjectives() {
        int n = 128 - 1;
        int n2 = 105;
        int n3 = 128 - n >> 1;
        int n4 = 128 - n2 >> 1;
        this.Can.scrGrap.setColor(0);
        this.Can.scrGrap.fillRect(n3, n4, n, n2);
        this.Can.scrGrap.setColor(43520);
        this.Can.scrGrap.drawRect(n3, n4, n, n2);
        this.Can.scrGrap.drawRect(n3 += 2, n4 += 2, n -= 4, this.Can.strH + 8);
        n4 += 4;
        this.Can.chars[0] = 79;
        this.Can.chars[1] = 66;
        this.Can.chars[2] = 74;
        this.Can.chars[3] = 69;
        this.Can.chars[4] = 67;
        this.Can.chars[5] = 84;
        this.Can.chars[6] = 73;
        this.Can.chars[7] = 86;
        this.Can.chars[8] = 69;
        this.Can.drawChars(true, this.Can.chars, 0, 9, n3 + (n >> 1), n4, 17);
        this.Can.scrGrap.drawRect(n3, n4 += this.Can.strH + 4 + 2, n, 82);
        this.Can.scrGrap.setColor(this.xanim > 0 ? 0xFFFFFF : 0x555555);
        this.Can.drawTriagle(n3 + (n >> 1), n4 += 4, 0, 5);
        int n5 = n4 += 9;
        for (int i = 0; i + this.xanim < this.strCount && i < this.maxStr[1]; ++i) {
            String string = new String(this.text.substring(this.strIdx[i + this.xanim << 1], this.strIdx[(i + this.xanim << 1) + 1]));
            this.Can.drawString(string, n3 + (n >> 1), n4, 17);
            string = null;
            n4 += this.Can.strH + 4;
        }
        n4 = n5 + 5 + (this.Can.strH + 4) * this.maxStr[1];
        this.Can.scrGrap.setColor(this.xanim + this.maxStr[1] < this.strCount ? 0xFFFFFF : 0x555555);
        this.Can.drawTriagle(n3 + (n >> 1), n4, 1, 5);
        n4 += 4;
    }

    private int getPositionScore(CUnit cUnit, byte by, byte by2) {
        int n = 0;
        byte by3 = cUnit.xMap;
        byte by4 = cUnit.yMap;
        byte by5 = cUnit.landDef;
        cUnit.xMap = by;
        cUnit.yMap = by2;
        cUnit.landDef = this.getLandDef(by, by2);
        for (byte by6 = 0; by6 < this.comCount; by6 = (byte)(by6 + 1)) {
            for (int i = 0; i < this.uCount[by6]; ++i) {
                byte by7 = this.uIdx[by6][i];
                if (cUnit == this.Units[by7]) continue;
                n += cUnit.getAttackScores(this.Units[by7], false);
            }
        }
        cUnit.xMap = by3;
        cUnit.yMap = by4;
        cUnit.landDef = by5;
        return n += cUnit.landDef * 10;
    }

    private int cpuMove(CUnit cUnit) {
        this.cpuAnyAttack = false;
        if (cUnit.maxCount / cUnit.count > 6) {
            return this.cpuBestPosition(cUnit, true);
        }
        int n = -1;
        byte by = cUnit.xMap;
        byte by2 = cUnit.yMap;
        int n2 = this.getPositionScore(cUnit, by, by2);
        for (int i = 0; i < this.mmCount; ++i) {
            int n3;
            int n4 = this.getPositionScore(cUnit, this.moveGrid[i][0], this.moveGrid[i][1]);
            if (!this.compareScores(n2, by2 * this.wMap + by, n4, n3 = this.moveGrid[i][1] * this.wMap + this.moveGrid[i][0])) continue;
            n2 = n4;
            n = i;
            by = this.moveGrid[n][0];
            by2 = this.moveGrid[n][1];
        }
        if (n2 <= landDef[this.getLandType(by2 * this.wMap + by)] * 10) {
            n = this.cpuBestPosition(cUnit, false);
            if (n == -1) {
                this.cpuAnyAttack = true;
                return this.cpuAnyAttackPosition(cUnit);
            }
            return n;
        }
        return n;
    }

    private int cpuAnyAttackPosition(CUnit cUnit) {
        byte by = cUnit.xMap;
        byte by2 = cUnit.yMap;
        int n = this.getPositionScore(cUnit, by, by2);
        boolean bl = n != this.getLandDef(by, by2) * 10;
        for (byte by3 = 0; by3 < this.hMap; by3 = (byte)(by3 + 1)) {
            for (byte by4 = 0; by4 < this.wMap; by4 = (byte)(by4 + 1)) {
                int n2 = 0;
                int n3 = by3 * this.wMap + by4;
                if (this.unitMap[n3] >= 0 || (n2 = this.getPositionScore(cUnit, by4, by3)) == this.getLandDef(by4, by3) * 10) continue;
                if (bl) {
                    if (!this.compareScores(n, by2 * this.wMap + by, n2, n3)) {
                        continue;
                    }
                } else {
                    bl = true;
                }
                by = by4;
                by2 = by3;
                n = n2;
            }
        }
        return bl ? this.getMove(cUnit, by, by2) : -1;
    }

    private int cpuBestPosition(CUnit cUnit, boolean bl) {
        byte by = cUnit.xMap;
        byte by2 = cUnit.yMap;
        int n = this.getPositionScore(cUnit, by, by2);
        for (byte by3 = 0; by3 < this.hMap; by3 = (byte)(by3 + 1)) {
            for (byte by4 = 0; by4 < this.wMap; by4 = (byte)(by4 + 1)) {
                int n2 = 0;
                int n3 = by3 * this.wMap + by4;
                if (this.unitMap[n3] >= 0 || !this.compareScores(n, by2 * this.wMap + by, n2 = this.getPositionScore(cUnit, by4, by3), n3)) continue;
                by = by4;
                by2 = by3;
                n = n2;
            }
        }
        if (!bl && n <= landDef[this.getLandType(by2 * this.wMap + by)] * 10) {
            return -1;
        }
        return this.getMove(cUnit, by, by2);
    }

    private int getMove(CUnit cUnit, byte by, byte by2) {
        this.getTrajectory(cUnit, by, by2);
        int n = -1;
        for (int i = this.moveSteps - 1; i >= 0; --i) {
            boolean bl = false;
            for (int j = 0; j < this.mmCount; ++j) {
                if (this.moveGrid[j][0] != this.xMove[i] || this.moveGrid[j][1] != this.yMove[i]) continue;
                bl = true;
                n = j;
                break;
            }
            if (bl) break;
        }
        return n;
    }

    private boolean compareScores(int n, int n2, int n3, int n4) {
        if (n3 < n) {
            return false;
        }
        if (n3 == n) {
            byte by;
            byte by2 = landDef[this.getLandType(n4)];
            if (by2 < (by = landDef[this.getLandType(n2)])) {
                return false;
            }
            if (by2 == by && this.moveWeights[n4] > this.moveWeights[n2]) {
                return false;
            }
        }
        return true;
    }

    private byte cpuAttack(CUnit cUnit) {
        byte by = -1;
        int n = this.cpuAnyAttack ? Integer.MIN_VALUE : 0;
        for (byte by2 = 0; by2 < this.comCount; by2 = (byte)(by2 + 1)) {
            for (int i = 0; i < this.uCount[by2]; ++i) {
                byte by3 = this.uIdx[by2][i];
                if (cUnit == this.Units[by3]) continue;
                int n2 = 0;
                if (this.cpuAnyAttack) {
                    n2 = cUnit.getAttackScores(this.Units[by3], true);
                    if (n2 == 0) {
                        continue;
                    }
                } else {
                    n2 = cUnit.getAttackScores(this.Units[by3], false);
                }
                if (n2 <= n || !cUnit.canAttack(this.Units[by3])) continue;
                n = n2;
                by = by3;
            }
        }
        return by;
    }

    private void checkDeadUnits(boolean bl) {
        for (byte by = 0; by < this.comCount; by = (byte)(by + 1)) {
            for (int i = 0; i < this.uCount[by]; ++i) {
                byte by2 = this.uIdx[by][i];
                if (this.Units[by2].count != 0) continue;
                if (bl) {
                    byte by3 = by;
                    this.uCount[by3] = (byte)(this.uCount[by3] - 1);
                    this.uIdx[by][i] = this.uIdx[by][this.uCount[by]];
                    continue;
                }
                this.unitExplode(this.Units[by2]);
            }
        }
    }

    private void unitExplode(CUnit cUnit) {
        int n = 10;
        int n2 = cUnit.xScr;
        int n3 = cUnit.yScr - 11;
        this.createExp((byte)0, n2 + this.rand.nextInt() % n, n3 + this.rand.nextInt() % n, 0, 20, 0, true);
        this.createExp((byte)0, n2 + this.rand.nextInt() % n, n3 + this.rand.nextInt() % n, 0, 20, 0, true);
        this.createExp((byte)0, n2 + this.rand.nextInt() % n, n3 + this.rand.nextInt() % n, 0, 20, 0, true);
        this.createExp((byte)0, n2 + this.rand.nextInt() % n, n3 + this.rand.nextInt() % n, 0, 20, 0, true);
        this.createExp((byte)0, n2 + this.rand.nextInt() % n, n3 + this.rand.nextInt() % n, 0, 20, 0, true);
        if (cUnit.type > 5) {
            byte by = (byte)(2 + Math.abs(this.rand.nextInt() % 4));
            this.createDebris(by, n2, n3);
            if (this.rand.nextInt() % 2 == 0) {
                int n4 = cUnit.yMap * this.wMap + cUnit.xMap;
                switch (this.getLandType(n4)) {
                    case 0: 
                    case 4: {
                        this.Map[n4] = (byte)(landType[2] + Math.abs(this.rand.nextInt() % 3));
                    }
                }
            }
        }
        if (cUnit.getCom() == this.comPlayer) {
            this.Can.vibrate();
        }
    }

    private int getLandType(int n) {
        for (int i = 0; i < 10; ++i) {
            if (landType[i + 1] <= this.Map[n]) continue;
            return i;
        }
        return 0;
    }

    private void drawTile(boolean bl, int n, int n2, int n3) {
        byte by = this.Map[n];
        Image image = null;
        if (by >= 26) {
            image = bl ? this.imgLand[by] : this.imgLand[0];
        } else if (!bl) {
            image = this.imgLand[by];
        }
        if (image != null) {
            this.Can.scrGrap.drawImage(image, n2, n3, 33);
        }
    }

    private void loadLevelImgs() {
        this.releaseImages();
        this.Explosion[0].loadImages(this.Can);
        this.Units[0].loadLevelImgs(this.Can);
        try {
            int n;
            Image image = Image.createImage((String)"/img/land0.png");
            this.Can.drawLoading(1, 55);
            int n2 = 4;
            int n3 = 7;
            int n4 = image.getWidth() / n2;
            int n5 = image.getHeight() / n3;
            for (n = 0; n < 26; ++n) {
                this.imgLand[n] = this.Can.createImage(image, n % n2, n / n2, n4, n5, false);
                this.Can.drawLoading(1, 56 + n);
            }
            image = null;
            image = Image.createImage((String)"/img/land1.png");
            this.Can.drawLoading(1, 82);
            n2 = 4;
            n3 = 2;
            n4 = image.getWidth() / n2;
            n5 = image.getHeight() / n3;
            for (n = 0; n < n2 * n3; ++n) {
                this.imgLand[26 + n] = this.Can.createImage(image, n % n2, n / n2, n4, n5, false);
                this.Can.drawLoading(1, 83 + n);
            }
            image = Image.createImage((String)"/img/tools.png");
            this.Can.drawLoading(1, 91);
            n2 = image.getWidth() / 2;
            n3 = image.getHeight();
            for (n = 0; n < 2; ++n) {
                this.imgTools[n] = this.Can.createImage(image, n, 0, n2, n3, false);
                this.Can.drawLoading(1, 92 + n);
            }
            image = null;
            image = Image.createImage((String)"/img/tool_tiles.png");
            this.Can.drawLoading(1, 94);
            n2 = image.getWidth();
            n3 = image.getHeight() / 3;
            for (n = 0; n < 3; ++n) {
                this.imgToolTile[n] = this.Can.createImage(image, 0, n, n2, n3, false);
                this.Can.drawLoading(1, 95 + n);
            }
            image = null;
            this.imgThink = Image.createImage((String)"/img/think.png");
            this.Cursor.loadImages(this.Can);
        }
        catch (Exception exception) {
            System.err.println("Game.loadLevelImages(): " + exception.toString());
        }
    }

    private void loadImages() {
        int n;
        for (n = 0; n < 20; ++n) {
            this.Explosion[n] = new CExplosion();
        }
        for (n = 0; n < 40; ++n) {
            this.Units[n] = new CUnit();
        }
        this.loadLevelImgs();
    }

    public byte[] saveMap() {
        int n;
        int n2;
        int n3 = 2;
        n3 += 2 + this.mapSize;
        ++n3;
        for (n2 = 0; n2 < this.comCount; n2 = (int)((byte)(n2 + 1))) {
            ++n3;
            n3 += this.uCount[n2] * 9;
        }
        n2 = 0;
        byte[] byArray = new byte[n3 += 3];
        byArray[n2] = this.comPlayer;
        byArray[++n2] = this.mission;
        byArray[++n2] = this.wMap;
        byArray[++n2] = this.hMap;
        ++n2;
        for (n = 0; n < this.mapSize; ++n) {
            byArray[n2] = this.Map[n];
            ++n2;
        }
        byArray[n2] = this.comCount;
        ++n2;
        for (n = 0; n < this.comCount; n = (int)((byte)(n + 1))) {
            byArray[n2] = this.uCount[n];
            ++n2;
            for (int i = 0; i < this.uCount[n]; ++i) {
                byte by = this.uIdx[n][i];
                n2 = this.Units[by].save(byArray, n2);
            }
        }
        byArray[n2] = this.comTurn;
        byArray[++n2] = this.Cursor.x;
        byArray[++n2] = this.Cursor.y;
        ++n2;
        return byArray;
    }

    private void loadMap(byte[] byArray) {
        try {
            int n;
            int n2;
            this.comPlayer = byArray[0];
            this.mission = byArray[1];
            this.wMap = byArray[2];
            this.hMap = byArray[3];
            this.mapSize = n2 = this.wMap * this.hMap;
            this.Map = new byte[this.mapSize];
            this.unitMap = new byte[this.mapSize];
            for (n = 0; n < this.mapSize; ++n) {
                this.Map[n] = byArray[4 + n];
            }
            this.comCount = byArray[n2 += 4];
            this.uIdx = new byte[this.comCount][40 / this.comCount];
            this.uCount = new byte[this.comCount];
            ++n2;
            n = 0;
            for (byte by = 0; by < this.comCount; by = (byte)(by + 1)) {
                this.uCount[by] = byArray[n2];
                ++n2;
                for (int i = 0; i < this.uCount[by]; ++i) {
                    n2 = this.Units[n].load(this, byArray, n2, by);
                    this.uIdx[by][i] = n;
                    n = (byte)(n + 1);
                }
            }
            this.comTurn = byArray[n2];
            this.Cursor.x = byArray[n2 + 1];
            this.Cursor.y = byArray[n2 + 2];
            n2 += 3;
        }
        catch (Exception exception) {
            this.Menu.setType((byte)4);
            System.err.println("CGame.loadMap(): " + exception.toString());
        }
    }

    private String objText(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        block0 : switch (this.comPlayer) {
            case 0: {
                switch (n) {
                    case 0: {
                        stringBuffer.append("Investigate territory and discover if there is any enemy presence. If the enemy are detected, destroy them and arrive at destination point. ");
                        break;
                    }
                    case 1: {
                        stringBuffer.append("You are the only one who has survived the ambush. You managed to escape and now your task is to return to the base and inform everyone about the ambush. But be cautious, enemies are everywhere. Seems that the only way is to run through the woods... ");
                        break;
                    }
                    case 2: {
                        stringBuffer.append("After you have successfully reached the base, you told what had happened with your group. Now you have to show the way to your allies that they may crush the enemy, and thus clear the territory. ");
                        break;
                    }
                    case 3: {
                        stringBuffer.append("For the successful defeat\u00a0of the enemy and your courage in the fight, you have been promoted\u00a0to the rank\u00a0of commander.\u00a0The soldiers are now under your command. Your task now is to clear the district of enemy units. ");
                        break;
                    }
                    case 4: {
                        stringBuffer.append("Clear the district of enemy units. ");
                        break;
                    }
                    case 5: {
                        stringBuffer.append("After you have cleared the territory from the enemy, you discovered a building with important strategic information. You must protect it until the commander-in-chief arrives. For this purpose reinforcements are sent to you. ");
                        break;
                    }
                    case 6: {
                        stringBuffer.append("When the plans of the enemy become known, you can attack them where they least expect. Destroy all enemy units. ");
                        break;
                    }
                    case 7: {
                        stringBuffer.append("Having broken through their basic defenses, you invade the enemy base and destroy everything that is in your way. ");
                        break;
                    }
                    case 8: {
                        stringBuffer.append("Destroy all enemy units. ");
                        break;
                    }
                    case 9: {
                        stringBuffer.append("Imprison the enemy general (to this end you must destroy all other enemy units). ");
                        break;
                    }
                    case 10: {
                        stringBuffer.append("Destroy all enemy units. ");
                        break;
                    }
                    case 11: {
                        stringBuffer.append("This mission is the last one in the war and is extremely difficult. Your task is to destroy the central headquarters of the enemy located inside their base that is filled with powerful weapons.  Our hope is with you. We trust you will not let us down. Good luck! ");
                    }
                }
                break;
            }
            case 1: {
                switch (n) {
                    case 0: {
                        stringBuffer.append("To launch a surprise attack, you have to capture a village. Thoroughly scout out the territory and eliminate everyone you meet on your way. ");
                        break block0;
                    }
                    case 1: {
                        stringBuffer.append("With a help of snipers, protect captured object. ");
                        break block0;
                    }
                    case 2: {
                        stringBuffer.append("After capturing an object, the enemy forces that are close will learn of it and march against you. Your task is to hold your positions and not to give the village back to enemy. ");
                        break block0;
                    }
                    case 3: {
                        stringBuffer.append("After capturing a village, your task is to destroy all enemy units. ");
                        break block0;
                    }
                    case 4: 
                    case 7: 
                    case 8: 
                    case 9: {
                        stringBuffer.append("Protect your base. ");
                        break block0;
                    }
                    case 5: {
                        stringBuffer.append("Protect the V.I.P. ");
                        break block0;
                    }
                    case 6: 
                    case 10: {
                        stringBuffer.append("Destroy all enemy units. ");
                        break block0;
                    }
                    case 11: {
                        stringBuffer.append("After numerous battles, you've managed to reach the city. When it is captured the enemy admits defeat,  but do not think victory will be easy. ");
                    }
                }
            }
        }
        return new String(stringBuffer);
    }

    private void releaseImages() {
        int n;
        for (n = 0; n < 3; ++n) {
            this.imgToolTile[n] = null;
        }
        for (n = 0; n < 2; ++n) {
            this.imgTools[n] = null;
        }
        for (n = 0; n < 34; ++n) {
            this.imgLand[n] = null;
        }
        this.imgThink = null;
        this.Cursor.release();
        this.Explosion[0].release(false);
        this.Units[0].releaseImages();
        this.Cursor.release();
    }

    public void release() {
        this.releaseImages();
        this.Explosion[0].release(true);
        this.sndDelete();
    }

    private void freeMem() {
        this.comCursor = null;
        this.uIdx = null;
        this.uCount = null;
        this.hMap = 0;
        this.wMap = 0;
        this.Map = null;
        this.unitMap = null;
        this.moveWeights = null;
        this.xTmp = null;
        this.yTmp = null;
        this.xMove = null;
        this.yMove = null;
    }

    private void sndLoad(int n) {
        this.sndDelete();
        try {
            InputStream inputStream = null;
            switch (n) {
                case 0: {
                    inputStream = this.getClass().getResourceAsStream("/snd/shot.mid");
                    break;
                }
                case 1: {
                    inputStream = this.getClass().getResourceAsStream("/snd/win.mid");
                    break;
                }
                case 2: {
                    inputStream = this.getClass().getResourceAsStream("/snd/lose.mid");
                }
            }
            this.snd = Manager.createPlayer(inputStream, (String)"audio/midi");
            this.snd.realize();
            this.Menu.sndVolume = (VolumeControl)this.snd.getControl("VolumeControl");
            this.Menu.setVolume();
            this.snd.setLoopCount(1);
            inputStream = null;
        }
        catch (Exception exception) {
            System.err.println("CGame.sndLoad(): " + exception.toString());
        }
    }

    private void sndPlay() {
        if (this.Menu.Sounds) {
            try {
                if (this.snd.getState() == 400) {
                    this.snd.stop();
                    this.snd.setMediaTime(0L);
                }
                this.snd.start();
            }
            catch (Exception exception) {
                System.err.println("CGame.sndPlay(): " + exception.toString());
            }
        }
    }

    private void sndDelete() {
        try {
            if (this.snd != null) {
                this.snd.close();
                this.snd = null;
            }
        }
        catch (Exception exception) {
            System.err.println("CGame.sndDelete(): " + exception.toString());
        }
    }
}

