/*
 * Decompiled with CFR 0.152.
 */
package generic;

import generic.ResourceManager;
import generic.SoundEventConstants;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public final class SoundManager
implements PlayerListener {
    public static final int SOUNDTYPE_AMR = 0;
    public static final int SOUNDTYPE_MP3 = 1;
    public static final int SOUNDTYPE_QCP = 2;
    public static final int SOUNDTYPE_MID = 3;
    private static final String[] MIME_TYPES = new String[]{"audio/amr", "audio/mpeg", "audio/vnd.qcelp", "audio/midi"};
    private boolean m_enabled = false;
    private ResourceManager m_resourceManager;
    private int m_currentPlayingSound = -1;
    private int[] m_priorities;
    private int m_soundStartDelay = 0;
    private Player[] m_sounds;
    public static VolumeControl m_volume = null;
    public static int m_volumeLevel = -1;

    public SoundManager(ResourceManager resourceManager) {
        this.m_resourceManager = resourceManager;
        int n = SoundEventConstants.SOUND_DATA_SETS.length;
        this.m_priorities = new int[n];
        this.m_sounds = new Player[n];
    }

    public void playerUpdate(Player player, String string, Object object) {
        if (string.equals("endOfMedia")) {
            this.m_currentPlayingSound = -1;
        }
    }

    public boolean loadSound(int n, int n2, int n3) {
        if (n < 0 || n >= this.m_sounds.length || this.m_sounds[n] != null) {
            return true;
        }
        try {
            short s = SoundEventConstants.SOUND_DATA_SETS[n];
            short s2 = SoundEventConstants.SOUND_DATA_FORMATS[n];
            String string = MIME_TYPES[s2];
            InputStream inputStream = this.m_resourceManager.loadBinaryFile(s);
            this.m_sounds[n] = Manager.createPlayer((InputStream)inputStream, (String)string);
            this.m_sounds[n].addPlayerListener((PlayerListener)this);
            this.m_sounds[n].prefetch();
            this.m_priorities[n] = n3;
            System.gc();
        }
        catch (Exception exception) {
            this.m_sounds[n] = null;
            return false;
        }
        return true;
    }

    public void freeSound(int n) {
        if (n < 0 || n >= this.m_sounds.length || this.m_sounds[n] == null) {
            return;
        }
        this.stopSound(n);
        this.m_sounds[n].deallocate();
        this.m_sounds[n].removePlayerListener((PlayerListener)this);
        this.m_sounds[n].close();
        this.m_sounds[n] = null;
        System.gc();
    }

    public void freeAllSounds() {
        for (int i = 0; i < this.m_sounds.length; ++i) {
            this.stopSound(i);
            this.freeSound(i);
        }
    }

    public void playSound(int n) {
        if (this.m_soundStartDelay > 0) {
            return;
        }
        if (!this.m_enabled || n < 0 || n >= this.m_sounds.length || this.m_sounds[n] == null) {
            return;
        }
        if (this.m_currentPlayingSound != -1) {
            return;
        }
        try {
            this.m_currentPlayingSound = n;
            if (this.m_sounds[n].getState() != 400) {
                m_volume = (VolumeControl)this.m_sounds[n].getControl("VolumeControl");
                if (m_volume != null) {
                    if (m_volumeLevel != -1) {
                        m_volume.setLevel(m_volumeLevel);
                    } else {
                        m_volume.setLevel(50);
                    }
                }
                this.m_sounds[n].start();
            }
        }
        catch (Throwable throwable) {
            this.m_currentPlayingSound = -1;
        }
    }

    public static void setVolume(int n) {
        if (m_volume != null) {
            m_volumeLevel = n;
            m_volume.setLevel(n);
        }
    }

    public void stopSound(int n) {
        if (n < 0 || n >= this.m_sounds.length || this.m_sounds[n] == null) {
            return;
        }
        if (this.m_sounds[n].getState() == 400) {
            try {
                this.m_sounds[n].stop();
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
        if (n == this.m_currentPlayingSound) {
            this.m_currentPlayingSound = -1;
        }
    }

    public void update(int n) {
        if (this.m_soundStartDelay > 0) {
            this.m_soundStartDelay -= n;
        }
    }

    public void appPause() {
    }

    public void appResume() {
    }

    public void stopAllSounds() {
        this.stopSound(this.m_currentPlayingSound);
        this.m_currentPlayingSound = -1;
    }

    public boolean isSoundPlaying(int n) {
        if (n < 0 || n >= this.m_sounds.length || this.m_sounds[n] == null) {
            return false;
        }
        return this.m_sounds[n].getState() == 400;
    }

    public void setEnabled(boolean bl) {
        this.m_enabled = bl;
        if (!this.m_enabled) {
            this.stopAllSounds();
        }
    }

    public boolean getEnabled() {
        return this.m_enabled;
    }
}

