/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.AppEngine;
import game.CarConstants;
import game.EventConstants;
import game.Scene;
import generic.AnimationManager;
import generic.MathExt;
import generic.MixedFont;
import generic.ResourceManager;
import generic.SoundManager;
import javax.microedition.lcdui.Graphics;

final class SceneMenu
extends Scene {
    public static final byte MENU_STATE_SELECT_LANGUAGE = 0;
    public static final byte MENU_STATE_CONFIRMSOUND = 1;
    public static final byte MENU_STATE_EASPLASH = 2;
    public static final byte MENU_STATE_TITLESPLASH = 3;
    public static final byte MENU_STATE_MAINMENU = 4;
    public static final byte MENU_STATE_QUICKRACE_CARSELECT = 5;
    public static final byte MENU_STATE_QUICKRACE_TRACKSELECT = 6;
    public static final byte MENU_STATE_OPTIONS = 7;
    public static final byte MENU_STATE_OPTIONS_LANGUAGE = 8;
    public static final byte MENU_STATE_HELP = 9;
    public static final byte MENU_STATE_ABOUT = 10;
    public static final byte MENU_STATE_CAREER_CAREERPROGRESS = 11;
    public static final byte MENU_STATE_CAREER_TUNERSHOP = 12;
    public static final byte MENU_STATE_CAREER_TUNERSHOP_BUY = 13;
    public static final byte MENU_STATE_CAREER_TUNERSHOP_CONFIRMBUY = 14;
    public static final byte MENU_STATE_CAREER_EVENTHUB = 15;
    public static final byte MENU_STATE_CAREER_CHOOSEEVENT = 16;
    public static final byte MENU_STATE_CAREER_GARAGE_MENU = 17;
    public static final byte MENU_STATE_CAREER_GARAGE_SELECT = 18;
    public static final byte MENU_STATE_NEWCAREER_GARAGE_BUY = 19;
    public static final byte MENU_STATE_NEWCAREER_GARAGE_BUY_CONFIRM = 20;
    public static final byte MENU_STATE_CAREER_GARAGE_BUY = 21;
    public static final byte MENU_STATE_CAREER_GARAGE_BUY_CONFIRM = 22;
    public static final byte MENU_STATE_CAREER_GARAGE_SELL = 23;
    public static final byte MENU_STATE_CAREER_GARAGE_SELL_CONFIRM = 24;
    public static final byte MENU_STATE_POSTRACE_STANDINGS = 25;
    public static final byte MENU_STATE_POSTRACE_AWARDS = 26;
    public static final byte MENU_STATE_POSTRACE_CLEAR_EVENT = 27;
    public static final byte MENU_STATE_POSTRACE_UNLOCK_CODE = 28;
    public static final byte MENU_STATE_POSTRACE_CLEAR_GAME = 29;
    public static final byte MENU_STATE_POSTRACE_SCORECARD = 30;
    public static final byte MENU_STATE_POSTRACE_RACEAGAIN = 31;
    public static final byte MENU_STATE_LOADLEVEL = 32;
    public static final byte MENU_STATE_EXITSCENE = 33;
    public static final byte MENU_STATE_CALL_TO_ACTION = 34;
    public static final byte MENU_STATE_CONFIRMEXIT = 35;
    public static final byte MENU_STATE_CONFIRMRESET = 36;
    private static final byte[] USTATES_CAREER_CASH = new byte[]{18, 11, 19, 21, 13};
    private static final byte MENU_DIRECTION_UPDOWN = 0;
    private static final byte MENU_DIRECTION_LEFTRIGHT = 1;
    private static final byte MENU_DIRECTION_CLAMP = 2;
    private static final byte MENU_RESULT_NONE = 0;
    private static final byte MENU_RESULT_SELECT = 1;
    private static final byte MENU_RESULT_CANCEL = 2;
    private static final byte MENU_RESULT_CHANGE = 3;
    private static final byte MENU_RESULT_TOGGLE = 4;
    private static final int MENU_TITLE_Y = 74;
    private static final int MENU_SELECT_TITLE_Y = 92;
    private static final int MENU_SELECT_ARROW_X = 66;
    private static final int MENU_LEFT = 0;
    private static final int MENU_TOP = 50;
    private static final int CARSELECT_VIEWPORT_TOP = 37;
    private static final int CARSELECT_VIEWPORT_HEIGHT = 132;
    private static final int CONFIRMBOX_WIDTH = 130;
    private static final int CONFIRMBOX_FILLCOLOUR = 0;
    private static final int CONFIRM_BOX_BORDERCOLOUR = 0xBB0000;
    private static final int CAREER_CASH_YPOS = 154;
    private static final int CARSELECT_MENU_QRACE_YPOS = 169;
    private static final int CARSELECT_MENU_SELECT_YPOS = 169;
    private static final int CARSELECT_MENU_BUYSELL_YPOS = 169;
    private static final int CAR_PRICE_YPOS = 178;
    private static final int CARSELECT_LEVEL_BAR_WIDTH = 93;
    private static final int CARSELECT_LEVEL_BAR_MULTIPLIER_F = 0x5D0000;
    private AppEngine m_engine;
    private boolean m_endScene = false;
    private int m_nextScene = -1;
    private byte m_menuState = (byte)-1;
    private byte m_menuSelection = 0;
    private boolean m_confirmBoxDisplayed;
    private static final int SPLASH_TIMEOUT_EA = 3000;
    private static final int SPLASH_TIMEOUT_CALL_TO_ACTION = 5000;
    private static final int SHOW_CALL_OF_ACTION_THIS_MANY_TIMES = 3;
    private static final int SPLASH_TIMEOUT_TITLESPLASH = 2000;
    private static final int CALL_TO_ACTION_TEXT_WIDTH_MULT_F = 55706;
    private int m_splashTimerEA;
    private short[] m_languageMenuStringIDs;
    private short[] m_mainMenuStringIDs;
    private short[] m_levelMenuStrings;
    private short[] m_quickRaceCarSelectMenuStrings;
    private short[] m_optionsMenuLabelsStringIDs;
    private short[] m_optionsMenuValuesStringIDs;
    private short[] m_careerProgressMenuStringIDs;
    private short[] m_careerEventHubMenuStringIDs;
    private short[][] m_careerChooseEventMenuStringIDs;
    private byte m_careerEventHubIndex;
    private short[] m_careerGarageMenuStringIDs;
    private short[] m_careerGarageBuyStringIDs;
    private short[] m_careerGarageSellStringIDs;
    private short[] m_yesNoMenuStringIDs;
    private byte m_tunerShopSelection;
    private short[] m_careerTunerMenuStringIDs;
    private short[] m_careerTunerMenuCompanyNameStringIDs;
    private short[][] m_careerTunerSubMenuStringIDs;
    private short[] m_careerTunerAnimIDs;
    private int[][] m_careerTunerAccessoryBoostsF;
    private short m_carSelectCurrCarID = (short)-1;
    private short m_carSelectCurrAnim = (short)-1;
    private static final int MAX_UPDATE_LOADING_TIME = 64;
    private int m_updateLoadingTime;
    private int m_loadedAnimImages;
    private int m_musicSoundId = -1;
    private int m_lastMusicSoundId = -1;
    private byte[][] m_careerBytesCash;
    private byte[][] m_careerBytesGripsWon;
    private byte[][][][] m_careerBytesTunershop;
    private byte[][] m_careerBytesBuySell;
    private byte[][] m_standingsBytesFinished;
    private byte[][][] m_standingsBytesCars;
    private byte[][][] m_standingsBytesTimes;
    private byte[][] m_standingsBytesDrift;
    private byte[][] m_standingsBytesPurse;
    private byte[][] m_standingsBytesTotal;
    private int m_trackStatsCurPage;
    private int m_trackStatsNumPages;
    private int m_trackStatsNumStatsPerPage;
    private byte[][] m_trackStatsPageBytes;
    private byte[][][] m_trackStatsBytes;
    private boolean[] m_trackStatsIsNew;
    private byte[][] m_awardsTrackLengthBytes;
    private byte[][] m_scorecardSummaryBytes;
    private byte[][][] m_scorecardAwards1Bytes;
    private byte[][] m_scorecardAwards2Bytes;
    private static final short[] QUICKRACE_TRACK_STATS_STRING_IDS = new short[]{101, 102, 103};
    private static final short[] CAREER_TRACK_STATS_STRING_IDS = new short[]{113, 115, 116, 101, 102, 103};
    private static final short[] SCORECARD_SUMMARY_STRING_IDS = new short[]{198, 199, 200};
    private static final short[] SCORECARD_AWARDS1_STRING_IDS = new short[]{201, 103};
    private static final short[] SCORECARD_AWARDS2_STRING_IDS = new short[]{202, 203};
    private static final int WRAP_WIDTH_EVENT_CLEAR = 140;
    private static final int WRAP_WIDTH_GAME_CLEAR = 114;
    private static final int WRAP_WIDTH_CONFIRM_EXIT = 114;
    private static final int WRAP_WIDTH_CONFIRM_RESET = 114;
    private static final int WRAP_WIDTH_CONFIRM_BUYSELL = 114;

    private static final boolean IS_IN(int n, byte[] byArray) {
        for (int i = byArray.length - 1; i >= 0; --i) {
            if (n != byArray[i]) continue;
            return true;
        }
        return false;
    }

    private void initByteArrays() {
        byte[] byArray = this.m_engine.getString(110).getBytes();
        this.m_careerBytesCash = new byte[][]{this.m_engine.getString(125).getBytes(), AppEngine.BYTEARRAY_DOLLARSIGN, AppEngine.intToByteArray(this.m_engine.rmsGetCareerMoney())};
        int n = this.m_engine.rmsGetNumGripRacesFinished();
        this.m_careerBytesGripsWon = n == 0 ? (Object)new byte[][]{AppEngine.stringToByteArray("N"), byArray, AppEngine.stringToByteArray("A")} : (byte[][])new byte[][]{AppEngine.intToByteArray(this.m_engine.rmsGetNumGripRacesWon()), byArray, AppEngine.intToByteArray(this.m_engine.rmsGetNumGripRacesFinished())};
        this.m_careerBytesBuySell = new byte[][]{AppEngine.BYTEARRAY_DOLLARSIGN, AppEngine.BYTEARRAY_EMPTY};
        this.m_standingsBytesFinished = new byte[][]{this.m_engine.getString(111).getBytes(), AppEngine.BYTEARRAY_EMPTY, byArray, AppEngine.BYTEARRAY_EMPTY};
        this.m_standingsBytesDrift = new byte[][]{AppEngine.BYTEARRAY_DOLLARSIGN, AppEngine.intToByteArray(this.m_engine.getLastRaceDriftMoney())};
        this.m_standingsBytesPurse = new byte[][]{AppEngine.BYTEARRAY_DOLLARSIGN, AppEngine.intToByteArray(this.m_engine.getLastRacePurseMoney())};
        this.m_standingsBytesTotal = new byte[][]{AppEngine.BYTEARRAY_DOLLARSIGN, AppEngine.intToByteArray(this.m_engine.getLastRaceDriftMoney() + this.m_engine.getLastRacePurseMoney())};
        this.m_trackStatsPageBytes = new byte[][]{AppEngine.BYTEARRAY_EMPTY, byArray, AppEngine.BYTEARRAY_EMPTY};
    }

    public void start() {
        this.m_engine = AppEngine.getCanvas();
        short[] sArray = new short[]{11, 12, 13};
        this.m_musicSoundId = this.m_engine.getEventHubUnlockLevel() < sArray.length ? sArray[this.m_engine.getEventHubUnlockLevel()] : sArray[this.m_engine.rand(0, sArray.length - 1)];
        this.m_languageMenuStringIDs = new short[]{4, 5, 6, 7, 8};
        this.m_trackStatsNumStatsPerPage = 3;
        this.initByteArrays();
        this.initialiseMenuItemStrings();
        this.initialiseTunerShopItems();
        if (!this.m_engine.m_splashDone) {
            this.loadAnims();
        }
        if (this.m_initialState != -1) {
            this.stateTransition(this.m_initialState);
        } else if (this.m_engine.m_splashDone) {
            if (this.m_engine.isCarNowRacingCareer()) {
                this.stateTransition((byte)25);
            } else {
                this.stateTransition((byte)25);
            }
        } else {
            this.stateTransition((byte)0);
        }
        this.m_engine.saveRMSGameData();
    }

    private void loadAnims() {
        AppEngine appEngine = this.m_engine;
        ResourceManager resourceManager = appEngine.getResourceManager();
        AnimationManager animationManager = appEngine.getAnimationManager();
        animationManager.loadImage(resourceManager, 292);
    }

    private void setSelectedCar(short s) {
        if (s != this.m_carSelectCurrCarID) {
            this.m_carSelectCurrAnim = CarConstants.CAR_MENU_ANIM_IDS[s];
            this.m_carSelectCurrCarID = s;
        }
    }

    private void initialiseMenuItemStrings() {
        int n;
        this.initialiseMainMenuItemStrings();
        this.m_quickRaceCarSelectMenuStrings = new short[this.m_engine.getNumCars()];
        for (n = 0; n < this.m_quickRaceCarSelectMenuStrings.length; ++n) {
            this.m_quickRaceCarSelectMenuStrings[n] = this.m_engine.getCarDescriptionStringID(n);
        }
        this.m_levelMenuStrings = new short[this.m_engine.getNumUnlockedTracks()];
        for (n = 0; n < this.m_levelMenuStrings.length; ++n) {
            byte by = this.m_engine.getNthUnlockedTrack(n);
            this.m_levelMenuStrings[n] = this.m_engine.getTrackNameStringID(by);
        }
        n = 5;
        short[] sArray = new short[n];
        this.m_optionsMenuLabelsStringIDs = sArray;
        int n2 = 0;
        sArray[n2] = 87;
        sArray[++n2] = 88;
        sArray[++n2] = 89;
        sArray[++n2] = 196;
        sArray[++n2] = 3;
        this.updateOptionsValues();
        this.m_careerProgressMenuStringIDs = new short[4];
        this.m_careerProgressMenuStringIDs[0] = 130;
        this.m_careerProgressMenuStringIDs[1] = 131;
        this.m_careerProgressMenuStringIDs[2] = 132;
        this.m_careerProgressMenuStringIDs[3] = 140;
        byte by = Math.min(this.m_engine.getEventHubUnlockLevel() + 1, this.m_engine.getNumEventHubs());
        this.m_careerEventHubMenuStringIDs = new short[by];
        this.m_careerChooseEventMenuStringIDs = new short[by][];
        for (byte by2 = 0; by2 < by; by2 = (byte)(by2 + 1)) {
            this.m_careerEventHubMenuStringIDs[by2] = this.m_engine.getEventHubName(by2);
            byte by3 = this.m_engine.getEventHubEventCount(by2);
            this.m_careerChooseEventMenuStringIDs[by2] = new short[by3];
            for (byte by4 = 0; by4 < by3; by4 = (byte)(by4 + 1)) {
                this.m_careerChooseEventMenuStringIDs[by2][by4] = this.m_engine.getEventHubEventName(by2, by4);
            }
        }
        this.m_yesNoMenuStringIDs = new short[2];
        this.m_yesNoMenuStringIDs[0] = 23;
        this.m_yesNoMenuStringIDs[1] = 22;
        this.initialiseCarBuySellStringIDs();
    }

    private void initialiseTunerShopItems() {
        AppEngine appEngine = this.m_engine;
        short s = this.m_carSelectCurrCarID;
        this.m_careerTunerMenuStringIDs = appEngine.getCareerTunerMenuStringIDs();
        this.m_careerTunerMenuCompanyNameStringIDs = appEngine.getCareerTunerMenuCompanyNameStringIDs();
        this.m_careerTunerAnimIDs = appEngine.getCareerTunerAnimIDs();
        this.m_careerTunerSubMenuStringIDs = new short[4][];
        this.m_careerBytesTunershop = new byte[4][][][];
        this.m_careerTunerAccessoryBoostsF = new int[4][];
        if (s > -1) {
            for (int i = 0; i < 4; ++i) {
                int n;
                short[] sArray = appEngine.getCareerTunerSubMenuStringIDs()[i];
                int[] nArray = appEngine.getCareerTunerAccessoryPrices()[i];
                int[] nArray2 = appEngine.getCareerTunerAccessoryBoostsF()[i];
                this.m_careerTunerSubMenuStringIDs[i] = new short[nArray2.length - n];
                this.m_careerBytesTunershop[i] = new byte[nArray2.length - n][][];
                this.m_careerTunerAccessoryBoostsF[i] = new int[nArray2.length - n];
                int n2 = 0;
                for (n = appEngine.getCarAccessoryLevel(s, i); n < nArray2.length; ++n) {
                    this.m_careerTunerSubMenuStringIDs[i][n2] = sArray[n];
                    this.m_careerBytesTunershop[i][n2] = new byte[2][];
                    this.m_careerBytesTunershop[i][n2][0] = AppEngine.BYTEARRAY_DOLLARSIGN;
                    this.m_careerBytesTunershop[i][n2][1] = AppEngine.intToByteArray(nArray[n]);
                    this.m_careerTunerAccessoryBoostsF[i][n2] = nArray2[n];
                    ++n2;
                }
            }
        }
    }

    private void initialiseMainMenuItemStrings() {
        int n = 5;
        if (this.m_engine.rmsGameExists()) {
            ++n;
        }
        this.m_mainMenuStringIDs = new short[n];
        int n2 = 0;
        this.m_mainMenuStringIDs[n2++] = 31;
        if (this.m_engine.rmsGameExists()) {
            this.m_mainMenuStringIDs[n2++] = 32;
        }
        this.m_mainMenuStringIDs[n2++] = 33;
        this.m_mainMenuStringIDs[n2++] = 34;
        this.m_mainMenuStringIDs[n2++] = 36;
        this.m_mainMenuStringIDs[n2++] = 37;
    }

    private void initialiseCarBuySellStringIDs() {
        byte by;
        int n = 0;
        this.m_careerGarageMenuStringIDs = this.m_engine.getCareerNumCarsOwned() > 1 && this.m_engine.getCareerNumCarsOwned() < this.m_engine.getNumCars() ? new short[3] : new short[2];
        this.m_careerGarageMenuStringIDs[n++] = 149;
        if (this.m_engine.getCareerNumCarsOwned() < this.m_engine.getNumCars()) {
            this.m_careerGarageMenuStringIDs[n++] = 151;
        }
        if (this.m_engine.getCareerNumCarsOwned() > 1) {
            this.m_careerGarageMenuStringIDs[n++] = 148;
        }
        int n2 = this.m_engine.getNumCars() - this.m_engine.getCareerNumCarsOwned();
        this.m_careerGarageBuyStringIDs = new short[n2];
        for (by = 0; by < this.m_careerGarageBuyStringIDs.length; by = (byte)(by + 1)) {
            this.m_careerGarageBuyStringIDs[by] = this.m_engine.getCarDescriptionStringID(this.m_engine.getNthNonOwnedCar(by));
        }
        this.m_careerGarageSellStringIDs = new short[this.m_engine.getCareerNumCarsOwned()];
        for (by = 0; by < this.m_careerGarageSellStringIDs.length; by = (byte)(by + 1)) {
            this.m_careerGarageSellStringIDs[by] = this.m_engine.getCarDescriptionStringID(this.m_engine.getNthOwnedCar(by));
        }
    }

    private void updateOptionsValues() {
        if (this.m_optionsMenuValuesStringIDs == null) {
            this.m_optionsMenuValuesStringIDs = new short[3];
        }
        this.m_optionsMenuValuesStringIDs[0] = this.m_engine.isSoundEnabled() ? 90 : 91;
        this.m_optionsMenuValuesStringIDs[1] = this.m_engine.isVibrationEnabled() ? 90 : 91;
        this.m_optionsMenuValuesStringIDs[2] = this.m_engine.m_rmsCarMarkersEnabled ? 90 : 91;
    }

    public void pause() {
    }

    public void resume() {
    }

    public void end() {
        this.m_engine.unloadImages(0x2000000000000000L);
        this.m_engine.getSoundManager().freeSound(this.m_musicSoundId);
        this.m_engine.requestGC(false);
    }

    public void update(int n) {
        if (this.m_endScene) {
            if (this.m_nextScene == -1) {
                this.m_engine.endGame();
            } else {
                this.m_engine.changeScene(this.m_nextScene);
            }
            return;
        }
        if (this.m_loadingProgress < 100) {
            this.updateLoading(n);
        }
        if (this.m_menuState != 33 && this.m_menuState != 1) {
            this.updateMusic();
        }
        this.m_engine.updateScrollers(n);
        switch (this.m_menuState) {
            case 2: {
                if (this.m_splashTimerEA <= 0) break;
                this.m_splashTimerEA -= n;
                if (this.m_splashTimerEA > 0) break;
                this.fadeStateTransition((byte)3);
                break;
            }
            case 3: {
                this.fadeStateTransition((byte)4);
            }
            case 34: {
                this.m_splashTimerEA -= n;
                if (this.m_splashTimerEA > 0) break;
                this.fadeStateTransition((byte)4);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 15: 
            case 16: {
                this.m_engine.getAnimationManager().updateAnims(n);
                break;
            }
            case 12: 
            case 13: {
                if (this.m_menuState == 13) {
                    int n2 = this.getTunerShopAccessorySelection();
                    if (this.m_careerTunerSubMenuStringIDs[this.m_tunerShopSelection].length == 0 || this.m_engine.rmsGetCareerMoney() < this.m_engine.getCareerTunerAccessoryPrices()[this.m_tunerShopSelection][n2]) {
                        this.m_engine.setSoftKeys(3, 0);
                    } else {
                        this.m_engine.setSoftKeys(3, 6);
                    }
                }
                this.m_engine.getAnimationManager().updateAnims(n);
                break;
            }
            case 5: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: {
                this.updateCarSelect(n);
                break;
            }
            case 19: 
            case 21: {
                if ((this.m_menuState == 21 || this.m_menuState == 19) && this.m_engine.rmsGetCareerMoney() < this.m_engine.getCarPrice(this.m_carSelectCurrCarID)) {
                    this.m_engine.setSoftKeys(3, 0);
                } else {
                    this.m_engine.setSoftKeys(3, 6);
                }
                this.updateCarSelect(n);
            }
        }
        if (this.m_menuState == 32) {
            this.m_nextScene = 1;
            this.fadeStateTransition((byte)33);
        }
    }

    private void updateLoading(int n) {
        if (this.m_updateLoadingTime <= 0 && this.m_loadingProgress < 100) {
            if (this.m_engine.getSoundManager().getEnabled() && !this.m_engine.getSoundManager().isSoundPlaying(this.m_musicSoundId)) {
                this.updateMusic();
                AppEngine.tryDefragMemory(25);
                this.m_updateLoadingTime = 64;
            } else {
                int n2 = 0;
                while (n2 < 1 && this.m_loadedAnimImages < this.m_engine.IMAGE_COUNT) {
                    int n3 = this.m_loadedAnimImages << 1;
                    int n4 = (int)AppEngine.IMAGE_IDS[n3 + 0];
                    long l = AppEngine.IMAGE_IDS[n3 + 1];
                    boolean bl = false;
                    if ((l & 0x2000000000000000L) != 0L) {
                        if (this.m_engine.getAnimationManager().loadImage(this.m_engine.getResourceManager(), n4)) {
                            bl = false;
                            ++n2;
                        } else {
                            bl = true;
                        }
                    }
                    if (!bl) {
                        ++this.m_loadedAnimImages;
                    }
                    this.m_loadingProgress = 15 + 85 * (n2 + this.m_loadedAnimImages) / this.m_engine.IMAGE_COUNT;
                }
                this.m_updateLoadingTime = this.m_loadingProgress < 100 ? 64 : Integer.MAX_VALUE;
            }
        } else {
            this.m_updateLoadingTime -= n;
        }
    }

    private int getTunerShopAccessorySelection() {
        int n = this.m_menuSelection + this.m_engine.getCareerTunerSubMenuStringIDs()[this.m_tunerShopSelection].length - this.m_careerTunerSubMenuStringIDs[this.m_tunerShopSelection].length;
        return n;
    }

    private void updateCarSelect(int n) {
        this.m_engine.getAnimationManager().updateAnims(n);
    }

    public void render(Graphics graphics) {
        if ((this.m_loadingProgress < 100 || this.m_endScene) && this.m_menuState != 2) {
            this.renderMenuBackground(graphics);
            this.m_engine.renderLoadingBar(graphics, this.m_endScene ? 0 : this.m_loadingProgress);
        }
        switch (this.m_menuState) {
            case 0: 
            case 8: {
                this.renderSelectLanguage(graphics);
                break;
            }
            case 1: {
                this.renderConfirmSound(graphics);
                break;
            }
            case 2: {
                this.renderEALogoScreen(graphics);
                break;
            }
            case 34: {
                this.renderCallToActionScreen(graphics);
                break;
            }
            case 3: {
                this.renderTitleSplash(graphics);
                break;
            }
            case 4: {
                this.renderMainMenu(graphics);
                break;
            }
            case 5: {
                this.renderQuickRaceCarSelectScreen(graphics);
                break;
            }
            case 6: {
                this.renderQuickRaceTrackSelectScreen(graphics);
                break;
            }
            case 7: {
                this.renderOptionsMenu(graphics);
                break;
            }
            case 36: {
                this.renderMenuBackground(graphics);
                this.renderConfirmation(graphics, 196);
                break;
            }
            case 9: {
                this.renderHelpScreen(graphics);
                break;
            }
            case 10: {
                this.renderAboutScreen(graphics);
                break;
            }
            case 11: {
                this.renderCareerProgressScreen(graphics);
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                this.renderCareerTunerScreen(graphics);
                break;
            }
            case 15: {
                this.renderCareerEventHubScreen(graphics);
                break;
            }
            case 16: {
                this.renderCareerChooseEventScreen(graphics);
                break;
            }
            case 17: {
                this.renderCareerGarageMenuScreen(graphics);
                break;
            }
            case 19: 
            case 21: {
                this.renderCareerGarageBuyScreen(graphics);
                break;
            }
            case 20: 
            case 22: {
                this.renderCareerGarageBuySellConfirm(graphics, 151);
                break;
            }
            case 23: {
                this.renderCareerGarageSellScreen(graphics);
                break;
            }
            case 24: {
                this.renderCareerGarageBuySellConfirm(graphics, 148);
                break;
            }
            case 18: {
                this.renderCareerGarageSelectScreen(graphics);
                break;
            }
            case 25: {
                this.renderPostRaceStandings(graphics);
                break;
            }
            case 26: {
                this.renderPostRaceAwards(graphics);
                break;
            }
            case 27: {
                this.renderPostRaceClearEvent(graphics);
                break;
            }
            case 28: {
                this.renderPostRaceUnlockCode(graphics);
                break;
            }
            case 29: {
                this.renderPostRaceClearGame(graphics);
                break;
            }
            case 30: {
                this.renderPostRaceScorecard(graphics);
                break;
            }
            case 31: {
                this.renderPostRaceRaceAgain(graphics);
                break;
            }
            case 35: {
                this.renderMenuBackground(graphics);
                this.renderConfirmation(graphics, 20);
            }
        }
    }

    private void renderMenuBackground(Graphics graphics) {
        boolean bl = this.m_engine.getAnimationManager().isImageLoaded(211);
        if (bl) {
            this.m_engine.getAnimationManager().drawAnimFrame(graphics, 328, 0, 0, 0);
        } else {
            graphics.setColor(0);
            graphics.fillRect(0, 0, this.m_engine.getWidth(), this.m_engine.getHeight());
        }
    }

    private void renderMenuTitle(Graphics graphics, short s) {
        this.m_engine.getAnimationManager().drawAnimFrame(graphics, 385, 0, this.m_engine.getHalfWidth(), 74);
        this.m_engine.drawString(graphics, s, this.m_engine.getFont(3), this.m_engine.getHalfWidth(), 74, 3);
    }

    private void renderMenuSelect(Graphics graphics, short s, boolean bl) {
        int n;
        int n2 = this.m_engine.getHalfWidth();
        this.m_engine.getAnimationManager().drawAnimFrame(graphics, 385, 0, n2, 92);
        if (bl) {
            n = 5;
            this.m_engine.getAnimationManager().drawAnimFrame(graphics, 335, 0, n2 - 66, 92);
            this.m_engine.getAnimationManager().drawAnimFrame(graphics, 334, 0, n2 + 66, 92);
        } else {
            n = -5;
        }
        MixedFont mixedFont = this.m_engine.getFont(1);
        int n3 = n2 - 66 + n;
        int n4 = n2 + 66 - n;
        int n5 = n4 - n3;
        this.m_engine.renderScroller(0, graphics, s, mixedFont, n2, 92, n5, 3);
    }

    private void renderSelectLanguage(Graphics graphics) {
        this.renderMenuBackground(graphics);
        this.m_engine.renderMenu(graphics, 0, 140, this.m_languageMenuStringIDs, this.m_menuSelection);
        this.m_engine.renderSoftKeys(graphics);
    }

    private void renderConfirmSound(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        appEngine.getAnimationManager().drawAnimFrame(graphics, 328, 0, 0, 0);
        int n = appEngine.getHalfWidth();
        int n2 = appEngine.getHalfHeight();
        int n3 = appEngine.getStringWidth(46, appEngine.getFont(1)) + 10;
        int n4 = n - (n3 >> 1);
        int n5 = n2 - 10;
        graphics.setColor(0);
        graphics.fillRect(n4 - 5, n5 - 5, n3 + 10, 30);
        appEngine.getAnimationManager().setColor(graphics, 14);
        graphics.fillRect(n4, n5, n3, 20);
        appEngine.drawString(graphics, 46, appEngine.getFont(1), n, n2, 3);
        this.m_engine.renderSoftKeys(graphics);
    }

    private void renderEALogoScreen(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, this.m_engine.getWidth(), this.m_engine.getHeight());
        this.m_engine.getAnimationManager().drawAnimFrame(graphics, 247, 0, this.m_engine.getHalfWidth(), this.m_engine.getHalfHeight());
    }

    private void renderTitleSplash(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, this.m_engine.getWidth(), this.m_engine.getHeight());
        this.m_engine.getAnimationManager().drawAnimFrame(graphics, 382, 0, this.m_engine.getHalfWidth(), this.m_engine.getHalfHeight());
        this.m_engine.renderSoftKeys(graphics);
    }

    private void renderMenuTitledBackground(Graphics graphics) {
        this.m_engine.getAnimationManager().drawAnimFrame(graphics, 330, 0, 0, 0);
    }

    private void renderMainMenu(Graphics graphics) {
        if (this.m_confirmBoxDisplayed) {
            this.renderMenuBackground(graphics);
            this.renderConfirmation(graphics, 33);
            this.m_engine.renderSoftKeys(graphics);
            return;
        }
        this.renderMenuTitledBackground(graphics);
        int n = this.m_mainMenuStringIDs.length * 12 + 10 + 5 >> 1;
        int n2 = this.m_engine.getHalfHeight() - n;
        this.m_engine.renderMenu(graphics, 0, n2, this.m_mainMenuStringIDs, this.m_menuSelection, AppEngine.MENU_WIDTH, 12, 5, 5, 5, 5, 25, true);
        this.m_engine.renderSoftKeys(graphics);
    }

    private void renderQuickRaceTrackSelectScreen(Graphics graphics) {
        this.m_engine.getAnimationManager().drawAnimFrame(graphics, 330, 0, 0, 0);
        this.renderMenuTitle(graphics, (short)145);
        int n = this.m_levelMenuStrings.length * 12 + 10 + 5 >> 1;
        int n2 = this.m_engine.getHalfHeight() - n;
        this.m_engine.renderVerticallyScrolledMenu(graphics, 0, n2, this.m_levelMenuStrings, 8, this.m_menuSelection, 144, 12, 5, 5, 5, 5, 16, true);
        this.m_engine.renderSoftKeys(graphics);
    }

    private void renderLevelBox(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
        int n6;
        int n7;
        int n8 = this.m_engine.getWidth() - 4;
        int n9 = n8 - 93;
        int n10 = n8 - 93;
        this.m_engine.drawString(graphics, n3, this.m_engine.getFont(1), 4, n2, 6);
        if (bl) {
            n7 = 345 + n4;
            n6 = 350 + n4;
        } else {
            n7 = 345;
            n6 = 350;
        }
        this.m_engine.getAnimationManager().drawAnimFrame(graphics, 355, 0, n8, n2);
        graphics.setClip(n9, 0, this.m_engine.getWidth() - n9, this.m_engine.getHeight());
        int n11 = MathExt.Fmul(n5, 0x5D0000) >> 16;
        this.m_engine.getAnimationManager().drawAnimFrame(graphics, n6, 0, n11 + n9, n2);
        graphics.setClip(0, 0, this.m_engine.getWidth(), this.m_engine.getHeight());
        this.m_engine.getAnimationManager().drawAnimFrame(graphics, n7, 0, n10, n2);
    }

    private void renderSelectCar(Graphics graphics, boolean bl, boolean bl2, boolean bl3) {
        int n;
        int n2 = this.m_engine.getHalfWidth();
        if (bl3) {
            n = 140;
            byte by = 0;
            if (bl2) {
                by = this.m_engine.getCarAccessoryLevel(this.m_carSelectCurrCarID, 0);
            }
            this.renderLevelBox(graphics, n2, n, 182, this.m_engine.getCarAccessoryLevel(this.m_carSelectCurrCarID, 0), this.m_engine.getCarValueSpeedF(this.m_carSelectCurrCarID, by), bl2);
            n += 13;
            if (bl2) {
                by = this.m_engine.getCarAccessoryLevel(this.m_carSelectCurrCarID, 1);
            }
            this.renderLevelBox(graphics, n2, n, 183, this.m_engine.getCarAccessoryLevel(this.m_carSelectCurrCarID, 1), this.m_engine.getCarValueAccelF(this.m_carSelectCurrCarID, by), bl2);
            n += 13;
            if (bl2) {
                by = this.m_engine.getCarAccessoryLevel(this.m_carSelectCurrCarID, 2);
            }
            this.renderLevelBox(graphics, n2, n, 184, this.m_engine.getCarAccessoryLevel(this.m_carSelectCurrCarID, 2), this.m_engine.getCarValueHandlingF(this.m_carSelectCurrCarID, by), bl2);
            n += 13;
            if (bl2) {
                by = this.m_engine.getCarAccessoryLevel(this.m_carSelectCurrCarID, 3);
            }
            this.renderLevelBox(graphics, n2, n, 185, this.m_engine.getCarAccessoryLevel(this.m_carSelectCurrCarID, 3), this.m_engine.getCarValueNitroF(this.m_carSelectCurrCarID, by), bl2);
        }
        this.m_engine.getAnimationManager().drawAnimFrame(graphics, this.m_carSelectCurrAnim, 0, this.m_engine.getHalfWidth(), 238);
        if (bl) {
            n = this.m_engine.getHalfWidth() + 50;
            this.m_engine.getAnimationManager().drawAnimFrame(graphics, 332, 0, n, 210);
            this.m_engine.drawChars(graphics, this.m_careerBytesBuySell, this.m_engine.getFont(1), n, 210, 33);
        }
    }

    private void renderQuickRaceCarSelectScreen(Graphics graphics) {
        this.m_engine.getAnimationManager().drawAnimFrame(graphics, 329, 0, 0, 0);
        this.renderMenuTitle(graphics, (short)144);
        this.renderMenuSelect(graphics, this.m_quickRaceCarSelectMenuStrings[this.m_menuSelection], true);
        this.renderSelectCar(graphics, false, false, true);
        this.m_engine.renderSoftKeys(graphics);
    }

    private void renderOptionsMenu(Graphics graphics) {
        this.renderMenuTitledBackground(graphics);
        AnimationManager animationManager = this.m_engine.getAnimationManager();
        int n = animationManager.getAnimFrameWidth(358, 0);
        int n2 = this.m_engine.getWidth() - n >> 1;
        int n3 = n2 + 5;
        int n4 = n3 + 2;
        MixedFont mixedFont = this.m_engine.getFont(1);
        int n5 = this.m_engine.getHalfWidth();
        int n6 = 135;
        animationManager.setColor(graphics, 0);
        graphics.fillRect(n2, n6, n, 16);
        this.m_engine.drawString(graphics, 34, this.m_engine.getFont(3), n4, 143, 6);
        n6 += 22;
        for (int i = 0; i < this.m_optionsMenuLabelsStringIDs.length; ++i) {
            int n7;
            animationManager.drawAnimFrame(graphics, 359, 0, n5, n6);
            if (i == this.m_menuSelection) {
                animationManager.drawAnimFrame(graphics, 335, 0, n5 + 56, n6);
            }
            int n8 = i < this.m_optionsMenuValuesStringIDs.length ? n - 64 : n - 29;
            if (i == this.m_menuSelection) {
                n7 = n - 64;
                this.m_engine.renderScroller(0, graphics, this.m_optionsMenuLabelsStringIDs[i], mixedFont, n5 + -54, n6, n8, 6);
            } else {
                n7 = graphics.getClipX();
                int n9 = graphics.getClipY();
                int n10 = graphics.getClipWidth();
                int n11 = graphics.getClipHeight();
                graphics.setClip(n5 + -54, n9, n8, n11);
                this.m_engine.drawString(graphics, this.m_optionsMenuLabelsStringIDs[i], mixedFont, n5 + -54, n6, 6);
                graphics.setClip(n7, n9, n10, n11);
            }
            if (i < this.m_optionsMenuValuesStringIDs.length) {
                animationManager.drawAnimFrame(graphics, 360, 0, n5 + 46, n6);
                this.m_engine.drawString(graphics, this.m_optionsMenuValuesStringIDs[i], mixedFont, n5 + 46, n6, 10);
            }
            n6 += 13;
        }
        animationManager.drawAnimFrame(graphics, 358, 0, n5, n6 -= 3);
        this.m_engine.renderSoftKeys(graphics);
    }

    private void renderHelpScreen(Graphics graphics) {
        this.renderMenuBackground(graphics);
        this.m_engine.renderHelpAbout(graphics, 37);
        this.m_engine.renderSoftKeys(graphics);
    }

    private void renderAboutScreen(Graphics graphics) {
        this.renderMenuBackground(graphics);
        this.m_engine.renderHelpAbout(graphics, 36);
        this.m_engine.renderSoftKeys(graphics);
    }

    private void renderCareerProgressScreen(Graphics graphics) {
        this.m_engine.getAnimationManager().drawAnimFrame(graphics, 330, 0, 0, 0);
        this.renderMenuTitle(graphics, (short)124);
        AppEngine appEngine = this.m_engine;
        MixedFont mixedFont = appEngine.getFont(1);
        int n = appEngine.getHalfWidth();
        int n2 = 130;
        int n3 = n - 72;
        int n4 = n + 72;
        appEngine.getAnimationManager().drawAnimFrame(graphics, 331, 0, n, n2);
        int n5 = n2 - 43;
        appEngine.drawChars(graphics, this.m_careerBytesCash, mixedFont, n3, n5, 20);
        int n6 = n2 - 32;
        appEngine.drawString(graphics, 126, mixedFont, n3, n6, 20);
        appEngine.drawChars(graphics, this.m_careerBytesGripsWon, mixedFont, n4, n6, 24);
        int n7 = n2 - 21;
        int n8 = n7 + 11;
        appEngine.drawString(graphics, 129, mixedFont, n3, n7, 20);
        int n9 = AppEngine.MENU_WIDTH + 10;
        appEngine.renderScroller(1, graphics, appEngine.getCarDescriptionStringID(appEngine.getPlayerCarIndex()), mixedFont, n3, n8, n9, 20);
        int n10 = n2 + 80;
        appEngine.renderMenu(graphics, 0, n10, this.m_careerProgressMenuStringIDs, this.m_menuSelection);
        int n11 = n;
        int n12 = n2 + 41;
        appEngine.getAnimationManager().drawAnimFrame(graphics, this.m_carSelectCurrAnim, 0, n11, n12);
        appEngine.renderSoftKeys(graphics);
    }

    private void renderCareerTunerScreen(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        MixedFont mixedFont = appEngine.getFont(1);
        AnimationManager animationManager = this.m_engine.getAnimationManager();
        int n = this.m_engine.getHalfWidth() + 11;
        int n2 = this.m_engine.getHalfHeight() + 39;
        this.m_engine.getAnimationManager().drawAnimFrame(graphics, 330, 0, 0, 0);
        int n3 = n;
        int n4 = n2;
        animationManager.drawAnimFrame(graphics, 333, 0, n3, n4);
        animationManager.drawAnimFrame(graphics, this.m_carSelectCurrAnim, 0, n, n2);
        this.renderCareerCashLine(graphics);
        if (this.m_menuState == 12) {
            this.renderMenuTitle(graphics, (short)130);
            this.renderMenuSelect(graphics, this.m_careerTunerMenuStringIDs[this.m_menuSelection], true);
            for (int i = 0; i < 4; ++i) {
                int n5 = this.m_engine.getHalfWidth() - 57;
                short s = this.m_careerTunerAnimIDs[i];
                animationManager.drawAnimFrame(graphics, s, 0, n5 + i * 38, 120);
                if (i != this.m_menuSelection) continue;
                animationManager.drawAnimFrame(graphics, 391, 0, n5 + i * 38, 120);
            }
        } else {
            this.renderMenuTitle(graphics, (short)130);
            this.renderMenuSelect(graphics, this.m_careerTunerMenuCompanyNameStringIDs[this.m_tunerShopSelection], false);
            int n6 = this.m_engine.getHalfWidth();
            short[] sArray = this.m_careerTunerSubMenuStringIDs[this.m_tunerShopSelection];
            byte[][][] byArray = this.m_careerBytesTunershop[this.m_tunerShopSelection];
            if (byArray.length == 0) {
                this.m_engine.drawWrappedString(graphics, mixedFont, 10, n6, 120, 17);
            } else {
                int n7;
                int n8 = n6 - 74;
                int n9 = n6 + 74;
                int n10 = 113;
                for (n7 = 0; n7 < byArray.length; ++n7) {
                    this.m_engine.getAnimationManager().drawAnimFrame(graphics, 356, 0, n6, n10);
                    this.m_engine.drawString(graphics, sArray[n7], this.m_engine.getFont(1), n8, n10 - 3, 36);
                    this.m_engine.drawChars(graphics, byArray[n7], this.m_engine.getFont(1), n9, n10 - 3, 40);
                    if (n7 == this.m_menuSelection) {
                        this.m_engine.getAnimationManager().drawAnimFrame(graphics, 393, 0, n6, n10);
                    }
                    n10 += 13;
                }
                n7 = this.getTunerShopAccessorySelection() + 1;
                int n11 = n10;
                int n12 = this.m_engine.getCarValueF(this.m_carSelectCurrCarID, this.m_tunerShopSelection, n7);
                this.renderLevelBox(graphics, 0, n11, this.m_careerTunerMenuStringIDs[this.m_tunerShopSelection], n7, n12, true);
                if (this.m_menuState == 14) {
                    int n13 = appEngine.getNumWrappedLines() * 8 + 4;
                    int n14 = n6 - 70;
                    int n15 = (n10 += 13) + (this.m_engine.getHeight() - n10 - 17 - n13 >> 1);
                    graphics.setColor(0);
                    graphics.fillRect(n14 - 5, n15 - 5, 150, n13 + 10);
                    appEngine.getAnimationManager().setColor(graphics, 14);
                    graphics.fillRect(n14, n15, 140, n13);
                    appEngine.drawWrappedString(graphics, mixedFont, 8, appEngine.getHalfWidth(), n15 + (n13 >> 1), 3);
                }
            }
        }
        this.m_engine.renderSoftKeys(graphics);
    }

    private void renderCareerEventHubScreen(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        AnimationManager animationManager = appEngine.getAnimationManager();
        MixedFont mixedFont = appEngine.getFont(1);
        this.m_engine.getAnimationManager().drawAnimFrame(graphics, 330, 0, 0, 0);
        this.renderMenuTitle(graphics, (short)132);
        int n = Math.min(appEngine.getEventHubUnlockLevel() + 1, appEngine.getNumEventHubs());
        for (int i = 0; i < n; ++i) {
            animationManager.drawAnimFrame(graphics, appEngine.getEventHubMenuAnimID((byte)i), 0, 41, 119 + i * 39);
            if (i == this.m_menuSelection) {
                appEngine.renderScroller(0, graphics, this.m_careerEventHubMenuStringIDs[i], mixedFont, 41, 119 + i * 39, 160, 6);
            } else {
                appEngine.drawString(graphics, this.m_careerEventHubMenuStringIDs[i], mixedFont, 41, 119 + i * 39, 6);
            }
            if (i != this.m_menuSelection) continue;
            animationManager.drawAnimFrame(graphics, 258, 0, 41, 119 + i * 39);
        }
        this.m_engine.renderSoftKeys(graphics);
    }

    private void renderCareerChooseEventScreen(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        appEngine.getAnimationManager().drawAnimFrame(graphics, 330, 0, 0, 0);
        int n = appEngine.getHalfWidth() - 73;
        this.renderMenuTitle(graphics, (short)132);
        appEngine.getAnimationManager().drawAnimFrame(graphics, appEngine.getEventHubBackdropAnimID(this.m_careerEventHubIndex), 0, appEngine.getHalfWidth(), 100);
        appEngine.drawString(graphics, 133, appEngine.getFont(3), n, 100, 6);
        appEngine.renderMenu(graphics, 0, 125, this.m_careerChooseEventMenuStringIDs[this.m_careerEventHubIndex], this.m_menuSelection);
        int n2 = 135;
        for (byte by = 0; by < (byte)this.m_careerChooseEventMenuStringIDs[this.m_careerEventHubIndex].length; by = (byte)(by + 1)) {
            if (appEngine.getEventClearedStatus(this.m_careerEventHubIndex, by)) {
                appEngine.getAnimationManager().drawAnimFrame(graphics, 300, 0, 16, n2);
            }
            n2 += AppEngine.MENU_LEADING;
        }
        appEngine.renderSoftKeys(graphics);
    }

    private void renderCareerCashLine(Graphics graphics) {
        int n = this.m_engine.getHalfWidth();
        int n2 = this.m_engine.getHeight() - 16;
        int n3 = n - 40;
        this.m_engine.getAnimationManager().setColor(graphics, 0);
        graphics.fillRect(n3, n2 - 14, 80, 14);
        this.m_engine.drawChars(graphics, this.m_careerBytesCash, this.m_engine.getFont(1), n, n2 - 7, 3);
    }

    private void renderCareerGarageMenuScreen(Graphics graphics) {
        this.m_engine.getAnimationManager().drawAnimFrame(graphics, 329, 0, 0, 0);
        this.renderMenuTitle(graphics, (short)131);
        int n = this.m_engine.getHalfHeight() - (this.m_careerGarageMenuStringIDs.length - 1) * AppEngine.MENU_LEADING - AppEngine.MENU_BORDER_HEIGHT - AppEngine.MENU_PADDING_HEIGHT;
        this.m_engine.renderMenu(graphics, 0, n, this.m_careerGarageMenuStringIDs, this.m_menuSelection);
        this.m_engine.renderSoftKeys(graphics);
    }

    private void renderCareerGarageBuySellConfirm(Graphics graphics, int n) {
        this.m_engine.getAnimationManager().drawAnimFrame(graphics, 329, 0, 0, 0);
        this.renderSelectCar(graphics, false, false, false);
        this.renderConfirmation(graphics, n);
        this.m_engine.renderSoftKeys(graphics);
    }

    private void renderCareerGarageBuyScreen(Graphics graphics) {
        this.m_engine.getAnimationManager().drawAnimFrame(graphics, 329, 0, 0, 0);
        this.renderMenuTitle(graphics, (short)147);
        this.renderMenuSelect(graphics, this.m_quickRaceCarSelectMenuStrings[this.m_carSelectCurrCarID], true);
        this.renderSelectCar(graphics, true, true, true);
        this.renderCareerCashLine(graphics);
        if (this.m_engine.rmsGetCareerMoney() < this.m_engine.getCarPrice(this.m_carSelectCurrCarID)) {
            this.renderPadlock(graphics);
        }
        this.m_engine.renderSoftKeys(graphics);
    }

    private void renderCareerGarageSellScreen(Graphics graphics) {
        this.m_engine.getAnimationManager().drawAnimFrame(graphics, 329, 0, 0, 0);
        this.renderMenuTitle(graphics, (short)148);
        this.renderMenuSelect(graphics, this.m_quickRaceCarSelectMenuStrings[this.m_carSelectCurrCarID], true);
        this.renderSelectCar(graphics, true, true, true);
        this.renderCareerCashLine(graphics);
        this.m_engine.renderSoftKeys(graphics);
    }

    private void renderCareerGarageSelectScreen(Graphics graphics) {
        this.m_engine.getAnimationManager().drawAnimFrame(graphics, 329, 0, 0, 0);
        this.renderMenuTitle(graphics, this.m_careerGarageMenuStringIDs[0]);
        boolean bl = this.m_engine.getCareerNumCarsOwned() > 1;
        this.renderMenuSelect(graphics, this.m_quickRaceCarSelectMenuStrings[this.m_carSelectCurrCarID], bl);
        this.renderSelectCar(graphics, false, true, true);
        this.m_engine.renderSoftKeys(graphics);
    }

    private void renderPostRaceStandings(Graphics graphics) {
        this.renderMenuBackground(graphics);
        AppEngine appEngine = this.m_engine;
        AnimationManager animationManager = appEngine.getAnimationManager();
        MixedFont mixedFont = appEngine.getFont(1);
        int[] nArray = this.m_engine.getRaceStandings();
        int n = nArray == null ? 1 : nArray.length;
        int n2 = n * 11;
        int n3 = 146;
        if (nArray == null) {
            n3 = appEngine.getStringWidth(186, mixedFont) + 10;
        }
        int n4 = n3 + 10;
        int n5 = appEngine.getHeight() - (n2 + 16 + 8) >> 1;
        int n6 = n5 + 16;
        int n7 = n6 + n2;
        int n8 = this.m_engine.getHalfWidth() - (n3 >> 1) - 5;
        int n9 = n8 + 5;
        int n10 = n9 + n3;
        int n11 = n9 + 6;
        int n12 = n10 - 21;
        animationManager.setColor(graphics, 0);
        graphics.fillRect(n8, n5, n4, 16);
        graphics.fillRect(n8, n6, 5, n2);
        graphics.fillRect(n10, n6, 5, n2);
        graphics.fillRect(n8, n7, n4, 8);
        animationManager.setColor(graphics, 2);
        graphics.fillRect(n9, n6, n3, n2);
        if (nArray == null) {
            int n13 = n6 + 3 + 2;
            appEngine.drawString(graphics, 186, mixedFont, this.m_engine.getHalfWidth(), n13, 3);
        } else {
            appEngine.drawChars(graphics, this.m_standingsBytesFinished, this.m_engine.getFont(3), n10 - 2, n5 + 8, 10);
            for (int i = 0; i < nArray.length; ++i) {
                if (i == this.m_engine.getPlayerRacePosition()) {
                    animationManager.drawAnimFrame(graphics, 337, 0, n8, n6 + i * 11);
                }
                int n14 = n6 + i * 11 + 3;
                appEngine.drawChars(graphics, this.m_standingsBytesCars[i], mixedFont, n11, n14, 20);
                appEngine.drawChars(graphics, this.m_standingsBytesTimes[i], mixedFont, n12, n14, 24);
            }
        }
        this.m_engine.renderSoftKeys(graphics);
    }

    private void renderPostRaceRaceAgain(Graphics graphics) {
        this.renderMenuBackground(graphics);
        this.renderMenuTitle(graphics, (short)98);
        int n = this.m_engine.getHalfHeight() - AppEngine.MENU_LEADING - AppEngine.MENU_BORDER_HEIGHT - AppEngine.MENU_PADDING_HEIGHT;
        this.m_engine.renderMenu(graphics, 0, n, this.m_yesNoMenuStringIDs, this.m_menuSelection);
        int n2 = n - 23;
        AppEngine appEngine = this.m_engine;
        appEngine.getAnimationManager().drawAnimFrame(graphics, 385, 0, appEngine.getHalfWidth(), n2);
        appEngine.drawString(graphics, 117, appEngine.getFont(1), appEngine.getHalfWidth(), n2, 3);
        this.m_engine.renderSoftKeys(graphics);
    }

    private void renderPostRaceAwards(Graphics graphics) {
        this.renderMenuBackground(graphics);
        AppEngine appEngine = this.m_engine;
        AnimationManager animationManager = appEngine.getAnimationManager();
        MixedFont mixedFont = appEngine.getFont(1);
        MixedFont mixedFont2 = appEngine.getFont(3);
        short[] sArray = this.m_engine.isCarNowRacingCareer() ? CAREER_TRACK_STATS_STRING_IDS : QUICKRACE_TRACK_STATS_STRING_IDS;
        int n = sArray.length % this.m_trackStatsNumStatsPerPage == 0 ? this.m_trackStatsNumStatsPerPage : sArray.length % this.m_trackStatsNumStatsPerPage;
        int n2 = this.m_trackStatsCurPage == this.m_trackStatsNumPages - 1 ? n : this.m_trackStatsNumStatsPerPage;
        int n3 = animationManager.getAnimFrameHeight(383, 0);
        int n4 = animationManager.getAnimFrameWidth(383, 0);
        int n5 = n2 * n3;
        int n6 = animationManager.getAnimFrameHeight(363, 0);
        int n7 = n6 + n5 + 21 + 8;
        int n8 = n4 + 10;
        int n9 = appEngine.getHeight() - n7 >> 1;
        int n10 = n9 + n6;
        int n11 = appEngine.getWidth() - n8 >> 1;
        int n12 = n11 + 5;
        int n13 = n12 + (n4 >> 1);
        int n14 = n9 + animationManager.getAnimFrameFirePointY(363, 0, 0);
        int n15 = n9 + animationManager.getAnimFrameFirePointY(363, 0, 1);
        int n16 = n9 + animationManager.getAnimFrameFirePointY(363, 0, 2);
        int n17 = n12 + n4 - 26;
        int n18 = n17 - 26;
        int n19 = n10 + n5 + 21 - 9;
        int n20 = n13 + animationManager.getAnimFrameFirePointX(383, 0, 0);
        int n21 = n13 + animationManager.getAnimFrameFirePointX(383, 0, 1);
        int n22 = n10 + animationManager.getAnimFrameFirePointY(383, 0, 0);
        int n23 = n10 + animationManager.getAnimFrameFirePointY(383, 0, 1);
        animationManager.drawAnimFrame(graphics, 363, 0, n13, n9);
        animationManager.setColor(graphics, 0);
        graphics.fillRect(n11, n10, 5, n5 + 21);
        graphics.fillRect(n12 + n4, n10, 5, n5 + 21);
        graphics.fillRect(n11, n10 + n5 + 21, n8, 8);
        animationManager.setColor(graphics, 14);
        graphics.fillRect(n12, n10 + n5, n4, 21);
        appEngine.drawString(graphics, 100, mixedFont, n13, n14, 17);
        appEngine.drawString(graphics, appEngine.getTrackNameStringID(appEngine.getCurrTrack()), mixedFont2, n13, n15, 17);
        int n24 = n21 - n20;
        appEngine.renderScroller(0, graphics, this.m_awardsTrackLengthBytes, mixedFont, n13, n16, n24, 17);
        appEngine.drawChars(graphics, this.m_trackStatsPageBytes, mixedFont2, n17, n19, 3);
        appEngine.drawString(graphics, 109, mixedFont2, n18, n19, 10);
        if (this.m_trackStatsCurPage > 0) {
            animationManager.drawAnimFrame(graphics, 362, 0, n17 - 16, n19);
        }
        if (this.m_trackStatsCurPage < this.m_trackStatsNumPages - 1) {
            animationManager.drawAnimFrame(graphics, 361, 0, n17 + 16, n19);
        }
        for (int i = 0; i < n2; ++i) {
            int n25 = i + this.m_trackStatsNumStatsPerPage * this.m_trackStatsCurPage;
            int n26 = this.m_trackStatsIsNew[n25] ? 384 : 383;
            animationManager.drawAnimFrame(graphics, n26, 0, n13, n10 + i * n3);
            appEngine.drawString(graphics, sArray[n25], mixedFont, n20, n22 + i * n3, 20);
            appEngine.drawChars(graphics, this.m_trackStatsBytes[n25], mixedFont, n21, n23 + i * n3, 24);
        }
        this.m_engine.renderSoftKeys(graphics);
    }

    private void initTrackStats() {
        short[] sArray = this.m_engine.isCarNowRacingCareer() ? CAREER_TRACK_STATS_STRING_IDS : QUICKRACE_TRACK_STATS_STRING_IDS;
        this.m_trackStatsCurPage = 0;
        this.m_trackStatsNumPages = sArray.length / this.m_trackStatsNumStatsPerPage;
        this.m_trackStatsPageBytes[0] = AppEngine.intToByteArray(this.m_trackStatsCurPage + 1);
        this.m_trackStatsPageBytes[2] = AppEngine.intToByteArray(this.m_trackStatsNumPages);
        if (this.m_trackStatsBytes == null) {
            int n = this.m_engine.getCurrTrack();
            byte[] byArray = this.m_engine.getString(104).getBytes();
            this.m_awardsTrackLengthBytes = new byte[][]{this.m_engine.getString(30).getBytes(), AppEngine.stringToByteArray(MathExt.fixedToString(this.m_engine.getLastTrackLength() << 3)), this.m_engine.getString(121).getBytes()};
            int n2 = this.m_engine.rmsGetTrackBestLapTime(n);
            int n3 = this.m_engine.rmsGetTrackBestRaceTime(n);
            int n4 = this.m_engine.rmsGetTrackBiggestDriftScores(n);
            int n5 = this.m_engine.getLastRacePurseMoney();
            int n6 = this.m_engine.getLastRaceDriftMoney();
            int n7 = n5 + n6;
            this.m_trackStatsBytes = new byte[sArray.length][][];
            int n8 = 0;
            if (this.m_trackStatsBytes.length > 3) {
                n8 = 3;
                this.m_trackStatsBytes[0] = new byte[][]{AppEngine.BYTEARRAY_DOLLARSIGN, AppEngine.intToByteArray(n5)};
                this.m_trackStatsBytes[1] = new byte[][]{AppEngine.BYTEARRAY_DOLLARSIGN, AppEngine.intToByteArray(n6)};
                this.m_trackStatsBytes[2] = new byte[][]{AppEngine.BYTEARRAY_DOLLARSIGN, AppEngine.intToByteArray(n7)};
                this.m_trackStatsIsNew = new boolean[]{false, false, false, this.m_engine.m_brokeBestLapTimeRecord, this.m_engine.m_brokeBestRaceTimeRecord, this.m_engine.m_brokeBiggestDriftScoreRecord};
            } else {
                this.m_trackStatsIsNew = new boolean[]{this.m_engine.m_brokeBestLapTimeRecord, this.m_engine.m_brokeBestRaceTimeRecord, this.m_engine.m_brokeBiggestDriftScoreRecord};
            }
            this.m_trackStatsBytes[0 + n8] = n2 == 0 ? (Object)new byte[][]{byArray} : AppEngine.fixedToTimeBytes(n2);
            this.m_trackStatsBytes[1 + n8] = n3 == 0 ? (Object)new byte[][]{byArray} : AppEngine.fixedToTimeBytes(n3);
            this.m_trackStatsBytes[2 + n8] = n4 == 0 ? (Object)new byte[][]{byArray} : (byte[][])new byte[][]{AppEngine.BYTEARRAY_DOLLARSIGN, AppEngine.intToByteArray(n4)};
        }
    }

    private void renderPostRaceClearEvent(Graphics graphics) {
        this.renderMenuBackground(graphics);
        AppEngine appEngine = this.m_engine;
        AnimationManager animationManager = appEngine.getAnimationManager();
        MixedFont mixedFont = appEngine.getFont(1);
        MixedFont mixedFont2 = appEngine.getFont(3);
        int n = appEngine.getHalfWidth();
        int n2 = appEngine.getHalfHeight() - animationManager.getAnimFrameHeight(386, 0) - 5;
        int n3 = n2 + 50;
        int n4 = n - 75;
        int n5 = appEngine.getHalfHeight() + animationManager.getAnimFrameHeight(387, 0) + 5;
        int n6 = n5 - 30;
        byte by = appEngine.getCarNowRacingHubIndex();
        int n7 = n2 + animationManager.getAnimFrameFirePointY(386, 0, 0);
        int n8 = n2 + animationManager.getAnimFrameFirePointY(386, 0, 1);
        int n9 = n5 + animationManager.getAnimFrameFirePointY(387, 0, 0);
        int n10 = n5 + animationManager.getAnimFrameFirePointY(387, 0, 1);
        animationManager.drawAnimFrame(graphics, 386, 0, n, n2);
        animationManager.drawAnimFrame(graphics, EventConstants.EVENTS_ANIMS[by << 1], 0, n4, n3);
        appEngine.drawString(graphics, 134, mixedFont2, n, n7, 17);
        appEngine.drawWrappedString(graphics, mixedFont, 9, n, n8, 17);
        appEngine.drawString(graphics, this.m_careerEventHubMenuStringIDs[by], mixedFont, n4, n3, 6);
        animationManager.drawAnimFrame(graphics, 387, 0, n, n5);
        animationManager.drawAnimFrame(graphics, EventConstants.EVENTS_ANIMS[by + 1 << 1], 0, n4, n6);
        appEngine.drawString(graphics, 136, mixedFont2, n, n9, 17);
        appEngine.drawString(graphics, this.m_careerEventHubMenuStringIDs[by + 1], mixedFont, n4, n6, 6);
        this.m_engine.renderSoftKeys(graphics);
    }

    private void renderPostRaceUnlockCode(Graphics graphics) {
        int n;
        this.renderMenuBackground(graphics);
        int n2 = this.m_engine.getWidth() - 20;
        int n3 = this.m_engine.getHeight() - 50;
        int n4 = (this.m_engine.getWidth() >> 1) - (n2 >> 1);
        int n5 = (this.m_engine.getHeight() >> 1) - (n3 >> 1);
        int n6 = n2 - 10 - 10;
        MixedFont mixedFont = this.m_engine.getFont(1);
        int n7 = mixedFont.getLineHeight() + 4;
        int n8 = n = this.m_engine.getWidth() >> 1;
        int n9 = this.m_engine.getHeight() >> 1;
        int n10 = n;
        int n11 = this.m_engine.getHeight() - 25 - 5 - 5;
        this.m_engine.getAnimationManager().setColor(graphics, 0);
        graphics.fillRect(n4, n5, n2, n3);
        this.m_engine.getAnimationManager().setColor(graphics, 14);
        graphics.fillRect(n4 + 5, n5 + 5, n2 - 10, n3 - 10);
        this.m_engine.wrapText(204, mixedFont, n6);
        this.m_engine.drawWrappedString(graphics, mixedFont, n7, n, 35, 17);
        int n12 = this.m_engine.getNumWrappedLines() * n7;
        this.m_engine.wrapText(205, mixedFont, n6);
        this.m_engine.drawWrappedString(graphics, mixedFont, n7, n10, n11, 33);
        int n13 = this.m_engine.getNumWrappedLines() * n7;
        int n14 = this.m_engine.getHeight() - (this.m_engine.getHeight() - n11 + n13) - (35 + n12);
        int n15 = 35 + n12 + (n14 >> 1);
        this.m_engine.getAnimationManager().setColor(graphics, 3);
        graphics.fillRect(15, n15 - 2, n2 - 10, n7);
        switch (this.m_engine.getEventHubUnlockLevel()) {
            case 1: {
                this.m_engine.drawString(graphics, 206, mixedFont, n8, n15, 17);
                break;
            }
            case 2: {
                this.m_engine.drawString(graphics, 207, mixedFont, n8, n15, 17);
                break;
            }
            default: {
                this.m_engine.drawString(graphics, 208, mixedFont, n8, n15, 17);
            }
        }
        this.m_engine.renderSoftKeys(graphics);
    }

    private void renderPostRaceClearGame(Graphics graphics) {
        this.renderMenuBackground(graphics);
        AppEngine appEngine = this.m_engine;
        AnimationManager animationManager = appEngine.getAnimationManager();
        MixedFont mixedFont = appEngine.getFont(1);
        MixedFont mixedFont2 = appEngine.getFont(3);
        int n = appEngine.getHalfWidth();
        int n2 = 6 + animationManager.getAnimFrameFirePointY(340, 0, 0);
        int n3 = 6 + animationManager.getAnimFrameFirePointY(340, 0, 1);
        int n4 = appEngine.getHeight() - 18;
        int n5 = n4 + animationManager.getAnimFrameFirePointY(339, 0, 0);
        animationManager.drawAnimFrame(graphics, 340, 0, n, 6);
        appEngine.drawString(graphics, 134, mixedFont2, n, n2, 17);
        appEngine.drawString(graphics, 137, mixedFont2, n, n3, 17);
        animationManager.drawAnimFrame(graphics, 339, 0, n, n4);
        appEngine.drawWrappedString(graphics, mixedFont, 9, n, n5, 17);
        this.m_engine.renderSoftKeys(graphics);
    }

    private void renderPostRaceScorecard(Graphics graphics) {
        int n;
        this.renderMenuBackground(graphics);
        AppEngine appEngine = this.m_engine;
        AnimationManager animationManager = appEngine.getAnimationManager();
        MixedFont mixedFont = appEngine.getFont(1);
        MixedFont mixedFont2 = appEngine.getFont(3);
        int n2 = appEngine.getHalfWidth();
        int n3 = 6 + animationManager.getAnimFrameFirePointY(338, 0, 0);
        int n4 = n2 + animationManager.getAnimFrameFirePointX(338, 0, 1);
        int n5 = 6 + animationManager.getAnimFrameFirePointY(338, 0, 1);
        int n6 = n2 + animationManager.getAnimFrameFirePointX(338, 0, 2);
        int n7 = 6 + animationManager.getAnimFrameFirePointY(338, 0, 2);
        int n8 = n2 + animationManager.getAnimFrameFirePointX(338, 0, 3);
        int n9 = 6 + animationManager.getAnimFrameFirePointY(338, 0, 3);
        animationManager.drawAnimFrame(graphics, 338, 0, n2, 6);
        appEngine.drawString(graphics, 139, mixedFont2, n2, n3, 17);
        for (n = 0; n < SCORECARD_SUMMARY_STRING_IDS.length; ++n) {
            appEngine.drawString(graphics, SCORECARD_SUMMARY_STRING_IDS[n], mixedFont, n4, n5 + n * 11, 20);
            appEngine.drawChars(graphics, this.m_scorecardSummaryBytes[n], mixedFont, n8, n5 + n * 11, 24);
        }
        for (n = 0; n < SCORECARD_AWARDS1_STRING_IDS.length; ++n) {
            appEngine.drawString(graphics, SCORECARD_AWARDS1_STRING_IDS[n], mixedFont, n6, n7 + n * 10, 20);
            appEngine.drawChars(graphics, this.m_scorecardAwards1Bytes[n], mixedFont, n8, n7 + n * 10, 24);
        }
        for (n = 0; n < SCORECARD_AWARDS2_STRING_IDS.length; ++n) {
            appEngine.drawString(graphics, SCORECARD_AWARDS2_STRING_IDS[n], mixedFont, n6, n9 + n * 10, 20);
            if (n == 0) {
                appEngine.drawChars(graphics, this.m_scorecardAwards2Bytes[n], mixedFont, n8, n9 + n * 10 + (n == 1 ? 10 : 0), 24);
                continue;
            }
            appEngine.renderScroller(n, graphics, CarConstants.CAR_NAMES[appEngine.rmsGetFavouriteCar()], mixedFont, n8, n9 + n * 10 + (n == 1 ? 10 : 0), 150, 24);
        }
        this.m_engine.renderSoftKeys(graphics);
    }

    private void initScorecard() {
        AppEngine appEngine = this.m_engine;
        this.m_scorecardSummaryBytes = new byte[][]{AppEngine.intToByteArray(appEngine.rmsGetNumGripRacesFinished()), AppEngine.intToByteArray(appEngine.rmsGetNumGripRacesQualified()), AppEngine.intToByteArray(appEngine.rmsGetNumGripRacesWon())};
        this.m_scorecardAwards1Bytes = new byte[][][]{new byte[][]{AppEngine.BYTEARRAY_DOLLARSIGN, AppEngine.intToByteArray(appEngine.rmsGetCareerEarnings())}, new byte[][]{AppEngine.BYTEARRAY_DOLLARSIGN, AppEngine.intToByteArray(appEngine.rmsGetBiggestDriftScore())}};
        this.m_scorecardAwards2Bytes = new byte[][]{AppEngine.intToByteArray(appEngine.getCareerNumCarsOwned()), {0}};
    }

    private void renderConfirmation(Graphics graphics, int n) {
        AnimationManager animationManager = this.m_engine.getAnimationManager();
        int n2 = this.m_engine.getHeight() * 41123 >> 16;
        int n3 = this.m_engine.getWidth() * 58089 >> 16;
        int n4 = this.m_engine.getHeight() - n2 >> 1;
        int n5 = n4 + 16;
        int n6 = n2 - 16 - 8;
        int n7 = this.m_engine.getWidth() - n3 >> 1;
        int n8 = n7 + 5;
        int n9 = n3 - 10;
        int n10 = n8 + 2;
        int n11 = n4 + 8;
        int n12 = n8 + (n9 >> 1);
        int n13 = n5 + (n6 >> 1);
        animationManager.setColor(graphics, 0);
        graphics.fillRect(n7, n4, n3, 16);
        graphics.fillRect(n7, n5, 5, n6);
        graphics.fillRect(n8 + n9, n5, 5, n6);
        graphics.fillRect(n7, n5 + n6, n3, 8);
        animationManager.setColor(graphics, 14);
        graphics.fillRect(n8, n5, n9, n6);
        this.m_engine.drawString(graphics, n, this.m_engine.getFont(3), n10, n11, 6);
        this.m_engine.drawWrappedString(graphics, this.m_engine.getFont(1), 10, n12, n13, 3);
        this.m_engine.renderSoftKeys(graphics);
    }

    public void processKeys(int n, int n2) {
        switch (this.m_menuState) {
            case 0: 
            case 8: {
                this.processKeysSelectLanguage(n, n2);
                break;
            }
            case 1: {
                this.processKeysConfirmSound(n, n2);
                break;
            }
            case 2: {
                if (this.m_loadingProgress < 100) break;
                this.processKeysTitleScreen(n, n2);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                if (this.m_confirmBoxDisplayed) {
                    this.processKeysNewCareerQuery(n, n2);
                    break;
                }
                this.processKeysMainMenu(n, n2);
                break;
            }
            case 5: {
                this.processKeysQuickRaceCarSelect(n, n2);
                break;
            }
            case 6: {
                this.processKeysQuickRaceTrackSelect(n, n2);
                break;
            }
            case 7: {
                this.processKeysOptions(n, n2);
                break;
            }
            case 36: {
                this.processKeysConfirmReset(n, n2);
                break;
            }
            case 9: 
            case 10: {
                this.processKeysHelpAbout(n, n2);
                break;
            }
            case 11: {
                this.processKeysCareerProgress(n, n2);
                break;
            }
            case 12: {
                this.processKeysCareerTuner(n, n2);
                break;
            }
            case 13: {
                this.processKeysCareerTunerBuy(n, n2);
                break;
            }
            case 14: {
                this.processKeysCareerTunerBuyConfirm(n, n2);
                break;
            }
            case 15: {
                this.processKeysCareerEventHub(n, n2);
                break;
            }
            case 16: {
                this.processKeysCareerChooseEvent(n, n2);
                break;
            }
            case 17: {
                this.processKeysCareerGarageMenu(n, n2);
                break;
            }
            case 19: 
            case 21: {
                this.processKeysCareerGarageBuy(n, n2);
                break;
            }
            case 20: 
            case 22: {
                this.processKeysCareerGarageBuyConfirm(n, n2);
                break;
            }
            case 23: {
                this.processKeysCareerGarageSell(n, n2);
                break;
            }
            case 24: {
                this.processKeysCareerGarageSellConfirm(n, n2);
                break;
            }
            case 18: {
                this.processKeysCareerGarageSelect(n, n2);
                break;
            }
            case 25: {
                this.processKeysPostRaceStandings(n, n2);
                break;
            }
            case 26: {
                this.processKeysPostRaceAwards(n, n2);
                break;
            }
            case 27: {
                this.processKeysPostRaceClearEvent(n, n2);
                break;
            }
            case 28: {
                this.processKeysPostRaceUnlockCode(n, n2);
                break;
            }
            case 29: {
                this.processKeysPostRaceClearGame(n, n2);
                break;
            }
            case 30: {
                this.processKeysPostRaceScorecard(n, n2);
                break;
            }
            case 31: {
                this.processKeysPostRaceRaceAgain(n, n2);
                break;
            }
            case 35: {
                this.processKeysConfirmExit(n, n2);
            }
        }
    }

    private void processKeysSelectLanguage(int n, int n2) {
        byte by = this.processKeysMenu(n, n2, this.m_languageMenuStringIDs.length, 0);
        switch (by) {
            case 1: {
                this.m_engine.loadStringsByLocale(this.m_menuSelection);
                this.m_engine.saveRMSAppSettings();
                this.initByteArrays();
                if (this.m_menuState == 8) {
                    this.stateTransition((byte)7);
                    break;
                }
                this.stateTransition((byte)1);
                break;
            }
            case 2: {
                if (this.m_menuState != 8) break;
                this.stateTransition((byte)7);
                break;
            }
        }
    }

    private void processKeysConfirmSound(int n, int n2) {
        if (n2 == 9) {
            this.m_engine.clearCommandKeys();
            this.m_engine.setSoundEnabled(true);
            this.updateOptionsValues();
            this.fadeStateTransition((byte)2);
        } else if (n2 == 10) {
            this.m_engine.clearCommandKeys();
            this.m_engine.setSoundEnabled(false);
            this.updateOptionsValues();
            this.fadeStateTransition((byte)2);
        }
    }

    private void processKeysTitleScreen(int n, int n2) {
    }

    private void processKeysMainMenu(int n, int n2) {
        byte by = this.processKeysMenu(n, n2, this.m_mainMenuStringIDs.length, 0);
        switch (by) {
            case 1: {
                switch (this.m_mainMenuStringIDs[this.m_menuSelection]) {
                    case 31: {
                        this.fadeStateTransition((byte)5);
                        break;
                    }
                    case 32: {
                        this.fadeStateTransition((byte)11);
                        break;
                    }
                    case 33: {
                        if (this.m_engine.rmsGameExists()) {
                            this.showNewCareerQuery();
                            break;
                        }
                        this.fadeStateTransition((byte)19);
                        break;
                    }
                    case 34: {
                        this.fadeStateTransition((byte)7);
                        break;
                    }
                    case 37: {
                        this.fadeStateTransition((byte)9);
                        break;
                    }
                    case 36: {
                        this.fadeStateTransition((byte)10);
                    }
                }
                break;
            }
            case 2: {
                this.stateTransition((byte)35);
                break;
            }
        }
    }

    private void showNewCareerQuery() {
        this.m_confirmBoxDisplayed = true;
        this.m_engine.wrapText(143, this.m_engine.getFont(1), 130);
        this.m_engine.setSoftKeys(10, 9);
    }

    private void hideNewCareerQuery() {
        this.m_confirmBoxDisplayed = false;
        this.m_engine.setSoftKeys(7, 6);
    }

    private void processKeysNewCareerQuery(int n, int n2) {
        if (n2 == 9) {
            this.m_engine.clearCommandKeys();
            this.fadeStateTransition((byte)19);
        } else if (n2 == 10 || n2 == 3) {
            this.m_engine.clearCommandKeys();
            this.hideNewCareerQuery();
        }
    }

    private byte processKeysMenu(int n, int n2, int n3, int n4) {
        boolean bl;
        if ((n & 0x1020) != 0 || n2 == 6 || n2 == 9 || n2 == 2) {
            this.m_engine.clearCommandKeys();
            this.m_engine.clearKeyBit(4128);
            return 1;
        }
        if (n2 == 3 || n2 == 10 || n2 == 7) {
            this.m_engine.clearCommandKeys();
            return 2;
        }
        int n5 = (n4 & 1) != 0 ? 65600 : 16640;
        int n6 = (n4 & 1) != 0 ? 32784 : 8196;
        int n7 = (n4 & 1) != 0 ? 24836 : 98384;
        boolean bl2 = (n & n5) != 0;
        boolean bl3 = (n & n6) != 0;
        boolean bl4 = bl = (n & n7) != 0;
        if (bl2) {
            this.m_engine.clearKeyBit(n5);
            this.m_menuSelection = (byte)(this.m_menuSelection + 1);
            if (this.m_menuSelection >= n3) {
                this.m_menuSelection = (n4 & 2) != 0 ? (byte)(n3 - 1) : (byte)0;
            }
            return 3;
        }
        if (bl3) {
            this.m_engine.clearKeyBit(n6);
            this.m_menuSelection = (byte)(this.m_menuSelection - 1);
            if (this.m_menuSelection < 0) {
                this.m_menuSelection = (n4 & 2) != 0 ? (byte)0 : (byte)(n3 - 1);
            }
            return 3;
        }
        if (bl) {
            this.m_engine.clearKeyBit(n7);
            return 4;
        }
        return 0;
    }

    private void processKeysQuickRaceCarSelect(int n, int n2) {
        byte by = this.processKeysMenu(n, n2, this.m_quickRaceCarSelectMenuStrings.length, 1);
        switch (by) {
            case 1: {
                this.fadeStateTransition((byte)6);
                break;
            }
            case 2: {
                this.fadeStateTransition((byte)4);
                break;
            }
            case 3: {
                this.setSelectedCar(this.m_menuSelection);
            }
        }
    }

    private void processKeysQuickRaceTrackSelect(int n, int n2) {
        byte by = this.processKeysMenu(n, n2, this.m_engine.getNumUnlockedTracks(), 2);
        switch (by) {
            case 1: {
                byte by2 = this.m_engine.getNthUnlockedTrack(this.m_menuSelection);
                this.m_engine.setCurrTrack(by2);
                int n3 = this.m_engine.getTrackType(by2);
                this.m_engine.setNextRaceType((byte)n3);
                this.m_engine.setNextRaceNumLaps((byte)3);
                this.m_engine.setCarNowRacingParameters(false, (byte)-1, (byte)-1);
                this.fadeStateTransition((byte)32);
                break;
            }
            case 2: {
                this.fadeStateTransition((byte)5);
                break;
            }
        }
    }

    private void processKeysOptions(int n, int n2) {
        byte by = this.processKeysMenu(n, n2, this.m_optionsMenuLabelsStringIDs.length, 0);
        switch (by) {
            case 1: {
                short s = this.m_optionsMenuLabelsStringIDs[this.m_menuSelection];
                if (s == 196) {
                    this.stateTransition((byte)36);
                    break;
                }
                if (s != 3) break;
                this.stateTransition((byte)8);
                break;
            }
            case 4: {
                short s = this.m_optionsMenuLabelsStringIDs[this.m_menuSelection];
                if (s == 87) {
                    this.m_engine.setSoundEnabled(!this.m_engine.isSoundEnabled());
                } else if (s == 88) {
                    this.m_engine.setVibrationEnabled(!this.m_engine.isVibrationEnabled());
                    this.m_engine.vibrate(400);
                } else if (s == 89) {
                    this.m_engine.m_rmsCarMarkersEnabled = !this.m_engine.m_rmsCarMarkersEnabled;
                }
                this.updateOptionsValues();
                this.m_engine.saveRMSAppSettings();
                break;
            }
            case 2: {
                this.fadeStateTransition((byte)4);
            }
        }
    }

    private void processKeysConfirmReset(int n, int n2) {
        if (n2 == 9) {
            this.m_engine.clearCommandKeys();
            this.m_engine.resetRecords();
            this.fadeStateTransition((byte)4);
        } else if (n2 == 10 || n2 == 3) {
            this.m_engine.clearCommandKeys();
            this.stateTransition((byte)7);
            this.m_menuSelection = (byte)3;
        }
    }

    private void processKeysHelpAbout(int n, int n2) {
        this.m_engine.processKeysHelpAbout(n, n2);
        if (n2 == 3) {
            this.m_engine.clearCommandKeys();
            this.fadeStateTransition((byte)4);
        }
    }

    private void processKeysCareerProgress(int n, int n2) {
        byte by = this.processKeysMenu(n, n2, this.m_careerProgressMenuStringIDs.length, 0);
        switch (by) {
            case 1: {
                switch (this.m_careerProgressMenuStringIDs[this.m_menuSelection]) {
                    case 130: {
                        this.fadeStateTransition((byte)12);
                        break;
                    }
                    case 131: {
                        this.fadeStateTransition((byte)17);
                        break;
                    }
                    case 132: {
                        this.fadeStateTransition((byte)15);
                        break;
                    }
                    case 140: {
                        this.fadeStateTransition((byte)4);
                    }
                }
                break;
            }
            case 2: {
                this.fadeStateTransition((byte)4);
                break;
            }
        }
    }

    private void processKeysCareerTuner(int n, int n2) {
        byte by = this.processKeysMenu(n, n2, this.m_careerTunerMenuStringIDs.length, 1);
        switch (by) {
            case 1: {
                this.stateTransition((byte)13);
                break;
            }
            case 2: {
                this.fadeStateTransition((byte)11);
            }
        }
    }

    private void processKeysCareerTunerBuy(int n, int n2) {
        byte by = this.processKeysMenu(n, n2, this.m_careerTunerSubMenuStringIDs[this.m_tunerShopSelection].length, 0);
        if (this.m_careerTunerSubMenuStringIDs[this.m_tunerShopSelection].length == 0) {
            this.m_menuSelection = 0;
        }
        switch (by) {
            case 1: {
                if (this.m_careerTunerSubMenuStringIDs[this.m_tunerShopSelection].length == 0) break;
                int n3 = this.getTunerShopAccessorySelection();
                int n4 = this.m_engine.getCareerTunerAccessoryPrices()[this.m_tunerShopSelection][n3];
                if (this.m_engine.rmsGetCareerMoney() < n4) break;
                this.stateTransition((byte)14);
                break;
            }
            case 2: {
                this.stateTransition((byte)12);
            }
        }
    }

    private void processKeysCareerTunerBuyConfirm(int n, int n2) {
        if (n2 == 9) {
            AppEngine.myDebug = "confirm ok";
            this.m_engine.clearCommandKeys();
            byte by = (byte)(this.getTunerShopAccessorySelection() + 1);
            this.m_engine.purchaseCareerTunerAccessory(this.m_carSelectCurrCarID, this.m_tunerShopSelection, by);
            this.stateTransition((byte)13);
        } else if (n2 == 10) {
            this.m_engine.clearCommandKeys();
            this.stateTransition((byte)13);
            AppEngine.myDebug = "confirm done";
        }
    }

    private void processKeysCareerEventHub(int n, int n2) {
        byte by = this.processKeysMenu(n, n2, Math.min(this.m_engine.getEventHubUnlockLevel() + 1, this.m_engine.getNumEventHubs()), 0);
        switch (by) {
            case 1: {
                this.fadeStateTransition((byte)16);
                break;
            }
            case 2: {
                this.fadeStateTransition((byte)11);
            }
        }
    }

    private void processKeysCareerChooseEvent(int n, int n2) {
        byte by = this.processKeysMenu(n, n2, this.m_careerChooseEventMenuStringIDs[this.m_careerEventHubIndex].length, 0);
        switch (by) {
            case 1: {
                byte by2 = this.m_engine.getEventHubEventTrackID(this.m_careerEventHubIndex, this.m_menuSelection);
                this.m_engine.setCurrTrack(by2);
                byte by3 = this.m_engine.getEventHubEventType(this.m_careerEventHubIndex, this.m_menuSelection);
                this.m_engine.setNextRaceType(by3);
                this.m_engine.setNextRaceNumLaps((byte)3);
                this.m_engine.setCarNowRacingParameters(true, this.m_careerEventHubIndex, this.m_menuSelection);
                this.fadeStateTransition((byte)32);
                break;
            }
            case 2: {
                this.fadeStateTransition((byte)15);
            }
        }
    }

    private void processKeysCareerGarageMenu(int n, int n2) {
        byte by = this.processKeysMenu(n, n2, this.m_careerGarageMenuStringIDs.length, 0);
        switch (by) {
            case 1: {
                switch (this.m_careerGarageMenuStringIDs[this.m_menuSelection]) {
                    case 149: 
                    case 150: {
                        this.fadeStateTransition((byte)18);
                        break;
                    }
                    case 151: {
                        this.fadeStateTransition((byte)21);
                        break;
                    }
                    case 148: {
                        this.fadeStateTransition((byte)23);
                    }
                }
                break;
            }
            case 2: {
                this.fadeStateTransition((byte)11);
            }
        }
    }

    private void processKeysCareerGarageBuy(int n, int n2) {
        byte by = this.processKeysMenu(n, n2, this.m_engine.getNumCars() - this.m_engine.getCareerNumCarsOwned(), 1);
        switch (by) {
            case 1: {
                if (this.m_engine.rmsGetCareerMoney() < this.m_engine.getCarPrice(this.m_carSelectCurrCarID)) break;
                byte by2 = this.m_menuState == 21 ? (byte)22 : 20;
                this.stateTransition(by2);
                break;
            }
            case 2: {
                if (this.m_menuState == 19) {
                    this.initialiseMainMenuItemStrings();
                    this.fadeStateTransition((byte)4);
                    break;
                }
                this.fadeStateTransition((byte)17);
                break;
            }
            case 3: {
                this.setSelectedCar(this.m_engine.getNthNonOwnedCar(this.m_menuSelection));
                this.m_careerBytesBuySell[1] = AppEngine.intToByteArray(this.m_engine.getCarPrice(this.m_carSelectCurrCarID));
            }
        }
    }

    private void processKeysCareerGarageBuyConfirm(int n, int n2) {
        if (n2 == 9) {
            this.m_engine.clearCommandKeys();
            if (this.m_engine.rmsGetCareerMoney() >= this.m_engine.getCarPrice(this.m_carSelectCurrCarID)) {
                if (this.m_menuState == 20) {
                    this.m_engine.rmsSetGameExists(true);
                    this.initByteArrays();
                }
                byte by = this.m_engine.getNthNonOwnedCar(this.m_menuSelection);
                this.m_engine.purchaseCareerCar(by);
                this.initialiseMainMenuItemStrings();
                this.initialiseCarBuySellStringIDs();
                if (this.m_engine.getCareerNumCarsOwned() > 1) {
                    this.fadeStateTransition((byte)18);
                } else {
                    this.m_engine.rmsSetCareerActiveCarIndex(by);
                    this.fadeStateTransition((byte)11);
                }
            }
        } else if (n2 == 10 || n2 == 3) {
            this.m_engine.clearCommandKeys();
            byte by = this.m_menuState == 22 ? (byte)21 : 19;
            this.stateTransition(by);
        }
    }

    private void processKeysCareerGarageSell(int n, int n2) {
        byte by = this.processKeysMenu(n, n2, this.m_engine.getCareerNumCarsOwned(), 1);
        switch (by) {
            case 1: {
                this.stateTransition((byte)24);
                break;
            }
            case 2: {
                this.fadeStateTransition((byte)17);
                break;
            }
            case 3: {
                boolean bl;
                boolean bl2 = bl = this.m_engine.getCareerNumCarsOwned() == 1;
                if (bl) break;
                this.setSelectedCar(this.m_engine.getNthOwnedCar(this.m_menuSelection));
                this.m_careerBytesBuySell[1] = AppEngine.intToByteArray(this.m_engine.getCarSellPrice(this.m_carSelectCurrCarID));
            }
        }
    }

    private void processKeysCareerGarageSellConfirm(int n, int n2) {
        if (n2 == 9) {
            this.m_engine.clearCommandKeys();
            byte by = this.m_engine.getNthOwnedCar(this.m_menuSelection);
            this.m_engine.sellCareerCar(by);
            this.initialiseCarBuySellStringIDs();
            if (this.m_engine.getCareerNumCarsOwned() > 1) {
                this.fadeStateTransition((byte)18);
            } else {
                this.m_engine.rmsSetCareerActiveCarIndex(this.m_engine.getNthOwnedCar((byte)0));
                this.fadeStateTransition((byte)17);
            }
        } else if (n2 == 10 || n2 == 3) {
            this.m_engine.clearCommandKeys();
            this.stateTransition((byte)23);
        }
    }

    private void processKeysCareerGarageSelect(int n, int n2) {
        byte by = this.processKeysMenu(n, n2, this.m_engine.getCareerNumCarsOwned(), 1);
        switch (by) {
            case 1: {
                boolean bl;
                boolean bl2 = bl = this.m_careerGarageMenuStringIDs[0] == 150;
                if (bl) break;
                this.m_engine.rmsSetCareerActiveCarIndex(this.m_engine.getNthOwnedCar(this.m_menuSelection));
                this.fadeStateTransition((byte)11);
                break;
            }
            case 2: {
                this.fadeStateTransition((byte)17);
                break;
            }
            case 3: {
                this.setSelectedCar(this.m_engine.getNthOwnedCar(this.m_menuSelection));
            }
        }
    }

    private void processKeysConfirmExit(int n, int n2) {
        if (n2 == 9) {
            this.m_engine.clearCommandKeys();
            this.m_nextScene = -1;
            this.fadeStateTransition((byte)33);
        } else if (n2 == 10 || n2 == 3) {
            this.m_engine.clearCommandKeys();
            this.stateTransition((byte)4);
        }
    }

    private void processKeysPostRaceStandings(int n, int n2) {
        if ((n & 0x1020) != 0 || n2 == 2) {
            this.m_engine.clearCommandKeys();
            this.m_engine.clearKeyBit(4128);
            if (this.m_engine.m_quitLastRace) {
                if (this.m_engine.isCarNowRacingCareer()) {
                    this.fadeStateTransition((byte)11);
                } else {
                    this.fadeStateTransition((byte)4);
                }
            } else {
                this.fadeStateTransition((byte)26);
            }
        }
    }

    private void processKeysPostRaceRaceAgain(int n, int n2) {
        byte by = this.processKeysMenu(n, n2, this.m_yesNoMenuStringIDs.length, 0);
        if (by == 1) {
            if (this.m_yesNoMenuStringIDs[this.m_menuSelection] == 22) {
                this.m_engine.clearCommandKeys();
                this.fadeStateTransition((byte)32);
            } else {
                this.m_engine.clearCommandKeys();
                if (this.m_engine.isCarNowRacingCareer()) {
                    this.postAwardsCareerStateTransition();
                } else {
                    this.fadeStateTransition((byte)4);
                }
            }
        }
    }

    private void processKeysPostRaceAwards(int n, int n2) {
        if ((n & 0x8010) != 0 && this.m_trackStatsCurPage > 0) {
            this.m_engine.clearKeyBit(32784);
            --this.m_trackStatsCurPage;
            this.m_trackStatsPageBytes[0] = AppEngine.intToByteArray(this.m_trackStatsCurPage + 1);
        } else if ((n & 0x10040) != 0 && this.m_trackStatsCurPage < this.m_trackStatsNumPages - 1) {
            this.m_engine.clearKeyBit(65600);
            ++this.m_trackStatsCurPage;
            this.m_trackStatsPageBytes[0] = AppEngine.intToByteArray(this.m_trackStatsCurPage + 1);
        } else if ((n & 0x1020) != 0 || n2 == 2) {
            this.m_engine.clearCommandKeys();
            this.m_engine.clearKeyBit(4128);
            this.postAwardsStateTransition();
        } else if (n2 == 3) {
            this.m_engine.clearCommandKeys();
            this.fadeStateTransition((byte)25);
        }
    }

    private void processKeysPostRaceClearEvent(int n, int n2) {
        if ((n & 0x1020) != 0 || n2 == 4) {
            this.m_engine.clearCommandKeys();
            this.m_engine.clearKeyBit(4128);
            this.fadeStateTransition((byte)11);
        }
    }

    private void processKeysPostRaceUnlockCode(int n, int n2) {
        if ((n & 0x1020) != 0 || n2 == 4) {
            this.m_engine.clearCommandKeys();
            this.m_engine.clearKeyBit(4128);
            if (this.m_engine.getEventHubUnlockLevel() == this.m_engine.getNumEventHubs()) {
                this.fadeStateTransition((byte)30);
            } else {
                this.fadeStateTransition((byte)11);
            }
        }
    }

    private void processKeysPostRaceClearGame(int n, int n2) {
        if ((n & 0x1020) != 0 || n2 == 4) {
            this.m_engine.clearCommandKeys();
            this.m_engine.clearKeyBit(4128);
            this.fadeStateTransition((byte)30);
        }
    }

    private void processKeysPostRaceScorecard(int n, int n2) {
        if ((n & 0x1020) != 0 || n2 == 4) {
            this.m_engine.clearCommandKeys();
            this.m_engine.clearKeyBit(4128);
            this.fadeStateTransition((byte)11);
        }
    }

    private void fadeStateTransition(byte by) {
        this.stateTransition(by);
    }

    private void stateTransition(byte by) {
        if (this.m_menuState == by) {
            return;
        }
        if (this.m_menuState == 5) {
            this.m_engine.setPlayerCarIndex(this.m_menuSelection);
        }
        if (this.m_menuState == 2) {
            this.m_engine.m_splashDone = true;
        }
        if (SceneMenu.IS_IN(by, USTATES_CAREER_CASH)) {
            this.m_careerBytesCash[2] = AppEngine.intToByteArray(this.m_engine.rmsGetCareerMoney());
        }
        this.m_engine.resetScrollers();
        switch (by) {
            case 0: {
                this.m_engine.setSoftKeys(0, 6);
                this.m_menuSelection = 0;
                break;
            }
            case 1: {
                this.m_engine.setSoftKeys(10, 9);
                break;
            }
            case 2: {
                this.m_splashTimerEA = 3000;
                this.m_engine.setSoftKeys(0, 0);
                break;
            }
            case 34: {
                int n = MathExt.Fmul(this.m_engine.getWidth() << 16, 55706) >> 16;
                this.m_engine.wrapText(195, this.m_engine.getFont(1), n);
                this.m_splashTimerEA = 5000;
                this.m_engine.setSoftKeys(0, 0);
                break;
            }
            case 3: {
                this.m_splashTimerEA = 2000;
                this.m_engine.setSoftKeys(0, 0);
                break;
            }
            case 4: {
                if (this.m_menuState == 2) {
                    this.m_engine.getAnimationManager().unloadImage(this.m_engine.getResourceManager(), 292);
                }
                this.m_confirmBoxDisplayed = false;
                this.m_menuSelection = 0;
                this.m_engine.setSoftKeys(7, 6);
                break;
            }
            case 5: 
            case 6: {
                this.m_engine.setSoftKeys(3, 6);
                if (by == 5) {
                    this.m_menuSelection = this.m_engine.getPlayerCarIndex();
                    if (this.m_carSelectCurrCarID == this.m_menuSelection) break;
                    this.setSelectedCar(this.m_menuSelection);
                    break;
                }
                this.m_menuSelection = 0;
                this.m_engine.m_animationManager.startAnim(299, true, true);
                this.m_engine.m_animationManager.startAnim(298, true, true);
                break;
            }
            case 32: {
                this.m_engine.setSoftKeys(0, 0);
                break;
            }
            case 33: {
                this.m_engine.setSoftKeys(0, 0);
                this.m_endScene = true;
                break;
            }
            case 7: {
                this.m_menuSelection = 0;
                this.m_engine.setSoftKeys(3, 0);
                break;
            }
            case 8: {
                this.m_menuSelection = this.m_engine.m_rmsEfigsIndex;
                this.m_engine.setSoftKeys(3, 6);
                break;
            }
            case 36: {
                this.m_engine.setSoftKeys(10, 9);
                this.m_engine.wrapText(197, this.m_engine.getFont(1), 114);
                break;
            }
            case 9: {
                this.m_engine.initHelpScreen();
                this.m_engine.setSoftKeys(3, 0);
                break;
            }
            case 10: {
                this.m_engine.initAboutScreen();
                this.m_engine.setSoftKeys(3, 0);
                break;
            }
            case 11: {
                this.m_menuSelection = 0;
                this.m_engine.setPlayerCarIndex(this.m_engine.rmsGetCareerActiveCarIndex());
                this.setSelectedCar(this.m_engine.rmsGetCareerActiveCarIndex());
                this.m_engine.setSoftKeys(3, 6);
                break;
            }
            case 12: {
                if (this.m_menuState == 13) {
                    this.m_menuSelection = this.m_tunerShopSelection;
                }
                this.m_engine.setSoftKeys(3, 6);
                break;
            }
            case 13: {
                this.initialiseTunerShopItems();
                if (this.m_menuState == 12) {
                    this.m_tunerShopSelection = this.m_menuSelection;
                }
                if (this.m_menuState != 14 || this.m_menuSelection >= this.m_careerTunerSubMenuStringIDs[this.m_tunerShopSelection].length) {
                    this.m_menuSelection = 0;
                }
                int n = 6;
                if (this.m_careerTunerSubMenuStringIDs[this.m_tunerShopSelection].length == 0) {
                    AppEngine.myDebug = "wraping text";
                    n = 0;
                    this.m_engine.wrapText(177, this.m_engine.getFont(1), this.m_engine.getWidth() / 2);
                    AppEngine.myDebug = "done";
                }
                this.m_engine.setSoftKeys(3, n);
                break;
            }
            case 14: {
                this.m_engine.wrapText(155, this.m_engine.getFont(1), 130);
                this.m_engine.setSoftKeys(10, 9);
                break;
            }
            case 15: {
                this.m_menuSelection = 0;
                this.m_careerEventHubIndex = 0;
                this.m_engine.setSoftKeys(3, 6);
                break;
            }
            case 16: {
                this.m_careerEventHubIndex = this.m_menuSelection;
                this.m_menuSelection = 0;
                this.m_engine.setSoftKeys(3, 6);
                break;
            }
            case 17: {
                this.m_engine.setSoftKeys(3, 6);
                this.m_menuSelection = 0;
                this.setSelectedCar(this.m_engine.rmsGetCareerActiveCarIndex());
                break;
            }
            case 19: {
                this.m_engine.resetRMSGameData();
                this.m_careerBytesCash[2] = AppEngine.intToByteArray(this.m_engine.rmsGetCareerMoney());
            }
            case 21: {
                this.m_engine.setSoftKeys(3, 6);
                if (this.m_menuState == 22 || this.m_menuState == 20) break;
                this.m_menuSelection = 0;
                this.setSelectedCar(this.m_engine.getNthNonOwnedCar(this.m_menuSelection));
                this.m_careerBytesBuySell[1] = AppEngine.intToByteArray(this.m_engine.getCarPrice(this.m_carSelectCurrCarID));
                break;
            }
            case 20: 
            case 22: {
                this.m_engine.setSoftKeys(10, 9);
                this.m_engine.wrapText(153, this.m_engine.getFont(1), 114);
                break;
            }
            case 23: {
                this.m_engine.setSoftKeys(3, 6);
                if (this.m_menuState == 24) break;
                this.m_menuSelection = 0;
                this.m_careerBytesBuySell[1] = AppEngine.intToByteArray(this.m_engine.getCarSellPrice(this.m_carSelectCurrCarID));
                this.setSelectedCar(this.m_engine.getNthOwnedCar(this.m_menuSelection));
                break;
            }
            case 24: {
                this.m_engine.setSoftKeys(10, 9);
                this.m_engine.wrapText(154, this.m_engine.getFont(1), 114);
                break;
            }
            case 18: {
                if (this.m_careerGarageMenuStringIDs[0] == 150) {
                    this.m_engine.setSoftKeys(3, 0);
                } else {
                    this.m_engine.setSoftKeys(3, 6);
                }
                this.m_menuSelection = 0;
                for (byte by2 = 0; by2 < this.m_engine.getCareerNumCarsOwned(); by2 = (byte)(by2 + 1)) {
                    if (this.m_engine.getNthOwnedCar(by2) != this.m_engine.rmsGetCareerActiveCarIndex()) continue;
                    this.m_menuSelection = by2;
                }
                this.setSelectedCar(this.m_engine.rmsGetCareerActiveCarIndex());
                break;
            }
            case 25: {
                if (this.m_standingsBytesCars == null && this.m_engine.getRaceStandings() != null) {
                    AppEngine appEngine = this.m_engine;
                    int[] nArray = appEngine.getRaceStandings();
                    this.m_standingsBytesFinished[1] = AppEngine.intToByteArray(appEngine.getPlayerRacePosition() + 1);
                    this.m_standingsBytesFinished[3] = AppEngine.intToByteArray(nArray.length);
                    this.m_standingsBytesCars = new byte[nArray.length][][];
                    this.m_standingsBytesTimes = new byte[nArray.length][][];
                    for (int i = 0; i < nArray.length; ++i) {
                        this.m_standingsBytesCars[i] = new byte[2][];
                        this.m_standingsBytesCars[i][0] = appEngine.getString(118).getBytes();
                        this.m_standingsBytesCars[i][1] = AppEngine.intToByteArray(i + 1);
                        this.m_standingsBytesTimes[i] = AppEngine.fixedToTimeBytes(nArray[i]);
                    }
                }
                this.m_engine.setSoftKeys(0, 2);
                break;
            }
            case 26: {
                this.initTrackStats();
                this.m_engine.setSoftKeys(3, 2);
                break;
            }
            case 27: {
                this.m_engine.wrapText(135, this.m_engine.getFont(1), 140);
                this.m_engine.setSoftKeys(0, 4);
                break;
            }
            case 28: {
                this.m_engine.setSoftKeys(0, 4);
                break;
            }
            case 29: {
                this.m_engine.wrapText(138, this.m_engine.getFont(1), 114);
                this.m_engine.setSoftKeys(0, 4);
                break;
            }
            case 30: {
                this.initScorecard();
                this.m_engine.setSoftKeys(0, 4);
                break;
            }
            case 31: {
                this.m_menuSelection = 0;
                this.m_engine.setSoftKeys(0, 6);
                break;
            }
            case 35: {
                this.m_engine.setSoftKeys(10, 9);
                this.m_engine.wrapText(47, this.m_engine.getFont(1), 114);
            }
        }
        this.m_menuState = by;
        this.m_engine.clearKeysPressedDown();
        this.m_engine.clearCommandKeys();
    }

    private void postAwardsStateTransition() {
        if (this.m_engine.isCarNowRacingCareer()) {
            if (this.m_engine.wasEventHubJustCleared()) {
                if (this.m_engine.getEventHubUnlockLevel() == this.m_engine.getNumEventHubs()) {
                    this.fadeStateTransition((byte)29);
                } else {
                    this.fadeStateTransition((byte)27);
                }
            } else if (this.m_engine.m_wonLastRace) {
                this.postAwardsCareerStateTransition();
            } else {
                this.fadeStateTransition((byte)31);
            }
        } else {
            this.fadeStateTransition((byte)31);
        }
    }

    private void postAwardsCareerStateTransition() {
        this.m_menuSelection = this.m_careerEventHubIndex = this.m_engine.getCarNowRacingHubIndex();
        this.fadeStateTransition((byte)16);
    }

    private void changeScene(int n) {
        this.m_nextScene = n;
        this.fadeStateTransition((byte)33);
    }

    void updateMusic() {
        SoundManager soundManager = this.m_engine.getSoundManager();
        if (!soundManager.getEnabled()) {
            this.stopMusic();
            return;
        }
        if (this.m_lastMusicSoundId != this.m_musicSoundId) {
            this.stopMusic();
        }
        if (this.m_musicSoundId != -1 && !soundManager.isSoundPlaying(this.m_musicSoundId) && this.m_menuState != 33) {
            soundManager.loadSound(this.m_musicSoundId, 1, 99);
            soundManager.playSound(this.m_musicSoundId);
        }
        this.m_lastMusicSoundId = this.m_musicSoundId;
    }

    void stopMusic() {
        SoundManager soundManager = this.m_engine.getSoundManager();
        if (this.m_lastMusicSoundId != -1 && soundManager.isSoundPlaying(this.m_lastMusicSoundId)) {
            soundManager.stopSound(this.m_lastMusicSoundId);
            soundManager.freeSound(this.m_lastMusicSoundId);
        }
    }

    private void renderPadlock(Graphics graphics) {
        int n = this.m_engine.getWidth() >> 1;
        int n2 = 22 + (MathExt.Fmul(this.m_engine.getHeight() << 16, 41288) >> 16);
        this.m_engine.getAnimationManager().drawAnimFrame(graphics, 297, 0, n, n2);
    }

    private void renderCallToActionScreen(Graphics graphics) {
        graphics.setColor(-16777216);
        graphics.fillRect(0, 0, this.m_engine.getWidth(), this.m_engine.getHeight());
        this.m_engine.drawWrappedString(graphics, this.m_engine.getFont(1), 10, this.m_engine.getHalfWidth(), this.m_engine.getHalfHeight(), 3);
    }
}

