/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.CarConstants;
import game.EventConstants;
import game.GameObject;
import game.MonkeyApp;
import game.Scene;
import game.SceneGame;
import game.SceneMenu;
import game.TrackConstants;
import game.TunerShopConstants;
import generic.AnimConstants;
import generic.AnimationManager;
import generic.MathExt;
import generic.MixedFont;
import generic.ResourceManager;
import generic.SoundManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;
import net.rim.device.api.system.Application;
import net.rim.device.api.system.GlobalEventListener;
import net.rim.device.api.system.KeyListener;
import net.rim.device.api.ui.Keypad;

public final class AppEngine
extends GameCanvas
implements KeyListener,
GlobalEventListener,
TrackConstants,
EventConstants,
CarConstants,
TunerShopConstants {
    public boolean inMenu;
    public static final int sKEY_0 = 1;
    public static final int sKEY_1 = 2;
    public static final int sKEY_2 = 4;
    public static final int sKEY_3 = 8;
    public static final int sKEY_4 = 16;
    public static final int sKEY_5 = 32;
    public static final int sKEY_6 = 64;
    public static final int sKEY_7 = 128;
    public static final int sKEY_8 = 256;
    public static final int sKEY_9 = 512;
    public static final int sKEY_POUND = 1024;
    public static final int sKEY_STAR = 2048;
    public static final int sKEY_DPAD_FIRE = 4096;
    public static final int sKEY_DPAD_UP = 8192;
    public static final int sKEY_DPAD_DOWN = 16384;
    public static final int sKEY_DPAD_LEFT = 32768;
    public static final int sKEY_DPAD_RIGHT = 65536;
    public static final int sKEY_SOFTL = 131072;
    public static final int sKEY_SOFTR = 262144;
    public static final int sKEY_CLR = 524288;
    public static final int sKEY_FIRE = 4128;
    public static final int sKEY_UP = 8196;
    public static final int sKEY_DOWN = 16640;
    public static final int sKEY_LEFT = 32784;
    public static final int sKEY_RIGHT = 65600;
    public static final int sKEY_ARROW = 123220;
    public static final int sKEY_NUMBER = 1023;
    public static final int KEYCODE_LSOFTKEY_STD = -6;
    public static final int KEYCODE_RSOFTKEY_STD = -7;
    public static final int KEYCODE_LSOFTKEY_MOTO = 97;
    public static final int KEYCODE_RSOFTKEY_MOTO = 112;
    public static final int KEYCODE_BACKKEY = 888;
    public static final int COMMAND_NONE = 0;
    public static final int COMMAND_MENU = 1;
    public static final int COMMAND_NEXT = 2;
    public static final int COMMAND_BACK = 3;
    public static final int COMMAND_OKAY = 4;
    public static final int COMMAND_GOTO = 5;
    public static final int COMMAND_SELECT = 6;
    public static final int COMMAND_EXIT = 7;
    public static final int COMMAND_GO = 8;
    public static final int COMMAND_YES = 9;
    public static final int COMMAND_NO = 10;
    public static final int COMMAND_SKIP = 11;
    public static final int COMMAND_MORE = 12;
    public static final byte QUICKRACE_NUM_LAPS = 3;
    public static final int CAREER_INITIAL_WALLET = 14000;
    public static final byte LOAD_BMW = 1;
    public static final byte LOAD_CHEVROLET = 2;
    public static final byte LOAD_MUSTANG = 4;
    public static final byte LOAD_COROLLA = 8;
    public static final byte LOAD_NISSAN_GTR = 16;
    public static final byte LOAD_NISSAN350 = 32;
    public static final byte LOAD_REACT_TEAM = 64;
    public static final short LOAD_BATTLE_MACHINE = 128;
    public static final short LOAD_SUPER_PROMO = 256;
    public static final short LOAD_GRIP = 512;
    public static final short LOAD_OPP_BMW = 1024;
    public static final short LOAD_OPP_CHEVROLET = 2048;
    public static final short LOAD_OPP_MUSTANG = 4096;
    public static final int LOAD_OPP_COROLLA = 8192;
    public static final int LOAD_OPP_NISSAN_GTR = 16384;
    public static final int LOAD_OPP_NISSAN350 = 32768;
    public static final int LOAD_INFINITI = 65536;
    public static final int LOAD_BMWM3_2003 = 131072;
    public static final int LOAD_SUPRA = 262144;
    public static final int LOAD_PONTIAC = 524288;
    public static final int LOAD_LEXUS = 0x100000;
    public static final int LOAD_MAZDA = 0x200000;
    public static final int LOAD_NISSAN_240SX = 0x400000;
    public static final int LOAD_SHELBY = 0x800000;
    public static final int LOAD_WRX = 0x1000000;
    public static final int LOAD_ACURA = 0x2000000;
    public static final int LOAD_OPP_INFINITI = 0x4000000;
    public static final int LOAD_OPP_BMWM3_2003 = 0x8000000;
    public static final int LOAD_OPP_SUPRA = 0x10000000;
    public static final int LOAD_OPP_PONTIAC = 0x20000000;
    public static final int LOAD_OPP_LEXUS = 0x40000000;
    public static final int LOAD_OPP_MAZDA = Integer.MIN_VALUE;
    public static final long LOAD_OPP_NISSAN_240SX = 0x100000000L;
    public static final long LOAD_OPP_SHELBY = 0x200000000L;
    public static final long LOAD_OPP_WRX = 0x400000000L;
    public static final long LOAD_OPP_ACURA = 0x800000000L;
    public static final long LOAD_CLEAR_SCENEGAME = 0xFFFFFFFFFL;
    public static final long LOAD_SCENEGAME = 0x800000000000000L;
    public static final long LOAD_SCENEINTRO = 0x1000000000000000L;
    public static final long LOAD_SCENEMENU = 0x2000000000000000L;
    public static final long LOAD_APPENGINE = 0x4000000000000000L;
    public final short IMAGE_COUNT;
    static final long[] IMAGE_IDS = new long[]{294L, 0x4000000000000000L, 212L, 0x2000000000000000L, 210L, 0x2000000000000000L, 211L, 0x2000000000000000L, 213L, 0x2000000000000000L, 281L, 0x2000000000000000L, 282L, 0x2000000000000000L, 283L, 0x2000000000000000L, 284L, 0x2000000000000000L, 293L, 0x2000000000000000L, 199L, 0x2000000000000000L, 297L, 0x2000000000000000L, 296L, 0x2000000000000000L, 295L, 0x2000000000000000L, 280L, 0x2000000000000000L, 31L, 0x800000000000000L, 30L, 64L, 29L, 128L, 28L, 256L, 61L, 1024L, 62L, 1024L, 63L, 1024L, 64L, 1024L, 65L, 1024L, 66L, 1024L, 67L, 1024L, 68L, 1024L, 74L, 2048L, 75L, 2048L, 76L, 2048L, 77L, 2048L, 78L, 2048L, 79L, 2048L, 80L, 2048L, 81L, 2048L, 87L, 8192L, 88L, 8192L, 89L, 8192L, 90L, 8192L, 91L, 8192L, 92L, 8192L, 93L, 8192L, 94L, 8192L, 163L, 16384L, 164L, 16384L, 165L, 16384L, 166L, 16384L, 167L, 16384L, 168L, 16384L, 169L, 16384L, 170L, 16384L, 119L, 4096L, 120L, 4096L, 121L, 4096L, 122L, 4096L, 123L, 4096L, 124L, 4096L, 125L, 4096L, 126L, 4096L, 138L, 32768L, 139L, 32768L, 140L, 32768L, 141L, 32768L, 142L, 32768L, 143L, 32768L, 144L, 32768L, 145L, 32768L, 216L, 0x800000000000000L, 217L, 0x800000000000000L, 218L, 0x800000000000000L, 219L, 0x800000000000000L, 220L, 0x800000000000000L, 221L, 0x800000000000000L, 222L, 0x800000000000000L, 223L, 0x800000000000000L, 224L, 0x800000000000000L, 225L, 0x800000000000000L, 226L, 0x800000000000000L, 227L, 0x800000000000000L, 228L, 0x800000000000000L, 229L, 0x800000000000000L, 230L, 0x800000000000000L, 231L, 0x800000000000000L, 232L, 256L, 233L, 256L, 234L, 256L, 235L, 256L, 236L, 256L, 237L, 256L, 238L, 256L, 239L, 256L, 240L, 256L, 241L, 256L, 242L, 256L, 243L, 256L, 244L, 256L, 245L, 256L, 246L, 256L, 247L, 256L, 256L, 128L, 257L, 128L, 258L, 128L, 259L, 128L, 260L, 128L, 261L, 128L, 262L, 128L, 263L, 128L, 248L, 128L, 249L, 128L, 250L, 128L, 251L, 128L, 252L, 128L, 253L, 128L, 254L, 128L, 255L, 128L, 264L, 64L, 265L, 64L, 266L, 64L, 267L, 64L, 268L, 64L, 269L, 64L, 270L, 64L, 271L, 64L, 272L, 64L, 273L, 64L, 274L, 64L, 275L, 64L, 276L, 64L, 277L, 64L, 278L, 64L, 279L, 64L, 82L, 2L, 83L, 2L, 84L, 2L, 85L, 2L, 74L, 2L, 86L, 2L, 95L, 8L, 96L, 8L, 97L, 8L, 98L, 8L, 87L, 8L, 99L, 8L, 127L, 4L, 128L, 4L, 129L, 4L, 130L, 4L, 119L, 4L, 131L, 4L, 146L, 32L, 147L, 32L, 148L, 32L, 149L, 32L, 138L, 32L, 150L, 32L, 69L, 1L, 70L, 1L, 71L, 1L, 72L, 1L, 61L, 1L, 73L, 1L, 171L, 16L, 172L, 16L, 173L, 16L, 174L, 16L, 163L, 16L, 175L, 16L, 102L, 65536L, 103L, 65536L, 104L, 65536L, 105L, 65536L, 101L, 65536L, 106L, 65536L, 56L, 131072L, 57L, 131072L, 58L, 131072L, 59L, 131072L, 55L, 131072L, 60L, 131072L, 183L, 262144L, 184L, 262144L, 185L, 262144L, 186L, 262144L, 182L, 262144L, 187L, 262144L, 152L, 524288L, 153L, 524288L, 154L, 524288L, 155L, 524288L, 151L, 524288L, 156L, 524288L, 108L, 0x100000L, 109L, 0x100000L, 110L, 0x100000L, 111L, 0x100000L, 107L, 0x100000L, 112L, 0x100000L, 114L, 0x200000L, 115L, 0x200000L, 116L, 0x200000L, 117L, 0x200000L, 113L, 0x200000L, 118L, 0x200000L, 133L, 0x400000L, 134L, 0x400000L, 135L, 0x400000L, 136L, 0x400000L, 132L, 0x400000L, 137L, 0x400000L, 158L, 0x800000L, 159L, 0x800000L, 160L, 0x800000L, 161L, 0x800000L, 157L, 0x800000L, 162L, 0x800000L, 177L, 0x1000000L, 178L, 0x1000000L, 179L, 0x1000000L, 180L, 0x1000000L, 176L, 0x1000000L, 181L, 0x1000000L, 50L, 0x2000000L, 51L, 0x2000000L, 52L, 0x2000000L, 53L, 0x2000000L, 49L, 0x2000000L, 54L, 0x2000000L, 298L, 0x800000000000000L, 215L, 512L, 100L, 512L, 205L, 0x800000000000000L, 202L, 0x800000000000000L, 206L, 0x800000000000000L, 290L, 0x800000000000000L, 190L, 0x800000000000000L, 192L, 0x800000000000000L, 188L, 0x800000000000000L, 200L, 0x800000000000000L, 193L, 0x800000000000000L, 191L, 0x800000000000000L, 189L, 0x800000000000000L, 194L, 512L, 26L, 64L, 25L, 64L, 197L, 512L, 196L, 0x800000000000000L, 198L, 512L, 195L, 512L, 207L, 512L, 291L, 0x800000000000000L, 201L, 0x800000000000000L, 203L, 0x800000000000000L, 204L, 0x800000000000000L, 47L, 0x800000000000000L, 208L, 512L, 48L, 0x800000000000000L, 18L, 256L, 17L, 256L, 21L, 128L, 285L, 0x800000000000000L, 23L, 128L, 288L, 0x800000000000000L, 287L, 0x800000000000000L, 289L, 0x800000000000000L, 286L, 0x800000000000000L, 209L, 0x800000000000000L, 214L, 0x2000000000000000L, 0L, 0L, -1L};
    public static final byte[] BYTEARRAY_EMPTY = new byte[0];
    public static byte[] BYTEARRAY_COLON = BYTEARRAY_EMPTY;
    public static byte[] BYTEARRAY_COLON_ZERO = BYTEARRAY_EMPTY;
    public static byte[] BYTEARRAY_DOLLARSIGN = BYTEARRAY_EMPTY;
    private byte[][] m_helpAboutPageBytes;
    private int m_helpAboutCurPage;
    private int m_helpAboutNumPages;
    private int m_helpAboutNumLinesPerPage;
    private static final byte STRINGS_EN = 0;
    private static final byte STRINGS_FR = 1;
    private static final byte STRINGS_IT = 2;
    private static final byte STRINGS_DE = 3;
    private static final byte STRINGS_ES = 4;
    private static final byte STRINGS_DEFAULT = 0;
    private static final short[] STRINGS_BY_LOCALE = new short[]{6, 8, 9, 5, 7};
    public static final byte ACC_ENGINE = 0;
    public static final byte ACC_TRANSMISSION = 1;
    public static final byte ACC_TYRES = 2;
    public static final byte ACC_NITRO = 3;
    public static final byte TUNERSHOP_NUM_ACC = 4;
    private static final byte CAR_SELL_PERCENTAGE = 50;
    private static int CAR_VALUE_SPEED_MIN_F;
    private static int CAR_VALUE_SPEED_MULTIPLIER_F;
    private static int CAR_VALUE_ACCEL_MIN_F;
    private static int CAR_VALUE_ACCEL_MULTIPLIER_F;
    private static int CAR_VALUE_HANDLING_MIN_F;
    private static int CAR_VALUE_HANDLING_MULTIPLIER_F;
    private static int CAR_VALUE_NITRO_MIN_F;
    private static int CAR_VALUE_NITRO_MULTIPLIER_F;
    public static final byte NUM_OPPONENTS_RACE = 8;
    public static int MENU_WIDTH;
    public static int MENU_LEADING;
    public static int MENU_BORDER_HEIGHT;
    public static int MENU_BORDER_WIDTH;
    public static int MENU_PADDING_WIDTH;
    public static int MENU_PADDING_HEIGHT;
    public static int MENU_INNER_WIDTH;
    public static int MENU_SELECT_WIDTH;
    public static int MENU_SELECT_BORDER_RIGHT;
    public static int m_keysPressedDown;
    public static int m_commandPressedDown;
    private int[] m_keyBuffer;
    private int m_keyBufferIndex;
    private int m_selectCommandID;
    private int m_cancelCommandID;
    private MonkeyApp m_midlet;
    private boolean m_gameRunning;
    private Scene m_currentScene;
    private Random m_randomInstance;
    public static boolean m_paused;
    private int m_lastPercentage = -1;
    public boolean m_splashDone;
    private short[] m_careerTunerMenuStringIDs;
    private short[] m_careerTunerMenuCompanyNameStringIDs;
    private short[][] m_careerTunerSubMenuStringIDs;
    private short[] m_careerTunerAnimIDs;
    private int[][] m_careerTunerAccessoryPrices;
    private int[][] m_careerTunerAccessoryBoostsF;
    private static final int SETTINGS_VERSION = 184;
    private boolean m_rmsSoundEnabled;
    private boolean m_rmsVibrationEnabled;
    public boolean m_rmsCarMarkersEnabled;
    private byte m_rmsNumTimesCallToActionShown;
    public byte m_rmsEfigsIndex;
    private boolean m_rmsGameExists;
    private byte m_rmsCareerActiveCarIndex;
    private int m_rmsCareerMoney;
    private int m_rmsCareerEarnings;
    private byte m_rmsHubUnlocked;
    private byte m_rmsHubUnlockedQuickRace;
    private boolean[][] m_rmsEventsCleared;
    private byte[] m_rmsCarsOwned;
    private byte m_careerNumCarsOwned;
    private byte[] m_carsNotOwned;
    private byte[][] m_rmsAccessoryLevel;
    private int[] m_rmsCarFinishes;
    private byte m_rmsFavouriteCar;
    private byte m_rmsCarUnlockLevel;
    private int[] m_rmsTrackBestLapTimes;
    private int[] m_rmsTrackBestRaceTimes;
    private int[] m_rmsTrackBiggestDriftScores;
    private int m_rmsNumGripRacesWon;
    private int m_rmsNumGripRacesQualified;
    private int m_rmsNumGripRacesFinished;
    public boolean m_rmsTutorialShown;
    private int m_lastTrackLength;
    public boolean m_brokeBestLapTimeRecord = false;
    public boolean m_brokeBestRaceTimeRecord = false;
    public boolean m_brokeBiggestDriftScoreRecord = false;
    private boolean m_hubJustCleared;
    private int CAREER_EARNINGS_UNLOCK_LEVEL_1 = 20000;
    private int CAREER_EARNINGS_UNLOCK_LEVEL_2 = 50000;
    private int CAREER_EARNINGS_UNLOCK_LEVEL_3 = 75000;
    private int CAREER_EARNINGS_UNLOCK_LEVEL_4 = 125000;
    private int CAREER_EARNINGS_UNLOCK_LEVEL_5 = 150000;
    private int m_lastRaceDriftMoney = 0;
    private int m_lastRacePurseMoney = 0;
    private byte m_nextRaceNumLaps;
    private byte m_nextRaceType;
    private byte m_playerCarIndex;
    private static final int PURSE_PLACEMENT_MULT_1ST = 39322;
    private static final int PURSE_PLACEMENT_MULT_2ND = 19661;
    private static final int PURSE_PLACEMENT_MULT_3RD = 6554;
    private int[] m_raceStandingsLapTimes = null;
    private int m_raceStandingsPlayerPos = 0;
    private short[] m_carDescriptions;
    private int[] m_carPrices;
    private byte[] m_carUnlockLevels;
    private int[] m_carParamTyres;
    private int[] m_carParamSteeringInc;
    private int[] m_carParamSteeringRecentreInc;
    private int[] m_carParamSteeringMax;
    private byte[] m_carNumGears;
    private int[][] m_carGearAccels;
    private int[][] m_carGearMaxSpeeds;
    private int[][] m_carGearMinSpeeds;
    private int m_carNowRacingParamTyresF;
    private int m_carNowRacingParamSteeringIncF;
    private int m_carNowRacingParamSteeringRecentreIncF;
    private int m_carNowRacingParamSteeringMaxF;
    private int[] m_carNowRacingGearAccelsF;
    private int[] m_carNowRacingGearMaxSpeedsF;
    private int[] m_carNowRacingGearMinSpeedsF;
    private int m_carNowRacingNitroRechargeRateF;
    private boolean m_carNowRacingIsCareer;
    private byte m_carNowRacingHubIndex;
    private byte m_carNowRacingEventIndex;
    public boolean m_wonLastRace;
    public boolean m_quitLastRace;
    private byte m_numEventHubs;
    private short[] m_eventHubNames;
    private short[] m_eventHubMenuAnimIDs;
    private short[] m_eventHubBackdropAnimIDs;
    private byte[] m_eventHubEventCounts;
    private byte[][] m_eventTypes;
    private short[][] m_eventNames;
    private byte[][] m_eventTrackIDs;
    private short[][] m_eventPurses;
    private byte[] m_stringChars;
    private int[] m_stringOffsets;
    private int m_numWrappedLines;
    private byte[][] m_wrappedLines;
    private short[] m_numWrappedLinesChunk;
    private static final int WORDWRAP_MAX_LINES = 130;
    private static final int WORDWRAP_MAX_COLS = 55;
    private static final int MAX_WRAP_CHUNKS = 5;
    private static final int MAX_WRAP_CHUNK_LINES = 5;
    private MixedFont m_fixedWhiteFont;
    private MixedFont m_fixedBlackFont;
    private MixedFont m_propWhiteFont;
    private MixedFont m_titleFont;
    public ResourceManager m_resourceManager = null;
    public AnimationManager m_animationManager = null;
    private SoundManager m_soundManager;
    private char[] m_percentString = new char[4];
    private int[] m_frameIntervals = new int[]{70, 70, 70, 70, 70, 70, 70, 70};
    private int m_frameIntervalIndex = 0;
    public short[] m_trackInfoNameIDs;
    private short[] m_trackInfoDataIDs;
    private short[] m_trackInfoThemeIDs;
    private int m_currTrack;
    private int m_numTracks;
    private boolean m_runGarbageCollect;
    private static AppEngine m_singletonAppEngine;
    int volume = 100;
    private boolean increaseVolume;
    private boolean decreaseVolume;
    public int navDown = 0;
    private static final String RMS_SETTINGS = "gamesett";
    private static final String RMS_DATA = "gamedata";
    private Timer m_gameTimer = null;
    private boolean m_paintScheduled = false;
    private boolean wasHidden = false;
    public static String DEBUG_I;
    public static final int VIBRATION_SHORT = 250;
    public static final int VIBRATION_MEDIUM = 400;
    public static final int VIBRATION_LONG = 600;
    private Image m_screenBuffer = null;
    public static String myDebug;
    public static final int FONT_MEDIUM_WHITE = 1;
    public static final int FONT_MEDIUM_BLACK = 2;
    public static final int FONT_TITLE = 3;
    public static final int FONT_SOFTKEY_TEXT = 1;
    public static final int FONT_MENU_TEXT = 1;
    public static final int FONT_MESSAGE_TEXT = 1;
    public static final int FONT_MENU_TITLE = 1;
    public static final int FONT_LAPTIMES = 1;
    public static final int FONT_HUD = 1;
    private static final int MAX_SCROLLERS = 2;
    private int[] m_scrollerStringId = new int[2];
    private int[] m_scrollerStringWidth = new int[2];
    private long[] m_scrollerTime = new long[2];
    private int[] m_scrollerOffset = new int[2];
    private byte[][][] m_scrollerStringArray = new byte[2][][];
    public static final int SCROLLER_INITIAL_PAUSE = 1500;
    public static final int SCROLLER_PIXELS_PER_SECOND = 20;
    public static final int SCROLLER_PIXEL_MARGIN = 20;
    public static final int INFO_BOX_WRAPWIDTH = 132;
    public static final int CONFIRM_BOX_WRAP_WIDTH = 110;
    public static final int SOFTKEYBAR_HEIGHT = 17;
    static final int POPUP_TYPE_LINEAR = 0;
    static final int POPUP_TYPE_GROW = 1;
    static final int POPUP_TYPE_SMOOTH = 2;
    static final int POPUP_TIME = 600;
    static final int POPUP_SOFTKEY_TIME = 400;
    static final int POPUP_BOX_MINSIZE = 40;
    static final int POPUP_ICONBOX_MINSIZE = 60;
    private int m_previousVerticalScrollOffset = 0;

    public MonkeyApp getMidlet() {
        return this.m_midlet;
    }

    public short[] getCareerTunerMenuStringIDs() {
        return this.m_careerTunerMenuStringIDs;
    }

    public short[] getCareerTunerMenuCompanyNameStringIDs() {
        return this.m_careerTunerMenuCompanyNameStringIDs;
    }

    public short[][] getCareerTunerSubMenuStringIDs() {
        return this.m_careerTunerSubMenuStringIDs;
    }

    public short[] getCareerTunerAnimIDs() {
        return this.m_careerTunerAnimIDs;
    }

    public int[][] getCareerTunerAccessoryPrices() {
        return this.m_careerTunerAccessoryPrices;
    }

    public int[][] getCareerTunerAccessoryBoostsF() {
        return this.m_careerTunerAccessoryBoostsF;
    }

    public int rmsGetNumTimesCallToActionShown() {
        return this.m_rmsNumTimesCallToActionShown;
    }

    public void rmsSetNumTimesCallToActionShown(int n) {
        this.m_rmsNumTimesCallToActionShown = (byte)n;
    }

    public boolean isSoundEnabled() {
        return this.m_rmsSoundEnabled;
    }

    public boolean isVibrationEnabled() {
        return this.m_rmsVibrationEnabled;
    }

    public void setSoundEnabled(boolean bl) {
        this.m_rmsSoundEnabled = bl;
        this.m_soundManager.setEnabled(bl);
    }

    public void setVibrationEnabled(boolean bl) {
        this.m_rmsVibrationEnabled = bl;
    }

    public boolean rmsGameExists() {
        return this.m_rmsGameExists;
    }

    public void rmsSetGameExists(boolean bl) {
        this.m_rmsGameExists = bl;
    }

    public byte rmsGetCareerActiveCarIndex() {
        return this.m_rmsCareerActiveCarIndex;
    }

    public void rmsSetCareerActiveCarIndex(byte by) {
        this.m_rmsCareerActiveCarIndex = by;
    }

    public int rmsGetCareerMoney() {
        return this.m_rmsCareerMoney;
    }

    public int rmsGetCareerEarnings() {
        return this.m_rmsCareerEarnings;
    }

    public byte rmsGetCarUnlockLevel() {
        return this.m_rmsCarUnlockLevel;
    }

    public int rmsGetTrackBestLapTime(int n) {
        return this.m_rmsTrackBestLapTimes[n];
    }

    public int rmsGetTrackBestRaceTime(int n) {
        return this.m_rmsTrackBestRaceTimes[n];
    }

    public int rmsGetTrackBiggestDriftScores(int n) {
        return this.m_rmsTrackBiggestDriftScores[n];
    }

    public int rmsGetNumGripRacesWon() {
        return this.m_rmsNumGripRacesWon;
    }

    public int rmsGetNumGripRacesFinished() {
        return this.m_rmsNumGripRacesFinished;
    }

    public int rmsGetNumGripRacesQualified() {
        return this.m_rmsNumGripRacesQualified;
    }

    public int rmsGetFavouriteCar() {
        return this.m_rmsFavouriteCar;
    }

    public int rmsGetBiggestDriftScore() {
        int[] nArray = this.m_rmsTrackBiggestDriftScores;
        int n = 0;
        for (int i = this.m_rmsTrackBiggestDriftScores.length - 1; i >= 0; --i) {
            if (nArray[i] <= n) continue;
            n = nArray[i];
        }
        return n;
    }

    public void setLastTrackLength(int n) {
        this.m_lastTrackLength = n;
    }

    public int getLastTrackLength() {
        return this.m_lastTrackLength;
    }

    public void submitBestLapTime(int n) {
        int n2 = this.m_rmsTrackBestLapTimes[this.m_currTrack];
        if (n2 == 0 || n < n2) {
            this.m_rmsTrackBestLapTimes[this.m_currTrack] = n;
            this.m_brokeBestLapTimeRecord = true;
        } else {
            this.m_brokeBestLapTimeRecord = false;
        }
    }

    public void submitBestRaceTime(int n) {
        int n2 = this.m_rmsTrackBestRaceTimes[this.m_currTrack];
        if (n2 == 0 || n < n2) {
            this.m_rmsTrackBestRaceTimes[this.m_currTrack] = n;
            this.m_brokeBestRaceTimeRecord = true;
        } else {
            this.m_brokeBestRaceTimeRecord = false;
        }
    }

    public void submitBiggestDriftScores(int n) {
        int n2 = this.m_rmsTrackBiggestDriftScores[this.m_currTrack];
        if (n2 == 0 || n > n2) {
            this.m_rmsTrackBiggestDriftScores[this.m_currTrack] = n;
            this.m_brokeBiggestDriftScoreRecord = true;
        } else {
            this.m_brokeBiggestDriftScoreRecord = false;
        }
    }

    public void resetRecords() {
        for (int i = 0; i < this.m_rmsTrackBestLapTimes.length; ++i) {
            this.m_rmsTrackBestLapTimes[i] = 0;
            this.m_rmsTrackBestRaceTimes[i] = 0;
            this.m_rmsTrackBiggestDriftScores[i] = 0;
        }
    }

    public void awardCareerPrizeMoney(int n) {
        this.m_rmsCareerEarnings += n;
        this.m_rmsCareerMoney += n;
        if (this.m_rmsCareerMoney >= this.CAREER_EARNINGS_UNLOCK_LEVEL_5 && this.m_rmsCarUnlockLevel < 5) {
            this.m_rmsCarUnlockLevel = (byte)5;
        } else if (this.m_rmsCareerMoney >= this.CAREER_EARNINGS_UNLOCK_LEVEL_4 && this.m_rmsCarUnlockLevel < 4) {
            this.m_rmsCarUnlockLevel = (byte)4;
        } else if (this.m_rmsCareerMoney >= this.CAREER_EARNINGS_UNLOCK_LEVEL_3 && this.m_rmsCarUnlockLevel < 3) {
            this.m_rmsCarUnlockLevel = (byte)3;
        } else if (this.m_rmsCareerMoney >= this.CAREER_EARNINGS_UNLOCK_LEVEL_2 && this.m_rmsCarUnlockLevel < 2) {
            this.m_rmsCarUnlockLevel = (byte)2;
        } else if (this.m_rmsCareerMoney >= this.CAREER_EARNINGS_UNLOCK_LEVEL_1 && this.m_rmsCarUnlockLevel < 1) {
            this.m_rmsCarUnlockLevel = 1;
        }
    }

    public void purchaseCareerTunerAccessory(int n, int n2, byte by) {
        this.m_rmsCareerMoney -= this.m_careerTunerAccessoryPrices[n2][by - 1];
        this.m_rmsAccessoryLevel[n][n2] = by;
    }

    public void purchaseCareerCar(byte by) {
        this.m_rmsCareerMoney -= this.getCarPrice(by);
        if (this.m_rmsCareerMoney < 0) {
            this.m_rmsCareerMoney = 0;
        }
        this.addCarToOwnedList(by);
        this.removeCarFromNotOwnedList(by);
    }

    public boolean careerCarOwned(byte by) {
        for (int i = 0; i < this.m_rmsCarsOwned.length; ++i) {
            if (this.m_rmsCarsOwned[i] != by) continue;
            return true;
        }
        return false;
    }

    public void sellCareerCar(byte by) {
        int n = this.getCarSellPrice(by);
        this.m_rmsCareerMoney += n;
        this.removeCarFromOwnedList(by);
        this.resetCarAccessories(by);
        this.addCarToNotOwnedList(by);
        this.rmsSetCareerActiveCarIndex(this.getNthOwnedCar((byte)0));
    }

    public byte getCareerNumCarsOwned() {
        return this.m_careerNumCarsOwned;
    }

    public byte getNthOwnedCar(byte by) {
        return this.m_rmsCarsOwned[by];
    }

    public byte getNthNonOwnedCar(byte by) {
        return this.m_carsNotOwned[by];
    }

    public byte getNthNonOwnedUnlockedCar(byte by) {
        byte by2 = 0;
        for (byte by3 = 0; by3 < (byte)this.m_carsNotOwned.length; by3 = (byte)(by3 + 1)) {
            byte by4 = this.m_carsNotOwned[by3];
            if (by4 == -1 || this.m_carUnlockLevels[by4] > this.m_rmsCarUnlockLevel) continue;
            byte by5 = by2;
            by2 = (byte)(by2 + 1);
            if (by5 != by) continue;
            return by3;
        }
        return by2;
    }

    private byte calcCareerNumCarsOwned() {
        for (byte by = 0; by < this.m_rmsCarsOwned.length; by = (byte)(by + 1)) {
            if (this.m_rmsCarsOwned[by] != -1) continue;
            return by;
        }
        return (byte)this.m_rmsCarsOwned.length;
    }

    private void addCarToOwnedList(byte by) {
        for (int i = 0; this.m_rmsCarsOwned[i] != -1 && i < this.m_rmsCarsOwned.length; ++i) {
        }
        this.m_rmsCarsOwned[i] = by;
        this.m_careerNumCarsOwned = (byte)(this.m_careerNumCarsOwned + 1);
    }

    private void addCarToNotOwnedList(byte by) {
        for (int i = 0; this.m_carsNotOwned[i] != -1 && i < this.m_carsNotOwned.length; ++i) {
        }
        this.m_carsNotOwned[i] = by;
    }

    private void removeCarFromOwnedList(byte by) {
        int n;
        int n2 = -1;
        for (n = 0; n < this.getNumCars(); ++n) {
            if (this.m_rmsCarsOwned[n] != by) continue;
            n2 = n;
        }
        if (n2 >= 0) {
            for (n = n2; n < this.m_rmsCarsOwned.length - 1; ++n) {
                this.m_rmsCarsOwned[n] = this.m_rmsCarsOwned[n + 1];
            }
            this.m_rmsCarsOwned[this.m_rmsCarsOwned.length - 1] = -1;
            this.m_careerNumCarsOwned = (byte)(this.m_careerNumCarsOwned - 1);
        }
    }

    private void removeCarFromNotOwnedList(byte by) {
        int n;
        int n2 = -1;
        for (n = 0; n < this.getNumCars(); ++n) {
            if (this.m_carsNotOwned[n] != by) continue;
            n2 = n;
        }
        if (n2 >= 0) {
            for (n = n2; n < this.m_carsNotOwned.length - 1; ++n) {
                this.m_carsNotOwned[n] = this.m_carsNotOwned[n + 1];
            }
            this.m_carsNotOwned[this.m_carsNotOwned.length - 1] = -1;
        }
    }

    public boolean wasEventHubJustCleared() {
        return this.m_hubJustCleared;
    }

    public byte getEventHubUnlockLevel() {
        return this.m_rmsHubUnlocked;
    }

    public byte getEventHubQuickRaceUnlockLevel() {
        return this.m_rmsHubUnlockedQuickRace;
    }

    public boolean getEventClearedStatus(byte by, byte by2) {
        return this.m_rmsEventsCleared[by][by2];
    }

    public void setEventCleared(byte by, byte by2) {
        this.m_rmsEventsCleared[by][by2] = true;
    }

    public byte getCarAccessoryLevel(int n, int n2) {
        return this.m_rmsAccessoryLevel[n][n2];
    }

    private void resetCarAccessories(int n) {
        byte[] byArray = this.m_rmsAccessoryLevel[n];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
    }

    public void setNextRaceNumLaps(byte by) {
        this.m_nextRaceNumLaps = by;
    }

    public byte getNextRaceNumLaps() {
        return this.m_nextRaceNumLaps;
    }

    public void setNextRaceType(byte by) {
        this.m_nextRaceType = by;
    }

    public byte getNextRaceType() {
        return this.m_nextRaceType;
    }

    public void setLastRaceDriftMoney(int n) {
        this.m_lastRaceDriftMoney = n;
    }

    public int getLastRaceDriftMoney() {
        return this.m_lastRaceDriftMoney;
    }

    public int getLastRacePurseMoney() {
        return this.m_lastRacePurseMoney;
    }

    public int getTrackType(int n) {
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        while (!bl && n2 < this.m_eventTrackIDs.length) {
            n3 = 0;
            while (!bl && n3 < this.m_eventTrackIDs[n2].length) {
                if (this.m_eventTrackIDs[n2][n3] == n) {
                    bl = true;
                    continue;
                }
                ++n3;
            }
            if (bl) continue;
            ++n2;
        }
        if (bl) {
            return this.m_eventTypes[n2][n3];
        }
        return -1;
    }

    public void submitRaceStandings(GameObject[] gameObjectArray) {
        int n;
        int n2;
        if (gameObjectArray == null) {
            this.m_raceStandingsLapTimes = null;
            this.m_brokeBestLapTimeRecord = false;
            this.m_brokeBestRaceTimeRecord = false;
            this.m_brokeBiggestDriftScoreRecord = false;
            this.m_hubJustCleared = false;
            this.m_wonLastRace = false;
            this.m_quitLastRace = true;
            return;
        }
        for (n2 = gameObjectArray.length - 1; n2 > 0; --n2) {
            if (gameObjectArray[n2].m_cumulativeLapTimes != gameObjectArray[n2 - 1].m_cumulativeLapTimes) continue;
            if (n2 == gameObjectArray.length - 1) {
                gameObjectArray[n2].m_cumulativeLapTimes += 4096;
                continue;
            }
            n = gameObjectArray[n2 + 1].m_cumulativeLapTimes - gameObjectArray[n2].m_cumulativeLapTimes;
            gameObjectArray[n2].m_cumulativeLapTimes += n >> 1;
        }
        this.m_raceStandingsLapTimes = new int[gameObjectArray.length];
        for (n2 = 0; n2 < this.m_raceStandingsLapTimes.length; ++n2) {
            this.m_raceStandingsLapTimes[n2] = gameObjectArray[n2].m_cumulativeLapTimes;
        }
        if (this.m_carNowRacingIsCareer) {
            n2 = this.getEventHubEventPurse(this.m_carNowRacingHubIndex, this.m_carNowRacingEventIndex) << 16;
            n = 0;
            if (this.m_raceStandingsPlayerPos == 0) {
                n = MathExt.Fmul(n2, 39322);
            } else if (this.m_raceStandingsPlayerPos == 1) {
                n = MathExt.Fmul(n2, 19661);
            } else if (this.m_raceStandingsPlayerPos == 2) {
                n = MathExt.Fmul(n2, 6554);
            }
            this.m_lastRacePurseMoney = n >> 16;
            if (this.m_lastRacePurseMoney > 0) {
                this.awardCareerPrizeMoney(this.m_lastRacePurseMoney);
            }
        } else {
            this.m_lastRacePurseMoney = 0;
        }
    }

    public int[] getRaceStandings() {
        return this.m_raceStandingsLapTimes;
    }

    public int getPlayerRacePosition() {
        return this.m_raceStandingsPlayerPos;
    }

    public int getCurrTrack() {
        return this.m_currTrack;
    }

    public void setCurrTrack(int n) {
        this.m_currTrack = n;
    }

    public short getTrackNameResID(int n) {
        return this.m_trackInfoNameIDs[n];
    }

    public int getTrackDataResID(int n) {
        return this.m_trackInfoDataIDs[n];
    }

    public int getTrackTheme(int n) {
        return this.m_trackInfoThemeIDs[n];
    }

    public String getTrackName(int n) {
        return this.getString(this.getTrackNameResID(n));
    }

    public short getTrackNameStringID(int n) {
        return this.getTrackNameResID(n);
    }

    public int getNumTracks() {
        return this.m_numTracks;
    }

    public void notifyRacePosition(int n) {
        this.m_wonLastRace = n < 1;
        this.m_quitLastRace = false;
        this.m_raceStandingsPlayerPos = n;
        if (this.m_carNowRacingIsCareer) {
            ++this.m_rmsNumGripRacesFinished;
            byte by = this.getPlayerCarIndex();
            this.m_rmsCarFinishes[by] = this.m_rmsCarFinishes[by] + 1;
            if (this.m_rmsCarFinishes[this.getPlayerCarIndex()] > this.m_rmsCarFinishes[this.m_rmsFavouriteCar]) {
                this.m_rmsFavouriteCar = this.getPlayerCarIndex();
            }
            if (n < 3) {
                ++this.m_rmsNumGripRacesQualified;
                if (n == 0) {
                    ++this.m_rmsNumGripRacesWon;
                }
                if (!this.getEventClearedStatus(this.m_carNowRacingHubIndex, this.m_carNowRacingEventIndex)) {
                    this.setEventCleared(this.m_carNowRacingHubIndex, this.m_carNowRacingEventIndex);
                    boolean bl = true;
                    for (int i = 0; i < this.m_rmsEventsCleared[this.m_carNowRacingHubIndex].length; ++i) {
                        bl = bl && this.m_rmsEventsCleared[this.m_carNowRacingHubIndex][i];
                    }
                    if (bl) {
                        this.m_rmsHubUnlocked = (byte)(this.m_carNowRacingHubIndex + 1);
                        if (this.m_rmsHubUnlocked > this.m_rmsHubUnlockedQuickRace) {
                            this.m_rmsHubUnlockedQuickRace = this.m_rmsHubUnlocked;
                        }
                    }
                    this.m_hubJustCleared = bl;
                } else {
                    this.m_hubJustCleared = false;
                }
            } else {
                this.m_hubJustCleared = false;
            }
        } else {
            this.m_hubJustCleared = false;
        }
    }

    public boolean isCarNowRacingCareer() {
        return this.m_carNowRacingIsCareer;
    }

    public byte getCarNowRacingHubIndex() {
        return this.m_carNowRacingHubIndex;
    }

    public byte getCarNowRacingEventIndex() {
        return this.m_carNowRacingEventIndex;
    }

    public static void createAppEngine(MonkeyApp monkeyApp) {
        m_singletonAppEngine = new AppEngine(monkeyApp);
    }

    public static AppEngine getCanvas() {
        return m_singletonAppEngine;
    }

    private AppEngine(MonkeyApp monkeyApp) {
        super(false);
        Application.getApplication().addKeyListener((KeyListener)this);
        Application.getApplication().addGlobalEventListener((GlobalEventListener)this);
        this.m_midlet = monkeyApp;
        this.m_gameRunning = false;
        this.m_keyBuffer = new int[8];
        this.m_keyBufferIndex = 0;
        this.m_runGarbageCollect = false;
        this.m_resourceManager = new ResourceManager("/");
        this.m_animationManager = new AnimationManager();
        this.m_soundManager = new SoundManager(this.m_resourceManager);
        this.m_soundManager.setEnabled(false);
        this.m_randomInstance = new Random();
        this.m_wrappedLines = new byte[130][55];
        this.m_numWrappedLinesChunk = new short[5];
        this.m_helpAboutNumLinesPerPage = 15;
        if (!this.m_animationManager.loadSubimageFile(this.m_resourceManager)) {
            // empty if block
        }
        if (!this.m_animationManager.loadAnimFile(this.m_resourceManager)) {
            // empty if block
        }
        this.m_animationManager.loadColorsFile(this.m_resourceManager);
        int n = 0;
        while (IMAGE_IDS[n << 1] != -1L) {
            n = (short)(n + 1);
        }
        this.IMAGE_COUNT = (short)n;
        this.m_fixedWhiteFont = MixedFont.loadFromStream(this.m_resourceManager, 13, 1);
        this.m_fixedBlackFont = MixedFont.loadFromStream(this.m_resourceManager, 11, 1);
        this.m_titleFont = MixedFont.loadFromStream(this.m_resourceManager, 15, 1);
        this.loadTrackInfo();
        this.loadCarData();
        this.loadTunershopData();
        this.calculateCarValues();
        this.loadEventHubData();
        this.loadRMSAppSettings();
        this.resetRMSGameData();
        this.loadRMSGameData();
        this.loadStringsByLocale(this.m_rmsEfigsIndex);
        this.initByteArrays();
        this.loadSounds();
        this.loadCommonSoftkeyResources();
        this.loadCommonMenuResources();
    }

    public boolean keyStatus(int n, int n2) {
        return true;
    }

    public boolean keyRepeat(int n, int n2) {
        return true;
    }

    public boolean keyUp(int n, int n2) {
        if (Keypad.key((int)n) == 18 || Keypad.key((int)n) == 17) {
            return false;
        }
        if (Keypad.key((int)n) == 4097) {
            return false;
        }
        if (Keypad.key((int)n) == 4096) {
            return false;
        }
        if (Keypad.key((int)n) == 19) {
            return false;
        }
        this.keyReleased(this.toCanvasKey(n));
        return true;
    }

    public boolean keyDown(int n, int n2) {
        if (Keypad.key((int)n) == 18 || Keypad.key((int)n) == 17) {
            this.hideNotify();
            this.m_soundManager.stopAllSounds();
            return false;
        }
        if (Keypad.key((int)n) == 4097) {
            this.decreaseVolume();
            return false;
        }
        if (Keypad.key((int)n) == 4096) {
            this.increaseVolume();
            return false;
        }
        if (Keypad.key((int)n) == 19) {
            return false;
        }
        this.keyPressed(this.toCanvasKey(n));
        return true;
    }

    private void increaseVolume() {
        if (this.volume < 100) {
            this.volume += 10;
            SoundManager.setVolume(this.volume);
        }
    }

    private void decreaseVolume() {
        if (this.volume > 0) {
            this.volume -= 10;
            SoundManager.setVolume(this.volume);
        }
    }

    public boolean keyChar(char c, int n, int n2) {
        return false;
    }

    public int toCanvasKey(int n) {
        int n2 = Keypad.key((int)n);
        switch (n2) {
            case 27: {
                if (this.m_cancelCommandID == 1) {
                    return -6;
                }
                return -7;
            }
            case 65: {
                return -6;
            }
            case 81: {
                return -6;
            }
            case 80: {
                return -7;
            }
        }
        switch (n2) {
            case 48: {
                return 0;
            }
            case 87: {
                return 0;
            }
            case 69: {
                return 4;
            }
            case 82: {
                return 8;
            }
            case 83: {
                return 16;
            }
            case 68: {
                return 32;
            }
            case 70: {
                return 64;
            }
            case 90: {
                return 128;
            }
            case 88: {
                return 256;
            }
            case 67: {
                return 512;
            }
            case 84: {
                return 2048;
            }
            case 89: {
                return 1024;
            }
        }
        return n;
    }

    protected boolean navigationMovement(int n, int n2, int n3, int n4) {
        block9: {
            int n5;
            block8: {
                if (!this.inMenu) {
                    return true;
                }
                if (n2 <= -1) {
                    for (n5 = n2; n5 < 0; ++n5) {
                        this.keyPressed(8196);
                        this.keyReleased(8196);
                    }
                } else if (n2 >= 1) {
                    for (n5 = 0; n5 < n2; ++n5) {
                        this.keyPressed(16640);
                        this.keyReleased(16640);
                    }
                    this.navDown = n2;
                }
                if (n > -1) break block8;
                for (n5 = n; n5 < 0; ++n5) {
                    this.keyPressed(32784);
                    this.keyReleased(32784);
                }
                break block9;
            }
            if (n < 1) break block9;
            for (n5 = 0; n5 < n; ++n5) {
                this.keyPressed(65600);
                this.keyReleased(65600);
            }
        }
        return true;
    }

    protected boolean navigationClick(int n, int n2) {
        if (!this.inMenu) {
            return true;
        }
        this.keyPressed(4128);
        return true;
    }

    protected boolean navigationUnclick(int n, int n2) {
        if (!this.inMenu) {
            return true;
        }
        this.keyReleased(4128);
        return true;
    }

    protected void onFocusNotify(boolean bl) {
        if (bl) {
            this.showNotify();
        } else {
            this.hideNotify();
        }
    }

    protected void onDisplay() {
        this.repaint();
    }

    protected void onExposed() {
        this.repaint();
    }

    private void initByteArrays() {
        BYTEARRAY_COLON = this.getString(107).getBytes();
        BYTEARRAY_COLON_ZERO = this.getString(108).getBytes();
        BYTEARRAY_DOLLARSIGN = this.getString(146).getBytes();
        this.m_helpAboutPageBytes = new byte[][]{BYTEARRAY_EMPTY, this.getString(110).getBytes(), BYTEARRAY_EMPTY};
    }

    private void loadSounds() {
        SoundManager soundManager = this.getSoundManager();
        soundManager.loadSound(8, 1, 100);
        soundManager.loadSound(7, 1, 100);
        soundManager.loadSound(9, 1, 100);
        soundManager.loadSound(10, 1, 100);
        soundManager.loadSound(2, 1, 99);
        soundManager.loadSound(3, 1, 99);
        soundManager.loadSound(4, 1, 99);
        soundManager.loadSound(5, 1, 99);
        soundManager.loadSound(6, 1, 99);
    }

    public int getHalfWidth() {
        return this.getWidth() >> 1;
    }

    public int getHalfHeight() {
        return this.getHeight() >> 1;
    }

    public ResourceManager getResourceManager() {
        return this.m_resourceManager;
    }

    public AnimationManager getAnimationManager() {
        return this.m_animationManager;
    }

    public SoundManager getSoundManager() {
        return this.m_soundManager;
    }

    public synchronized void start() {
        this.changeScene(0);
        m_paused = false;
    }

    public void end() {
        int n;
        this.m_gameRunning = false;
        if (this.m_currentScene != null) {
            int n2 = n = !this.m_currentScene.isLoadingComplete() ? 1 : 0;
            while (n != 0) {
                try {
                    this.wait(20L);
                    n = !this.m_currentScene.isLoadingComplete() ? 1 : 0;
                }
                catch (Exception exception) {
                    n = 0;
                }
            }
            this.m_currentScene.end();
        }
        this.saveRMSAppSettings();
        this.saveRMSGameData();
        for (n = AnimConstants.IMAGE_RES_IDS.length - 1; n >= 0; --n) {
            this.m_animationManager.unloadImage(this.m_resourceManager, AnimConstants.IMAGE_RES_IDS[n]);
        }
        this.requestGC(true);
        this.m_soundManager.freeAllSounds();
    }

    private void resetRMSAppSettings() {
        this.m_rmsSoundEnabled = false;
        this.m_rmsVibrationEnabled = true;
        this.m_rmsCarMarkersEnabled = true;
        this.m_rmsNumTimesCallToActionShown = 0;
        this.m_rmsEfigsIndex = (byte)-1;
    }

    public void resetRMSGameData() {
        int n;
        int n2;
        this.m_rmsGameExists = false;
        this.m_rmsCareerActiveCarIndex = 0;
        this.m_rmsCareerMoney = 14000;
        this.m_rmsCareerEarnings = 0;
        this.m_rmsCarUnlockLevel = 0;
        this.m_rmsHubUnlocked = 0;
        if (this.m_rmsTrackBestLapTimes == null) {
            this.m_rmsTrackBestLapTimes = new int[this.m_numTracks];
        }
        if (this.m_rmsTrackBestRaceTimes == null) {
            this.m_rmsTrackBestRaceTimes = new int[this.m_numTracks];
        }
        if (this.m_rmsTrackBiggestDriftScores == null) {
            this.m_rmsTrackBiggestDriftScores = new int[this.m_numTracks];
        }
        this.m_rmsNumGripRacesWon = 0;
        this.m_rmsNumGripRacesFinished = 0;
        this.m_rmsNumGripRacesQualified = 0;
        for (n2 = 0; n2 < this.m_rmsTrackBestLapTimes.length; ++n2) {
            this.m_rmsTrackBestLapTimes[n2] = 0;
        }
        if (this.m_rmsEventsCleared == null) {
            this.m_rmsEventsCleared = new boolean[this.m_numEventHubs][];
        }
        for (n2 = 0; n2 < this.m_rmsEventsCleared.length; n2 = (byte)(n2 + 1)) {
            if (this.m_rmsEventsCleared[n2] == null) {
                this.m_rmsEventsCleared[n2] = new boolean[this.getEventHubEventCount((byte)n2)];
            }
            for (n = 0; n < this.getEventHubEventCount((byte)n2); n = (byte)(n + 1)) {
                this.m_rmsEventsCleared[n2][n] = false;
            }
        }
        if (this.m_rmsCarsOwned == null) {
            this.m_rmsCarsOwned = new byte[this.getNumCars()];
        }
        if (this.m_carsNotOwned == null) {
            this.m_carsNotOwned = new byte[this.getNumCars()];
        }
        for (n2 = 0; n2 < this.m_rmsCarsOwned.length; n2 = (byte)(n2 + 1)) {
            this.m_rmsCarsOwned[n2] = -1;
            this.m_carsNotOwned[n2] = n2;
        }
        this.m_careerNumCarsOwned = 0;
        if (this.m_rmsAccessoryLevel == null) {
            this.m_rmsAccessoryLevel = new byte[this.getNumCars()][4];
        }
        for (n2 = 0; n2 < this.getNumCars(); ++n2) {
            for (n = 0; n < 4; ++n) {
                this.m_rmsAccessoryLevel[n2][n] = 0;
            }
        }
        if (this.m_rmsCarFinishes == null) {
            this.m_rmsCarFinishes = new int[this.getNumCars()];
        }
        for (n2 = 0; n2 < this.m_rmsCarFinishes.length; ++n2) {
            this.m_rmsCarFinishes[n2] = 0;
        }
        this.m_rmsFavouriteCar = 0;
        this.m_rmsTutorialShown = false;
    }

    private void loadRMSAppSettings() {
        RecordStore recordStore = null;
        ByteArrayInputStream byteArrayInputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            recordStore = RecordStore.openRecordStore((String)RMS_SETTINGS, (boolean)false);
            byte[] byArray = recordStore.getRecord(1);
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            filterInputStream = new DataInputStream(byteArrayInputStream);
            int n = ((DataInputStream)filterInputStream).readInt();
            if (n == 184) {
                this.m_rmsSoundEnabled = ((DataInputStream)filterInputStream).readBoolean();
                this.m_rmsVibrationEnabled = ((DataInputStream)filterInputStream).readBoolean();
                this.m_rmsCarMarkersEnabled = ((DataInputStream)filterInputStream).readBoolean();
                this.m_rmsNumTimesCallToActionShown = ((DataInputStream)filterInputStream).readByte();
                this.m_rmsEfigsIndex = ((DataInputStream)filterInputStream).readByte();
            } else {
                this.resetRMSAppSettings();
                this.saveRMSAppSettings();
            }
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            this.resetRMSAppSettings();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            filterInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (recordStore != null) {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void loadRMSGameData() {
        RecordStore recordStore = null;
        ByteArrayInputStream byteArrayInputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            recordStore = RecordStore.openRecordStore((String)RMS_DATA, (boolean)false);
            byte[] byArray = recordStore.getRecord(1);
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            filterInputStream = new DataInputStream(byteArrayInputStream);
            int n = ((DataInputStream)filterInputStream).readInt();
            if (n == 184) {
                int n2;
                int n3;
                this.m_rmsGameExists = ((DataInputStream)filterInputStream).readBoolean();
                this.m_rmsCareerActiveCarIndex = ((DataInputStream)filterInputStream).readByte();
                this.m_rmsCareerMoney = ((DataInputStream)filterInputStream).readInt();
                this.m_rmsCareerEarnings = ((DataInputStream)filterInputStream).readInt();
                this.m_rmsCarUnlockLevel = ((DataInputStream)filterInputStream).readByte();
                this.m_rmsHubUnlocked = ((DataInputStream)filterInputStream).readByte();
                this.m_rmsHubUnlockedQuickRace = ((DataInputStream)filterInputStream).readByte();
                for (n3 = 0; n3 < this.m_numTracks; ++n3) {
                    this.m_rmsTrackBestLapTimes[n3] = ((DataInputStream)filterInputStream).readInt();
                }
                for (n3 = 0; n3 < this.m_numTracks; ++n3) {
                    this.m_rmsTrackBestRaceTimes[n3] = ((DataInputStream)filterInputStream).readInt();
                }
                for (n3 = 0; n3 < this.m_numTracks; ++n3) {
                    this.m_rmsTrackBiggestDriftScores[n3] = ((DataInputStream)filterInputStream).readInt();
                }
                this.m_rmsNumGripRacesWon = ((DataInputStream)filterInputStream).readInt();
                this.m_rmsNumGripRacesFinished = ((DataInputStream)filterInputStream).readInt();
                this.m_rmsNumGripRacesQualified = ((DataInputStream)filterInputStream).readInt();
                for (n3 = 0; n3 < this.m_rmsEventsCleared.length; n3 = (int)((byte)(n3 + 1))) {
                    for (n2 = 0; n2 < this.m_rmsEventsCleared[n3].length; n2 = (byte)(n2 + 1)) {
                        this.m_rmsEventsCleared[n3][n2] = ((DataInputStream)filterInputStream).readBoolean();
                    }
                }
                for (n3 = 0; n3 < this.getNumCars(); n3 = (int)((byte)(n3 + 1))) {
                    this.m_rmsCarsOwned[n3] = ((DataInputStream)filterInputStream).readByte();
                }
                this.m_careerNumCarsOwned = this.calcCareerNumCarsOwned();
                n3 = 0;
                for (n2 = 0; n2 < this.getNumCars(); n2 = (byte)(n2 + 1)) {
                    if (this.careerCarOwned((byte)n2)) continue;
                    int n4 = n3;
                    n3 = (byte)(n3 + 1);
                    this.m_carsNotOwned[n4] = n2;
                }
                for (n2 = n3; n2 < this.getNumCars(); n2 = (byte)(n2 + 1)) {
                    int n5 = n3;
                    n3 = (byte)(n3 + 1);
                    this.m_carsNotOwned[n5] = -1;
                }
                if (this.m_rmsAccessoryLevel == null) {
                    this.m_rmsAccessoryLevel = new byte[this.getNumCars()][4];
                }
                for (n2 = 0; n2 < this.m_rmsAccessoryLevel.length; ++n2) {
                    for (int i = 0; i < 4; ++i) {
                        this.m_rmsAccessoryLevel[n2][i] = ((DataInputStream)filterInputStream).readByte();
                    }
                }
                if (this.m_rmsCarFinishes == null) {
                    this.m_rmsCarFinishes = new int[this.getNumCars()];
                }
                for (n2 = 0; n2 < this.m_rmsCarFinishes.length; ++n2) {
                    this.m_rmsCarFinishes[n2] = ((DataInputStream)filterInputStream).readInt();
                }
                this.m_rmsFavouriteCar = ((DataInputStream)filterInputStream).readByte();
                this.m_rmsTutorialShown = ((DataInputStream)filterInputStream).readBoolean();
            } else {
                this.resetRMSGameData();
                this.saveRMSGameData();
            }
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            this.resetRMSGameData();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            filterInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (recordStore != null) {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean saveRMSAppSettings() {
        boolean bl = false;
        RecordStore recordStore = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(184);
            dataOutputStream.writeBoolean(this.m_rmsSoundEnabled);
            dataOutputStream.writeBoolean(this.m_rmsVibrationEnabled);
            dataOutputStream.writeBoolean(this.m_rmsCarMarkersEnabled);
            dataOutputStream.writeByte(this.m_rmsNumTimesCallToActionShown);
            dataOutputStream.writeByte(this.m_rmsEfigsIndex);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            recordStore = RecordStore.openRecordStore((String)RMS_SETTINGS, (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        try {
            dataOutputStream.close();
        }
        catch (Exception exception) {
            bl = true;
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            bl = true;
        }
        if (recordStore != null) {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                bl = true;
            }
        }
        return !bl;
    }

    public boolean saveRMSGameData() {
        boolean bl = false;
        RecordStore recordStore = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            int n;
            int n2;
            dataOutputStream.writeInt(184);
            dataOutputStream.writeBoolean(this.m_rmsGameExists);
            dataOutputStream.writeByte(this.m_rmsCareerActiveCarIndex);
            dataOutputStream.writeInt(this.m_rmsCareerMoney);
            dataOutputStream.writeInt(this.m_rmsCareerEarnings);
            dataOutputStream.writeByte(this.m_rmsCarUnlockLevel);
            dataOutputStream.writeByte(this.m_rmsHubUnlocked);
            dataOutputStream.writeByte(this.m_rmsHubUnlockedQuickRace);
            for (n2 = 0; n2 < this.m_numTracks; ++n2) {
                dataOutputStream.writeInt(this.m_rmsTrackBestLapTimes[n2]);
            }
            for (n2 = 0; n2 < this.m_numTracks; ++n2) {
                dataOutputStream.writeInt(this.m_rmsTrackBestRaceTimes[n2]);
            }
            for (n2 = 0; n2 < this.m_numTracks; ++n2) {
                dataOutputStream.writeInt(this.m_rmsTrackBiggestDriftScores[n2]);
            }
            dataOutputStream.writeInt(this.m_rmsNumGripRacesWon);
            dataOutputStream.writeInt(this.m_rmsNumGripRacesFinished);
            dataOutputStream.writeInt(this.m_rmsNumGripRacesQualified);
            for (n2 = 0; n2 < this.m_rmsEventsCleared.length; n2 = (int)((byte)(n2 + 1))) {
                for (n = 0; n < this.m_rmsEventsCleared[n2].length; n = (int)((byte)(n + 1))) {
                    dataOutputStream.writeBoolean(this.m_rmsEventsCleared[n2][n]);
                }
            }
            for (n2 = 0; n2 < this.getNumCars(); n2 = (int)((byte)(n2 + 1))) {
                dataOutputStream.writeByte(this.m_rmsCarsOwned[n2]);
            }
            for (n2 = 0; n2 < this.getNumCars(); ++n2) {
                for (n = 0; n < 4; ++n) {
                    dataOutputStream.writeByte(this.m_rmsAccessoryLevel[n2][n]);
                }
            }
            for (n2 = 0; n2 < this.m_rmsCarFinishes.length; ++n2) {
                dataOutputStream.writeInt(this.m_rmsCarFinishes[n2]);
            }
            dataOutputStream.writeByte(this.m_rmsFavouriteCar);
            dataOutputStream.writeBoolean(this.m_rmsTutorialShown);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            recordStore = RecordStore.openRecordStore((String)RMS_DATA, (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        try {
            dataOutputStream.close();
        }
        catch (Exception exception) {
            bl = true;
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            bl = true;
        }
        if (recordStore != null) {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                bl = true;
            }
        }
        return !bl;
    }

    public void showNotify() {
        if (m_paused) {
            this.resumeGame();
            this.startThread();
        }
    }

    public void hideNotify() {
        this.pauseGame();
    }

    public void startThread() {
        this.m_gameRunning = true;
        if (this.m_gameTimer != null) {
            this.m_gameTimer.cancel();
            this.m_gameTimer = null;
            System.gc();
        }
        this.m_gameTimer = new Timer();
        this.m_gameTimer.schedule(new TimerTask(){
            long timeStartFrame = System.currentTimeMillis();

            public void run() {
                if (!AppEngine.this.m_gameRunning) {
                    AppEngine.this.m_midlet.destroyApp(true);
                    return;
                }
                if (!m_paused && !AppEngine.this.m_paintScheduled) {
                    AppEngine.this.m_paintScheduled = true;
                    long l = System.currentTimeMillis();
                    AppEngine.this.runLoop((int)(l - this.timeStartFrame));
                    this.timeStartFrame = l;
                    AppEngine.this.repaint();
                }
            }
        }, 0L, 10L);
    }

    public void runLoop(int n) {
        int n2;
        if (this.m_soundManager != null) {
            this.m_soundManager.update(n > 0 ? n : 0);
        }
        for (n2 = this.m_keyBufferIndex - 1; n2 >= 0; --n2) {
            if (this.m_keyBuffer[n2] >= 0) continue;
            m_keysPressedDown &= ~(-this.m_keyBuffer[n2]);
            if (-this.m_keyBuffer[n2] != 131072 && -this.m_keyBuffer[n2] != 262144 && -this.m_keyBuffer[n2] != 524288) continue;
            m_commandPressedDown = 0;
        }
        for (n2 = this.m_keyBufferIndex - 1; n2 >= 0; --n2) {
            if (this.m_keyBuffer[n2] <= 0) continue;
            m_keysPressedDown |= this.m_keyBuffer[n2];
            if (this.m_keyBuffer[n2] == 524288) {
                m_commandPressedDown = 3;
                continue;
            }
            if (this.m_keyBuffer[n2] == 262144) {
                m_commandPressedDown = this.m_selectCommandID;
                continue;
            }
            if (this.m_keyBuffer[n2] != 131072) continue;
            m_commandPressedDown = this.m_cancelCommandID;
        }
        this.update(n);
        n2 = 0;
        for (int i = 1; i <= 18; ++i) {
            for (int j = 0; j < this.m_keyBufferIndex; ++j) {
                if (this.m_keyBuffer[j] < 0) {
                    n2 |= -this.m_keyBuffer[j];
                } else if (n2 == 1 << i && this.m_keyBuffer[j] > 0) {
                    n2 &= ~this.m_keyBuffer[j];
                }
                this.m_keyBuffer[j] = 0;
            }
        }
        this.m_keyBufferIndex = 0;
        this.clearKeyBit(n2);
        if (this.m_runGarbageCollect) {
            System.gc();
            this.m_runGarbageCollect = false;
        }
    }

    public boolean endGame(String string) {
        try {
            this.m_midlet.platformRequest(string);
            this.endGame();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void endGame() {
        this.m_soundManager.stopAllSounds();
        this.m_gameRunning = false;
    }

    public void endGameOnErrorMsg(String string) {
    }

    public void pauseGame() {
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.clearCommandKeys();
        this.clearKeysPressedDown();
        if (this.m_soundManager != null) {
            this.m_soundManager.appPause();
        }
        if (this.m_currentScene != null) {
            this.m_currentScene.pause();
        }
        m_paused = true;
    }

    public void resumeGame() {
        if (this.m_soundManager != null) {
            this.m_soundManager.appResume();
        }
        if (this.m_currentScene != null && this.m_currentScene.isLoadingComplete()) {
            this.m_currentScene.resume();
        }
        this.clearCommandKeys();
        this.clearKeysPressedDown();
        this.m_keyBufferIndex = 0;
        m_paused = false;
    }

    public boolean isPaused() {
        return m_paused;
    }

    public boolean isGameEnded() {
        return !this.m_gameRunning;
    }

    public int rand(int n, int n2) {
        int n3 = this.m_randomInstance.nextInt() & Integer.MAX_VALUE;
        int n4 = n2 - n + 1;
        return n + n3 % n4;
    }

    public void seedRand(long l) {
        this.m_randomInstance.setSeed(l);
    }

    public void vibrate(int n) {
        if (this.m_rmsVibrationEnabled) {
            try {
                Display.getDisplay((MIDlet)this.m_midlet).vibrate(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final void update(int n) {
        if (n > 250) {
            n = 250;
        }
        n = this.getAverageInterval(n);
        if (this.m_currentScene != null && this.m_currentScene != null) {
            this.m_currentScene.processKeys(m_keysPressedDown, m_commandPressedDown);
            this.m_currentScene.update(n);
        }
    }

    public final synchronized void paint(Graphics graphics) {
        if (this.m_currentScene != null && this.m_gameRunning) {
            if (!this.m_currentScene.isLoadingComplete()) {
                this.renderLoadingScreen(graphics);
            } else {
                this.m_currentScene.render(graphics);
            }
        }
        this.m_paintScheduled = false;
    }

    void renderLoadingScreen(Graphics graphics) {
    }

    void renderOverlay(Graphics graphics) {
    }

    public void keyPressed(int n) {
        if (this.m_keyBufferIndex < this.m_keyBuffer.length) {
            switch (n) {
                case -8: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = 32;
                    break;
                }
                case 49: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = 2;
                    break;
                }
                case 1: 
                case 4: 
                case 50: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = 4;
                    break;
                }
                case 51: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = 8;
                    break;
                }
                case 2: 
                case 16: 
                case 52: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = 16;
                    break;
                }
                case 32: 
                case 53: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = 32;
                    break;
                }
                case 5: 
                case 54: 
                case 64: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = 64;
                    break;
                }
                case 55: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = 128;
                    break;
                }
                case 6: 
                case 56: 
                case 256: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = 256;
                    break;
                }
                case 57: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = 512;
                    break;
                }
                case 48: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = 1;
                    break;
                }
                case 35: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = 1024;
                    break;
                }
                case 42: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = 2048;
                    break;
                }
                case -6: 
                case 97: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = 131072;
                    break;
                }
                case -7: 
                case 112: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = 262144;
                    break;
                }
                case 888: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = 524288;
                }
            }
        }
    }

    public void keyReleased(int n) {
        if (this.m_keyBufferIndex < this.m_keyBuffer.length) {
            switch (n) {
                case -8: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = -32;
                    break;
                }
                case 49: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = -2;
                    break;
                }
                case 1: 
                case 4: 
                case 50: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = -4;
                    break;
                }
                case 51: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = -8;
                    break;
                }
                case 2: 
                case 16: 
                case 52: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = -16;
                    break;
                }
                case 32: 
                case 53: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = -32;
                    break;
                }
                case 5: 
                case 54: 
                case 64: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = -64;
                    break;
                }
                case 55: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = -128;
                    break;
                }
                case 6: 
                case 56: 
                case 256: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = -256;
                    break;
                }
                case 57: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = -512;
                    break;
                }
                case 48: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = -1;
                    break;
                }
                case 35: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = -1024;
                    break;
                }
                case 42: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = -2048;
                    break;
                }
                case -6: 
                case 97: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = -131072;
                    break;
                }
                case -7: 
                case 112: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = -262144;
                    break;
                }
                case 888: {
                    this.m_keyBuffer[this.m_keyBufferIndex++] = -524288;
                }
            }
        }
    }

    public void clearKeyBit(int n) {
        m_keysPressedDown &= ~n;
    }

    public void clearKeysPressedDown() {
        m_keysPressedDown = 0;
    }

    public void clearCommandKeys() {
        m_commandPressedDown = 0;
        this.clearKeyBit(524288);
    }

    public void setSoftKeys(int n, int n2) {
        int n3 = n;
        n = n2;
        n2 = n3;
        if (n2 != this.m_selectCommandID) {
            this.m_selectCommandID = n2;
        }
        if (n != this.m_cancelCommandID) {
            this.m_cancelCommandID = n;
        }
    }

    private int getCommandString(int n) {
        switch (n) {
            case 0: {
                return -1;
            }
            case 1: {
                return 9;
            }
            case 2: {
                return 10;
            }
            case 3: {
                return 11;
            }
            case 4: {
                return 17;
            }
            case 5: {
                return 18;
            }
            case 6: {
                return 19;
            }
            case 7: {
                return 20;
            }
            case 8: {
                return 21;
            }
            case 9: {
                return 22;
            }
            case 10: {
                return 23;
            }
            case 11: {
                return 24;
            }
            case 12: {
                return 25;
            }
        }
        return -1;
    }

    public int getSelectCommandID() {
        return this.m_selectCommandID;
    }

    public int getCancelCommandID() {
        return this.m_cancelCommandID;
    }

    void drawChars(Graphics graphics, byte[][] byArray, MixedFont mixedFont, int n, int n2, int n3) {
        byte[] byArray2;
        int n4;
        int n5 = mixedFont.getSpacing();
        int n6 = n;
        if ((n3 & 1) != 0 || (n3 & 8) != 0) {
            n4 = -n5;
            for (int i = 0; i < byArray.length; ++i) {
                byArray2 = byArray[i];
                n4 += mixedFont.getStringWidth(byArray2, 0, byArray2.length) + n5;
            }
            if ((n3 & 1) != 0) {
                n6 -= n4 >> 1;
                n3 = n3 & 0xFFFFFFFE | 4;
            } else if ((n3 & 8) != 0) {
                n6 -= n4;
                n3 = n3 & 0xFFFFFFF7 | 4;
            }
        }
        for (n4 = 0; n4 < byArray.length; ++n4) {
            byArray2 = byArray[n4];
            mixedFont.drawChars(graphics, byArray2, 0, byArray2.length, n6, n2, n3);
            n6 += mixedFont.getStringWidth(byArray2, 0, byArray2.length) + n5;
        }
    }

    void drawChars(Graphics graphics, byte[] byArray, MixedFont mixedFont, int n, int n2, int n3) {
        mixedFont.drawChars(graphics, byArray, 0, byArray.length, n, n2, n3);
    }

    public void drawString(Graphics graphics, int n, MixedFont mixedFont, int n2, int n3, int n4) {
        mixedFont.drawChars(graphics, this.m_stringChars, this.getStringOffset(n), this.getStringLength(n), n2, n3, n4);
    }

    public void drawString(Graphics graphics, String string, MixedFont mixedFont, int n, int n2, int n3) {
        mixedFont.drawString(graphics, string, n, n2, n3);
    }

    public void drawWrappedString(Graphics graphics, MixedFont mixedFont, int n, int n2, int n3, int n4) {
        if (this.m_numWrappedLines <= 0) {
            AppEngine.debug("drawWrappedString() error: (m_numWrappedLines <= 0)");
            return;
        }
        int n5 = n3;
        if ((n4 & 0x20) != 0) {
            n5 -= mixedFont.getLineHeight() + n * (this.m_numWrappedLines - 1);
            n4 &= 0xFFFFFFDF;
            n4 |= 0x10;
        } else if ((n4 & 2) != 0) {
            n5 -= mixedFont.getLineHeight() + n * (this.m_numWrappedLines - 1) >> 1;
            n4 &= 0xFFFFFFFD;
            n4 |= 0x10;
        }
        int n6 = graphics.getClipY();
        int n7 = graphics.getClipHeight();
        int n8 = mixedFont.getLineHeight();
        for (int i = 0; i < this.m_numWrappedLines; ++i) {
            if (n5 + n8 > n6 && n5 - n8 < n6 + n7) {
                mixedFont.drawChars(graphics, this.m_wrappedLines[i], 0, 55, n2, n5, n4);
            }
            if (n5 - n8 > n6 + n7) {
                return;
            }
            n5 += n;
        }
    }

    public void drawPartWrappedString(Graphics graphics, MixedFont mixedFont, int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.m_numWrappedLines <= 0) {
            return;
        }
        int n7 = n3;
        if ((n4 & 0x20) != 0) {
            n7 -= mixedFont.getLineHeight() + n * (n6 - 1);
            n4 &= 0xFFFFFFDF;
            n4 |= 0x10;
        } else if ((n4 & 2) != 0) {
            n7 -= mixedFont.getLineHeight() + n * (n6 - 1) >> 1;
            n4 &= 0xFFFFFFFD;
            n4 |= 0x10;
        }
        int n8 = graphics.getClipY();
        int n9 = graphics.getClipHeight();
        int n10 = mixedFont.getLineHeight();
        int n11 = n5 + n6;
        if (n11 > this.m_numWrappedLines) {
            n11 = this.m_numWrappedLines;
        }
        for (int i = n5; i < n11; ++i) {
            if (n7 + n10 > n8 && n7 - n10 < n8 + n9) {
                mixedFont.drawChars(graphics, this.m_wrappedLines[i], 0, 55, n2, n7, n4);
            }
            if (n7 - n10 > n8 + n9) {
                return;
            }
            n7 += n;
        }
    }

    public int wrapText(int n, MixedFont mixedFont, int n2) {
        this.m_numWrappedLines = this.wrapText(this.m_stringChars, this.getStringOffset(n), this.getStringLength(n), mixedFont, n2, 0);
        return this.m_numWrappedLines;
    }

    public void drawWrappedStringChunk(int n, Graphics graphics, MixedFont mixedFont, int n2, int n3, int n4, int n5) {
        if (this.m_numWrappedLinesChunk[n] <= 0) {
            return;
        }
        int n6 = n4;
        if ((n5 & 0x20) != 0) {
            n6 -= mixedFont.getLineHeight() + n2 * (this.m_numWrappedLinesChunk[n] - 1);
            n5 &= 0xFFFFFFDF;
            n5 |= 0x10;
        } else if ((n5 & 2) != 0) {
            n6 -= mixedFont.getLineHeight() + n2 * (this.m_numWrappedLinesChunk[n] - 1) >> 1;
            n5 &= 0xFFFFFFFD;
            n5 |= 0x10;
        }
        int n7 = graphics.getClipY();
        int n8 = graphics.getClipHeight();
        int n9 = mixedFont.getLineHeight();
        int n10 = n * 5;
        for (int i = 0; i < this.m_numWrappedLinesChunk[n]; ++i) {
            if (n6 + n9 > n7 && n6 - n9 < n7 + n8) {
                mixedFont.drawChars(graphics, this.m_wrappedLines[n10 + i], 0, 55, n3, n6, n5);
            }
            if (n6 - n9 > n7 + n8) {
                return;
            }
            n6 += n2;
        }
    }

    public void drawWrappedStringChunkClipped(int n, Graphics graphics, MixedFont mixedFont, int n2, int n3, int n4, int n5, int n6) {
        if (this.m_numWrappedLinesChunk[n] <= 0) {
            return;
        }
        int n7 = Math.min(n3, this.m_numWrappedLinesChunk[n]);
        int n8 = n5;
        if ((n6 & 0x20) != 0) {
            n8 -= mixedFont.getLineHeight() + n2 * (n7 - 1);
            n6 &= 0xFFFFFFDF;
            n6 |= 0x10;
        } else if ((n6 & 2) != 0) {
            n8 -= mixedFont.getLineHeight() + n2 * (n7 - 1) >> 1;
            n6 &= 0xFFFFFFFD;
            n6 |= 0x10;
        }
        int n9 = graphics.getClipY();
        int n10 = graphics.getClipHeight();
        int n11 = mixedFont.getLineHeight();
        int n12 = n * 5;
        for (int i = 0; i < n7; ++i) {
            if (n8 + n11 > n9 && n8 - n11 < n9 + n10) {
                mixedFont.drawChars(graphics, this.m_wrappedLines[n12 + i], 0, 55, n4, n8, n6);
            }
            if (n8 - n11 > n9 + n10) {
                return;
            }
            n8 += n2;
        }
        if (n7 < this.m_numWrappedLinesChunk[n]) {
            mixedFont.drawString(graphics, "...", (n4 += mixedFont.getStringWidth(this.m_wrappedLines[n12 + n7 - 1], 0, 55)) + 1, n8 -= n2, 20);
        }
    }

    public int wrapTextChunk(int n, int n2, MixedFont mixedFont, int n3) {
        int n4 = n * 5;
        this.m_numWrappedLinesChunk[n] = (short)this.wrapText(this.m_stringChars, this.getStringOffset(n2), this.getStringLength(n2), mixedFont, n3, n4);
        return this.m_numWrappedLinesChunk[n];
    }

    int wrapMoreText(int n, MixedFont mixedFont, int n2) {
        this.m_numWrappedLines += this.wrapText(this.m_stringChars, this.getStringOffset(n), this.getStringLength(n), mixedFont, n2, this.m_numWrappedLines);
        return this.m_numWrappedLines;
    }

    int wrapMoreText(byte[] byArray, MixedFont mixedFont, int n) {
        this.m_numWrappedLines += this.wrapText(byArray, 0, byArray.length, mixedFont, n, this.m_numWrappedLines);
        return this.m_numWrappedLines;
    }

    public int wrapText(byte[] byArray, int n, int n2, MixedFont mixedFont, int n3, int n4) {
        boolean bl = false;
        int n5 = 0;
        int n6 = n;
        int n7 = 0;
        int n8 = 0;
        do {
            int n9;
            int n10;
            int n11;
            for (n11 = n6; n11 < n + n2; ++n11) {
                n10 = mixedFont.getStringWidth(byArray, n6, n11 - n6);
                if (n10 > n3) {
                    if (n7 != 0) break;
                    n7 = n10;
                    n8 = n11;
                    break;
                }
                n9 = byArray[n11];
                if (n9 != 127 && n9 != 10 && n9 != 22 && n11 != n + n2 - 1) continue;
                n7 = n10;
                n8 = n11;
                if ((char)byArray[n11] == '\u0016' || n11 == n + n2 - 1) {
                    n7 += mixedFont.getCharWidth(byArray[n11]);
                    ++n8;
                }
                if ((char)byArray[n11] == '\u007f') break;
            }
            if (n7 == 0 && (n8 >= n + n2 - 1 || (char)byArray[n8] != '\u007f')) {
                n7 = mixedFont.getStringWidth(byArray, n6, n + n2 - n6);
                n8 = n + n2;
                bl = false;
            } else {
                bl = true;
            }
            n11 = 0;
            n10 = n6;
            while (n10 < n8) {
                this.m_wrappedLines[n4 + n5][n11++] = byArray[n10++];
            }
            n9 = n4 + n5++;
            this.m_wrappedLines[n9][n11] = -1;
            n6 = n8 + 1;
            if (n8 <= n || n8 >= byArray.length || (char)byArray[n8] == '\u007f' || (char)byArray[n8] != '\n') {
                // empty if block
            }
            n7 = 0;
            n8 = --n6;
        } while (bl);
        return n5 - 1;
    }

    public static byte[][] fixedToTimeBytes(int n) {
        int n2 = (n >> 16) / 60;
        byte[] byArray = AppEngine.stringToByteArray(MathExt.fixedToString2DP(n - (n2 * 60 << 16)));
        byte[][] byArrayArray = n2 > 0 ? new byte[][]{AppEngine.intToByteArray(n2), byArray.length < 5 ? BYTEARRAY_COLON_ZERO : BYTEARRAY_COLON, byArray} : new byte[][]{byArray};
        return byArrayArray;
    }

    public static byte[] intToByteArray(int n) {
        String string = String.valueOf(n);
        byte[] byArray = new byte[string.length()];
        for (int i = byArray.length - 1; i >= 0; --i) {
            byArray[i] = (byte)(string.charAt(i) - 48);
        }
        return byArray;
    }

    public static int intToByteArray(int n, byte[] byArray) {
        boolean bl = false;
        int n2 = byArray.length - 1;
        do {
            byte by = (byte)(n % 10);
            n /= 10;
            if (byArray[n2] != by) {
                bl = true;
            }
            byArray[n2--] = by;
        } while (n > 0);
        if (bl) {
            return n2 + 1;
        }
        return -1;
    }

    public static byte[] stringToByteArray(String string) {
        byte[] byArray = new byte[string.length()];
        for (int i = byArray.length - 1; i >= 0; --i) {
            int n = string.charAt(i);
            switch (n) {
                case 48: {
                    n = 0;
                    break;
                }
                case 49: {
                    n = 1;
                    break;
                }
                case 50: {
                    n = 2;
                    break;
                }
                case 51: {
                    n = 3;
                    break;
                }
                case 52: {
                    n = 4;
                    break;
                }
                case 53: {
                    n = 5;
                    break;
                }
                case 54: {
                    n = 6;
                    break;
                }
                case 55: {
                    n = 7;
                    break;
                }
                case 56: {
                    n = 8;
                    break;
                }
                case 57: {
                    n = 9;
                    break;
                }
                case 32: {
                    n = 10;
                    break;
                }
                case 33: {
                    n = 11;
                    break;
                }
                case 35: {
                    n = 12;
                    break;
                }
                case 36: {
                    n = 13;
                    break;
                }
                case 37: {
                    n = 14;
                    break;
                }
                case 38: {
                    n = 15;
                    break;
                }
                case 39: {
                    n = 16;
                    break;
                }
                case 40: {
                    n = 17;
                    break;
                }
                case 41: {
                    n = 18;
                    break;
                }
                case 42: {
                    n = 19;
                    break;
                }
                case 43: {
                    n = 20;
                    break;
                }
                case 44: {
                    n = 21;
                    break;
                }
                case 45: {
                    n = 22;
                    break;
                }
                case 46: {
                    n = 23;
                    break;
                }
                case 47: {
                    n = 24;
                    break;
                }
                case 58: {
                    n = 25;
                    break;
                }
                case 59: {
                    n = 26;
                    break;
                }
                case 60: {
                    n = 27;
                    break;
                }
                case 61: {
                    n = 28;
                    break;
                }
                case 62: {
                    n = 29;
                    break;
                }
                case 63: {
                    n = 30;
                    break;
                }
                case 64: {
                    n = 31;
                    break;
                }
                case 65: {
                    n = 32;
                    break;
                }
                case 66: {
                    n = 33;
                    break;
                }
                case 67: {
                    n = 34;
                    break;
                }
                case 68: {
                    n = 35;
                    break;
                }
                case 69: {
                    n = 36;
                    break;
                }
                case 70: {
                    n = 37;
                    break;
                }
                case 71: {
                    n = 38;
                    break;
                }
                case 72: {
                    n = 39;
                    break;
                }
                case 73: {
                    n = 40;
                    break;
                }
                case 74: {
                    n = 41;
                    break;
                }
                case 75: {
                    n = 42;
                    break;
                }
                case 76: {
                    n = 43;
                    break;
                }
                case 77: {
                    n = 44;
                    break;
                }
                case 78: {
                    n = 45;
                    break;
                }
                case 79: {
                    n = 46;
                    break;
                }
                case 80: {
                    n = 47;
                    break;
                }
                case 81: {
                    n = 48;
                    break;
                }
                case 82: {
                    n = 49;
                    break;
                }
                case 83: {
                    n = 50;
                    break;
                }
                case 84: {
                    n = 51;
                    break;
                }
                case 85: {
                    n = 52;
                    break;
                }
                case 86: {
                    n = 53;
                    break;
                }
                case 87: {
                    n = 54;
                    break;
                }
                case 88: {
                    n = 55;
                    break;
                }
                case 89: {
                    n = 56;
                    break;
                }
                case 90: {
                    n = 57;
                    break;
                }
                case 192: {
                    n = 58;
                    break;
                }
                case 193: {
                    n = 59;
                    break;
                }
                case 196: {
                    n = 60;
                    break;
                }
                case 198: {
                    n = 61;
                    break;
                }
                case 199: {
                    n = 62;
                    break;
                }
                case 200: {
                    n = 63;
                    break;
                }
                case 201: {
                    n = 64;
                    break;
                }
                case 202: {
                    n = 65;
                    break;
                }
                case 204: {
                    n = 66;
                    break;
                }
                case 205: {
                    n = 67;
                    break;
                }
                case 206: {
                    n = 68;
                    break;
                }
                case 209: {
                    n = 69;
                    break;
                }
                case 210: {
                    n = 70;
                    break;
                }
                case 211: {
                    n = 71;
                    break;
                }
                case 212: {
                    n = 72;
                    break;
                }
                case 214: {
                    n = 73;
                    break;
                }
                case 217: {
                    n = 74;
                    break;
                }
                case 218: {
                    n = 75;
                    break;
                }
                case 219: {
                    n = 76;
                    break;
                }
                case 220: {
                    n = 77;
                    break;
                }
                case 223: {
                    n = 78;
                    break;
                }
                case 338: {
                    n = 79;
                    break;
                }
                case 161: {
                    n = 80;
                    break;
                }
                case 191: {
                    n = 81;
                    break;
                }
                case 97: {
                    n = 82;
                    break;
                }
                case 98: {
                    n = 83;
                    break;
                }
                case 99: {
                    n = 84;
                    break;
                }
                case 100: {
                    n = 85;
                    break;
                }
                case 101: {
                    n = 86;
                    break;
                }
                case 102: {
                    n = 87;
                    break;
                }
                case 103: {
                    n = 88;
                    break;
                }
                case 104: {
                    n = 89;
                    break;
                }
                case 105: {
                    n = 90;
                    break;
                }
                case 106: {
                    n = 91;
                    break;
                }
                case 107: {
                    n = 92;
                    break;
                }
                case 108: {
                    n = 93;
                    break;
                }
                case 109: {
                    n = 94;
                    break;
                }
                case 110: {
                    n = 95;
                    break;
                }
                case 111: {
                    n = 96;
                    break;
                }
                case 112: {
                    n = 97;
                    break;
                }
                case 113: {
                    n = 98;
                    break;
                }
                case 114: {
                    n = 99;
                    break;
                }
                case 115: {
                    n = 100;
                    break;
                }
                case 116: {
                    n = 101;
                    break;
                }
                case 117: {
                    n = 102;
                    break;
                }
                case 118: {
                    n = 103;
                    break;
                }
                case 119: {
                    n = 104;
                    break;
                }
                case 120: {
                    n = 105;
                    break;
                }
                case 121: {
                    n = 106;
                    break;
                }
                case 122: {
                    n = 107;
                    break;
                }
                case 224: {
                    n = 108;
                    break;
                }
                case 225: {
                    n = 109;
                    break;
                }
                case 228: {
                    n = 110;
                    break;
                }
                case 230: {
                    n = 111;
                    break;
                }
                case 231: {
                    n = 112;
                    break;
                }
                case 232: {
                    n = 113;
                    break;
                }
                case 233: {
                    n = 114;
                    break;
                }
                case 234: {
                    n = 115;
                    break;
                }
                case 236: {
                    n = 116;
                    break;
                }
                case 237: {
                    n = 117;
                    break;
                }
                case 238: {
                    n = 118;
                    break;
                }
                case 241: {
                    n = 119;
                    break;
                }
                case 242: {
                    n = 120;
                    break;
                }
                case 243: {
                    n = 121;
                    break;
                }
                case 246: {
                    n = 122;
                    break;
                }
                case 249: {
                    n = 123;
                    break;
                }
                case 250: {
                    n = 124;
                    break;
                }
                case 252: {
                    n = 125;
                    break;
                }
                case 339: {
                    n = 126;
                    break;
                }
                case 124: {
                    n = 127;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            byArray[i] = (byte)n;
        }
        return byArray;
    }

    public MixedFont getFont(int n) {
        switch (n) {
            default: {
                return null;
            }
            case 1: {
                return this.m_fixedWhiteFont;
            }
            case 2: {
                return this.m_fixedBlackFont;
            }
            case 3: 
        }
        return this.m_titleFont;
    }

    public String getString(int n) {
        return new String(this.m_stringChars, this.getStringOffset(n), this.getStringLength(n));
    }

    public int getStringOffset(int n) {
        return this.m_stringOffsets[n << 1];
    }

    public int getStringLength(int n) {
        return this.m_stringOffsets[(n << 1) + 1];
    }

    public int getStringWidth(int n, MixedFont mixedFont) {
        return mixedFont.getStringWidth(this.m_stringChars, this.getStringOffset(n), this.getStringLength(n));
    }

    public void loadStringsByLocale(byte by) {
        if (by == -1) {
            String string = null;
            try {
                string = this.m_midlet.getAppProperty("Force-Locale").toLowerCase();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (string == null || string.length() == 0) {
                string = "auto";
            }
            if (!(!string.startsWith("auto") && (string.startsWith("de") || string.startsWith("en") || string.startsWith("es") || string.startsWith("fr") || string.startsWith("it") || string.startsWith("menu")))) {
                String string2 = System.getProperty("microedition.locale").toLowerCase();
                string = string2 != null && string2.length() != 0 ? string2 : (string.startsWith("auto-") ? string.substring(5) : null);
            }
            if (string != null && string.length() != 0) {
                if (string.startsWith("de")) {
                    by = (byte)3;
                } else if (string.startsWith("en")) {
                    by = 0;
                } else if (string.startsWith("es")) {
                    by = (byte)4;
                } else if (string.startsWith("fr")) {
                    by = 1;
                } else if (string.startsWith("it")) {
                    by = (byte)2;
                }
            }
        }
        if (by >= 0 && by < STRINGS_BY_LOCALE.length) {
            this.loadStrings(this.m_resourceManager.loadBinaryFile(STRINGS_BY_LOCALE[by]));
            this.m_rmsEfigsIndex = by;
        } else {
            this.loadStrings(this.m_resourceManager.loadBinaryFile(STRINGS_BY_LOCALE[0]));
            this.m_rmsEfigsIndex = (byte)-1;
        }
    }

    private void loadStrings(InputStream inputStream) {
        try {
            int n;
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n2 = dataInputStream.readUnsignedShort();
            int n3 = dataInputStream.readUnsignedShort();
            int n4 = dataInputStream.readUnsignedShort();
            this.m_stringOffsets = new int[n3 << 1];
            for (n = 0; n < n3 << 1; n += 2) {
                this.m_stringOffsets[n] = dataInputStream.readShort();
                this.m_stringOffsets[n + 1] = dataInputStream.readShort();
            }
            this.m_stringChars = new byte[n4 + 1];
            for (n = 0; n < n4; ++n) {
                this.m_stringChars[n] = dataInputStream.readByte();
            }
            this.m_stringChars[n4] = 0;
        }
        catch (IOException iOException) {
            System.err.println("Error loading strings");
        }
    }

    int getNumWrappedLines() {
        return this.m_numWrappedLines;
    }

    public void resetScrollers() {
        for (int i = 0; i < this.m_scrollerStringId.length; ++i) {
            this.m_scrollerStringId[i] = -1;
            this.m_scrollerStringArray[i] = null;
        }
    }

    private void setupScroller(int n, MixedFont mixedFont, int n2) {
        if (n < this.m_scrollerStringId.length) {
            this.m_scrollerTime[n] = 0L;
            this.m_scrollerStringId[n] = n2;
            this.m_scrollerStringArray[n] = null;
            if (this.m_scrollerStringId[n] != -1) {
                this.m_scrollerStringWidth[n] = this.getStringWidth(n2, mixedFont);
                this.m_scrollerOffset[n] = 0;
            }
        }
    }

    private void setupScroller(int n, MixedFont mixedFont, byte[][] byArray) {
        if (n < this.m_scrollerStringId.length) {
            this.m_scrollerTime[n] = 0L;
            this.m_scrollerStringId[n] = -1;
            this.m_scrollerStringArray[n] = byArray;
            if (this.m_scrollerStringArray[n] != null) {
                int n2 = mixedFont.getSpacing();
                int n3 = 0;
                for (int i = 0; i < byArray.length; ++i) {
                    byte[] byArray2 = byArray[i];
                    n3 += mixedFont.getStringWidth(byArray2, 0, byArray2.length) + n2;
                }
                this.m_scrollerStringWidth[n] = n3;
                this.m_scrollerOffset[n] = 0;
            }
        }
    }

    public void updateScrollers(long l) {
        for (int i = 0; i < this.m_scrollerStringId.length; ++i) {
            if (this.m_scrollerStringId[i] == -1 && this.m_scrollerStringArray[i] == null) continue;
            int n = i;
            this.m_scrollerTime[n] = this.m_scrollerTime[n] + l;
            if (this.m_scrollerTime[i] <= 1500L) continue;
            long l2 = this.m_scrollerTime[i] - 1500L;
            this.m_scrollerOffset[i] = (int)(l2 * 20L >> 10);
            int n2 = this.m_scrollerStringWidth[i] + 20;
            if (this.m_scrollerOffset[i] < n2) continue;
            int n3 = i;
            this.m_scrollerOffset[n3] = this.m_scrollerOffset[n3] - n2;
            int n4 = i;
            this.m_scrollerTime[n4] = this.m_scrollerTime[n4] - (long)((n2 << 10) / 20);
        }
    }

    public void renderScroller(int n, Graphics graphics, int n2, MixedFont mixedFont, int n3, int n4, int n5, int n6) {
        if (n >= this.m_scrollerStringId.length) {
            return;
        }
        if (this.m_scrollerStringId[n] != n2) {
            this.setupScroller(n, mixedFont, n2);
        }
        if (this.m_scrollerStringWidth[n] <= n5) {
            this.drawString(graphics, n2, mixedFont, n3, n4, n6);
        } else {
            int n7 = graphics.getClipX();
            int n8 = graphics.getClipY();
            int n9 = graphics.getClipWidth();
            int n10 = graphics.getClipHeight();
            int n11 = n3;
            if ((n6 & 1) != 0) {
                n11 = n3 - (n5 >> 1);
            } else if ((n6 & 8) != 0) {
                n11 = n3 - n5;
            }
            graphics.setClip(n11, n8, n5, n10);
            this.drawString(graphics, this.m_scrollerStringId[n], mixedFont, n3 - this.m_scrollerOffset[n], n4, n6);
            this.drawString(graphics, this.m_scrollerStringId[n], mixedFont, n3 - this.m_scrollerOffset[n] + this.m_scrollerStringWidth[n] + 20, n4, n6);
            graphics.setClip(n7, n8, n9, n10);
        }
    }

    public void renderScroller(int n, Graphics graphics, byte[][] byArray, MixedFont mixedFont, int n2, int n3, int n4, int n5) {
        if (n >= this.m_scrollerStringId.length) {
            return;
        }
        if (this.m_scrollerStringArray[n] != byArray) {
            this.setupScroller(n, mixedFont, byArray);
        }
        if (this.m_scrollerStringWidth[n] <= n4) {
            this.drawChars(graphics, byArray, mixedFont, n2, n3, n5);
        } else {
            int n6 = graphics.getClipX();
            int n7 = graphics.getClipY();
            int n8 = graphics.getClipWidth();
            int n9 = graphics.getClipHeight();
            int n10 = n2;
            if ((n5 & 1) != 0) {
                n10 = n2 - (n4 >> 1);
            } else if ((n5 & 8) != 0) {
                n10 = n2 - n4;
            }
            graphics.setClip(n10, n7, n4, n9);
            this.drawChars(graphics, this.m_scrollerStringArray[n], mixedFont, n2 - this.m_scrollerOffset[n], n3, n5);
            this.drawChars(graphics, this.m_scrollerStringArray[n], mixedFont, n2 - this.m_scrollerOffset[n] + this.m_scrollerStringWidth[n] + 20, n3, n5);
            graphics.setClip(n6, n7, n8, n9);
        }
    }

    public int getScrollerWidth(int n) {
        return this.m_scrollerStringWidth[n];
    }

    public void renderClippedString(Graphics graphics, int n, MixedFont mixedFont, int n2, int n3, int n4) {
        int n5 = graphics.getClipX();
        int n6 = graphics.getClipY();
        int n7 = graphics.getClipWidth();
        int n8 = graphics.getClipHeight();
        graphics.setClip(n2, n6, n4 - 6, n8);
        this.drawString(graphics, n, mixedFont, n2, n3, 20);
        graphics.setClip(n5, n6, n7, n8);
        this.drawString(graphics, 28, mixedFont, n2 + n4, n3, 24);
    }

    public void changeScene(int n) {
        this.changeScene(n, (byte)-1);
    }

    public void changeScene(int n, byte by) {
        if (this.m_currentScene != null) {
            this.m_currentScene.end();
        }
        this.m_lastPercentage = -1;
        this.m_currentScene = null;
        AppEngine.tryDefragMemory(1000);
        switch (n) {
            case 0: {
                this.inMenu = true;
                this.m_currentScene = new SceneMenu();
                this.m_currentScene.loadScene();
                break;
            }
            case 1: {
                this.m_currentScene = new SceneGame();
                this.m_currentScene.loadScene();
                break;
            }
        }
        this.m_currentScene.m_initialState = by;
        this.clearKeysPressedDown();
        this.clearCommandKeys();
        this.repaint();
    }

    public void restartCurrentRace() {
        if (this.m_currentScene instanceof SceneGame) {
            this.changeScene(1);
        }
    }

    public void requestGC(boolean bl) {
        if (bl) {
            System.gc();
            this.m_runGarbageCollect = false;
        } else {
            this.m_runGarbageCollect = true;
        }
    }

    public static void debug(String string) {
    }

    public void loadCommonSoftkeyResources() {
    }

    public void loadCommonMenuResources() {
        this.loadImages(0x4000000000000000L);
    }

    public void loadCommonSoundResources() {
    }

    public void renderSoftKeysInGame(Graphics graphics) {
        AnimationManager animationManager = this.m_animationManager;
        int n = this.getCommandString(this.getCancelCommandID());
        int n2 = this.getCommandString(this.getSelectCommandID());
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        int n5 = n4 - 1;
        int n6 = animationManager.getAnimFrameWidth(341, 0);
        int n7 = animationManager.getAnimFrameWidth(342, 0);
        MixedFont mixedFont = this.getFont(1);
        int n8 = n != -1 ? this.getStringWidth(n, mixedFont) : 0;
        int n9 = n2 != -1 ? this.getStringWidth(n2, mixedFont) : 0;
        int n10 = Math.max(Math.max(n8, n9), 35);
        int n11 = n10 + 4;
        int n12 = n11 >> 1;
        int n13 = n3 - n12 - 1;
        int n14 = n3 - n6;
        if (n != -1) {
            animationManager.drawAnimFrame(graphics, 341, 0, 0, n4);
            animationManager.drawAnimFrame(graphics, 342, 0, n6, n4);
            animationManager.drawAnimFrame(graphics, 342, 0, n11 - n6 - n7, n4);
            animationManager.drawAnimFrame(graphics, 343, 0, n11 - n6, n4);
            this.drawString(graphics, n, mixedFont, n12, n5, 33);
        }
        if (n2 != -1) {
            animationManager.drawAnimFrame(graphics, 341, 0, n3 - n11, n4);
            animationManager.drawAnimFrame(graphics, 342, 0, n3 - n11 + n6, n4);
            animationManager.drawAnimFrame(graphics, 342, 0, n14 - n7, n4);
            animationManager.drawAnimFrame(graphics, 343, 0, n14, n4);
            this.drawString(graphics, n2, mixedFont, n13, n5, 33);
        }
    }

    public void renderSoftKeys(Graphics graphics) {
        this.renderSoftKeyButtons(graphics);
    }

    public void renderSoftKeyButtons(Graphics graphics) {
        int n = this.getCommandString(this.getCancelCommandID());
        int n2 = this.getCommandString(this.getSelectCommandID());
        int n3 = 3;
        int n4 = this.getHeight() - 3;
        int n5 = 13;
        int n6 = this.getHeight() - n5;
        MixedFont mixedFont = this.getFont(1);
        int n7 = n != -1 ? this.getStringWidth(n, mixedFont) : 0;
        int n8 = n2 != -1 ? this.getStringWidth(n2, mixedFont) : 0;
        int n9 = Math.max(Math.max(n7, n8), 37);
        int n10 = n9 + (n3 << 1);
        this.m_animationManager.setColor(graphics, 0);
        if (n != -1) {
            graphics.fillRect(0, n6, n10, n5);
            this.drawString(graphics, n, mixedFont, n3, n4, 36);
        }
        if (n2 != -1) {
            graphics.fillRect(this.getWidth() - n10, n6, n10, n5);
            this.drawString(graphics, n2, mixedFont, this.getWidth() - n3, n4, 40);
        }
    }

    public void renderBackgroundDim(Graphics graphics) {
    }

    public void renderLoading(Graphics graphics, int n) {
        int n2 = this.getHeight() - 7 >> 1;
        int n3 = 100 * n * 41 >> 12;
        graphics.setColor(0);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.drawString(graphics, 48, this.getFont(1), 86, n2 - 8, 33);
        graphics.setColor(0xFFFFFF);
        graphics.drawRect(34, n2 - 2, 103, 6);
        graphics.fillRect(36, n2, n3, 3);
    }

    public void renderLoadingBar(Graphics graphics, int n) {
        this.renderLoadingBar(graphics, n, this.getHeight() - 19);
    }

    public void renderLoadingBar(Graphics graphics, int n, int n2) {
        int n3 = this.getWidth();
        int n4 = n3 * n * 41 >> 12;
        int n5 = n2 - 8;
        this.getAnimationManager().setColor(graphics, 0);
        graphics.fillRect(0, n5, n3, 16);
        this.drawString(graphics, 48, this.getFont(3), n3 >> 1, n2, 3);
        this.getAnimationManager().setColor(graphics, 30);
        graphics.fillRect(0, n5 - 2, n4, 2);
        graphics.fillRect(0, n5 + 16, n4, 2);
        this.getAnimationManager().setColor(graphics, 14);
        graphics.fillRect(n4, n5 - 2, n3 - n4, 2);
        graphics.fillRect(n4, n5 + 16, n3 - n4, 2);
    }

    public static int popupSize(int n, int n2, int n3, long l, long l2) {
        int n4;
        if (l >= l2) {
            return n3;
        }
        if (l < 0L) {
            return n2;
        }
        switch (n) {
            default: {
                return (int)((long)n2 + l * (long)(n3 - n2) / l2);
            }
            case 2: {
                n4 = MathExt.smoothstepF(0, (int)l2, (int)l);
                break;
            }
            case 1: {
                int n5 = (int)(l2 >> 1);
                if (l < (long)n5) {
                    int n6 = MathExt.Fdiv(MathExt.Fmul((int)l, 102944), n5);
                    n4 = MathExt.Fmul(MathExt.Fsin(n6), 72089);
                    break;
                }
                int n7 = MathExt.Fdiv((int)l - n5, (int)l2 - n5);
                int n8 = MathExt.Fmul(n7, 617662);
                int n9 = 6554 - MathExt.Fmul(6554, n7);
                n4 = MathExt.Fmul(MathExt.Fcos(n8), n9) + 65536;
                break;
            }
        }
        return n2 + (n4 * (n3 - n2) >> 16);
    }

    private int getAverageInterval(int n) {
        this.m_frameIntervals[this.m_frameIntervalIndex] = n;
        if (++this.m_frameIntervalIndex > 7) {
            this.m_frameIntervalIndex = 0;
        }
        int n2 = this.m_frameIntervals[0] + this.m_frameIntervals[1] + this.m_frameIntervals[2] + this.m_frameIntervals[3] + this.m_frameIntervals[4] + this.m_frameIntervals[5] + this.m_frameIntervals[6] + this.m_frameIntervals[7];
        return n2 >>= 3;
    }

    public void renderMenu(Graphics graphics, int n, int n2, short[] sArray) {
        this.renderMenu(graphics, n, n2, sArray, (byte)-1);
    }

    public void renderMenu(Graphics graphics, int n, int n2, short[] sArray, byte by) {
        this.renderMenu(graphics, n, n2, sArray, by, MENU_WIDTH, MENU_LEADING, MENU_BORDER_WIDTH, MENU_BORDER_HEIGHT, MENU_PADDING_WIDTH, MENU_PADDING_HEIGHT, MENU_SELECT_BORDER_RIGHT, false);
    }

    public void renderMenu(Graphics graphics, int n, int n2, short[] sArray, byte by, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl) {
        int n10 = n3 - (n5 << 1);
        int n11 = n10 - (n7 << 1);
        int n12 = n10 - 1;
        int n13 = n7;
        if (bl) {
            n12 += n5;
        }
        MixedFont mixedFont = this.getFont(1);
        int n14 = (n4 + 1 << 1 >> 1) - 2;
        int n15 = (n14 >> 1) - (mixedFont.getLineHeight() >> 1) + 1;
        int n16 = sArray.length * n4 + n8;
        this.m_animationManager.setColor(graphics, 13);
        graphics.fillRect(n += this.getHalfWidth() - (n3 >> 1), n2, n3, n6);
        graphics.fillRect(n, (n2 += n6) + n16, n3, n6);
        graphics.fillRect(n, n2, n5, n16);
        graphics.fillRect((n += n5) + n10, n2, n5, n16);
        this.m_animationManager.setColor(graphics, 14);
        graphics.fillRect(n, n2, n10, n16);
        n += n7;
        n2 += n8;
        int n17 = n12 - n9 - 6;
        int n18 = n12 - 10;
        for (int i = 0; i < sArray.length; ++i) {
            if (i == by) {
                this.m_animationManager.setColor(graphics, 15);
                graphics.drawRect(n - n13, n2 - n15, n12, n14);
                graphics.fillRect(n + n12 - n9 - n13, n2 - n15, n9, n14);
                this.renderScroller(0, graphics, sArray[i], mixedFont, n, n2, n17, 4 | 0x10);
            } else {
                int n19 = graphics.getClipX();
                int n20 = graphics.getClipY();
                int n21 = graphics.getClipWidth();
                int n22 = graphics.getClipHeight();
                graphics.setClip(n, n20, n18, n22);
                this.drawString(graphics, sArray[i], mixedFont, n, n2, 4 | 0x10);
                graphics.setClip(n19, n20, n21, n22);
            }
            n2 += n4;
        }
    }

    public void renderVerticallyScrolledMenu(Graphics graphics, int n, int n2, short[] sArray, int n3, int n4) {
        this.renderVerticallyScrolledMenu(graphics, n, n2, sArray, n3, n4, MENU_WIDTH, MENU_LEADING, MENU_BORDER_WIDTH, MENU_BORDER_HEIGHT, MENU_PADDING_WIDTH, MENU_PADDING_HEIGHT, MENU_SELECT_BORDER_RIGHT, false);
    }

    public void renderVerticallyScrolledMenu(Graphics graphics, int n, int n2, short[] sArray, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, boolean bl) {
        int n12 = n5 - (n7 << 1);
        int n13 = n12 - (n9 << 1);
        int n14 = n12 - 1;
        int n15 = n9;
        if (bl) {
            n14 += n7;
        }
        MixedFont mixedFont = this.getFont(1);
        int n16 = (n6 + 1 << 1 >> 1) - 2;
        int n17 = (n16 >> 1) - (mixedFont.getLineHeight() >> 1) + 1;
        n += this.getHalfWidth() - (n5 >> 1);
        int n18 = this.m_previousVerticalScrollOffset;
        if (n18 >= n4) {
            n18 = n4;
        } else if (n4 >= n3 + n18) {
            n18 = n4 - n3 + 1;
        }
        int n19 = sArray.length;
        if (n19 > n3) {
            n19 = n3;
        }
        int n20 = n19 * n6 + n10;
        this.m_animationManager.setColor(graphics, 13);
        graphics.fillRect(n, n2, n5, n8);
        if (n18 > 0) {
            this.m_animationManager.drawAnim(graphics, 299, this.getHalfWidth(), n2);
        }
        graphics.fillRect(n, (n2 += n8) + n20, n5, n8);
        if (n18 + n19 < sArray.length) {
            this.m_animationManager.drawAnim(graphics, 298, this.getHalfWidth(), n2 + n20 + n8);
        }
        graphics.fillRect(n, n2, n7, n20);
        graphics.fillRect((n += n7) + n12, n2, n7, n20);
        this.m_animationManager.setColor(graphics, 14);
        graphics.fillRect(n, n2, n12, n20);
        n += n9;
        n2 += n10;
        int n21 = n14 - n11 - 6;
        int n22 = n14 - 10;
        for (int i = n18; i < sArray.length && i - n18 < n3; ++i) {
            if (i == n4) {
                this.m_animationManager.setColor(graphics, 15);
                graphics.drawRect(n - n15, n2 - n17, n14, n16);
                graphics.fillRect(n + n14 - n11 - n15, n2 - n17, n11, n16);
                this.renderScroller(0, graphics, sArray[i], mixedFont, n, n2, n21, 4 | 0x10);
            } else {
                int n23 = graphics.getClipX();
                int n24 = graphics.getClipY();
                int n25 = graphics.getClipWidth();
                int n26 = graphics.getClipHeight();
                graphics.setClip(n, n24, n22, n26);
                this.drawString(graphics, sArray[i], mixedFont, n, n2, 4 | 0x10);
                graphics.setClip(n23, n24, n25, n26);
            }
            n2 += n6;
        }
        this.m_previousVerticalScrollOffset = n18;
    }

    public void renderPopUpBox(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        MixedFont mixedFont = this.getFont(1);
        int n6 = this.m_numWrappedLines * 10 + 6 + 2 + mixedFont.getLineHeight();
        int n7 = n2 - (n >> 1);
        int n8 = n3 - (n6 >> 1);
        graphics.setColor(n4);
        graphics.fillRect(n7, n8, n, n6);
        graphics.setColor(n5);
        graphics.drawRect(n7 + 1, n8 + 1, n - 1 - 2, n6 - 1 - 2);
        this.drawWrappedString(graphics, mixedFont, 10, n7 + (n >> 1), n8 + (n6 >> 1), 3);
    }

    public int getHelpAboutTextWrapWidth() {
        System.out.println("BORDER_W = 5");
        System.out.println("WIDTH = 212");
        System.out.println("BOX_LEFT = 14");
        System.out.println("BODY_W = 202");
        System.out.println("BODY_W - (TEXT_PADX << 1)190");
        return 190;
    }

    public void renderHelpAbout(Graphics graphics, int n) {
        AnimationManager animationManager = this.m_animationManager;
        int n2 = this.getWidth() - 212 >> 1;
        int n3 = n2 + 5;
        int n4 = n3 + 2;
        int n5 = n3 + 202 - 26;
        int n6 = n5 - 26;
        int n7 = n3 + 6;
        animationManager.setColor(graphics, 0);
        graphics.fillRect(n2, 60, 212, 16);
        graphics.fillRect(n2, 76, 5, 176);
        graphics.fillRect(n3 + 202, 76, 5, 176);
        graphics.fillRect(n2, 252, 212, 8);
        animationManager.setColor(graphics, 14);
        graphics.fillRect(n3, 76, 202, 176);
        this.drawString(graphics, n, this.getFont(3), n4, 68, 6);
        this.drawChars(graphics, this.m_helpAboutPageBytes, this.getFont(3), n5, 243, 3);
        this.drawString(graphics, 109, this.getFont(3), n6, 243, 10);
        if (this.m_helpAboutCurPage > 0) {
            animationManager.drawAnimFrame(graphics, 362, 0, n5 - 16, 243);
        }
        if (this.m_helpAboutCurPage < this.m_helpAboutNumPages - 1) {
            animationManager.drawAnimFrame(graphics, 361, 0, n5 + 16, 243);
        }
        this.drawPartWrappedString(graphics, this.getFont(1), 10, n7, 82, 20, this.m_helpAboutCurPage * this.m_helpAboutNumLinesPerPage, this.m_helpAboutNumLinesPerPage);
    }

    public void initHelpScreen() {
        this.wrapText(42, this.getFont(1), this.getHelpAboutTextWrapWidth());
        this.m_helpAboutCurPage = 0;
        this.m_helpAboutNumPages = this.m_numWrappedLines / this.m_helpAboutNumLinesPerPage;
        if (this.m_numWrappedLines % this.m_helpAboutNumLinesPerPage != 0) {
            ++this.m_helpAboutNumPages;
        }
        this.m_helpAboutPageBytes[0] = AppEngine.intToByteArray(this.m_helpAboutCurPage + 1);
        this.m_helpAboutPageBytes[2] = AppEngine.intToByteArray(this.m_helpAboutNumPages);
    }

    public void initAboutScreen() {
        int n = this.getHelpAboutTextWrapWidth();
        this.wrapText(38, this.getFont(1), n);
        byte[] byArray = AppEngine.stringToByteArray(this.m_midlet.getAppProperty("MIDlet-Version"));
        byte[] byArray2 = this.getString(39).getBytes();
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
        this.wrapMoreText(byArray3, this.getFont(1), n);
        this.wrapMoreText(40, this.getFont(1), n);
        this.m_helpAboutCurPage = 0;
        this.m_helpAboutNumPages = this.m_numWrappedLines / this.m_helpAboutNumLinesPerPage;
        if (this.m_numWrappedLines % this.m_helpAboutNumLinesPerPage != 0) {
            ++this.m_helpAboutNumPages;
        }
        this.m_helpAboutPageBytes[0] = AppEngine.intToByteArray(this.m_helpAboutCurPage + 1);
        this.m_helpAboutPageBytes[2] = AppEngine.intToByteArray(this.m_helpAboutNumPages);
    }

    public void processKeysHelpAbout(int n, int n2) {
        if ((n & 0x8010) != 0 && this.m_helpAboutCurPage > 0) {
            this.clearKeyBit(32784);
            --this.m_helpAboutCurPage;
            this.m_helpAboutPageBytes[0] = AppEngine.intToByteArray(this.m_helpAboutCurPage + 1);
        } else if ((n & 0x10040) != 0 && this.m_helpAboutCurPage < this.m_helpAboutNumPages - 1) {
            this.clearKeyBit(65600);
            ++this.m_helpAboutCurPage;
            this.m_helpAboutPageBytes[0] = AppEngine.intToByteArray(this.m_helpAboutCurPage + 1);
        }
    }

    private void loadTrackInfo() {
        try {
            InputStream inputStream = this.m_resourceManager.loadBinaryFile(310);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            this.m_numTracks = dataInputStream.readByte();
            this.m_trackInfoNameIDs = new short[this.m_numTracks];
            this.m_trackInfoDataIDs = new short[this.m_numTracks];
            this.m_trackInfoThemeIDs = new short[this.m_numTracks];
            for (int i = 0; i < this.m_numTracks; ++i) {
                this.m_trackInfoNameIDs[i] = TrackConstants.TRACK_NAMES[dataInputStream.readByte()];
                this.m_trackInfoDataIDs[i] = TrackConstants.TRACK_DATA[dataInputStream.readByte()];
                this.m_trackInfoThemeIDs[i] = dataInputStream.readByte();
            }
            this.m_nextRaceType = 0;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public byte getNumUnlockedTracks() {
        byte by = 0;
        for (byte by2 = 0; by2 < this.m_numTracks; by2 = (byte)(by2 + 1)) {
            byte by3 = this.findTrackEventHubIndex(by2);
            if (by3 != -1 && this.getEventHubQuickRaceUnlockLevel() < by3) continue;
            by = (byte)(by + 1);
        }
        return by;
    }

    public byte getNthUnlockedTrack(int n) {
        int n2 = 0;
        for (byte by = 0; by < this.m_numTracks; by = (byte)(by + 1)) {
            byte by2 = this.findTrackEventHubIndex(by);
            if (by2 != -1 && this.getEventHubQuickRaceUnlockLevel() < by2) continue;
            int n3 = n2;
            n2 = (byte)(n2 + 1);
            if (n3 != n) continue;
            return by;
        }
        return (byte)n2;
    }

    private byte findTrackEventHubIndex(byte by) {
        for (int i = 0; i < this.m_numEventHubs; ++i) {
            for (int j = 0; j < this.m_eventTrackIDs[i].length; ++j) {
                if (this.m_eventTrackIDs[i][j] != by) continue;
                return (byte)i;
            }
        }
        return -1;
    }

    public static void tryDefragMemory(int n) {
        if (n <= 0) {
            n = 20;
        }
        System.gc();
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Thread.yield();
    }

    public void loadCarData() {
        try {
            InputStream inputStream = this.m_resourceManager.loadBinaryFile(1);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n = dataInputStream.readByte();
            dataInputStream.close();
            dataInputStream = null;
            inputStream = null;
            System.gc();
            this.m_carDescriptions = new short[n];
            this.m_carPrices = new int[n];
            this.m_carUnlockLevels = new byte[n];
            this.m_carParamTyres = new int[n];
            this.m_carParamSteeringInc = new int[n];
            this.m_carParamSteeringRecentreInc = new int[n];
            this.m_carParamSteeringMax = new int[n];
            this.m_carNumGears = new byte[n];
            this.m_carGearAccels = new int[n][];
            this.m_carGearMinSpeeds = new int[n][];
            this.m_carGearMaxSpeeds = new int[n][];
            inputStream = this.m_resourceManager.loadBinaryFile(1);
            dataInputStream = new DataInputStream(inputStream);
            n = dataInputStream.readByte();
            for (int i = 0; i < n; ++i) {
                this.m_carDescriptions[i] = CarConstants.CAR_NAMES[dataInputStream.readByte()];
                dataInputStream.readByte();
                dataInputStream.readByte();
                this.m_carPrices[i] = dataInputStream.readInt();
                this.m_carUnlockLevels[i] = dataInputStream.readByte();
                this.m_carParamTyres[i] = dataInputStream.readInt();
                this.m_carParamSteeringInc[i] = dataInputStream.readInt();
                this.m_carParamSteeringRecentreInc[i] = dataInputStream.readInt();
                this.m_carParamSteeringMax[i] = dataInputStream.readInt();
                this.m_carNumGears[i] = dataInputStream.readByte();
                this.m_carGearAccels[i] = new int[this.m_carNumGears[i]];
                this.m_carGearMinSpeeds[i] = new int[this.m_carNumGears[i]];
                this.m_carGearMaxSpeeds[i] = new int[this.m_carNumGears[i]];
                for (int j = 0; j < this.m_carNumGears[i]; ++j) {
                    this.m_carGearAccels[i][j] = dataInputStream.readInt();
                    this.m_carGearMinSpeeds[i][j] = dataInputStream.readInt();
                    this.m_carGearMaxSpeeds[i][j] = dataInputStream.readInt();
                    this.m_carGearMinSpeeds[i][j] = j == 0 ? 0 : MathExt.Fmul(this.m_carGearMaxSpeeds[i][j - 1], 54613);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void calculateCarValues() {
        int n = this.getNumCars();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        CAR_VALUE_SPEED_MIN_F = Integer.MAX_VALUE;
        CAR_VALUE_ACCEL_MIN_F = Integer.MAX_VALUE;
        CAR_VALUE_HANDLING_MIN_F = Integer.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            n2 = Math.max(n2, this.m_carGearMaxSpeeds[i][this.m_carNumGears[i] - 1]);
            CAR_VALUE_SPEED_MIN_F = Math.min(CAR_VALUE_SPEED_MIN_F, this.m_carGearMaxSpeeds[i][this.m_carNumGears[i] - 1]);
            n3 = Math.max(n3, this.m_carGearAccels[i][0]);
            CAR_VALUE_ACCEL_MIN_F = Math.min(CAR_VALUE_ACCEL_MIN_F, this.m_carGearAccels[i][0]);
            n4 = Math.max(n4, this.m_carParamTyres[i]);
            CAR_VALUE_HANDLING_MIN_F = Math.min(CAR_VALUE_HANDLING_MIN_F, this.m_carParamTyres[i]);
        }
        n2 = MathExt.Fmul(n2, this.m_careerTunerAccessoryBoostsF[0][3]);
        n3 = MathExt.Fmul(n3, this.m_careerTunerAccessoryBoostsF[1][3]);
        n4 = MathExt.Fmul(n4, this.m_careerTunerAccessoryBoostsF[2][3]);
        CAR_VALUE_SPEED_MIN_F = MathExt.Fmul(CAR_VALUE_SPEED_MIN_F, 58982);
        CAR_VALUE_ACCEL_MIN_F = MathExt.Fmul(CAR_VALUE_ACCEL_MIN_F, 58982);
        CAR_VALUE_HANDLING_MIN_F = MathExt.Fmul(CAR_VALUE_HANDLING_MIN_F, 58982);
        CAR_VALUE_SPEED_MULTIPLIER_F = MathExt.Fdiv(65536, n2 - CAR_VALUE_SPEED_MIN_F);
        CAR_VALUE_ACCEL_MULTIPLIER_F = MathExt.Fdiv(65536, n3 - CAR_VALUE_ACCEL_MIN_F);
        CAR_VALUE_HANDLING_MULTIPLIER_F = MathExt.Fdiv(65536, n4 - CAR_VALUE_HANDLING_MIN_F);
        CAR_VALUE_NITRO_MIN_F = Short.MIN_VALUE;
        CAR_VALUE_NITRO_MULTIPLIER_F = MathExt.Fdiv(65536, 262144 - CAR_VALUE_NITRO_MIN_F);
    }

    public void loadTunershopData() {
        try {
            InputStream inputStream = this.m_resourceManager.loadBinaryFile(10);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n = dataInputStream.readByte();
            dataInputStream.close();
            dataInputStream = null;
            inputStream = null;
            System.gc();
            short[] sArray = new short[n];
            short[] sArray2 = new short[n];
            short[] sArray3 = new short[n];
            short[][] sArrayArray = new short[n][];
            int[][] nArrayArray = new int[n][];
            int[][] nArrayArray2 = new int[n][];
            inputStream = this.m_resourceManager.loadBinaryFile(10);
            dataInputStream = new DataInputStream(inputStream);
            n = dataInputStream.readByte();
            for (int i = 0; i < n; ++i) {
                sArray[i] = TunerShopConstants.TUNERSHOP_STRINGS[dataInputStream.readByte()];
                sArray2[i] = TunerShopConstants.TUNERSHOP_STRINGS[dataInputStream.readByte()];
                sArray3[i] = TunerShopConstants.TUNERSHOP_ANIMS[dataInputStream.readByte()];
                int n2 = dataInputStream.readByte();
                sArrayArray[i] = new short[n2];
                nArrayArray[i] = new int[n2];
                nArrayArray2[i] = new int[n2];
                for (int j = 0; j < n2; ++j) {
                    sArrayArray[i][j] = TunerShopConstants.TUNERSHOP_STRINGS[dataInputStream.readByte()];
                    nArrayArray[i][j] = dataInputStream.readInt();
                    nArrayArray2[i][j] = dataInputStream.readInt();
                }
            }
            this.m_careerTunerMenuStringIDs = sArray;
            this.m_careerTunerMenuCompanyNameStringIDs = sArray2;
            this.m_careerTunerAnimIDs = sArray3;
            this.m_careerTunerSubMenuStringIDs = sArrayArray;
            this.m_careerTunerAccessoryPrices = nArrayArray;
            this.m_careerTunerAccessoryBoostsF = nArrayArray2;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void loadImages(long l) {
        ResourceManager resourceManager = this.getResourceManager();
        AnimationManager animationManager = this.getAnimationManager();
        int n = 0;
        while (IMAGE_IDS[n << 1] != -1L) {
            if ((IMAGE_IDS[(n << 1) + 1] & l) != 0L) {
                while (!animationManager.loadImage(resourceManager, (int)IMAGE_IDS[n << 1])) {
                    AppEngine.tryDefragMemory(25);
                }
            }
            ++n;
        }
        AppEngine.tryDefragMemory(25);
    }

    void unloadImages(long l) {
        ResourceManager resourceManager = this.getResourceManager();
        AnimationManager animationManager = this.getAnimationManager();
        int n = 0;
        while (IMAGE_IDS[n << 1] != -1L) {
            if ((IMAGE_IDS[(n << 1) + 1] & l) != 0L) {
                animationManager.unloadImage(resourceManager, (int)IMAGE_IDS[n << 1]);
            }
            ++n;
        }
        AppEngine.tryDefragMemory(25);
    }

    public int getNumCars() {
        return this.m_carDescriptions.length;
    }

    public int getNumUnlockedCars() {
        int n = 0;
        for (int i = 0; i < this.getNumCars(); ++i) {
            if (this.m_carUnlockLevels[i] > this.m_rmsCarUnlockLevel) continue;
            ++n;
        }
        return n;
    }

    public short getCarDescriptionStringID() {
        return this.getCarDescriptionStringID(this.m_playerCarIndex);
    }

    public short getCarDescriptionStringID(int n) {
        return this.m_carDescriptions[n];
    }

    public int getCarPrice(int n) {
        return this.m_carPrices[n];
    }

    public int getCarPrice() {
        return this.getCarPrice(this.m_playerCarIndex);
    }

    public int getCarSellPrice(int n) {
        int n2 = this.m_carPrices[n];
        for (int i = 0; i < 4; ++i) {
            byte by = this.m_rmsAccessoryLevel[n][i];
            if (by <= 0) continue;
            n2 += this.m_careerTunerAccessoryPrices[i][by - 1];
        }
        return n2 * 50 / 100;
    }

    public byte getCarUnlockLevel(int n) {
        return this.m_carUnlockLevels[n];
    }

    public byte getCarUnlockLevel() {
        return this.getCarUnlockLevel(this.m_playerCarIndex);
    }

    public int getCarParamTyres() {
        return this.getCarParamTyres(this.m_playerCarIndex);
    }

    public int getCarParamTyres(int n) {
        return this.m_carParamTyres[n];
    }

    public int getCarParamSteeringInc() {
        return this.getCarParamSteeringInc(this.m_playerCarIndex);
    }

    public int getCarParamSteeringInc(int n) {
        return this.m_carParamSteeringInc[n];
    }

    public int getCarParamSteeringRecentreInc() {
        return this.getCarParamSteeringRecentreInc(this.m_playerCarIndex);
    }

    public int getCarParamSteeringRecentreInc(int n) {
        return this.m_carParamSteeringRecentreInc[n];
    }

    public int getCarParamSteeringMax() {
        return this.getCarParamSteeringMax(this.m_playerCarIndex);
    }

    public int getCarParamSteeringMax(int n) {
        return this.m_carParamSteeringMax[n];
    }

    public byte getCarNumGears() {
        return this.getCarNumGears(this.m_playerCarIndex);
    }

    public byte getCarNumGears(int n) {
        return this.m_carNumGears[n];
    }

    public int getCarGearAccel(byte by) {
        return this.getCarGearAccel(this.m_playerCarIndex, by);
    }

    public int getCarGearAccel(int n, byte by) {
        return this.m_carGearAccels[n][by];
    }

    public int[] getCarGearAccelData() {
        return this.getCarGearAccelData(this.m_playerCarIndex);
    }

    public int[] getCarGearAccelData(int n) {
        int[] nArray = new int[this.m_carGearAccels[n].length];
        System.arraycopy(this.m_carGearAccels[n], 0, nArray, 0, nArray.length);
        return nArray;
    }

    public int[] getCarGearMinSpeedData() {
        return this.getCarGearMinSpeedData(this.m_playerCarIndex);
    }

    public int[] getCarGearMinSpeedData(int n) {
        int[] nArray = new int[this.m_carGearMinSpeeds[n].length];
        System.arraycopy(this.m_carGearMinSpeeds[n], 0, nArray, 0, nArray.length);
        return nArray;
    }

    public int[] getCarGearMaxSpeedData() {
        return this.getCarGearMaxSpeedData(this.m_playerCarIndex);
    }

    public int[] getCarGearMaxSpeedData(int n) {
        int[] nArray = new int[this.m_carGearMaxSpeeds[n].length];
        System.arraycopy(this.m_carGearMaxSpeeds[n], 0, nArray, 0, nArray.length);
        return nArray;
    }

    public int getCarGearMinSpeed(byte by) {
        return this.getCarGearMinSpeed(this.m_playerCarIndex, by);
    }

    public int getCarGearMinSpeed(int n, byte by) {
        return this.m_carGearMinSpeeds[n][by];
    }

    public int getCarGearMaxSpeed(byte by) {
        return this.getCarGearMaxSpeed(this.m_playerCarIndex, by);
    }

    public int getCarGearMaxSpeed(int n, byte by) {
        return this.m_carGearMaxSpeeds[n][by];
    }

    public void setPlayerCarIndex(byte by) {
        this.m_playerCarIndex = by;
    }

    public byte getPlayerCarIndex() {
        return this.m_playerCarIndex;
    }

    private void loadEventHubData() {
        try {
            InputStream inputStream = this.m_resourceManager.loadBinaryFile(3);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            this.m_numEventHubs = dataInputStream.readByte();
            dataInputStream.close();
            dataInputStream = null;
            inputStream = null;
            System.gc();
            this.m_eventHubNames = new short[this.m_numEventHubs];
            this.m_eventHubMenuAnimIDs = new short[this.m_numEventHubs];
            this.m_eventHubBackdropAnimIDs = new short[this.m_numEventHubs];
            this.m_eventHubEventCounts = new byte[this.m_numEventHubs];
            this.m_eventTypes = new byte[this.m_numEventHubs][];
            this.m_eventNames = new short[this.m_numEventHubs][];
            this.m_eventTrackIDs = new byte[this.m_numEventHubs][];
            this.m_eventPurses = new short[this.m_numEventHubs][];
            inputStream = this.m_resourceManager.loadBinaryFile(3);
            dataInputStream = new DataInputStream(inputStream);
            dataInputStream.readByte();
            for (int i = 0; i < this.m_numEventHubs; ++i) {
                int n;
                this.m_eventHubNames[i] = EventConstants.EVENTS_STRINGS[dataInputStream.readByte()];
                this.m_eventHubMenuAnimIDs[i] = EventConstants.EVENTS_ANIMS[dataInputStream.readByte()];
                this.m_eventHubBackdropAnimIDs[i] = EventConstants.EVENTS_ANIMS[dataInputStream.readByte()];
                this.m_eventHubEventCounts[i] = n = dataInputStream.readByte();
                this.m_eventTypes[i] = new byte[n];
                this.m_eventNames[i] = new short[n];
                this.m_eventTrackIDs[i] = new byte[n];
                this.m_eventPurses[i] = new short[n];
                for (int j = 0; j < n; ++j) {
                    this.m_eventTypes[i][j] = dataInputStream.readByte();
                    this.m_eventNames[i][j] = EventConstants.EVENTS_STRINGS[dataInputStream.readByte()];
                    this.m_eventTrackIDs[i][j] = (byte)EventConstants.EVENTS_TRACKS[dataInputStream.readByte()];
                    this.m_eventPurses[i][j] = dataInputStream.readShort();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte getNumEventHubs() {
        return this.m_numEventHubs;
    }

    public short getEventHubName(byte by) {
        return this.m_eventHubNames[by];
    }

    public short getEventHubMenuAnimID(byte by) {
        return this.m_eventHubMenuAnimIDs[by];
    }

    public short getEventHubBackdropAnimID(byte by) {
        return this.m_eventHubBackdropAnimIDs[by];
    }

    public byte getEventHubEventCount(byte by) {
        return this.m_eventHubEventCounts[by];
    }

    public byte getEventHubEventType(byte by, byte by2) {
        return this.m_eventTypes[by][by2];
    }

    public short getEventHubEventName(byte by, byte by2) {
        return this.m_eventNames[by][by2];
    }

    public byte getEventHubEventTrackID(byte by, byte by2) {
        return this.m_eventTrackIDs[by][by2];
    }

    public short getEventHubEventPurse(byte by, byte by2) {
        return this.m_eventPurses[by][by2];
    }

    public void setCarNowRacingParameters(boolean bl, byte by, byte by2) {
        this.m_carNowRacingIsCareer = bl;
        this.m_carNowRacingParamTyresF = this.getCarParamTyres();
        this.m_carNowRacingParamSteeringIncF = this.getCarParamSteeringInc();
        this.m_carNowRacingParamSteeringRecentreIncF = this.getCarParamSteeringRecentreInc();
        this.m_carNowRacingParamSteeringMaxF = this.getCarParamSteeringMax();
        this.m_carNowRacingGearAccelsF = this.getCarGearAccelData();
        this.m_carNowRacingGearMinSpeedsF = this.getCarGearMinSpeedData();
        this.m_carNowRacingGearMaxSpeedsF = this.getCarGearMaxSpeedData();
        this.m_carNowRacingNitroRechargeRateF = 65536;
        if (bl) {
            this.m_carNowRacingParamTyresF = MathExt.Fmul(this.m_carNowRacingParamTyresF, this.getCareerAccessoryAdjustment(2));
            if (this.m_carNowRacingParamTyresF > 65536) {
                this.m_carNowRacingParamTyresF = 65536;
            }
            int n = this.getCareerAccessoryAdjustment(1);
            int n2 = this.getCareerAccessoryAdjustment(0);
            int n3 = this.getCarNumGears();
            for (int i = 0; i < n3; ++i) {
                this.m_carNowRacingGearAccelsF[i] = MathExt.Fmul(this.m_carNowRacingGearAccelsF[i], n);
                this.m_carNowRacingGearMaxSpeedsF[i] = MathExt.Fmul(this.m_carNowRacingGearMaxSpeedsF[i], n2);
            }
            this.m_carNowRacingNitroRechargeRateF = MathExt.Fmul(this.m_carNowRacingNitroRechargeRateF, this.getCareerAccessoryAdjustment(3));
            this.m_carNowRacingHubIndex = by;
            this.m_carNowRacingEventIndex = by2;
        }
    }

    public int getCarNowRacingParamTyres() {
        return this.m_carNowRacingParamTyresF;
    }

    public int getCarNowRacingParamSteeringInc() {
        return this.m_carNowRacingParamSteeringIncF;
    }

    public int getCarNowRacingParamSteeringRecentreInc() {
        return this.m_carNowRacingParamSteeringRecentreIncF;
    }

    public int getCarNowRacingParamSteeringMax() {
        return this.m_carNowRacingParamSteeringMaxF;
    }

    public int[] getCarNowRacingGearAccelData() {
        return this.m_carNowRacingGearAccelsF;
    }

    public int[] getCarNowRacingGearMinSpeedData() {
        return this.m_carNowRacingGearMinSpeedsF;
    }

    public int[] getCarNowRacingGearMaxSpeedData() {
        return this.m_carNowRacingGearMaxSpeedsF;
    }

    public int getCarNowRacingNitroRechargeRate() {
        return this.m_carNowRacingNitroRechargeRateF;
    }

    public int getCareerAccessoryAdjustment(int n) {
        byte by = this.m_rmsAccessoryLevel[this.m_playerCarIndex][n];
        if (by > 0) {
            return this.m_careerTunerAccessoryBoostsF[n][by - 1];
        }
        return 65536;
    }

    public int getCarValueSpeedF(int n, int n2) {
        int n3 = this.getCarGearMaxSpeed(n, (byte)(this.getCarNumGears() - 1));
        if (n2 > 0) {
            n3 = MathExt.Fmul(n3, this.m_careerTunerAccessoryBoostsF[0][n2 - 1]);
        }
        n3 -= CAR_VALUE_SPEED_MIN_F;
        n3 = MathExt.Fmul(n3, CAR_VALUE_SPEED_MULTIPLIER_F);
        return n3;
    }

    public int getCarValueAccelF(int n, int n2) {
        int n3 = this.getCarGearAccel(n, (byte)0);
        if (n2 > 0) {
            n3 = MathExt.Fmul(n3, this.m_careerTunerAccessoryBoostsF[1][n2 - 1]);
        }
        n3 -= CAR_VALUE_ACCEL_MIN_F;
        n3 = MathExt.Fmul(n3, CAR_VALUE_ACCEL_MULTIPLIER_F);
        return n3;
    }

    public int getCarValueHandlingF(int n, int n2) {
        int n3 = this.getCarParamTyres(n);
        if (n2 > 0) {
            n3 = MathExt.Fmul(n3, this.m_careerTunerAccessoryBoostsF[2][n2 - 1]);
        }
        n3 -= CAR_VALUE_HANDLING_MIN_F;
        n3 = MathExt.Fmul(n3, CAR_VALUE_HANDLING_MULTIPLIER_F);
        return n3;
    }

    public int getCarValueNitroF(int n, int n2) {
        int n3 = 0;
        if (n2 > 0) {
            n3 += n2 << 16;
        }
        n3 += -CAR_VALUE_NITRO_MIN_F;
        n3 = MathExt.Fmul(n3, CAR_VALUE_NITRO_MULTIPLIER_F);
        return n3;
    }

    public int getCarValueF(int n, int n2, int n3) {
        switch (n2) {
            case 0: {
                return this.getCarValueSpeedF(n, n3);
            }
            case 1: {
                return this.getCarValueAccelF(n, n3);
            }
            case 2: {
                return this.getCarValueHandlingF(n, n3);
            }
        }
        return this.getCarValueNitroF(n, n3);
    }

    public void overrideKeyStates() {
        int n = this.getKeyStates();
        m_keysPressedDown = (n & 4) == 0 ? (m_keysPressedDown &= 0xFFFF7FFF) : (m_keysPressedDown |= 0x8000);
        m_keysPressedDown = (n & 0x20) == 0 ? (m_keysPressedDown &= 0xFFFEFFFF) : (m_keysPressedDown |= 0x10000);
    }

    public void eventOccurred(long l, int n, int n2, Object object, Object object2) {
        if (l == 5961289116197897667L) {
            if (n == 1) {
                DEBUG_I = DEBUG_I + " H";
                this.hideNotify();
                this.m_soundManager.stopAllSounds();
            } else if (n == 2) {
                DEBUG_I = DEBUG_I + " S";
                this.showNotify();
            }
        }
    }

    static {
        MENU_WIDTH = 130;
        MENU_LEADING = 14;
        MENU_BORDER_HEIGHT = 3;
        MENU_BORDER_WIDTH = 3;
        MENU_PADDING_WIDTH = 4;
        MENU_PADDING_HEIGHT = 4;
        MENU_INNER_WIDTH = MENU_WIDTH - MENU_BORDER_WIDTH * 2;
        MENU_SELECT_WIDTH = MENU_INNER_WIDTH - 1;
        MENU_SELECT_BORDER_RIGHT = 10;
        m_keysPressedDown = 0;
        m_commandPressedDown = 0;
        m_singletonAppEngine = null;
        DEBUG_I = "...";
        myDebug = "";
    }
}

