/*
 * Decompiled with CFR 0.152.
 */
package generic;

public final class MathExt {
    private static final int M_PI_Q16 = 205887;
    private static final int M_2PI_Q16 = 411775;
    private static final int M_PI_Q16_INV = 20861;
    private static final int M_PI_Q16_180 = 1144;
    private static final int M_PI_Q16_180_INV = 3754936;
    public static final int M_2PI = 411775;
    public static final int M_PI = 205887;
    public static final int M_PI_2 = 102944;
    public static final int M_PI_4 = 51472;
    public static final int M_PI_8 = 25736;
    public static final int M_PI_16 = 12868;
    public static final int M_PI_32 = 6434;
    public static final int M_ONE_FIXED = 65536;
    public static final int M_180_FIXED = 0xB40000;
    public static final int M_360_FIXED = 23592960;
    public static final int M_HALF_FIXED = 32768;
    private static final int FSQRT_NUM_PRECALCED = 33;
    private static final int FSQRT_LOWER_SCALE_LIMIT = 16384;
    private static final int FSQRT_UPPER_SCALE_LIMIT = 0x20000000;
    private static final int[] Fsqrt_smallest_precalced = new int[]{0, 16, 362, 443, 512, 572, 627, 677, 724, 768, 810, 849, 887, 923, 958, 991, 1024, 1056, 1086, 1116, 1145, 1173, 1201, 1227, 1254, 1280, 1305, 1330, 1355, 1378, 1402, 1425, 1448};

    public static final int degreesToRadians(int n) {
        return MathExt.Fmul(n, 1144);
    }

    public static final int radiansToDegrees(int n) {
        return MathExt.Fmul(n, 3754936);
    }

    public static final int Fmul(int n, int n2) {
        return (int)((long)n * (long)n2 >> 16);
    }

    public static final int FmulLSL1(int n, int n2) {
        return (int)((long)n * (long)n2 >> 15);
    }

    public static final int Fdot2(int[] nArray, int[] nArray2) {
        return (int)((long)nArray[0] * (long)nArray2[0] + (long)nArray[1] * (long)nArray2[1] >> 16);
    }

    public static final int Fdot3(int[] nArray, int[] nArray2) {
        return (int)((long)nArray[0] * (long)nArray2[0] + (long)nArray[1] * (long)nArray2[1] + (long)nArray[2] * (long)nArray2[2] >> 16);
    }

    public static final int Fdot4(int[] nArray, int[] nArray2) {
        return (int)((long)nArray[0] * (long)nArray2[0] + (long)nArray[1] * (long)nArray2[1] + (long)nArray[2] * (long)nArray2[2] + (long)nArray[3] * (long)nArray2[3] >> 16);
    }

    public static final int Fdot4(int[] nArray, int n, int[] nArray2) {
        return (int)((long)nArray[0 + n] * (long)nArray2[0] + (long)nArray[1 + n] * (long)nArray2[1] + (long)nArray[2 + n] * (long)nArray2[2] + (long)nArray[3 + n] * (long)nArray2[3] >> 16);
    }

    public static final int Fdot4(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        return (int)((long)nArray[0 + n] * (long)nArray2[0 * n3 + n2] + (long)nArray[1 + n] * (long)nArray2[1 * n3 + n2] + (long)nArray[2 + n] * (long)nArray2[2 * n3 + n2] + (long)nArray[3 + n] * (long)nArray2[3 * n3 + n2] >> 16);
    }

    public static final void Fcross3(int[] nArray, int[] nArray2, int[] nArray3) {
        nArray3[0] = MathExt.Fmul(nArray[1], nArray2[2]) - MathExt.Fmul(nArray[2], nArray2[1]);
        nArray3[1] = -MathExt.Fmul(nArray[0], nArray2[2]) + MathExt.Fmul(nArray[2], nArray2[0]);
        nArray3[2] = MathExt.Fmul(nArray[0], nArray2[1]) - MathExt.Fmul(nArray[1], nArray2[0]);
    }

    public static final int Fmag2Sqr(int[] nArray) {
        return MathExt.Fdot2(nArray, nArray);
    }

    public static final int Fmag2(int[] nArray) {
        return MathExt.Fsqrt(MathExt.Fdot2(nArray, nArray));
    }

    public static final int Fmag2Sqr(int n, int n2) {
        return (int)((long)n * (long)n + (long)n2 * (long)n2 >> 16);
    }

    public static final int Fmag2(int n, int n2) {
        return MathExt.Fsqrt((int)((long)n * (long)n + (long)n2 * (long)n2 >> 16));
    }

    public static final int Fmag3Sqr(int[] nArray) {
        return MathExt.Fdot3(nArray, nArray);
    }

    public static final int Fmag4Sqr(int[] nArray) {
        return MathExt.Fdot4(nArray, nArray);
    }

    public static final int Fdiv(int n, int n2) {
        return (int)(((long)n << 16) / (long)n2);
    }

    public static final int Fcos(int n) {
        int n2 = n >= 0 ? 1 : -1;
        int n3 = MathExt.Fmul(n2 * n << 1, 20861) & 0x3FFFF;
        int n4 = n3 >> 16;
        n3 &= 0xFFFF;
        n2 = 1;
        if (((n4 &= 3) & 1) != 0) {
            n2 = -n2;
            n3 = 65536 - n3;
        }
        if ((n4 & 2) != 0) {
            n2 = -n2;
        }
        n3 = MathExt.Fmul(n3 >> 1, 205887);
        int n5 = 65536;
        int n6 = MathExt.Fmul(n3, n3);
        int n7 = n6 >> 1;
        n5 -= n7;
        n7 = MathExt.Fmul(MathExt.Fmul(n6, n7), 5461);
        n5 += n7;
        n7 = MathExt.Fmul(MathExt.Fmul(n6, n7), 2185);
        n5 -= n7;
        n7 = MathExt.Fmul(MathExt.Fmul(n6, n7), 1170);
        n5 += n7;
        n7 = MathExt.Fmul(MathExt.Fmul(n6, n7), 728);
        n5 -= n7;
        return n5 *= n2;
    }

    public static final int Facos(int n) {
        if (n <= -65536) {
            return 205887;
        }
        if (n >= 65536) {
            return 0;
        }
        if (n < -52429) {
            return 205887 - MathExt.Fsqrt(65536 - MathExt.Fmul(n, n));
        }
        if (n > 52429) {
            return MathExt.Fasin(MathExt.Fsqrt(65536 - MathExt.Fmul(n, n)));
        }
        int n2 = 102943;
        int n3 = MathExt.Fmul(n, n);
        int n4 = n;
        n2 -= n4;
        n4 = MathExt.Fmul(n4, n3);
        n2 -= MathExt.Fmul(MathExt.Fdiv(65536, 393216), n4);
        n4 = MathExt.Fmul(n4, n3);
        n2 -= MathExt.Fmul(MathExt.Fdiv(196608, 0x280000), n4);
        n4 = MathExt.Fmul(n4, n3);
        return n2 -= MathExt.Fmul(MathExt.Fdiv(327680, 0x700000), n4);
    }

    public static final int Fsin(int n) {
        return MathExt.Fcos(n - 102944);
    }

    public static final int Fasin(int n) {
        if (n <= -65536) {
            return -102943;
        }
        if (n >= 65536) {
            return 102943;
        }
        if (n > 52429) {
            return MathExt.Facos(MathExt.Fsqrt(65536 - MathExt.Fmul(n, n)));
        }
        if (n < -52429) {
            return -MathExt.Facos(MathExt.Fsqrt(65536 - MathExt.Fmul(n, n)));
        }
        int n2 = 0;
        int n3 = MathExt.Fmul(n, n);
        int n4 = n;
        n2 += n4;
        n4 = MathExt.Fmul(n4, n3);
        n2 += MathExt.Fmul(10923, n4);
        n4 = MathExt.Fmul(n4, n3);
        n2 += MathExt.Fmul(4915, n4);
        n4 = MathExt.Fmul(n4, n3);
        return n2 += MathExt.Fmul(2926, n4);
    }

    public static final int Fatan2(int n, int n2) {
        if (n == 0) {
            if (n2 < 0) {
                return 205887;
            }
            return 0;
        }
        if (n2 == 0) {
            if (n < 0) {
                return -102943;
            }
            return 102943;
        }
        int n3 = MathExt.Fmag2(n, n2);
        int n4 = n3 > 0 ? MathExt.Fdiv(n2 < 0 ? -n2 : n2, n3) : (n2 < 0 ? -n2 : n2);
        int n5 = MathExt.Facos(n4);
        if (n < 0 && n2 < 0) {
            n5 -= 205887;
        } else if (n < 0 && n2 > 0) {
            n5 = -n5;
        } else if (n > 0 && n2 < 0) {
            n5 = 205887 - n5;
        }
        return n5;
    }

    public static final int Fsqrt(int n) {
        int n2;
        if (n < 0) {
            return 0;
        }
        if (n < 33) {
            return Fsqrt_smallest_precalced[n];
        }
        int n3 = n;
        if (n < 16384) {
            n3 <<= 4;
        } else if (n > 0x20000000) {
            n3 >>= 4;
        }
        if (n3 > 65000 && n3 < 66000) {
            n2 = n3 + 65536 >> 1;
        } else {
            int n4 = (n3 >> 3) + MathExt.INT_TO_Q16(2);
            if (n4 > MathExt.INT_TO_Q16(128)) {
                n4 = MathExt.INT_TO_Q16(128);
            }
            int n5 = 16384;
            n2 = n4 + n5 >> 1;
            for (int i = 0; i < 11; ++i) {
                int n6 = MathExt.Fmul(n2, n2);
                if (n6 > n3) {
                    n4 = n2;
                } else {
                    n5 = n2;
                }
                n2 = n4 + n5 >> 1;
            }
        }
        if (n < 16384) {
            n2 >>= 2;
        } else if (n > 0x20000000) {
            n2 <<= 2;
        }
        return n2;
    }

    public static final void getUnitVec3DFixed(int[] nArray, int[] nArray2) {
        int n = MathExt.getVectorMag3DFixed(nArray);
        int n2 = 0;
        if (n > 0) {
            n2 = MathExt.Fdiv(65536, n);
        }
        nArray2[0] = MathExt.Fmul(nArray[0], n2);
        nArray2[1] = MathExt.Fmul(nArray[1], n2);
        nArray2[2] = MathExt.Fmul(nArray[2], n2);
    }

    public static final void getUnitVec3DFixed(int[] nArray, int[] nArray2, int n) {
        int n2 = MathExt.Fdiv(65536, n);
        nArray2[0] = MathExt.Fmul(nArray[0], n2);
        nArray2[1] = MathExt.Fmul(nArray[1], n2);
        nArray2[2] = MathExt.Fmul(nArray[2], n2);
    }

    public static final void getUnitVec2DFixed(int[] nArray, int[] nArray2) {
        int n = MathExt.getVectorMag2DFixed(nArray);
        int n2 = 0;
        if (n > 0) {
            n2 = MathExt.Fdiv(65536, n);
        }
        nArray2[0] = MathExt.Fmul(nArray[0], n2);
        nArray2[1] = MathExt.Fmul(nArray[1], n2);
    }

    public static final void getUnitVec2DFixed(int[] nArray, int[] nArray2, int n) {
        int n2 = MathExt.Fdiv(65536, n);
        nArray2[0] = MathExt.Fmul(nArray[0], n2);
        nArray2[1] = MathExt.Fmul(nArray[1], n2);
    }

    public static final int getVectorMag3DFixed(int[] nArray) {
        return MathExt.Fsqrt(MathExt.Fmag3Sqr(nArray));
    }

    public static final int getVectorMag2DFixed(int[] nArray) {
        return MathExt.Fsqrt(MathExt.Fmul(nArray[0], nArray[0]) + MathExt.Fmul(nArray[1], nArray[1]));
    }

    private static final int INT_TO_Q16(int n) {
        return n << 16;
    }

    public static final int smoothstepF(int n, int n2, int n3) {
        if (n3 < n) {
            return 0;
        }
        if (n3 >= n2) {
            return 65536;
        }
        int n4 = n3 - n;
        int n5 = n2 - n;
        int n6 = MathExt.Fdiv(n4, n5);
        int n7 = MathExt.Fmul(n6, n6);
        return -2 * MathExt.Fmul(n7, n6) + 3 * n7;
    }

    public static int linearstepF(int n, int n2, int n3) {
        if (n3 < n) {
            return 0;
        }
        if (n3 >= n2) {
            return 65536;
        }
        int n4 = n3 - n;
        int n5 = n2 - n;
        return MathExt.Fdiv(n4, n5);
    }

    public static void intToRGB(byte[] byArray, int n) {
        byArray[0] = (byte)((n & 0xFF0000) >> 16);
        byArray[1] = (byte)((n & 0xFF00) >> 8);
        byArray[2] = (byte)(n & 0xFF);
    }

    public static int RGBtoInt(byte[] byArray) {
        return (byArray[0] << 16) + (byArray[1] << 8) + byArray[2];
    }

    public static int degreesToRadiansF(int n) {
        return MathExt.Fmul(1144, n);
    }

    public static int radiansToDegreesF(int n) {
        return MathExt.Fmul(3754936, n);
    }

    public static final int getVectorYawFixed(int n, int n2, int n3) {
        return MathExt.radiansToDegrees(MathExt.Fatan2(n, n3));
    }

    public static final int getVectorPitchFixed(int n, int n2, int n3) {
        return MathExt.radiansToDegrees(MathExt.Fatan2(n2, MathExt.Fsqrt(MathExt.Fmul(n, n) + MathExt.Fmul(n3, n3))));
    }

    public static final int power(int n, int n2) {
        int n3 = 1;
        for (int i = 1; i <= n2; ++i) {
            n3 *= n;
        }
        return n3;
    }

    public static final int powerF(int n, int n2) {
        int n3 = 65536;
        for (int i = 1; i <= n2; ++i) {
            n3 = MathExt.Fmul(n3, n);
        }
        return n3;
    }

    public static void rotate2DVecF(int[] nArray, int[] nArray2, int n) {
        nArray2[0] = MathExt.Fmul(MathExt.Fcos(n), nArray[0]) - MathExt.Fmul(MathExt.Fsin(n), nArray[1]);
        nArray2[1] = MathExt.Fmul(MathExt.Fsin(n), nArray[0]) + MathExt.Fmul(MathExt.Fcos(n), nArray[1]);
    }

    public static String fixedToString(int n) {
        boolean bl = false;
        if (n < 0) {
            n = -n;
            bl = true;
        }
        int n2 = n >> 16;
        int n3 = n & 0xFFFF;
        int n4 = MathExt.Fmul(n3, 655360000);
        String string = new String();
        if (bl) {
            string = string + "-";
        }
        string = string + n2;
        string = string + ".";
        if ((n4 >>= 16) < 10) {
            string = string + "000";
        } else if (n4 < 100) {
            string = string + "00";
        } else if (n4 < 1000) {
            string = string + "0";
        }
        string = string + n4;
        return string;
    }

    public static String fixedToString2DP(int n) {
        boolean bl = false;
        if (n < 0) {
            n = -n;
            bl = true;
        }
        int n2 = n >> 16;
        int n3 = n & 0xFFFF;
        int n4 = MathExt.Fmul(n3, 0x640000);
        String string = new String();
        if (bl) {
            string = string + "-";
        }
        string = string + n2;
        string = string + ".";
        if ((n4 >>= 16) < 10) {
            string = string + "0";
        }
        string = string + n4;
        return string;
    }

    public static void getLineNormal2D(int[] nArray, int[] nArray2) {
        nArray2[0] = -nArray[1];
        nArray2[1] = nArray[0];
    }

    public static int angleBetweenVectors2D(int[] nArray, int[] nArray2) {
        return MathExt.Fatan2(nArray2[1], nArray2[0]) - MathExt.Fatan2(nArray[1], nArray[0]);
    }

    public static int pointLineDistance2D(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[]{nArray2[2] - nArray2[0], nArray2[3] - nArray2[1]};
        int[] nArray4 = new int[]{nArray[0] - nArray2[0], nArray[1] - nArray2[1]};
        int n = MathExt.angleBetweenVectors2D(nArray4, nArray3);
        int n2 = MathExt.getVectorMag2DFixed(nArray4);
        return MathExt.Fmul(n2, MathExt.Fsin(n));
    }

    public static int getDiffBetweenAngles(int n, int n2) {
        int n3 = n2 - n;
        if (n3 > 205887) {
            n3 -= 411775;
        } else if (n3 < -205887) {
            n3 += 411775;
        }
        return n3;
    }
}

