/*
 * Decompiled with CFR 0.152.
 */
package generic;

import generic.AnimationManager;
import javax.microedition.lcdui.Graphics;

public final class AnimPlayer {
    private int mAnimID = -1;
    private int mCurrentFrame = 0;
    private int mCurrentFrameTime = 0;
    private boolean mInitialised = false;
    private boolean mAnimating = false;
    private boolean mLoop = false;
    private boolean mReverse = false;
    private AnimationManager mAnimMgr;

    public AnimPlayer(AnimationManager animationManager) {
        this.mAnimMgr = animationManager;
    }

    public final void updateAnim(int n) {
        if (!this.mAnimating && this.mAnimMgr != null) {
            return;
        }
        this.mCurrentFrameTime += n;
        if (this.mCurrentFrameTime > this.mAnimMgr.animFrameGetDuration(this.mAnimID, this.mCurrentFrame)) {
            if (this.mReverse) {
                this.prevFrame();
            } else {
                this.nextFrame();
            }
        }
    }

    public final void nextFrame() {
        this.mCurrentFrameTime -= this.mAnimMgr.animFrameGetDuration(this.mAnimID, this.mCurrentFrame);
        if (this.mCurrentFrameTime < 0) {
            this.mCurrentFrameTime = 0;
        }
        ++this.mCurrentFrame;
        if (this.mCurrentFrame >= this.mAnimMgr.animGetNumFrames(this.mAnimID)) {
            if (this.mLoop) {
                this.mCurrentFrame = 0;
            } else {
                this.mCurrentFrame = this.mAnimMgr.animGetNumFrames(this.mAnimID) - 1;
                this.mAnimating = false;
            }
        }
    }

    public final void prevFrame() {
        this.mCurrentFrameTime -= this.mAnimMgr.animFrameGetDuration(this.mAnimID, this.mCurrentFrame);
        if (this.mCurrentFrameTime < 0) {
            this.mCurrentFrameTime = 0;
        }
        --this.mCurrentFrame;
        if (this.mCurrentFrame <= 0) {
            if (this.mLoop) {
                this.mCurrentFrame = this.mAnimMgr.animGetNumFrames(this.mAnimID) - 1;
            } else {
                this.mCurrentFrame = 0;
                this.mAnimating = false;
            }
        }
    }

    public void startAnim(int n, boolean bl, boolean bl2) {
        if (bl || this.mAnimID != n) {
            this.mAnimID = n;
            this.mCurrentFrame = this.mReverse ? this.mAnimMgr.animGetNumFrames(this.mAnimID) - 1 : 0;
            this.mCurrentFrameTime = 0;
        } else if (this.mCurrentFrame >= this.mAnimMgr.animGetNumFrames(this.mAnimID)) {
            this.mCurrentFrame = 0;
        } else if (this.mCurrentFrame < 0) {
            this.mCurrentFrame = this.mAnimMgr.animGetNumFrames(this.mAnimID) - 1;
        }
        this.mInitialised = true;
        this.mAnimating = true;
        this.mLoop = bl2;
    }

    public final void drawAnim(Graphics graphics, int n, int n2, boolean bl) {
        if (this.mAnimMgr == null) {
            return;
        }
        if (this.mAnimID >= 0) {
            this.mAnimMgr.drawAnimFrame(graphics, this.mAnimID, this.mCurrentFrame, n, n2);
        }
    }

    public void setReverse(boolean bl) {
        this.mReverse = bl;
    }

    public final int getAnimID() {
        return this.mAnimID;
    }

    public final int getCurrAnimFrame() {
        return this.mCurrentFrame;
    }

    public final int getNumAnimFrames() {
        if (this.mAnimID == -1) {
            return 0;
        }
        if (this.mAnimMgr == null) {
            return 0;
        }
        return this.mAnimMgr.animGetNumFrames(this.mAnimID);
    }

    public final int getAnimDuration() {
        if (this.mAnimID == -1) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.mAnimMgr.animGetNumFrames(this.mAnimID); ++i) {
            n += this.mAnimMgr.animFrameGetDuration(this.mAnimID, i);
        }
        return n;
    }

    public final boolean isAnimating() {
        return this.mAnimating;
    }

    public final boolean isInitialised() {
        return this.mInitialised;
    }

    public void setAnimating(boolean bl) {
        this.mAnimating = bl;
    }

    public void setFrame(int n) {
        this.mCurrentFrame = n;
    }
}

