/*
 * Decompiled with CFR 0.152.
 */
package generic;

import generic.ResourceManager;
import generic.SoundEventConstants;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public final class SoundManager {
    public static final int SOUNDTYPE_AMR = 0;
    public static final int SOUNDTYPE_MP3 = 1;
    public static final int SOUNDTYPE_QCP = 2;
    public static final int SOUNDTYPE_MID = 3;
    public static final int SOUNDTYPE_WAV = 4;
    private static final String[] MIME_TYPES = new String[]{"audio/amr", "audio/mpeg", "audio/vnd.qcelp", "audio/midi", "audio/x-wav"};
    private static boolean m_enabled = false;
    private static ResourceManager m_resourceManager;
    private static int m_currentPlayingSound;
    private int[] m_priorities;
    private int m_soundStartDelay = 0;
    private static Player m_sounds;
    private Player m_soundsdrift;
    public int pauseID = -1;

    public SoundManager(ResourceManager resourceManager) {
        m_resourceManager = resourceManager;
        int n = SoundEventConstants.SOUND_DATA_SETS.length;
        this.m_priorities = new int[n];
    }

    public static boolean loadSound(int n, int n2, int n3) {
        if (n < 0 || m_sounds != null) {
            return false;
        }
        try {
            short s = SoundEventConstants.SOUND_DATA_SETS[n];
            short s2 = SoundEventConstants.SOUND_DATA_FORMATS[n];
            String string = MIME_TYPES[s2];
            InputStream inputStream = m_resourceManager.loadBinaryFile(s);
            m_sounds = Manager.createPlayer((InputStream)inputStream, (String)string);
            m_sounds.realize();
            inputStream.close();
            inputStream = null;
        }
        catch (Exception exception) {
            m_sounds = null;
            return false;
        }
        return true;
    }

    public void freeSound(int n) {
        SoundManager.stopAllSounds();
    }

    public void freeAllSounds() {
        SoundManager.stopAllSounds();
    }

    public static void playSound(int n) {
        if (!m_enabled || n < 0) {
            return;
        }
        if (m_sounds != null && n != m_currentPlayingSound) {
            SoundManager.stopSound(n);
        }
        m_currentPlayingSound = n;
        if (m_sounds == null) {
            SoundManager.loadSound(m_currentPlayingSound, 1, 100);
        }
        try {
            if (m_sounds != null) {
                m_sounds.prefetch();
                m_sounds.start();
            }
        }
        catch (Exception exception) {
            m_sounds = null;
            m_currentPlayingSound = -1;
        }
    }

    public static void stopSound(int n) {
        if (n < 0) {
            return;
        }
        if (m_sounds == null) {
            return;
        }
        try {
            m_sounds.stop();
            m_sounds.deallocate();
            m_sounds.close();
            m_sounds = null;
        }
        catch (Exception exception) {
            m_sounds = null;
            exception.printStackTrace();
        }
        m_currentPlayingSound = -1;
    }

    public void update(int n) {
        if (this.m_soundStartDelay > 0) {
            this.m_soundStartDelay -= n;
        }
    }

    public void appPause() {
        SoundManager.stopAllSounds();
    }

    public void appResume() {
    }

    public static void stopAllSounds() {
        SoundManager.stopSound(m_currentPlayingSound);
    }

    public static boolean isSoundPlaying(int n) {
        if (n < 0 || m_sounds == null) {
            return false;
        }
        return m_sounds.getState() == 400;
    }

    public void setEnabled(boolean bl) {
        m_enabled = bl;
        if (!m_enabled) {
            SoundManager.stopAllSounds();
        }
    }

    public boolean getEnabled() {
        return m_enabled;
    }

    public void appPause1() {
        this.pauseID = m_currentPlayingSound;
        SoundManager.stopAllSounds();
    }

    static {
        m_currentPlayingSound = -1;
    }
}

