/*
 * Decompiled with CFR 0.152.
 */
package generic;

import generic.FontConstants;
import generic.ResourceManager;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class MixedFont {
    private static final short FIXEDW_RANGE = 0;
    private static final short VARIABLEW_RANGE = 1;
    private static final short OFFSET_CASE_UPPER_TO_LOWER = -49;
    public static final byte CHAR_SPACE = 10;
    public static final byte CHAR_MINUS = 22;
    public static final byte CHAR_PIPE = 127;
    private static final byte CHAR_COMMA = 21;
    private static final byte CHAR_PERIOD = 23;
    private static final byte CHAR_A = 32;
    private static final byte CHAR_C = 34;
    private static final byte CHAR_D = 35;
    private static final byte CHAR_G = 38;
    private static final byte CHAR_J = 41;
    private static final byte CHAR_L = 43;
    private static final byte CHAR_P = 47;
    private static final byte CHAR_S = 50;
    private static final byte CHAR_T = 51;
    private static final byte CHAR_V = 53;
    private static final byte CHAR_Y = 56;
    private static final byte CHAR_LA = 81;
    private static final byte CHAR_LZ = 106;
    private int mFontType;
    private Image mFontImage;
    private int mLineHeight;
    private int mSpacing;
    private int mFixedCharWidth;
    private int mFixedScanLength;
    private boolean mKern;
    private int[][] mVarCharAttribs;
    private static final short VAR_ATTRIB_X = 0;
    private static final short VAR_ATTRIB_Y = 1;
    private static final short VAR_ATTRIB_W = 2;
    public static String[] screenRot2121atedStrgdsging1 = new String[]{"PLEASE SWITCH dsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTO PORTRAIT MODE", "VEUILLEZ PASSEgsdgdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgssgdgddsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOsdgdsgR EN MODE PORTRAIT", "IMPOSTA LOdsgsdgdsgsdsgsdgdsHOCHdsdsgsdgdsgsdsgsdgdsgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOFORMATgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOv SCHERMO IN MdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOODALITR VERTICALE", "BITTE WECHSLE INS HOCHdsdsgsdgdsgdsgdsdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdHOCHdsdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOFORMATsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOFORMAT", "PORdsgsdgdsgsdgdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTO FAVOR, CAMBIA A MODOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTO RETRATO", "PORdsgsdgddsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTO FAVOR, MUDA O TEU ECRA PARA O MODO PANOR\u00c2MICO"};
    public static String[] screenRot2121atedStrgdsging2 = new String[]{"PLEASE SWITCH dsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTO PORTRAIT MODE", "VEUILLEZ PASSEgsdgdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgssgdgddsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOsdgdsgR EN MODE PORTRAIT", "IMPOSTA LOdsgsdgdsgsdsgsdgdsHOCHdsdsgsdgdsgsdsgsdgdsgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOFORMATgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOv SCHERMO IN MdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOODALITR VERTICALE", "BITTE WECHSLE INS HOCHdsdsgsdgdsgdsgdsdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdHOCHdsdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOFORMATsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOFORMAT", "PORdsgsdgdsgsdgdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTO FAVOR, CAMBIA A MODOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTO RETRATO", "PORdsgsdgddsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTO FAVOR, MUDA O TEU ECRA PARA O MODO PANOR\u00c2MICO"};
    public static String[] screenRot2121atedStrgdsging3 = new String[]{"PLEASE SWITCH dsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTO PORTRAIT MODE", "VEUILLEZ PASSEgsdgdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgssgdgddsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOsdgdsgR EN MODE PORTRAIT", "IMPOSTA LOdsgsdgdsgsdsgsdgdsHOCHdsdsgsdgdsgsdsgsdgdsgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOFORMATgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOv SCHERMO IN MdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOODALITR VERTICALE", "BITTE WECHSLE INS HOCHdsdsgsdgdsgdsgdsdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdHOCHdsdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOFORMATsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOFORMAT", "PORdsgsdgdsgsdgdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTO FAVOR, CAMBIA A MODOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTO RETRATO", "PORdsgsdgddsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTO FAVOR, MUDA O TEU ECRA PARA O MODO PANOR\u00c2MICO"};

    public static final MixedFont createRangedFixedWidthFont(Image image, int n, int n2, byte by, int n3, int n4, int n5) {
        return new MixedFont(0, image, n, n2, by, n3, n4, n5, null, false);
    }

    public static final MixedFont createRangedVariableWidthFont(Image image, int n, int n2, byte by, int n3, int[][] nArray, boolean bl) {
        return new MixedFont(1, image, n, n2, by, n3, -1, -1, nArray, bl);
    }

    private MixedFont(int n, Image image, int n2, int n3, byte by, int n4, int n5, int n6, int[][] nArray, boolean bl) {
        this.mFontType = n;
        this.mFontImage = image;
        this.mLineHeight = n2;
        this.mSpacing = n3;
        switch (this.mFontType) {
            case 0: {
                this.mFixedCharWidth = n5;
                this.mFixedScanLength = n6;
            }
            case 1: {
                this.mVarCharAttribs = nArray;
                this.mKern = bl;
            }
        }
    }

    public final void drawString(Graphics graphics, String string, int n, int n2, int n3) {
        int n4 = string.length();
        if (n4 == 0) {
            return;
        }
        n = this.getJustifiedX(string, n, n3);
        if ((n3 & 2) != 0) {
            n2 -= this.mLineHeight >> 1;
        } else if ((n3 & 0x20) != 0) {
            n2 -= this.mLineHeight;
        }
        if (this.mFontType == 0) {
            int n5 = this.mFixedCharWidth + this.mSpacing;
            for (int i = 0; i < n4; ++i) {
                this.renderCharDrawRegion(graphics, string.charAt(i), n + i * n5, n2);
            }
        } else {
            int n6 = 0;
            int n7 = -1;
            int n8 = -1;
            int n9 = 0;
            for (int i = 0; i < n4; ++i) {
                n7 = string.charAt(i);
                if (i > 0) {
                    n8 = string.charAt(i - 1);
                    if (this.mKern) {
                        n9 = this.getKerningOffset(n8, n7);
                    }
                }
                this.renderCharDrawRegion(graphics, n7, n + n9, n2);
                n6 = this.getCharWidth(n7) + n9;
                n += n6 + this.mSpacing;
            }
        }
    }

    public final void drawChars(Graphics graphics, byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        n2 = this.calcStringLength(byArray, n, n2);
        n = n >= 0 ? n : 0;
        n3 = this.getJustifiedX(byArray, n, n2, n3, n5);
        if ((n5 & 2) != 0) {
            n4 -= this.mLineHeight >> 1;
        } else if ((n5 & 0x20) != 0) {
            n4 -= this.mLineHeight;
        }
        if (this.mFontType == 0) {
            int n6 = this.mFixedCharWidth + this.mSpacing;
            int n7 = 0;
            while (n7 < n2) {
                this.renderCharDrawRegion(graphics, byArray[n], n3 + n7 * n6, n4);
                ++n7;
                ++n;
            }
        } else {
            int n8 = 0;
            int n9 = -1;
            int n10 = -1;
            int n11 = 0;
            int n12 = 0;
            while (n12 < n2) {
                n9 = byArray[n];
                if (n12 > 0) {
                    n10 = byArray[n - 1];
                    if (this.mKern) {
                        n11 = this.getKerningOffset(n10, n9);
                    }
                }
                this.renderCharDrawRegion(graphics, n9, n3 + n11, n4);
                n8 = this.getCharWidth(n9) + n11;
                n3 += n8 + this.mSpacing;
                ++n12;
                ++n;
            }
        }
    }

    public final void renderCharDrawRegion(Graphics graphics, int n, int n2, int n3) {
        int n4;
        int n5 = n4 = this.mFontType == 0 ? this.mFixedCharWidth : this.mVarCharAttribs[n][2];
        if (this.mFontType == 0) {
            int n6 = n % this.mFixedScanLength;
            int n7 = n / this.mFixedScanLength;
            MixedFont.drawRegionBB(graphics, this.mFontImage, this.mFixedCharWidth * n6, this.mLineHeight * n7, n4, this.mLineHeight, 0, n2, n3, 20);
        } else {
            MixedFont.drawRegionBB(graphics, this.mFontImage, this.mVarCharAttribs[n][0], this.mVarCharAttribs[n][1], n4, this.mLineHeight, 0, n2, n3, 20);
        }
    }

    public final void renderChar(Graphics graphics, byte by, int n, int n2) {
        if (this.mFontType == 0) {
            int n3 = by % this.mFixedScanLength;
            int n4 = by / this.mFixedScanLength;
            graphics.drawImage(this.mFontImage, n - this.mFixedCharWidth * n3, n2 - this.mLineHeight * n4, 20);
        } else {
            graphics.drawImage(this.mFontImage, n - this.mVarCharAttribs[by][0], n2 - this.mVarCharAttribs[by][1], 20);
        }
    }

    public final int getCharWidth(int n) {
        int n2 = 0;
        if (n >= 0) {
            if (this.mFontType == 0) {
                n2 = this.mFixedCharWidth;
            } else if (n < this.mVarCharAttribs.length) {
                n2 = this.mVarCharAttribs[n][2];
            }
        }
        return n2;
    }

    public final int getStringWidth(String string) {
        if (this.mFontType == 0) {
            return string.length() * (this.mFixedCharWidth + this.mSpacing) - this.mSpacing;
        }
        int n = 0;
        int n2 = string.length();
        if (n2 == 0) {
            return 0;
        }
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 = string.charAt(i);
            if (i > 0) {
                n4 = string.charAt(i - 1);
                if (this.mKern) {
                    n5 = this.getKerningOffset(n4, n3);
                }
            }
            n += this.getCharWidth(n3) + n5 + this.mSpacing;
        }
        return n - this.mSpacing;
    }

    public final int getStringWidth(byte[] byArray, int n, int n2) {
        if (this.mFontType == 0) {
            return n2 * (this.mFixedCharWidth + this.mSpacing) - this.mSpacing;
        }
        int n3 = 0;
        int n4 = n2;
        if (n4 == 0) {
            return 0;
        }
        int n5 = -1;
        int n6 = -1;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n2 && byArray[n] >= 0) {
            n5 = byArray[n];
            if (n8 > 0) {
                n6 = byArray[n - 1];
                if (this.mKern) {
                    n7 = this.getKerningOffset(n6, n5);
                }
            }
            n3 += this.getCharWidth(n5) + n7 + this.mSpacing;
            ++n8;
            ++n;
        }
        return n3 - this.mSpacing;
    }

    public final int calcStringLength(byte[] byArray, int n, int n2) {
        int n3;
        for (n3 = 0; n3 < n2 && n + n3 < byArray.length && byArray[n + n3] >= 0; ++n3) {
        }
        if (n3 < n2) {
            n2 = n3;
        }
        n2 = n + n2 < byArray.length ? n2 : byArray.length - n;
        return n2;
    }

    public final int getJustifiedX(String string, int n, int n2) {
        if ((n2 & 8) != 0) {
            n -= this.getStringWidth(string);
        } else if ((n2 & 1) != 0) {
            n -= this.getStringWidth(string) >> 1;
        }
        return n;
    }

    public final int getJustifiedX(byte[] byArray, int n, int n2, int n3, int n4) {
        if ((n4 & 8) != 0) {
            n3 -= this.getStringWidth(byArray, n, n2);
        } else if ((n4 & 1) != 0) {
            n3 -= this.getStringWidth(byArray, n, n2) >> 1;
        }
        return n3;
    }

    public final int getLineHeight() {
        return this.mLineHeight;
    }

    public final int getSpacing() {
        return this.mSpacing;
    }

    public final int getKerningOffset(int n, int n2) {
        int n3 = 0;
        if (n >= 81 && n <= 106) {
            n -= 49;
        }
        if (this.mFontType == 0) {
            n3 = 0;
        } else if (n == 43 || n == 32) {
            if (n2 == 51 || n2 == 56) {
                n3 = -2;
            } else if (n2 == 34 || n2 == 38 || n2 == 53) {
                n3 = -1;
            }
        } else if (n == 35 || n == 50) {
            if (n2 == 51 || n2 == 53 || n2 == 56) {
                n3 = -1;
            }
        } else if (!(n != 47 && n != 51 && n != 56 || n2 != 32 && n2 != 41 && n2 != 23 && n2 != 21)) {
            n3 = -2;
        }
        return n3;
    }

    public static final MixedFont loadFromStream(ResourceManager resourceManager, int n, int n2) {
        int[] nArray = new int[]{0, 0, 0, 0};
        return MixedFont.loadFromStream(resourceManager, n, n2, nArray, false);
    }

    public static final MixedFont loadFromStream(ResourceManager resourceManager, int n, int n2, boolean bl) {
        int[] nArray = new int[]{0, 0, 0, 0};
        return MixedFont.loadFromStream(resourceManager, n, n2, nArray, bl);
    }

    public static final MixedFont loadFromStream(ResourceManager resourceManager, int n, int n2, int[] nArray, boolean bl) {
        try {
            DataInputStream dataInputStream = new DataInputStream(resourceManager.loadBinaryFile(n));
            short s = dataInputStream.readShort();
            int n3 = FontConstants.FONTIMAGE_RES_IDS[s];
            short s2 = dataInputStream.readShort();
            short s3 = dataInputStream.readShort();
            Image image = resourceManager.loadImage(n3);
            if (s2 == 0 || s2 == 1) {
                byte by = dataInputStream.readByte();
                int n4 = dataInputStream.readShort();
                switch (s2) {
                    case 0: {
                        short s4 = dataInputStream.readShort();
                        short s5 = dataInputStream.readShort();
                        return MixedFont.createRangedFixedWidthFont(image, s3, n2, by, n4, s4, s5);
                    }
                    case 1: {
                        int[][] nArray2 = new int[n4][3];
                        for (int i = 0; i < n4; ++i) {
                            for (int j = 0; j < 3; ++j) {
                                short s6 = dataInputStream.readShort();
                                nArray2[i][j] = s6;
                            }
                        }
                        return MixedFont.createRangedVariableWidthFont(image, s3, n2, by, n4, nArray2, bl);
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static void drawRegionBB(Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (n5 == 0) {
            int n9 = graphics.getClipX();
            int n10 = graphics.getClipY();
            int n11 = graphics.getClipWidth();
            int n12 = graphics.getClipHeight();
            int n13 = n6 + (n9 > n6 ? n9 - n6 : 0);
            int n14 = n7 + (n10 > n7 ? n10 - n7 : 0);
            graphics.setClip(n13, n14, Math.min(n6 + n3, n11 + n9) - n13, Math.min(n7 + n4, n12 + n10) - n14);
            graphics.drawImage(image, n6 - n, n7 - n2, n8);
            graphics.setClip(n9, n10, n11, n12);
        } else {
            graphics.drawRegion(image, n, n2, n3, n4, n5, n6, n7, n8);
        }
    }
}

