/*
 * Decompiled with CFR 0.152.
 */
package generic;

import game.AppEngine;
import game.ResourceConstantOverrides;
import generic.AnimConstants;
import generic.ColourConstants;
import generic.FontConstants;
import generic.MathExt;
import generic.ResourceConstants;
import generic.SoundEventConstants;
import generic.StringConstants;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public final class ResourceManager
implements AnimConstants,
FontConstants,
StringConstants,
ResourceConstants,
ColourConstants,
SoundEventConstants,
ResourceConstantOverrides {
    private String mFileNamePrefix;
    private static StringBuffer mFileNameBuffer = new StringBuffer(80);
    private static final int PNG_SIGNATURE_SIZE = 8;
    private static final int CHUNK_LENGTH_SIZE = 4;
    private static final int CHUNK_TYPE_SIZE = 4;
    private static final int CHUNK_DATA_OFFSET = 8;
    private static final int CHUNK_CRC_SIZE = 4;
    private static final int CHUNK_OVERHEAD_SIZE = 12;
    private static final int ZLIB_HEADER_SIZE = 7;
    private static final int ADLER_SIZE = 4;
    private static final int CRC32_POLYNOMIAL = -306674912;
    private static final int CHUNK_TYPE_VAL_IHDR = 1229472850;
    private static final int CHUNK_TYPE_VAL_PLTE = 1347179589;
    private static final int CHUNK_TYPE_VAL_tRNS = 1951551059;
    private static final int CHUNK_TYPE_VAL_IDAT = 1229209940;
    private static final int CHUNK_TYPE_VAL_IEND = 1229278788;
    private int[] mCRCTable;
    private static final int SCALE_MAX_WIDTH = 45;
    private static final int SCALE_MAX_HEIGHT = 74;
    private int[] m_scaleBufferRGB;
    private int m_lastSrcImageID;
    private byte[] m_srcBytes;

    public ResourceManager() {
        this("");
        this.buildLUT();
    }

    public ResourceManager(String string) {
        this.mFileNamePrefix = string;
        this.buildLUT();
    }

    public static final int ID_TO_FILESIZE(int n) {
        return ResourceConstants.RESOURCE_FILESIZE_LIST[n];
    }

    public static final String ID_TO_FILENAME(int n) {
        return ResourceConstants.RESOURCE_FILENAMES_LIST[n];
    }

    public final Image loadImage(int n) {
        this.m_lastSrcImageID = -1;
        this.m_srcBytes = null;
        try {
            mFileNameBuffer.delete(0, mFileNameBuffer.length());
            mFileNameBuffer.append(this.mFileNamePrefix);
            mFileNameBuffer.append(ResourceManager.ID_TO_FILENAME(n));
            return Image.createImage((String)mFileNameBuffer.toString());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public final InputStream loadBinaryFile(int n) {
        mFileNameBuffer.delete(0, mFileNameBuffer.length());
        mFileNameBuffer.append(this.mFileNamePrefix);
        mFileNameBuffer.append(ResourceManager.ID_TO_FILENAME(n));
        return this.getClass().getResourceAsStream(mFileNameBuffer.toString());
    }

    public final Image loadImageCrazy(int n) {
        Object object;
        mFileNameBuffer.delete(0, mFileNameBuffer.length());
        mFileNameBuffer.append(this.mFileNamePrefix);
        mFileNameBuffer.append(ResourceManager.ID_TO_FILENAME(n));
        int n2 = 0;
        int n3 = 0;
        try {
            object = Image.createImage((String)mFileNameBuffer.toString());
            n2 = object.getWidth();
            n3 = object.getHeight();
        }
        catch (Throwable throwable) {
            return null;
        }
        System.gc();
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Thread.yield();
        object = new byte[n2 * n3 * 2 + 100];
        object[((Image)object).length - 1] = (Image)true;
        InputStream inputStream = this.loadBinaryFile(n);
        object = null;
        System.gc();
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Thread.yield();
        Image image = null;
        try {
            image = Image.createImage((InputStream)inputStream);
        }
        catch (Throwable throwable) {
            return null;
        }
        inputStream = null;
        System.gc();
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Thread.yield();
        return image;
    }

    public final Image loadImageMem(int n) {
        try {
            byte[] byArray = new byte[15000];
            byArray[14999] = 1;
            InputStream inputStream = this.loadBinaryFile(n);
            byArray = null;
            System.gc();
            try {
                Thread.sleep(16L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Thread.yield();
            Image image = Image.createImage((InputStream)inputStream);
            inputStream = null;
            return image;
        }
        catch (OutOfMemoryError outOfMemoryError) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public final Image loadImageScaledRGB(int n, int n2) {
        try {
            mFileNameBuffer.delete(0, mFileNameBuffer.length());
            mFileNameBuffer.append(this.mFileNamePrefix);
            mFileNameBuffer.append(ResourceManager.ID_TO_FILENAME(n));
            Image image = Image.createImage((String)mFileNameBuffer.toString());
            int n3 = image.getWidth();
            int n4 = image.getHeight();
            int n5 = MathExt.Fmul(n3 << 16, n2) + 32768 >> 16;
            int n6 = MathExt.Fmul(n4 << 16, n2) + 32768 >> 16;
            int[] nArray = new int[n3 * n4];
            int[] nArray2 = new int[n5 * n6];
            image.getRGB(nArray, 0, n3, 0, 0, n3, n4);
            this.scaleRGB(nArray, 0, 0, n3, n4, nArray2, 0, 0, n5, n6);
            return Image.createRGBImage((int[])nArray2, (int)n5, (int)n6, (boolean)true);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private void scaleRGB(int[] nArray, int n, int n2, int n3, int n4, int[] nArray2, int n5, int n6, int n7, int n8) {
        if (this.m_scaleBufferRGB.length < n3 * n4) {
            this.m_scaleBufferRGB = null;
            System.gc();
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Thread.yield();
            this.m_scaleBufferRGB = new int[n3 * n4];
        }
        int[] nArray3 = this.m_scaleBufferRGB;
        int n9 = n3;
        int n10 = n2 * n9 + n;
        int n11 = n3;
        int n12 = n6 * n11 + n;
        int n13 = n4;
        int n14 = n4 << 1;
        int n15 = n8 << 1;
        int n16 = n8;
        if (n4 < n8) {
            while (n6 < n16) {
                System.arraycopy(nArray, n10, nArray3, n12, n9);
                if ((n13 += n14) >= n15) {
                    n13 -= n15;
                    ++n2;
                    n10 += n9;
                }
                ++n6;
                n12 += n11;
            }
        } else {
            while (n6 < n16) {
                if ((n13 += n15) > n14) {
                    System.arraycopy(nArray, n10, nArray3, n12, n9);
                    ++n6;
                    n12 += n11;
                    n13 -= n14;
                }
                ++n2;
                n10 += n9;
            }
        }
        n9 = n3;
        n10 = n;
        n11 = n7;
        n12 = n5;
        n13 = n3;
        int n17 = n3 << 1;
        int n18 = n7 << 1;
        n16 = n7;
        int n19 = n7 * n8;
        if (n3 < n7) {
            while (n5 < n16) {
                int n20 = n10;
                for (int i = n12; i < n19; i += n11) {
                    nArray2[i] = nArray3[n20];
                    n20 += n9;
                }
                if ((n13 += n17) >= n18) {
                    n13 -= n18;
                    ++n;
                    ++n10;
                }
                ++n5;
                ++n12;
            }
        } else {
            while (n5 < n16) {
                if ((n13 += n18) > n17) {
                    int n21 = n10;
                    for (int i = n12; i < n19; i += n11) {
                        nArray2[i] = nArray3[n21];
                        n21 += n9;
                    }
                    ++n5;
                    ++n12;
                    n13 -= n17;
                }
                ++n;
                ++n10;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] loadBinaryFileToByteArray(int n) {
        Object object;
        Object var2_2 = null;
        int n2 = 0;
        try {
            object = this.loadBinaryFile(n);
            while (((InputStream)object).read() >= 0) {
                ++n2;
            }
        }
        catch (Exception exception) {
        }
        finally {
            var2_2 = null;
            AppEngine.tryDefragMemory(25);
        }
        if ((object = (Object)new byte[n2]) == null) {
            return null;
        }
        try {
            InputStream inputStream = this.loadBinaryFile(n);
            if (inputStream == null) {
                return null;
            }
            inputStream.read((byte[])object);
            inputStream = null;
        }
        catch (Exception exception) {
            return null;
        }
        return object;
    }

    public void nullifyPNGscaleBuffer() {
        this.m_srcBytes = null;
        AppEngine.tryDefragMemory(25);
    }

    public Image loadImageScaled(int n, int n2, int n3) {
        if (n != this.m_lastSrcImageID) {
            this.m_lastSrcImageID = n;
            this.m_srcBytes = this.loadBinaryFileToByteArray(n);
        }
        if (this.m_srcBytes == null) {
            return null;
        }
        return this.loadPNGScaled(this.m_srcBytes, 0, n2, n3);
    }

    public Image loadPNGScaled(byte[] byArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        if (this.unsignedByteToInt(byArray[n++]) != 137 || this.unsignedByteToInt(byArray[n++]) != 80 || this.unsignedByteToInt(byArray[n++]) != 78 || this.unsignedByteToInt(byArray[n++]) != 71 || this.unsignedByteToInt(byArray[n++]) != 13 || this.unsignedByteToInt(byArray[n++]) != 10 || this.unsignedByteToInt(byArray[n++]) != 26 || this.unsignedByteToInt(byArray[n++]) != 10) {
            return null;
        }
        while (n < byArray.length && n14 == 0) {
            n5 = this.readBigEndianInt(byArray, n);
            n4 = this.readBigEndianInt(byArray, n + 4);
            if (n4 == 1229472850) {
                n6 = n;
                n7 = n5;
            } else if (n4 == 1347179589) {
                n8 = n;
                n9 = n5;
            } else if (n4 == 1951551059) {
                n10 = n;
                n11 = n5;
            } else if (n4 == 1229209940) {
                n12 = n;
                n13 = n5;
            } else if (n4 == 1229278788) {
                n14 = n;
                n15 = n5;
            }
            n += 12 + n5;
        }
        n5 = this.readBigEndianInt(byArray, n6 + 8);
        n4 = this.readBigEndianInt(byArray, n6 + 8 + 4);
        int n16 = MathExt.Fmul(n5 << 16, n2) + 32768 >> 16;
        int n17 = MathExt.Fmul(n4 << 16, n3) + 32768 >> 16;
        if (n16 <= 0) {
            n16 = 1;
        }
        if (n17 <= 0) {
            n17 = 1;
        }
        int n18 = 7 + (n16 * n17 + n17) + 4;
        int n19 = 4;
        int n20 = n7 + n9 + n18 + n15;
        if (n11 > 0) {
            ++n19;
            n20 += n11;
        }
        n20 += 8;
        byte[] byArray2 = new byte[n20 += n19 * 12];
        int n21 = 0;
        System.arraycopy(byArray, 0, byArray2, n21, 8 + n7 + 8);
        this.writeBigEndianInt(n16, byArray2, 16);
        this.writeBigEndianInt(n17, byArray2, 20);
        int n22 = this.calcCRC32(byArray2, 12, n7 + 4);
        this.writeBigEndianInt(n22, byArray2, n21 += 8 + n7 + 8);
        System.arraycopy(byArray, n8, byArray2, n21 += 4, n9 + 12);
        n21 += n9 + 12;
        if (n11 > 0) {
            System.arraycopy(byArray, n10, byArray2, n21, n11 + 12);
            n21 += n11 + 12;
        }
        this.writeBigEndianInt(n18, byArray2, n21);
        this.writeBigEndianInt(1229209940, byArray2, n21 += 4);
        this.scaleIDAT(byArray, n12 + 8, n5, n4, byArray2, n21 += 4, n16, n17);
        int n23 = this.calcCRC32(byArray2, n21 - 4, n18 + 4);
        this.writeBigEndianInt(n23, byArray2, n21 += n18);
        System.arraycopy(byArray, n14, byArray2, n21 += 4, n15 + 12);
        return Image.createImage((byte[])byArray2, (int)0, (int)byArray2.length);
    }

    private void scaleIDAT(byte[] byArray, int n, int n2, int n3, byte[] byArray2, int n4, int n5, int n6) {
        int n7;
        int n8 = n4;
        System.arraycopy(byArray, n, byArray2, n8, 3);
        int n9 = n5 * n6 + n6;
        this.writeBigEndianShort((short)n9, byArray2, n8 += 3);
        this.writeBigEndianShort((short)(~n9), byArray2, n8 += 2);
        n8 += 2;
        n += 7;
        int n10 = n2 << 1;
        int n11 = n3 << 1;
        int n12 = 0;
        int n13 = n2 + 1;
        int n14 = n5 << 1;
        int n15 = n6 << 1;
        int n16 = 0;
        int n17 = n5 + 1;
        int n18 = n3;
        boolean bl = false;
        while (!bl) {
            n18 += n15;
            while (n18 > n11) {
                n18 -= n11;
                n7 = 0;
                int n19 = 0;
                int n20 = n2;
                boolean bl2 = false;
                while (!bl2) {
                    n20 += n14;
                    while (n20 > n10) {
                        n20 -= n10;
                        int n21 = n8 + n19 + n16 * n17 + 1;
                        int n22 = n + n7 + n12 * n13 + 1;
                        byArray2[n21] = byArray[n22];
                        if (++n19 < n5) continue;
                        bl2 = true;
                        break;
                    }
                    ++n7;
                }
                if (++n16 < n6) continue;
                bl = true;
                break;
            }
            ++n12;
        }
        n7 = this.updateAdler32(byArray2, 1, n4 + 7, n9);
        this.writeBigEndianInt(n7, byArray2, n8 += n9);
    }

    public Image loadImageMirroredPNG(int n) {
        int n2;
        int n3;
        byte[] byArray;
        int n4 = 5000;
        try {
            InputStream inputStream = this.loadBinaryFile(n);
            byArray = new byte[n4];
            n4 = inputStream.read(byArray);
            inputStream = null;
        }
        catch (IOException iOException) {
            System.err.println("Error loading and transforming image: " + this.mFileNamePrefix + ResourceManager.ID_TO_FILENAME(n) + ": " + iOException.toString());
            return null;
        }
        if (this.unsignedByteToInt(byArray[0]) != 137 || this.unsignedByteToInt(byArray[1]) != 80 || this.unsignedByteToInt(byArray[2]) != 78 || this.unsignedByteToInt(byArray[3]) != 71 || this.unsignedByteToInt(byArray[4]) != 13 || this.unsignedByteToInt(byArray[5]) != 10 || this.unsignedByteToInt(byArray[6]) != 26 || this.unsignedByteToInt(byArray[7]) != 10) {
            return null;
        }
        int n5 = this.readBigEndianInt(byArray, 8);
        String string = this.readPNGChunkType(byArray, 12);
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if (n5 > 0 && string.equals("IHDR")) {
            n6 = this.readBigEndianInt(byArray, 16);
            n7 = this.readBigEndianInt(byArray, 20);
            n8 = byArray[24];
            n9 = byArray[25];
        }
        if (n8 != 8 || n9 != 3) {
            return null;
        }
        int n10 = this.getChunkStartIndex(byArray, "IDAT");
        int n11 = n4;
        int n12 = n6 * n7 + n7 + 7 + 4;
        int n13 = n11;
        int n14 = n12;
        int n15 = n10 + 4 + 4;
        int n16 = n15 + n14;
        int n17 = n15 + 7 + 1;
        int n18 = n6 + 1;
        for (n3 = 0; n3 < n7; ++n3) {
            n2 = n17 + n3 * n18;
            int n19 = n2 + n6 - 1;
            byArray[n2 - 1] = 0;
            for (int i = 0; i < n6 >> 1; ++i) {
                byte by = byArray[n19 - i];
                byArray[n19 - i] = byArray[n2 + i];
                byArray[n2 + i] = by;
            }
        }
        n3 = this.updateAdler32(byArray, 1, n15 + 7, n6 * n7 + n7);
        this.writeBigEndianInt(n3, byArray, n16 - 4);
        n2 = this.calcCRC32(byArray, n10 + 4, 4 + n14);
        this.writeBigEndianInt(n2, byArray, n16);
        try {
            Image image = Image.createImage((byte[])byArray, (int)0, (int)n13);
            if (image != null) {
                return image;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void buildLUT() {
        this.mCRCTable = new int[256];
        for (int i = 0; i <= 255; ++i) {
            int n = i;
            for (int j = 8; j > 0; --j) {
                if ((n & 1) == 1) {
                    n = n >>> 1 ^ 0xEDB88320;
                    continue;
                }
                n >>>= 1;
            }
            this.mCRCTable[i] = n;
        }
    }

    public int updateAdler32(byte[] byArray, int n, int n2, int n3) {
        int n4 = n & 0xFFFF;
        int n5 = n >>> 16;
        while (n3-- > 0) {
            n4 = (n4 + (byArray[n2++] & 0xFF)) % 65521;
            n5 = (n5 + n4) % 65521;
        }
        n = n5 << 16 | n4;
        return n;
    }

    public int calcCRC32(byte[] byArray, int n, int n2) {
        int n3 = -1;
        for (int i = n; i < n + n2; ++i) {
            int n4 = 0xFF & byArray[i] ^ n3 & 0xFF;
            n3 = n3 >>> 8 ^ this.mCRCTable[n4];
        }
        return ~n3;
    }

    private int readBigEndianInt(byte[] byArray, int n) {
        int n2 = (byArray[n] & 0xFF) << 24;
        int n3 = (byArray[n + 1] & 0xFF) << 16;
        int n4 = (byArray[n + 2] & 0xFF) << 8;
        int n5 = byArray[n + 3] & 0xFF;
        int n6 = n2 | n3 | n4 | n5;
        return n6;
    }

    private void writeBigEndianInt(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >> 24 & 0xFF);
        byArray[n2 + 1] = (byte)(n >> 16 & 0xFF);
        byArray[n2 + 2] = (byte)(n >> 8 & 0xFF);
        byArray[n2 + 3] = (byte)(n & 0xFF);
    }

    private void writeBigEndianShort(short s, byte[] byArray, int n) {
        byArray[n] = (byte)(s & 0xFF);
        byArray[n + 1] = (byte)(s >> 8 & 0xFF);
    }

    private String readPNGChunkType(byte[] byArray, int n) {
        try {
            return new String(new Character((char)byArray[n]).toString() + new Character((char)byArray[n + 1]).toString() + new Character((char)byArray[n + 2]).toString() + new Character((char)byArray[n + 3]).toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private int unsignedByteToInt(byte by) {
        return 0xFF & by;
    }

    private int getChunkStartIndex(byte[] byArray, String string) {
        int n;
        String string2;
        int n2 = 8;
        do {
            n = this.readBigEndianInt(byArray, n2);
        } while (!(string2 = this.readPNGChunkType(byArray, n2 + 4)).equals(string) && (n2 += 12 + n) < byArray.length);
        return n2;
    }

    private String getTypeName(int n) {
        switch (n) {
            case 1229472850: {
                return "CHUNK_TYPE_VAL_IHDR";
            }
            case 1347179589: {
                return "CHUNK_TYPE_VAL_PLTE";
            }
            case 1951551059: {
                return "CHUNK_TYPE_VAL_tRNS";
            }
            case 1229209940: {
                return "CHUNK_TYPE_VAL_IDAT";
            }
            case 1229278788: {
                return "CHUNK_TYPE_VAL_IEND";
            }
        }
        return "unknown";
    }
}

