/*
 * Decompiled with CFR 0.152.
 */
package generic;

import generic.AnimConstants;
import generic.AnimPlayer;
import generic.MathExt;
import generic.ResourceManager;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class AnimationManager {
    private static final byte SUB_IMAGE_ID = 0;
    private static final byte SUB_IMAGE_X = 1;
    private static final byte SUB_IMAGE_Y = 2;
    private static final byte SUB_IMAGE_WIDTH = 3;
    private static final byte SUB_IMAGE_HEIGHT = 4;
    private static final byte NUM_SUB_IMAGE_FIELDS = 5;
    private static final byte ANIM_FIRST_FRAME_OFFSET = 0;
    private static final byte ANIM_NUM_FRAMES = 1;
    private static final byte ANIM_NUM_SHORTS_IN_DATA = 2;
    private static final byte FRAME_NUM_PRIMITIVES = 0;
    private static final byte FRAME_DURATION = 1;
    private static final byte FRAME_BYTE_OFFSET = 2;
    private static final byte FRAME_SHORT_OFFSET = 3;
    private static final byte FRAME_NUM_SHORTS_IN_DATA = 4;
    private static final byte PRIMITIVE_SPRITE_ENUM = 0;
    private static final byte PRIMITIVE_CLIP_ENUM = 1;
    private static final byte PRIMITIVE_COLL_BOX_ENUM = 2;
    private static final byte PRIMITIVE_HOLLOW_RECTANGLE_ENUM = 3;
    private static final byte PRIMITIVE_FILLED_RECTANGLE_ENUM = 4;
    private static final byte PRIMITIVE_HOLLOW_ELLIPSE_ENUM = 5;
    private static final byte PRIMITIVE_FILLED_ELLIPSE_ENUM = 6;
    private static final byte PRIMITIVE_FIRE_POINT_ENUM = 7;
    private static final byte PRIMITIVE_LINE_ENUM = 8;
    private static final byte PRIMITIVE_TEXT_ENUM = 9;
    private static final byte PRIMITIVE_COLOR_ENUM = 10;
    private static final byte PRIMITIVE_XFLIPPED_SPRITE_ENUM = 11;
    private static final int NUM_BYTES_IN_SPRITE_PRIMITIVE = 1;
    private static final int NUM_SHORTS_IN_SPRITE_PRIMITIVE = 3;
    private static final byte ANIMPLAYER_POOLSIZE = 16;
    private AnimPlayer[] m_animPlayerPool;
    private byte[] m_colourData;
    private short[] m_animData;
    private short[] m_frameData;
    private byte[] m_primitiveByteData;
    private short[] m_primitiveShortData;
    private short[][] m_subImages;
    private Image[] m_animImageArray;
    private short[] m_imageLoadCountArray;
    private static final short[] OPP_BMW = new short[]{50, 51, 52, 53, 54, 55, 56};
    private static final short[] OPP_CHEVY = new short[]{63, 64, 65, 66, 67, 68, 69};
    private static final short[] OPP_COROLLA = new short[]{76, 77, 78, 79, 80, 81, 82};
    private static final short[] OPP_SKYLINE_GTR = new short[]{124, 125, 126, 127, 128, 129, 130};
    private static final short[] OPP_MUSTANG = new short[]{98, 99, 100, 101, 102, 103, 104};
    private static final short[] OPP_NISSAN350Z = new short[]{111, 112, 113, 114, 115, 116, 117};
    private static final short[] OBJECT_ALL_CHEVRON_LEFT_TURN = new short[]{173, 174, 175, 176, 177, 178, 179};
    private static final short[] OBJECT_ALL_CHEVRON_RIGHT_TURN = new short[]{181, 182, 183, 184, 185, 186, 187};
    private static final short[] OBJECT_BEACH_PALMTREE = new short[]{189, 190, 191, 192, 193, 194, 195};
    private static final short[] OBJECT_CANYON_BUSH = new short[]{197, 198, 199, 200, 201, 202, 203};
    private static final short[] OBJECT_CANYON_CACTUS = new short[]{205, 206, 207, 208, 209, 210, 211};
    private static final short[] OBJECT_CANYON_DEADTREE = new short[]{213, 214, 215, 216, 217, 218, 219};
    private static final short[] OBJECT_COUNTRY_TREES = new short[]{221, 222, 223, 224, 225, 226, 227};
    private static final short[] OBJECT_COUNTRY_TREE = new short[]{229, 230, 231, 232, 233, 234, 235};
    private static final short[] SCALE_SIZE_02 = new short[]{50, 63, 76, 124, 98, 111, 173, 181, 189, 197, 205, 213, 221, 229};
    private static final short[] SCALE_SIZE_03 = new short[]{51, 64, 77, 125, 99, 112, 174, 182, 190, 198, 206, 214, 222, 230};
    private static final short[] SCALE_SIZE_04 = new short[]{52, 65, 78, 126, 100, 113, 175, 183, 191, 199, 207, 215, 223, 231};
    private static final short[] SCALE_SIZE_05 = new short[]{53, 66, 79, 127, 101, 114, 176, 184, 192, 200, 208, 216, 224, 232};
    private static final short[] SCALE_SIZE_06 = new short[]{54, 67, 80, 128, 102, 115, 177, 185, 193, 201, 209, 217, 225, 233};
    private static final short[] SCALE_SIZE_07 = new short[]{55, 68, 81, 129, 103, 116, 178, 186, 194, 202, 210, 218, 226, 234};
    private static final short[] SCALE_SIZE_08 = new short[]{56, 69, 82, 130, 104, 117, 179, 187, 195, 203, 211, 219, 227, 227};
    public static String[] screenRot2121atedStrgdsging1 = new String[]{"PLEASE SWITCH dsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTO PORTRAIT MODE", "VEUILLEZ PASSEgsdgdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgssgdgddsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOsdgdsgR EN MODE PORTRAIT", "IMPOSTA LOdsgsdgdsgsdsgsdgdsHOCHdsdsgsdgdsgsdsgsdgdsgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOFORMATgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOv SCHERMO IN MdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOODALITR VERTICALE", "BITTE WECHSLE INS HOCHdsdsgsdgdsgdsgdsdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdHOCHdsdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOFORMATsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOFORMAT", "PORdsgsdgdsgsdgdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTO FAVOR, CAMBIA A MODOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTO RETRATO", "PORdsgsdgddsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTO FAVOR, MUDA O TEU ECRA PARA O MODO PANOR\u00c2MICO"};
    public static String[] screenRot2121atedStrgdsging2 = new String[]{"PLEASE SWITCH dsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTO PORTRAIT MODE", "VEUILLEZ PASSEgsdgdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgssgdgddsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOsdgdsgR EN MODE PORTRAIT", "IMPOSTA LOdsgsdgdsgsdsgsdgdsHOCHdsdsgsdgdsgsdsgsdgdsgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOFORMATgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOv SCHERMO IN MdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOODALITR VERTICALE", "BITTE WECHSLE INS HOCHdsdsgsdgdsgdsgdsdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdHOCHdsdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOFORMATsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOFORMAT", "PORdsgsdgdsgsdgdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTO FAVOR, CAMBIA A MODOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTO RETRATO", "PORdsgsdgddsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTO FAVOR, MUDA O TEU ECRA PARA O MODO PANOR\u00c2MICO"};
    public static String[] screenRot2121atedStrgdsging3 = new String[]{"PLEASE SWITCH dsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTO PORTRAIT MODE", "VEUILLEZ PASSEgsdgdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgssgdgddsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOsdgdsgR EN MODE PORTRAIT", "IMPOSTA LOdsgsdgdsgsdsgsdgdsHOCHdsdsgsdgdsgsdsgsdgdsgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOFORMATgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOv SCHERMO IN MdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOODALITR VERTICALE", "BITTE WECHSLE INS HOCHdsdsgsdgdsgdsgdsdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdHOCHdsdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOFORMATsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOFORMAT", "PORdsgsdgdsgsdgdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTO FAVOR, CAMBIA A MODOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTO RETRATO", "PORdsgsdgddsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdgdsgdsgdsgdsgdsgdsgTOsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTOdsgsdgdsgsdgdsgdsgdsgdsgdsgdsgTO FAVOR, MUDA O TEU ECRA PARA O MODO PANOR\u00c2MICO"};

    public AnimationManager() {
        AnimPlayer[] animPlayerArray = new AnimPlayer[16];
        Image[] imageArray = new Image[214];
        short[] sArray = new short[214];
        int n = 0;
        while (n < 16) {
            animPlayerArray[n++] = new AnimPlayer(this);
        }
        n = 0;
        while (n < 214) {
            imageArray[n] = null;
            sArray[n++] = 0;
        }
        this.m_animPlayerPool = animPlayerArray;
        this.m_animImageArray = imageArray;
        this.m_imageLoadCountArray = sArray;
    }

    public boolean loadColorsFile(ResourceManager resourceManager) {
        DataInputStream dataInputStream = new DataInputStream(resourceManager.loadBinaryFile(2));
        this.m_colourData = new byte[ResourceManager.ID_TO_FILESIZE(2)];
        try {
            dataInputStream.read(this.m_colourData);
            dataInputStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public void setColor(Graphics graphics, int n) {
        int n2 = n * 3;
        byte[] byArray = this.m_colourData;
        graphics.setColor(byArray[n2] & 0xFF, byArray[n2 + 1] & 0xFF, byArray[n2 + 2] & 0xFF);
    }

    public boolean loadSubimageFile(ResourceManager resourceManager) {
        try {
            short[][] sArray = new short[326][5];
            DataInputStream dataInputStream = new DataInputStream(resourceManager.loadBinaryFile(4));
            for (int i = 0; i < 326; ++i) {
                short[] sArray2 = sArray[i];
                sArray2[0] = (short)dataInputStream.readUnsignedByte();
                sArray2[1] = dataInputStream.readShort();
                sArray2[2] = dataInputStream.readShort();
                sArray2[3] = dataInputStream.readShort();
                sArray2[4] = dataInputStream.readShort();
            }
            this.m_subImages = sArray;
        }
        catch (IOException iOException) {
            this.m_subImages = null;
            return false;
        }
        return true;
    }

    public boolean loadAnimFile(ResourceManager resourceManager) {
        try {
            short[] sArray = new short[528];
            short[] sArray2 = new short[2852];
            byte[] byArray = new byte[1943];
            short[] sArray3 = new short[5179];
            DataInputStream dataInputStream = new DataInputStream(resourceManager.loadBinaryFile(0));
            int n = 0;
            while (n < sArray.length) {
                sArray[n++] = dataInputStream.readShort();
            }
            n = 0;
            while (n < sArray2.length) {
                sArray2[n++] = dataInputStream.readShort();
            }
            n = 0;
            while (n < byArray.length) {
                byArray[n++] = dataInputStream.readByte();
            }
            n = 0;
            while (n < sArray3.length) {
                sArray3[n++] = dataInputStream.readShort();
            }
            this.m_animData = sArray;
            this.m_frameData = sArray2;
            this.m_primitiveByteData = byArray;
            this.m_primitiveShortData = sArray3;
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    private static final int numBytesInPrimitive(byte by) {
        if (by == 10) {
            return 2;
        }
        if (by == 9) {
            return 3;
        }
        return 1;
    }

    private static final int numShortsInPrimitive(byte by) {
        if (by == 0 || by == 11 || by == 9) {
            return 3;
        }
        if (by == 7) {
            return 2;
        }
        if (by == 10) {
            return 0;
        }
        return 4;
    }

    private static final boolean IS_IN(int n, short[] sArray) {
        for (int i = sArray.length - 1; i >= 0; --i) {
            if (n != sArray[i]) continue;
            return true;
        }
        return false;
    }

    public boolean loadImage(ResourceManager resourceManager, int n) {
        int n2;
        for (n2 = 0; n2 < 214 && n != AnimConstants.IMAGE_RES_IDS[n2]; ++n2) {
        }
        if (214 == n2) {
            return false;
        }
        short[] sArray = this.m_imageLoadCountArray;
        if (sArray[n2] == 0) {
            int n3 = -1;
            if (AnimationManager.IS_IN(n, OPP_BMW)) {
                n3 = 49;
            } else if (AnimationManager.IS_IN(n, OPP_CHEVY)) {
                n3 = 62;
            } else if (AnimationManager.IS_IN(n, OPP_COROLLA)) {
                n3 = 75;
            } else if (AnimationManager.IS_IN(n, OPP_SKYLINE_GTR)) {
                n3 = 123;
            } else if (AnimationManager.IS_IN(n, OPP_MUSTANG)) {
                n3 = 97;
            } else if (AnimationManager.IS_IN(n, OPP_NISSAN350Z)) {
                n3 = 110;
            } else if (AnimationManager.IS_IN(n, OBJECT_ALL_CHEVRON_LEFT_TURN)) {
                n3 = 172;
            } else if (AnimationManager.IS_IN(n, OBJECT_ALL_CHEVRON_RIGHT_TURN)) {
                n3 = 180;
            } else if (AnimationManager.IS_IN(n, OBJECT_BEACH_PALMTREE)) {
                n3 = 188;
            } else if (AnimationManager.IS_IN(n, OBJECT_CANYON_BUSH)) {
                n3 = 196;
            } else if (AnimationManager.IS_IN(n, OBJECT_CANYON_CACTUS)) {
                n3 = 204;
            } else if (AnimationManager.IS_IN(n, OBJECT_CANYON_DEADTREE)) {
                n3 = 212;
            } else if (AnimationManager.IS_IN(n, OBJECT_COUNTRY_TREES)) {
                n3 = 220;
            } else if (AnimationManager.IS_IN(n, OBJECT_COUNTRY_TREE)) {
                n3 = 228;
            }
            if (n3 != -1) {
                int n4 = 65536;
                if (AnimationManager.IS_IN(n, SCALE_SIZE_02)) {
                    n4 = 57344;
                } else if (AnimationManager.IS_IN(n, SCALE_SIZE_03)) {
                    n4 = 49152;
                } else if (AnimationManager.IS_IN(n, SCALE_SIZE_04)) {
                    n4 = 40960;
                } else if (AnimationManager.IS_IN(n, SCALE_SIZE_05)) {
                    n4 = 32768;
                } else if (AnimationManager.IS_IN(n, SCALE_SIZE_06)) {
                    n4 = 24576;
                } else if (AnimationManager.IS_IN(n, SCALE_SIZE_07)) {
                    n4 = 16384;
                } else if (AnimationManager.IS_IN(n, SCALE_SIZE_08)) {
                    n4 = 8192;
                }
                this.m_animImageArray[n2] = resourceManager.loadImageScaled(n3, n4, n4);
            } else {
                switch (n) {
                    default: 
                }
                this.m_animImageArray[n2] = resourceManager.loadImage(n);
            }
            if (this.m_animImageArray[n2] == null) {
                return false;
            }
            System.gc();
            try {
                Thread.sleep(25L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Thread.yield();
        }
        int n5 = n2;
        sArray[n5] = (short)(sArray[n5] + 1);
        return true;
    }

    public boolean unloadImage(ResourceManager resourceManager, int n) {
        int n2;
        for (n2 = 0; n2 < 214 && n != AnimConstants.IMAGE_RES_IDS[n2]; ++n2) {
        }
        if (214 == n2) {
            return false;
        }
        short s = this.m_imageLoadCountArray[n2];
        if (s > 0) {
            if (0 == (s = (short)(s - 1))) {
                this.m_animImageArray[n2] = null;
            }
            this.m_imageLoadCountArray[n2] = s;
        }
        return true;
    }

    public AnimPlayer createAnimPlayer() {
        return new AnimPlayer(this);
    }

    public void drawAnimFrame(Graphics graphics, int n, int n2, int n3, int n4) {
        if (n < 0) {
            return;
        }
        int n5 = graphics.getClipX();
        int n6 = graphics.getClipY();
        int n7 = graphics.getClipWidth();
        int n8 = graphics.getClipHeight();
        boolean bl = false;
        short[] sArray = this.m_frameData;
        int n9 = (this.m_animData[n * 2 + 0] + n2) * 4;
        int n10 = sArray[n9 + 0];
        int n11 = sArray[n9 + 2] & 0xFFFF;
        int n12 = sArray[n9 + 3] & 0xFFFF;
        short[] sArray2 = this.m_primitiveShortData;
        short[][] sArray3 = this.m_subImages;
        Image[] imageArray = this.m_animImageArray;
        byte[] byArray = this.m_primitiveByteData;
        for (int i = 0; i != n10; ++i) {
            byte by = byArray[n11];
            if (by == 0 || by == 11) {
                int n13 = sArray2[n12 + 0] & 0xFFFF;
                int n14 = n3 + sArray2[n12 + 1];
                int n15 = n4 + sArray2[n12 + 2];
                short[] sArray4 = sArray3[n13];
                int n16 = sArray4[0] & 0xFFFF;
                Image image = imageArray[n16];
                if (image != null) {
                    int n17 = by == 0 ? 0 : 2;
                    AnimationManager.drawRegionBB(graphics, image, sArray4[1], sArray4[2], sArray4[3], sArray4[4], n17, n14, n15, 20);
                }
                ++n11;
                n12 += 3;
                continue;
            }
            if (by != 2 && by != 7) {
                this.drawPrimitive(graphics, n3, n4, n11, n12);
                if (by == 1) {
                    bl = true;
                }
            }
            n11 += AnimationManager.numBytesInPrimitive(by);
            n12 += AnimationManager.numShortsInPrimitive(by);
        }
        if (bl) {
            graphics.setClip(n5, n6, n7, n8);
        }
    }

    private final void drawPrimitive(Graphics graphics, int n, int n2, int n3, int n4) {
        byte[] byArray = this.m_primitiveByteData;
        short[] sArray = this.m_primitiveShortData;
        switch (byArray[n3]) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                int n5 = n + sArray[n4];
                int n6 = n2 + sArray[n4 + 1];
                short s = sArray[n4 + 2];
                short s2 = sArray[n4 + 3];
                switch (byArray[n3]) {
                    case 3: {
                        graphics.drawRect(n5, n6, s - 1, s2 - 1);
                        break;
                    }
                    case 4: {
                        graphics.fillRect(n5, n6, (int)s, (int)s2);
                        break;
                    }
                    case 5: {
                        graphics.drawArc(n5, n6, s - 1, s2 - 1, 0, 360);
                        break;
                    }
                    case 6: {
                        graphics.fillArc(n5, n6, (int)s, (int)s2, 0, 360);
                    }
                }
                break;
            }
            case 8: {
                int n7 = n + sArray[n4];
                int n8 = n2 + sArray[n4 + 1];
                int n9 = n + sArray[n4 + 2];
                int n10 = n2 + sArray[n4 + 3];
                graphics.drawLine(n7, n8, n9, n10);
                break;
            }
            case 9: {
                short s = sArray[n4 + 2];
                if (s == -1) break;
                byte by = byArray[n3 + 2];
                int n11 = 0;
                switch (by & 3) {
                    case 0: {
                        n11 = 4;
                        break;
                    }
                    case 1: {
                        n11 = 1;
                        break;
                    }
                    case 2: {
                        n11 = 8;
                    }
                }
                switch (by >> 2 & 3) {
                    case 0: {
                        n11 |= 0x10;
                        break;
                    }
                    case 1: {
                        n11 |= 2;
                        break;
                    }
                    case 2: {
                        n11 |= 0x20;
                    }
                }
                break;
            }
            case 10: {
                byte by = byArray[n3 + 1];
                this.setColor(graphics, by);
                break;
            }
            case 1: {
                int n12 = n + sArray[n4];
                int n13 = n2 + sArray[n4 + 1];
                short s = sArray[n4 + 2];
                short s3 = sArray[n4 + 3];
                graphics.clipRect(n12, n13, (int)s, (int)s3);
            }
        }
    }

    public int animGetNumFrames(int n) {
        int n2 = n * 2;
        return this.m_animData[n2 + 1];
    }

    public short animFrameGetDuration(int n, int n2) {
        int n3 = (this.m_animData[n * 2 + 0] + n2) * 4;
        return this.m_frameData[n3 + 1];
    }

    private int getPrimitiveX(int n, int n2) {
        byte by = this.m_primitiveByteData[n];
        switch (by) {
            case 0: 
            case 11: {
                return this.m_primitiveShortData[n2 + 1];
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                return this.m_primitiveShortData[n2];
            }
            case 8: {
                short s = this.m_primitiveShortData[n2];
                short s2 = this.m_primitiveShortData[n2 + 2];
                return s < s2 ? s : s2;
            }
        }
        return 0;
    }

    private int getPrimitiveY(int n, int n2) {
        byte by = this.m_primitiveByteData[n];
        switch (by) {
            case 0: 
            case 11: {
                return this.m_primitiveShortData[n2 + 2];
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                return this.m_primitiveShortData[n2 + 1];
            }
            case 8: {
                short s = this.m_primitiveShortData[n2 + 1];
                short s2 = this.m_primitiveShortData[n2 + 3];
                return s < s2 ? s : s2;
            }
        }
        return 0;
    }

    private int getPrimitiveWidth(int n, int n2) {
        switch (this.m_primitiveByteData[n]) {
            case 0: 
            case 11: {
                int n3 = this.m_primitiveShortData[n2 + 0];
                return this.m_subImages[n3 &= 0xFFFF][3];
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return this.m_primitiveShortData[n2 + 2];
            }
            case 8: {
                int n4 = this.m_primitiveShortData[n2 + 2] - this.m_primitiveShortData[n2];
                return n4 < 0 ? -n4 : n4;
            }
            case 9: {
                return 0;
            }
        }
        return 0;
    }

    private int getPrimitiveHeight(int n, int n2) {
        switch (this.m_primitiveByteData[n]) {
            case 0: 
            case 11: {
                int n3 = this.m_primitiveShortData[n2 + 0];
                return this.m_subImages[n3 &= 0xFFFF][4];
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return this.m_primitiveShortData[n2 + 3];
            }
            case 8: {
                int n4 = this.m_primitiveShortData[n2 + 3] - this.m_primitiveShortData[n2 + 1];
                return n4 < 0 ? -n4 : n4;
            }
            case 9: {
                return 0;
            }
        }
        return 0;
    }

    public int getAnimFrameX(int n, int n2) {
        int n3 = 99999999;
        int n4 = 0;
        int n5 = (this.m_animData[n * 2 + 0] + n2) * 4;
        int n6 = this.m_frameData[n5 + 0];
        short s = this.m_frameData[n5 + 2];
        short s2 = this.m_frameData[n5 + 3];
        for (int i = 0; i < n6; ++i) {
            byte by = this.m_primitiveByteData[s];
            switch (by) {
                case 10: {
                    break;
                }
                default: {
                    n4 = this.getPrimitiveX(s, s2);
                    if (n4 >= n3) break;
                    n3 = n4;
                }
            }
            s = (short)(s + AnimationManager.numBytesInPrimitive(by));
            s2 = (short)(s2 + AnimationManager.numShortsInPrimitive(by));
        }
        return n3;
    }

    public int getAnimFrameY(int n, int n2) {
        int n3 = 99999999;
        int n4 = 0;
        int n5 = (this.m_animData[n * 2 + 0] + n2) * 4;
        int n6 = this.m_frameData[n5 + 0];
        short s = this.m_frameData[n5 + 2];
        short s2 = this.m_frameData[n5 + 3];
        for (int i = 0; i < n6; ++i) {
            byte by = this.m_primitiveByteData[s];
            switch (by) {
                case 10: {
                    break;
                }
                default: {
                    n4 = this.getPrimitiveY(s, s2);
                    if (n4 >= n3) break;
                    n3 = n4;
                }
            }
            s = (short)(s + AnimationManager.numBytesInPrimitive(by));
            s2 = (short)(s2 + AnimationManager.numShortsInPrimitive(by));
        }
        return n3;
    }

    public int getAnimFrameWidth(int n, int n2) {
        int n3 = 99999999;
        int n4 = -99999999;
        int n5 = 0;
        int n6 = 0;
        int n7 = (this.m_animData[n * 2 + 0] + n2) * 4;
        int n8 = this.m_frameData[n7 + 0];
        short s = this.m_frameData[n7 + 2];
        short s2 = this.m_frameData[n7 + 3];
        for (int i = 0; i < n8; ++i) {
            byte by = this.m_primitiveByteData[s];
            switch (by) {
                case 10: {
                    break;
                }
                default: {
                    n5 = this.getPrimitiveX(s, s2);
                    n6 = n5 + this.getPrimitiveWidth(s, s2);
                    if (n5 < n3) {
                        n3 = n5;
                    }
                    if (n6 <= n4) break;
                    n4 = n6;
                }
            }
            s = (short)(s + AnimationManager.numBytesInPrimitive(by));
            s2 = (short)(s2 + AnimationManager.numShortsInPrimitive(by));
        }
        return (short)(n4 - n3);
    }

    public int getAnimFrameHeight(int n, int n2) {
        int n3 = 99999999;
        int n4 = -99999999;
        int n5 = 0;
        int n6 = 0;
        int n7 = (this.m_animData[n * 2 + 0] + n2) * 4;
        int n8 = this.m_frameData[n7 + 0];
        short s = this.m_frameData[n7 + 2];
        short s2 = this.m_frameData[n7 + 3];
        for (int i = 0; i < n8; ++i) {
            byte by = this.m_primitiveByteData[s];
            switch (by) {
                case 10: {
                    break;
                }
                default: {
                    n5 = this.getPrimitiveY(s, s2);
                    n6 = n5 + this.getPrimitiveHeight(s, s2);
                    if (n5 < n3) {
                        n3 = n5;
                    }
                    if (n6 <= n4) break;
                    n4 = n6;
                }
            }
            s = (short)(s + AnimationManager.numBytesInPrimitive(by));
            s2 = (short)(s2 + AnimationManager.numShortsInPrimitive(by));
        }
        return (short)(n4 - n3);
    }

    public int getAnimFrameFirePointCount(int n, int n2) {
        int n3 = n * 2;
        int n4 = (this.m_animData[n3 + 0] + n2) * 4;
        int n5 = this.m_frameData[n4 + 0];
        int n6 = this.m_frameData[n4 + 2];
        int n7 = this.m_frameData[n4 + 3];
        int n8 = 0;
        for (int i = 0; i < n5; ++i) {
            byte by = this.m_primitiveByteData[n6];
            if (by == 7) {
                ++n8;
            }
            n6 += AnimationManager.numBytesInPrimitive(by);
            n7 += AnimationManager.numShortsInPrimitive(by);
        }
        return n8;
    }

    public int getAnimFrameFirePointX(int n, int n2, int n3) {
        short[] sArray = this.m_frameData;
        byte[] byArray = this.m_primitiveByteData;
        int n4 = n * 2;
        int n5 = (this.m_animData[n4 + 0] + n2) * 4;
        int n6 = sArray[n5 + 0];
        int n7 = sArray[n5 + 2];
        int n8 = sArray[n5 + 3];
        int n9 = 0;
        for (int i = 0; i < n6; ++i) {
            byte by = byArray[n7];
            if (by == 7) {
                if (n9 == n3) {
                    return this.getPrimitiveX(n7, n8);
                }
                ++n9;
            }
            n7 += AnimationManager.numBytesInPrimitive(by);
            n8 += AnimationManager.numShortsInPrimitive(by);
        }
        return 0;
    }

    public int getAnimFrameFirePointY(int n, int n2, int n3) {
        short[] sArray = this.m_frameData;
        byte[] byArray = this.m_primitiveByteData;
        int n4 = n * 2;
        int n5 = (this.m_animData[n4 + 0] + n2) * 4;
        int n6 = sArray[n5 + 0];
        int n7 = sArray[n5 + 2];
        int n8 = sArray[n5 + 3];
        int n9 = 0;
        for (int i = 0; i < n6; ++i) {
            byte by = byArray[n7];
            if (by == 7) {
                if (n9 == n3) {
                    return this.getPrimitiveY(n7, n8);
                }
                ++n9;
            }
            n7 += AnimationManager.numBytesInPrimitive(by);
            n8 += AnimationManager.numShortsInPrimitive(by);
        }
        return 0;
    }

    public Image getImage(int n) {
        if (n < 0 || n >= 214) {
            return null;
        }
        return this.m_animImageArray[n];
    }

    public boolean startAnimReverse(short s, boolean bl, boolean bl2) {
        AnimPlayer animPlayer;
        AnimPlayer[] animPlayerArray = this.m_animPlayerPool;
        int n = 0;
        while ((animPlayer = animPlayerArray[n++]).isAnimating()) {
            if (animPlayer.getAnimID() == s) {
                return true;
            }
            if (n < 16) continue;
        }
        if (n == 16) {
            return false;
        }
        animPlayer.startAnim(s, bl, bl2);
        animPlayer.setReverse(true);
        return true;
    }

    public boolean startAnim(int n, boolean bl, boolean bl2) {
        AnimPlayer animPlayer;
        AnimPlayer[] animPlayerArray = this.m_animPlayerPool;
        int n2 = 0;
        while ((animPlayer = animPlayerArray[n2++]).isAnimating()) {
            if (animPlayer.getAnimID() == n) {
                return true;
            }
            if (n2 < 16) continue;
        }
        if (n2 == 16) {
            return false;
        }
        animPlayer.startAnim(n, bl, bl2);
        animPlayer.setReverse(false);
        return true;
    }

    public void updateAnims(int n) {
        AnimPlayer[] animPlayerArray = this.m_animPlayerPool;
        int n2 = 16;
        do {
            animPlayerArray[--n2].updateAnim(n);
        } while (n2 != 0);
    }

    public boolean drawAnim(Graphics graphics, int n, int n2, int n3) {
        AnimPlayer[] animPlayerArray = this.m_animPlayerPool;
        int n4 = 16;
        do {
            AnimPlayer animPlayer;
            if ((animPlayer = animPlayerArray[--n4]).getAnimID() != n) continue;
            this.drawAnimFrame(graphics, n, animPlayer.getCurrAnimFrame(), n2, n3);
            return true;
        } while (n4 != 0);
        return false;
    }

    public void drawAnim(Graphics graphics, AnimPlayer animPlayer, int n, int n2) {
        this.drawAnimFrame(graphics, animPlayer.getAnimID(), animPlayer.getCurrAnimFrame(), n, n2);
    }

    public void stopAnim(int n) {
        AnimPlayer[] animPlayerArray = this.m_animPlayerPool;
        int n2 = 16;
        do {
            AnimPlayer animPlayer;
            if ((animPlayer = animPlayerArray[--n2]).getAnimID() != n) continue;
            animPlayer.setAnimating(false);
        } while (n2 != 0);
    }

    public void stopAllAnims() {
        AnimPlayer[] animPlayerArray = this.m_animPlayerPool;
        int n = 16;
        do {
            animPlayerArray[--n].setAnimating(false);
        } while (n != 0);
    }

    public int getColor(int n) {
        int n2 = n * 3;
        byte[] byArray = this.m_colourData;
        int n3 = (byArray[n2] & 0xFF) << 16;
        int n4 = (byArray[n2 + 1] & 0xFF) << 8;
        int n5 = byArray[n2 + 2] & 0xFF;
        return 0xFF000000 | n3 | n4 | n5;
    }

    public void drawScaledPrimitives(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2) {
        int n7 = (this.m_animData[n * 2 + 0] + n2) * 4;
        int n8 = this.m_frameData[n7 + 0];
        short s = this.m_frameData[n7 + 2];
        short s2 = this.m_frameData[n7 + 3];
        short[] sArray = this.m_primitiveShortData;
        byte[] byArray = this.m_primitiveByteData;
        for (int i = 0; i < n8; ++i) {
            int n9 = MathExt.Fmul(sArray[s2] << 16, n5) + 65535 >> 16;
            int n10 = MathExt.Fmul(sArray[s2 + 1] << 16, n6) + 65535 >> 16;
            int n11 = MathExt.Fmul(sArray[s2 + 2] << 16, n5) + 65535 >> 16;
            int n12 = MathExt.Fmul(sArray[s2 + 3] << 16, n6) + 65535 >> 16;
            byte by = byArray[s];
            if (bl) {
                if (by == 8) {
                    n9 = -n9;
                    n11 = -n11;
                } else {
                    n9 = -n9 - n11;
                }
            }
            if (bl2) {
                if (by == 8) {
                    n10 = -n10;
                    n12 = -n12;
                } else {
                    n10 = -n10 - n12;
                }
            }
            switch (by) {
                case 4: {
                    graphics.fillRect(n3 + n9, n4 + n10, n11, n12);
                    break;
                }
                case 8: {
                    graphics.drawLine(n3 + n9, n4 + n10, n3 + n11, n4 + n12);
                    break;
                }
                case 3: {
                    graphics.drawRect(n3 + n9, n4 + n10, n11, n12);
                    break;
                }
                case 6: {
                    graphics.fillArc(n3 + n9, n4 + n10, n11, n12, 0, 360);
                    break;
                }
                case 5: {
                    graphics.drawArc(n3 + n9, n4 + n10, n11, n12, 0, 360);
                    break;
                }
                case 10: {
                    byte by2 = this.m_primitiveByteData[s + 1];
                    graphics.setColor(this.getColor(by2));
                    break;
                }
            }
            s = (short)(s + AnimationManager.numBytesInPrimitive(by));
            s2 = (short)(s2 + AnimationManager.numShortsInPrimitive(by));
        }
    }

    public boolean isImageLoaded(int n) {
        int n2;
        for (n2 = 0; n2 < 214 && n != AnimConstants.IMAGE_RES_IDS[n2]; ++n2) {
        }
        if (214 == n2) {
            return false;
        }
        return this.m_imageLoadCountArray[n2] != 0;
    }

    public static void drawRegionBB(Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (n5 == 0) {
            int n9 = graphics.getClipX();
            int n10 = graphics.getClipY();
            int n11 = graphics.getClipWidth();
            int n12 = graphics.getClipHeight();
            int n13 = n6 + (n9 > n6 ? n9 - n6 : 0);
            int n14 = n7 + (n10 > n7 ? n10 - n7 : 0);
            graphics.setClip(n13, n14, Math.min(n6 + n3, n11 + n9) - n13, Math.min(n7 + n4, n12 + n10) - n14);
            graphics.drawImage(image, n6 - n, n7 - n2, n8);
            graphics.setClip(n9, n10, n11, n12);
        } else {
            graphics.drawRegion(image, n, n2, n3, n4, n5, n6, n7, n8);
        }
    }
}

