/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.BaseObject;
import game.SceneGame;
import generic.MathExt;

public class GameObject
extends BaseObject {
    public static final int AI_MOOD_NORMAL = 0;
    public static final int AI_MOOD_AGGRESSIVE = 1;
    public static final int AI_MOOD_SOFT = 2;
    private static final int DEFAULT_MAX_BOOST_TIME = 196608;
    private static final int DEFAULT_BOOST_SPEED_MULTIPLIER = 91750;
    private static final int DEFAULT_BOOST_ACCEL_MULTIPLIER = 229376;
    private static final int DEFAULT_GEARCHANGE_ACCEL_EASE_TIME = 39322;
    private static final int DEFAULT_BRAKING = 0xA00000;
    private static final int DEFAULT_BRAKING_OFFTRACK = 0x960000;
    private static final int DEFAULT_POST_BOOST_SLOWING = 0x780000;
    public static final int GEARCHANGE_DELAY_TIME = 16384;
    public int m_numLapsCompleted = -1;
    public int m_currentLapTime;
    public int m_cumulativeLapTimes;
    public boolean m_finishedRace = false;
    public int m_currSection = 0;
    public int m_nextSection = 1;
    public int m_lateralPosTargetF = 0;
    public int m_lateralPosSpeedF = 0;
    public int m_lateralPosAccelF = 65536;
    public int m_lateralPosSpeedMaxF = 65536;
    public int m_speedF = 0;
    public int m_accelerationF;
    public int m_speedMulF = 0;
    public int m_accelMulF = 0;
    public int m_AITimeF = 0;
    public int m_AILimitF = 131072;
    public int m_ID = 0;
    public int m_mood = 0;
    public byte m_currentGear;
    public byte m_numGears = 1;
    public int[] m_gearAccels;
    public int[] m_gearMinSpeeds;
    public int[] m_gearMaxSpeeds;
    public boolean m_isAutoTransmission;
    public boolean m_isAccelerating;
    public boolean m_isBraking;
    public boolean m_isOffTrackBraking;
    public int m_difficultyMult = 65536;
    public int m_catchupCodeMultTargetF = 65536;
    public int m_catchupCodeMultCurrF = 65536;
    public int m_lastCornerWarningSection = -1;
    public boolean m_showingSlowdownEffects;
    public SceneGame m_sceneGame;
    public int m_brakingForce = 0xA00000;
    public int m_offTrackBrakingForce = 0x960000;
    private boolean m_isBoosting;
    private int m_boostTimeF = 196608;
    private int m_gearChangeAccelEaseTimeF = 39322;
    private int m_timeSinceGearChangeSecsF;
    private int m_curGearMinSpeedF;
    private int m_curGearMaxSpeedF;
    private int m_maxSpeedRangeMultiplierF;
    private int m_racePosition;
    private int m_gearChangeDelayTimerSecsF;
    private byte m_maximumAllowedGear;
    public int m_opponentAnimIDIndex;

    public GameObject() {
    }

    public GameObject(SceneGame sceneGame) {
        this();
        this.m_sceneGame = sceneGame;
    }

    public GameObject(int n, int n2, int n3, int n4) {
        this();
        this.setType(n);
        this.m_trackPosF = n2;
        this.m_currSection = n3;
        this.m_lateralPosF = n4;
    }

    public boolean updateSpeed(int n) {
        this.updateBoost(n);
        this.updateAcceleration(n);
        this.updateBraking(n);
        return this.updateTransmission(n);
    }

    public int getSpeedFactor() {
        return MathExt.Fmul(this.m_speedF, this.m_maxSpeedRangeMultiplierF);
    }

    public int getSpeedFactor(int n) {
        return MathExt.Fmul(n, this.m_maxSpeedRangeMultiplierF);
    }

    private void updateAcceleration(int n) {
        int n2 = 0;
        int n3 = 0;
        if (this.m_isBoosting) {
            n2 = MathExt.Fmul(this.m_accelerationF, 229376);
            n3 = MathExt.Fmul(this.m_curGearMaxSpeedF, 91750);
        } else if (this.m_isAccelerating) {
            n2 = this.m_accelerationF;
            n3 = this.m_curGearMaxSpeedF;
        }
        if (n2 > 0 && this.m_speedF < n3) {
            if (this.m_currentGear > 0 && this.m_timeSinceGearChangeSecsF < this.m_gearChangeAccelEaseTimeF) {
                int n4 = MathExt.smoothstepF(0, this.m_gearChangeAccelEaseTimeF, this.m_timeSinceGearChangeSecsF);
                n2 = MathExt.Fmul(n2, n4);
            }
            this.m_speedF += MathExt.Fmul(n2, n);
            if (this.m_speedF > n3) {
                this.m_speedF = n3;
            }
        }
    }

    private void updateBraking(int n) {
        if (this.m_isBraking) {
            this.m_speedF -= MathExt.Fmul(this.m_brakingForce, n);
            if (this.m_speedF < 0) {
                this.m_speedF = 0;
            }
        } else if (this.m_isOffTrackBraking) {
            this.m_speedF -= MathExt.Fmul(this.m_offTrackBrakingForce, n);
            if (this.m_speedF < 0) {
                this.m_speedF = 0;
            }
        }
    }

    public boolean isBoosting() {
        return this.m_isBoosting;
    }

    public void setBoosting(boolean bl) {
        if (bl && this.m_boostTimeF > 0) {
            this.turnBoostOn();
        } else {
            this.turnBoostOff();
        }
    }

    public int getBoostTimeRemaining() {
        return this.m_boostTimeF;
    }

    public int getBoostTime() {
        return 196608 - this.m_boostTimeF;
    }

    private void updateBoost(int n) {
    }

    private void turnBoostOn() {
        this.m_isBoosting = true;
    }

    private void turnBoostOff() {
        this.m_boostTimeF = 196608;
        this.m_isBoosting = false;
    }

    public int getGearChangeAccelEaseTime() {
        return this.m_gearChangeAccelEaseTimeF;
    }

    public void setGearChangeAccelEaseTime(int n) {
        this.m_gearChangeAccelEaseTimeF = n;
    }

    public int getGearAccel(int n) {
        return this.m_gearAccels[n];
    }

    public int getGearMinSpeed(int n) {
        return this.m_gearMinSpeeds[n];
    }

    public int getGearMaxSpeed(int n) {
        return this.m_gearMaxSpeeds[n];
    }

    public void setGearAccel(int n, int n2) {
        this.m_gearAccels[n] = n2;
    }

    public void setGearMinSpeed(int n, int n2) {
        this.m_gearMinSpeeds[n] = n2;
    }

    public void setGearMaxSpeed(int n, int n2) {
        this.m_gearMaxSpeeds[n] = n2;
    }

    public int getCurGearMinSpeed() {
        return this.m_curGearMinSpeedF;
    }

    public void setCurGearMinSpeed(int n) {
        this.m_curGearMinSpeedF = n;
    }

    public int getCurGearMaxSpeed() {
        return this.m_curGearMaxSpeedF;
    }

    public void setCurGearMaxSpeed(int n) {
        this.m_curGearMaxSpeedF = n;
        if (n > 0 && this.m_currentGear == this.m_numGears - 1) {
            this.m_maxSpeedRangeMultiplierF = MathExt.Fdiv(65536, n);
        } else if (this.m_currentGear == this.m_numGears - 1) {
            this.m_maxSpeedRangeMultiplierF = 0;
        }
    }

    public int getTopGearMaxSpeed() {
        return this.m_gearMaxSpeeds[this.m_numGears - 1];
    }

    public int getMaxBoostSpeed() {
        return MathExt.Fmul(this.getTopGearMaxSpeed(), 91750);
    }

    public void setNumGears(byte by) {
        this.m_numGears = by;
        this.m_maximumAllowedGear = (byte)(this.m_numGears - 1);
    }

    public byte getNumGears() {
        return this.m_numGears;
    }

    public void setGearAccelData(int[] nArray) {
        this.m_gearAccels = new int[nArray.length];
        for (int i = 0; i < this.m_gearAccels.length; ++i) {
            this.m_gearAccels[i] = nArray[i];
        }
        this.m_accelerationF = this.m_gearAccels[this.m_currentGear];
    }

    public void setGearMinSpeedData(int[] nArray) {
        this.m_gearMinSpeeds = new int[nArray.length];
        for (int i = 0; i < this.m_gearMinSpeeds.length; ++i) {
            this.m_gearMinSpeeds[i] = nArray[i];
        }
        this.m_curGearMinSpeedF = this.m_gearMinSpeeds[this.m_currentGear];
    }

    public void setGearMaxSpeedData(int[] nArray) {
        this.m_gearMaxSpeeds = new int[nArray.length];
        for (int i = 0; i < this.m_gearMaxSpeeds.length; ++i) {
            this.m_gearMaxSpeeds[i] = nArray[i];
        }
        this.m_curGearMaxSpeedF = this.m_gearMaxSpeeds[this.m_currentGear];
        this.m_maxSpeedRangeMultiplierF = MathExt.Fdiv(65536, this.getTopGearMaxSpeed());
    }

    private boolean updateTransmission(int n) {
        boolean bl = false;
        if (this.m_isAutoTransmission && this.m_speedF >= this.m_curGearMaxSpeedF && this.m_currentGear < this.m_maximumAllowedGear) {
            if (this.m_ID == 999 || this.m_gearChangeDelayTimerSecsF >= 16384) {
                this.incrementGear();
                this.m_gearChangeDelayTimerSecsF = 0;
                bl = true;
            } else if (this.m_ID != 999) {
                this.m_gearChangeDelayTimerSecsF += n;
            }
        } else if (this.m_isAutoTransmission && this.m_speedF < this.m_curGearMinSpeedF && this.m_currentGear > 0) {
            this.decrementGear();
            if (this.m_ID != 999) {
                this.m_gearChangeDelayTimerSecsF = 0;
            }
            bl = true;
        } else if (this.m_ID != 999 && this.m_gearChangeDelayTimerSecsF != 0) {
            this.m_gearChangeDelayTimerSecsF = 0;
        } else {
            this.m_timeSinceGearChangeSecsF += n;
        }
        if (!this.m_isBoosting && this.m_speedF > this.m_curGearMaxSpeedF && !this.m_isBoosting) {
            this.m_speedF -= MathExt.Fmul(0x780000, n);
        }
        return bl;
    }

    public void incrementGear() {
        if (this.m_currentGear < this.m_numGears - 1) {
            this.setCurrentGear((byte)(this.m_currentGear + 1));
            if (this.getType() == 1) {
                this.m_sceneGame.startBackfireEffect();
            }
        }
    }

    public void decrementGear() {
        if (this.m_currentGear > 0) {
            this.setCurrentGear((byte)(this.m_currentGear - 1));
            if (this.getType() == 1) {
                this.m_sceneGame.startBrakingEffect();
            }
        }
    }

    public void setCurrentGear(byte by) {
        this.m_currentGear = by;
        this.m_curGearMinSpeedF = MathExt.Fmul(this.m_gearMinSpeeds[this.m_currentGear], this.m_difficultyMult);
        this.m_curGearMaxSpeedF = MathExt.Fmul(this.m_gearMaxSpeeds[this.m_currentGear], this.m_difficultyMult);
        this.m_accelerationF = MathExt.Fmul(this.m_gearAccels[this.m_currentGear], this.m_difficultyMult);
        this.m_timeSinceGearChangeSecsF = 0;
    }

    public byte getCurrentGear() {
        return this.m_currentGear;
    }

    public void setMaximumAllowedGear() {
        this.setMaximumAllowedGear((byte)(this.m_numGears - 1));
    }

    public void setMaximumAllowedGear(byte by) {
        this.m_maximumAllowedGear = by;
        if (this.m_maximumAllowedGear < this.m_currentGear) {
            this.setCurrentGear(this.m_maximumAllowedGear);
        }
    }

    public byte getMaximumAllowedGear() {
        return this.m_maximumAllowedGear;
    }

    public boolean isMaximumGearAllowed() {
        return this.m_maximumAllowedGear == this.m_numGears - 1;
    }

    public void debugPrint() {
    }

    public int getRacePos() {
        return this.m_racePosition;
    }

    public void setRacePos(int n) {
        this.m_racePosition = n;
    }

    public void updateCatchupCode(int n) {
        if (this.m_catchupCodeMultCurrF < this.m_catchupCodeMultTargetF) {
            this.m_catchupCodeMultCurrF += MathExt.Fmul(655, n);
            if (this.m_catchupCodeMultCurrF > this.m_catchupCodeMultTargetF) {
                this.m_catchupCodeMultCurrF = this.m_catchupCodeMultTargetF;
            }
        } else if (this.m_catchupCodeMultCurrF > this.m_catchupCodeMultTargetF) {
            this.m_catchupCodeMultCurrF -= MathExt.Fmul(655, n);
            if (this.m_catchupCodeMultCurrF < this.m_catchupCodeMultTargetF) {
                this.m_catchupCodeMultCurrF = this.m_catchupCodeMultTargetF;
            }
        }
    }
}

