/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.AppEngine;
import game.BaseObject;
import game.GameObject;
import game.Scene;
import generic.AnimPlayer;
import generic.AnimationManager;
import generic.LoadingListener;
import generic.MathExt;
import generic.MixedFont;
import generic.ResourceManager;
import generic.SoundManager;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

final class SceneGame
extends Scene
implements LoadingListener {
    private int tempIdealGear = 0;
    private int tempPos = 0;
    private int tempEndDist = 0;
    private int tempSpeed = 0;
    private int tempDrift = 0;
    private static final int NUM_OPPONENT_CAR_TYPES_PER_RACE = 5;
    public static final int MAX_STATIC_OBJECTS_PER_SECTION = 8;
    private static final int TRACK_LENGTH_MULTIPLIER = 1;
    private static final int SLOPE_ARRAY_ENTRIES_MAX = 16;
    private static final int INTERP_LENGTH = 300;
    private static final int DEFAULT_ACCELERATION = 0x500000;
    public static final int ROAD_HEIGHT_VIEWPORT = 83;
    public static final int ROAD_BEND_SHIFT_DOWN = 4;
    public static final int CAM_SHIFT_DOWN = 5;
    public static final int SPEED_INC = 0x280000;
    public static final int SPEED_MAX = 0x1900000;
    public static final int SPEED_OFFTRACK = 0x640000;
    public static final int DEFAULT_BRAKING = 0xA00000;
    public static final int DEFAULT_POST_BOOST_SLOWING = 0x780000;
    public static final int NUM_CAR_ANGLES = 9;
    public static final int AI_LATERAL_POS_STEER_THRESHOLD = 32768;
    public static final int AI_DISTANCE_STEER_THRESHOLD = 0xC80000;
    public static final int AI_DISTANCE_STEER_THRESHOLD_MIN = 0x430000;
    private static final int AI_RECENTRE_RATE = 327680;
    public static final int AI_KICK_IN_DELAY_MIN = 3;
    public static final int AI_KICK_IN_DELAY_MAX = 12;
    public static final int AI_CATCHUP_MULT_MIN = 60948;
    public static final int AI_CATCHUP_MULT_MAX = 72089;
    public static final int AI_RACE_START_BOOST = 86508;
    public static final int CAR_COLLISION_LENGTH_LEFT_04 = 458752;
    public static final int CAR_COLLISION_LENGTH_LEFT_03 = 458752;
    public static final int CAR_COLLISION_LENGTH_LEFT_02 = 458752;
    public static final int CAR_COLLISION_LENGTH_LEFT_01 = 458752;
    public static final int CAR_COLLISION_LENGTH_STRAIGHT = 458752;
    public static final int CAR_COLLISION_LENGTH_RIGHT_01 = 458752;
    public static final int CAR_COLLISION_LENGTH_RIGHT_02 = 458752;
    public static final int CAR_COLLISION_LENGTH_RIGHT_03 = 458752;
    public static final int CAR_COLLISION_LENGTH_RIGHT_04 = 458752;
    public static final int CAR_COLLISION_WIDTH_LEFT_04 = 9830;
    public static final int CAR_COLLISION_WIDTH_LEFT_03 = 9830;
    public static final int CAR_COLLISION_WIDTH_LEFT_02 = 9830;
    public static final int CAR_COLLISION_WIDTH_LEFT_01 = 9830;
    public static final int CAR_COLLISION_WIDTH_STRAIGHT = 9830;
    public static final int CAR_COLLISION_WIDTH_RIGHT_01 = 9830;
    public static final int CAR_COLLISION_WIDTH_RIGHT_02 = 9830;
    public static final int CAR_COLLISION_WIDTH_RIGHT_03 = 9830;
    public static final int CAR_COLLISION_WIDTH_RIGHT_04 = 9830;
    public static final int CAR_COLLISION_SPARK_OFFSET_FRONT_Y = -12;
    public static final int CAR_COLLISION_SPARK_OFFSET_BACK_Y = -12;
    public static final int VIEW_DISTANCE = 400;
    public static final int VIEW_LOD1 = 175;
    public static final int VIEW_LOD2 = 150;
    public static final int VIEW_LOD3 = 125;
    public static final int VIEW_LOD4 = 100;
    public static final int VIEW_LOD5 = 75;
    public static final int VIEW_OPPONENT_CAR_LOD1 = 340;
    public static final int VIEW_OPPONENT_CAR_LOD2 = 189;
    public static final int VIEW_OPPONENT_CAR_LOD3 = 105;
    public static final int VIEW_OPPONENT_CAR_LOD4 = 58;
    public static final int VIEW_OPPONENT_CAR_LOD5 = 32;
    public static final int VIEW_OPPONENT_CAR_LOD6 = 18;
    public static final int VIEW_OPPONENT_CAR_LOD7 = 10;
    public static final int VIEW_TREE_LOD1 = 340;
    public static final int VIEW_TREE_LOD2 = 290;
    public static final int VIEW_TREE_LOD3 = 240;
    public static final int VIEW_TREE_LOD4 = 190;
    public static final int VIEW_TREE_LOD5 = 140;
    public static final int VIEW_TREE_LOD6 = 90;
    public static final int VIEW_TREE_LOD7 = 40;
    public static final int LATERAL_POS_MAX = 91750;
    public static final int LATERAL_POS_MIN = -91750;
    public static final int LATERAL_POS_AI_MAX = 65536;
    public static final int LATERAL_POS_AI_MIN = -65536;
    public static final int NO_STEERING_SPEED_LOW = -524288;
    public static final int NO_STEERING_SPEED_HIGH = 0x1E0000;
    private static int VIEWPORT_LEFT;
    private static int VIEWPORT_TOP;
    private static int VIEWPORT_WIDTH;
    private static int VIEWPORT_HEIGHT;
    private static int VIEWPORT_CENTRE_X;
    private static int VIEWPORT_CENTRE_Y;
    private AppEngine m_engine = AppEngine.getCanvas();
    private boolean m_endScene = false;
    public static final int DEFAULT_STEERING_INC = 102944;
    public static final int DEFAULT_STEERING_MAX_BEND = 64340;
    public static final int DEFAULT_STEERING_MAX_STRAIGHT = 12868;
    public static final int DEFAULT_STEERING_RECENTRE_INC = 102944;
    public static final int DRIFT_SPEED_PENALTY_MULT = 873800;
    public static final int DEFAULT_LATERAL_STEER_MAX = 131072;
    public static final int DEFAULT_LATERAL_DRIFT_MAX = 163840;
    public static final int PERSPECTIVE_DIVIDE = 60293;
    public static final int HORIZON_OFFSET_INC = 4;
    public static final int HORIZON_OFFSET_MIN = 0;
    public static final int HORIZON_OFFSET_MAX = 64;
    public static final int TRACK_SCALE_MULF = 32768;
    public static final int TRACK_CURVE_INC_F = 3277;
    public static final int TRACK_CURVE_MIN_F = 0;
    public static final int TRACK_CURVE_MAX_F = 65536;
    public static final int TRACK_CURVE_WARNING_DISTANCE = 800;
    public static final int AI_HARD_CURVE_WARNING_DISTANCE = 640;
    public static final int AI_NORM_CURVE_WARNING_DISTANCE = 747;
    public static final int AI_SOFT_CURVE_WARNING_DISTANCE = 853;
    private static final int RACE_COMPLETE_DELAYTIME = 131072;
    private static final int LAPTIME_DISPLAY_DURATION = 262144;
    public static final int GC_SLEEP_TIME = 20;
    private static final int BOOST_TAKEOFF_DELAY = 5000;
    private static final int BOOST_GAUGE_MAX = 0x640000;
    private static final int BOOST_DEPLETE_RATE = 1200000;
    private static final int BOOST_RESTORE_RATE = 37500;
    private static final int BOOST_REUSE_DELAY = 0;
    private static final int BOOST_TIMER_MULT = 8;
    private static final int BOOST_DRIFT_MULT = 4368;
    private static final int BOOST_MIN_USABLE_AMOUNT = 0x190000;
    private static final int BOOST_MULTIPLIER_ACCELERATION = 131072;
    private static final int BOOST_MULTIPLIER_MAX_SPEED = 114688;
    private static final int BOOST_PERFECTDRIFT_BONUS = 0x190000;
    private static final int BOOST_STYLISHDRIFT_BONUS = 983040;
    private static final int BOOST_NOTBADDRIFT_BONUS = 327680;
    private static final int BOOST_AVERAGEDRIFT_BONUS = 131072;
    private static final int DEFAULT_MAX_BOOST_TIME = 196608;
    private static final int NUM_GEARS = 6;
    private static int HUD_HEIGHT;
    private static int HUD_POSITION_X;
    private static int HUD_POSITION_Y;
    private static int TRACK_VIEWPORT_HEIGHT;
    private static int HUD_GEAR_POSITION_Y;
    private static int HUD_GEAR_CLEAR_POSITION_Y;
    private static int HUD_GEAR_WIDTH;
    private static int HUD_GEAR_HEIGHT;
    private static int HUD_GEAR_NUMBER_XOFFSET;
    private static final int HUD_POS_POSITION_X = 1;
    private static int HUD_LAP_POSITION_X;
    private static final int HUD_LAP_POS_POSITION_Y = 10;
    private static int HUD_GEAR_POSITION_X;
    private static int HUD_SPEED_POSITION_X;
    private static int HUD_SPEED_UNIT_POSITION_X;
    private static int HUD_BOOST_POSITION_X;
    private static int HUD_DRIFT_POSITION_Y;
    private static int HUD_NEEDLE_ORIGIN_X;
    private static int HUD_SPEED_POSITION_Y;
    private static int HUD_SPEED_WIDTH;
    private static int HUD_SPEED_HEIGHT;
    private static int HUD_SPEED_UNIT_POSITION_Y;
    private static int HUD_BOOST_POSITION_YOFFSET;
    private static int HUD_DRIFT_POSITION_X;
    private static int HUD_DRIFTINDICATOR_YPOS;
    private static final int HUD_DRIFTINDICATOR_HEIGHT = 10;
    private static int HUD_NEEDLE_ORIGIN_Y;
    private static int HUD_NEEDLE_LENGTH_F;
    private static int HUD_NEEDLE_WIDTH_F;
    private static int HUD_NEEDLE_MIN_ANGLE_F;
    private static int HUD_NEEDLE_TOTAL_ANGLE_F;
    private static int HUD_NEEDLE_CLIP_Y;
    private static int HUD_PREV_TIME_OFFSET_X;
    private static int HUD_PREV_NEXT_TIME_OFFSET_Y;
    private static int HUD_NEXT_TIME_OFFSET_X;
    private static int HUD_PREV_NEXT_TIME_WIDTH;
    private static int HUD_PREV_NEXT_TIME_HEIGHT;
    private static int HUD_TACHO_POSITION_X;
    private static int HUD_TACHO_POSITION_Y;
    private static int HUD_WINGEDBOX_INFO_WIDTH;
    private static final int TOP_HUD_BAR_HEIGHT = 16;
    private static final int INTRO_CAMANIM_STAGE_TIME = 1500;
    private static final int INTRO_CAMERA_MOVE_TIME = 2000;
    private static final int INTRO_TRACK_HEIGHT_OFFSET = 62;
    private static final int HUD_WARNING_GAP = 4;
    private static final int AI_DIFFICULTY_MIN_F = 52250;
    private static final int AI_DIFFICULTY_MAX_F = 64749;
    private static final int DRIFT_FORCE_MAX = 65536;
    private static final int DRIFT_FORCE_MIN = 0;
    private static final int STEERING_SPEED_FACTOR_MULT = 32768;
    public static final int LATERAL_DRIFT_CATCHUP_RATE = 8192;
    public static final int DRIFT_ANGLE_CATCHUP_RATE = 8096;
    public static final int LATERAL_DRIFT_NO_STEER_MULT = 58982;
    private static final int OUTSIDE_TURN_SPEED_MULT = 39322;
    private static final int INSIDE_TURN_SPEED_MULT = 91750;
    private static final int LATDRIFT_EXTRA_TRACK_WIDTH = 13107;
    private static final int LATDRIFT_EXTRA_WIDE_TRACK = 78643;
    private static final int LATDRIFT_EXTRA_WIDE_TRACK_INV = 54613;
    private static final int DRIFT_RATING_DISPLAY_TIME = 131072;
    private static final int DRIFT_MINIGAME_MIN_SPEED = 0x500000;
    private static final int SLIPSTREAM_MAX_DIST_BEHIND = 0xC80000;
    private static final int SLIPSTREAM_MAX_LATERAL_DIST = 21823;
    private static final int SLIPSTREAM_START_DELAY = 65536;
    private static final int SLIPSTREAM_SPEED_BONUS_MAX = 9830;
    private static final int SLIPSTREAM_MULT_INCREASE_RATE = 6554;
    private static final int DRIFT_MINIGAME_NEEDLE_SPEEDMULT = 65536;
    private static final int DRIFT_MINIGAME_NEEDLE_MINSPEED = 32768;
    private static final int DRIFT_MINIGAME_INPUT_SPEEDMULT = 49152;
    private static final int DRIFT_MINIGAME_INPUT_MINSPEED = 65536;
    private static final int DRIFT_MINIGAME_FALLOFF_INFLUENCE = 29491;
    private static final int DRIFT_MINI_GAME_LEFTCORNER_DOTPOS = 21845;
    private static final int DRIFT_MINI_GAME_RIGHTCORNER_DOTPOS = -21845;
    private static final int DRIFT_MINIGAME_GREENZONE_TIMEMULT = 327680;
    private static final int TACHO_FLASH_LIMIT = 1000000;
    private static final int SMOKE_START_MINIMUM = 819;
    private static final int MAX_DRIFT_ROTATION = 51472;
    private static final int MAX_DRIFT_ROTATION_SPEED = 200;
    private static final int DRIFT_RECENTRE_ROTATION_SPEED = 80;
    private static final int PRIMITIVE_TYPE_RECT = 0;
    private static final int PRIMITIVE_TYPE_FILLED_RECT = 1;
    private static final int PRIMITIVE_TYPE_ELLIPSE = 2;
    private static final int PRIMITIVE_TYPE_FILLED_ELLIPSE = 3;
    private static final int PRIMITIVE_TYPE_LINE = 4;
    private static final int[] TRACK1_WIDTHS;
    private static final int[] TRACK1_OFFSETS;
    private static final int[] TRACK2_WIDTHS;
    private static final int[] TRACK2_OFFSETS;
    private boolean m_clearScreen = true;
    public boolean m_stat_screen = false;
    private boolean m_raceIntroDone;
    private int m_raceIntroTotalTime = 0;
    private int m_raceIntroCameraOffsetF = 0;
    private int m_raceIntroCount;
    private int m_raceIntroTimer;
    private int m_raceIntroCameraDivF;
    private boolean m_raceIntroCameraDone;
    private static final short WRAPWIDTH_TUTORIAL = 136;
    private static final short WRAPWIDTH_CONFIRM = 136;
    private static final byte MENU_STATE_NONE = 0;
    private static final byte MENU_STATE_MAIN = 1;
    private static final byte MENU_STATE_HELP = 2;
    private static final byte MENU_STATE_ABOUT = 3;
    private static final byte MENU_STATE_OPTIONS = 4;
    private static final byte MENU_STATE_CONFIRMEXIT = 5;
    private static final byte MENU_STATE_CONFIRMRESTART = 6;
    private static final byte PRERACE_STATE_LOADING = 7;
    private static final byte PRERACE_STATE_TUTORIAL = 8;
    public boolean m_isMenuShowing;
    private int m_menuSelection;
    private short[] m_mainMenuStringIDs;
    private short[] m_optionsMenuStringIDs;
    private int m_menuState;
    private boolean m_isSteeringLeft;
    private boolean m_isSteeringRight;
    private boolean m_playerCarAuto = true;
    private boolean m_brakingForCorner;
    private boolean m_playerCarInInsideLane;
    private long m_playerEnteredCornerTime = 0L;
    private int m_playerLatPos1CornerTime = 0;
    private int m_playerLatPos2CornerTime = 0;
    private int m_playerLatPos3CornerTime = 0;
    private int m_playerLatPos4CornerTime = 0;
    private int m_chainedDriftComboCount = 0;
    private boolean m_slipstreamLinesEffectEnabled;
    private boolean m_insideCornerLineLinesEffectEnabled;
    private int m_insideCornerLineSustainTimer;
    private int m_slipstreamTimer = 0;
    private boolean m_slipstreaming = false;
    private GameObject m_slipstreamingCar = null;
    private int m_slipstreamMult = 0;
    private boolean m_showSlipstreamTouchySteering;
    private Image m_imgTrackPacked;
    private Image m_imgSkyline;
    private Image m_imgGrassDark;
    private Image m_imgGrassLight;
    private int[] m_grassOffsets;
    private int[] m_trackSectionCurvature;
    private int[] m_trackSectionAbsStart;
    private int[] m_trackSectionAbsEnd;
    private int[] m_trackSectionLength;
    private int[] m_trackSectionLengthInvF;
    private int[] m_trackSectionAvgSpeedsInvF;
    private int[] m_trackSectionSlope;
    private int m_trackNumSections;
    private int m_trackTotalDistance;
    private int[] m_slopeArrayDistanceF;
    private int[] m_slopeArraySlopeF;
    private int[] m_slopeSourceHeights;
    private int[] m_slopeDestYs;
    private int m_numSlopeSections;
    private int m_currBendFactor = 0;
    private int[] m_trackBendOffsets;
    private int m_invRoadHeightViewport;
    private int m_renderCityOffsetXF = 0;
    private int[] m_perspectiveRangesF = null;
    private int m_skylineColourR;
    private int m_skylineColourG;
    private int m_skylineColourB;
    private BaseObject[] m_staticTrackObjects = null;
    private GameObject[] m_carsTrackOrder = null;
    private GameObject[] m_carsRaceOrder = null;
    private GameObject[] m_opponentCars = null;
    private GameObject[] m_raceEndStandings;
    private int m_firstCarRenderIndex = 0;
    private int m_currCarRenderIndex = 0;
    private int m_firstStaticObjRenderIndex = 0;
    private int m_currStaticObjRenderIndex = 0;
    private int m_raceEndStandingsIndex;
    private GameObject m_playerCar = null;
    private AnimPlayer m_playerCarAnimPlayer;
    private short[] m_playerBrakesAnimIDs;
    private short m_crashLeftAnimID;
    private short m_crashRightAnimID;
    private int m_playerAccelerationF = 0x500000;
    private int m_playerSteeringAngleF;
    private int m_playerSteeringIncF;
    private int m_playerSteeringMaxF;
    private int m_playerSteeringRecentreIncF;
    private int m_playerTyresF;
    private int m_playerTyresInvF;
    private int m_playerBoostRestoreRateF;
    private int m_playerLateralSteerMaxF = 131072;
    private int m_playerLateralDriftMaxF = 163840;
    private int m_playerSpeedMaxF = 0x1900000;
    private boolean m_playerOffTrack = false;
    private int m_playerCarSlopeCurr = 0;
    private boolean m_playerIsBoosting = false;
    private int m_timeSinceLastBoost;
    private int m_playerBrakingF = 0xA00000;
    private int m_playerPostBoostSlowingF = 0x780000;
    private boolean m_playerIsDrifting = false;
    private int m_driftSpeedPenaltyMultF = 873800;
    private int m_playerCarLateralDriftF = 0;
    private int m_playerCarDriftDiffFactorF;
    private int m_playerCarDriftDiffTargetF = 0;
    private int m_lateralPosFactorF = 0;
    private int m_playerBoostTimeF = 196608;
    private int m_playerUpdateSteeringF = 0;
    private int m_playerCarDriftingAngleTargetF;
    private int m_playerCarDriftingAngleCurrentF;
    private AnimPlayer m_playerImpactSparkAnimPlayer;
    private boolean m_playerBumpedFront = false;
    private int m_playerImpactSparkX = 0;
    private int m_playerImpactSparkY = 0;
    private AnimPlayer m_smokeLeftAnimPlayer;
    private AnimPlayer m_smokeRightAnimPlayer;
    private boolean m_smokingLeftWheel = false;
    private boolean m_smokingRightWheel = false;
    private AnimPlayer m_speedlinesAnimPlayer;
    private boolean m_speedlines = false;
    private AnimPlayer m_highlightPlayer;
    private int[] m_playerCarLowRevSpeedsF;
    private int[] m_playerCarRevDivsF;
    private int m_playerCarMinDriftBendSpeed = 0;
    private int m_playerCarMaxDriftBendSpeed = 0;
    private int m_playerCarDriftBendSpeedDiv = 0;
    private int m_cornerOutsideSpeedMult = 39322;
    private int m_cornerInsideSpeedMult = 91750;
    private static final short[] LOADING_STATS_IDS;
    private byte[][] m_loadingTrackLengthBytes;
    private byte[][][] m_loadingStatsBytes;
    private byte[][] m_eolLapBytes;
    private byte[][] m_lapBytes;
    private byte[][] m_posBytes;
    private byte[] m_gearBytes;
    private byte[] m_speedBytes;
    private int m_speedBytesOffset;
    private byte[][] m_driftCashBytes;
    private byte[][][] m_endOfLapStatsBytes;
    private static final int DRIFT_START_DELAY = 800;
    private static final int DRIFT_CASH_FLASH_CYCLE_TIME = 1000;
    private static final int DRIFT_CASH_FLASH_TIMEOUT = 3000;
    private static final int DRIFT_CASH_FLASH_TIME = 550;
    private static final int DRIFT_TEXT_FLASH_CYCLE_TIME = 750;
    private static final int DRIFT_TEXT_FLASH_TIME = 380;
    private static final int DRIFT_BAR_FLASH_CYCLE_TIME = 300;
    private static final int DRIFT_BAR_FLASH_TIME = 150;
    private static final int BOOST_GAUGE_FLASH_CYCLE_TIME = 300;
    private static final int BOOST_GAUGE_FLASH_TIME = 180;
    private int m_driftMiniGameNeedleMomentumDir = 0;
    private int m_driftMiniGameNeedlePosF = 0;
    private int m_driftMiniGameTargetPosF = 0;
    private boolean m_driftMiniGameActivated = false;
    private boolean m_driftMiniGameLeftPressed = false;
    private boolean m_driftMiniGameRightPressed = false;
    private boolean m_driftMiniGameTargetDotMatched = false;
    private int[] m_steeringWheelAnimFramesLookupF;
    private int m_driftMiniGameTimerF = 0;
    private int m_driftMiniGameLastScore = 0;
    private int m_driftScoreDisplayTime = 0;
    private boolean m_driftScoreDisplayed = false;
    private int m_driftBorderLeft;
    private int m_driftBorderRight;
    private int m_wingedBoxBackingLeft;
    private int m_wingedBoxBackingRight;
    private int m_bonusNitroBoostTimer;
    private int m_driftScoreTimer;
    private int m_boostGaugeBonusWidth;
    private int m_driftTextFlashTimer;
    private int m_driftMiniGameDelayTimer;
    private int m_playerCarCollisionPushDiv = 0;
    private int m_driftScoreThisRace = 0;
    private int m_viewPosF = 0;
    private int m_viewSection = 0;
    private int m_cameraShakeX = 0;
    private int m_cameraShakeXAmplitudeF = 0;
    private int m_cameraShakeXAmplitudeMaxF = 262144;
    private static int m_cameraShakeXAmplitudeInitialF;
    private int m_boostDelay;
    private int m_boostGaugeLevel;
    private int m_boostGaugeDivF = 0;
    private AnimPlayer m_boostAnimPlayer;
    private int m_primitiveObjScaleBaseF;
    private int m_primitiveObjScaleRangeMultiplierF;
    private static final short[] CAR_SPEEDLINES_ANIM_IDS;
    private static final short[] CAR_HIGHLIGHT_ANIM_IDS;
    private static final short[] EFFECTS_ANIMIDS_BACKFIRE;
    private static final short[] BRAKES_STD;
    private static final short[] BRAKES_350Z;
    private static final short[] BRAKES_CHEVY;
    private static final short[] BRAKES_MUSTANG;
    private static final short[] BRAKES_SHELBY;
    private int m_slowdownEffectsAngle;
    private AnimPlayer m_slowdownBrakeAnimPlayer;
    private AnimPlayer m_slowdownBackfireAnimPlayer;
    private static final int COLLISION_BRAKE_TIMEOUT = 300;
    private int m_collisionBrakingTimeout;
    private int[] m_carCollisionLengthsF;
    private int[] m_carCollisionWidthsF;
    private int[] m_carAnimIDs;
    private int[] m_boostAnimIDs;
    private int m_carAngleLimit01F;
    private int m_carAngleLimit02F;
    private int m_carAngleLimit03F;
    private int m_carAngleLimit04F;
    private int m_numOpponentCars;
    private long m_lastLapTime;
    private long m_bestLapTime = -1L;
    private int m_lastLapDisplayTimer = 0;
    private boolean m_lastLapTimeShowing = false;
    private int m_bestLapDisplayTimer = 0;
    private boolean m_bestLapTimeShowing = false;
    private byte m_raceMaxLaps;
    private boolean m_raceComplete;
    private int m_raceCompleteTimer;
    private int m_biggestDriftScore;
    private static final int GRIP_LIGHTS_OFF_POS = -7536640;
    private static final int GRIP_LIGHTS_OFFSET_MAX = -1572864;
    private static final int GRIP_LIGHTS_SPEED = 6000;
    private static final int SMOKE_TAKEOFF_TIMEOUT = 500;
    private int m_takeOffSmokeTimer;
    private int m_lightsOffsetY;
    private int m_revPercentF;
    private int m_HUDWarningX = 0;
    private int m_HUDWarningY = 0;
    private AnimPlayer m_HUDBoostBar;
    private int m_nitroBarWidth = 0;
    private int m_nitroBarHeight = 0;
    private boolean m_redrawHUD;
    private boolean m_redrawHUDSpeed;
    private boolean m_redrawHUDGear;
    private boolean m_redrawHUDLapPosition;
    private boolean m_redrawHUDTopBar;
    private boolean m_redrawHUDCornerScore;
    private boolean m_redrawHUDDriftScore;
    private static final int MAX_UPDATE_LOADING_TIME = 64;
    private long m_loadMask;
    private int m_updateLoadingTime;
    private int m_loadedAnimImages;
    private int[] m_opponentCarAnimID;
    private boolean m_showDebugTrack = false;
    private int[] m_AIDecisionDelays;
    private GameObject m_nextOpponentRaceOrder;
    private GameObject m_prevOpponentRaceOrder;
    private boolean m_driftComboDisplayed = false;
    private int m_driftComboDisplayXF = 0;
    private int m_driftComboDisplayPauseTime = 0;
    private int m_driftComboDisplayAnimID;
    private static final int DRIFT_COMBO_DISPLAY_SPEED = 30000;
    private static final int DRIFT_COMBO_DISPLAY_PAUSE_TIME = 700;
    private static final int CRASH_CUTSCENE_END_DELAY = 900;
    private boolean m_crashCutscenePlaying = false;
    private boolean m_crashCutsceneBridgingAnimDone = false;
    private boolean m_crashCutsceneEndAnimDone = false;
    private int m_crashCutsceneEndDelay = 0;
    private static byte[][] m_racePosByteArrays;
    private static final byte WINGED_BOX_DRIFT = 0;
    private static final byte WINGED_BOX_DANGER = 1;
    private static final byte WINGED_BOX_SUCCESS = 2;
    private static final byte WINGED_BOX_INFO = 3;

    public SceneGame() {
        this.loadAnims();
        this.m_slopeArrayDistanceF = new int[16];
        this.m_slopeArraySlopeF = new int[16];
        this.m_slopeDestYs = new int[16];
        this.m_slopeSourceHeights = new int[16];
        this.m_raceMaxLaps = this.m_engine.getNextRaceNumLaps();
        this.m_trackBendOffsets = new int[83];
        this.initGrassOffsets();
        this.m_boostGaugeDivF = MathExt.Fdiv(65536, 0x640000);
    }

    private void initByteArrays() {
        byte[] byArray = this.m_engine.getString(111).getBytes();
        byte[] byArray2 = AppEngine.intToByteArray(this.m_carsRaceOrder.length);
        int n = this.m_engine.getCurrTrack();
        byte[] byArray3 = this.m_engine.getString(105).getBytes();
        int n2 = this.m_engine.rmsGetTrackBestLapTime(n);
        int n3 = this.m_engine.rmsGetTrackBestRaceTime(n);
        int n4 = this.m_engine.rmsGetTrackBiggestDriftScores(n);
        this.m_loadingStatsBytes = new byte[LOADING_STATS_IDS.length][][];
        this.m_loadingStatsBytes[0] = n2 == 0 ? (Object)new byte[][]{byArray3} : AppEngine.fixedToTimeBytes(n2);
        this.m_loadingStatsBytes[1] = n3 == 0 ? (Object)new byte[][]{byArray3} : AppEngine.fixedToTimeBytes(n3);
        this.m_loadingStatsBytes[2] = n4 == 0 ? (Object)new byte[][]{byArray3} : (byte[][])new byte[][]{this.m_engine.getString(147).getBytes(), AppEngine.intToByteArray(n4)};
        this.m_loadingTrackLengthBytes = new byte[][]{this.m_engine.getString(32).getBytes(), AppEngine.stringToByteArray(MathExt.fixedToString(this.m_trackTotalDistance << 3)), this.m_engine.getString(122).getBytes()};
        this.m_eolLapBytes = new byte[][]{this.m_engine.getString(93).getBytes(), AppEngine.BYTEARRAY_EMPTY};
        this.m_lapBytes = new byte[][]{AppEngine.intToByteArray(1), byArray, AppEngine.intToByteArray(this.m_raceMaxLaps)};
        this.m_posBytes = new byte[][]{byArray2, byArray, byArray2};
        this.m_gearBytes = AppEngine.intToByteArray(1);
        this.m_speedBytes = new byte[4];
        this.m_speedBytesOffset = 3;
        this.m_driftCashBytes = new byte[][]{this.m_engine.getString(147).getBytes(), AppEngine.intToByteArray(0)};
        this.m_endOfLapStatsBytes = new byte[][][]{new byte[][]{this.m_engine.getString(95).getBytes(), AppEngine.BYTEARRAY_EMPTY, byArray, byArray2}, new byte[][]{this.m_engine.getString(94).getBytes(), AppEngine.BYTEARRAY_EMPTY, AppEngine.BYTEARRAY_EMPTY, AppEngine.BYTEARRAY_EMPTY}};
    }

    public void start() {
        this.m_menuState = 7;
        this.m_biggestDriftScore = 0;
        this.m_lightsOffsetY = -7536640;
        this.m_numOpponentCars = 8;
        this.m_playerCarAuto = true;
        this.m_redrawHUDGear = true;
        this.loadTrack(this.m_engine.getCurrTrack());
        this.initDisplayDimensionsAndOffsets();
        this.initPerspectiveRanges();
        this.initPlayerCar();
        this.initOpponentCars();
        this.initTrackOrderArray();
        this.initCar();
        this.sortCarsTrackOrder();
        this.sortCarsRaceOrder();
        this.initStaticObjects();
        this.sortStaticObjTrackOrder();
        this.initByteArrays();
        AnimationManager animationManager = this.m_engine.getAnimationManager();
        this.m_slowdownEffectsAngle = 4;
        this.m_slowdownBrakeAnimPlayer = animationManager.createAnimPlayer();
        this.m_slowdownBackfireAnimPlayer = animationManager.createAnimPlayer();
        this.m_engine.getSoundManager().stopAllSounds();
        this.startRaceIntro();
        this.m_engine.setSoftKeys(0, 0);
    }

    private void resetRace() {
        this.m_engine.setSoftKeys(0, 0);
        this.m_engine.restartCurrentRace();
    }

    public void pause() {
    }

    public void resume() {
        this.m_redrawHUD = true;
        if (!this.m_isMenuShowing && this.m_menuState == 0) {
            this.m_isMenuShowing = true;
            this.m_menuState = 1;
            this.m_engine.setSoftKeys(3, 6);
            this.m_engine.getSoundManager().stopAllSounds();
            this.initialiseMenuItems();
        }
    }

    public void end() {
        this.m_engine.unloadImages(0xFFFFFFFFFL);
        this.m_engine.getSoundManager().stopAllSounds();
    }

    public void update(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.m_stat_screen) {
            this.m_engine.updateScrollers(n);
        }
        if (this.m_loadingProgress < 100) {
            this.updateLoading(n);
            this.m_engine.updateScrollers(n);
            return;
        }
        if (this.m_menuState == 7 || this.m_menuState == 8) {
            return;
        }
        if (this.m_endScene) {
            this.m_engine.changeScene(0, (byte)25);
            return;
        }
        if (this.m_isMenuShowing) {
            return;
        }
        if (!this.m_raceIntroDone) {
            this.updateRaceIntro(n);
            n = 0;
        }
        int n6 = n5 = MathExt.Fmul(n << 16, 66);
        this.m_revPercentF = 0;
        if (this.m_playerCar.m_speedF > this.m_playerCarLowRevSpeedsF[this.m_playerCar.getCurrentGear()]) {
            this.m_revPercentF = MathExt.Fmul(this.m_playerCar.m_speedF - this.m_playerCarLowRevSpeedsF[this.m_playerCar.getCurrentGear()], this.m_playerCarRevDivsF[this.m_playerCar.getCurrentGear()]);
        }
        if (this.m_revPercentF > 72090) {
            this.m_revPercentF = 72090;
        }
        if (this.m_driftComboDisplayed) {
            this.updateDriftComboDisplay(n);
        }
        if (this.m_collisionBrakingTimeout > 0) {
            this.m_collisionBrakingTimeout -= n;
        }
        if (this.m_boostDelay > 0) {
            this.m_boostDelay -= n;
        }
        if (this.m_takeOffSmokeTimer > 0) {
            this.m_takeOffSmokeTimer -= n;
        }
        if (this.m_playerCar.m_finishedRace) {
            for (n4 = 0; n4 < this.m_opponentCars.length; ++n4) {
                this.m_opponentCars[n4].m_isBraking = true;
            }
            this.m_playerCar.m_isBraking = true;
            this.m_playerCar.setBoosting(false);
            this.m_smokingRightWheel = this.m_smokingLeftWheel = this.m_playerCar.m_speedF > 0;
        }
        if (this.m_playerCar.m_showingSlowdownEffects) {
            boolean bl = this.m_playerCar.m_showingSlowdownEffects = !this.m_crashCutscenePlaying && (this.m_slowdownBrakeAnimPlayer.isAnimating() || this.m_brakingForCorner || this.m_slowdownBackfireAnimPlayer.isAnimating());
            if (!this.m_playerCar.m_showingSlowdownEffects) {
                this.m_slowdownBrakeAnimPlayer.setAnimating(false);
                this.m_slowdownBackfireAnimPlayer.setAnimating(false);
            } else {
                n4 = this.getPlayerCarAnimID();
                if (n4 != this.m_slowdownEffectsAngle) {
                    this.m_slowdownEffectsAngle = n4;
                    if (this.m_slowdownBrakeAnimPlayer.isAnimating() && this.m_playerBrakesAnimIDs[n4] != -1) {
                        this.m_slowdownBrakeAnimPlayer.startAnim(this.m_playerBrakesAnimIDs[n4], false, false);
                    }
                    this.m_slowdownBackfireAnimPlayer.startAnim(EFFECTS_ANIMIDS_BACKFIRE[n4], false, false);
                }
                this.m_slowdownBrakeAnimPlayer.updateAnim(n);
                this.m_slowdownBackfireAnimPlayer.updateAnim(n);
            }
        }
        n4 = this.m_trackSectionCurvature[this.m_playerCar.m_currSection];
        if (this.m_raceComplete && this.m_playerCar.m_isBraking) {
            this.m_playerCarDriftingAngleTargetF = 51472;
        } else if (this.m_driftMiniGameActivated) {
            this.m_playerCarDriftingAngleTargetF = 51472;
            if (n4 > 0) {
                this.m_playerCarDriftingAngleTargetF = -this.m_playerCarDriftingAngleTargetF;
            }
        } else {
            this.m_playerCarDriftingAngleTargetF = 0;
        }
        int n7 = this.m_playerCarDriftingAngleTargetF - this.m_playerCarDriftingAngleCurrentF;
        if (this.m_playerCarDriftingAngleCurrentF != 0 && !this.m_driftMiniGameActivated) {
            n3 = 80;
            if (n7 < 0) {
                n3 = -n3;
            }
        } else {
            n3 = 200;
            if (n7 < 0) {
                n3 = -n3;
            }
        }
        int n8 = MathExt.Fmul(n3, n << 16);
        if (n3 > 0 && n8 > n7 || n3 < 0 && n8 < n7) {
            n8 = n7;
        }
        this.m_playerCarDriftingAngleCurrentF += n8;
        this.updateCollisions(n6);
        this.updateBoost(n6);
        if (this.m_bonusNitroBoostTimer > 0) {
            this.m_bonusNitroBoostTimer -= n;
            if (this.m_bonusNitroBoostTimer <= 0) {
                this.setPlayerBoosting(false);
            }
        }
        if (this.m_driftMiniGameActivated) {
            this.m_driftTextFlashTimer -= n;
            if (this.m_driftMiniGameDelayTimer > 0) {
                this.m_driftMiniGameDelayTimer -= n;
                if (this.m_driftTextFlashTimer <= 0) {
                    this.m_driftTextFlashTimer = 300;
                }
            } else {
                if (this.m_driftTextFlashTimer <= 0) {
                    this.m_driftTextFlashTimer = 750;
                }
                this.updateDriftMiniGameNeedle(n6);
            }
        } else {
            this.updateSteering(n5);
        }
        this.updateCityScroll(n6);
        this.updatePlayerSlipstreaming(n6);
        this.updateAllCarsTrackPos(n6);
        this.updateTrackWarning();
        this.m_currBendFactor = this.calcBendFactor();
        this.calcTrackBendOffsets();
        if (this.m_raceIntroCount < 0 && this.m_lightsOffsetY > -7536640) {
            this.m_lightsOffsetY -= 6000 * n;
        }
        this.updateLateralPos(n6);
        if (!this.m_playerCar.m_finishedRace) {
            this.updateSmoke(n6);
            this.updateOpponentCarsSteering(n6);
            this.updateOpponentCarsLateralPos(n6);
        }
        this.updateRaceProgress(n5);
        this.updateLapTimeDisplay(n5);
        this.updateAnims(MathExt.Fmul(n6, 65536000) + 32768 >> 16);
        if (this.m_driftScoreTimer > 0) {
            this.updateDriftScoreDisplay(n);
        }
        this.m_playerCarSlopeCurr = this.getCarSlope();
        int n9 = this.m_playerCar.getRacePos();
        this.sortCarsTrackOrder();
        this.sortCarsRaceOrder();
        this.updateCatchupCode(n5);
        if (!this.m_playerCar.m_finishedRace && this.m_playerCar.getRacePos() != n9) {
            this.m_posBytes[0] = AppEngine.intToByteArray(this.m_playerCar.getRacePos() + 1);
        }
        int n10 = this.m_playerCar.m_speedF;
        if (this.m_slipstreamMult > 0) {
            n10 += MathExt.Fmul(n10, this.m_slipstreamMult);
        }
        if ((n2 = AppEngine.intToByteArray(n10 >> 17, this.m_speedBytes)) != -1) {
            this.m_redrawHUDSpeed = true;
            this.m_speedBytesOffset = n2;
        }
        if (this.m_raceIntroDone) {
            this.updateSound();
        }
    }

    private boolean updateAllCarsTrackPos(int n) {
        boolean bl = true;
        for (int i = 0; i < this.m_carsTrackOrder.length; ++i) {
            int n2;
            int n3;
            GameObject gameObject = this.m_carsTrackOrder[i];
            if (!gameObject.m_finishedRace) {
                gameObject.m_currentLapTime += n;
                if (bl) {
                    bl = false;
                }
            }
            boolean bl2 = gameObject.updateSpeed(n);
            if (gameObject == this.m_playerCar && this.m_playerCarAuto && bl2) {
                this.m_redrawHUDGear = true;
                this.m_gearBytes = AppEngine.intToByteArray(this.m_playerCar.getCurrentGear() + 1);
            }
            int n4 = gameObject.m_speedF;
            if (gameObject == this.m_playerCar && this.m_slipstreamTimer > 0) {
                n4 += MathExt.Fmul(n4, this.m_slipstreamMult);
            }
            n4 = MathExt.Fmul(n4, gameObject.m_catchupCodeMultCurrF);
            int n5 = this.m_trackSectionCurvature[gameObject.m_currSection];
            if (gameObject == this.m_playerCar && n5 != 0) {
                if (this.m_driftMiniGameActivated) {
                    if (gameObject.m_speedF < 0x500000) {
                        this.endDriftMiniGame();
                    }
                } else {
                    n3 = this.m_cornerInsideSpeedMult - this.m_cornerOutsideSpeedMult;
                    n2 = gameObject.m_lateralPosF + 65536 >> 1;
                    if (n5 < 0) {
                        n2 = 65536 - n2;
                    }
                    int n6 = this.m_cornerOutsideSpeedMult + MathExt.Fmul(n2, n3);
                    n4 = MathExt.Fmul(n4, n6);
                }
            }
            n4 = MathExt.Fmul(n4, 131072);
            gameObject.m_trackPosF += MathExt.Fmul(n4, n);
            while (gameObject.m_trackPosF > this.m_trackSectionAbsEnd[gameObject.m_currSection] << 16) {
                n3 = this.m_trackSectionCurvature[gameObject.m_currSection];
                if (gameObject == this.m_playerCar && !gameObject.m_finishedRace) {
                    if (this.m_trackSectionCurvature[gameObject.m_currSection] != 0 && this.m_trackSectionCurvature[gameObject.m_nextSection] == 0) {
                        this.m_playerSteeringAngleF = 0;
                    }
                    if (!gameObject.m_finishedRace && gameObject.m_numLapsCompleted != -1 && n3 != 0) {
                        this.m_redrawHUDCornerScore = true;
                        if (this.m_driftMiniGameActivated && (n2 = this.m_trackSectionCurvature[(gameObject.m_currSection + 1) % this.m_trackSectionCurvature.length]) == 0) {
                            this.endDriftMiniGame();
                        }
                    }
                }
                ++gameObject.m_currSection;
                if (gameObject.m_currSection >= this.m_trackNumSections) {
                    gameObject.m_currSection -= this.m_trackNumSections;
                    gameObject.m_trackPosF -= this.m_trackTotalDistance << 16;
                    if (!gameObject.m_finishedRace) {
                        this.gameObjectFinishedLap(gameObject);
                    }
                }
                n2 = this.m_trackSectionCurvature[gameObject.m_currSection];
                if (gameObject == this.m_playerCar && n2 != 0) {
                    if (n3 == 0) {
                        this.m_playerEnteredCornerTime = System.currentTimeMillis();
                        this.m_playerLatPos1CornerTime = 0;
                        this.m_playerLatPos2CornerTime = 0;
                        this.m_playerLatPos3CornerTime = 0;
                        this.m_playerLatPos4CornerTime = 0;
                        this.m_chainedDriftComboCount = 1;
                    }
                    if (this.m_playerCar.isBoosting() && !this.m_playerOffTrack) {
                        this.startDriftMiniGame();
                    } else if (this.m_driftMiniGameActivated && this.m_playerCar.m_numLapsCompleted != -1 && (n2 > 0 && n3 < 0 || n2 < 0 && n3 > 0)) {
                        ++this.m_chainedDriftComboCount;
                        this.showDriftComboDisplay();
                    }
                }
                gameObject.m_nextSection = gameObject.m_currSection + 1;
                if (gameObject.m_nextSection < this.m_trackNumSections) continue;
                gameObject.m_nextSection -= this.m_trackNumSections;
            }
            if (gameObject != this.m_playerCar) continue;
            this.m_playerIsDrifting = this.m_trackSectionCurvature[this.m_playerCar.m_currSection] != 0;
        }
        return bl;
    }

    private void showDriftComboDisplay() {
        this.m_driftComboDisplayed = true;
        this.m_driftComboDisplayPauseTime = 0;
        int n = this.m_engine.getAnimationManager().getAnimFrameWidth(268, 0);
        this.m_driftComboDisplayXF = this.m_engine.getWidth() + (n >> 1) << 16;
        switch (this.m_chainedDriftComboCount) {
            case 2: {
                this.m_driftComboDisplayAnimID = 266;
                break;
            }
            case 3: {
                this.m_driftComboDisplayAnimID = 267;
                break;
            }
            case 4: {
                this.m_driftComboDisplayAnimID = 268;
                break;
            }
            default: {
                this.m_driftComboDisplayAnimID = -1;
            }
        }
    }

    private void hideDriftComboDisplay() {
        this.m_driftComboDisplayed = false;
    }

    private void updateDriftComboDisplay(int n) {
        int n2 = this.m_driftComboDisplayXF >> 16;
        if (n2 == this.m_engine.getHalfWidth() && this.m_driftComboDisplayPauseTime < 700) {
            this.m_driftComboDisplayPauseTime += n;
        } else {
            int n3 = MathExt.Fmul(30000, n << 16);
            this.m_driftComboDisplayXF -= n3;
            int n4 = this.m_driftComboDisplayXF >> 16;
            if (n2 > this.m_engine.getHalfWidth() && n4 < this.m_engine.getHalfWidth()) {
                this.m_driftComboDisplayXF = this.m_engine.getHalfWidth() << 16;
            } else {
                int n5 = this.m_engine.getAnimationManager().getAnimFrameWidth(this.m_driftComboDisplayAnimID, 0);
                int n6 = -(n5 >> 1);
                if (n4 < n6) {
                    this.hideDriftComboDisplay();
                }
            }
        }
    }

    private void renderDriftComboDisplay(Graphics graphics) {
        this.m_engine.getAnimationManager().drawAnimFrame(graphics, this.m_driftComboDisplayAnimID, 0, this.m_driftComboDisplayXF >> 16, 130);
    }

    private void updatePlayerSlipstreaming(int n) {
        int n2;
        if (this.m_slipstreaming) {
            if (this.isCarWithinSlipstreamZDist(this.m_slipstreamingCar) && this.isCarWithinSlipstreamXDist(this.m_slipstreamingCar)) {
                if (this.m_slipstreamTimer < 65536) {
                    this.m_slipstreamTimer += n;
                } else {
                    if (!this.m_slipstreamLinesEffectEnabled) {
                        this.m_slipstreamLinesEffectEnabled = true;
                    }
                    this.m_slipstreamMult += MathExt.Fmul(6554, n);
                    if (this.m_slipstreamMult > 9830) {
                        this.m_slipstreamMult = 9830;
                    }
                }
                return;
            }
            this.m_slipstreaming = false;
            this.m_showSlipstreamTouchySteering = false;
        }
        int n3 = 0;
        for (n2 = 0; n2 < this.m_carsTrackOrder.length; ++n2) {
            if (this.m_carsTrackOrder[n2] != this.m_playerCar) continue;
            n3 = n2;
            break;
        }
        if ((n2 = n3 + 1) >= this.m_carsTrackOrder.length) {
            n2 = 0;
        }
        while (this.isCarWithinSlipstreamZDist(this.m_carsTrackOrder[n2])) {
            if (this.isCarWithinSlipstreamXDist(this.m_carsTrackOrder[n2])) {
                this.m_slipstreaming = true;
                this.m_slipstreamingCar = this.m_carsTrackOrder[n2];
                this.m_slipstreamTimer = 0;
                if (!this.m_driftMiniGameActivated || this.m_crashCutscenePlaying) {
                    this.calculateWingedBoxWidth(HUD_WINGEDBOX_INFO_WIDTH, 3);
                }
                return;
            }
            if (++n2 >= this.m_carsTrackOrder.length) {
                n2 = 0;
            }
            if (n2 != n3) continue;
        }
        if (!(this.m_slipstreaming && this.m_slipstreamTimer >= 65536 || this.m_slipstreamMult <= 0)) {
            this.m_slipstreamMult -= MathExt.Fmul(6554, n >> 2);
            if (this.m_slipstreamMult < 0) {
                this.m_slipstreamMult = 0;
            }
        }
        if ((!this.m_slipstreaming || this.m_slipstreamTimer < 65536) && this.m_slipstreamLinesEffectEnabled) {
            this.m_slipstreamLinesEffectEnabled = false;
        }
    }

    private boolean isCarWithinSlipstreamZDist(GameObject gameObject) {
        int n = gameObject.m_trackPosF - this.m_playerCar.m_trackPosF;
        if (n < 0 && gameObject.m_numLapsCompleted > this.m_playerCar.m_numLapsCompleted) {
            while (n < 0) {
                n += this.m_trackTotalDistance << 16;
            }
        }
        return n > 0 && n <= 0xC80000;
    }

    private boolean isCarWithinSlipstreamXDist(GameObject gameObject) {
        int n = Math.abs(gameObject.m_lateralPosF - this.m_playerCar.m_lateralPosF);
        return n <= 21823;
    }

    private int getCarZDist(GameObject gameObject) {
        int n = gameObject.m_trackPosF - this.m_playerCar.m_trackPosF;
        if (n < 0 && gameObject.m_numLapsCompleted > this.m_playerCar.m_numLapsCompleted) {
            while (n < 0) {
                n += this.m_trackTotalDistance << 16;
            }
        }
        return n;
    }

    private void showDriftScore() {
        this.m_driftScoreTimer = 3000;
    }

    private void hideDriftScore() {
        this.m_driftScoreTimer = 0;
    }

    private void updateDriftScoreDisplay(int n) {
        if (this.m_driftScoreTimer > 0) {
            this.m_driftScoreTimer -= n;
            if (this.m_driftScoreTimer <= 0) {
                if (!this.m_driftMiniGameActivated && !this.m_crashCutscenePlaying && (this.m_slipstreamLinesEffectEnabled || this.m_insideCornerLineLinesEffectEnabled)) {
                    this.calculateWingedBoxWidth(HUD_WINGEDBOX_INFO_WIDTH, 3);
                }
                this.m_redrawHUDTopBar = true;
            }
        }
    }

    private void updateRaceProgress(int n) {
        if (this.m_raceComplete) {
            this.m_raceCompleteTimer += n;
            if (this.m_raceCompleteTimer >= 131072) {
                this.m_engine.setSoftKeys(0, 0);
                for (int i = 0; i < this.m_opponentCars.length; ++i) {
                    this.m_opponentCars[i].m_isBraking = false;
                }
                while (!this.updateAllCarsTrackPos(n << 5)) {
                }
                if (this.m_engine.isCarNowRacingCareer()) {
                    this.m_engine.awardCareerPrizeMoney(this.m_driftScoreThisRace);
                    this.m_engine.setLastRaceDriftMoney(this.m_driftScoreThisRace);
                }
                this.sortRaceEndStandings();
                this.m_engine.notifyRacePosition(this.m_raceEndStandingsIndex);
                this.m_engine.submitRaceStandings(this.m_raceEndStandings);
                this.m_engine.submitBestLapTime((int)this.m_bestLapTime);
                this.m_engine.submitBestRaceTime(this.m_playerCar.m_cumulativeLapTimes);
                this.m_engine.submitBiggestDriftScores(this.m_biggestDriftScore);
                this.m_endScene = true;
            }
        }
    }

    private void sortRaceEndStandings() {
        this.m_raceEndStandingsIndex = 0;
        for (int i = this.m_raceEndStandings.length - 1; i >= 1; --i) {
            if (this.m_raceEndStandings[i] != this.m_playerCar) continue;
            this.m_raceEndStandingsIndex = i;
            if (this.m_playerCar.m_cumulativeLapTimes != this.m_raceEndStandings[i - 1].m_cumulativeLapTimes) continue;
            this.m_raceEndStandings[i] = this.m_raceEndStandings[i - 1];
            this.m_raceEndStandings[i - 1] = this.m_playerCar;
            this.m_raceEndStandingsIndex = i - 1;
        }
    }

    public void gameObjectFinishedLap(GameObject gameObject) {
        ++gameObject.m_numLapsCompleted;
        if (gameObject == this.m_playerCar) {
            int n = gameObject.m_numLapsCompleted + 1;
            if (n == 0) {
                n = 1;
            } else if (n > this.m_raceMaxLaps) {
                n = this.m_raceMaxLaps;
            }
            this.m_lapBytes[0] = AppEngine.intToByteArray(n);
            this.m_eolLapBytes[1] = this.m_lapBytes[0];
            this.m_endOfLapStatsBytes[0][1] = this.m_posBytes[0];
            this.m_redrawHUDLapPosition = true;
        }
        if (gameObject.m_numLapsCompleted > 0) {
            gameObject.m_cumulativeLapTimes += gameObject.m_currentLapTime;
        }
        if (gameObject.m_numLapsCompleted == this.m_raceMaxLaps) {
            gameObject.m_finishedRace = true;
            if (gameObject == this.m_playerCar) {
                // empty if block
            }
            this.m_raceEndStandings[this.m_raceEndStandingsIndex++] = gameObject;
        }
        if (gameObject == this.m_playerCar && gameObject.m_numLapsCompleted != 0) {
            this.m_lastLapTime = gameObject.m_currentLapTime;
            byte[][] byArray = AppEngine.fixedToTimeBytes((int)this.m_lastLapTime);
            if (byArray.length > 1) {
                this.m_endOfLapStatsBytes[1][1] = byArray[0];
                this.m_endOfLapStatsBytes[1][2] = byArray[1];
                this.m_endOfLapStatsBytes[1][3] = byArray[2];
            } else {
                this.m_endOfLapStatsBytes[1][1] = AppEngine.BYTEARRAY_EMPTY;
                this.m_endOfLapStatsBytes[1][2] = AppEngine.BYTEARRAY_EMPTY;
                this.m_endOfLapStatsBytes[1][3] = byArray[0];
            }
            if (this.m_bestLapTime == -1L || this.m_lastLapTime < this.m_bestLapTime) {
                this.m_bestLapTime = this.m_lastLapTime;
                this.showBestLapTime();
            }
            this.showLastLapTime();
            if (gameObject.m_finishedRace) {
                this.m_raceComplete = true;
                this.m_raceCompleteTimer = 0;
            }
        }
        if (gameObject.m_numLapsCompleted > 0) {
            gameObject.m_currentLapTime = 0;
        }
    }

    public void render(Graphics graphics) {
        if (this.m_loadingProgress < 100 || this.m_menuState == 7) {
            this.renderLoading(graphics);
            return;
        }
        if (this.m_menuState == 8) {
            this.renderTutorial(graphics);
            this.m_redrawHUD = true;
            this.renderHUD(graphics);
            return;
        }
        if (this.m_raceCompleteTimer >= 131072) {
            return;
        }
        if (this.m_clearScreen) {
            this.m_clearScreen = false;
            graphics.setColor(this.m_skylineColourR, this.m_skylineColourG, this.m_skylineColourB);
            graphics.fillRect(VIEWPORT_LEFT, VIEWPORT_TOP, VIEWPORT_WIDTH, VIEWPORT_HEIGHT);
            this.m_redrawHUD = true;
        }
        int n = graphics.getClipX();
        int n2 = graphics.getClipY();
        int n3 = graphics.getClipWidth();
        int n4 = graphics.getClipHeight();
        graphics.clipRect(0, 0, VIEWPORT_WIDTH, TRACK_VIEWPORT_HEIGHT);
        this.adjustViewpoint();
        this.renderCity(graphics);
        this.renderTrack(graphics);
        this.renderDrawList(graphics);
        if (this.m_engine.m_rmsCarMarkersEnabled) {
            this.renderRacePosIndicatorRear(graphics);
        }
        if (this.m_driftComboDisplayed) {
            this.renderDriftComboDisplay(graphics);
        }
        graphics.setClip(n, n2, n3, n4);
        this.renderHUD(graphics);
        if ((this.m_raceIntroDone || this.m_raceIntroCount < 1) && this.m_lastLapTimeShowing) {
            this.renderLapTimes(graphics);
        }
        if (!this.m_raceIntroDone || this.m_lightsOffsetY > -7536640) {
            this.renderRaceIntroHUD(graphics);
        }
        if (this.m_showDebugTrack) {
            this.renderDebugTrack(graphics, false);
        }
        if (this.m_isMenuShowing) {
            this.renderMenu(graphics);
        }
    }

    private void renderMenu(Graphics graphics) {
        switch (this.m_menuState) {
            case 2: {
                this.m_engine.renderHelpAbout(graphics, 39);
                this.m_engine.renderSoftKeysInGame(graphics);
                break;
            }
            case 3: {
                this.m_engine.renderHelpAbout(graphics, 38);
                this.m_engine.renderSoftKeysInGame(graphics);
                break;
            }
            case 4: {
                this.renderMenu(graphics, this.m_optionsMenuStringIDs, 36);
                break;
            }
            case 1: {
                this.renderMenu(graphics, this.m_mainMenuStringIDs, 37);
                break;
            }
            case 5: 
            case 6: {
                this.renderConfirm(graphics);
            }
        }
    }

    private void renderMenu(Graphics graphics, short[] sArray, int n) {
        AppEngine appEngine = this.m_engine;
        AnimationManager animationManager = appEngine.getAnimationManager();
        MixedFont mixedFont = appEngine.getFont(1);
        int n2 = sArray.length * 11;
        int n3 = appEngine.getHeight() - (n2 + 16 + 8) >> 1;
        int n4 = n3 + 16;
        int n5 = n4 + n2;
        int n6 = this.m_engine.getHalfWidth() - 73 - 5;
        int n7 = n6 + 5;
        int n8 = n7 + 146;
        int n9 = n7 + 6;
        int n10 = n8 - 21;
        animationManager.setColor(graphics, 0);
        graphics.fillRect(n6, n3, 156, 16);
        graphics.fillRect(n6, n4, 5, n2);
        graphics.fillRect(n8, n4, 5, n2);
        graphics.fillRect(n6, n5, 156, 8);
        animationManager.setColor(graphics, 2);
        graphics.fillRect(n7, n4, 146, n2);
        animationManager.drawAnimFrame(graphics, 337, 0, n6, n4 + this.m_menuSelection * 11);
        appEngine.drawString(graphics, n, appEngine.getFont(3), n7 + 2, n3 + 8, 6);
        for (int i = sArray.length - 1; i >= 0; --i) {
            int n11;
            int n12 = n4 + i * 11 + 3;
            appEngine.drawString(graphics, sArray[i], mixedFont, n9, n12, 20);
            if (sArray[i] == 88) {
                n11 = appEngine.isSoundEnabled() ? 91 : 92;
                appEngine.drawString(graphics, n11, mixedFont, n10, n12, 24);
                continue;
            }
            if (sArray[i] == 89) {
                n11 = appEngine.isVibrationEnabled() ? 91 : 92;
                appEngine.drawString(graphics, n11, mixedFont, n10, n12, 24);
                continue;
            }
            if (sArray[i] != 90) continue;
            n11 = appEngine.m_rmsCarMarkersEnabled ? 91 : 92;
            appEngine.drawString(graphics, n11, mixedFont, n10, n12, 24);
        }
    }

    private void renderConfirm(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        AnimationManager animationManager = appEngine.getAnimationManager();
        MixedFont mixedFont = appEngine.getFont(1);
        int n = mixedFont.getLineHeight() + 3;
        int n2 = appEngine.getNumWrappedLines() * n;
        int n3 = this.m_engine.getHalfWidth();
        int n4 = this.m_engine.getHalfHeight() - (n2 >> 1);
        int n5 = n4 - 3;
        int n6 = n3 - 68;
        animationManager.setColor(graphics, 0);
        graphics.fillRect(n6 - 5, n5 - 8, 146, 8);
        graphics.fillRect(n6 - 5, n5, 5, n2 + 3);
        graphics.fillRect(n6 + 136, n5, 5, n2 + 3);
        graphics.fillRect(n6 - 5, n5 + n2 + 3, 146, 8);
        animationManager.setColor(graphics, 14);
        graphics.fillRect(n6, n5, 136, n2 + 3);
        appEngine.drawWrappedString(graphics, mixedFont, n, n3, n4, 17);
    }

    private void renderLoading(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        AnimationManager animationManager = appEngine.getAnimationManager();
        MixedFont mixedFont = appEngine.getFont(3);
        MixedFont mixedFont2 = appEngine.getFont(1);
        int n = appEngine.getHalfWidth();
        int n2 = n + animationManager.getAnimFrameFirePointX(383, 0, 0);
        int n3 = n + animationManager.getAnimFrameFirePointX(383, 0, 1);
        int n4 = 138 + animationManager.getAnimFrameFirePointY(383, 0, 0);
        int n5 = 138 + animationManager.getAnimFrameFirePointY(383, 0, 1);
        int n6 = n + animationManager.getAnimFrameFirePointX(260, 0, 0);
        int n7 = 233 + animationManager.getAnimFrameFirePointY(260, 0, 0);
        int n8 = 20 * LOADING_STATS_IDS.length;
        int n9 = animationManager.getAnimFrameWidth(383, 0) >> 1;
        animationManager.setColor(graphics, 46);
        graphics.fillRect(0, 0, appEngine.getWidth(), appEngine.getHeight());
        animationManager.drawAnimFrame(graphics, 344, 0, n, 84);
        animationManager.setColor(graphics, 0);
        graphics.fillRect(n - n9 - 5, 138, 5, n8);
        graphics.fillRect(n + n9, 138, 5, n8);
        graphics.fillRect(n - n9 - 5, 138 + n8, n9 + 5 << 1, 8);
        int n10 = 84 + animationManager.getAnimFrameFirePointY(344, 0, 0);
        appEngine.drawString(graphics, 101, mixedFont2, n, n10, 17);
        n10 = 84 + animationManager.getAnimFrameFirePointY(344, 0, 1);
        appEngine.drawString(graphics, appEngine.getTrackNameStringID(appEngine.getCurrTrack()), mixedFont, n, n10, 17);
        n10 = 84 + animationManager.getAnimFrameFirePointY(344, 0, 2);
        int n11 = n3 - n2;
        appEngine.renderScroller(0, graphics, this.m_loadingTrackLengthBytes, mixedFont2, n, n10, n11, 17);
        for (int i = 0; i < LOADING_STATS_IDS.length; ++i) {
            animationManager.drawAnimFrame(graphics, 383, 0, n, 138 + 20 * i);
            appEngine.drawString(graphics, LOADING_STATS_IDS[i], mixedFont2, n2, n4 + 20 * i, 20);
            appEngine.drawChars(graphics, this.m_loadingStatsBytes[i], mixedFont2, n3, n5 + 20 * i, 24);
        }
        if (this.m_loadingProgress < 100) {
            appEngine.renderLoadingBar(graphics, this.m_loadingProgress);
        }
        appEngine.renderSoftKeys(graphics);
    }

    private void renderTutorial(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        AnimationManager animationManager = appEngine.getAnimationManager();
        animationManager.setColor(graphics, 1);
        graphics.fillRect(VIEWPORT_LEFT, VIEWPORT_TOP, VIEWPORT_WIDTH, VIEWPORT_HEIGHT);
        appEngine.renderHelpAbout(graphics, 45);
    }

    private void initialiseMenuItems() {
        this.m_mainMenuStringIDs = new short[]{14, 36, 39, 38, 15, 17};
        this.m_optionsMenuStringIDs = new short[]{88, 89, 90, 13};
    }

    public void processKeys(int n, int n2) {
        if (this.m_isMenuShowing) {
            this.processKeysMenu(n, n2);
            return;
        }
        if (this.m_menuState == 7 || this.m_menuState == 8) {
            this.processKeysPreRace(n, n2);
            return;
        }
        if (n2 == 1) {
            this.m_isMenuShowing = true;
            this.m_menuState = 1;
            this.m_engine.setSoftKeys(3, 6);
            this.m_redrawHUD = true;
            this.m_engine.getSoundManager().stopAllSounds();
            this.initialiseMenuItems();
        } else if (!this.m_raceIntroDone) {
            this.processKeysRaceIntro(n, n2);
        } else if (this.m_driftMiniGameActivated) {
            this.processKeysDriftMiniGame(n, n2);
        } else {
            this.processKeysDriving(n, n2);
        }
    }

    private void processKeysMenu(int n, int n2) {
        switch (this.m_menuState) {
            case 2: 
            case 3: {
                this.m_engine.processKeysHelpAbout(n, n2);
                if (n2 != 3) break;
                this.m_engine.clearCommandKeys();
                this.m_engine.setSoftKeys(3, 6);
                this.m_menuState = 1;
                this.m_redrawHUD = true;
                break;
            }
            case 4: {
                if ((n & 0x2004) != 0) {
                    this.m_engine.clearKeyBit(8196);
                    this.m_menuSelection = (this.m_menuSelection + this.m_optionsMenuStringIDs.length - 1) % this.m_optionsMenuStringIDs.length;
                    break;
                }
                if ((n & 0x4100) != 0) {
                    this.m_engine.clearKeyBit(16640);
                    this.m_menuSelection = (this.m_menuSelection + 1) % this.m_optionsMenuStringIDs.length;
                    break;
                }
                if (n2 == 3) {
                    this.m_engine.clearCommandKeys();
                    this.m_engine.setSoftKeys(3, 6);
                    this.m_menuSelection = 0;
                    this.m_menuState = 1;
                    this.m_redrawHUD = true;
                    break;
                }
                short s = this.m_optionsMenuStringIDs[this.m_menuSelection];
                switch (s) {
                    case 88: 
                    case 89: 
                    case 90: {
                        if ((n & 0x8010) == 0 && (n & 0x10040) == 0 && (n & 0x1020) == 0 && n2 != 6) break;
                        this.m_engine.clearKeyBit(102512);
                        this.m_engine.clearCommandKeys();
                        if (s == 88) {
                            this.m_engine.setSoundEnabled(!this.m_engine.isSoundEnabled());
                            this.m_engine.getSoundManager().playSound(7);
                            System.out.println("");
                            break;
                        }
                        if (s == 89) {
                            this.m_engine.setVibrationEnabled(!this.m_engine.isVibrationEnabled());
                            this.m_engine.vibrate(400);
                            break;
                        }
                        if (s != 90) break;
                        this.m_engine.m_rmsCarMarkersEnabled = !this.m_engine.m_rmsCarMarkersEnabled;
                        break;
                    }
                    case 13: {
                        if ((n & 0x1020) == 0 && n2 != 6) break;
                        this.m_engine.clearKeyBit(4128);
                        this.m_engine.clearCommandKeys();
                        this.m_engine.setSoftKeys(3, 6);
                        this.m_menuSelection = 0;
                        this.m_menuState = 1;
                        this.m_redrawHUD = true;
                    }
                }
                break;
            }
            case 1: {
                if ((n & 0x2004) != 0) {
                    this.m_engine.clearKeyBit(8196);
                    this.m_menuSelection = (this.m_menuSelection + this.m_mainMenuStringIDs.length - 1) % this.m_mainMenuStringIDs.length;
                    break;
                }
                if ((n & 0x4100) != 0) {
                    this.m_engine.clearKeyBit(16640);
                    this.m_menuSelection = (this.m_menuSelection + 1) % this.m_mainMenuStringIDs.length;
                    break;
                }
                if (n2 == 3) {
                    this.m_engine.clearCommandKeys();
                    this.m_engine.setSoftKeys(0, 1);
                    this.m_menuState = 0;
                    this.m_redrawHUD = true;
                    this.m_isMenuShowing = false;
                    break;
                }
                if ((n & 0x1020) == 0 && n2 != 6) break;
                this.m_engine.clearKeyBit(4128);
                this.m_engine.clearCommandKeys();
                switch (this.m_mainMenuStringIDs[this.m_menuSelection]) {
                    case 17: {
                        this.m_engine.wrapText(18, this.m_engine.getFont(1), 136);
                        this.m_engine.setSoftKeys(10, 9);
                        this.m_menuState = 5;
                        this.m_redrawHUD = true;
                        break;
                    }
                    case 15: {
                        this.m_engine.wrapText(16, this.m_engine.getFont(1), 136);
                        this.m_engine.setSoftKeys(10, 9);
                        this.m_menuState = 6;
                        this.m_redrawHUD = true;
                        break;
                    }
                    case 14: {
                        this.m_engine.setSoftKeys(0, 1);
                        this.m_menuState = 0;
                        this.m_redrawHUD = true;
                        this.m_isMenuShowing = false;
                        break;
                    }
                    case 36: {
                        this.m_engine.setSoftKeys(3, 6);
                        this.m_menuSelection = 0;
                        this.m_menuState = 4;
                        this.m_redrawHUD = true;
                        break;
                    }
                    case 39: {
                        this.m_engine.setSoftKeys(3, 0);
                        this.m_engine.initHelpScreen();
                        this.m_menuState = 2;
                        this.m_redrawHUD = true;
                        break;
                    }
                    case 38: {
                        this.m_engine.setSoftKeys(3, 0);
                        this.m_engine.initAboutScreen();
                        this.m_menuState = 3;
                        this.m_redrawHUD = true;
                    }
                }
                break;
            }
            case 6: {
                if (n2 == 9) {
                    this.m_engine.clearCommandKeys();
                    this.resetRace();
                    this.m_menuState = 0;
                    this.m_redrawHUD = true;
                    this.m_isMenuShowing = false;
                    break;
                }
                if (n2 != 10) break;
                this.m_engine.clearCommandKeys();
                this.m_engine.setSoftKeys(3, 6);
                this.m_menuState = 1;
                this.m_redrawHUD = true;
                break;
            }
            case 5: {
                if (n2 == 9) {
                    this.m_engine.clearCommandKeys();
                    this.m_engine.submitRaceStandings(null);
                    this.m_endScene = true;
                    break;
                }
                if (n2 != 10) break;
                this.m_engine.clearCommandKeys();
                this.m_engine.setSoftKeys(3, 6);
                this.m_menuState = 1;
                this.m_redrawHUD = true;
            }
        }
    }

    private void processKeysPreRace(int n, int n2) {
        switch (this.m_menuState) {
            case 7: {
                if (this.m_loadingProgress < 100 || (n & 0x1020) == 0 && n2 != 4) break;
                this.m_engine.clearKeyBit(4128);
                this.m_engine.clearCommandKeys();
                this.m_engine.initHelpScreen();
                if (this.m_engine.m_rmsTutorialShown) {
                    this.m_menuState = 0;
                    this.m_redrawHUD = true;
                    this.m_isMenuShowing = false;
                    this.m_stat_screen = false;
                    this.m_engine.setSoftKeys(0, 1);
                    break;
                }
                this.m_engine.m_rmsTutorialShown = true;
                this.m_menuState = 8;
                this.m_stat_screen = false;
                break;
            }
            case 8: {
                this.m_engine.processKeysHelpAbout(n, n2);
                if ((n & 0x1020) == 0 && n2 != 4) break;
                this.m_engine.clearKeyBit(4128);
                this.m_engine.clearCommandKeys();
                this.m_menuState = 0;
                this.m_redrawHUD = true;
                this.m_isMenuShowing = false;
                this.m_stat_screen = false;
                this.m_engine.setSoftKeys(0, 1);
            }
        }
    }

    private void processKeysRaceIntro(int n, int n2) {
    }

    private void processKeysDriving(int n, int n2) {
        int n3;
        this.m_engine.overrideKeyStates();
        boolean bl = false;
        if (this.m_crashCutscenePlaying) {
            this.m_isSteeringLeft = false;
            this.m_isSteeringRight = false;
            bl = true;
        } else {
            this.m_isSteeringLeft = (n & 0x8010) != 0;
            boolean bl2 = this.m_isSteeringRight = (n & 0x10040) != 0;
            if (this.m_playerOffTrack && this.m_playerCar.m_speedF > 0x640000) {
                bl = true;
            }
            if ((n & 0x2004) != 0) {
                if (this.m_playerIsBoosting) {
                    this.setPlayerBoosting(false);
                    this.m_HUDBoostBar.startAnim(281, true, false);
                } else if (this.m_timeSinceLastBoost >= 0 && this.m_boostGaugeLevel >= 0x190000) {
                    this.setPlayerBoosting(true);
                    this.m_HUDBoostBar.startAnim(282, true, true);
                }
                this.m_engine.clearKeyBit(8196);
            }
            if ((n3 = this.m_trackSectionCurvature[this.m_playerCar.m_currSection]) != 0 && (n & 0x1020) != 0 && this.m_playerCar.m_speedF >= 0x500000 && !this.m_playerOffTrack) {
                this.startDriftMiniGame();
                this.m_engine.clearKeyBit(4128);
                return;
            }
        }
        if (bl) {
            this.m_playerCar.m_isAccelerating = false;
            if (this.m_playerOffTrack && this.m_playerCar.m_speedF > 0x640000) {
                this.m_playerCar.m_isBraking = false;
                this.m_playerCar.m_isOffTrackBraking = true;
            } else {
                this.m_playerCar.m_isBraking = true;
                this.m_playerCar.m_isOffTrackBraking = false;
            }
        } else {
            n3 = this.m_playerCar.m_speedF > -524288 && this.m_playerCar.m_speedF < 0x1E0000 ? 1 : 0;
            boolean bl3 = !this.m_isSteeringLeft && !this.m_isSteeringRight;
            this.m_playerCar.m_isBraking = (n & 0x4100) != 0;
            this.m_playerCar.m_isOffTrackBraking = false;
            this.m_playerCar.m_isAccelerating = !this.m_playerCar.m_isBraking && (n3 != 0 || bl3);
        }
    }

    public void startBackfireEffect() {
        this.m_playerCar.m_showingSlowdownEffects = true;
        int n = this.getPlayerCarAnimID();
        this.m_slowdownBrakeAnimPlayer.setAnimating(false);
        this.m_slowdownBackfireAnimPlayer.startAnim(EFFECTS_ANIMIDS_BACKFIRE[n], true, false);
    }

    public void startBrakingEffect() {
        this.startBackfireEffect();
        int n = this.getPlayerCarAnimID();
        if (this.m_playerBrakesAnimIDs[n] != -1) {
            this.m_slowdownBrakeAnimPlayer.startAnim(this.m_playerBrakesAnimIDs[n], true, false);
        }
    }

    private void startCrashCutscene() {
        this.m_crashCutscenePlaying = true;
        this.m_crashCutsceneBridgingAnimDone = false;
        this.m_crashCutsceneEndAnimDone = false;
        this.crashCutsceneBeginBridgingAnim();
    }

    private void crashCutsceneBeginBridgingAnim() {
        short s = this.m_playerCarDriftingAngleCurrentF > 0 ? this.m_crashLeftAnimID : this.m_crashRightAnimID;
        this.m_playerCarAnimPlayer.startAnim(s, true, false);
        this.m_engine.vibrate(600);
    }

    private void crashCutsceneBeginFinalAnim() {
        this.m_crashCutsceneBridgingAnimDone = true;
        this.m_crashCutsceneEndAnimDone = false;
    }

    private void crashCutsceneEndFinalAnim() {
        this.m_crashCutsceneEndAnimDone = true;
        this.m_crashCutsceneEndDelay = 0;
        this.m_playerCarAnimPlayer.setAnimating(false);
        this.m_playerCar.m_speedF = 0;
    }

    private void updateCrashCutscene(int n) {
        if (!this.m_crashCutsceneBridgingAnimDone) {
            if (!this.m_playerCarAnimPlayer.isAnimating()) {
                this.crashCutsceneBeginFinalAnim();
            } else {
                this.m_playerCarAnimPlayer.updateAnim(n);
            }
        } else if (!this.m_crashCutsceneEndAnimDone) {
            if (!this.m_playerCarAnimPlayer.isAnimating()) {
                this.crashCutsceneEndFinalAnim();
            } else {
                this.m_playerCarAnimPlayer.updateAnim(n);
            }
        } else if (this.m_crashCutsceneEndDelay < 900) {
            this.m_crashCutsceneEndDelay += n;
        } else {
            this.endCrashCutscene();
        }
    }

    private void endCrashCutscene() {
        this.m_playerCarAnimPlayer.startAnim(this.m_carAnimIDs[this.getPlayerCarAnimID()], true, true);
        this.m_crashCutscenePlaying = false;
        this.m_playerCar.m_lateralPosF = 0;
        this.m_playerCar.m_lateralPosTargetF = 0;
    }

    private void updateSound() {
        SoundManager soundManager = this.m_engine.getSoundManager();
        if (!(this.m_crashCutscenePlaying || soundManager.isSoundPlaying(5) || soundManager.isSoundPlaying(1) || soundManager.isSoundPlaying(0))) {
            if (this.m_driftMiniGameActivated) {
                if (!soundManager.isSoundPlaying(4)) {
                    soundManager.stopAllSounds();
                    soundManager.playSound(4);
                }
            } else if (this.m_playerCar.m_isBraking || this.m_playerCar.getMaximumAllowedGear() < this.m_playerCar.m_numGears - 1) {
                // empty if block
            }
        }
    }

    public void loadingComplete(int n) {
    }

    private void loadAnims() {
    }

    private void updateLoading(int n) {
        ResourceManager resourceManager = this.m_engine.getResourceManager();
        if (this.m_updateLoadingTime <= 0 && this.m_loadingProgress < 100) {
            int n2;
            this.m_engine.hideNotify();
            this.m_engine.showNotify();
            if (this.m_loadingProgress <= 0) {
                int n3;
                long l = 0L;
                this.m_loadMask = 0x800000000000000L;
                switch (this.m_engine.getTrackTheme(this.m_engine.getCurrTrack())) {
                    case 0: {
                        this.m_loadMask |= 0x40L;
                        break;
                    }
                    case 1: {
                        this.m_loadMask |= 0x80L;
                        break;
                    }
                    default: {
                        this.m_loadMask |= 0x100L;
                    }
                }
                byte by = this.m_engine.getPlayerCarIndex();
                this.m_playerBrakesAnimIDs = BRAKES_STD;
                switch (by) {
                    case 1: {
                        this.m_loadMask |= 1L;
                        l = 1024L;
                        this.m_crashLeftAnimID = (short)55;
                        this.m_crashRightAnimID = (short)56;
                        break;
                    }
                    case 2: {
                        this.m_loadMask |= 2L;
                        l = 2048L;
                        this.m_playerBrakesAnimIDs = BRAKES_CHEVY;
                        this.m_crashLeftAnimID = (short)57;
                        this.m_crashRightAnimID = (short)58;
                        break;
                    }
                    case 0: {
                        this.m_loadMask |= 0x10L;
                        l = 16384L;
                        this.m_playerBrakesAnimIDs = BRAKES_CHEVY;
                        this.m_crashLeftAnimID = (short)221;
                        this.m_crashRightAnimID = (short)222;
                        break;
                    }
                    case 4: {
                        this.m_loadMask |= 0x20L;
                        l = 32768L;
                        this.m_playerBrakesAnimIDs = BRAKES_350Z;
                        this.m_crashLeftAnimID = (short)215;
                        this.m_crashRightAnimID = (short)216;
                        break;
                    }
                    case 3: {
                        this.m_loadMask |= 8L;
                        l = 8192L;
                        this.m_crashLeftAnimID = (short)59;
                        this.m_crashRightAnimID = (short)60;
                        break;
                    }
                    case 6: {
                        this.m_loadMask |= 0x10000L;
                        l = 0x4000000L;
                        this.m_playerBrakesAnimIDs = BRAKES_350Z;
                        this.m_crashLeftAnimID = (short)205;
                        this.m_crashRightAnimID = (short)206;
                        break;
                    }
                    case 7: {
                        this.m_loadMask |= 0x20000L;
                        l = 0x8000000L;
                        this.m_crashLeftAnimID = (short)53;
                        this.m_crashRightAnimID = (short)54;
                        break;
                    }
                    case 8: {
                        this.m_loadMask |= 0x40000L;
                        l = 0x10000000L;
                        this.m_crashLeftAnimID = (short)225;
                        this.m_crashRightAnimID = (short)226;
                        break;
                    }
                    case 9: {
                        this.m_loadMask |= 0x80000L;
                        l = 0x20000000L;
                        this.m_crashLeftAnimID = (short)217;
                        this.m_crashRightAnimID = (short)218;
                        break;
                    }
                    case 10: {
                        this.m_loadMask |= 0x100000L;
                        l = 0x40000000L;
                        this.m_crashLeftAnimID = (short)207;
                        this.m_crashRightAnimID = (short)208;
                        break;
                    }
                    case 11: {
                        this.m_loadMask |= 0x200000L;
                        l = Integer.MIN_VALUE;
                        this.m_crashLeftAnimID = (short)209;
                        this.m_crashRightAnimID = (short)210;
                        break;
                    }
                    case 12: {
                        this.m_loadMask |= 0x400000L;
                        l = 0x100000000L;
                        this.m_crashLeftAnimID = (short)213;
                        this.m_crashRightAnimID = (short)214;
                        break;
                    }
                    case 13: {
                        this.m_loadMask |= 0x800000L;
                        l = 0x200000000L;
                        this.m_playerBrakesAnimIDs = BRAKES_SHELBY;
                        this.m_crashLeftAnimID = (short)219;
                        this.m_crashRightAnimID = (short)220;
                        break;
                    }
                    case 14: {
                        this.m_loadMask |= 0x1000000L;
                        l = 0x400000000L;
                        this.m_crashLeftAnimID = (short)223;
                        this.m_crashRightAnimID = (short)224;
                        break;
                    }
                    case 15: {
                        this.m_loadMask |= 0x2000000L;
                        l = 0x800000000L;
                        this.m_crashLeftAnimID = (short)51;
                        this.m_crashRightAnimID = (short)52;
                        break;
                    }
                    default: {
                        this.m_loadMask |= 4L;
                        l = 4096L;
                        this.m_playerBrakesAnimIDs = BRAKES_MUSTANG;
                        this.m_crashLeftAnimID = (short)211;
                        this.m_crashRightAnimID = (short)212;
                    }
                }
                long[] lArray = new long[]{16384L, 1024L, 2048L, 8192L, 32768L, 4096L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L, Integer.MIN_VALUE, 0x100000000L, 0x200000000L, 0x400000000L, 0x800000000L};
                int[] nArray = new int[]{232, 227, 228, 229, 231, 230};
                this.m_loadMask |= 0x200L;
                n2 = 0;
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    if (l != lArray[n3]) continue;
                    n2 = 1;
                    break;
                }
                this.m_opponentCarAnimID = n2 != 0 ? new int[nArray.length - 1] : new int[nArray.length];
                int n4 = 0;
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    if (n2 != 0 && lArray[n3] == l) continue;
                    this.m_opponentCarAnimID[n4++] = n3;
                }
                this.shuffleOpponentCarAnimIDs();
                for (n3 = 0; n3 < 5; ++n3) {
                    this.m_loadMask |= lArray[this.m_opponentCarAnimID[n3]];
                }
                for (n3 = 0; n3 < this.m_opponentCarAnimID.length; ++n3) {
                    this.m_opponentCarAnimID[n3] = nArray[this.m_opponentCarAnimID[n3]];
                }
            }
            int n5 = 0;
            while (n5 < 1 && this.m_loadedAnimImages < this.m_engine.IMAGE_COUNT) {
                int n6 = this.m_loadedAnimImages << 1;
                n2 = (int)AppEngine.IMAGE_IDS[n6 + 0];
                long l = AppEngine.IMAGE_IDS[n6 + 1];
                boolean bl = false;
                if ((l & this.m_loadMask) != 0L) {
                    if (n2 == 29) {
                        this.m_imgTrackPacked = resourceManager.loadImage(n2);
                        if (this.m_imgTrackPacked == null) {
                            bl = true;
                        } else {
                            ++n5;
                        }
                    } else if (n2 == 27 || n2 == 26 || n2 == 28) {
                        this.m_imgSkyline = resourceManager.loadImage(n2);
                        if (this.m_imgSkyline == null) {
                            bl = true;
                        } else {
                            ++n5;
                        }
                    } else if (n2 == 21 || n2 == 23 || n2 == 17) {
                        this.m_imgGrassDark = resourceManager.loadImage(n2);
                        if (this.m_imgGrassDark == null) {
                            bl = true;
                        } else {
                            ++n5;
                        }
                    } else if (n2 == 22 || n2 == 24 || n2 == 18) {
                        this.m_imgGrassLight = resourceManager.loadImage(n2);
                        if (this.m_imgGrassLight == null) {
                            bl = true;
                        } else {
                            ++n5;
                        }
                    } else if (this.m_engine.getAnimationManager().loadImage(resourceManager, n2)) {
                        ++n5;
                    } else {
                        bl = true;
                    }
                }
                if (!bl) {
                    ++this.m_loadedAnimImages;
                }
                this.m_loadingProgress = 0 + 98 * (n5 + this.m_loadedAnimImages) / this.m_engine.IMAGE_COUNT;
            }
            if (this.m_loadingProgress < 98) {
                this.m_updateLoadingTime = 64;
            } else {
                this.m_updateLoadingTime = Integer.MAX_VALUE;
                this.m_playerImpactSparkAnimPlayer = this.m_engine.getAnimationManager().createAnimPlayer();
                this.m_playerCarAnimPlayer = this.m_engine.getAnimationManager().createAnimPlayer();
                this.m_playerCarAnimPlayer.startAnim(141, true, true);
                this.m_boostAnimPlayer = this.m_engine.getAnimationManager().createAnimPlayer();
                this.m_boostAnimPlayer.startAnim(293, true, true);
                this.m_HUDBoostBar = this.m_engine.getAnimationManager().createAnimPlayer();
                this.m_HUDBoostBar.startAnim(281, true, false);
                this.m_smokeLeftAnimPlayer = this.m_engine.getAnimationManager().createAnimPlayer();
                this.m_smokeRightAnimPlayer = this.m_engine.getAnimationManager().createAnimPlayer();
                this.m_speedlinesAnimPlayer = this.m_engine.getAnimationManager().createAnimPlayer();
                this.m_highlightPlayer = this.m_engine.getAnimationManager().createAnimPlayer();
                this.changeSkyColour();
                this.m_loadingProgress = 100;
                this.m_engine.getResourceManager().nullifyPNGscaleBuffer();
                this.m_stat_screen = true;
                this.m_engine.setSoftKeys(0, 4);
            }
        } else {
            this.m_updateLoadingTime -= n;
        }
    }

    private void updateAnims(int n) {
        if (this.m_crashCutscenePlaying) {
            this.updateCrashCutscene(n);
        } else if (!this.m_playerCar.m_finishedRace || this.m_playerCar.m_speedF != 0) {
            this.m_playerCarAnimPlayer.updateAnim(n);
        }
        if (this.m_playerIsBoosting) {
            this.m_boostAnimPlayer.updateAnim(n);
        }
        this.m_HUDBoostBar.updateAnim(n);
        if (this.m_playerImpactSparkAnimPlayer.isAnimating()) {
            this.m_playerImpactSparkAnimPlayer.updateAnim(n);
        }
        if (this.m_smokeLeftAnimPlayer.isAnimating()) {
            this.m_smokeLeftAnimPlayer.updateAnim(n);
        }
        if (this.m_smokeRightAnimPlayer.isAnimating()) {
            this.m_smokeRightAnimPlayer.updateAnim(n);
        }
        if (this.m_speedlinesAnimPlayer.isAnimating()) {
            this.m_speedlinesAnimPlayer.updateAnim(n);
        }
        if (this.m_highlightPlayer.isAnimating() && this.m_playerCar.m_speedF > 0) {
            this.m_highlightPlayer.updateAnim(MathExt.Fmul(this.m_playerCar.getSpeedFactor(), n << 16) >> 14);
        }
    }

    private void loadTrack(int n) {
        int n2;
        int n3;
        DataInputStream dataInputStream;
        InputStream inputStream;
        int n4 = this.m_engine.getTrackDataResID(n);
        try {
            inputStream = this.m_engine.getResourceManager().loadBinaryFile(this.m_engine.getTrackDataResID(n));
            dataInputStream = new DataInputStream(inputStream);
            this.m_trackNumSections = dataInputStream.readShort();
            dataInputStream.close();
        }
        catch (IOException iOException) {
            return;
        }
        AppEngine.tryDefragMemory(20);
        this.m_trackSectionCurvature = new int[this.m_trackNumSections];
        this.m_trackSectionAbsStart = new int[this.m_trackNumSections];
        this.m_trackSectionAbsEnd = new int[this.m_trackNumSections];
        this.m_trackSectionLength = new int[this.m_trackNumSections];
        this.m_trackSectionLengthInvF = new int[this.m_trackNumSections];
        this.m_trackSectionAvgSpeedsInvF = new int[this.m_trackNumSections];
        this.m_trackSectionSlope = new int[this.m_trackNumSections];
        try {
            inputStream = this.m_engine.getResourceManager().loadBinaryFile(this.m_engine.getTrackDataResID(n));
            dataInputStream = new DataInputStream(inputStream);
            dataInputStream.skipBytes(2);
            for (n3 = 0; n3 < this.m_trackNumSections; ++n3) {
                this.m_trackSectionLength[n3] = dataInputStream.readInt();
                this.m_trackSectionCurvature[n3] = dataInputStream.readInt();
                this.m_trackSectionSlope[n3] = dataInputStream.readInt();
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            return;
        }
        AppEngine.tryDefragMemory(20);
        for (n2 = 0; n2 < this.m_trackNumSections; ++n2) {
            int n5 = n2;
            this.m_trackSectionLength[n5] = this.m_trackSectionLength[n5] * 1;
            this.m_trackSectionAbsStart[n2] = n2 == 0 ? 0 : this.m_trackSectionAbsEnd[n2 - 1];
            this.m_trackSectionAbsEnd[n2] = this.m_trackSectionAbsStart[n2] + this.m_trackSectionLength[n2];
        }
        this.m_trackTotalDistance = this.m_trackSectionAbsEnd[this.m_trackNumSections - 1];
        this.m_engine.setLastTrackLength(this.m_trackTotalDistance);
        for (n2 = 0; n2 < this.m_trackNumSections; ++n2) {
            this.m_trackSectionLengthInvF[n2] = MathExt.Fdiv(65536, this.m_trackSectionLength[n2] << 16);
            int n6 = this.m_trackSectionCurvature[n2];
            if (n6 == 0) continue;
            n3 = this.getIdealGearForBend(n6);
            int n7 = this.m_engine.getCarNowRacingGearMaxSpeedData()[n3];
            this.m_trackSectionAvgSpeedsInvF[n2] = MathExt.Fdiv(65536, n7);
        }
    }

    private int calcBendFactor() {
        int n = 0;
        int n2 = 400;
        int n3 = this.m_viewPosF + 32768 >> 16;
        int n4 = this.m_viewSection;
        while (this.m_trackSectionAbsEnd[n4] - n3 < n2) {
            n2 -= this.m_trackSectionAbsEnd[n4] - n3;
            n += this.m_trackSectionCurvature[n4] * (this.m_trackSectionAbsEnd[n4] - n3);
            n3 += this.m_trackSectionAbsEnd[n4] - n3;
            if (++n4 < this.m_trackNumSections) continue;
            n4 -= this.m_trackNumSections;
            n3 -= this.m_trackTotalDistance;
        }
        return n += this.m_trackSectionCurvature[n4] * n2;
    }

    private void updateSteering(int n) {
        int n2;
        int n3 = this.m_playerSteeringMaxF;
        if (this.m_slipstreaming && this.m_slipstreamTimer >= 65536) {
            n2 = this.getCarZDist(this.m_slipstreamingCar);
            this.m_showSlipstreamTouchySteering = n2 < 0x640000;
        }
        if (this.m_isSteeringLeft) {
            n2 = MathExt.Fmul(this.m_playerSteeringIncF, n);
            if (this.m_slipstreaming && this.m_showSlipstreamTouchySteering) {
                n2 <<= 3;
            }
            this.m_playerSteeringAngleF -= n2;
            if (this.m_playerSteeringAngleF < -n3) {
                this.m_playerSteeringAngleF = -n3;
            }
        }
        if (this.m_isSteeringRight) {
            n2 = MathExt.Fmul(this.m_playerSteeringIncF, n);
            if (this.m_slipstreaming && this.m_showSlipstreamTouchySteering) {
                n2 <<= 3;
            }
            this.m_playerSteeringAngleF += n2;
            if (this.m_playerSteeringAngleF > n3) {
                this.m_playerSteeringAngleF = n3;
            }
        }
        if (!this.m_isSteeringLeft && !this.m_isSteeringRight) {
            if (this.m_playerSteeringAngleF > 0) {
                this.m_playerSteeringAngleF -= MathExt.Fmul(this.m_playerSteeringRecentreIncF, n);
                if (this.m_playerSteeringAngleF < 0) {
                    this.m_playerSteeringAngleF = 0;
                }
            } else if (this.m_playerSteeringAngleF < 0) {
                this.m_playerSteeringAngleF += MathExt.Fmul(this.m_playerSteeringRecentreIncF, n);
                if (this.m_playerSteeringAngleF > 0) {
                    this.m_playerSteeringAngleF = 0;
                }
            }
        }
        if (this.m_playerCar.m_speedF > -524288 && this.m_playerCar.m_speedF < 0x1E0000) {
            this.m_playerSteeringAngleF = 0;
        }
    }

    public void setPlayerBoosting(boolean bl) {
        if (bl && this.m_playerBoostTimeF > 0) {
            this.m_playerIsBoosting = true;
            if (this.m_bonusNitroBoostTimer <= 0) {
                this.m_cameraShakeXAmplitudeF = m_cameraShakeXAmplitudeInitialF;
            }
            this.m_HUDBoostBar.startAnim(282, true, true);
            if (!this.m_playerCar.isMaximumGearAllowed()) {
                this.m_playerCar.setMaximumAllowedGear();
            }
        } else {
            this.m_playerIsBoosting = false;
            this.m_bonusNitroBoostTimer = 0;
            this.m_playerBoostTimeF = 196608;
            this.m_HUDBoostBar.startAnim(281, true, false);
        }
        this.m_playerCar.setBoosting(this.m_playerIsBoosting);
    }

    private void updateCityScroll(int n) {
        if (this.m_currBendFactor != 0 && this.m_playerCar.m_speedF > 0) {
            int n2 = MathExt.Fmul(this.m_currBendFactor << 13, this.m_playerCar.getSpeedFactor());
            this.m_renderCityOffsetXF += MathExt.Fmul(n2, n);
        }
        this.m_renderCityOffsetXF += MathExt.Fmul(this.m_playerUpdateSteeringF << 8, n);
        while (this.m_renderCityOffsetXF < 0) {
            this.m_renderCityOffsetXF += this.m_imgSkyline.getWidth() << 16;
        }
        while (this.m_renderCityOffsetXF >= this.m_imgSkyline.getWidth()) {
            this.m_renderCityOffsetXF -= this.m_imgSkyline.getWidth() << 16;
        }
    }

    private void setCarParameters() {
        this.m_playerSteeringRecentreIncF = this.m_engine.getCarNowRacingParamSteeringRecentreInc();
        this.m_playerSteeringIncF = this.m_engine.getCarNowRacingParamSteeringInc();
        this.m_playerSteeringMaxF = this.m_engine.getCarNowRacingParamSteeringMax();
        this.m_playerTyresF = this.m_engine.getCarNowRacingParamTyres();
        this.m_playerTyresInvF = MathExt.Fdiv(65536, this.m_playerTyresF);
        this.m_playerBoostRestoreRateF = MathExt.Fmul(this.m_engine.getCarNowRacingNitroRechargeRate(), 37500);
        for (int i = 0; i < this.m_carsTrackOrder.length; ++i) {
            GameObject gameObject = this.m_carsTrackOrder[i];
            gameObject.setNumGears(this.m_engine.getCarNumGears());
            gameObject.setGearAccelData(this.m_engine.getCarNowRacingGearAccelData());
            gameObject.setGearMinSpeedData(this.m_engine.getCarNowRacingGearMinSpeedData());
            gameObject.setGearMaxSpeedData(this.m_engine.getCarNowRacingGearMaxSpeedData());
            gameObject.m_isAutoTransmission = i == 0 ? this.m_playerCarAuto : true;
        }
    }

    private void startRaceIntro() {
        for (int i = 0; i < this.m_carsTrackOrder.length; ++i) {
            this.m_carsTrackOrder[i].m_isAccelerating = false;
        }
        this.m_raceIntroDone = false;
        this.m_raceIntroCameraDone = false;
        this.m_raceIntroCount = 3;
        this.m_redrawHUD = true;
        this.startNextIntroStage();
    }

    private void updateRaceIntro(int n) {
        if (this.m_raceIntroCount == 3) {
            this.m_lightsOffsetY += 6000 * n;
            if (this.m_lightsOffsetY > -1572864) {
                this.m_lightsOffsetY = -1572864;
            }
        }
        this.m_raceIntroTotalTime += n;
        if (this.m_raceIntroTotalTime < 2000) {
            this.m_raceIntroCameraOffsetF = MathExt.Fmul(this.m_raceIntroCameraDivF, this.m_raceIntroTotalTime << 16);
        } else {
            this.m_raceIntroCameraDone = true;
            this.m_raceIntroCameraOffsetF = 0;
        }
        this.m_raceIntroTimer -= n;
        if (this.m_raceIntroTimer <= 0) {
            if (--this.m_raceIntroCount < 0) {
                this.endRaceIntro();
                this.startRace();
            } else {
                this.startNextIntroStage();
            }
        }
    }

    private void endRaceIntro() {
        this.m_raceIntroDone = true;
    }

    private void startNextIntroStage() {
        this.m_raceIntroTimer = 1500;
        if (this.m_menuState == 0) {
            SoundManager soundManager = this.m_engine.getSoundManager();
            if (this.m_raceIntroCount > 0) {
                soundManager.stopAllSounds();
                soundManager.freeSound(1);
                soundManager.freeSound(0);
                soundManager.loadSound(0, 1, 99);
                soundManager.playSound(0);
            } else {
                soundManager.stopAllSounds();
                soundManager.freeSound(0);
                soundManager.loadSound(1, 1, 99);
                soundManager.playSound(1);
            }
        }
    }

    private void startRace() {
        this.m_takeOffSmokeTimer = 500;
        this.m_boostDelay = 5000;
        for (int i = 0; i < this.m_carsTrackOrder.length; ++i) {
            this.m_carsTrackOrder[i].m_isAccelerating = true;
        }
    }

    private void initCar() {
        int n;
        int n2;
        this.setCarParameters();
        this.m_playerSteeringAngleF = 0;
        this.m_playerLateralSteerMaxF = 131072;
        this.m_carAnimIDs = new int[9];
        byte by = this.m_engine.getPlayerCarIndex();
        switch (by) {
            case 1: {
                this.m_carAnimIDs[0] = 82;
                this.m_carAnimIDs[1] = 81;
                this.m_carAnimIDs[2] = 80;
                this.m_carAnimIDs[3] = 79;
                this.m_carAnimIDs[4] = 87;
                this.m_carAnimIDs[5] = 83;
                this.m_carAnimIDs[6] = 84;
                this.m_carAnimIDs[7] = 85;
                this.m_carAnimIDs[8] = 86;
                break;
            }
            case 2: {
                this.m_carAnimIDs[0] = 91;
                this.m_carAnimIDs[1] = 90;
                this.m_carAnimIDs[2] = 89;
                this.m_carAnimIDs[3] = 88;
                this.m_carAnimIDs[4] = 96;
                this.m_carAnimIDs[5] = 92;
                this.m_carAnimIDs[6] = 93;
                this.m_carAnimIDs[7] = 94;
                this.m_carAnimIDs[8] = 95;
                break;
            }
            case 0: {
                this.m_carAnimIDs[0] = 181;
                this.m_carAnimIDs[1] = 180;
                this.m_carAnimIDs[2] = 179;
                this.m_carAnimIDs[3] = 178;
                this.m_carAnimIDs[4] = 186;
                this.m_carAnimIDs[5] = 182;
                this.m_carAnimIDs[6] = 183;
                this.m_carAnimIDs[7] = 184;
                this.m_carAnimIDs[8] = 185;
                break;
            }
            case 3: {
                this.m_carAnimIDs[0] = 100;
                this.m_carAnimIDs[1] = 99;
                this.m_carAnimIDs[2] = 98;
                this.m_carAnimIDs[3] = 97;
                this.m_carAnimIDs[4] = 105;
                this.m_carAnimIDs[5] = 101;
                this.m_carAnimIDs[6] = 102;
                this.m_carAnimIDs[7] = 103;
                this.m_carAnimIDs[8] = 104;
                break;
            }
            case 4: {
                this.m_carAnimIDs[0] = 154;
                this.m_carAnimIDs[1] = 153;
                this.m_carAnimIDs[2] = 152;
                this.m_carAnimIDs[3] = 151;
                this.m_carAnimIDs[4] = 159;
                this.m_carAnimIDs[5] = 155;
                this.m_carAnimIDs[6] = 156;
                this.m_carAnimIDs[7] = 157;
                this.m_carAnimIDs[8] = 158;
                break;
            }
            case 6: {
                this.m_carAnimIDs[0] = 109;
                this.m_carAnimIDs[1] = 108;
                this.m_carAnimIDs[2] = 107;
                this.m_carAnimIDs[3] = 106;
                this.m_carAnimIDs[4] = 114;
                this.m_carAnimIDs[5] = 110;
                this.m_carAnimIDs[6] = 111;
                this.m_carAnimIDs[7] = 112;
                this.m_carAnimIDs[8] = 113;
                break;
            }
            case 7: {
                this.m_carAnimIDs[0] = 73;
                this.m_carAnimIDs[1] = 72;
                this.m_carAnimIDs[2] = 71;
                this.m_carAnimIDs[3] = 70;
                this.m_carAnimIDs[4] = 78;
                this.m_carAnimIDs[5] = 74;
                this.m_carAnimIDs[6] = 75;
                this.m_carAnimIDs[7] = 76;
                this.m_carAnimIDs[8] = 77;
                break;
            }
            case 8: {
                this.m_carAnimIDs[0] = 199;
                this.m_carAnimIDs[1] = 198;
                this.m_carAnimIDs[2] = 197;
                this.m_carAnimIDs[3] = 196;
                this.m_carAnimIDs[4] = 204;
                this.m_carAnimIDs[5] = 200;
                this.m_carAnimIDs[6] = 201;
                this.m_carAnimIDs[7] = 202;
                this.m_carAnimIDs[8] = 203;
                break;
            }
            case 9: {
                this.m_carAnimIDs[0] = 163;
                this.m_carAnimIDs[1] = 162;
                this.m_carAnimIDs[2] = 161;
                this.m_carAnimIDs[3] = 160;
                this.m_carAnimIDs[4] = 168;
                this.m_carAnimIDs[5] = 164;
                this.m_carAnimIDs[6] = 165;
                this.m_carAnimIDs[7] = 166;
                this.m_carAnimIDs[8] = 167;
                break;
            }
            case 10: {
                this.m_carAnimIDs[0] = 118;
                this.m_carAnimIDs[1] = 117;
                this.m_carAnimIDs[2] = 116;
                this.m_carAnimIDs[3] = 115;
                this.m_carAnimIDs[4] = 123;
                this.m_carAnimIDs[5] = 119;
                this.m_carAnimIDs[6] = 120;
                this.m_carAnimIDs[7] = 121;
                this.m_carAnimIDs[8] = 122;
                break;
            }
            case 11: {
                this.m_carAnimIDs[0] = 127;
                this.m_carAnimIDs[1] = 126;
                this.m_carAnimIDs[2] = 125;
                this.m_carAnimIDs[3] = 124;
                this.m_carAnimIDs[4] = 132;
                this.m_carAnimIDs[5] = 128;
                this.m_carAnimIDs[6] = 129;
                this.m_carAnimIDs[7] = 130;
                this.m_carAnimIDs[8] = 131;
                break;
            }
            case 12: {
                this.m_carAnimIDs[0] = 145;
                this.m_carAnimIDs[1] = 144;
                this.m_carAnimIDs[2] = 143;
                this.m_carAnimIDs[3] = 142;
                this.m_carAnimIDs[4] = 150;
                this.m_carAnimIDs[5] = 146;
                this.m_carAnimIDs[6] = 147;
                this.m_carAnimIDs[7] = 148;
                this.m_carAnimIDs[8] = 149;
                break;
            }
            case 13: {
                this.m_carAnimIDs[0] = 172;
                this.m_carAnimIDs[1] = 171;
                this.m_carAnimIDs[2] = 170;
                this.m_carAnimIDs[3] = 169;
                this.m_carAnimIDs[4] = 177;
                this.m_carAnimIDs[5] = 173;
                this.m_carAnimIDs[6] = 174;
                this.m_carAnimIDs[7] = 175;
                this.m_carAnimIDs[8] = 176;
                break;
            }
            case 14: {
                this.m_carAnimIDs[0] = 190;
                this.m_carAnimIDs[1] = 189;
                this.m_carAnimIDs[2] = 188;
                this.m_carAnimIDs[3] = 187;
                this.m_carAnimIDs[4] = 195;
                this.m_carAnimIDs[5] = 191;
                this.m_carAnimIDs[6] = 192;
                this.m_carAnimIDs[7] = 193;
                this.m_carAnimIDs[8] = 194;
                break;
            }
            case 15: {
                this.m_carAnimIDs[0] = 64;
                this.m_carAnimIDs[1] = 63;
                this.m_carAnimIDs[2] = 62;
                this.m_carAnimIDs[3] = 61;
                this.m_carAnimIDs[4] = 69;
                this.m_carAnimIDs[5] = 65;
                this.m_carAnimIDs[6] = 66;
                this.m_carAnimIDs[7] = 67;
                this.m_carAnimIDs[8] = 68;
                break;
            }
            default: {
                this.m_carAnimIDs[0] = 136;
                this.m_carAnimIDs[1] = 135;
                this.m_carAnimIDs[2] = 134;
                this.m_carAnimIDs[3] = 133;
                this.m_carAnimIDs[4] = 141;
                this.m_carAnimIDs[5] = 137;
                this.m_carAnimIDs[6] = 138;
                this.m_carAnimIDs[7] = 139;
                this.m_carAnimIDs[8] = 140;
            }
        }
        this.m_boostAnimIDs = new int[9];
        this.m_boostAnimIDs[0] = 288;
        this.m_boostAnimIDs[1] = 287;
        this.m_boostAnimIDs[2] = 286;
        this.m_boostAnimIDs[3] = 285;
        this.m_boostAnimIDs[4] = 293;
        this.m_boostAnimIDs[5] = 289;
        this.m_boostAnimIDs[6] = 290;
        this.m_boostAnimIDs[7] = 291;
        this.m_boostAnimIDs[8] = 292;
        this.m_carAngleLimit01F = n2 = this.m_playerSteeringMaxF / 15;
        this.m_carAngleLimit02F = this.m_carAngleLimit01F + (n2 << 1);
        this.m_carAngleLimit03F = this.m_carAngleLimit02F + (n2 << 2);
        this.m_carAngleLimit04F = this.m_carAngleLimit03F + (n2 << 2);
        this.m_playerCarCollisionPushDiv = MathExt.Fdiv(65536, MathExt.Fmul(this.m_playerCar.getGearMaxSpeed(5), 32768));
        this.m_playerCarLowRevSpeedsF = new int[this.m_engine.getCarNumGears()];
        this.m_playerCarLowRevSpeedsF[0] = 0;
        this.m_playerCarLowRevSpeedsF[1] = 0;
        for (n = 2; n < this.m_playerCarLowRevSpeedsF.length; ++n) {
            this.m_playerCarLowRevSpeedsF[n] = this.m_playerCar.getGearMaxSpeed(n - 2);
        }
        this.m_playerCarRevDivsF = new int[this.m_engine.getCarNumGears()];
        for (n = 0; n < this.m_playerCarRevDivsF.length; ++n) {
            this.m_playerCarRevDivsF[n] = MathExt.Fdiv(65536, this.m_playerCar.getGearMaxSpeed(n) - this.m_playerCarLowRevSpeedsF[n]);
        }
        this.m_playerCarMinDriftBendSpeed = this.m_playerCar.getGearMaxSpeed(1);
        this.m_playerCarMaxDriftBendSpeed = this.m_playerCar.getMaxBoostSpeed();
        this.m_playerCarDriftBendSpeedDiv = MathExt.Fdiv(65536, this.m_playerCarMaxDriftBendSpeed - this.m_playerCarMinDriftBendSpeed);
        this.m_carCollisionLengthsF = new int[9];
        this.m_carCollisionWidthsF = new int[9];
        this.m_carCollisionLengthsF[0] = 458752;
        this.m_carCollisionLengthsF[1] = 458752;
        this.m_carCollisionLengthsF[2] = 458752;
        this.m_carCollisionLengthsF[3] = 458752;
        this.m_carCollisionLengthsF[4] = 458752;
        this.m_carCollisionLengthsF[5] = 458752;
        this.m_carCollisionLengthsF[6] = 458752;
        this.m_carCollisionLengthsF[7] = 458752;
        this.m_carCollisionLengthsF[8] = 458752;
        this.m_carCollisionWidthsF[0] = 9830;
        this.m_carCollisionWidthsF[1] = 9830;
        this.m_carCollisionWidthsF[2] = 9830;
        this.m_carCollisionWidthsF[3] = 9830;
        this.m_carCollisionWidthsF[4] = 9830;
        this.m_carCollisionWidthsF[5] = 9830;
        this.m_carCollisionWidthsF[6] = 9830;
        this.m_carCollisionWidthsF[7] = 9830;
        this.m_carCollisionWidthsF[8] = 9830;
    }

    private int getAnimIDIndexFromAngle(int n) {
        if (this.m_trackSectionCurvature[this.m_playerCar.m_currSection] == 0) {
            return 4;
        }
        if (n < -this.m_carAngleLimit04F) {
            return 0;
        }
        if (n < -this.m_carAngleLimit03F) {
            return 1;
        }
        if (n < -this.m_carAngleLimit02F) {
            return 2;
        }
        if (n < -this.m_carAngleLimit01F) {
            return 3;
        }
        if (n <= this.m_carAngleLimit01F) {
            return 4;
        }
        if (n <= this.m_carAngleLimit02F) {
            return 5;
        }
        if (n <= this.m_carAngleLimit03F) {
            return 6;
        }
        if (n <= this.m_carAngleLimit04F) {
            return 7;
        }
        return 8;
    }

    public void updateLateralPos(int n) {
        int n2;
        int n3;
        int n4;
        this.m_playerUpdateSteeringF = 0;
        if (!this.m_driftMiniGameActivated) {
            n4 = MathExt.Fsin(this.m_playerSteeringAngleF);
            n4 = MathExt.Fmul(n4, this.m_playerLateralSteerMaxF);
            n3 = MathExt.Fmul(32768, this.m_playerCar.getSpeedFactor());
            n2 = MathExt.Fmul(65536 - n3, n4);
            this.m_playerUpdateSteeringF = MathExt.Fmul(n2, n);
        }
        n4 = MathExt.Fmul(this.getLateralDrift(), n);
        if (this.m_driftMiniGameActivated) {
            n4 = 0;
        }
        n3 = this.m_trackSectionCurvature[this.m_playerCar.m_currSection];
        if (!this.m_driftMiniGameActivated && n3 < 0 && !this.m_isSteeringLeft || n3 > 0 && !this.m_isSteeringRight) {
            n4 = MathExt.Fmul(n4, 58982);
        }
        n2 = this.m_playerCarInInsideLane ? 1 : 0;
        this.m_playerCarInInsideLane = false;
        if (n3 != 0) {
            if (this.m_playerOffTrack) {
                this.m_playerLatPos1CornerTime = 0;
                this.m_playerLatPos2CornerTime = 0;
                this.m_playerLatPos3CornerTime = 0;
                this.m_playerLatPos4CornerTime = 0;
            } else if (this.m_lateralPosFactorF < 16384) {
                this.m_playerLatPos1CornerTime += n;
            } else if (this.m_lateralPosFactorF < 32768) {
                this.m_playerLatPos2CornerTime += n;
            } else if (this.m_lateralPosFactorF < 49152) {
                this.m_playerLatPos3CornerTime += n;
            } else {
                this.m_playerLatPos4CornerTime += n;
                this.m_playerCarInInsideLane = true;
            }
        }
        if (!this.m_playerCarInInsideLane && n2 != 0) {
            this.m_insideCornerLineSustainTimer = this.m_playerLatPos4CornerTime;
        } else if (!this.m_playerCarInInsideLane && this.m_insideCornerLineSustainTimer > 0) {
            this.m_insideCornerLineSustainTimer -= n;
        }
        if (this.m_playerCarLateralDriftF < n4) {
            this.m_playerCarLateralDriftF += MathExt.Fmul(8192, n);
            if (this.m_playerCarLateralDriftF > n4) {
                this.m_playerCarLateralDriftF = n4;
            }
        } else if (this.m_playerCarLateralDriftF > n4) {
            this.m_playerCarLateralDriftF -= MathExt.Fmul(8192, n);
            if (this.m_playerCarLateralDriftF < n4) {
                this.m_playerCarLateralDriftF = n4;
            }
        }
        this.m_playerCar.m_lateralPosF += this.m_playerUpdateSteeringF;
        this.m_playerCar.m_lateralPosF += this.m_playerCarLateralDriftF;
        if (this.m_playerCar.m_lateralPosF > 91750) {
            this.m_playerCar.m_lateralPosF = 91750;
        } else if (this.m_playerCar.m_lateralPosF < -91750) {
            this.m_playerCar.m_lateralPosF = -91750;
        }
        boolean bl = this.m_playerOffTrack = this.m_playerCar.m_lateralPosF < -65536 || this.m_playerCar.m_lateralPosF > 65536;
        if (this.m_playerOffTrack && this.m_driftMiniGameActivated) {
            this.m_chainedDriftComboCount = 1;
            this.cancelDriftMiniGame();
            this.startCrashCutscene();
        }
        if (this.m_playerCarDriftDiffFactorF < this.m_playerCarDriftDiffTargetF) {
            this.m_playerCarDriftDiffFactorF += MathExt.Fmul(8096, n);
            if (this.m_playerCarDriftDiffFactorF > this.m_playerCarDriftDiffTargetF) {
                this.m_playerCarDriftDiffFactorF = this.m_playerCarDriftDiffTargetF;
            }
        } else if (this.m_playerCarDriftDiffFactorF > this.m_playerCarDriftDiffTargetF) {
            this.m_playerCarDriftDiffFactorF -= MathExt.Fmul(8096, n);
            if (this.m_playerCarDriftDiffFactorF < this.m_playerCarDriftDiffTargetF) {
                this.m_playerCarDriftDiffFactorF = this.m_playerCarDriftDiffTargetF;
            }
        }
    }

    private void calcTrackBendOffsets() {
        int n = this.m_currBendFactor;
        for (int i = 0; i < 83; ++i) {
            this.m_trackBendOffsets[i] = n >> 4;
            n = (n >> 1) + (n >> 2) + (n >> 3);
        }
    }

    private void renderCity(Graphics graphics) {
        int n;
        int n2;
        int n3 = this.m_imgSkyline.getHeight();
        int n4 = VIEWPORT_TOP + TRACK_VIEWPORT_HEIGHT - 83;
        n4 += MathExt.Fmul(this.m_playerCarSlopeCurr - 65536, 0x200000) + 32768 >> 16;
        int n5 = 0;
        for (n2 = 0; n2 < this.m_numSlopeSections; ++n2) {
            if (this.m_slopeDestYs[n2] <= n5) continue;
            n5 = this.m_slopeDestYs[n2];
        }
        if (n4 < TRACK_VIEWPORT_HEIGHT - n5) {
            n4 = TRACK_VIEWPORT_HEIGHT - n5;
        }
        if ((n2 = n4 - n3) > 0) {
            graphics.setColor(this.m_skylineColourR, this.m_skylineColourG, this.m_skylineColourB);
            graphics.fillRect(VIEWPORT_LEFT, VIEWPORT_TOP, VIEWPORT_WIDTH, n2 - VIEWPORT_TOP);
        }
        for (n = (this.m_renderCityOffsetXF >> 16) - this.m_cameraShakeX; n < 0; n += this.m_imgSkyline.getWidth()) {
        }
        while (n >= this.m_imgSkyline.getWidth()) {
            n -= this.m_imgSkyline.getWidth();
        }
        graphics.drawRegion(this.m_imgSkyline, n, 0, this.m_imgSkyline.getWidth() - n, n3, 0, 0, n2, 20);
        if (n > 0) {
            graphics.drawRegion(this.m_imgSkyline, 0, 0, n, n3, 0, this.m_imgSkyline.getWidth() - n, n2, 20);
        }
    }

    private void initPerspectiveRanges() {
        this.m_perspectiveRangesF = new int[83];
        for (int i = 0; i < 83; ++i) {
            this.m_perspectiveRangesF[82 - i] = MathExt.powerF(70444, i + 1) - 65536;
        }
    }

    private int getFurthestVisibileStaticObjTrackOrder() {
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < this.m_staticTrackObjects.length; ++i) {
            int n3 = this.calcDistance(this.m_viewPosF, this.m_staticTrackObjects[i].m_trackPosF);
            if (n3 > this.m_perspectiveRangesF[0] || n3 < n) continue;
            n = n3;
            n2 = i;
        }
        return n2;
    }

    private int getOpponentCarFrameFromDistance(int n) {
        if (n > 340) {
            return 0;
        }
        if (n > 189) {
            return 1;
        }
        if (n > 105) {
            return 2;
        }
        if (n > 58) {
            return 3;
        }
        if (n > 32) {
            return 4;
        }
        if (n > 18) {
            return 5;
        }
        if (n > 10) {
            return 6;
        }
        return 7;
    }

    private void changeSkyColour() {
        int[] nArray = new int[1];
        this.m_imgSkyline.getRGB(nArray, 0, 1, 0, 0, 1, 1);
        this.m_skylineColourR = (nArray[0] & 0xFF0000) >> 16;
        this.m_skylineColourG = (nArray[0] & 0xFF00) >> 8;
        this.m_skylineColourB = nArray[0] & 0xFF;
    }

    private void initGrassOffsets() {
        this.m_grassOffsets = new int[83];
        for (int i = 0; i < 83; ++i) {
            this.m_grassOffsets[i] = this.m_engine.rand(0, 100);
        }
    }

    private void initOpponentCars() {
        int n = MathExt.Fdiv(12499, this.m_numOpponentCars << 16);
        this.m_opponentCars = new GameObject[this.m_numOpponentCars];
        for (int i = 0; i < this.m_numOpponentCars; ++i) {
            GameObject gameObject = new GameObject();
            gameObject.m_trackPosF = this.getCarStartingPosF(i);
            gameObject.m_currSection = this.getTrackSectionForTrackPos(gameObject.m_trackPosF);
            gameObject.m_nextSection = gameObject.m_currSection + 1;
            if (gameObject.m_nextSection >= this.m_trackNumSections) {
                gameObject.m_nextSection = 0;
            }
            gameObject.m_lateralPosF = (i & 1) == 1 ? 39322 : -39322;
            gameObject.m_lateralPosTargetF = gameObject.m_lateralPosF;
            gameObject.setType(2);
            gameObject.m_ID = i;
            gameObject.m_speedF = 0;
            gameObject.m_difficultyMult = 52250 + MathExt.Fmul(this.m_numOpponentCars - 1 - i << 16, n);
            gameObject.m_mood = this.getRandomAIMood();
            gameObject.m_AITimeF = MathExt.Fdiv(i << 16, this.m_numOpponentCars << 15) - (this.m_engine.rand(3, 12) << 16);
            gameObject.m_catchupCodeMultCurrF = 86508;
            gameObject.m_opponentAnimIDIndex = this.m_engine.rand(0, 4);
            this.m_opponentCars[i] = gameObject;
        }
    }

    private int getTrackSectionForTrackPos(int n) {
        int n2 = 0;
        for (int i = 0; i < this.m_trackNumSections; ++i) {
            if ((n2 += this.m_trackSectionLength[i]) <= n) continue;
            return i;
        }
        return 0;
    }

    private int getCarStartingPosF(int n) {
        return this.m_trackTotalDistance - (n & 0xFFFFFFFE) * 40 + (n & 1) * 10 << 16;
    }

    private void debugOpponentCars() {
        for (int i = 0; i < this.m_opponentCars.length; ++i) {
            this.m_opponentCars[i].debugPrint();
        }
    }

    private void initPlayerCar() {
        this.m_playerCar = new GameObject(this);
        this.m_playerCar.m_lateralPosF = 0;
        this.m_playerCar.m_trackPosF = this.getCarStartingPosF(this.m_numOpponentCars);
        this.m_playerCar.m_currSection = this.getTrackSectionForTrackPos(this.m_playerCar.m_trackPosF);
        this.m_playerCar.m_nextSection = this.m_playerCar.m_currSection + 1;
        if (this.m_playerCar.m_nextSection >= this.m_trackNumSections) {
            this.m_playerCar.m_nextSection = 0;
        }
        this.m_playerCar.setType(1);
        this.m_playerCar.m_ID = 999;
        this.m_playerCar.m_speedF = 0;
        this.m_playerCar.m_speedMulF = 65536;
        this.m_playerCar.m_accelMulF = 65536;
    }

    private void initTrackOrderArray() {
        int n;
        this.m_carsTrackOrder = new GameObject[this.m_numOpponentCars + 1];
        this.m_carsRaceOrder = new GameObject[this.m_carsTrackOrder.length];
        this.m_carsTrackOrder[0] = this.m_playerCar;
        for (n = 1; n < this.m_carsTrackOrder.length; ++n) {
            this.m_carsTrackOrder[n] = this.m_opponentCars[n - 1];
        }
        for (n = 0; n < this.m_carsTrackOrder.length; ++n) {
            this.m_carsRaceOrder[n] = this.m_carsTrackOrder[n];
        }
        this.m_raceEndStandings = new GameObject[this.m_carsTrackOrder.length];
    }

    private void sortCarsTrackOrder() {
        boolean bl = false;
        int n = this.m_carsTrackOrder.length - 1;
        while (!bl) {
            bl = true;
            for (int i = 0; i < n; ++i) {
                if (this.m_carsTrackOrder[i + 1].m_trackPosF >= this.m_carsTrackOrder[i].m_trackPosF) continue;
                GameObject gameObject = this.m_carsTrackOrder[i];
                this.m_carsTrackOrder[i] = this.m_carsTrackOrder[i + 1];
                this.m_carsTrackOrder[i + 1] = gameObject;
                bl = false;
                this.m_redrawHUDLapPosition = true;
            }
            --n;
        }
    }

    private void sortCarsRaceOrder() {
        int n;
        boolean bl = false;
        int n2 = this.m_carsRaceOrder.length - 1;
        while (!bl) {
            bl = true;
            for (n = 0; n < n2; ++n) {
                int n3 = this.m_carsRaceOrder[n].m_trackPosF;
                int n4 = this.m_carsRaceOrder[n + 1].m_trackPosF;
                int n5 = this.m_carsRaceOrder[n + 1].m_numLapsCompleted;
                int n6 = this.m_carsRaceOrder[n].m_numLapsCompleted;
                if (n5 >= n6 && (n5 != n6 || n4 >= n3)) continue;
                GameObject gameObject = this.m_carsRaceOrder[n];
                this.m_carsRaceOrder[n] = this.m_carsRaceOrder[n + 1];
                this.m_carsRaceOrder[n + 1] = gameObject;
                bl = false;
            }
            --n2;
        }
        for (n = 0; n < this.m_carsRaceOrder.length; ++n) {
            this.m_carsRaceOrder[n].setRacePos(this.m_carsRaceOrder.length - n - 1);
            if (this.m_carsRaceOrder[n].getType() == 1) {
                this.m_nextOpponentRaceOrder = null;
                if (this.m_carsRaceOrder[n].getRacePos() > 0) {
                    this.m_nextOpponentRaceOrder = this.m_carsRaceOrder[n + 1];
                }
                this.m_prevOpponentRaceOrder = null;
                if (n > 0) {
                    this.m_prevOpponentRaceOrder = this.m_carsRaceOrder[n - 1];
                }
            }
            this.m_carsRaceOrder[n].m_catchupCodeMultTargetF = 65536;
        }
        if (this.m_nextOpponentRaceOrder != null) {
            this.m_nextOpponentRaceOrder.m_catchupCodeMultTargetF = 60948;
        }
        if (this.m_prevOpponentRaceOrder != null) {
            this.m_prevOpponentRaceOrder.m_catchupCodeMultTargetF = 72089;
        }
    }

    private void debugCarsTrackOrder() {
    }

    private void initStaticObjects() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = this.m_engine.getTrackTheme(this.m_engine.getCurrTrack());
        this.m_engine.seedRand(100000L + (long)this.m_engine.getCurrTrack());
        int n8 = 0;
        for (n6 = 0; n6 < this.m_trackNumSections; ++n6) {
            if (this.m_trackSectionCurvature[n6] == 0) continue;
            ++n8;
        }
        int n9 = n6 = this.m_trackTotalDistance / 500;
        n9 += this.m_trackNumSections * 6;
        n9 += n8 * 2;
        this.m_staticTrackObjects = new BaseObject[n9 += 4];
        int n10 = 0;
        int n11 = 250;
        for (n5 = 0; n5 < n6; ++n5) {
            n4 = (n5 & 1) == 1 ? 81920 : -81920;
            n3 = 15;
            if (n7 == 2 && n5 % 3 == 0) {
                n3 = 18;
            }
            this.addStaticObject(n11 << 16, n4, n3, n10++);
            n11 += 500;
        }
        for (n5 = 0; n5 < this.m_trackNumSections; ++n5) {
            if (n7 == 2 && (n5 == 0 || n5 == this.m_trackNumSections - 1)) {
                n4 = this.m_trackSectionAbsStart[n5] << 16;
                if (n5 != 0) {
                    n4 = this.m_trackSectionAbsEnd[n5] - 600 << 16;
                }
                n3 = this.m_engine.rand(0, 1) == 1 ? 16 : 17;
                for (n2 = 0; n2 < 6; ++n2) {
                    n = (n2 & 1) == 1 ? 91750 : -91750;
                    this.addStaticObject(n4, n, n3, n10++);
                    n4 += 0x640000;
                }
                continue;
            }
            for (n4 = 0; n4 < 6; ++n4) {
                n3 = this.getRandomStaticObjectType();
                n2 = (this.m_trackSectionAbsStart[n5] << 16) + MathExt.Fmul(n4 << 16, MathExt.Fdiv(this.m_trackSectionLength[n5] - 200 << 16, 393216));
                n = BaseObject.isCentered(n3) ? 0 : (this.m_engine.rand(0, 1) == 1 ? 91750 : -91750);
                this.addStaticObject(n2, n, n3, n10++);
            }
        }
        for (n5 = 0; n5 < this.m_trackNumSections; ++n5) {
            n4 = n5 + 1;
            if (n4 >= this.m_trackNumSections) {
                n4 = 0;
            }
            if ((n3 = this.m_trackSectionCurvature[n4]) == 0) continue;
            n2 = this.m_trackSectionAbsEnd[n5] - 200 << 16;
            n = n3 < 0 ? 5 : 6;
            int n12 = n3 < 0 ? 75366 : -75366;
            this.addStaticObject(n2, n12, n, n10++);
            n2 = this.m_trackSectionAbsEnd[n5] - 100 << 16;
            this.addStaticObject(n2, n12, n, n10++);
        }
        this.addStaticObject(this.m_trackTotalDistance - 10 << 16, 0, 19, n10++);
        n4 = n5 = this.m_trackTotalDistance << 14;
        this.addStaticObject(n4, 0, 22, n10++);
        this.addStaticObject(n4 += n5, 0, 21, n10++);
        this.addStaticObject(n4 += n5, 0, 22, n10++);
    }

    private void addStaticObject(int n, int n2, int n3, int n4) {
        BaseObject baseObject = new BaseObject();
        baseObject.m_trackPosF = n;
        baseObject.setType(n3);
        baseObject.m_lateralPosF = n2;
        this.m_staticTrackObjects[n4] = baseObject;
    }

    private void sortStaticObjTrackOrder() {
        boolean bl = false;
        int n = this.m_staticTrackObjects.length - 1;
        while (!bl) {
            bl = true;
            for (int i = 0; i < n; ++i) {
                if (this.m_staticTrackObjects[i + 1].m_trackPosF >= this.m_staticTrackObjects[i].m_trackPosF) continue;
                BaseObject baseObject = this.m_staticTrackObjects[i];
                this.m_staticTrackObjects[i] = this.m_staticTrackObjects[i + 1];
                this.m_staticTrackObjects[i + 1] = baseObject;
                bl = false;
            }
            --n;
        }
    }

    private void fillSlopeArray() {
        int n = this.m_viewPosF;
        int n2 = this.m_viewSection;
        int n3 = 0x1900000;
        int n4 = 65536;
        this.m_numSlopeSections = 0;
        int n5 = (this.m_trackSectionAbsEnd[n2] << 16) - n;
        while (n5 <= n3) {
            this.calcTrack(n5, n4);
            n3 -= n5;
            n += n5;
            if (++n2 >= this.m_trackNumSections) {
                n2 -= this.m_trackNumSections;
                n -= this.m_trackTotalDistance << 16;
            }
            n5 = (this.m_trackSectionAbsEnd[n2] << 16) - n;
            n4 = this.m_trackSectionSlope[n2] - (this.m_playerCarSlopeCurr - 65536);
        }
        this.calcTrack(n3, n4);
    }

    private int getCarSlope() {
        int n = this.m_trackSectionAbsEnd[this.m_playerCar.m_currSection] - (this.m_playerCar.m_trackPosF + 32768 >> 16);
        if (n <= 300) {
            int n2 = this.m_trackSectionSlope[this.m_playerCar.m_nextSection] - this.m_trackSectionSlope[this.m_playerCar.m_currSection];
            int n3 = MathExt.Fmul(n2, MathExt.Fdiv(300 - n << 16, 19660800));
            return this.m_trackSectionSlope[this.m_playerCar.m_currSection] + n3;
        }
        return this.m_trackSectionSlope[this.m_playerCar.m_currSection];
    }

    private void calcTrack(int n, int n2) {
        this.m_slopeArrayDistanceF[this.m_numSlopeSections] = n;
        this.m_slopeArraySlopeF[this.m_numSlopeSections] = n2;
        ++this.m_numSlopeSections;
    }

    private void calcSlopeHeights() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.m_numSlopeSections; ++i) {
            int n3 = this.m_slopeArraySlopeF[i];
            n2 += this.m_slopeArrayDistanceF[i];
            int n4 = MathExt.Fmul(this.m_slopeArrayDistanceF[i], MathExt.Fdiv(0x530000, 0x1900000));
            this.m_slopeSourceHeights[i] = n4 + 32768 >> 16;
            this.m_slopeDestYs[i] = (n += MathExt.Fmul(n4, n3)) + 32768 >> 16;
        }
    }

    private void adjustViewpoint() {
        this.m_viewPosF = this.m_playerCar.m_trackPosF - 327680;
        this.m_viewSection = this.m_playerCar.m_currSection;
        while (this.m_viewPosF < this.m_trackSectionAbsStart[this.m_viewSection]) {
            --this.m_viewSection;
            if (this.m_viewPosF >= 0) continue;
            this.m_viewPosF += this.m_trackTotalDistance << 16;
            this.m_viewSection += this.m_trackNumSections;
        }
    }

    private void renderTrack(Graphics graphics) {
        int n;
        if (!this.m_raceIntroCameraDone) {
            this.calcIntroSlopeHeights();
        } else {
            this.fillSlopeArray();
            this.calcSlopeHeights();
        }
        this.m_currCarRenderIndex = this.m_firstCarRenderIndex = this.getFurthestVisibileCarTrackOrder();
        this.m_currStaticObjRenderIndex = this.m_firstStaticObjRenderIndex = this.getFurthestVisibileStaticObjTrackOrder();
        int n2 = MathExt.Fmul(this.m_playerCar.m_lateralPosF, TRACK1_WIDTHS[51] << 15) + 32768 >> 16;
        int n3 = VIEWPORT_CENTRE_X + this.m_cameraShakeX;
        n3 -= n2;
        int n4 = n = 0;
        for (int i = this.m_numSlopeSections - 1; i >= 0; --i) {
            int n5;
            int n6 = this.m_slopeSourceHeights[i];
            if (n6 <= 0) continue;
            int n7 = this.m_perspectiveRangesF[n4];
            int n8 = 0;
            if (n4 < 82) {
                n8 = this.m_perspectiveRangesF[n4 + 1];
            }
            int n9 = this.m_slopeDestYs[i];
            int n10 = 0;
            if (i > 0) {
                for (n5 = i - 1; n5 >= 0; --n5) {
                    if (this.m_slopeDestYs[n5] <= this.m_slopeDestYs[i]) continue;
                    n10 = this.m_slopeDestYs[n5];
                }
            }
            n4 = n;
            n5 = 0;
            if (i > 0) {
                n5 = this.m_slopeDestYs[i - 1];
            }
            int n11 = n9 - n5;
            int n12 = n6;
            int n13 = n6 << 1;
            int n14 = n11 << 1;
            int n15 = n9 + n11;
            if (n11 > 0) {
                if (n6 < n11) {
                    for (n9 = VIEWPORT_TOP + TRACK_VIEWPORT_HEIGHT - n9; n9 < n15; ++n9) {
                        this.renderTrackSliver(graphics, n4, n9, n8, n3);
                        if ((n12 += n13) < n14) continue;
                        this.renderCars(graphics, n4, n9, n3, n8, n7, n10);
                        this.renderStaticObjs(graphics, n4, n9, n3, n8, n7, n10);
                        n12 -= n14;
                        n7 = n8;
                        n8 = 0;
                        if (++n4 >= 82) continue;
                        n8 = this.m_perspectiveRangesF[n4 + 1];
                    }
                } else {
                    while (n9 < n15) {
                        if ((n12 += n14) > n13) {
                            this.renderTrackSliver(graphics, n4, n9, n8, n3);
                            ++n9;
                            n12 -= n13;
                        }
                        this.renderCars(graphics, n4, n9, n3, n8, n7, n10);
                        this.renderStaticObjs(graphics, n4, n9, n3, n8, n7, n10);
                        n7 = n8;
                        n8 = 0;
                        if (++n4 >= 82) continue;
                        n8 = this.m_perspectiveRangesF[n4 + 1];
                    }
                }
            } else if (n11 < 0) {
                n11 = -n11;
                n14 = n11 << 1;
                if (n6 < n11) {
                    while (n9 > n15) {
                        if ((n12 += n13) >= n14) {
                            this.renderCars(graphics, n4, n9, n3, n8, n7, n10);
                            this.renderStaticObjs(graphics, n4, n9, n3, n8, n7, n10);
                            n12 -= n14;
                            n7 = n8;
                            n8 = 0;
                            if (++n4 < 82) {
                                n8 = this.m_perspectiveRangesF[n4 + 1];
                            }
                        }
                        --n9;
                    }
                } else {
                    while (n9 > n15) {
                        if ((n12 += n14) > n13) {
                            this.renderCars(graphics, n4, n9, n3, n8, n7, n10);
                            this.renderStaticObjs(graphics, n4, n9, n3, n8, n7, n10);
                            --n9;
                            n12 -= n13;
                            n7 = n8;
                        }
                        n8 = 0;
                        if (++n4 >= 82) continue;
                        n8 = this.m_perspectiveRangesF[n4 + 1];
                    }
                }
            } else if (n11 == 0) {
                int n16 = n4 + n6;
                while (n4 < n16) {
                    n8 = 0;
                    if (n4 < 82) {
                        n8 = this.m_perspectiveRangesF[n4 + 1];
                    }
                    ++n4;
                }
                this.renderCars(graphics, n4, n9, n3, n8, n7, n10);
                this.renderStaticObjs(graphics, n4, n9, n3, n8, n7, n10);
            }
            n += n6;
        }
    }

    private void renderCars(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.m_currCarRenderIndex < 0) {
            return;
        }
        int n7 = this.m_currCarRenderIndex;
        int n8 = this.calcDistance(this.m_viewPosF, this.m_carsTrackOrder[this.m_currCarRenderIndex].m_trackPosF);
        if (n8 < this.m_perspectiveRangesF[0]) {
            while (n8 > n4 && n8 <= n5) {
                int n9 = MathExt.Fmul(this.m_carsTrackOrder[this.m_currCarRenderIndex].m_lateralPosF, TRACK1_WIDTHS[n] >> 1 << 16) >> 16;
                this.m_carsTrackOrder[this.m_currCarRenderIndex].m_renderPosX = n3 + n9 + this.m_trackBendOffsets[n];
                this.m_carsTrackOrder[this.m_currCarRenderIndex].m_renderPosY = n2;
                this.m_carsTrackOrder[this.m_currCarRenderIndex].m_renderDistF = n8;
                this.m_carsTrackOrder[this.m_currCarRenderIndex].m_renderClipY = n6;
                if (--this.m_currCarRenderIndex < 0) {
                    this.m_currCarRenderIndex += this.m_carsTrackOrder.length;
                }
                if (n7 == this.m_currCarRenderIndex) break;
                n8 = this.calcDistance(this.m_viewPosF, this.m_carsTrackOrder[this.m_currCarRenderIndex].m_trackPosF);
            }
        }
    }

    private int getFurthestVisibileCarTrackOrder() {
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < this.m_carsTrackOrder.length; ++i) {
            int n3 = this.calcDistance(this.m_viewPosF, this.m_carsTrackOrder[i].m_trackPosF);
            if (n3 > this.m_perspectiveRangesF[0] || n3 < n) continue;
            n = n3;
            n2 = i;
        }
        return n2;
    }

    private int calcDistance(int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            n3 += this.m_trackTotalDistance << 16;
        }
        return n3;
    }

    private void renderCar(Graphics graphics, GameObject gameObject) {
        int n = this.getOpponentCarFrameFromDistance(gameObject.m_renderDistF + 32768 >> 16);
        this.m_engine.getAnimationManager().drawAnimFrame(graphics, this.m_opponentCarAnimID[gameObject.m_opponentAnimIDIndex], n, gameObject.m_renderPosX, gameObject.m_renderPosY);
        if (gameObject == this.m_nextOpponentRaceOrder && this.m_raceIntroDone && this.m_engine.m_rmsCarMarkersEnabled) {
            int n2 = this.m_engine.getAnimationManager().getAnimFrameHeight(this.m_opponentCarAnimID[gameObject.m_opponentAnimIDIndex], n);
            this.m_engine.getAnimationManager().drawAnimFrame(graphics, 295, 0, gameObject.m_renderPosX, gameObject.m_renderPosY - n2);
            byte[] byArray = m_racePosByteArrays[gameObject.getRacePos()];
            if (byArray == null) {
                SceneGame.m_racePosByteArrays[gameObject.getRacePos()] = AppEngine.intToByteArray(gameObject.getRacePos() + 1);
                byArray = m_racePosByteArrays[gameObject.getRacePos()];
            }
            this.m_engine.drawChars(graphics, byArray, this.m_engine.getFont(1), gameObject.m_renderPosX, gameObject.m_renderPosY - n2 - 8, 3);
        }
    }

    private void renderStaticObj(Graphics graphics, BaseObject baseObject) {
        int n = this.getTreeFrameFromDistance(baseObject.m_renderDistF + 32768 >> 16);
        int n2 = -1;
        if (baseObject.getType() == 5) {
            n2 = 301;
        } else if (baseObject.getType() == 6) {
            n2 = 302;
        } else if (baseObject.getType() == 7) {
            n2 = 304;
        } else if (baseObject.getType() == 8) {
            n2 = 305;
        } else if (baseObject.getType() == 9) {
            n2 = 306;
        } else if (baseObject.getType() == 10) {
            n2 = 303;
        } else if (baseObject.getType() == 11) {
            n2 = 308;
        } else if (baseObject.getType() == 14) {
            n2 = 307;
        } else if (baseObject.getType() == 15) {
            n2 = 314;
        } else if (baseObject.getType() == 16) {
            n2 = 310;
        } else if (baseObject.getType() == 17) {
            n2 = 311;
        } else if (baseObject.getType() == 18) {
            n2 = 309;
        } else if (baseObject.getType() == 19) {
            n2 = 312;
        } else if (baseObject.getType() == 20) {
            n2 = 313;
        } else if (baseObject.getType() == 21) {
            n2 = 315;
        } else if (baseObject.getType() == 22) {
            n2 = 316;
        }
        if (n2 >= 0) {
            if (baseObject.m_isPrimitive) {
                int n3 = 6554 + MathExt.Fmul(baseObject.m_renderSrcY << 16, this.m_invRoadHeightViewport);
                int n4 = this.m_primitiveObjScaleBaseF + MathExt.Fmul(baseObject.m_renderSrcY << 16, this.m_primitiveObjScaleRangeMultiplierF);
                this.m_engine.getAnimationManager().drawScaledPrimitives(graphics, n2, 0, baseObject.m_renderPosX, baseObject.m_renderPosY, n4, n3, baseObject.m_lateralPosF > 0, false);
            } else {
                this.m_engine.getAnimationManager().drawAnimFrame(graphics, n2, n, baseObject.m_renderPosX, baseObject.m_renderPosY);
            }
        }
    }

    private void renderStaticObjs(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.m_currStaticObjRenderIndex < 0) {
            return;
        }
        int n7 = this.m_currStaticObjRenderIndex;
        int n8 = this.calcDistance(this.m_viewPosF, this.m_staticTrackObjects[this.m_currStaticObjRenderIndex].m_trackPosF);
        if (n8 < this.m_perspectiveRangesF[0]) {
            while (n8 > n4 && n8 <= n5) {
                int n9 = MathExt.Fmul(this.m_staticTrackObjects[this.m_currStaticObjRenderIndex].m_lateralPosF, TRACK1_WIDTHS[n] >> 1 << 16) >> 16;
                this.m_staticTrackObjects[this.m_currStaticObjRenderIndex].m_renderPosX = n3 + n9 + this.m_trackBendOffsets[n];
                this.m_staticTrackObjects[this.m_currStaticObjRenderIndex].m_renderPosY = n2;
                this.m_staticTrackObjects[this.m_currStaticObjRenderIndex].m_renderDistF = n8;
                this.m_staticTrackObjects[this.m_currStaticObjRenderIndex].m_renderClipY = n6;
                this.m_staticTrackObjects[this.m_currStaticObjRenderIndex].m_renderSrcY = n;
                if (--this.m_currStaticObjRenderIndex < 0) {
                    this.m_currStaticObjRenderIndex += this.m_staticTrackObjects.length;
                }
                if (n7 == this.m_currStaticObjRenderIndex) break;
                n8 = this.calcDistance(this.m_viewPosF, this.m_staticTrackObjects[this.m_currStaticObjRenderIndex].m_trackPosF);
            }
        }
    }

    private int getTreeFrameFromDistance(int n) {
        if (n > 340) {
            return 0;
        }
        if (n > 290) {
            return 1;
        }
        if (n > 240) {
            return 2;
        }
        if (n > 190) {
            return 3;
        }
        if (n > 140) {
            return 4;
        }
        if (n > 90) {
            return 5;
        }
        if (n > 40) {
            return 6;
        }
        return 7;
    }

    private void renderPlayerCar(Graphics graphics, int n) {
        int n2;
        int n3 = VIEWPORT_CENTRE_X + this.m_cameraShakeX;
        int n4 = this.getPlayerCarAnimID();
        if (this.m_playerImpactSparkAnimPlayer.isAnimating() && this.m_playerBumpedFront) {
            this.m_playerImpactSparkAnimPlayer.drawAnim(graphics, this.m_playerImpactSparkX, this.m_playerImpactSparkY, false);
        }
        if (!this.m_crashCutscenePlaying) {
            this.m_playerCarAnimPlayer.startAnim(this.m_carAnimIDs[n4], false, true);
        }
        this.m_playerCarAnimPlayer.drawAnim(graphics, n3, n, false);
        if (!this.m_crashCutscenePlaying) {
            n2 = CAR_HIGHLIGHT_ANIM_IDS[n4];
            if (n2 == -1) {
                this.m_highlightPlayer.setAnimating(false);
            } else {
                this.m_highlightPlayer.startAnim(n2, false, true);
                this.m_highlightPlayer.drawAnim(graphics, n3, n, false);
            }
            if (!this.m_playerCar.m_finishedRace) {
                boolean bl = this.m_insideCornerLineLinesEffectEnabled;
                boolean bl2 = this.m_insideCornerLineLinesEffectEnabled = !this.m_crashCutscenePlaying && !this.m_driftMiniGameActivated && this.m_playerCarInInsideLane || this.m_insideCornerLineSustainTimer > 0;
                if (this.m_insideCornerLineLinesEffectEnabled && !bl) {
                    this.calculateWingedBoxWidth(HUD_WINGEDBOX_INFO_WIDTH, 3);
                }
                boolean bl3 = this.m_speedlines = this.m_raceIntroDone && (this.m_slipstreaming || this.m_insideCornerLineLinesEffectEnabled);
                if (this.m_speedlines) {
                    short s = CAR_SPEEDLINES_ANIM_IDS[n4];
                    this.m_speedlinesAnimPlayer.startAnim(s, false, true);
                    this.m_speedlinesAnimPlayer.drawAnim(graphics, n3, n, false);
                }
                if ((this.m_playerCar.m_isBraking || this.m_playerCar.m_isOffTrackBraking || this.m_collisionBrakingTimeout > 0) && this.m_playerBrakesAnimIDs[this.getPlayerCarAnimID()] != -1) {
                    this.m_engine.getAnimationManager().drawAnimFrame(graphics, this.m_playerBrakesAnimIDs[n4], this.m_playerCarAnimPlayer.getCurrAnimFrame(), n3, n);
                }
                if (this.m_playerCar.m_showingSlowdownEffects) {
                    if (this.m_slowdownBrakeAnimPlayer.isAnimating()) {
                        this.m_slowdownBrakeAnimPlayer.drawAnim(graphics, n3, n, false);
                    }
                    this.m_slowdownBackfireAnimPlayer.drawAnim(graphics, n3, n, false);
                }
            }
            if (this.m_playerIsBoosting) {
                this.m_boostAnimPlayer.startAnim(this.m_boostAnimIDs[n4], false, true);
                this.m_boostAnimPlayer.drawAnim(graphics, n3, n, false);
            }
        }
        if (this.m_smokingLeftWheel) {
            n2 = this.getSmokeLeftAnimIDFromCarAnimID(n4);
            if (n2 > -1) {
                this.m_smokeLeftAnimPlayer.startAnim(n2, false, true);
                this.m_smokeLeftAnimPlayer.drawAnim(graphics, n3, n, false);
            } else {
                this.m_smokeLeftAnimPlayer.setAnimating(false);
            }
        }
        if (this.m_smokingRightWheel) {
            n2 = this.getSmokeRightAnimIDFromCarAnimID(n4);
            if (n2 > -1) {
                this.m_smokeRightAnimPlayer.startAnim(n2, false, true);
                this.m_smokeRightAnimPlayer.drawAnim(graphics, n3, n, false);
            } else {
                this.m_smokeRightAnimPlayer.setAnimating(false);
            }
        }
        if (this.m_playerImpactSparkAnimPlayer.isAnimating() && !this.m_playerBumpedFront) {
            this.m_playerImpactSparkAnimPlayer.drawAnim(graphics, this.m_playerImpactSparkX, this.m_playerImpactSparkY, false);
        }
    }

    private void renderTrackSliver(Graphics graphics, int n, int n2, int n3, int n4) {
        try {
            int n5;
            Image image = this.m_imgGrassLight;
            int n6 = n4 - TRACK1_OFFSETS[n] + this.m_trackBendOffsets[n];
            int n7 = 0;
            int n8 = TRACK1_WIDTHS[n];
            int n9 = this.m_grassOffsets[n];
            int n10 = 0;
            int n11 = 0;
            int n12 = this.m_viewPosF + n3;
            if (n12 > this.m_trackTotalDistance << 16) {
                n12 -= this.m_trackTotalDistance << 16;
            }
            if ((n12 >> 22 & 1) == 1) {
                n5 = 82 - n;
                image = this.m_imgGrassDark;
                n6 = n4 - TRACK2_OFFSETS[n] + this.m_trackBendOffsets[n];
                n7 = TRACK1_WIDTHS[n5];
                n8 = TRACK2_WIDTHS[n];
                n9 = this.m_grassOffsets[n5];
                n = n5;
            }
            if (n6 > 0) {
                n10 = image.getWidth() - n9;
            }
            if ((n5 = n6 + n8) < VIEWPORT_LEFT + VIEWPORT_WIDTH) {
                n11 = image.getWidth() - n9;
            }
            if (this.m_viewPosF + n3 > this.m_trackTotalDistance - 20 << 16 && this.m_viewPosF + n3 < this.m_trackTotalDistance << 16) {
                graphics.setColor(-4144960);
                graphics.drawLine(n6, n2, n8 << 1, n2);
            } else if (n8 > 0) {
                graphics.drawRegion(this.m_imgTrackPacked, n7, n, n8, 1, 0, n6, n2, 20);
            }
            if (n10 > 0) {
                graphics.drawRegion(image, 0, 0, n10, 1, 0, n6 - image.getWidth() + n9, n2, 20);
            }
            if (n11 > 0) {
                graphics.drawRegion(image, n9, 0, n11, 1, 0, n5, n2, 20);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void renderDrawList(Graphics graphics) {
        int n = 0;
        int n2 = this.m_firstCarRenderIndex;
        int n3 = 0;
        int n4 = this.m_firstStaticObjRenderIndex;
        int n5 = 0;
        graphics.setClip(VIEWPORT_LEFT, VIEWPORT_TOP, VIEWPORT_WIDTH, TRACK_VIEWPORT_HEIGHT);
        if (this.m_firstCarRenderIndex >= 0 && (n = this.m_firstCarRenderIndex - this.m_currCarRenderIndex) <= 0) {
            n += this.m_carsTrackOrder.length;
        }
        if (this.m_firstStaticObjRenderIndex >= 0 && (n3 = this.m_firstStaticObjRenderIndex - this.m_currStaticObjRenderIndex) <= 0) {
            n3 += this.m_staticTrackObjects.length;
        }
        while (n > 0 || n3 > 0) {
            BaseObject baseObject = null;
            boolean bl = true;
            if (n > 0 && n3 > 0) {
                if (this.m_carsTrackOrder[n2].m_renderDistF <= this.m_staticTrackObjects[n4].m_renderDistF) {
                    bl = false;
                }
            } else if (n3 > 0) {
                bl = false;
            }
            if (bl) {
                baseObject = this.m_carsTrackOrder[n2];
                --n;
                if (--n2 < 0) {
                    n2 += this.m_carsTrackOrder.length;
                }
            } else {
                baseObject = this.m_staticTrackObjects[n4];
                --n3;
                if (--n4 < 0) {
                    n4 += this.m_staticTrackObjects.length;
                }
            }
            if (n5 != baseObject.m_renderClipY) {
                n5 = baseObject.m_renderClipY;
                graphics.setClip(VIEWPORT_LEFT, VIEWPORT_TOP, VIEWPORT_WIDTH, TRACK_VIEWPORT_HEIGHT - n5);
            }
            if (bl) {
                if (baseObject.getType() == 1) {
                    this.renderPlayerCar(graphics, baseObject.m_renderPosY);
                    continue;
                }
                this.renderCar(graphics, (GameObject)baseObject);
                continue;
            }
            this.renderStaticObj(graphics, baseObject);
        }
    }

    void updateBoost(int n) {
        if (!this.m_playerIsBoosting) {
            if (this.m_boostDelay <= 0) {
                this.m_boostGaugeLevel += MathExt.Fmul(this.m_playerBoostRestoreRateF, n);
                if (this.m_boostGaugeLevel >= 0x640000) {
                    this.m_boostGaugeLevel = 0x640000;
                }
            }
            this.m_timeSinceLastBoost += n;
            this.m_cameraShakeXAmplitudeF -= n << 3;
            if (this.m_cameraShakeXAmplitudeF < 0) {
                this.m_cameraShakeXAmplitudeF = 0;
            }
        } else if (this.m_playerIsBoosting && this.m_bonusNitroBoostTimer <= 0) {
            this.m_playerBoostTimeF -= n;
            if (this.m_playerBoostTimeF <= 0) {
                this.setPlayerBoosting(false);
            }
            this.m_boostGaugeLevel -= MathExt.Fmul(1200000, n);
            if (this.m_boostGaugeLevel < 0) {
                this.m_boostGaugeLevel = 0;
                this.setPlayerBoosting(false);
                this.m_HUDBoostBar.startAnim(281, true, false);
            }
            this.m_cameraShakeXAmplitudeF += n << 2;
            if (this.m_cameraShakeXAmplitudeF > this.m_cameraShakeXAmplitudeMaxF) {
                this.m_cameraShakeXAmplitudeF = this.m_cameraShakeXAmplitudeMaxF;
            }
        }
        this.m_cameraShakeX = this.m_engine.rand(-(this.m_cameraShakeXAmplitudeF >> 16), this.m_cameraShakeXAmplitudeF >> 16);
    }

    private void renderHUD(Graphics graphics) {
        if (this.m_redrawHUD) {
            this.renderHUDBackground(graphics);
            this.renderHUDSpeedUnit(graphics);
            this.m_redrawHUD = false;
            this.m_redrawHUDGear = true;
            this.m_redrawHUDLapPosition = true;
            this.m_redrawHUDTopBar = true;
            this.m_redrawHUDCornerScore = true;
            this.m_redrawHUDDriftScore = true;
            this.m_redrawHUDSpeed = true;
        }
        this.renderHUDTacho(graphics);
        if (this.m_redrawHUDSpeed) {
            this.renderHUDSpeed(graphics);
        }
        this.renderHUDBoostGauge(graphics);
        if (this.m_redrawHUDGear) {
            this.renderHUDGear(graphics);
            this.m_redrawHUDGear = false;
        }
        if (!this.m_redrawHUDTopBar && (this.m_redrawHUDDriftScore || this.m_redrawHUDLapPosition || this.m_driftMiniGameActivated)) {
            this.m_redrawHUDTopBar = true;
        }
        this.m_redrawHUDTopBar = true;
        this.m_redrawHUDLapPosition = true;
        this.m_redrawHUDDriftScore = true;
        if (this.m_redrawHUDTopBar) {
            this.renderHUDTopBar(graphics);
            this.m_redrawHUDTopBar = false;
        }
        if (this.m_redrawHUDLapPosition) {
            this.renderHUDPosition(graphics);
            this.renderHUDLap(graphics);
            this.m_redrawHUDLapPosition = false;
        }
        if (this.m_driftMiniGameActivated) {
            this.renderHUDDriftMiniGame(graphics);
            this.renderHUDDriftIndicator(graphics);
        }
        if (this.m_driftScoreTimer > 0) {
            this.renderHUDDriftScore(graphics);
        } else if (!this.m_driftMiniGameActivated && !this.m_crashCutscenePlaying) {
            if (this.m_slipstreamLinesEffectEnabled) {
                this.renderWingedBox(graphics, (byte)3, (short)194);
            } else if (this.m_insideCornerLineLinesEffectEnabled) {
                this.renderWingedBox(graphics, (byte)3, (short)195);
            }
        }
        this.m_engine.renderSoftKeysInGame(graphics);
    }

    private void renderHUDBackground(Graphics graphics) {
        this.m_engine.getAnimationManager().drawAnimFrame(graphics, 265, 0, HUD_POSITION_X, HUD_POSITION_Y);
    }

    private void renderHUDTacho(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        AnimationManager animationManager = appEngine.getAnimationManager();
        animationManager.drawAnimFrame(graphics, 284, 0, HUD_TACHO_POSITION_X, HUD_TACHO_POSITION_Y);
        if (this.m_playerCar.m_speedF > this.m_playerCar.getCurGearMaxSpeed() - 1000000 && this.m_playerCar.getCurrentGear() < 5 && (System.currentTimeMillis() >> 7 & 1L) == 1L) {
            animationManager.drawAnimFrame(graphics, 279, 0, HUD_TACHO_POSITION_X, HUD_TACHO_POSITION_Y);
        }
        if (this.m_raceIntroDone) {
            int n = HUD_NEEDLE_MIN_ANGLE_F + MathExt.Fmul(HUD_NEEDLE_TOTAL_ANGLE_F, this.m_revPercentF);
            int n2 = MathExt.Fcos(n += appEngine.rand(0, 6144) - 3072);
            int n3 = MathExt.Fsin(n);
            int n4 = MathExt.Fmul(n2, HUD_NEEDLE_LENGTH_F) + 32768 >> 16;
            int n5 = MathExt.Fmul(n3, HUD_NEEDLE_LENGTH_F) + 32768 >> 16;
            graphics.setColor(-1);
            int n6 = MathExt.Fmul(n3, HUD_NEEDLE_WIDTH_F) + 32768 >> 16;
            int n7 = MathExt.Fmul(n2, HUD_NEEDLE_WIDTH_F) + 32768 >> 16;
            int n8 = graphics.getClipX();
            int n9 = graphics.getClipY();
            int n10 = graphics.getClipWidth();
            int n11 = graphics.getClipHeight();
            graphics.clipRect(0, 0, VIEWPORT_WIDTH, HUD_POSITION_Y + HUD_NEEDLE_CLIP_Y);
            graphics.fillTriangle(HUD_POSITION_X + HUD_NEEDLE_ORIGIN_X + n4, HUD_POSITION_Y + HUD_NEEDLE_ORIGIN_Y + n5, HUD_POSITION_X + HUD_NEEDLE_ORIGIN_X + n6, HUD_POSITION_Y + HUD_NEEDLE_ORIGIN_Y - n7, HUD_POSITION_X + HUD_NEEDLE_ORIGIN_X - n6, HUD_POSITION_Y + HUD_NEEDLE_ORIGIN_Y + n7);
            graphics.setClip(n8, n9, n10, n11);
        }
    }

    private void renderHUDGear(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(HUD_POSITION_X + HUD_GEAR_POSITION_X, HUD_POSITION_Y + HUD_GEAR_CLEAR_POSITION_Y, HUD_GEAR_WIDTH, HUD_GEAR_HEIGHT);
        int n = 280;
        this.m_engine.getAnimationManager().drawAnimFrame(graphics, n, this.m_playerCar.getCurrentGear(), HUD_POSITION_X + HUD_GEAR_POSITION_X, HUD_POSITION_Y + HUD_GEAR_POSITION_Y);
        this.m_engine.drawChars(graphics, this.m_gearBytes, this.m_engine.getFont(1), HUD_POSITION_X + HUD_GEAR_POSITION_X + HUD_GEAR_NUMBER_XOFFSET, HUD_POSITION_Y + HUD_GEAR_POSITION_Y, 3);
    }

    private void renderHUDLap(Graphics graphics) {
        MixedFont mixedFont = this.m_engine.getFont(1);
        this.m_engine.drawString(graphics, 120, mixedFont, HUD_LAP_POSITION_X, 9, 40);
        this.m_engine.drawChars(graphics, this.m_lapBytes, mixedFont, HUD_LAP_POSITION_X, 11, 24);
    }

    private void renderHUDPosition(Graphics graphics) {
        MixedFont mixedFont = this.m_engine.getFont(1);
        this.m_engine.drawString(graphics, 121, mixedFont, 1, 9, 36);
        this.m_engine.drawChars(graphics, this.m_posBytes, mixedFont, 1, 11, 20);
    }

    private void renderWingedBox(Graphics graphics, byte by, byte[][] byArray) {
        this.renderWingedBoxBacking(graphics, by);
        if (byArray != null) {
            this.m_engine.drawChars(graphics, byArray, this.m_engine.getFont(1), this.m_engine.getHalfWidth(), HUD_DRIFTINDICATOR_YPOS, 3);
        }
    }

    private void renderWingedBox(Graphics graphics, byte by, short s) {
        this.renderWingedBoxBacking(graphics, by);
        if (s != -1) {
            this.m_engine.drawString(graphics, s, this.m_engine.getFont(1), this.m_engine.getHalfWidth(), HUD_DRIFTINDICATOR_YPOS, 3);
        }
    }

    private void renderWingedBoxBacking(Graphics graphics, byte by) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = this.m_driftBorderLeft;
        int n5 = this.m_driftBorderRight;
        switch (by) {
            case 0: {
                n = 269;
                n2 = 270;
                n3 = 27;
                break;
            }
            case 1: {
                n = 275;
                n2 = 276;
                n3 = 32;
                break;
            }
            case 2: 
            case 3: {
                n = 277;
                n2 = 278;
                n3 = 30;
                if (by != 2) break;
                n4 = this.m_wingedBoxBackingLeft;
                n5 = this.m_wingedBoxBackingRight;
            }
        }
        if (n != -1) {
            AnimationManager animationManager = this.m_engine.getAnimationManager();
            animationManager.drawAnimFrame(graphics, n, 0, n4, HUD_DRIFTINDICATOR_YPOS);
            animationManager.drawAnimFrame(graphics, n2, 0, n5, HUD_DRIFTINDICATOR_YPOS);
            animationManager.setColor(graphics, n3);
            graphics.drawRect(n4, HUD_DRIFTINDICATOR_YPOS - 5, n5 - n4 - 1, 9);
        }
    }

    private void renderHUDDriftIndicator(Graphics graphics) {
        if (this.m_driftMiniGameTargetDotMatched) {
            if (this.m_driftTextFlashTimer > 380) {
                this.renderWingedBox(graphics, (byte)0, (short)128);
            } else {
                this.renderWingedBox(graphics, (byte)0, (short)-1);
            }
        } else if (this.m_driftTextFlashTimer > 380) {
            this.renderWingedBox(graphics, (byte)1, (short)190);
        } else {
            this.renderWingedBox(graphics, (byte)1, (short)-1);
        }
    }

    private void renderHUDSpeed(Graphics graphics) {
        int n = HUD_SPEED_POSITION_X;
        int n2 = HUD_SPEED_POSITION_Y;
        this.m_engine.getAnimationManager().setColor(graphics, 0);
        graphics.fillRect(HUD_POSITION_X + n - HUD_SPEED_WIDTH, HUD_POSITION_Y + n2 - HUD_SPEED_HEIGHT, HUD_SPEED_WIDTH, HUD_SPEED_HEIGHT);
        this.m_engine.getFont(1).drawChars(graphics, this.m_speedBytes, this.m_speedBytesOffset, this.m_speedBytes.length - this.m_speedBytesOffset, HUD_POSITION_X + n, HUD_POSITION_Y + n2, 40);
        this.m_redrawHUDSpeed = false;
    }

    private void renderHUDSpeedUnit(Graphics graphics) {
        int n = HUD_SPEED_UNIT_POSITION_X;
        this.m_engine.drawString(graphics, 123, this.m_engine.getFont(1), HUD_POSITION_X + n, HUD_POSITION_Y + HUD_SPEED_UNIT_POSITION_Y, 40);
    }

    private void renderHUDBoostGauge(Graphics graphics) {
        int n = HUD_BOOST_POSITION_X;
        int n2 = this.m_engine.getHeight() + HUD_BOOST_POSITION_YOFFSET;
        int n3 = n - this.m_nitroBarWidth;
        int n4 = n2;
        int n5 = this.m_nitroBarWidth;
        int n6 = this.m_nitroBarHeight;
        int n7 = MathExt.Fmul(this.m_boostGaugeLevel, this.m_boostGaugeDivF);
        n7 = MathExt.Fmul(n7, n5 << 16) + 32768 >> 16;
        this.m_HUDBoostBar.drawAnim(graphics, n, n2, false);
        if (this.m_boostGaugeLevel < 0x190000) {
            this.m_engine.getAnimationManager().setColor(graphics, 20);
            graphics.fillRect(n3, n4, n7, n6);
        }
        if (n7 < n5) {
            int n8 = n5 - n7;
            this.m_engine.getAnimationManager().setColor(graphics, 0);
            graphics.fillRect(n3 + n5 - n8, n4, n8, n6);
        }
        if (this.m_driftScoreTimer > 0 && this.m_driftScoreTimer % 300 > 180) {
            if (this.m_boostGaugeBonusWidth > n7) {
                this.m_boostGaugeBonusWidth = n7;
            }
            this.m_engine.getAnimationManager().setColor(graphics, 9);
            graphics.fillRect(n3 + n7 - this.m_boostGaugeBonusWidth, n4, this.m_boostGaugeBonusWidth, n6);
        }
    }

    private void renderRaceIntroHUD(Graphics graphics) {
        int n = 3 - this.m_raceIntroCount;
        if (n < 0) {
            n = 0;
        } else if (n > 3) {
            n = 3;
        }
        this.m_engine.getAnimationManager().drawAnimFrame(graphics, 283, n, this.m_engine.getHalfWidth(), this.m_engine.getHalfHeight() + (this.m_lightsOffsetY >> 16));
    }

    private void renderHUDTopBar(Graphics graphics) {
        int n = this.m_engine.getWidth();
        AnimationManager animationManager = this.m_engine.getAnimationManager();
        animationManager.setColor(graphics, 0);
        graphics.fillRect(0, 2, n, 16);
        animationManager.setColor(graphics, 37);
        graphics.drawLine(0, 0, n, 0);
        graphics.drawLine(0, 18, n, 18);
        animationManager.setColor(graphics, 40);
        graphics.drawLine(0, 1, n, 1);
        graphics.drawLine(0, 19, n, 19);
        animationManager.setColor(graphics, 3);
        graphics.drawLine(0, 20, n, 20);
    }

    private void renderHUDDriftScore(Graphics graphics) {
        if (this.m_driftScoreTimer % 1000 > 550) {
            this.renderWingedBox(graphics, (byte)2, (short)189);
        } else {
            this.renderWingedBox(graphics, (byte)2, this.m_driftCashBytes);
        }
    }

    private int getCarAnimIDIndex(int n) {
        return n + 4;
    }

    private byte getIdealGearForBend(int n) {
        if (n < 0) {
            n = -n;
        }
        return (byte)(5 - n);
    }

    private int getDriftSpeedPenalty(int n) {
        return MathExt.Fmul(Math.abs(n), this.m_driftSpeedPenaltyMultF);
    }

    private int getLateralDrift() {
        int n;
        int n2 = this.m_trackSectionCurvature[this.m_playerCar.m_currSection];
        if (n2 == 0) {
            this.m_playerCarDriftDiffTargetF = 0;
            this.m_lateralPosFactorF = 0;
            return 0;
        }
        byte by = this.getIdealGearForBend(n2);
        int n3 = this.m_playerCar.getGearMaxSpeed(by);
        int n4 = MathExt.Fmul(32768, this.m_playerCar.getSpeedFactor(n3));
        int n5 = MathExt.Fmul(32768, this.m_playerCar.getSpeedFactor());
        int n6 = MathExt.Fmul(65536 - n4, this.m_playerLateralSteerMaxF);
        int n7 = MathExt.Fmul(32768, this.m_playerLateralSteerMaxF);
        int n8 = MathExt.Fmul(65536 - n5, this.m_playerLateralSteerMaxF);
        if (this.m_playerCar.m_speedF < n3) {
            this.m_playerCarDriftDiffTargetF = 0;
        } else {
            n = n6 - n7;
            this.m_playerCarDriftDiffTargetF = -MathExt.Fdiv(n6 - n8, n);
            if (n2 < 0) {
                this.m_playerCarDriftDiffTargetF = -this.m_playerCarDriftDiffTargetF;
            }
            this.m_playerCarDriftDiffTargetF = MathExt.Fmul(this.m_playerCarDriftDiffTargetF, this.m_playerTyresInvF);
        }
        n = MathExt.Fdiv(n5, n4);
        int n9 = MathExt.Fmul(n6, n);
        int n10 = this.m_playerCar.m_lateralPosF + 65536 >> 1;
        n10 = n2 < 0 ? 65536 - n10 : -n10;
        this.m_lateralPosFactorF = Math.abs(n10);
        int n11 = n10 + (n2 < 0 ? 13107 : -13107);
        int n12 = MathExt.Fmul(n11, 54613);
        int n13 = MathExt.Fmul(n12, n9);
        n13 = MathExt.Fmul(n13, this.m_playerTyresInvF);
        return n13;
    }

    private void updateTrackWarning() {
        for (int i = 0; i < this.m_carsTrackOrder.length; ++i) {
            GameObject gameObject = this.m_carsTrackOrder[i];
            if (gameObject.m_lastCornerWarningSection == gameObject.m_nextSection) continue;
            if (gameObject.m_lastCornerWarningSection == gameObject.m_currSection && gameObject == this.m_playerCar && this.m_playerCarAuto && !this.m_playerCar.isMaximumGearAllowed()) {
                gameObject.setMaximumAllowedGear();
                this.m_brakingForCorner = false;
                continue;
            }
            int n = this.m_trackSectionCurvature[gameObject.m_nextSection];
            int n2 = this.m_trackSectionCurvature[gameObject.m_currSection];
            if (n == 0) continue;
            int n3 = this.m_trackSectionAbsStart[gameObject.m_nextSection] - (gameObject.m_trackPosF + 32768 >> 16);
            if (n3 < 0) {
                n3 += this.m_trackTotalDistance;
            }
            int n4 = 800;
            if (i != 0) {
                n4 = gameObject.m_mood == 1 ? 640 : (gameObject.m_mood == 0 ? 747 : 853);
            }
            if (n3 <= n4) {
                byte by = this.getIdealGearForBend(n);
                if (!(gameObject.getMaximumAllowedGear() <= by || gameObject == this.m_playerCar && this.m_playerIsBoosting)) {
                    gameObject.setMaximumAllowedGear(by);
                    this.m_redrawHUDGear = true;
                    this.m_gearBytes = AppEngine.intToByteArray(this.m_playerCar.getCurrentGear() + 1);
                    if (gameObject == this.m_playerCar) {
                        this.m_brakingForCorner = true;
                        this.startBrakingEffect();
                    }
                }
                gameObject.m_lastCornerWarningSection = gameObject.m_nextSection;
                continue;
            }
            if (gameObject.isMaximumGearAllowed() || n2 != 0 || gameObject == this.m_playerCar && !this.m_playerCarAuto) continue;
            gameObject.setMaximumAllowedGear();
            this.m_brakingForCorner = false;
        }
    }

    private void initDisplayDimensionsAndOffsets() {
        VIEWPORT_LEFT = 0;
        VIEWPORT_TOP = 0;
        VIEWPORT_WIDTH = this.m_engine.getWidth();
        VIEWPORT_HEIGHT = this.m_engine.getHeight();
        VIEWPORT_CENTRE_X = VIEWPORT_LEFT + (VIEWPORT_WIDTH >> 1);
        VIEWPORT_CENTRE_Y = VIEWPORT_TOP + (VIEWPORT_HEIGHT >> 1);
        TRACK_VIEWPORT_HEIGHT = VIEWPORT_HEIGHT - HUD_HEIGHT - 1;
        HUD_POSITION_X = VIEWPORT_CENTRE_X - 1;
        HUD_POSITION_Y = VIEWPORT_HEIGHT;
        HUD_TACHO_POSITION_X = this.m_engine.getWidth();
        HUD_TACHO_POSITION_Y = this.m_engine.getHeight() - 9;
        int n = this.m_engine.getStringWidth(194, this.m_engine.getFont(1));
        int n2 = this.m_engine.getStringWidth(195, this.m_engine.getFont(1));
        HUD_WINGEDBOX_INFO_WIDTH = Math.max(n, n2);
        this.m_HUDWarningX = VIEWPORT_CENTRE_X;
        this.m_HUDWarningY = VIEWPORT_TOP + TRACK_VIEWPORT_HEIGHT >> 1;
        this.m_nitroBarWidth = 97;
        this.m_nitroBarHeight = 9;
        this.m_raceIntroCameraDivF = MathExt.Fdiv(0x3E0000, 0x7D00000);
        HUD_LAP_POSITION_X = VIEWPORT_WIDTH - 1;
        HUD_DRIFT_POSITION_X = VIEWPORT_WIDTH >> 1;
        this.m_invRoadHeightViewport = MathExt.Fdiv(58982, 0x520000);
        this.m_primitiveObjScaleBaseF = MathExt.Fdiv(TRACK1_WIDTHS[0] << 16, TRACK1_WIDTHS[82] << 16);
        this.m_primitiveObjScaleRangeMultiplierF = MathExt.Fdiv(65536 - this.m_primitiveObjScaleBaseF, 0x520000);
    }

    private void renderLapTimes(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        MixedFont mixedFont = appEngine.getFont(1);
        int n = appEngine.getHalfWidth();
        appEngine.getAnimationManager().drawAnimFrame(graphics, 296, 0, n, 91);
        if (this.m_playerCar.m_numLapsCompleted + 1 == this.m_raceMaxLaps) {
            appEngine.drawString(graphics, 98, mixedFont, n, 94, 17);
        } else if (this.m_playerCar.m_numLapsCompleted == this.m_raceMaxLaps) {
            appEngine.drawString(graphics, 112, mixedFont, n, 94, 17);
        } else {
            appEngine.drawChars(graphics, this.m_eolLapBytes, mixedFont, n, 94, 17);
        }
        appEngine.drawChars(graphics, this.m_endOfLapStatsBytes[0], mixedFont, n, 111, 17);
        appEngine.drawChars(graphics, this.m_endOfLapStatsBytes[1], mixedFont, n, 123, 17);
    }

    private void showLastLapTime() {
        this.m_lastLapDisplayTimer = 0;
        this.m_lastLapTimeShowing = true;
    }

    private void hideLastLapTime() {
        this.m_lastLapTimeShowing = false;
    }

    private void showBestLapTime() {
        this.m_bestLapDisplayTimer = 0;
        this.m_bestLapTimeShowing = true;
    }

    private void hideBestLapTime() {
        this.m_bestLapTimeShowing = false;
    }

    private void updateLapTimeDisplay(int n) {
        if (this.m_lastLapTimeShowing) {
            this.m_lastLapDisplayTimer += n;
            if (this.m_lastLapDisplayTimer >= 262144) {
                this.hideLastLapTime();
            }
        }
        if (this.m_bestLapTimeShowing) {
            this.m_bestLapDisplayTimer += n;
            if (this.m_bestLapDisplayTimer >= 262144) {
                this.hideBestLapTime();
            }
        }
    }

    private void updateCollisions(int n) {
        for (int i = 0; i < this.m_carsTrackOrder.length - 1; ++i) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6 = i + 1;
            if (n6 == this.m_carsTrackOrder.length) {
                n6 = 0;
            }
            GameObject gameObject = this.m_carsTrackOrder[i];
            GameObject gameObject2 = this.m_carsTrackOrder[n6];
            int n7 = gameObject2.m_trackPosF - gameObject.m_trackPosF;
            if (n7 < 0) {
                n7 += this.m_trackTotalDistance << 16;
            }
            if (n7 > (n5 = this.m_carCollisionLengthsF[this.getCarAnimIDIndex(this.m_trackSectionCurvature[gameObject.m_currSection])]) + (n4 = this.m_carCollisionLengthsF[this.getCarAnimIDIndex(this.m_trackSectionCurvature[gameObject2.m_currSection])])) continue;
            int n8 = gameObject2.m_lateralPosF - gameObject.m_lateralPosF;
            if (n8 < 0) {
                n8 = -n8;
            }
            if (n8 > (n3 = this.m_carCollisionWidthsF[this.getCarAnimIDIndex(this.m_trackSectionCurvature[gameObject.m_currSection])]) + (n2 = this.m_carCollisionWidthsF[this.getCarAnimIDIndex(this.m_trackSectionCurvature[gameObject2.m_currSection])])) continue;
            gameObject.m_speedF = MathExt.Fmul(gameObject2.m_speedF, 49152);
            if (gameObject.getType() == 1) {
                this.m_playerCar.setCurrentGear(this.getGearForSpeed(gameObject.m_speedF));
                this.m_redrawHUDGear = true;
                this.m_gearBytes = AppEngine.intToByteArray(this.m_playerCar.getCurrentGear() + 1);
                if (this.m_driftMiniGameActivated) {
                    this.m_chainedDriftComboCount = 1;
                    this.cancelDriftMiniGame();
                    this.startCrashCutscene();
                }
                this.m_collisionBrakingTimeout = 300;
            }
            if (gameObject.getType() != 1 && gameObject2.getType() != 1) continue;
            int n9 = MathExt.Fmul(gameObject.m_speedF, this.m_playerCarCollisionPushDiv);
            if ((n9 = MathExt.Fmul(n9, this.m_playerSteeringMaxF)) > this.m_playerSteeringMaxF) {
                n9 = this.m_playerSteeringMaxF;
            }
            this.m_playerSteeringAngleF = gameObject.m_lateralPosF > gameObject2.m_lateralPosF ? n9 : -n9;
            if (!this.m_playerImpactSparkAnimPlayer.isAnimating()) {
                this.m_playerImpactSparkAnimPlayer.startAnim(294, true, false);
                this.m_playerImpactSparkX = gameObject2.m_renderPosX + gameObject.m_renderPosX >> 1;
                if (gameObject.getType() == 1) {
                    this.m_playerBumpedFront = true;
                    this.m_playerImpactSparkY = gameObject2.m_renderPosY + -12;
                } else {
                    this.m_playerBumpedFront = false;
                    this.m_playerImpactSparkY = gameObject.m_renderPosY + -12;
                }
            }
            this.m_engine.vibrate(250);
        }
    }

    private void updateOpponentCarsLateralPos(int n) {
        for (int i = 0; i < this.m_numOpponentCars; ++i) {
            boolean bl;
            GameObject gameObject = this.m_opponentCars[i];
            int n2 = this.m_playerCar.m_trackPosF - gameObject.m_trackPosF;
            boolean bl2 = bl = n2 > 0 && n2 < 983040;
            if (bl && (this.m_driftMiniGameActivated || this.m_crashCutscenePlaying)) {
                int n3 = this.getOvertakingPos(gameObject, this.m_playerCar);
                gameObject.m_lateralPosSpeedF = 0;
                gameObject.m_lateralPosF = n3;
                continue;
            }
            if (gameObject.m_lateralPosF < gameObject.m_lateralPosTargetF) {
                gameObject.m_lateralPosSpeedF = gameObject.m_lateralPosSpeedF < 0 ? 0 : (gameObject.m_lateralPosSpeedF += MathExt.Fmul(gameObject.m_lateralPosAccelF, n));
                gameObject.m_lateralPosF += MathExt.Fmul(gameObject.m_lateralPosSpeedF, n);
            } else if (gameObject.m_lateralPosF > gameObject.m_lateralPosTargetF) {
                gameObject.m_lateralPosSpeedF = gameObject.m_lateralPosSpeedF > 0 ? 0 : (gameObject.m_lateralPosSpeedF -= MathExt.Fmul(gameObject.m_lateralPosAccelF, n));
                gameObject.m_lateralPosF += MathExt.Fmul(gameObject.m_lateralPosSpeedF, n);
            }
            if (gameObject.m_lateralPosF < -65536) {
                gameObject.m_lateralPosF = -65536;
                continue;
            }
            if (gameObject.m_lateralPosF <= 65536) continue;
            gameObject.m_lateralPosF = 65536;
        }
    }

    private void renderDebugTrack(Graphics graphics, boolean bl) {
        if (bl) {
            graphics.setColor(-16777216);
            graphics.fillRect(VIEWPORT_LEFT, VIEWPORT_TOP, VIEWPORT_WIDTH, VIEWPORT_HEIGHT);
        }
        graphics.setColor(-10461088);
        graphics.drawArc(VIEWPORT_CENTRE_X - 60, VIEWPORT_CENTRE_Y - 60, 120, 120, 0, 360);
        graphics.setColor(-8355712);
        graphics.drawArc(VIEWPORT_CENTRE_X - 50, VIEWPORT_CENTRE_Y - 50, 100, 100, 0, 360);
        graphics.setColor(-8355712);
        graphics.drawArc(VIEWPORT_CENTRE_X - 70, VIEWPORT_CENTRE_Y - 70, 140, 140, 0, 360);
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.m_numOpponentCars + 1; ++i) {
            GameObject gameObject = this.m_carsTrackOrder[i];
            int n3 = MathExt.Fdiv(gameObject.m_trackPosF >> 4, this.m_trackTotalDistance << 12);
            n3 = MathExt.Fmul(n3, 411775);
            int n4 = MathExt.Fcos(n3);
            int n5 = MathExt.Fsin(n3);
            int n6 = 0x3C0000 - MathExt.Fmul(655360, gameObject.m_lateralPosF);
            n4 = MathExt.Fmul(n4, n6);
            n5 = MathExt.Fmul(n5, n6);
            int n7 = VIEWPORT_CENTRE_X + (n4 >> 16);
            int n8 = VIEWPORT_CENTRE_Y + (n5 >> 16);
            if (gameObject.getType() == 1) {
                n = n7;
                n2 = n8;
                continue;
            }
            if (gameObject == this.m_nextOpponentRaceOrder) {
                graphics.setColor(-256);
                graphics.fillRect(n7 - 4, n8 - 4, 8, 8);
            } else if (gameObject == this.m_prevOpponentRaceOrder) {
                graphics.setColor(-16776961);
                graphics.fillRect(n7 - 4, n8 - 4, 8, 8);
            }
            graphics.setColor(-4169632);
            graphics.fillRect(n7 - 1, n8 - 1, 3, 3);
            if (gameObject.m_mood == 1) {
                graphics.setColor(-16777216);
            } else if (gameObject.m_mood == 2) {
                graphics.setColor(-1);
            } else {
                graphics.setColor(-32640);
            }
            graphics.fillRect(n7, n8, 1, 1);
        }
        graphics.setColor(-10460992);
        graphics.fillRect(n - 1, n2 - 1, 3, 3);
        graphics.setColor(-8355585);
        graphics.fillRect(n, n2, 1, 1);
    }

    private int getRandomAIMood() {
        int n = this.m_engine.rand(1, 100);
        if (n < 10) {
            return 2;
        }
        if (n < 20) {
            return 1;
        }
        return 0;
    }

    private int getOvertakingPos(GameObject gameObject, GameObject gameObject2) {
        int n = 0;
        if (gameObject2 == this.m_playerCar && (this.m_driftMiniGameActivated || this.m_crashCutscenePlaying)) {
            n = gameObject2.m_lateralPosF < 0 ? 65536 : -65536;
        } else if (gameObject2.m_lateralPosF < gameObject.m_lateralPosF) {
            n = gameObject2.m_lateralPosF + 32768;
            if (n > 65536) {
                n = gameObject2.m_lateralPosF - 32768;
            }
        } else {
            n = gameObject2.m_lateralPosF - 32768;
            if (n < -65536) {
                n = gameObject2.m_lateralPosF + 32768;
            }
        }
        return n;
    }

    private int getAvoidingPos(GameObject gameObject, GameObject gameObject2) {
        int n = 0;
        if (gameObject2.m_lateralPosF < gameObject.m_lateralPosF) {
            n = gameObject.m_lateralPosF + 32768;
            if (n > 65536) {
                n = 65536;
            }
        } else {
            n = gameObject.m_lateralPosF - 32768;
            if (n < -65536) {
                n = -65536;
            }
        }
        return n;
    }

    private void updateOpponentCarsSteering(int n) {
        for (int i = 0; i < this.m_numOpponentCars + 1; ++i) {
            int n2;
            GameObject gameObject = this.m_carsTrackOrder[i];
            if (gameObject.getType() != 2) continue;
            gameObject.m_AITimeF += n;
            if (gameObject.m_AITimeF <= gameObject.m_AILimitF) continue;
            gameObject.m_AITimeF = 0;
            int n3 = i + 1;
            if (n3 >= this.m_numOpponentCars + 1) {
                n3 = 0;
            }
            GameObject gameObject2 = this.m_carsTrackOrder[n3];
            int n4 = gameObject2.m_trackPosF - gameObject.m_trackPosF;
            if (n4 > 0x430000 && n4 < 0xC80000) {
                n2 = gameObject2.m_lateralPosF - gameObject.m_lateralPosF;
                if (n2 < 0) {
                    n2 = -n2;
                }
                if (n2 < 32768) {
                    gameObject.m_lateralPosTargetF = this.getOvertakingPos(gameObject, gameObject2);
                    return;
                }
            }
            if ((n2 = i - 1) < 0) {
                n2 = this.m_numOpponentCars;
            }
            GameObject gameObject3 = this.m_carsTrackOrder[n2];
            int n5 = gameObject.m_trackPosF - gameObject3.m_trackPosF;
            if (n5 > 0x430000 && n5 < 0xC80000) {
                if (gameObject.m_mood == 1) {
                    gameObject.m_lateralPosTargetF = gameObject3.m_lateralPosF;
                    return;
                }
                if (gameObject.m_mood == 2) {
                    gameObject.m_lateralPosTargetF = this.getAvoidingPos(gameObject, gameObject3);
                    return;
                }
            }
            gameObject.m_lateralPosTargetF = this.getAIRacingLineLateralPos(gameObject);
            if (gameObject.m_lateralPosTargetF == 0) {
                int n6 = gameObject.m_ID + gameObject.m_currSection & 3;
                switch (n6) {
                    case 0: {
                        gameObject.m_lateralPosTargetF = 39322;
                        break;
                    }
                    case 1: {
                        gameObject.m_lateralPosTargetF = 19661;
                        break;
                    }
                    case 2: {
                        gameObject.m_lateralPosTargetF = -19661;
                        break;
                    }
                    default: {
                        gameObject.m_lateralPosTargetF = -39322;
                    }
                }
            }
            gameObject.m_lateralPosTargetF += this.m_engine.rand(0, 13107) - 6554;
        }
    }

    private int getAIRacingLineLateralPos(GameObject gameObject) {
        int n = this.m_trackSectionCurvature[gameObject.m_currSection];
        if (n == 0 && !gameObject.isMaximumGearAllowed()) {
            int n2 = gameObject.m_currSection + 1;
            if (n2 >= this.m_trackNumSections) {
                n2 -= this.m_trackNumSections;
            }
            n = this.m_trackSectionCurvature[n2];
        }
        return this.getRacingLineLateralPosForCurvature(n);
    }

    private int getRacingLineLateralPosForCurvature(int n) {
        int n2 = n << 14;
        return n2;
    }

    private int getPlayerCarAnimID() {
        if (this.m_playerCar.m_finishedRace) {
            return 8;
        }
        int n = 4;
        if (this.m_isSteeringLeft) {
            n = 3;
        } else if (this.m_isSteeringRight) {
            n = 5;
        }
        if (this.m_playerCarDriftingAngleCurrentF != 0) {
            int n2 = this.m_playerCarDriftingAngleCurrentF < 0 ? 8 : 0;
            int n3 = n2 - n;
            int n4 = n3 > 0 ? 1 : -1;
            int n5 = this.m_playerCarDriftingAngleTargetF;
            if (n5 == 0) {
                n5 = n4 == 1 ? 51472 : -51472;
            }
            if (Math.abs(n3) == 1) {
                n = n2;
            } else if (Math.abs(n3) == 2) {
                n = Math.abs(this.m_playerCarDriftingAngleCurrentF) < Math.abs(n5) >> 1 ? (n += n4) : n2;
            } else if (Math.abs(n3) == 3) {
                int n6 = Math.abs(n5) / 3;
                n = Math.abs(this.m_playerCarDriftingAngleCurrentF) < n6 ? (n += n4) : (Math.abs(this.m_playerCarDriftingAngleCurrentF) < n6 << 1 ? (n += 2 * n4) : n2);
            } else if (Math.abs(n3) == 4) {
                int n7 = Math.abs(n5) >> 2;
                n = Math.abs(this.m_playerCarDriftingAngleCurrentF) < n7 ? (n += n4) : (Math.abs(this.m_playerCarDriftingAngleCurrentF) < n7 << 1 ? (n += 2 * n4) : (Math.abs(this.m_playerCarDriftingAngleCurrentF) < 3 * n7 ? (n += 3 * n4) : n2));
            }
        }
        return n;
    }

    private byte getGearForSpeed(int n) {
        int n2 = 0;
        for (int n3 = 0; n3 < 6; n3 = (int)((byte)(n3 + 1))) {
            if (n > this.m_playerCar.getGearMaxSpeed(n3)) continue;
            n2 = n3;
            break;
        }
        return (byte)n2;
    }

    private void renderHUDTime(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        graphics.setColor(-12303549);
        graphics.fillRect(n, n2, n3, n4);
        if (n5 > 0 && n5 < 0x640000) {
            this.m_engine.drawString(graphics, MathExt.fixedToString2DP(n5), this.m_engine.getFont(1), n + (n3 >> 1), n2 + (n4 >> 1), 3);
        }
    }

    private void calcIntroSlopeHeights() {
        this.m_slopeSourceHeights[0] = 83;
        this.m_slopeDestYs[0] = 83 - (62 - (this.m_raceIntroCameraOffsetF + 32768 >> 16));
        this.m_numSlopeSections = 1;
    }

    private void calculateWingedBoxWidth(int n, int n2) {
        int n3 = (n >> 1) + 3;
        if (n2 == 2) {
            this.m_wingedBoxBackingLeft = this.m_engine.getHalfWidth() - n3;
            this.m_wingedBoxBackingRight = this.m_engine.getHalfWidth() + n3;
        } else {
            this.m_driftBorderLeft = this.m_engine.getHalfWidth() - n3;
            this.m_driftBorderRight = this.m_engine.getHalfWidth() + n3;
        }
    }

    private void startDriftMiniGame() {
        this.m_driftMiniGameDelayTimer = 800;
        this.m_driftTextFlashTimer = 300;
        this.m_driftMiniGameTargetDotMatched = true;
        this.hideDriftScore();
        this.m_lastLapTimeShowing = false;
        this.setPlayerBoosting(false);
        this.m_playerCar.m_isAccelerating = false;
        this.m_driftMiniGameActivated = true;
        this.m_driftMiniGameNeedleMomentumDir = this.m_engine.rand(0, 1);
        if (this.m_driftMiniGameNeedleMomentumDir == 0) {
            this.m_driftMiniGameNeedleMomentumDir = -1;
        }
        this.m_driftMiniGameNeedlePosF = 0;
        this.m_driftMiniGameLeftPressed = false;
        this.m_driftMiniGameRightPressed = false;
        this.m_isSteeringLeft = false;
        this.m_isSteeringRight = false;
        this.m_playerSteeringAngleF = 0;
        this.m_driftScoreDisplayed = false;
        int n = this.m_engine.getStringWidth(128, this.m_engine.getFont(1));
        this.calculateWingedBoxWidth(n, 0);
        this.m_driftMiniGameTimerF = 0;
    }

    private static int getDriftMiniGameTargetPos(int n) {
        return 0;
    }

    private void cancelDriftMiniGame() {
        this.m_driftMiniGameActivated = false;
        this.m_playerCar.m_isAccelerating = true;
        this.calculateWingedBoxWidth(HUD_WINGEDBOX_INFO_WIDTH, 3);
    }

    private void endDriftMiniGame() {
        this.cancelDriftMiniGame();
        this.m_driftMiniGameLastScore = this.m_driftMiniGameTimerF >> 12;
        int n = this.m_driftMiniGameLastScore >> 1;
        if (n > this.m_biggestDriftScore) {
            this.m_biggestDriftScore = n;
        }
        this.m_driftScoreThisRace += n;
        this.m_driftCashBytes[1] = AppEngine.intToByteArray(n);
        this.m_boostAnimPlayer.startAnim(this.m_boostAnimIDs[this.getPlayerCarAnimID()], false, true);
        this.m_boostGaugeLevel += this.m_driftMiniGameLastScore * 4368;
        if (this.m_boostGaugeLevel >= 0x640000) {
            this.m_boostGaugeLevel = 0x640000;
        }
        if (this.m_driftMiniGameLastScore > 0) {
            this.m_bonusNitroBoostTimer = this.m_driftMiniGameLastScore * 8;
            this.setPlayerBoosting(true);
            MixedFont mixedFont = this.m_engine.getFont(1);
            int n2 = this.m_engine.getStringWidth(189, mixedFont);
            int n3 = mixedFont.getStringWidth(this.m_driftCashBytes[0], 0, this.m_driftCashBytes[0].length) + mixedFont.getStringWidth(this.m_driftCashBytes[1], 0, this.m_driftCashBytes[1].length);
            this.calculateWingedBoxWidth(Math.max(n2, n3), 2);
            int n4 = this.m_nitroBarWidth - 2;
            int n5 = MathExt.Fmul(this.m_driftMiniGameLastScore * 4368, this.m_boostGaugeDivF);
            this.m_boostGaugeBonusWidth = MathExt.Fmul(n5, n4 << 16) + 32768 >> 16;
            if (this.m_boostGaugeBonusWidth > n4) {
                this.m_boostGaugeBonusWidth = n4;
            }
            this.showDriftScore();
        }
    }

    private void updateDriftMiniGameNeedle(int n) {
        if (this.m_driftMiniGameNeedlePosF < this.m_driftMiniGameTargetPosF && this.m_driftMiniGameNeedleMomentumDir == 1) {
            this.m_driftMiniGameNeedleMomentumDir = -1;
        } else if (this.m_driftMiniGameNeedlePosF > this.m_driftMiniGameTargetPosF && this.m_driftMiniGameNeedleMomentumDir == -1) {
            this.m_driftMiniGameNeedleMomentumDir = 1;
        }
        int n2 = this.m_driftMiniGameNeedlePosF - this.m_driftMiniGameTargetPosF;
        int n3 = 32768 + MathExt.Fmul(29491, Math.abs(n2));
        int n4 = MathExt.Fmul(65536, n3);
        this.m_driftMiniGameNeedlePosF += this.m_driftMiniGameNeedleMomentumDir * MathExt.Fmul(n4, n);
        int n5 = 65536 + MathExt.Fmul(49152, Math.abs(this.m_playerCarDriftDiffTargetF));
        if (this.m_driftMiniGameLeftPressed) {
            this.m_driftMiniGameNeedlePosF -= MathExt.Fmul(n5, n);
        } else if (this.m_driftMiniGameRightPressed) {
            this.m_driftMiniGameNeedlePosF += MathExt.Fmul(n5, n);
        }
        boolean bl = this.m_driftMiniGameTargetDotMatched;
        n2 = this.m_driftMiniGameNeedlePosF - this.m_driftMiniGameTargetPosF;
        this.m_driftMiniGameTargetDotMatched = Math.abs(n2) <= 32768;
        bl = !bl && this.m_driftMiniGameTargetDotMatched || bl && !this.m_driftMiniGameTargetDotMatched;
        this.m_driftMiniGameTimerF += n;
        if (this.m_driftMiniGameTargetDotMatched) {
            this.m_driftMiniGameTimerF += MathExt.Fmul(327680, n);
        }
        if (bl) {
            int n6 = this.m_engine.getStringWidth(this.m_driftMiniGameTargetDotMatched ? 128 : 190, this.m_engine.getFont(1));
            this.calculateWingedBoxWidth(n6, this.m_driftMiniGameTargetDotMatched ? 0 : 1);
        }
        if (Math.abs(this.m_driftMiniGameNeedlePosF) >= 65536) {
            this.m_chainedDriftComboCount = 1;
            this.cancelDriftMiniGame();
            this.startCrashCutscene();
        }
    }

    private void processKeysDriftMiniGame(int n, int n2) {
        this.m_engine.overrideKeyStates();
        if ((n & 0x1020) != 0) {
            this.endDriftMiniGame();
            this.m_engine.clearKeyBit(4128);
            return;
        }
        if (this.m_driftMiniGameDelayTimer <= 0) {
            this.m_driftMiniGameLeftPressed = (n & 0x8010) != 0;
            boolean bl = this.m_driftMiniGameRightPressed = (n & 0x10040) != 0;
        }
        if ((n & 0x4100) == 0 && this.m_playerCar.m_isBraking) {
            this.m_playerCar.m_isBraking = false;
        }
    }

    private void renderHUDDriftMiniGame(Graphics graphics) {
        if (this.m_driftMiniGameDelayTimer <= 0 || this.m_driftTextFlashTimer > 150) {
            int n = this.m_driftMiniGameTargetDotMatched ? 274 : 273;
            int n2 = this.m_engine.getAnimationManager().getAnimFrameWidth(271, 0);
            this.m_engine.getAnimationManager().drawAnimFrame(graphics, 271, 0, HUD_DRIFT_POSITION_X, HUD_DRIFT_POSITION_Y);
            int n3 = HUD_DRIFT_POSITION_X + (MathExt.Fmul(n2 << 15, this.m_driftMiniGameNeedlePosF) >> 16);
            this.m_engine.getAnimationManager().drawAnimFrame(graphics, n, 0, n3, HUD_DRIFT_POSITION_Y);
        }
    }

    private void updateSmoke(int n) {
        int n2 = this.m_trackSectionCurvature[this.m_playerCar.m_currSection];
        if (this.m_crashCutscenePlaying) {
            this.m_smokingLeftWheel = false;
            this.m_smokingRightWheel = false;
            return;
        }
        if (this.m_takeOffSmokeTimer > 0) {
            this.m_smokingLeftWheel = true;
            this.m_smokingRightWheel = true;
            return;
        }
        if (this.m_playerOffTrack) {
            if (this.m_playerCar.m_lateralPosF < 0) {
                this.m_smokingLeftWheel = true;
                this.m_smokingRightWheel = false;
            } else {
                this.m_smokingLeftWheel = false;
                this.m_smokingRightWheel = true;
            }
            return;
        }
        if (n2 == 0) {
            this.m_smokingLeftWheel = false;
            this.m_smokingRightWheel = false;
            return;
        }
        if (this.m_driftMiniGameActivated) {
            this.m_smokingLeftWheel = true;
            this.m_smokingRightWheel = true;
            return;
        }
        int n3 = this.m_playerCarLateralDriftF + this.m_playerUpdateSteeringF;
        if (n2 != 0 && !this.m_driftMiniGameActivated) {
            boolean bl;
            this.m_smokingLeftWheel = bl = !(this.m_playerCar.m_speedF <= 0 || n3 < 0 && n2 > 0 || n3 > 0 && n2 < 0);
            this.m_smokingRightWheel = bl;
        }
    }

    private int getSmokeLeftAnimIDFromCarAnimID(int n) {
        switch (n) {
            case 0: {
                return 239;
            }
            case 1: {
                return 237;
            }
            case 2: {
                return 235;
            }
            case 3: {
                return 233;
            }
            case 4: {
                return 326;
            }
            case 5: {
                return 240;
            }
            case 6: {
                return 242;
            }
            case 7: {
                return 244;
            }
        }
        return -1;
    }

    private int getSmokeRightAnimIDFromCarAnimID(int n) {
        switch (n) {
            case 1: {
                return 238;
            }
            case 2: {
                return 236;
            }
            case 3: {
                return 234;
            }
            case 4: {
                return 327;
            }
            case 5: {
                return 241;
            }
            case 6: {
                return 243;
            }
            case 7: {
                return 245;
            }
            case 8: {
                return 246;
            }
        }
        return -1;
    }

    private void updateCatchupCode(int n) {
        for (int i = 0; i < this.m_carsRaceOrder.length; ++i) {
            GameObject gameObject = this.m_carsRaceOrder[i];
            gameObject.updateCatchupCode(n);
        }
    }

    private void renderRacePosIndicatorRear(Graphics graphics) {
        int n = HUD_POSITION_Y - HUD_HEIGHT - this.m_engine.getAnimationManager().getAnimFrameHeight(295, 0);
        if (this.m_prevOpponentRaceOrder == null) {
            return;
        }
        int n2 = this.m_playerCar.m_trackPosF - this.m_prevOpponentRaceOrder.m_trackPosF >> 16;
        if (n2 < 0) {
            n2 += this.m_trackTotalDistance;
        }
        if (n2 <= 120) {
            int n3 = this.m_prevOpponentRaceOrder.m_lateralPosF - this.m_playerCar.m_lateralPosF;
            int n4 = MathExt.Fmul(TRACK1_WIDTHS[82] << 15, n3) + 32768 >> 16;
            int n5 = (VIEWPORT_WIDTH >> 1) + n4;
            if (n5 < VIEWPORT_LEFT) {
                n5 = VIEWPORT_LEFT;
            } else if (n5 >= VIEWPORT_LEFT + VIEWPORT_WIDTH) {
                n5 = VIEWPORT_LEFT + VIEWPORT_WIDTH - 1;
            }
            this.m_engine.getAnimationManager().drawAnimFrame(graphics, 295, 0, n5, n);
            byte[] byArray = m_racePosByteArrays[this.m_prevOpponentRaceOrder.getRacePos()];
            if (byArray == null) {
                SceneGame.m_racePosByteArrays[this.m_prevOpponentRaceOrder.getRacePos()] = AppEngine.intToByteArray(this.m_prevOpponentRaceOrder.getRacePos() + 1);
                byArray = m_racePosByteArrays[this.m_prevOpponentRaceOrder.getRacePos()];
            }
            this.m_engine.drawChars(graphics, byArray, this.m_engine.getFont(1), n5, n - 8, 3);
        }
    }

    private int getRandomStaticObjectType() {
        int n = 0;
        int n2 = 0;
        switch (this.m_engine.getTrackTheme(this.m_engine.getCurrTrack())) {
            case 0: {
                n = 11;
                n2 = 14;
                break;
            }
            case 1: {
                n = 9;
                n2 = 8;
                break;
            }
            case 2: {
                n = 10;
                n2 = 7;
            }
        }
        int n3 = this.m_engine.rand(0, 1) == 1 ? n : n2;
        return n3;
    }

    private void shuffleOpponentCarAnimIDs() {
        for (int i = 0; i < 128; ++i) {
            int n;
            int n2 = this.m_engine.rand(0, this.m_opponentCarAnimID.length - 1);
            if (n2 == (n = this.m_engine.rand(0, this.m_opponentCarAnimID.length - 1))) continue;
            int n3 = this.m_opponentCarAnimID[n2];
            this.m_opponentCarAnimID[n2] = this.m_opponentCarAnimID[n];
            this.m_opponentCarAnimID[n] = n3;
        }
    }

    static {
        HUD_HEIGHT = 34;
        HUD_GEAR_POSITION_Y = -21;
        HUD_GEAR_CLEAR_POSITION_Y = -30;
        HUD_GEAR_WIDTH = 26;
        HUD_GEAR_HEIGHT = 18;
        HUD_GEAR_NUMBER_XOFFSET = 21;
        HUD_GEAR_POSITION_X = -117;
        HUD_SPEED_POSITION_X = 82;
        HUD_SPEED_UNIT_POSITION_X = 82;
        HUD_BOOST_POSITION_X = 146;
        HUD_DRIFT_POSITION_Y = 112;
        HUD_NEEDLE_ORIGIN_X = 121;
        HUD_SPEED_POSITION_Y = -22;
        HUD_SPEED_WIDTH = 17;
        HUD_SPEED_HEIGHT = 6;
        HUD_SPEED_UNIT_POSITION_Y = -13;
        HUD_BOOST_POSITION_YOFFSET = -25;
        HUD_DRIFTINDICATOR_YPOS = 10;
        HUD_NEEDLE_ORIGIN_Y = -8;
        HUD_NEEDLE_LENGTH_F = 0x190000;
        HUD_NEEDLE_WIDTH_F = 131072;
        HUD_NEEDLE_MIN_ANGLE_F = 212321;
        HUD_NEEDLE_TOTAL_ANGLE_F = 77208;
        HUD_NEEDLE_CLIP_Y = -9;
        HUD_PREV_TIME_OFFSET_X = -56;
        HUD_PREV_NEXT_TIME_OFFSET_Y = -43;
        HUD_NEXT_TIME_OFFSET_X = -1;
        HUD_PREV_NEXT_TIME_WIDTH = 33;
        HUD_PREV_NEXT_TIME_HEIGHT = 8;
        TRACK1_WIDTHS = new int[]{74, 78, 82, 86, 90, 94, 98, 102, 106, 110, 116, 120, 124, 128, 132, 136, 140, 144, 148, 152, 156, 160, 164, 168, 172, 176, 180, 184, 188, 192, 196, 200, 204, 208, 212, 216, 220, 226, 230, 234, 238, 242, 246, 250, 254, 258, 262, 266, 270, 274, 278, 282, 286, 290, 294, 298, 302, 306, 310, 314, 318, 322, 326, 332, 336, 340, 344, 348, 352, 356, 360, 364, 368, 372, 376, 380, 384, 388, 392, 396, 400, 404, 408};
        TRACK1_OFFSETS = new int[]{37, 39, 41, 43, 45, 47, 49, 51, 53, 55, 58, 60, 62, 64, 66, 68, 70, 72, 74, 76, 78, 80, 82, 84, 86, 88, 90, 92, 94, 96, 98, 100, 102, 104, 106, 108, 110, 113, 115, 117, 119, 121, 123, 125, 127, 129, 131, 133, 135, 137, 139, 141, 143, 145, 147, 149, 151, 153, 155, 157, 159, 161, 163, 166, 168, 170, 172, 174, 176, 178, 180, 182, 184, 186, 188, 190, 192, 194, 196, 198, 200, 202, 204};
        TRACK2_WIDTHS = new int[]{74, 78, 82, 86, 90, 94, 98, 102, 106, 110, 116, 120, 124, 128, 132, 136, 140, 144, 148, 152, 156, 160, 164, 168, 172, 176, 180, 184, 188, 192, 196, 200, 204, 208, 212, 216, 220, 226, 230, 234, 238, 242, 246, 250, 254, 258, 262, 266, 270, 274, 278, 282, 286, 290, 294, 298, 302, 306, 310, 314, 318, 322, 326, 332, 336, 340, 344, 348, 352, 356, 360, 364, 368, 372, 376, 380, 384, 388, 392, 396, 400, 404, 408};
        TRACK2_OFFSETS = new int[]{37, 39, 41, 43, 45, 47, 49, 51, 53, 55, 58, 60, 62, 64, 66, 68, 70, 72, 74, 76, 78, 80, 82, 84, 86, 88, 90, 92, 94, 96, 98, 100, 102, 104, 106, 108, 110, 113, 115, 117, 119, 121, 123, 125, 127, 129, 131, 133, 135, 137, 139, 141, 143, 145, 147, 149, 151, 153, 155, 157, 159, 161, 163, 166, 168, 170, 172, 174, 176, 178, 180, 182, 184, 186, 188, 190, 192, 194, 196, 198, 200, 202, 204};
        LOADING_STATS_IDS = new short[]{102, 103, 104};
        m_cameraShakeXAmplitudeInitialF = 131072;
        CAR_SPEEDLINES_ANIM_IDS = new short[]{321, 320, 319, 318, 317, 322, 323, 324, 325};
        CAR_HIGHLIGHT_ANIM_IDS = new short[]{-1, 251, 250, 249, 248, 252, 253, 254, -1};
        EFFECTS_ANIMIDS_BACKFIRE = new short[]{3, 2, 1, 0, 8, 4, 5, 6, 7};
        BRAKES_STD = new short[]{-1, 18, 17, 16, 22, 19, 20, 21, -1};
        BRAKES_350Z = new short[]{-1, 11, 10, 9, 15, 12, 13, 14, -1};
        BRAKES_CHEVY = new short[]{-1, 25, 24, 23, 29, 26, 27, 28, -1};
        BRAKES_MUSTANG = new short[]{-1, 32, 31, 30, 36, 33, 34, 35, -1};
        BRAKES_SHELBY = new short[]{-1, 39, 38, 37, 43, 40, 41, 42, -1};
        m_racePosByteArrays = new byte[9][];
    }
}

