/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.AppEngine;
import javax.microedition.lcdui.Graphics;

abstract class Scene
implements Runnable {
    public static final byte SCENE_MENU = 0;
    public static final byte SCENE_GAME = 1;
    private boolean m_loadingComplete = false;
    private Thread m_loadingThread = null;
    protected int m_loadingProgress = 0;
    public byte m_initialState = (byte)-1;

    Scene() {
    }

    public final boolean isLoadingComplete() {
        return this.m_loadingComplete;
    }

    public final int getLoadingProgress() {
        return this.m_loadingProgress;
    }

    public final void loadScene() {
        this.m_loadingComplete = false;
        if (this.m_loadingThread != null) {
            this.m_loadingThread = null;
        }
        try {
            this.m_loadingThread = new Thread(this);
            Thread.sleep(100L);
            this.m_loadingThread.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected abstract void start();

    public abstract void pause();

    public abstract void resume();

    public abstract void end();

    public abstract void render(Graphics var1);

    public abstract void update(int var1);

    public synchronized void run() {
        System.gc();
        try {
            this.start();
        }
        catch (Throwable throwable) {
            AppEngine.debug("Exception in start: " + throwable.toString());
            throwable.printStackTrace();
        }
        System.gc();
        this.m_loadingComplete = true;
    }

    public abstract void processKeys(int var1, int var2);
}

