/*
 * Decompiled with CFR 0.152.
 */
package viking;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import viking.FontDraw;
import viking.Lang;
import viking.SplashScreen;
import viking.TileMap;
import viking.VikingVex;
import xantus.MIDISoundPlayer;

public class VikingVexCanvas
extends Canvas
implements Runnable {
    public static final int REPAINT_FULL = 0;
    public static final int REPAINT_INFOBOX = 1;
    public static final int REPAINT_BOX = 2;
    public static final int REPAINT_FPS = 3;
    public static final byte MUSIC_YES = 1;
    public static final byte MUSIC_NO = 0;
    private static final int NR_LEVELS = 25;
    private static final int MAX_LEVELS = 32;
    private static final int TILESIZE = 16;
    private static int ARROW_W;
    private static int ARROW_H;
    private static final int MOVE_DOWN = 1;
    private static final int MOVE_UP = 2;
    private static final int MOVE_LEFT = 3;
    private static final int MOVE_RIGHT = 4;
    private static final int MOVE_TIME_VIKING = 400;
    private static final int MOVE_TIME_SCREEN = 250;
    private static final int DT = 50;
    private static int MOVE_TIME;
    private static final int MAX_OBJECTS = 16;
    private static final int FONT_W = 6;
    private static final int FONT_H = 9;
    private static final int GAMESTATE_MENU = 0;
    private static final int GAMESTATE_PLAY = 1;
    private static final int GAMESTATE_LOADGFX = 2;
    private static final int GAMESTATE_MENU_INIT = 3;
    private static final int GAMESTATE_MUSIC_CHOICE = 4;
    private static final int MENU_MAIN = 0;
    private static final int MENU_LEVELCOMPLETE = 1;
    private static final int MENU_INGAME = 2;
    private static final int MENU_GAMECOMPLETE = 3;
    private static final int MENU_HELP = 4;
    private static final int MENU_ABOUT = 5;
    private static final int MENU_SCORES = 6;
    private static final int OBJECT_STONE = 0;
    private static final int OBJECT_BLOCKER = 7;
    private static final int OBJECT_EXIT = 8;
    private static final int IDLE_TIME = 6000;
    private static final int IDLE_ANIM_DELAY = 100;
    private static final int KEYSTATE_NONE = 0;
    private static final int KEYSTATE_PRESS = 1;
    private static final int KEYSTATE_RELEASE = 2;
    private static final char[][] menu_map;
    private final VikingVex midlet;
    private final Display display;
    private int width;
    private int height;
    private int cnt = 0;
    private int pos;
    private int frames = 0;
    private int deltaTime;
    private int totalTime = 0;
    private volatile Thread animationThread = null;
    private int menuPos = 0;
    private int scorePage = 0;
    private int activeMenu = 0;
    private int loadState = 0;
    private InputStream is;
    private String levelStr;
    private boolean showFPS = false;
    private boolean keyRelease = false;
    private int keyState = 0;
    private SplashScreen splash = null;
    private String[] curLang;
    public static final int LeftSoftKey = -6;
    public static final int RightSoftKey = -7;
    private int gameState = 2;
    private boolean levelComplete = false;
    private int nrMoves;
    private boolean mapActive = false;
    private boolean screenScroll = false;
    int screen_scroll_mapPosX;
    int screen_scroll_mapPosY;
    int screenDirection;
    private byte[] mapBuf = new byte[768];
    private int curLevel = 0;
    private char[][] curMap = new char[16][16];
    private int mapPosX = 0;
    private int mapPosY = 0;
    private int mapPosNewX = 0;
    private int mapPosNewY = 0;
    private int xMove = 0;
    private int yMove = 0;
    private int firePress = 0;
    private boolean screenMoving;
    private boolean needXScroll;
    private boolean needYScroll;
    private int[] levelRecord = new int[32];
    private int levelStartX;
    private int levelEndX;
    private int levelStartY;
    private int levelEndY;
    private TileMap menuTileMap = new TileMap();
    private TileMap tileMap = new TileMap();
    private int tileFullX;
    private int tileFullY;
    private int tileFullW;
    private int tileFullH;
    private int playerX;
    private int playerY;
    private int playerDirection = 1;
    private int playerSmooth;
    private boolean playerMoving;
    private int playerIdle = 6000;
    private boolean idleAnim;
    private int idleAnimPos;
    private boolean[] objActive = new boolean[16];
    private boolean[] objMoving = new boolean[16];
    private int[] objType = new int[16];
    private int[] objX = new int[16];
    private int[] objY = new int[16];
    public int repaintMode = 0;
    public int nextRepaintMode = 0;
    private int repaintX;
    private int repaintY;
    private int repaintW;
    private int repaintH;
    private FontDraw fontDraw = new FontDraw(6, 9, 16, 6, " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_\u00b4abcdefghijklmnopqrstuvwxyz{|}~|\u00e1?\u00e9\u00ea\u00ed\u00f1\u00e6\u0161\u00fa\u00fc\u00fd\u00da\u00f3   ");
    private Image fontImg;
    private Image tileImg;
    private Image[] tileGfx = new Image[112];
    private Image playerImg;
    private Image objectImg;
    private Image arrowImg;
    private Image offscreen;
    private Image scrollArrows;
    public byte snd = 1;
    public boolean hide_notify;
    private static final char[] animSequence;
    private static final char[] idleSequence;
    private static final char[] tileType;
    private static String[] infoBoxStr;
    private static int[] infoBoxStrLen;
    private static int infoBoxRows;
    private static int infoBoxCol;
    private int lastKey = 0;
    MIDISoundPlayer music_player;
    static Random rand;
    public static long msNow;
    public static long msLast;
    public static long msTime;
    public boolean be = true;
    static int[] obj_time_to_anim;
    static final int PETRIFY = 9;
    static final int FLAG = 10;
    static int[] obj_anim;
    static final byte DOWN = 0;
    static final byte RIGHT = 1;
    static final byte UP = 2;
    static final byte LEFT = 3;
    static final byte ARR_ACTIVE = 1;
    static final byte ARR_NORM = 0;
    static final byte ARR_INACT = 2;
    static byte[] scrollArrow_states;
    static int[] scrollArrow_X;
    static int[] scrollArrow_Y;
    static int[] scrollArrow_DRX;
    static int[] scrollArrow_DRY;
    static int scrollArrow_anim;
    static int scrollArr_inc;
    static int arrow_h;
    static int arrow_w;
    static final byte MENU_INGAME_WIDTH = 15;
    static final byte after_sound = 1;
    static boolean key0;
    static final int[] CHEAT_SEQUENCE;
    static int cheat_pos;

    VikingVexCanvas(VikingVex midlet, Display display) {
        this.midlet = midlet;
        this.display = display;
        rand = new Random();
        this.setFullScreenMode(true);
        this.width = 128;
        this.height = 128;
        for (int i = 0; i < 32; ++i) {
            this.levelRecord[i] = -1;
        }
        this.curLevel = 0;
        this.LoadRecords();
        this.curLang = Lang.language;
        this.music_player = new MIDISoundPlayer(this);
        this.music_player.startPlayer();
        this.splash = new SplashScreen();
        this.splash.Init(this.width);
    }

    public void PlayMainMusic() {
        this.music_player.stopPlayer();
        this.music_player.playSound(1);
    }

    public void PlayMenuMusic() {
        this.music_player.stopPlayer();
        this.music_player.playSound(0);
    }

    public void hideNotify() {
        this.hide_notify = true;
        try {
            if (this.music_player != null) {
                this.music_player.stopPlayer();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showNotify() {
        this.hide_notify = false;
        if (this.gameState == 1 || this.gameState == 0 && this.activeMenu == 2) {
            this.music_player.playSound(1);
        } else if (this.gameState != 2) {
            this.music_player.playSound(0);
        }
        this.repaintMode = 0;
        this.serviceRepaints();
    }

    public void InitTileMap() {
        this.menuTileMap.tileHeight = 16;
        this.menuTileMap.tileWidth = 16;
        this.menuTileMap.mapWidth = 16;
        this.menuTileMap.mapHeight = 16;
        if (this.menuTileMap.mapHeight * this.menuTileMap.tileHeight < this.height) {
            this.menuTileMap.screenHeight = this.menuTileMap.mapHeight * this.menuTileMap.tileHeight;
            this.menuTileMap.screenY = (this.height - this.menuTileMap.screenHeight) / 2;
        } else {
            this.menuTileMap.screenHeight = this.height;
            this.menuTileMap.screenY = 0;
            this.needYScroll = true;
        }
        if (this.menuTileMap.mapWidth * this.menuTileMap.tileWidth < this.width) {
            this.menuTileMap.screenWidth = this.menuTileMap.mapWidth * this.menuTileMap.tileWidth;
            this.menuTileMap.screenX = (this.width - this.menuTileMap.screenWidth) / 2;
        } else {
            this.menuTileMap.screenWidth = this.width;
            this.menuTileMap.screenX = 0;
        }
    }

    private void putInt(byte[] buf, int offset, int value) {
        buf[offset + 0] = (byte)(value >> 24 & 0xFF);
        buf[offset + 1] = (byte)(value >> 16 & 0xFF);
        buf[offset + 2] = (byte)(value >> 8 & 0xFF);
        buf[offset + 3] = (byte)(value >> 0 & 0xFF);
    }

    private int getInt(byte[] buf, int offset) {
        return (buf[offset + 0] & 0xFF) << 24 | (buf[offset + 1] & 0xFF) << 16 | (buf[offset + 2] & 0xFF) << 8 | buf[offset + 3] & 0xFF;
    }

    private void LoadRecords() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"VikingVex", (boolean)true);
            RecordEnumeration en = rs.enumerateRecords(null, null, false);
            byte[] data = new byte[137];
            while (en.hasNextElement()) {
                int index = en.nextRecordId();
                if (137 != rs.getRecordSize(index)) continue;
                rs.getRecord(index, data, 0);
                int tmp = this.getInt(data, 0);
                if (tmp != 1179995212) continue;
                for (int i = 0; i < 32; ++i) {
                    this.levelRecord[i] = this.getInt(data, i * 4 + 4);
                }
                this.curLevel = this.getInt(data, 132);
                this.snd = data[136];
            }
            rs.closeRecordStore();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void SaveRecords(boolean increaseLevel) {
        byte[] data = new byte[137];
        try {
            int i;
            RecordStore rs = RecordStore.openRecordStore((String)"VikingVex", (boolean)true);
            this.putInt(data, 0, 1179995212);
            for (i = 0; i < 32; ++i) {
                this.putInt(data, i * 4 + 4, this.levelRecord[i]);
            }
            i = this.curLevel;
            if (increaseLevel && ++i > 24) {
                i = 24;
            }
            this.putInt(data, 132, i);
            data[136] = this.snd;
            try {
                rs.setRecord(1, data, 0, data.length);
                rs.closeRecordStore();
            }
            catch (InvalidRecordIDException e) {
                try {
                    i = rs.addRecord(data, 0, data.length);
                    rs.closeRecordStore();
                }
                catch (RecordStoreException recordstoreexception) {
                }
            }
            catch (RecordStoreException recordstoreexception1) {}
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    void LoadGfx(int state) {
        try {
            if (state < 4) {
                switch (state) {
                    case 0: {
                        this.fontImg = Image.createImage((String)"/font.png");
                        this.scrollArrows = Image.createImage((String)"/scroll_arrows.png");
                        break;
                    }
                    case 1: {
                        this.playerImg = Image.createImage((String)"/player.png");
                        break;
                    }
                    case 2: {
                        this.objectImg = Image.createImage((String)"/objects.png");
                        this.arrowImg = Image.createImage((String)"/arrow.png");
                        ARROW_W = this.arrowImg.getWidth() + 2;
                        ARROW_H = this.arrowImg.getHeight() + 2;
                        break;
                    }
                    case 3: {
                        this.tileImg = Image.createImage((String)"/tiles1.png");
                    }
                }
            } else if (state < 11) {
                int y = state - 4;
                int i = y * 8;
                for (int x = 0; x < 8; ++x) {
                    this.tileGfx[i] = Image.createImage((int)16, (int)16);
                    this.tileGfx[i].getGraphics().drawImage(this.tileImg, x * -16, y * -16, 20);
                    ++i;
                }
            } else if (state == 11) {
                this.tileImg = null;
                System.gc();
                this.tileImg = Image.createImage((String)"/tiles2.png");
            } else {
                int y = state - 12;
                int i = 56 + y * 8;
                for (int x = 0; x < 8; ++x) {
                    this.tileGfx[i] = Image.createImage((int)16, (int)16);
                    this.tileGfx[i].getGraphics().drawImage(this.tileImg, x * -16, y * -16, 20);
                    ++i;
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    void startAnimation() {
        this.animationThread = new Thread(this);
        this.animationThread.start();
    }

    void stopAnimation() {
        try {
            this.music_player.stopPlayer();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.animationThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int millis_per_tick = 50;
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        Thread currentThread = Thread.currentThread();
        try {
            this.deltaTime = millis_per_tick;
            while (currentThread == this.animationThread) {
                long startTime = System.currentTimeMillis();
                long stop_at = startTime + (long)millis_per_tick;
                switch (this.gameState) {
                    case 2: {
                        if (this.totalTime < 4500) break;
                        if (this.splash != null) {
                            this.splash.dispose();
                            this.splash = null;
                            System.out.println(Runtime.getRuntime().freeMemory());
                        }
                        this.LoadGfx(this.loadState);
                        System.out.println(this.loadState + ": " + Runtime.getRuntime().freeMemory());
                        ++this.loadState;
                        if (this.loadState != 19) break;
                        System.gc();
                        System.out.println(Runtime.getRuntime().freeMemory());
                        this.gameState = 3;
                        if (this.snd != 1) break;
                        this.music_player.playSound(0);
                        break;
                    }
                    case 0: {
                        this.repaintMode = 0;
                        this.HandleMenu();
                        break;
                    }
                    default: {
                        if (this.repaintMode != 2) {
                            this.tileMap.screenX = this.tileFullX;
                            this.tileMap.screenY = this.tileFullY;
                            this.tileMap.screenWidth = this.tileFullW;
                            this.tileMap.screenHeight = this.tileFullH;
                            this.repaintX = 0;
                            this.repaintY = 0;
                            this.repaintW = this.width;
                            this.repaintH = this.height;
                            break;
                        }
                        switch (this.playerDirection) {
                            case 3: {
                                x = this.playerX * 16 + this.tileFullX - 32 - this.mapPosX;
                                y = this.playerY * 16 + this.tileFullY - 16 - this.mapPosY;
                                w = 80;
                                h = 48;
                                break;
                            }
                            case 4: {
                                x = this.playerX * 16 + this.tileFullX - 32 - this.mapPosX;
                                y = this.playerY * 16 + this.tileFullY - 16 - this.mapPosY;
                                w = 80;
                                h = 48;
                                break;
                            }
                            case 2: {
                                x = this.playerX * 16 + this.tileFullX - 16 - this.mapPosX;
                                y = this.playerY * 16 + this.tileFullY - 32 - this.mapPosY;
                                w = 48;
                                h = 80;
                                break;
                            }
                            case 1: {
                                x = this.playerX * 16 + this.tileFullX - 16 - this.mapPosX;
                                y = this.playerY * 16 + this.tileFullY - 32 - this.mapPosY;
                                w = 48;
                                h = 80;
                            }
                        }
                        if (x < 0) {
                            x = 0;
                        }
                        if (y < 0) {
                            y = 0;
                        }
                        if (x + w > this.width) {
                            w = this.width - x;
                        }
                        if (y + h > this.height) {
                            h = this.height - y;
                        }
                        this.tileMap.screenX = x;
                        this.tileMap.screenY = y;
                        this.tileMap.screenWidth = w;
                        this.tileMap.screenHeight = h;
                        this.repaintX = x;
                        this.repaintY = y;
                        this.repaintW = w;
                        this.repaintH = h;
                    }
                }
                this.repaint(0, 0, this.width, this.height);
                this.serviceRepaints();
                ++this.frames;
                VikingVexCanvas vikingVexCanvas = this;
                synchronized (vikingVexCanvas) {
                    do {
                        Thread.sleep(10L);
                    } while (System.currentTimeMillis() < stop_at);
                }
                this.totalTime += this.deltaTime;
                msLast = startTime;
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    public void LoadLevel(String mapName) {
        try {
            this.is = this.getClass().getResourceAsStream(mapName);
            this.is.read(this.mapBuf);
            this.is.close();
            int i = 0;
            for (int y = 0; y < 16; ++y) {
                for (int x = 0; x < 16; ++x) {
                    this.curMap[y][x] = (char)this.mapBuf[i++];
                }
            }
            for (i = 0; i < 16; ++i) {
                this.objActive[i] = false;
            }
            i = 0;
            int j = 0;
            while (this.mapBuf[262 + i] != -1) {
                this.objActive[j] = true;
                this.objType[j] = this.mapBuf[262 + i++];
                this.objX[j] = this.mapBuf[262 + i++];
                this.objY[j] = this.mapBuf[262 + i++];
                ++j;
            }
            this.mapPosX = 0;
            this.mapPosY = 0;
            this.playerX = this.mapBuf[260];
            this.playerY = this.mapBuf[261];
            this.levelStartX = this.mapBuf[256];
            this.levelStartY = this.mapBuf[257];
            this.levelEndX = this.mapBuf[258];
            this.levelEndY = this.mapBuf[259];
            this.playerDirection = 1;
            this.tileMap.tileHeight = 16;
            this.tileMap.tileWidth = 16;
            this.tileMap.mapWidth = 16;
            this.tileMap.mapHeight = 16;
            if (this.tileMap.mapHeight * this.tileMap.tileHeight < this.height) {
                this.tileMap.screenHeight = this.tileMap.mapHeight * this.tileMap.tileHeight;
                this.tileMap.screenY = (this.height - this.tileMap.screenHeight) / 2;
            } else {
                this.tileMap.screenHeight = this.height;
                this.tileMap.screenY = 0;
                this.needYScroll = true;
                if ((this.levelEndY - this.levelStartY) * 16 > this.height) {
                    this.mapPosY = this.levelStartY * 16;
                    while (this.playerY * 16 - this.mapPosY > this.height / 2 && this.mapPosY < this.levelEndY * 16 - this.height) {
                        this.mapPosY += 16;
                    }
                } else {
                    this.mapPosY = (this.levelEndY - this.levelStartY) * 16 / 2 + this.levelStartY * 16 - this.height / 2;
                }
            }
            if (this.tileMap.mapWidth * this.tileMap.tileWidth < this.width) {
                this.tileMap.screenWidth = this.tileMap.mapWidth * this.tileMap.tileWidth;
                this.tileMap.screenX = (this.width - this.tileMap.screenWidth) / 2;
            } else {
                this.tileMap.screenWidth = this.width;
                this.tileMap.screenX = 0;
                this.needXScroll = true;
                if ((this.levelEndX - this.levelStartX) * 16 > this.width) {
                    this.mapPosX = this.levelStartX * 16;
                    while (this.playerX * 16 - this.mapPosX > this.width / 2 && this.mapPosX < this.levelEndX * 16 - this.width) {
                        this.mapPosX += 16;
                    }
                } else {
                    this.mapPosX = (this.levelEndX - this.levelStartX) * 16 / 2 + this.levelStartX * 16 - this.width / 2;
                }
            }
            this.tileFullX = this.tileMap.screenX;
            this.tileFullY = this.tileMap.screenY;
            this.tileFullW = this.tileMap.screenWidth;
            this.tileFullH = this.tileMap.screenHeight;
        }
        catch (Exception e) {
            System.out.println("Failed to load level : " + mapName);
        }
    }

    public void InitLevel(int level) {
        this.curLevel = level;
        this.nrMoves = 0;
        this.LoadLevel("/level" + (this.curLevel + 1) + ".map");
        for (int i = 1; i <= 6; ++i) {
            VikingVexCanvas.calcObjAnimTime(i);
        }
        VikingVexCanvas.obj_anim[0] = 0;
        VikingVexCanvas.obj_anim[8] = 0;
        VikingVexCanvas.obj_anim[7] = 0;
        this.screenScroll = false;
    }

    public void UpdateObjects(boolean complete) {
        int i;
        if (complete) {
            for (i = 0; i < 16; ++i) {
                if (!this.objActive[i]) continue;
                int x = this.objX[i];
                int y = this.objY[i];
                for (int j = 0; j < 16; ++j) {
                    if (!this.objActive[j] || j == i || this.objType[i] != this.objType[j] && -this.objType[i] != this.objType[j]) continue;
                    boolean stick = false;
                    if (this.objX[j] == x && this.objY[j] == y + 1) {
                        stick = true;
                    }
                    if (this.objX[j] == x && this.objY[j] == y - 1) {
                        stick = true;
                    }
                    if (this.objX[j] == x + 1 && this.objY[j] == y) {
                        stick = true;
                    }
                    if (this.objX[j] == x - 1 && this.objY[j] == y) {
                        stick = true;
                    }
                    if (!stick) continue;
                    if (this.objType[i] > 0) {
                        this.objType[i] = -this.objType[i];
                    }
                    if (this.objType[j] <= 0) continue;
                    this.objType[j] = -this.objType[j];
                }
            }
            VikingVexCanvas.obj_anim[9] = 6;
        }
        this.levelComplete = true;
        for (i = 0; i < 16; ++i) {
            if (!this.objActive[i] || this.objType[i] == 0 || this.objType[i] == 7 || this.objType[i] == 8) continue;
            this.levelComplete = false;
        }
        if (this.levelComplete) {
            this.levelComplete = false;
            for (i = 0; i < 16; ++i) {
                if (!this.objActive[i]) continue;
                if (this.objType[i] == 7) {
                    obj_anim[7] = obj_anim[7] + 1;
                    if (obj_anim[7] == 6) {
                        this.objActive[i] = false;
                    }
                    this.nextRepaintMode = 0;
                    continue;
                }
                if (this.objType[i] != 8 || this.objX[i] != this.playerX || this.objY[i] != this.playerY) continue;
                this.levelComplete = true;
            }
        }
        if (this.levelComplete && complete) {
            if (this.levelRecord[this.curLevel] == -1 || this.nrMoves < this.levelRecord[this.curLevel]) {
                this.levelRecord[this.curLevel] = this.nrMoves;
                this.SaveRecords(true);
            }
            this.gameState = 0;
            this.activeMenu = 1;
        }
    }

    public void DrawSprite(Graphics g, Image sprite, int x, int y, int w, int h, int r, int c) {
        int w2 = w;
        int h2 = h;
        if (x - this.mapPosX > this.repaintX + this.repaintW || y - this.mapPosY > this.repaintY + this.repaintH) {
            return;
        }
        if (x - this.mapPosX + w < this.repaintX || y - this.mapPosY + h < this.repaintY) {
            return;
        }
        if (x - this.mapPosX + w > this.repaintX + this.repaintW) {
            w2 = this.repaintX + this.repaintW - (x - this.mapPosX);
        }
        if (y - this.mapPosY + h > this.repaintY + this.repaintH) {
            h2 = this.repaintY + this.repaintH - (y - this.mapPosY);
        }
        g.setClip(x - this.mapPosX, y - this.mapPosY, w2, h2);
        g.drawImage(sprite, x - c * w - this.mapPosX, y - r * h - this.mapPosY, 4 | 0x10);
        g.setClip(this.repaintX, this.repaintY, this.repaintW, this.repaintH);
    }

    public static int next_random(int n) {
        int val;
        int bits;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        if ((n & -n) == n) {
            return (int)((long)n * ((long)rand.nextInt() >> 1 & Integer.MAX_VALUE) >> 31);
        }
        while ((bits = rand.nextInt() >> 1 & Integer.MAX_VALUE) - (val = bits % n) + (n - 1) < 0) {
        }
        return val;
    }

    static void calcObjAnimTime(int i) {
        VikingVexCanvas.obj_time_to_anim[i] = 60 + VikingVexCanvas.next_random(60);
    }

    void getScrollArrowStates() {
        VikingVexCanvas.scrollArrow_states[3] = this.mapPosX > this.levelStartX * 16 ? 0 : 2;
        VikingVexCanvas.scrollArrow_states[1] = this.mapPosX < this.levelEndX * 16 - this.width ? 0 : 2;
        VikingVexCanvas.scrollArrow_states[2] = this.mapPosY > this.levelStartY * 16 ? 0 : 2;
        int n = VikingVexCanvas.scrollArrow_states[0] = this.mapPosY < this.levelEndY * 16 - this.height ? 0 : 2;
        if (this.screenMoving) {
            if (this.screenDirection == 3) {
                VikingVexCanvas.scrollArrow_states[3] = 1;
            }
            if (this.screenDirection == 4) {
                VikingVexCanvas.scrollArrow_states[1] = 1;
            }
            if (this.screenDirection == 2) {
                VikingVexCanvas.scrollArrow_states[2] = 1;
            }
            if (this.screenDirection == 1) {
                VikingVexCanvas.scrollArrow_states[0] = 1;
            }
        } else {
            if ((scrollArrow_anim += scrollArr_inc) == 3 || scrollArrow_anim == -3) {
                scrollArr_inc = -scrollArr_inc;
            }
            if (scrollArrow_states[2] == 0) {
                VikingVexCanvas.scrollArrow_DRY[2] = scrollArrow_Y[2] + scrollArrow_anim;
            }
            if (scrollArrow_states[0] == 0) {
                VikingVexCanvas.scrollArrow_DRY[0] = scrollArrow_Y[0] - scrollArrow_anim;
            }
            if (scrollArrow_states[3] == 0) {
                VikingVexCanvas.scrollArrow_DRX[3] = scrollArrow_X[3] + scrollArrow_anim;
            }
            if (scrollArrow_states[1] == 0) {
                VikingVexCanvas.scrollArrow_DRX[1] = scrollArrow_X[1] - scrollArrow_anim;
            }
        }
    }

    void initScrollArrows() {
        int i;
        arrow_h = this.scrollArrows.getHeight() / 3;
        arrow_w = this.scrollArrows.getWidth() / 4;
        VikingVexCanvas.scrollArrow_X[2] = VikingVexCanvas.scrollArrow_X[0] = this.width - arrow_w >> 1;
        VikingVexCanvas.scrollArrow_X[3] = 4;
        VikingVexCanvas.scrollArrow_X[1] = this.width - arrow_w - 4;
        VikingVexCanvas.scrollArrow_Y[3] = VikingVexCanvas.scrollArrow_Y[1] = this.height - arrow_h >> 1;
        VikingVexCanvas.scrollArrow_Y[2] = 4;
        VikingVexCanvas.scrollArrow_Y[0] = this.height - arrow_h - 4;
        for (i = 0; i < 4; ++i) {
            System.out.println(scrollArrow_X[i] + " " + scrollArrow_Y[i]);
        }
        scrollArrow_anim = 0;
        scrollArr_inc = 1;
        for (i = 0; i < 4; ++i) {
            VikingVexCanvas.scrollArrow_DRX[i] = scrollArrow_X[i];
            VikingVexCanvas.scrollArrow_DRY[i] = scrollArrow_Y[i];
        }
        this.getScrollArrowStates();
    }

    public void HandleGame(Graphics g) {
        int i;
        int xm = 0;
        int ym = 0;
        char anim = '\u0000';
        boolean smx = false;
        boolean smy = false;
        if (this.playerMoving || this.screenScroll) {
            int direction;
            if (this.playerMoving) {
                MOVE_TIME = 400;
                direction = this.playerDirection;
                anim = animSequence[4 * this.playerSmooth / MOVE_TIME];
            } else {
                MOVE_TIME = 250;
                direction = this.screenDirection;
                this.getScrollArrowStates();
            }
            this.playerSmooth += this.deltaTime;
            switch (direction) {
                case 3: {
                    xm = 16 - this.playerSmooth * 16 / MOVE_TIME;
                    if (!this.screenMoving) break;
                    this.mapPosX = this.mapPosNewX + xm;
                    break;
                }
                case 4: {
                    xm = this.playerSmooth * 16 / MOVE_TIME - 16;
                    if (!this.screenMoving) break;
                    this.mapPosX = this.mapPosNewX + xm;
                    break;
                }
                case 2: {
                    ym = 16 - this.playerSmooth * 16 / MOVE_TIME;
                    if (!this.screenMoving) break;
                    this.mapPosY = this.mapPosNewY + ym;
                    break;
                }
                case 1: {
                    ym = this.playerSmooth * 16 / MOVE_TIME - 16;
                    if (!this.screenMoving) break;
                    this.mapPosY = this.mapPosNewY + ym;
                }
            }
            if (this.screenScroll) {
                xm = 0;
                ym = 0;
            }
            if (this.playerSmooth >= MOVE_TIME) {
                if (this.screenMoving) {
                    this.screenMoving = false;
                    this.mapPosX = this.mapPosNewX;
                    this.mapPosY = this.mapPosNewY;
                }
                for (i = 0; i < 16; ++i) {
                    this.objMoving[i] = false;
                }
                if (this.playerMoving) {
                    this.UpdateObjects(true);
                }
                this.playerMoving = false;
            } else {
                this.UpdateObjects(false);
            }
        } else {
            this.UpdateObjects(false);
        }
        if (this.repaintMode == 2) {
            this.tileMap.DrawTileMap(g, this.tileGfx, this.curMap, this.mapPosX + this.repaintX - this.tileFullX, this.mapPosY + this.repaintY - this.tileFullY);
        } else {
            this.tileMap.DrawTileMap(g, this.tileGfx, this.curMap, this.mapPosX, this.mapPosY);
        }
        for (i = 1; i <= 6; ++i) {
            if (obj_time_to_anim[i] > 0) {
                int n = i;
                obj_time_to_anim[n] = obj_time_to_anim[n] - 1;
                continue;
            }
            int n = i;
            obj_anim[n] = obj_anim[n] + 1;
            if (obj_anim[i] == 6) {
                VikingVexCanvas.obj_anim[i] = 0;
                VikingVexCanvas.calcObjAnimTime(i);
                continue;
            }
            this.nextRepaintMode = 0;
        }
        obj_anim[10] = obj_anim[10] + 1;
        obj_anim[10] = obj_anim[10] & 7;
        VikingVexCanvas.obj_anim[8] = obj_anim[10] >> 1;
        if (obj_anim[9] > 0) {
            obj_anim[9] = obj_anim[9] - 1;
        }
        for (i = 0; i < 16; ++i) {
            boolean petrifying;
            int o_type = this.objType[i];
            boolean bl = petrifying = o_type < 0;
            if (petrifying) {
                o_type = -o_type;
                if (obj_anim[9] == 0) {
                    o_type = 0;
                    this.objType[i] = 0;
                    petrifying = false;
                }
            }
            if (this.objActive[i]) {
                if (this.objMoving[i]) {
                    this.DrawSprite(g, this.objectImg, this.objX[i] * 16 + this.tileFullX + xm, this.objY[i] * 16 + this.tileFullY + ym, 16, 16, o_type, obj_anim[o_type]);
                } else {
                    this.DrawSprite(g, this.objectImg, this.objX[i] * 16 + this.tileFullX, this.objY[i] * 16 + this.tileFullY, 16, 16, o_type, obj_anim[o_type]);
                }
            }
            if (!petrifying) continue;
            this.DrawSprite(g, this.objectImg, this.objX[i] * 16 + this.tileFullX, this.objY[i] * 16 + this.tileFullY, 16, 16, 0, obj_anim[9]);
        }
        if (this.idleAnim) {
            this.DrawSprite(g, this.playerImg, this.playerX * 16 + this.tileFullX + xm, this.playerY * 16 + this.tileFullY + ym, 16, 16, this.playerDirection + 3, idleSequence[this.idleAnimPos / 100 % 6]);
            this.idleAnimPos += this.deltaTime;
            if (this.idleAnimPos >= 600) {
                this.idleAnim = false;
                this.playerIdle = 6000;
            }
        } else {
            this.DrawSprite(g, this.playerImg, this.playerX * 16 + this.tileFullX + xm, this.playerY * 16 + this.tileFullY + ym, 16, 16, this.playerDirection - 1, anim);
        }
        if (!this.idleAnim) {
            this.playerIdle -= this.deltaTime;
        }
        if (this.playerIdle < 0 && !this.idleAnim) {
            this.idleAnim = true;
            this.idleAnimPos = 0;
        }
        if (this.mapActive) {
            this.nextRepaintMode = 0;
            this.DrawMiniMap(g);
        }
        if (key0) {
            if (!this.screenScroll && !this.playerMoving) {
                this.screen_scroll_mapPosX = this.mapPosX;
                this.screen_scroll_mapPosY = this.mapPosY;
                this.screenScroll = true;
                this.initScrollArrows();
                System.out.println("MapX and Y: " + this.mapPosX + " " + this.mapPosY);
            } else if (this.screenScroll) {
                this.mapPosX = this.screen_scroll_mapPosX;
                this.mapPosY = this.screen_scroll_mapPosY;
                this.screenScroll = false;
                this.nextRepaintMode = 0;
            }
            key0 = false;
        }
        if (this.screenScroll) {
            for (i = 0; i < 4; ++i) {
                this.DrawSprite(g, this.scrollArrows, scrollArrow_DRX[i] + this.mapPosX, scrollArrow_DRY[i] + this.mapPosY, arrow_w, arrow_h, scrollArrow_states[i], i);
            }
        }
    }

    public void paint(Graphics g) {
        switch (this.gameState) {
            case 2: {
                if (this.totalTime < 3000) {
                    g.setColor(0xFFFFFF);
                    g.fillRect(0, 0, this.width, this.height);
                }
                if (this.totalTime < 1500) {
                    this.InitTileMap();
                    try {
                        this.splash.Render(g, this.width, this.height, 2);
                    }
                    catch (Exception exception) {}
                    break;
                }
                if (this.totalTime < 3000) {
                    this.splash.Render(g, this.width, this.height, 0);
                    break;
                }
                if (this.totalTime < 4500) {
                    this.splash.Render(g, this.width, this.height, 1);
                    break;
                }
                g.setClip(0, 0, this.width, this.height);
                g.setColor(0);
                g.drawRect(3, this.height - 7 - 9, this.width - 6, 13);
                g.setColor(0xFFFFFF);
                g.drawRect(2, this.height - 8 - 9, this.width - 6, 13);
                g.setColor(0x181818);
                g.fillRect(4, this.height - 6 - 9, this.width - 8, 11);
                g.setColor(infoBoxCol);
                g.fillRect(4, this.height - 6 - 9, this.width - 8 - (this.width - 8) * (18 - this.loadState) / 18, 11);
                if (this.loadState <= 0) break;
                this.fontDraw.DrawString(g, this.fontImg, this.width / 2 - this.curLang[33].length() / 2 * 6, this.height - 4 - 9, this.curLang[33]);
                break;
            }
            default: {
                this.DrawGraphics(g);
                if (this.gameState != 1) break;
                g.drawImage(this.arrowImg, this.width - ARROW_W, this.height - ARROW_H, 4 | 0x10);
            }
        }
    }

    public void DrawGraphics(Graphics g) {
        if (this.keyRelease && this.keyState == 0) {
            this.xMove = 0;
            this.yMove = 0;
            this.firePress = 0;
            this.mapActive = false;
            this.keyRelease = false;
        }
        switch (this.gameState) {
            case 3: {
                if (!this.needXScroll || !this.needYScroll) {
                    g.setColor(0);
                    g.fillRect(0, 0, this.width, this.height);
                }
                this.menuTileMap.DrawTileMap(g, this.tileGfx, menu_map, 0, 0);
                this.gameState = 0;
                break;
            }
            case 0: {
                if (this.repaintMode == 0) {
                    if (this.activeMenu != 0 && this.activeMenu != 4 && this.activeMenu != 5 && this.activeMenu != 6) {
                        if (!this.needXScroll || !this.needYScroll) {
                            g.setColor(0);
                            g.fillRect(0, 0, this.width, this.height);
                        }
                        this.HandleGame(g);
                    } else {
                        if (!this.needXScroll || !this.needYScroll) {
                            g.setColor(0);
                            g.fillRect(0, 0, this.width, this.height);
                        }
                        this.menuTileMap.DrawTileMap(g, this.tileGfx, menu_map, 0, 0);
                    }
                }
                this.DrawInfoBox(g);
                break;
            }
            case 1: {
                if (!(this.repaintMode != 0 || this.needXScroll && this.needYScroll)) {
                    g.setColor(0);
                    g.fillRect(0, 0, this.width, this.height);
                }
                this.nextRepaintMode = 0;
                this.HandleGame(g);
                if (this.screenScroll) {
                    this.MoveScreen();
                } else {
                    this.MovePlayer();
                }
                this.repaintMode = this.nextRepaintMode;
                if (!this.screenMoving) break;
                this.repaintMode = 0;
            }
        }
        if (this.showFPS && this.deltaTime > 0) {
            g.setColor(0xA0A0A0);
            g.fillRect(4, 4, 18, 14);
            g.setColor(0);
            g.drawRect(4, 4, 18, 14);
            g.setColor(0xFFFFFF);
            g.drawRect(3, 3, 18, 14);
            g.setColor(0xFFFFFF);
            g.setColor(0x808080);
            this.fontDraw.DrawString(g, this.fontImg, 7, 7, "" + 1000 / this.deltaTime);
        }
        g.setClip(0, 0, this.width, this.height);
        this.keyState = 0;
    }

    public String GetScoreString(int lvl) {
        String tmpStr = this.levelRecord[lvl] == -1 ? "-" : "" + this.levelRecord[lvl];
        while (tmpStr.length() < 4) {
            tmpStr = " " + tmpStr;
        }
        return tmpStr;
    }

    /*
     * Unable to fully structure code
     */
    public void HandleMenu() {
        switch (this.activeMenu) {
            case 0: {
                if (this.menuPos < 0) {
                    this.menuPos = 5;
                }
                if (this.menuPos > 5) {
                    this.menuPos = 0;
                }
                VikingVexCanvas.infoBoxStr[0] = this.curLang[0];
                VikingVexCanvas.infoBoxStr[1] = this.curLang[1];
                VikingVexCanvas.infoBoxStr[2] = this.curLang[2];
                VikingVexCanvas.infoBoxStr[3] = this.menuPos == 0 ? "* " + this.curLang[3] + " *" : "  " + this.curLang[3] + "  ";
                if (this.menuPos == 1) {
                    this.levelStr = this.curLevel == 0 ? " " : "<";
                    if (this.curLevel < 9) {
                        this.levelStr = this.levelStr + "0";
                    }
                    this.levelStr = this.levelStr + "" + (this.curLevel + 1);
                    this.levelStr = this.curLevel != 24 && this.levelRecord[this.curLevel] != -1 ? this.levelStr + ">" : this.levelStr + " ";
                    VikingVexCanvas.infoBoxStr[4] = "* " + this.curLang[4] + " " + this.levelStr + " *";
                    if (this.xMove == 1) {
                        if (this.curLevel != 24 && this.levelRecord[this.curLevel] != -1) {
                            ++this.curLevel;
                        }
                        this.xMove = 0;
                    }
                    if (this.xMove == -1) {
                        if (this.curLevel != 0) {
                            --this.curLevel;
                        }
                        this.xMove = 0;
                    }
                } else {
                    this.levelStr = this.curLevel < 9 ? " 0" : " ";
                    this.levelStr = this.levelStr + "" + (this.curLevel + 1);
                    VikingVexCanvas.infoBoxStr[4] = "  " + this.curLang[4] + " " + this.levelStr + "   ";
                }
                if (this.menuPos != 2) ** GOTO lbl50
                VikingVexCanvas.infoBoxStr[5] = "* " + this.curLang[37] + "<" + this.curLang[38 + this.snd] + "> *";
                if (this.xMove == 0 && this.firePress != 1) ** GOTO lbl51
                this.snd = (byte)(this.snd + 1);
                this.snd = (byte)(this.snd & 1);
                this.firePress = 0;
                this.xMove = 0;
                if (this.snd != 1) ** GOTO lbl43
                try {
                    this.PlayMenuMusic();
                }
                catch (Exception e) {}
                ** GOTO lbl51
lbl43:
                // 1 sources

                try {
                    if (this.music_player != null) {
                        this.music_player.stopPlayer();
                    }
                    ** GOTO lbl51
                }
                catch (Exception e) {}
                ** GOTO lbl51
lbl50:
                // 1 sources

                VikingVexCanvas.infoBoxStr[5] = "  " + this.curLang[37] + " " + this.curLang[38 + this.snd] + "   ";
lbl51:
                // 7 sources

                VikingVexCanvas.infoBoxStr[6] = this.menuPos == 3 ? "* " + this.curLang[6] + " *" : "  " + this.curLang[6] + "  ";
                VikingVexCanvas.infoBoxStr[7] = this.menuPos == 4 ? "* " + this.curLang[5] + " *" : "  " + this.curLang[5] + "  ";
                VikingVexCanvas.infoBoxStr[8] = this.menuPos == 5 ? "* " + this.curLang[7] + " *" : "  " + this.curLang[7] + "  ";
                VikingVexCanvas.infoBoxRows = 9;
                if (this.firePress != 1) break;
                switch (this.menuPos) {
                    case 0: {
                        this.xMove = 0;
                        this.yMove = 0;
                        this.firePress = 0;
                        this.InitLevel(this.curLevel);
                        this.gameState = 1;
                        if (this.snd != 1) break;
                        try {
                            this.PlayMainMusic();
                        }
                        catch (Exception e) {}
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 3: {
                        this.gameState = 3;
                        this.activeMenu = 6;
                        this.xMove = 0;
                        this.yMove = 0;
                        this.firePress = 0;
                        this.menuPos = 0;
                        this.scorePage = 0;
                        break;
                    }
                    case 4: {
                        this.gameState = 3;
                        this.activeMenu = 4;
                        this.xMove = 0;
                        this.yMove = 0;
                        this.firePress = 0;
                        this.menuPos = 0;
                        break;
                    }
                    case 5: {
                        this.SaveRecords(false);
                        this.stopAnimation();
                        this.midlet.exitRequested();
                    }
                }
                this.menuPos = 0;
                break;
            }
            case 1: {
                if (this.menuPos < 0) {
                    this.menuPos = 1;
                }
                if (this.menuPos > 1) {
                    this.menuPos = 0;
                }
                VikingVexCanvas.infoBoxStr[0] = " " + this.curLang[4] + " " + (this.curLevel + 1) + " " + this.curLang[8] + " ";
                VikingVexCanvas.infoBoxStr[1] = this.curLang[9] + ": " + this.nrMoves;
                VikingVexCanvas.infoBoxStr[2] = this.curLang[10] + ": " + this.levelRecord[this.curLevel];
                VikingVexCanvas.infoBoxStr[3] = "";
                VikingVexCanvas.infoBoxRows = 6;
                VikingVexCanvas.infoBoxStr[4] = this.menuPos == 0 ? "* " + this.curLang[11] + " *" : "  " + this.curLang[11] + "  ";
                VikingVexCanvas.infoBoxStr[5] = this.menuPos == 1 ? "* " + this.curLang[12] + " *" : "  " + this.curLang[12] + "  ";
                if (this.firePress != 1) break;
                switch (this.menuPos) {
                    case 0: {
                        ++this.curLevel;
                    }
                }
                this.gameState = 1;
                this.xMove = 0;
                this.yMove = 0;
                this.firePress = 0;
                this.menuPos = 0;
                if (this.curLevel == 25) {
                    --this.curLevel;
                    this.gameState = 0;
                    this.activeMenu = 3;
                    break;
                }
                this.InitLevel(this.curLevel);
                break;
            }
            case 3: {
                VikingVexCanvas.infoBoxStr[0] = this.curLang[13];
                VikingVexCanvas.infoBoxStr[1] = this.curLang[14];
                VikingVexCanvas.infoBoxStr[2] = this.curLang[15];
                VikingVexCanvas.infoBoxStr[3] = "";
                VikingVexCanvas.infoBoxStr[4] = "* " + this.curLang[16] + " *";
                VikingVexCanvas.infoBoxRows = 5;
                if (this.firePress != 1) break;
                if (this.snd == 1) {
                    try {
                        this.PlayMenuMusic();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                this.activeMenu = 0;
                this.xMove = 0;
                this.yMove = 0;
                this.firePress = 0;
                this.curLevel = 24;
                this.InitLevel(this.curLevel);
                this.menuPos = 0;
                this.gameState = 3;
                break;
            }
            case 2: {
                if (this.menuPos < 0) {
                    this.menuPos = 3;
                }
                if (this.menuPos > 3) {
                    this.menuPos = 0;
                }
                VikingVexCanvas.infoBoxStr[0] = this.curLang[4] + ":  " + (this.curLevel + 1);
                while (VikingVexCanvas.infoBoxStr[0].length() < 15) {
                    VikingVexCanvas.infoBoxStr[0] = VikingVexCanvas.infoBoxStr[0] + " ";
                }
                VikingVexCanvas.infoBoxStr[1] = this.curLang[9] + ":  " + this.nrMoves;
                while (VikingVexCanvas.infoBoxStr[1].length() < 15) {
                    VikingVexCanvas.infoBoxStr[1] = VikingVexCanvas.infoBoxStr[1] + " ";
                }
                VikingVexCanvas.infoBoxStr[2] = this.levelRecord[this.curLevel] < 0 ? this.curLang[10] + ": -" : this.curLang[10] + ": " + this.levelRecord[this.curLevel];
                while (VikingVexCanvas.infoBoxStr[2].length() < 15) {
                    VikingVexCanvas.infoBoxStr[2] = VikingVexCanvas.infoBoxStr[2] + " ";
                }
                VikingVexCanvas.infoBoxStr[3] = "";
                VikingVexCanvas.infoBoxStr[4] = this.menuPos == 0 ? "* " + this.curLang[17] + " *" : "  " + this.curLang[17] + "  ";
                VikingVexCanvas.infoBoxStr[5] = this.menuPos == 1 ? "* " + this.curLang[18] + " *" : "  " + this.curLang[18] + "  ";
                if (this.menuPos != 2) ** GOTO lbl185
                VikingVexCanvas.infoBoxStr[6] = "* " + this.curLang[37] + "<" + this.curLang[38 + this.snd] + "> *";
                if (this.xMove == 0 && this.firePress != 1) ** GOTO lbl186
                this.snd = (byte)(this.snd + 1);
                this.snd = (byte)(this.snd & 1);
                this.firePress = 0;
                this.xMove = 0;
                if (this.snd != 1) ** GOTO lbl178
                try {
                    this.PlayMainMusic();
                }
                catch (Exception e) {}
                ** GOTO lbl186
lbl178:
                // 1 sources

                try {
                    if (this.music_player != null) {
                        this.music_player.stopPlayer();
                    }
                    ** GOTO lbl186
                }
                catch (Exception e) {}
                ** GOTO lbl186
lbl185:
                // 1 sources

                VikingVexCanvas.infoBoxStr[6] = "  " + this.curLang[37] + " " + this.curLang[38 + this.snd] + "   ";
lbl186:
                // 7 sources

                VikingVexCanvas.infoBoxStr[7] = this.menuPos == 3 ? "* " + this.curLang[19] + " *" : "  " + this.curLang[19] + "  ";
                VikingVexCanvas.infoBoxRows = 8;
                if (this.firePress != 1) break;
                switch (this.menuPos) {
                    case 0: {
                        this.gameState = 1;
                        break;
                    }
                    case 1: {
                        this.gameState = 1;
                        this.InitLevel(this.curLevel);
                        break;
                    }
                    case 3: {
                        if (this.snd == 1) {
                            try {
                                this.PlayMenuMusic();
                            }
                            catch (Exception var2_7) {
                                // empty catch block
                            }
                        }
                        this.activeMenu = 0;
                        this.gameState = 3;
                    }
                }
                this.xMove = 0;
                this.yMove = 0;
                this.firePress = 0;
                this.menuPos = 0;
                break;
            }
            case 6: {
                switch (this.scorePage) {
                    case 0: {
                        VikingVexCanvas.infoBoxStr[0] = "  " + this.curLang[4] + " 01-05 >";
                        break;
                    }
                    case 1: {
                        VikingVexCanvas.infoBoxStr[0] = "< " + this.curLang[4] + " 06-10 >";
                        break;
                    }
                    case 2: {
                        VikingVexCanvas.infoBoxStr[0] = "< " + this.curLang[4] + " 11-15 >";
                        break;
                    }
                    case 3: {
                        VikingVexCanvas.infoBoxStr[0] = "< " + this.curLang[4] + " 16-20 >";
                        break;
                    }
                    case 4: {
                        VikingVexCanvas.infoBoxStr[0] = "< " + this.curLang[4] + " 21-25  ";
                    }
                }
                VikingVexCanvas.infoBoxStr[1] = "";
                for (i = 0; i < 5; ++i) {
                    VikingVexCanvas.infoBoxStr[i + 2] = 5 * this.scorePage + i + 1 < 10 ? this.curLang[4] + " 0" + (5 * this.scorePage + i + 1) : this.curLang[4] + " " + (5 * this.scorePage + i + 1);
                    v0 = i + 2;
                    VikingVexCanvas.infoBoxStr[v0] = VikingVexCanvas.infoBoxStr[v0] + " : " + this.GetScoreString(5 * this.scorePage + i);
                }
                VikingVexCanvas.infoBoxStr[7] = "";
                VikingVexCanvas.infoBoxStr[8] = "* " + this.curLang[19] + " *";
                VikingVexCanvas.infoBoxRows = 9;
                if (this.xMove == 1) {
                    if (this.scorePage < 4) {
                        ++this.scorePage;
                    }
                    this.xMove = 0;
                }
                if (this.xMove == -1) {
                    if (this.scorePage > 0) {
                        --this.scorePage;
                    }
                    this.xMove = 0;
                }
                if (this.firePress != 1) break;
                this.activeMenu = 0;
                this.xMove = 0;
                this.yMove = 0;
                this.firePress = 0;
                this.gameState = 3;
                this.menuPos = 3;
                break;
            }
            case 4: {
                VikingVexCanvas.infoBoxStr[0] = this.curLang[20];
                VikingVexCanvas.infoBoxStr[1] = this.curLang[21];
                VikingVexCanvas.infoBoxStr[2] = this.curLang[22];
                VikingVexCanvas.infoBoxStr[3] = this.curLang[23];
                VikingVexCanvas.infoBoxStr[4] = this.curLang[24];
                VikingVexCanvas.infoBoxStr[5] = this.curLang[25];
                VikingVexCanvas.infoBoxStr[6] = this.curLang[40];
                VikingVexCanvas.infoBoxStr[7] = this.curLang[41];
                VikingVexCanvas.infoBoxStr[8] = this.curLang[42];
                VikingVexCanvas.infoBoxStr[9] = this.curLang[43];
                VikingVexCanvas.infoBoxStr[10] = "* " + this.curLang[26] + " *";
                VikingVexCanvas.infoBoxRows = 11;
                if (this.firePress != 1) break;
                this.activeMenu = 5;
                this.xMove = 0;
                this.yMove = 0;
                this.firePress = 0;
                this.gameState = 3;
                break;
            }
            case 5: {
                VikingVexCanvas.infoBoxStr[0] = this.curLang[27];
                VikingVexCanvas.infoBoxStr[1] = this.curLang[28];
                VikingVexCanvas.infoBoxStr[2] = this.curLang[29];
                VikingVexCanvas.infoBoxStr[3] = this.curLang[30];
                VikingVexCanvas.infoBoxStr[4] = this.curLang[31];
                VikingVexCanvas.infoBoxStr[5] = this.curLang[32];
                VikingVexCanvas.infoBoxStr[6] = "* " + this.curLang[19] + " *";
                VikingVexCanvas.infoBoxRows = 7;
                if (this.firePress != 1) break;
                this.activeMenu = 0;
                this.xMove = 0;
                this.yMove = 0;
                this.firePress = 0;
                this.gameState = 3;
                this.menuPos = 4;
            }
        }
    }

    public boolean MoveOK(int dx, int dy) {
        int y = this.playerY + dy;
        int x = this.playerX + dx;
        if (tileType[this.curMap[y][x] - '\u0001'] != '\u0000') {
            return false;
        }
        for (int i = 0; i < 16; ++i) {
            if (!this.objActive[i] || this.objX[i] != x || this.objY[i] != y) continue;
            if (this.objType[i] == 8) {
                this.playerX += dx;
                this.playerY += dy;
                ++this.nrMoves;
                this.playerMoving = true;
                this.playerSmooth = 0;
                return true;
            }
            if (this.objType[i] <= 0 || this.objType[i] == 7) {
                return false;
            }
            if (tileType[this.curMap[y + dy][x + dx] - '\u0001'] != '\u0000') {
                return false;
            }
            for (int j = 0; j < 16; ++j) {
                if (!this.objActive[j] || j == i || this.objX[j] != x + dx || this.objY[j] != y + dy) continue;
                return false;
            }
            int n = i;
            this.objX[n] = this.objX[n] + dx;
            int n2 = i;
            this.objY[n2] = this.objY[n2] + dy;
            this.objMoving[i] = true;
        }
        this.playerX += dx;
        this.playerY += dy;
        ++this.nrMoves;
        this.playerMoving = true;
        this.playerSmooth = 0;
        return true;
    }

    public void MovePlayer() {
        if (!this.playerMoving) {
            if (this.xMove == -1) {
                this.playerDirection = 3;
                if (this.MoveOK(-1, 0) && this.needXScroll && this.playerX * 16 - this.mapPosX < this.width / 2 && this.mapPosX > this.levelStartX * 16) {
                    this.screenMoving = true;
                    this.mapPosNewX = this.mapPosX - 16;
                    this.mapPosNewY = this.mapPosY;
                }
            } else if (this.xMove == 1) {
                this.playerDirection = 4;
                if (this.MoveOK(1, 0) && this.needXScroll && this.playerX * 16 - this.mapPosX > this.width / 2 && this.mapPosX < this.levelEndX * 16 - this.width) {
                    this.screenMoving = true;
                    this.mapPosNewX = this.mapPosX + 16;
                    this.mapPosNewY = this.mapPosY;
                }
            } else if (this.yMove == -1) {
                this.playerDirection = 2;
                if (this.MoveOK(0, -1) && this.needYScroll && this.playerY * 16 - this.mapPosY < this.height / 2 && this.mapPosY > this.levelStartY * 16) {
                    this.screenMoving = true;
                    this.mapPosNewX = this.mapPosX;
                    this.mapPosNewY = this.mapPosY - 16;
                }
            } else if (this.yMove == 1) {
                this.playerDirection = 1;
                if (this.MoveOK(0, 1) && this.needYScroll && this.playerY * 16 - this.mapPosY > this.height / 2 && this.mapPosY < this.levelEndY * 16 - this.height) {
                    this.screenMoving = true;
                    this.mapPosNewX = this.mapPosX;
                    this.mapPosNewY = this.mapPosY + 16;
                }
            }
        }
    }

    public void MoveScreen() {
        if (!this.screenMoving) {
            if (this.xMove == -1) {
                if (this.needXScroll && this.mapPosX > this.levelStartX * 16) {
                    this.screenMoving = true;
                    this.mapPosNewX = this.mapPosX - 16;
                    this.mapPosNewY = this.mapPosY;
                    this.screenDirection = 3;
                    this.playerSmooth = 0;
                }
            } else if (this.xMove == 1) {
                if (this.needXScroll && this.mapPosX < this.levelEndX * 16 - this.width) {
                    this.screenMoving = true;
                    this.mapPosNewX = this.mapPosX + 16;
                    this.mapPosNewY = this.mapPosY;
                    this.screenDirection = 4;
                    this.playerSmooth = 0;
                }
            } else if (this.yMove == -1) {
                if (this.needYScroll && this.mapPosY > this.levelStartY * 16) {
                    this.screenMoving = true;
                    this.mapPosNewX = this.mapPosX;
                    this.mapPosNewY = this.mapPosY - 16;
                    this.screenDirection = 2;
                    this.playerSmooth = 0;
                }
            } else if (this.yMove == 1 && this.needYScroll && this.mapPosY < this.levelEndY * 16 - this.height) {
                this.screenMoving = true;
                this.mapPosNewX = this.mapPosX;
                this.mapPosNewY = this.mapPosY + 16;
                this.screenDirection = 1;
                this.playerSmooth = 0;
            }
        }
    }

    final void cheatComplete() {
        for (int i = 0; i < 25; ++i) {
            if (this.levelRecord[i] != -1) continue;
            this.levelRecord[i] = 999;
        }
    }

    public void keyPressed(int keyCode) {
        int gameAction = 0;
        if (keyCode >= 48 && keyCode <= 57) {
            int key = keyCode - 48;
            if (CHEAT_SEQUENCE[cheat_pos] == key) {
                if (++cheat_pos == CHEAT_SEQUENCE.length) {
                    this.cheatComplete();
                    cheat_pos = 0;
                }
            } else {
                cheat_pos = 0;
            }
        }
        this.lastKey = keyCode;
        this.keyState = 1;
        try {
            gameAction = this.getGameAction(keyCode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (gameAction == 2 || this.lastKey == 52) {
            this.keyRelease = false;
            this.xMove = -1;
            this.yMove = 0;
            this.firePress = 0;
            this.playerIdle = 6000;
            this.idleAnim = false;
        }
        if (gameAction == 5 || this.lastKey == 54) {
            this.keyRelease = false;
            this.xMove = 1;
            this.yMove = 0;
            this.firePress = 0;
            this.playerIdle = 6000;
            this.idleAnim = false;
        }
        if (gameAction == 1 || this.lastKey == 50) {
            this.keyRelease = false;
            this.xMove = 0;
            this.yMove = -1;
            this.firePress = 0;
            if (this.gameState != 1) {
                --this.menuPos;
            }
            this.playerIdle = 6000;
            this.idleAnim = false;
        }
        if (gameAction == 6 || this.lastKey == 56) {
            this.keyRelease = false;
            this.xMove = 0;
            this.yMove = 1;
            this.firePress = 0;
            if (this.gameState != 1) {
                ++this.menuPos;
            }
            this.playerIdle = 6000;
            this.idleAnim = false;
        }
        if (gameAction == 8 || this.lastKey == 53) {
            this.keyRelease = false;
            this.firePress = 1;
            this.xMove = 0;
            this.yMove = 0;
        }
        if (!(this.lastKey != 35 && this.lastKey != -7 || this.gameState != 1 || this.mapActive)) {
            this.gameState = 0;
            this.activeMenu = 2;
            this.firePress = 0;
            this.xMove = 0;
            this.yMove = 0;
        }
        if (this.lastKey == 42 || this.lastKey == -6) {
            if (this.gameState == 1) {
                this.mapActive = true;
                this.repaintMode = 0;
                this.firePress = 0;
                this.xMove = 0;
                this.yMove = 0;
            } else if (this.gameState == 0) {
                this.firePress = 1;
                this.xMove = 0;
                this.yMove = 0;
            }
        }
        if (this.lastKey == 48 && this.gameState == 1) {
            key0 = true;
        }
    }

    public void keyReleased(int keyCode) {
        this.lastKey = 0;
        this.keyRelease = true;
    }

    public void DrawInfoBox(Graphics g) {
        int i;
        int w = 0;
        for (i = 0; i < infoBoxRows; ++i) {
            VikingVexCanvas.infoBoxStrLen[i] = infoBoxStr[i].length();
            if (infoBoxStrLen[i] <= w) continue;
            w = infoBoxStrLen[i];
        }
        w = 6 * w + 8;
        int h = infoBoxRows * 9 + 8;
        int x = 4 + (this.width - w) / 2;
        int y = 4 + (this.height - h) / 2;
        g.setColor(infoBoxCol);
        g.fillRect(x - 3, y - 3, w, h);
        g.setColor(0);
        g.drawRect(x - 3, y - 3, w, h);
        g.setColor(0xFFFFFF);
        g.drawRect(x - 4, y - 4, w, h);
        for (i = 0; i < infoBoxRows; ++i) {
            int xpos = x + (w - 6 - infoBoxStrLen[i] * 6) / 2;
            this.fontDraw.DrawString(g, this.fontImg, xpos, y + i * 9, infoBoxStr[i]);
        }
    }

    public void DrawMiniMap(Graphics g) {
        int sx = 5;
        int sy = 5;
        int posx = (this.width - 16 * sx) / 2;
        int posy = (this.height - 16 * sy) / 2;
        g.setColor(0);
        g.drawRect(posx - 1, posy - 1, 16 * sx + 2, 16 * sy + 2);
        g.setColor(0xFFFFFF);
        g.drawRect(posx - 2, posy - 2, 16 * sx + 2, 16 * sy + 2);
        for (int y = 0; y < this.tileMap.mapHeight; ++y) {
            for (int x = 0; x < this.tileMap.mapWidth; ++x) {
                if (tileType[this.curMap[y][x] - '\u0001'] == '\u0000') {
                    g.setColor(96, 192, 96);
                } else {
                    g.setColor(64, 96, 64);
                }
                g.fillRect(posx + x * sx, posy + y * sy, sx, sy);
            }
        }
        for (int i = 0; i < 16; ++i) {
            if (!this.objActive[i]) continue;
            switch (this.objType[i]) {
                case 0: {
                    g.setColor(128, 128, 128);
                    break;
                }
                case 1: {
                    g.setColor(255, 32, 32);
                    break;
                }
                case 2: {
                    g.setColor(32, 255, 32);
                    break;
                }
                case 3: {
                    g.setColor(32, 32, 255);
                    break;
                }
                case 4: {
                    g.setColor(255, 255, 32);
                    break;
                }
                case 5: {
                    g.setColor(255, 32, 255);
                    break;
                }
                case 6: {
                    g.setColor(255, 128, 32);
                    break;
                }
                case 7: {
                    g.setColor(160, 96, 64);
                    break;
                }
                case 8: {
                    g.setColor(0, 0, 0);
                }
            }
            g.fillRect(posx + this.objX[i] * sx, posy + this.objY[i] * sy, sx, sy);
        }
        g.setColor(255, 255, 255);
        g.fillRect(posx + this.playerX * sx, posy + this.playerY * sy, sx, sy);
    }

    static {
        MOVE_TIME = 0;
        menu_map = new char[][]{{'\u0007', '\u0006', '\u0001', '\u0001', ',', 'i', '9', '9', '9', '9', ',', ',', '\u0004', '\u0004', '\u0007', ','}, {'\u0001', '\u0006', '\u0001', '\u0006', ',', '9', '9', '9', 'c', '+', '\u0001', ',', ',', '\u0004', '\u0004', ','}, {',', '\u0006', '8', '\u0001', '-', 'i', '9', '9', '9', ',', ',', ',', '8', ',', ',', ','}, {'i', '8', 'i', '8', '9', 'O', 'P', '9', '+', ',', ',', '8', '\u001f', '+', ',', ','}, {'i', 'i', 'i', 'i', 'i', '\u0013', 'D', 'P', '9', '8', '9', '9', '\u0013', 'i', ',', '\u0001'}, {'i', 'e', 'i', 'i', 'i', '\u0002', '\u001f', '\u0013', '\\', 'i', '\u0002', '\u0013', '\u001f', 'i', '+', ','}, {'i', 'i', 'i', 'i', 'i', '[', '\u001f', '\\', '9', 'O', '\u001f', '\u0002', '\\', 'i', ',', ','}, {'i', 'i', 'i', 'Y', 'i', 'i', 'i', 'i', 'i', '[', 'D', '\\', '9', 'N', '9', '8'}, {'i', 'i', ' ', ' ', 'i', 'i', 'i', 'i', 'i', 'O', 'D', 'D', 'P', '9', '9', 'i'}, {'9', '\u0005', '\u0005', '\u0003', '\u0003', ' ', 'i', '9', 'i', '[', 'D', '\u001f', 'D', 'P', '9', 'i'}, {',', '\u0005', '\u0005', '\u0003', '\u0004', '\u0004', '\u0004', 'i', 'i', 'i', '^', '_', '^', 'D', 'P', 'i'}, {'9', ',', ',', '\u0005', '\u0004', '\u0005', 'i', 'i', 'i', 'D', 'j', '\u0003', '\u0007', '_', 'D', 'P'}, {'9', 'i', 'i', '8', '8', 'i', 'U', 'i', 'O', 'D', 'j', '\u0005', ',', 'k', 'D', 'D'}, {'9', '9', 'i', 'i', 'i', 'i', 'W', 'i', 'D', 'D', 'D', 'j', 'k', 'D', '\u0013', 'D'}, {'9', '9', 'i', 'i', 'i', 'i', 'i', 'O', 'D', 'D', '\u0002', 'D', '\u0013', '\u0002', 'D', 'D'}, {'i', 'i', 'i', '9', 'i', 'i', 'i', 'D', 'D', 'D', 'D', 'D', 'D', 'D', 'D', '\u0013'}};
        animSequence = new char[]{'\u0001', '\u0000', '\u0002', '\u0000', '\u0000'};
        idleSequence = new char[]{'\u0000', '\u0001', '\u0002', '\u0002', '\u0001', '\u0000'};
        tileType = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0000', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0000', '\u0000', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0000', '\u0000', '\u0000', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0000', '\u0000', '\u0000', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0000', '\u0000', '\u0000', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0000', '\u0000', '\u0000', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0000', '\u0000', '\u0000', '\u0001'};
        infoBoxStr = new String[11];
        infoBoxStrLen = new int[11];
        infoBoxRows = 0;
        infoBoxCol = 7425631;
        obj_time_to_anim = new int[7];
        obj_anim = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        scrollArrow_states = new byte[]{0, 0, 0, 0};
        scrollArrow_X = new int[4];
        scrollArrow_Y = new int[4];
        scrollArrow_DRX = new int[4];
        scrollArrow_DRY = new int[4];
        scrollArrow_anim = 0;
        key0 = false;
        CHEAT_SEQUENCE = new int[]{8, 3, 7, 6, 4, 6, 2, 8, 6, 7};
        cheat_pos = 0;
    }
}

