
//////////////////////////////////////////////////////////////////////////////
//								TextBox										//
//--------------------------------------------------------------------------//
//	Version: 1.11															//
//--------------------------------------------------------------------------//
//	Note: auto newline.														//
//		  can use "/n" to new line and use "/p" to new page.				//
//		  will not newline between an English word.							//
//--------------------------------------------------------------------------//
//	Guide:																	//
//	|																		//
//	+-- TextBox()															//
//	|		Construct:  TextBox textBox	= new TextBox();					//
//	+--	Close()																//
//	|		Destruct.														//
//	+-- setBoxSize( int width,int height )									//
//	|		reset region to show a text string.								//
//	|		width: the width of the region.									//
//	|		height: the height of the region.								//
//	+-- setFont( Font font )												//
//	|		reset system font.												//
//	+-- setString( String text )											//
//	|		set the string you should display.								//
//	+--	paintText( Graphics g,int x,int y,int col,int currentPage )			//
//	|		write the string to the screen.									//
//	|		g:	javax.microedition.lcdui.Graphics.							//
//	|		x:	the left edge of the text box,use screen coordinate. 		//
//	|		y:	the top edge of the text box,use screen coordinate.			//
//	|		col: the color of the string you should display.				//
//	|		currentPage: current page of the text to display.				//
//	+-- int page()															//
//			return the max page of the string.								//
//--------------------------------------------------------------------------//
//	Notice: 																//
//	1.	command "/n" and "/p" in the end of the text will be ignore.		//
//	2.	if you want to display "/n"	or "/p",you should insert space between	//
//		command like "/ n" or "/ p".										//	
//--------------------------------------------------------------------------//
//	Author: BingFeng														//
//--------------------------------------------------------------------------//
//	Year  2006	for  Soco Soft												//
//////////////////////////////////////////////////////////////////////////////

import java.util.*;
import javax.microedition.lcdui.*;

public class TextBox
{
	/////////////////////////////////////////////////////////
	/////////////////////// Varibles ////////////////////////
	/////////////////////////////////////////////////////////
	
	//	private	
	private String text;		
	
	private int textLength;		//	size of the string
	
	private int width;			//	width of the text box
	private int height;			//	height of the text box

	private Font font;			//	type of font
	
	private int maxLineNum;		//	max line number in one page
	private int lineSize;		//	the number of words in one line
	private int totalPage;		//	pages of the text
	
	private int lineNum[];		//	line number in every page. Array[page]
	private int linePos[];		//	start position for one line in the text
		
	//	set string
	private int currentLen;		//	current number of word in current line
	private int wordNumber;		//	the word number of current letter
	private int letterLength;	//	length of current letter
	private int currentIndex;	//	current index of the text string
	private int currentLine;	//	current number of the line in current page
	private int totalLine;		//	total line in the text
	private int lineIndex;		//	current line
	private int pageIndex;		//	current page

	private	int imgWordW;
	private	int imgWordH;
		
	/////////////////////////////////////////////////////////
	/////////////////////// Functions ///////////////////////
	/////////////////////////////////////////////////////////
	public TextBox(  int imgWordW , int imgWordH  )
	{		
		font	= Font.getFont(Font.FACE_PROPORTIONAL,Font.STYLE_PLAIN,Font.SIZE_MEDIUM);
		setBoxSize( 24,22 );
		
		this.imgWordW = imgWordW;
		this.imgWordH = imgWordH;
	}
	
	public void Close()
	{
		text	= null;
		lineNum	= null;
		linePos	= null;
	}
	
	private	void resetBox()
	{
//#ifdef DEBUG_MODE
//		if( width < 24 || height < 22 )
//		{
//			System.out.println( "TextBox create failed: size too small." );
//			return;
//		}
//#endif

		lineSize	= width-4;
		maxLineNum	= (height-2)/(imgWordH+2);
		if( text != null )
			setString( text );
	}
	
	//	change line&page
	private	void newLine( int state )
	{
		//	state:
		//	0 --> auto enter
		//	1 --> force enter
	
		//	change line
		currentLine ++;
		currentLen	= 0;
		linePos[++lineIndex]	= currentIndex-(state<<1);
		linePos[++lineIndex]	= currentIndex+1;
					
		//	change page	
		if( currentLine == maxLineNum )
		{
			totalPage ++;
			totalLine	+= currentLine;
			lineNum[++pageIndex]	= totalLine;
			currentLine	= 0;
		}	
	}
	
	public void setString( String text )
	{
		String currentChar;
	
		this.text	= text;		
		textLength	= text.length();
		
//#ifdef DEBUG_MODE
		if( textLength == 0 )
			return;
//#endif			

		lineNum	= new int[textLength+1];
		linePos	= new int[textLength<<1];
		
		currentIndex	= 0;
		wordNumber		= 0;
		letterLength	= 0;
		currentLen		= 0;
		currentLine		= 0;	
		totalLine		= 0;	
		
		pageIndex			= 0;
		lineIndex			= 0;
		lineNum[pageIndex]	= 0;
		linePos[lineIndex]	= 0;

		totalPage	= 0;

		while( currentIndex < textLength )
		{
			currentChar	= text.substring( currentIndex,currentIndex+1 );

			//	English
			if( !currentChar.equals(" ")  &&  !currentChar.equals("/") )
			{				
				wordNumber	= 1;
				while( currentIndex+wordNumber < textLength &&
					  !text.substring( currentIndex+wordNumber,currentIndex+wordNumber+1 ).equals(" ") &&
					  !text.substring( currentIndex+wordNumber,currentIndex+wordNumber+1 ).equals("/")  )
				{					
					wordNumber++;
				}
				
				letterLength	= imgWordW*wordNumber;
				
				if( letterLength > lineSize )
				{
					for( int i=0;i<wordNumber;i++ )
					{
						currentChar	= text.substring( currentIndex,currentIndex+1 );						
						letterLength	= imgWordW;
						if( currentLen+letterLength > lineSize )
							newLine(0);
						else	currentLen	+= letterLength;
						
						currentIndex++;
					}
				}
				else if( currentLen+letterLength > lineSize )
				{
					currentIndex	--;
					
					newLine(0);
					
					currentIndex	+= wordNumber;
					currentLen		= letterLength;
				}
				else
				{
					currentIndex	+= wordNumber;
					currentLen		+= letterLength;
				}
			}
			
			//	command
			else if( currentChar.equals("/") )
			{
				currentIndex++;

				if( currentIndex < textLength )
				{
					currentChar	= text.substring( currentIndex,currentIndex+1 );
						
					//	change line
					if( currentChar.equals("n")||currentChar.equals("N") )
					{
						if( currentIndex == textLength-1 )
						{
							currentIndex --;
							break;
						}
						else	newLine(1);
					}
					
					//	change page
					else if( currentChar.equals("p")||currentChar.equals("P") )
					{
						if( currentIndex == textLength-1 )
						{
							currentIndex --;
							break;
						}
						else
						{
							currentLine ++;
							currentLen	= 0;
							linePos[++lineIndex]	= currentIndex-2;
							linePos[++lineIndex]	= currentIndex+1;
							
							totalPage ++;
							totalLine	+= currentLine;
							lineNum[++pageIndex]	= totalLine;
							currentLine	= 0;
						}
					}
					
					else
					{
						currentIndex --;
						currentLen	+= imgWordW;
												
						if( currentLen >= lineSize )
						{
							if( currentLen > lineSize )
								currentIndex --;
								
							newLine(0);
						}
					}
					
					currentIndex ++;
				}
			}

			//	Chinese & Number
			else
			{
				currentLen	+= imgWordW;
				
				if( currentLen >= lineSize )
				{
					if( currentLen > lineSize )
						currentIndex --;
						
					newLine(0);
				}
	
				currentIndex ++;
			}
		}

		if(  currentLine != 0 || currentLen != 0 )
		{
			totalPage	++;
			totalLine	+= currentLine+1;
			linePos[++lineIndex]	= currentIndex-1;
			lineNum[++pageIndex]	= totalLine;
		}
	}
	
	public void setFont( Font font )
	{
		this.font	= font;
		
		resetBox();
	}
	
	public void setBoxSize( int width,int height )
	{
		this.width	= width;
		this.height	= height;
		
		resetBox();
	}
	
	public int page()
	{
		return	Math.max( 1,totalPage );
	}
	
	public void paintText( Graphics g,int x,int y,int col,int currentPage )
	{
		g.setColor( col );
		g.setFont( font );
		
		for( int i=0;i<lineNum[currentPage+1]-lineNum[currentPage];i++ )
		{
			g.drawString( text.substring( linePos[i+lineNum[currentPage]<<1],linePos[(i+lineNum[currentPage]<<1)+1]+1 ),
						  x+(width>>1),
						  y+(height-(lineNum[currentPage+1]-lineNum[currentPage])*(font.getHeight()+2)>>1)+i*(font.getHeight()+2),
						  Graphics.TOP|Graphics.HCENTER );		
		}
	}
	
	public void paintText( Graphics g,int x,int y,int col,int currentPage , Image	word )
	{
		g.setColor( col );
		g.setFont( font );
		
		for( int i=0;i<lineNum[currentPage+1]-lineNum[currentPage];i++ )
		{
//			FrameWork.imgStr.paint( g , text.substring( linePos[i+lineNum[currentPage]<<1],linePos[(i+lineNum[currentPage]<<1)+1]+1 ),
//						  x+(width>>1),
//						  y+(height-(lineNum[currentPage+1]-lineNum[currentPage])*(imgWordH+2)>>1)+i*(imgWordH+2),
//						  Graphics.TOP|Graphics.HCENTER , word , imgWordW , imgWordH );	
				
				FrameWork.imgStr.paint( g , text.substring( linePos[i+lineNum[currentPage]<<1],linePos[(i+lineNum[currentPage]<<1)+1]+1 ),
						  x+(width>>1),
						  y+(height-(lineNum[currentPage+1]-lineNum[currentPage])*(imgWordH+2)>>1)+i*(imgWordH+2),
						  Graphics.TOP|Graphics.HCENTER , word , Constant.IMAGEWORDSW , Constant.IMAGEWORDSH );							
		}
	}
	
	public void paintText( Graphics g,int x,int y, Image word , int top , int bottom )
	{
//		g.setColor( col );
//		g.setFont( font );
		
		for( int i=0;i<totalLine;i++ )
		{
//			if( y+i*(imgWordH+2) > top && y+i*(imgWordH+2) < bottom )
//			FrameWork.imgStr.paint( g , text.substring( linePos[i<<1],linePos[(i<<1)+1]+1 ),
//						  x+(width>>1),
//						  y+i*(imgWordH+2),
//						  Graphics.TOP|Graphics.HCENTER , word , imgWordW , imgWordH );

			if( y+i*(imgWordH+2) > top && y+i*(imgWordH+2) < bottom )
			FrameWork.imgStr.paint( g , text.substring( linePos[i<<1],linePos[(i<<1)+1]+1 ),
						  x+(width>>1),
						  y+i*(imgWordH+2),
						  Graphics.TOP|Graphics.HCENTER , word , Constant.IMAGEWORDSW , Constant.IMAGEWORDSH );
		}
	}
	
//	public void paintText( Graphics g,int x,int y,int col , int top , int bottom )
//	{
////		g.setColor( col );
////		g.setFont( font );
//		
//		for( int i=0;i<totalLine;i++ )
//		{
////			if( y+i*(imgWordH+2) > top && y+i*(imgWordH+2) < bottom )
////			FrameWork.imgStr.paint( g , text.substring( linePos[i<<1],linePos[(i<<1)+1]+1 ),
////						  x+(width>>1),
////						  y+i*(imgWordH+2),
////						  Graphics.TOP|Graphics.HCENTER , word , imgWordW , imgWordH );
//
//			if( y+i*(imgWordH+2) > top && y+i*(imgWordH+2) < bottom )
//			FrameWork.imgStr.paint( g , text.substring( linePos[i<<1],linePos[(i<<1)+1]+1 ),
//						  x+(width>>1),
//						  y+i*(imgWordH+2),
//						  Graphics.TOP|Graphics.HCENTER );
//		}
//	}
	
	public void paintText1( Graphics g,int x,int y,int col,int top,int bottom )
	{
		g.setColor( col );
		g.setFont( font );
		
		for( int i=0;i<totalLine;i++ )
		{
			if( y+i*(imgWordH+10) > top && y+i*(imgWordH+10) < bottom )
			g.drawString( text.substring( linePos[i<<1],linePos[(i<<1)+1]+1 ),
						  x+(width>>1),
						  y+i*(imgWordH+10),
						  Graphics.TOP|Graphics.HCENTER );
		}
	}
	
//	public void paintText1( Graphics g,int x,int y,int col,int currentPage )
//	{		
//			g.setColor( col );
//			g.setFont( font );
//				
//			for( int i=0;i<lineNum[currentPage+1]-lineNum[currentPage];i++ )
//			{			
//				if( y+i*(FrameWork.imgStr.Height+2) > 50 && y+i*(FrameWork.imgStr.Height+2) < 208 )
//				FrameWork.imgStr.paint( g , text.substring( linePos[i+lineNum[currentPage]<<1],linePos[(i+lineNum[currentPage]<<1)+1]+1 ),
//										  x+(width>>1),
//										  y+i*(FrameWork.imgStr.Height+2),
//										  Graphics.TOP|Graphics.HCENTER );
//			}
//			
//			g.setClip( 0,0,Environment.SCREEN_WIDTH,Environment.SCREEN_HEIGHT );
//	}
	
	
//	public int height()
//	{
//		return totalLine*(FrameWork.imgStr.Height+2);
//	}
	
	public int getWordLength()
	{						
		return	totalLine*(imgWordH+2); 
	}	
}