//import java.io.*;
//import javax.microedition.media.*;
//import javax.microedition.media.control.*;
//
//public final class Sound 
////implements PlayerListener
//{
//	private Player	p[];
//	private InputStream	sound;
//
//	private VolumeControl synth[];
//	private int currentSound;;
//	private String soundType;
//	private String soundRes;
//	private int soundNum;
//	
//	public Sound( int num )
//	{
//		try
//		{
//			soundNum=num;
//
//			currentSound = 0;
//			p = new Player[num];		
//			synth = new VolumeControl[num];
//			
//			for(int i=0;i<num;i++)
//			{				
//				setType(Constant.soundType[i]);
//									
//				sound	= getClass().getResourceAsStream("/sound/"+i+"."+soundType);
//						
//				p[i] = Manager.createPlayer(sound,"audio/"+soundRes);				
//				
//					
////				p[i].addPlayerListener( this );
//				p[i].realize();
//				synth[i] = (VolumeControl)p[i].getControl("VolumeControl"); 
//
//			}
//				
//			sound = null;
//			System.gc();
//		}
//		catch
//		(Exception e)
//		{
//		}
//	}
//	
////	public void playerUpdate(Player p,String t,Object d)
////	{
////		if( t == PlayerListener.END_OF_MEDIA )
////		{} 			
////		
////		if( t == PlayerListener.ERROR )
////		{	
////				soundStop();
////				soundReset(0);
////		} 	
////	}
//	
//	public void soundOpen( int i )
//	{		
////		if(currentSound == i)
////			return;	
////
////		if(p[currentSound] == null || p[currentSound].getState() == Player.STARTED)
////		 	return;
//		 	
//		if(i>=0 && i<p.length)
//		{
////			if(currentSound >= 0 && currentSound < p.length)
////				 soundStop();
//			currentSound = i;		
//		}
//		else
//		{
//			System.out.println("soundOpen Error!");
//		}			
//	}
//
//
//	public void soundPlay( int loop )
//	{	
////		if(currentSound < 0 || currentSound>=p.length)					
////			return;		
////															
////		if(p[currentSound] == null || p[currentSound].getState() == Player.STARTED)		
////		 	return;		
//				
//				try
//        {        		
//						if(loop!=0)
//						p[currentSound].setLoopCount(loop);
//						
////						if(p[currentSound].getState() == Player.REALIZED)//ֻMOTO
////          	   p[currentSound].prefetch();    
//
////						soundReset(0);
//            p[currentSound].start();
//            return;
//        }
//        catch(Exception _ex)
//        {
//        		System.out.println("error!!");
//            return;
//        }
//	}
//
//
//    public void soundPause()
//    {   
//    		try
//        {
//            if(p[currentSound] == null)
//                return;
//                
//          	if(p[currentSound].getState() == Player.STARTED)
//          	{
//							 p[currentSound].stop();						
//						}
//				
////					mediaTime[currentSound] = p[currentSound].getMediaTime();
//			
////        	if(p[currentSound].getState() == Player.PREFETCHED)//nokiaĲ
////          	 p[currentSound].deallocate();    
//                
//        }
//        catch(Exception _ex)
//        {
//            return;
//        }
//        return;
//    }
//
//    public void soundStop()
//    {
//    	 try
//       {
//            if(p[currentSound] == null)
//                return;
//                
//          	if(p[currentSound].getState() == Player.STARTED)
//          		 p[currentSound].stop();
//          		
////	        mediaTime[currentSound] = 0;
//          	
////        	if(p[currentSound].getState() == Player.PREFETCHED)//nokiaĲ
////          	 p[currentSound].deallocate();    
//             
//        }
//        catch(Exception _ex)
//        {
//            return;
//        }
//
//        return;
//    }
//
//   public void soundlevel( int level )
//   {
//    	try
//    	{
//    		for(int i =0;i<soundNum;i++)
//			{	
//    			if( synth[i] != null)
//					synth[i].setLevel( level*10 );
//			}
//    	}
//    	catch(Exception e){}
//   }  
//  
//  public void setMute( boolean mute )
//  {
//    	try
//    	{
//    		for(int i =0;i<soundNum;i++)
//				{	
//    			if( synth[i] != null)
//					synth[i].setMute(mute);
//				}
//    	}
//    	catch
//    	(Exception e)
//    	{
//    		System.out.println("setMute error!!");
//    	}
//   }  
//
//   
//	public void close()
//	{
//		for(int i =0;i<soundNum;i++)	
//		{					 	
//    	 p[i] = null;
//    }
//		
//		p=null;
//		sound	= null;
//			
//		System.gc();
//	}		
//			
//	
//	public void soundReset(long mediaTime)
//    {
//    	try
//    	{
//    		p[currentSound].setMediaTime(mediaTime);
//    	}
//    	catch
//    	(Exception e)
//    	{
//    	}
//    } 
//	
//			
//	private void setType(int t)
//	{
//		if(t==0)
//		{
//			soundType="amr";
//			soundRes="amr";
//		}
//		else if(t==1)
//		{
//			soundType="mid";
//			soundRes="midi";
//		}
//		else if(t==2)
//		{
//			soundType="wav";
//			soundRes="x-wav";
//		}
//	}
//
//}

import java.io.*;
import javax.microedition.media.*;
import javax.microedition.media.control.*;

public final class Sound
{

	private InputStream	sound;

	public int currentSound;	
	private String soundType;
	private String soundRes;

//	public int currentType;
	private Player	player;
	private VolumeControl synth;
	

	public Sound()
	{
		currentSound	= -1;
	}

	public boolean soundOpen( int i )
	{
		if( i == currentSound )
			return false;

		try
		{		
			if( player != null && player.getState() == Player.STARTED )
			{
					player.stop();
					player.deallocate();
					player.close();
					player = null;
			}
									
			setType(Constant.soundType[i]);
			
			sound	= getClass().getResourceAsStream("/sound/"+i+"."+soundType);
			
			player	= Manager.createPlayer(sound,"audio/"+soundRes);	

			if( player.getState() == Player.UNREALIZED )
					player.realize();

			if( player.getState() == Player.REALIZED )
					player.prefetch();

			synth	= (VolumeControl)player.getControl("VolumeControl"); 

			currentSound = i;
//			currentType	= type;
			
			sound = null;
			System.gc();

			return true;
		}
		catch
		(Exception e)
		{
//			_error	= e.getMessage();
		}
		
		return	false;
	}			

	public void soundPlay( int loop )
	{	
		if( player == null || player.getState() == Player.STARTED)
		 	return;

		try
        {
			if( player.getState() == Player.UNREALIZED )
				player.realize();
	
			if( player.getState() == Player.REALIZED )
				player.prefetch();	

			if(loop!=0)
				player.setLoopCount(loop);	
            player.start();
        }
        catch(Exception _ex)
        {
        }
	}

	public void soundPause()
    {    	
    	try
        {
            if(player == null)
                return;
                
          	if(player.getState() == Player.STARTED)
				player.stop();
//        	else if(player.getState() == Player.PREFETCHED)
//          	  	player.deallocate();    
                
        }
        catch(Exception _ex)
        {
        }
    }

	public void soundStop()
    {
    	try
        {
            if(player == null)
                return;
                
          	if(player.getState() == Player.STARTED)
          	{
				player.stop();
				player.setMediaTime(0);
          	}
//        	else if(player.getState() == Player.PREFETCHED)
//          	  	player.deallocate();    
             
        }
        catch(Exception _ex)
        {
        }
    }

	public void soundlevel( int level )
   {
    	try
    	{
   			if( synth != null)
				synth.setLevel( level*20 );
    	}
    	catch
    	(Exception e)
    	{
    	}
   }  


	public void close()
	{
		if(player.getState() == Player.PREFETCHED)
          	player.deallocate();    
          	
		if(player.getState() == Player.UNREALIZED)
			player.deallocate();   	
			
		player.close();
		
		player	= null;
		sound	= null;
			
		System.gc();
	}
	
	
	public void soundReset(long mediaTime)
    {
    	try
    	{
    		player.setMediaTime(mediaTime);
    	}
    	catch
    	(Exception e)
    	{
    		System.out.println( e.getMessage()  );
    	}
    } 
    
    public int soundState()
    {
    	if( player == null )
    		return	-1;
    	else	return	player.getState();
    }
			
	private void setType(int t)
	{
		if(t==0)
		{
			soundType="amr";
			soundRes="amr";
		}
		else if(t==1)
		{
			soundType="mid";
			soundRes="midi";
		}
		else if(t==2)
		{
			soundType="wav";
			soundRes="x-wav";
		}
	}

}