
import javax.microedition.rms.*;

public final class Record
{
	private	RecordStore	store;
	String	strRecordName;

    public	Record(String strRecordName)
    {
    	this.strRecordName	= strRecordName;
    }

	public	boolean saveRecord(int iRecordID, byte[] data)
	{
		int i;

		//Open
		try
		{
			store = RecordStore.openRecordStore(strRecordName, true);
		}
		catch(RecordStoreException ex){}

		if( store == null )
			return false;

		try
		{
			if( iRecordID > store.getNumRecords() )
			{
				int id	= store.addRecord( data, 0, data.length );
			}
			else
			{
				for( i=1; i<=store.getNumRecords(); i++ )
				{
					if( i == iRecordID )
						store.setRecord( i, data, 0, data.length );
				}
			}
		}
		catch(RecordStoreException ex){}

		try
		{
			if( store != null )
				store.closeRecordStore();
		}
		catch(RecordStoreException ex)
		{
			ex.printStackTrace();
		}
		return true;
	}

	public	byte[] loadRecord(int iRecordID)
	{
		int i;
		boolean	bHasData	= false;

		//Open
		try
		{
			store = RecordStore.openRecordStore(strRecordName, false);
		}
		catch(RecordStoreException ex){}

		if( store == null )
			return null;

		byte[] data	= null;

		try
		{
			for( i=1; i<=store.getNumRecords(); i++ )
			{
				if( i == iRecordID )
				{
					data		= store.getRecord(i);
					bHasData	= true;
				}
			}
		}
		catch(RecordStoreException ex){}

		// close
		try
		{
			if( store != null )
				store.closeRecordStore();
		}
		catch(RecordStoreException ex)
		{
			ex.printStackTrace();
		}

		if( bHasData )
			return data;
		return null;
	}
}