public final class Environment
{
	public static final int SCREEN_WIDTH				=	176;
	public static final int SCREEN_HEIGHT				=	205;
	public static final int COMMAND_LEFT				=	0;
	public static final int COMMAND_RIGHT				=	1;
	
	public static int getGameKey( int iKeyValue )
	{
		switch( iKeyValue )
		{
			case 1:
			case -1:	// ARROW_UP			
			return	Constant.KEY_UP;
			
			case 50:	// NUM_2
			return	Constant.KEY_NUM_2;
			
			case 6:
			case -6:	// ARROW_DOWN	
			return	Constant.KEY_DOWN;
			
			case 56:	// NUM_2
			return	Constant.KEY_NUM_8;
			
			case 5:
			case -5:
			case -4:	// ARROW_RIGHT		
			return	Constant.KEY_RIGHT;
						
			case 54:	// NUM_6
			return	Constant.KEY_NUM_6;
			
			case -2:
			case 2:	// ARROW_LEFT
			return	Constant.KEY_LEFT;
			
			case 52:	// NUM_4
			return	Constant.KEY_NUM_4;
			
			case 22:
			case -22:
			case -7:	// SOFT_LEFT
			return	Constant.KEY_OK;
			
			case 21:
			case -21: // SOFT_RIGHT
			return	Constant.KEY_CANCEL;
			
			case 20:
			case -20:	// CENTER
			case 53:	// NUM_5
				if( FrameWork.frameState == Constant.STATE_GAMEMAIN ||						
						FrameWork.frameState == Constant.STATE_GAMEPAUSE )
						return Constant.KEY_FIRE;
				else	return Constant.KEY_OK;
				
//			case 53:	// NUM_5			
//			return Constant.KEY_FIRE;
			
			case 35:	// NUM_3
			return Constant.KEY_WELL;
								
			case 42:	// NUM_1
			return Constant.KEY_STAR;			
								
			default:
			return	iKeyValue;
		}
	}
	
	public static int getCommandAnchor( int id )
	{
		if( id == Constant.COMMAND_OK )
			return	COMMAND_RIGHT;
		else if( id == Constant.COMMAND_BACK ) 
			return	COMMAND_LEFT;
			
		return 100 ;
	}
}
